import { Construct } from 'constructs';
import { AttiniTask } from './attini-task';
/**
 * The AttiniRunnerJob is a quick and cost-efficient way to run shell commands using a container.
 */
export declare class AttiniRunnerJob extends AttiniTask {
    private props;
    type: string;
    constructor(scope: Construct, id: string, props: AttiniRunnerJobProps);
    protected renderProps(): object;
}
export interface AttiniRunnerJobProps {
    /**
     * A reference to an {@link AttiniRunner} to use for executing the job.
     * Use {@link AttiniRunner.runnerName} to get a reference.
     *
     * If omitted the Attini default runner will be used.
     */
    readonly runner?: string;
    /**
     * A list of shell commands that will be executed by the Runner.
     */
    readonly commands: Array<string>;
}
