"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AttiniImport = exports.SourceType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_stepfunctions_1 = require("aws-cdk-lib/aws-stepfunctions");
const attini_task_1 = require("./attini-task");
const index_1 = require("./index");
var SourceType;
(function (SourceType) {
    SourceType[SourceType["S3_SOURCE"] = 0] = "S3_SOURCE";
    SourceType[SourceType["DISTRIBUTION_SOURCE"] = 1] = "DISTRIBUTION_SOURCE";
})(SourceType = exports.SourceType || (exports.SourceType = {}));
/**
 * The Attini import step can be used for importing data from different sources.
 * A common use case for this type is reading data from the output of another distribution.
 * For example, you could have a distribution responsible for setting up a network that exposes a VPC-id.
 * Then the VPC-id can be imported by other deployment plans.
 */
class AttiniImport extends attini_task_1.AttiniTask {
    constructor(scope, id, props) {
        super(scope, id);
        this.props = props;
        this.type = 'AttiniImport';
        if (this.props.sourceType.valueOf() === SourceType.S3_SOURCE.valueOf() && !this.props.s3Source) {
            throw new Error('S3 source is set as type for Attini import step but no S3 source is configured, id =' + id);
        }
        if (this.props.sourceType.valueOf() === SourceType.DISTRIBUTION_SOURCE.valueOf() && !this.props.distributionSource) {
            throw new Error('Distribution source is set as type for Attini import step but no distribution source is configured, id: ' + id);
        }
    }
    renderProps() {
        let properties = {};
        if (this.props.sourceType.valueOf() === SourceType.S3_SOURCE.valueOf()) {
            properties.SourceType = 'S3';
            properties.Source = index_1.PropsUtil.fixCase(this.props.s3Source);
        }
        else {
            properties.SourceType = 'Distribution';
            properties.Source = index_1.PropsUtil.fixCase(this.props.distributionSource);
        }
        if (this.props.mapping) {
            properties.Mapping = this.props.mapping;
        }
        if (this.props.executionRoleArn) {
            properties.ExecutionRoleArn = this.props.executionRoleArn;
        }
        return {
            Properties: aws_stepfunctions_1.FieldUtils.renderObject(properties),
        };
    }
}
exports.AttiniImport = AttiniImport;
_a = JSII_RTTI_SYMBOL_1;
AttiniImport[_a] = { fqn: "@attini/cdk.AttiniImport", version: "0.0.47" };
//# sourceMappingURL=data:application/json;base64,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