"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AttiniCfn = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_stepfunctions_1 = require("aws-cdk-lib/aws-stepfunctions");
const attini_task_1 = require("./attini-task");
const index_1 = require("./index");
class AttiniCfn extends attini_task_1.AttiniTask {
    constructor(scope, id, props) {
        super(scope, id);
        this.props = props;
        this.type = 'AttiniCfn';
    }
    renderProps() {
        let copy = { ...this.props };
        if (this.props.action && this.props.action.valueOf() === index_1.CfnAction.DEPLOY.valueOf()) {
            copy.action = 'Deploy';
        }
        else if (this.props.action && this.props.action.valueOf() === index_1.CfnAction.DELETE.valueOf()) {
            copy.action = 'Delete';
        }
        return {
            Properties: aws_stepfunctions_1.FieldUtils.renderObject(index_1.PropsUtil.fixCase(copy)),
        };
    }
}
exports.AttiniCfn = AttiniCfn;
_a = JSII_RTTI_SYMBOL_1;
AttiniCfn[_a] = { fqn: "@attini/cdk.AttiniCfn", version: "0.0.47" };
//# sourceMappingURL=data:application/json;base64,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