![BidFX-API-Python](https://user-images.githubusercontent.com/2197551/76171801-35d74100-6187-11ea-8cc5-7f29b66d00ea.png)

# BidFX Public API for Python

[![Release](https://img.shields.io/pypi/v/bidfx-api)](https://pypi.org/project/bidfx-api)
[![Status](https://img.shields.io/pypi/status/bidfx-api)](https://pypi.org/project/bidfx-api)
[![License](https://img.shields.io/badge/license-Apache%202-4EB1BA.svg)](https://www.apache.org/licenses/LICENSE-2.0.html)
[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)
[![ReadTheDocs](https://img.shields.io/readthedocs/bidfx-api-py)](https://readthedocs.org/projects/bidfx-api-py)

-------

## Features

The BidFX Python API is a *pricing* and *trading* API that connects to
the BidFX platform to subscribe to realtime pricing and to place orders.
The API supports:

 - FX request for stream (RFS) pricing
 - FX request for quote (RFQ) pricing
 - FX and Futures trading via
    [REST](https://en.wikipedia.org/wiki/Representational_state_transfer) or 
    [WebSockets](https://en.wikipedia.org/wiki/WebSocket).


## Quick start

### Installation

```sh
pip install bidfx-api
```

### API docs

Read the documentation on [Read The Docs](https://bidfx-api-py.readthedocs.io).


## Python version

The API is compatible with Python 3.6 and greater.
If you do not have Python, please install the latest 3.x version from [python.org](https://python.org) 
or refer to the [Installing Python](http://docs.python-guide.org/en/latest/starting/installation/) section 
of the Hitchhiker’s Guide to Python.


## Alternative APIs

If you prefer not to code in Python, you can read about the complete BidFX API range, and their different capabilities,
at [BidFX API Overview](https://www.bidfx.com/apis).
