## Making packages

### Adjust version number

emacs setup.py

git status
git add setup.py
git commit -m "bump version"
git push origin master

### Creating requirements file for automatic installation

To create `requirements.txt` first install Kinetics software in a new
virtual environment and make sure that the software works as it
should.  Then use `pip` to create `requirements.txt`:

```
python -m venv install-test
install-test/bin/pip install .
install-test/bin/pip freeze | grep -v iocbio > requirements.txt
echo iocbio.db >> requirements.txt
```

After that, `requirements.txt` should not contain `iocbio.kinetics` and have
`iocbio.db` without version. Update the file in the repository.

### PyPi

For making source package, run

```
python3 setup.py sdist
```

For upload to PyPI:

```
twine upload dist/iocbio.kinetics-1.0.0.tar.gz
```

### Make release at Gitlab

Go to https://gitlab.com/iocbio/kinetics/tags and make a new release
with Changelog


### Windows executable

Windows executable as generated by PyInstaller through Gitlab CI. It
is automatically uploaded into our server, just a link has to be added
to the release notes.