"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EvaluateExpression = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const iam = require("@aws-cdk/aws-iam");
const lambda = require("@aws-cdk/aws-lambda");
const sfn = require("@aws-cdk/aws-stepfunctions");
/**
 * A Step Functions Task to evaluate an expression
 *
 * OUTPUT: the output of this task is the evaluated expression.
 *
 */
class EvaluateExpression extends sfn.TaskStateBase {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_tasks_EvaluateExpressionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, EvaluateExpression);
            }
            throw error;
        }
        this.evalFn = createEvalFn(this.props.runtime ?? lambda.Runtime.NODEJS_14_X, this);
        this.taskPolicies = [
            new iam.PolicyStatement({
                resources: this.evalFn.resourceArnsForGrantInvoke,
                actions: ['lambda:InvokeFunction'],
            }),
        ];
    }
    /**
     * @internal
     */
    _renderTask() {
        const matches = this.props.expression.match(/\$[.\[][.a-zA-Z[\]0-9-_]+/g);
        let expressionAttributeValues = {};
        if (matches) {
            expressionAttributeValues = matches.reduce((acc, m) => ({
                ...acc,
                [m]: sfn.JsonPath.stringAt(m),
            }), {});
        }
        const parameters = {
            expression: this.props.expression,
            expressionAttributeValues,
        };
        return {
            Resource: this.evalFn.functionArn,
            Parameters: sfn.FieldUtils.renderObject(parameters),
        };
    }
}
exports.EvaluateExpression = EvaluateExpression;
_a = JSII_RTTI_SYMBOL_1;
EvaluateExpression[_a] = { fqn: "@aws-cdk/aws-stepfunctions-tasks.EvaluateExpression", version: "1.194.0" };
function createEvalFn(runtime, scope) {
    const lambdaPurpose = 'Eval';
    const nodeJsGuids = {
        [lambda.Runtime.NODEJS_14_X.name]: 'da2d1181-604e-4a45-8694-1a6abd7fe42d',
        [lambda.Runtime.NODEJS_14_X.name]: '2b81e383-aad2-44db-8aaf-b4809ae0e3b4',
        [lambda.Runtime.NODEJS_10_X.name]: 'a0d2ce44-871b-4e74-87a1-f5e63d7c3bdc',
    };
    switch (runtime) {
        case lambda.Runtime.NODEJS_14_X:
        case lambda.Runtime.NODEJS_14_X:
        case lambda.Runtime.NODEJS_10_X:
            const uuid = nodeJsGuids[runtime.name];
            if (uuid) {
                return new lambda.SingletonFunction(scope, 'EvalFunction', {
                    runtime,
                    uuid,
                    handler: 'index.handler',
                    lambdaPurpose,
                    code: lambda.Code.fromAsset(path.join(__dirname, 'eval-nodejs-handler'), {
                        exclude: ['*.ts'],
                    }),
                });
            }
            break;
    }
    throw new Error(`The runtime ${runtime.name} is currently not supported.`);
}
//# sourceMappingURL=data:application/json;base64,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