from ........Internal.Core import Core
from ........Internal.CommandsGroup import CommandsGroup
from ........Internal import Conversions
from ........ import repcap


# noinspection PyPep8Naming,PyAttributeOutsideInit,SpellCheckingInspection
class NstatesCls:
	"""Nstates commands group definition. 1 total commands, 0 Subgroups, 1 group commands"""

	def __init__(self, core: Core, parent):
		self._core = core
		self._cmd_group = CommandsGroup("nstates", core, parent)

	def get(self, window=repcap.Window.Default) -> int:
		"""SCPI: CALCulate<n>:HOPDetection:STATes:TABLe:NSTates \n
		Snippet: value: int = driver.applications.k60Transient.calculate.hopDetection.states.table.nstates.get(window = repcap.Window.Default) \n
		This command queries the number of hop states to be generated by a subsequent method RsFsw.Applications.K60_Transient.
		Calculate.HopDetection.States.Table.Add.set or method RsFsw.Applications.K60_Transient.Calculate.HopDetection.States.
		Table.Replace.set command. \n
			:param window: optional repeated capability selector. Default value: Nr1 (settable in the interface 'Calculate')
			:return: no_of_states: Range: 0 to 1000"""
		window_cmd_val = self._cmd_group.get_repcap_cmd_value(window, repcap.Window)
		response = self._core.io.query_str(f'CALCulate{window_cmd_val}:HOPDetection:STATes:TABLe:NSTates?')
		return Conversions.str_to_int(response)
