from ......Internal.Core import Core
from ......Internal.CommandsGroup import CommandsGroup
from ......Internal import Conversions


# noinspection PyPep8Naming,PyAttributeOutsideInit,SpellCheckingInspection
class RremoveCls:
	"""Rremove commands group definition. 1 total commands, 0 Subgroups, 1 group commands"""

	def __init__(self, core: Core, parent):
		self._core = core
		self._cmd_group = CommandsGroup("rremove", core, parent)

	def set(self, state: bool) -> None:
		"""SCPI: [SENSe]:SSEarch:RREMove \n
		Snippet: driver.applications.k50Spurious.sense.ssearch.rremove.set(state = False) \n
		If enabled, residual spurs, which are generated by internal components in the R&S FSW itself, are not included in the
		spur results. Note, however, if a residual spur coincides with a 'true' spur, the spur is also removed. \n
			:param state: ON | OFF | 0 | 1 OFF | 0 Residuals are not removed ON | 1 Residuals are removed
		"""
		param = Conversions.bool_to_str(state)
		self._core.io.write(f'SENSe:SSEarch:RREMove {param}')

	def get(self) -> bool:
		"""SCPI: [SENSe]:SSEarch:RREMove \n
		Snippet: value: bool = driver.applications.k50Spurious.sense.ssearch.rremove.get() \n
		If enabled, residual spurs, which are generated by internal components in the R&S FSW itself, are not included in the
		spur results. Note, however, if a residual spur coincides with a 'true' spur, the spur is also removed. \n
			:return: state: ON | OFF | 0 | 1 OFF | 0 Residuals are not removed ON | 1 Residuals are removed"""
		response = self._core.io.query_str(f'SENSe:SSEarch:RREMove?')
		return Conversions.str_to_bool(response)
