from ......Internal.Core import Core
from ......Internal.CommandsGroup import CommandsGroup
from ......Internal import Conversions
from ......Internal.Utilities import trim_str_response


# noinspection PyPep8Naming,PyAttributeOutsideInit,SpellCheckingInspection
class FnameCls:
	"""Fname commands group definition. 1 total commands, 0 Subgroups, 1 group commands"""

	def __init__(self, core: Core, parent):
		self._core = core
		self._cmd_group = CommandsGroup("fname", core, parent)

	def set(self, filename: str) -> None:
		"""SCPI: CONFigure:DDPD:FNAMe \n
		Snippet: driver.applications.k18AmplifierEt.configure.ddpd.fname.set(filename = '1') \n
		This command defines a file name for the I/Q file that contains the predistorted I/Q data that was generated by the
		direct DPD.
			INTRO_CMD_HELP: Prerequisites for this command \n
			- Turn on direct DPD (method RsFsw.Applications.K18_AmplifierEt.Configure.Ddpd.State.set) . \n
			:param filename: String containing the file name (including file type .wv) .
		"""
		param = Conversions.value_to_quoted_str(filename)
		self._core.io.write(f'CONFigure:DDPD:FNAMe {param}')

	def get(self) -> str:
		"""SCPI: CONFigure:DDPD:FNAMe \n
		Snippet: value: str = driver.applications.k18AmplifierEt.configure.ddpd.fname.get() \n
		This command defines a file name for the I/Q file that contains the predistorted I/Q data that was generated by the
		direct DPD.
			INTRO_CMD_HELP: Prerequisites for this command \n
			- Turn on direct DPD (method RsFsw.Applications.K18_AmplifierEt.Configure.Ddpd.State.set) . \n
			:return: filename: String containing the file name (including file type .wv) ."""
		response = self._core.io.query_str(f'CONFigure:DDPD:FNAMe?')
		return trim_str_response(response)
