from .......Internal.Core import Core
from .......Internal.CommandsGroup import CommandsGroup


# noinspection PyPep8Naming,PyAttributeOutsideInit,SpellCheckingInspection
class AtimingCls:
	"""Atiming commands group definition. 1 total commands, 0 Subgroups, 1 group commands"""

	def __init__(self, core: Core, parent):
		self._core = core
		self._cmd_group = CommandsGroup("atiming", core, parent)

	def set(self) -> None:
		"""SCPI: [SENSe]:NR5G:OOPower:ATIMing \n
		Snippet: driver.applications.k14Xnr5G.sense.nr5G.ooPower.atiming.set() \n
		This command adjusts the timing for on / off power measurements. \n
		"""
		self._core.io.write(f'SENSe:NR5G:OOPower:ATIMing')

	def set_with_opc(self, opc_timeout_ms: int = -1) -> None:
		"""SCPI: [SENSe]:NR5G:OOPower:ATIMing \n
		Snippet: driver.applications.k14Xnr5G.sense.nr5G.ooPower.atiming.set_with_opc() \n
		This command adjusts the timing for on / off power measurements. \n
		Same as set, but waits for the operation to complete before continuing further. Use the RsFsw.utilities.opc_timeout_set() to set the timeout value. \n
			:param opc_timeout_ms: Maximum time to wait in milliseconds, valid only for this call."""
		self._core.io.write_with_opc(f'SENSe:NR5G:OOPower:ATIMing', opc_timeout_ms)
