from .......Internal.Core import Core
from .......Internal.CommandsGroup import CommandsGroup


# noinspection PyPep8Naming,PyAttributeOutsideInit,SpellCheckingInspection
class DownlinkCls:
	"""Downlink commands group definition. 92 total commands, 5 Subgroups, 0 group commands"""

	def __init__(self, core: Core, parent):
		self._core = core
		self._cmd_group = CommandsGroup("downlink", core, parent)

	@property
	def cc(self):
		"""cc commands group. 26 Sub-classes, 0 commands."""
		if not hasattr(self, '_cc'):
			from .Cc import CcCls
			self._cc = CcCls(self._core, self._cmd_group)
		return self._cc

	@property
	def pindex(self):
		"""pindex commands group. 0 Sub-classes, 1 commands."""
		if not hasattr(self, '_pindex'):
			from .Pindex import PindexCls
			self._pindex = PindexCls(self._core, self._cmd_group)
		return self._pindex

	@property
	def sinfo(self):
		"""sinfo commands group. 0 Sub-classes, 1 commands."""
		if not hasattr(self, '_sinfo'):
			from .Sinfo import SinfoCls
			self._sinfo = SinfoCls(self._core, self._cmd_group)
		return self._sinfo

	@property
	def npdsch(self):
		"""npdsch commands group. 3 Sub-classes, 0 commands."""
		if not hasattr(self, '_npdsch'):
			from .Npdsch import NpdschCls
			self._npdsch = NpdschCls(self._core, self._cmd_group)
		return self._npdsch

	@property
	def frequency(self):
		"""frequency commands group. 2 Sub-classes, 0 commands."""
		if not hasattr(self, '_frequency'):
			from .Frequency import FrequencyCls
			self._frequency = FrequencyCls(self._core, self._cmd_group)
		return self._frequency

	def clone(self) -> 'DownlinkCls':
		"""Clones the group by creating new object from it and its whole existing subgroups
		Also copies all the existing default Repeated Capabilities setting,
		which you can change independently without affecting the original group"""
		new_group = DownlinkCls(self._core, self._cmd_group.parent)
		self._cmd_group.synchronize_repcaps(new_group)
		return new_group
