from .........Internal.Core import Core
from .........Internal.CommandsGroup import CommandsGroup


# noinspection PyPep8Naming,PyAttributeOutsideInit,SpellCheckingInspection
class PhichCls:
	"""Phich commands group definition. 5 total commands, 5 Subgroups, 0 group commands"""

	def __init__(self, core: Core, parent):
		self._core = core
		self._cmd_group = CommandsGroup("phich", core, parent)

	@property
	def duration(self):
		"""duration commands group. 0 Sub-classes, 1 commands."""
		if not hasattr(self, '_duration'):
			from .Duration import DurationCls
			self._duration = DurationCls(self._core, self._cmd_group)
		return self._duration

	@property
	def mitm(self):
		"""mitm commands group. 0 Sub-classes, 1 commands."""
		if not hasattr(self, '_mitm'):
			from .Mitm import MitmCls
			self._mitm = MitmCls(self._core, self._cmd_group)
		return self._mitm

	@property
	def ngParameter(self):
		"""ngParameter commands group. 0 Sub-classes, 1 commands."""
		if not hasattr(self, '_ngParameter'):
			from .NgParameter import NgParameterCls
			self._ngParameter = NgParameterCls(self._core, self._cmd_group)
		return self._ngParameter

	@property
	def noGroups(self):
		"""noGroups commands group. 0 Sub-classes, 1 commands."""
		if not hasattr(self, '_noGroups'):
			from .NoGroups import NoGroupsCls
			self._noGroups = NoGroupsCls(self._core, self._cmd_group)
		return self._noGroups

	@property
	def power(self):
		"""power commands group. 0 Sub-classes, 1 commands."""
		if not hasattr(self, '_power'):
			from .Power import PowerCls
			self._power = PowerCls(self._core, self._cmd_group)
		return self._power

	def clone(self) -> 'PhichCls':
		"""Clones the group by creating new object from it and its whole existing subgroups
		Also copies all the existing default Repeated Capabilities setting,
		which you can change independently without affecting the original group"""
		new_group = PhichCls(self._core, self._cmd_group.parent)
		self._cmd_group.synchronize_repcaps(new_group)
		return new_group
