"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Account = exports.AccountProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const gpdb_generated_1 = require("./gpdb.generated");
Object.defineProperty(exports, "AccountProperty", { enumerable: true, get: function () { return gpdb_generated_1.RosAccount; } });
/**
 * A ROS resource type:  `ALIYUN::GPDB::Account`
 */
class Account extends ros.Resource {
    /**
     * Create a new `ALIYUN::GPDB::Account`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosAccount = new gpdb_generated_1.RosAccount(this, id, {
            accountDescription: props.accountDescription,
            dbInstanceId: props.dbInstanceId,
            accountPassword: props.accountPassword,
            accountName: props.accountName,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosAccount;
        this.attrAccountName = rosAccount.attrAccountName;
        this.attrDbInstanceId = rosAccount.attrDbInstanceId;
    }
}
exports.Account = Account;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYWNjb3VudC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImFjY291bnQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsOENBQThDO0FBQzlDLHFEQUE4QztBQUV2QixnR0FGZCwyQkFBVSxPQUVtQjtBQXNDdEM7O0dBRUc7QUFDSCxNQUFhLE9BQVEsU0FBUSxHQUFHLENBQUMsUUFBUTtJQWlCckM7Ozs7OztPQU1HO0lBQ0gsWUFBWSxLQUFvQixFQUFFLEVBQVUsRUFBRSxLQUFtQixFQUFFLG1DQUEyQyxJQUFJO1FBQzlHLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFFakIsTUFBTSxVQUFVLEdBQUcsSUFBSSwyQkFBVSxDQUFDLElBQUksRUFBRSxFQUFFLEVBQUc7WUFDekMsa0JBQWtCLEVBQUUsS0FBSyxDQUFDLGtCQUFrQjtZQUM1QyxZQUFZLEVBQUUsS0FBSyxDQUFDLFlBQVk7WUFDaEMsZUFBZSxFQUFFLEtBQUssQ0FBQyxlQUFlO1lBQ3RDLFdBQVcsRUFBRSxLQUFLLENBQUMsV0FBVztTQUNqQyxFQUFFLGdDQUFnQyxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsZ0NBQWdDLENBQUMsQ0FBQztRQUNwRixJQUFJLENBQUMsUUFBUSxHQUFHLFVBQVUsQ0FBQztRQUMzQixJQUFJLENBQUMsZUFBZSxHQUFHLFVBQVUsQ0FBQyxlQUFlLENBQUM7UUFDbEQsSUFBSSxDQUFDLGdCQUFnQixHQUFHLFVBQVUsQ0FBQyxnQkFBZ0IsQ0FBQztJQUN4RCxDQUFDO0NBQ0o7QUFyQ0QsMEJBcUNDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgcm9zIGZyb20gJ0BhbGljbG91ZC9yb3MtY2RrLWNvcmUnO1xuaW1wb3J0IHsgUm9zQWNjb3VudCB9IGZyb20gJy4vZ3BkYi5nZW5lcmF0ZWQnO1xuLy8gR2VuZXJhdGVkIGZyb20gdGhlIEFsaUNsb3VkIFJPUyBSZXNvdXJjZSBTcGVjaWZpY2F0aW9uXG5leHBvcnQgeyBSb3NBY2NvdW50IGFzIEFjY291bnRQcm9wZXJ0eSB9O1xuXG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIGRlZmluaW5nIGEgYEFMSVlVTjo6R1BEQjo6QWNjb3VudGBcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBBY2NvdW50UHJvcHMge1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgYWNjb3VudE5hbWU6IFRoZSBuYW1lIG9mIHRoZSBwcml2aWxlZ2VkIGFjY291bnQuXG4gICAgICogVGhlIG5hbWUgY2FuIGNvbnRhaW4gbG93ZXJjYXNlIGxldHRlcnMsIGRpZ2l0cywgYW5kIHVuZGVyc2NvcmVzIChfKS5cbiAgICAgKiBUaGUgbmFtZSBtdXN0IHN0YXJ0IHdpdGggYSBsb3dlcmNhc2UgbGV0dGVyIGFuZCBlbmQgd2l0aCBhIGxvd2VyY2FzZSBsZXR0ZXIgb3IgYSBkaWdpdC5cbiAgICAgKiBUaGUgbmFtZSBjYW5ub3Qgc3RhcnQgd2l0aCBncC5cbiAgICAgKiBUaGUgbmFtZSBtdXN0IGJlIDIgdG8gMTYgY2hhcmFjdGVycyBpbiBsZW5ndGguXG4gICAgICovXG4gICAgcmVhZG9ubHkgYWNjb3VudE5hbWU6IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IGFjY291bnRQYXNzd29yZDogVGhlIHBhc3N3b3JkIG9mIHRoZSBwcml2aWxlZ2VkIGFjY291bnQuXG4gICAgICogVGhlIHBhc3N3b3JkIG11c3QgY29udGFpbiBhdCBsZWFzdCB0aHJlZSBvZiB0aGUgZm9sbG93aW5nIGNoYXJhY3RlciB0eXBlczogdXBwZXJjYXNlXG4gICAgICogbGV0dGVycywgbG93ZXJjYXNlIGxldHRlcnMsIGRpZ2l0cywgYW5kIHNwZWNpYWwgY2hhcmFjdGVycy5cbiAgICAgKiBTcGVjaWFsIGNoYXJhY3RlcnMgaW5jbHVkZSAhIEAgIyAkICUgXiAmICogKCApIF8gKyAtID1cbiAgICAgKiBUaGUgcGFzc3dvcmQgbXVzdCBiZSA4IHRvIDMyIGNoYXJhY3RlcnMgaW4gbGVuZ3RoLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGFjY291bnRQYXNzd29yZDogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgZGJJbnN0YW5jZUlkOiBUaGUgSUQgb2YgdGhlIGluc3RhbmNlLlxuICAgICAqIE5vdGUgWW91IGNhbiBjYWxsIHRoZSBEZXNjcmliZURCSW5zdGFuY2VzIG9wZXJhdGlvbiB0byBxdWVyeSBkZXRhaWxzIG9mIGFsbCBBbmFseXRpY0RCIGZvciBQb3N0Z3JlU1FMIGluc3RhbmNlcyBpbiBhIHNwZWNpZmljXG4gICAgICogcmVnaW9uLCBpbmNsdWRpbmcgaW5zdGFuY2UgSURzLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGRiSW5zdGFuY2VJZDogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgYWNjb3VudERlc2NyaXB0aW9uOiBUaGUgZGVzY3JpcHRpb24gb2YgdGhlIHByaXZpbGVnZWQgYWNjb3VudC5cbiAgICAgKi9cbiAgICByZWFkb25seSBhY2NvdW50RGVzY3JpcHRpb24/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG59XG5cbi8qKlxuICogQSBST1MgcmVzb3VyY2UgdHlwZTogIGBBTElZVU46OkdQREI6OkFjY291bnRgXG4gKi9cbmV4cG9ydCBjbGFzcyBBY2NvdW50IGV4dGVuZHMgcm9zLlJlc291cmNlIHtcblxuICAgIC8qKlxuICAgICAqIEEgZmFjdG9yeSBtZXRob2QgdGhhdCBjcmVhdGVzIGEgbmV3IGluc3RhbmNlIG9mIHRoaXMgY2xhc3MgZnJvbSBhbiBvYmplY3RcbiAgICAgKiBjb250YWluaW5nIHRoZSBwcm9wZXJ0aWVzIG9mIHRoaXMgUk9TIHJlc291cmNlLCB3aGljaCB3aWxsIGJlIGFzc2lnbmVkIHRvIFJPUyByZXNvdXJjZS5cbiAgICAgKi9cblxuICAgIC8qKlxuICAgICAqIEF0dHJpYnV0ZSBBY2NvdW50TmFtZTogVGhlIG5hbWUgb2YgdGhlIGFjY291bnQuXG4gICAgICovXG4gICAgcHVibGljIHJlYWRvbmx5IGF0dHJBY2NvdW50TmFtZTogcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQXR0cmlidXRlIERCSW5zdGFuY2VJZDogVGhlIElEIG9mIHRoZSBpbnN0YW5jZS5cbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0ckRiSW5zdGFuY2VJZDogcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQ3JlYXRlIGEgbmV3IGBBTElZVU46OkdQREI6OkFjY291bnRgLlxuICAgICAqXG4gICAgICogUGFyYW0gc2NvcGUgLSBzY29wZSBpbiB3aGljaCB0aGlzIHJlc291cmNlIGlzIGRlZmluZWRcbiAgICAgKiBQYXJhbSBpZCAgICAtIHNjb3BlZCBpZCBvZiB0aGUgcmVzb3VyY2VcbiAgICAgKiBQYXJhbSBwcm9wcyAtIHJlc291cmNlIHByb3BlcnRpZXNcbiAgICAgKi9cbiAgICBjb25zdHJ1Y3RvcihzY29wZTogcm9zLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IEFjY291bnRQcm9wcywgZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQ6Ym9vbGVhbiA9IHRydWUpIHtcbiAgICAgICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgICAgICBjb25zdCByb3NBY2NvdW50ID0gbmV3IFJvc0FjY291bnQodGhpcywgaWQsICB7XG4gICAgICAgICAgICBhY2NvdW50RGVzY3JpcHRpb246IHByb3BzLmFjY291bnREZXNjcmlwdGlvbixcbiAgICAgICAgICAgIGRiSW5zdGFuY2VJZDogcHJvcHMuZGJJbnN0YW5jZUlkLFxuICAgICAgICAgICAgYWNjb3VudFBhc3N3b3JkOiBwcm9wcy5hY2NvdW50UGFzc3dvcmQsXG4gICAgICAgICAgICBhY2NvdW50TmFtZTogcHJvcHMuYWNjb3VudE5hbWUsXG4gICAgICAgIH0sIGVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50ICYmIHRoaXMuc3RhY2suZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQpO1xuICAgICAgICB0aGlzLnJlc291cmNlID0gcm9zQWNjb3VudDtcbiAgICAgICAgdGhpcy5hdHRyQWNjb3VudE5hbWUgPSByb3NBY2NvdW50LmF0dHJBY2NvdW50TmFtZTtcbiAgICAgICAgdGhpcy5hdHRyRGJJbnN0YW5jZUlkID0gcm9zQWNjb3VudC5hdHRyRGJJbnN0YW5jZUlkO1xuICAgIH1cbn1cbiJdfQ==