# SpectroscPy 0.1.0
# SpectroscPy is a script package developed by and containing contributions from

    # Karen Oda Hjorth Dundas
    # Magnus Ringholm
    # Yann Cornation
    # Benedicte Ofstad

# The package is released under a LGPL licence.
# For questions, please contact on karen.o.dundas@uit.no

# The modules transform_nc_to_nm and vib_analysis are both to a certain extent derived from similar 
# or corresponding functionality in Dalton, perhaps mainly so for the former.  For questions about
# this, please contact Magnus Ringholm or Benedicte Ofstad.
# Thanks also to Per-Olof Åstrand on these routines

from spectroscpy import get_vib_harm_freqs_and_eigvecs, project_out_transl_and_rot, read_mol, \
                        mol_is_linear, get_vibrational_w
import pytest
import os
import numpy as np

hess = \
        [[ 5.72272693e-01,  2.09891223e-02,  1.42620281e-01, -8.53002216e-04, \
           1.62644871e-03,  3.08362650e-03,  1.85906832e-02, -8.77288621e-05, \
           1.76147642e-02, -5.90010374e-01, -2.25278414e-02, -1.63318673e-01], \
         [ 2.09891223e-02,  1.57315245e-03,  4.18465590e-03, -1.38197401e-03, \
          -9.93838006e-04, -3.75709216e-03,  1.07388195e-03, -1.13168952e-03, \
           1.04284790e-02, -2.06810307e-02,  5.52375178e-04, -1.08560413e-02], \
         [ 1.42620281e-01,  4.18465590e-03,  1.40142218e-01, -1.69722346e-03, \
           4.54609392e-03, -9.00637321e-03, -6.49535982e-02, -1.07097629e-02, \
          -3.47816097e-02, -7.59694602e-02,  1.97901364e-03, -9.63542348e-02], \
         [-8.53002216e-04, -1.38197401e-03, -1.69722346e-03,  1.63390525e-01, \
           2.58122688e-01,  7.49587843e-02, -1.66811534e-01, -2.66168848e-01, \
          -9.11324251e-02,  4.27401244e-03,  9.42813330e-03,  1.78708637e-02], \
         [ 1.62644871e-03, -9.93838006e-04,  4.54609392e-03,  2.58122688e-01, \
           4.10598983e-01,  1.21159300e-01, -2.67929965e-01, -4.22765680e-01, \
          -1.35670866e-01,  8.18082769e-03,  1.31605355e-02,  9.96547123e-03], \
         [ 3.08362650e-03, -3.75709216e-03, -9.00637321e-03,  7.49587843e-02, \
           1.21159300e-01,  1.40000986e-01, -3.62006904e-02, -6.65516376e-02, \
          -9.62373492e-02, -4.18417197e-02, -5.08505693e-02, -3.47572633e-02], \
         [ 1.85906832e-02,  1.07388195e-03, -6.49535982e-02, -1.66811534e-01, \
          -2.67929965e-01, -3.62006904e-02,  2.35852242e-01,  3.02735035e-01, \
           4.07856829e-02, -8.76313922e-02, -3.58789533e-02,  6.03686070e-02], \
         [-8.77288621e-05, -1.13168952e-03, -1.07097629e-02, -2.66168848e-01, \
          -4.22765680e-01, -6.65516376e-02,  3.02735035e-01,  4.69493162e-01, \
           7.48062239e-02, -3.64784572e-02, -4.55957919e-02,  2.45517660e-03], \
         [ 1.76147642e-02,  1.04284790e-02, -3.47816097e-02, -9.11324251e-02, \
          -1.35670866e-01, -9.62373492e-02,  4.07856829e-02,  7.48062239e-02, \
           7.65821431e-01,  3.27319770e-02,  5.04361628e-02, -6.34802472e-01], \
         [-5.90010374e-01, -2.06810307e-02, -7.59694602e-02,  4.27401244e-03, \
           8.18082769e-03, -4.18417197e-02, -8.76313922e-02, -3.64784572e-02, \
           3.27319770e-02,  6.73367753e-01,  4.89786614e-02,  8.50792020e-02], \
         [-2.25278414e-02,  5.52375178e-04,  1.97901364e-03,  9.42813330e-03, \
           1.31605355e-02, -5.08505693e-02, -3.58789533e-02, -4.55957919e-02, \
           5.04361628e-02,  4.89786614e-02,  3.18828813e-02, -1.56460654e-03], \
         [-1.63318673e-01, -1.08560413e-02, -9.63542348e-02,  1.78708637e-02, \
           9.96547123e-03, -3.47572633e-02,  6.03686070e-02,  2.45517660e-03, \
          -6.34802472e-01,  8.50792020e-02, -1.56460654e-03,  7.65913970e-01]]

def test_mol_is_linear():

    coordinates = [[1.69509813, -0.01831334, 1.84778681], [-0.83741626, -1.47927283, -1.84733382], \
                   [0.12223015, 0.06073168, -1.31223], [-0.11825048, -0.07620551, 1.31178901]]

    is_linear = mol_is_linear(coordinates)

    assert 0 == is_linear

    coordinates = [[-2.45478, 0.83201, -0.0], [-1.26231, 0.73716, -0.0], [-3.64737, 0.92684, -0.0]]

    is_linear = mol_is_linear(coordinates)

    assert 1 == is_linear


def test_read_mol():

    data_dir = '{0}/'.format(os.path.dirname(__file__))
    mol_name = data_dir + 'H2O2.mol'

    ref_coordinates = [[1.69509813, -0.01831334, 1.84778681], [-0.83741626, -1.47927283, -1.84733382], \
                       [0.12223015, 0.06073168, -1.31223], [-0.11825048, -0.07620551, 1.31178901]]
    ref_charges = [1, 1, 8, 8]
    ref_masses = [1.007825, 1.007825, 15.994915, 15.994915]

    coordinates, charges, masses = read_mol(mol_name)

    assert np.allclose(ref_coordinates, coordinates)
    assert np.allclose(ref_charges, charges)
    assert np.allclose(ref_masses, masses)


def test_project_out_transl_and_rot():

    coordinates = [[1.69509813, -0.01831334, 1.84778681], [-0.83741626, -1.47927283, -1.84733382], \
                   [0.12223015, 0.06073168, -1.31223], [-0.11825048, -0.07620551, 1.31178901]]

    num_vib_modes = 6

    ref_vib_hess = [[ 5.72269997e-01,  2.09889534e-02,  1.42620475e-01, -8.50811840e-04, \
                      1.62634521e-03,  3.08313993e-03,  1.85914553e-02, -8.78149538e-05, \
                      1.76130443e-02, -5.90010641e-01, -2.25274837e-02, -1.63316659e-01], \
                    [ 2.09889534e-02,  1.57374462e-03,  4.18501063e-03, -1.37917155e-03, \
                     -9.93225244e-04, -3.75708617e-03,  1.07034809e-03, -1.12817472e-03, \
                      1.04272034e-02, -2.06801300e-02,  5.47655346e-04, -1.08551279e-02], \
                    [ 1.42620475e-01,  4.18501063e-03,  1.40143529e-01, -1.69757260e-03, \
                      4.54569499e-03, -9.00688056e-03, -6.49520644e-02, -1.07106785e-02, \
                     -3.47801877e-02, -7.59708375e-02,  1.97997286e-03, -9.63564609e-02], \
                    [-8.50811840e-04, -1.37917155e-03, -1.69757260e-03,  1.63390619e-01, \
                      2.58120942e-01,  7.49590212e-02, -1.66814988e-01, -2.66166141e-01, \
                     -9.11304732e-02,  4.27518110e-03,  9.42437047e-03,  1.78690245e-02], \
                    [ 1.62634521e-03, -9.93225244e-04,  4.54569499e-03,  2.58120942e-01, \
                      4.10597478e-01,  1.21159195e-01, -2.67927761e-01, -4.22767777e-01, \
                     -1.35669503e-01,  8.18047379e-03,  1.31635248e-02,  9.96461236e-03], \
                    [ 3.08313993e-03, -3.75708617e-03, -9.00688056e-03,  7.49590212e-02, \
                      1.21159195e-01,  1.40002530e-01, -3.62004865e-02, -6.65533933e-02, \
                     -9.62397309e-02, -4.18416747e-02, -5.08487160e-02, -3.47559190e-02], \
                    [ 1.85914553e-02,  1.07034809e-03, -6.49520644e-02, -1.66814988e-01, \
                     -2.67927761e-01, -3.62004865e-02,  2.35856641e-01,  3.02731709e-01, \
                      4.07862034e-02, -8.76331081e-02, -3.58742960e-02,  6.03663475e-02], \
                    [-8.78149538e-05, -1.12817472e-03, -1.07106785e-02, -2.66166141e-01, \
                     -4.22767777e-01, -6.65533933e-02,  3.02731709e-01,  4.69496506e-01, \
                      7.48084182e-02, -3.64777530e-02, -4.56005539e-02,  2.45565362e-03], \
                    [ 1.76130443e-02,  1.04272034e-02, -3.47801877e-02, -9.11304732e-02, \
                     -1.35669503e-01, -9.62397309e-02,  4.07862034e-02,  7.48084182e-02, \
                      7.65822271e-01,  3.27312255e-02,  5.04338813e-02, -6.34802352e-01], \
                    [-5.90010641e-01, -2.06801300e-02, -7.59708375e-02,  4.27518110e-03, \
                      8.18047379e-03, -4.18416747e-02, -8.76331081e-02, -3.64777530e-02, \
                      3.27312255e-02,  6.73368568e-01,  4.89774092e-02,  8.50812867e-02], \
                    [-2.25274837e-02,  5.47655346e-04,  1.97997286e-03,  9.42437047e-03, \
                      1.31635248e-02, -5.08487160e-02, -3.58742960e-02, -4.56005539e-02, \
                      5.04338813e-02,  4.89774092e-02,  3.18893737e-02, -1.56513812e-03], \
                    [-1.63316659e-01, -1.08551279e-02, -9.63564609e-02,  1.78690245e-02, \
                      9.96461236e-03, -3.47559190e-02,  6.03663475e-02,  2.45565362e-03, \
                     -6.34802352e-01,  8.50812867e-02, -1.56513812e-03,  7.65914732e-01]]

    vib_hess = project_out_transl_and_rot(num_vib_modes, hess, coordinates)

    assert np.allclose(ref_vib_hess, vib_hess)


def test_get_vib_harm_freqs_and_eigvecs():

    ref_T = \
        [[-1.53222357e-02, -1.53669888e-02,  3.22981009e-03,  4.17339724e-03, \
          -4.03628914e-04, -8.54362528e-04,  1.13488075e-03, -2.88616863e-04, \
          -3.77606108e-04, -1.62362393e-03, -1.62362393e-03,  5.14035877e-04], \
         [-4.88454587e-04, -6.26090972e-04, -2.86856313e-04,  9.19391442e-04, \
           5.97284932e-04,  1.58823715e-02, -1.14146847e-03,  7.96520914e-03, \
           3.28688007e-03, -1.64709234e-03, -1.64709234e-03, -9.62826828e-03], \
         [-4.54192140e-03, -4.36068019e-03, -1.50488540e-02, -1.51582554e-02, \
          -3.00715934e-03,  3.65915208e-04, -1.96142805e-03, -2.50207663e-04, \
          -2.48190436e-05,  3.54138948e-03,  3.54138948e-03, -4.62509663e-06], \
         [-8.12088720e-03,  8.23711286e-03, -1.38024617e-03,  2.89722010e-03, \
          -3.15677757e-04, -1.33095828e-02, -4.84150203e-03,  6.19763680e-03, \
          -2.44347259e-03, -1.40658966e-03, -1.40658966e-03, -9.84941656e-03], \
         [-1.30330770e-02,  1.29622276e-02, -2.92412422e-03,  3.13500922e-03, \
           6.51580245e-04,  8.70769872e-03, -4.48933861e-03, -6.19650723e-04, \
           1.74382574e-03,  6.45440786e-04,  6.45440786e-04,  8.99006010e-03], \
         [-4.54112240e-03,  4.34618794e-03,  1.50507102e-02, -1.51597004e-02, \
           3.00626300e-03, -3.80756305e-04,  3.45825375e-03, -1.30143133e-03, \
           2.00114363e-03,  2.48623031e-03,  2.48623031e-03, -2.63082451e-04], \
         [ 5.11949879e-04, -5.26040879e-04,  1.11679665e-03,  1.44609639e-04, \
          -1.70604122e-04,  9.86304146e-04, -1.50682473e-03, -2.55382512e-03, \
           2.03048197e-04, -9.73793860e-04, -9.73793860e-04, -1.59801919e-03], \
         [ 8.20763107e-04, -8.20829892e-04,  7.77635495e-04, -7.65522406e-04, \
          -1.48224530e-04, -4.63682059e-04, -5.10657338e-03,  4.11025264e-03, \
           9.19617398e-04,  1.06259271e-04,  1.06259271e-04,  3.28095483e-03], \
         [ 2.86187714e-04, -3.45501456e-04, -6.03883287e-04,  9.55520058e-04, \
           4.06140663e-03, -1.10939371e-04, -7.45728136e-04,  7.80849642e-04, \
          -3.73049118e-04,  3.26180135e-03,  3.26180135e-03,  1.36954278e-03], \
         [ 9.65179904e-04,  9.75287860e-04, -1.23333598e-03, -5.90122786e-04, \
           2.15926979e-04, -9.38468746e-05,  5.54270900e-04, -2.53545305e-04, \
          -4.05103152e-04, -1.53831645e-03, -1.53831645e-03, -2.06526629e-04], \
         [ 3.12162589e-05,  4.35411782e-05, -5.75314541e-04,  5.10058319e-04, \
           6.95346751e-05, -1.08571583e-03,  1.06062494e-03, -1.78354784e-03, \
           5.61812796e-03, -8.09242269e-04, -8.09242269e-04,  4.20426292e-04], \
         [ 2.86126589e-04,  3.46414599e-04,  6.03766333e-04,  9.54786678e-04, \
          -4.06135015e-03,  1.11874495e-04, -2.34995409e-04,  6.84086724e-04, \
          -1.83586994e-04,  3.16228875e-03,  3.16228875e-03,  1.34778770e-03]]


    ref_num_coordinates = 12
    ref_vib_energies = [0.01890185358818863, 0.018867981779968866, 0.008117022153354516, \
                        0.007240632902872262, 0.00677517594096139, 0.0008338069322834605]

    coordinates = [[1.69509813, -0.01831334, 1.84778681], [-0.83741626, -1.47927283, -1.84733382], \
                   [0.12223015, 0.06073168, -1.31223], [-0.11825048, -0.07620551, 1.31178901]]
    charges = [1, 1, 8, 8]
    masses = [1.007825, 1.007825, 15.994915, 15.994915]

    vib_energies, transformation_matrix, num_coordinates = \
        get_vib_harm_freqs_and_eigvecs(coordinates, charges, masses, hess, True, 0)

    assert np.allclose(ref_vib_energies, vib_energies)
    assert np.allclose(ref_T, transformation_matrix)
    assert ref_num_coordinates == num_coordinates

    # No outproj

    ref_T = \
        [[ 1.53222364e-02,  1.53670155e-02, -3.22975982e-03, -4.17335205e-03,
           4.03681984e-04, -8.51675722e-04, -2.74560138e-03,  4.55906564e-03,
          -1.38128323e-03,  2.18922739e-03,  3.07109481e-03, -4.60706897e-04],
         [ 4.88410056e-04,  6.26137618e-04,  2.86776025e-04, -9.19420836e-04,
          -5.97402541e-04,  1.58880330e-02,  9.16369781e-03,  2.78802774e-03,
           2.65651660e-03,  2.88456843e-03, -8.65224577e-04, -1.34945554e-02],
         [ 4.54190822e-03,  4.36062063e-03,  1.50489843e-02,  1.51581630e-02,
           3.00692356e-03,  3.63435384e-04,  2.31374067e-03, -4.16520398e-03,
           2.67725344e-03, -1.73219053e-03,  2.44043366e-03,  6.59472490e-04],
         [ 8.12085675e-03, -8.23715876e-03,  1.38026165e-03, -2.89720207e-03,
           3.15755877e-04, -1.33090792e-02,  6.65249266e-03, -4.45629194e-03,
          -1.37950651e-03,  2.19462209e-03,  3.06813217e-03, -1.19475619e-02],
         [ 1.30331105e-02, -1.29622150e-02,  2.92400423e-03, -3.13500547e-03,
          -6.51675312e-04,  8.70392066e-03, -6.91465135e-03, -2.74537108e-03,
           2.65914165e-03,  2.88475733e-03, -8.63687512e-04,  6.35533779e-03],
         [ 4.54111470e-03, -4.34612809e-03, -1.50506731e-02,  1.51597565e-02,
          -3.00606280e-03, -3.78093753e-04,  2.23071308e-03,  4.20922198e-03,
           2.67499815e-03, -1.73596723e-03,  2.44185681e-03 , 6.81301565e-04],
         [-5.11951013e-04,  5.26037263e-04, -1.11680881e-03 ,-1.44620009e-04,
           1.70641992e-04,  9.84036025e-04,  1.56835664e-03, -3.24588870e-03,
          -1.37946718e-03,  2.19338240e-03,  3.06888219e-03,  1.53794676e-03],
         [-8.20759865e-04,  8.20825300e-04, -7.77632229e-04,  7.65559022e-04,
           1.48254437e-04, -4.64760203e-04, -2.92414581e-03, -1.89866657e-03,
           2.65862924e-03,  2.88493285e-03, -8.64053227e-04, -1.79657144e-03],
         [-2.86187268e-04,  3.45504240e-04,  6.03809917e-04, -9.55526425e-04,
          -4.06141159e-03, -1.11217196e-04, -1.36067693e-04, -3.98123285e-04,
           2.67640238e-03, -1.73424924e-03,  2.44156426e-03, -4.25724116e-05],
         [-9.65176896e-04, -9.75283034e-04,  1.23334399e-03,  5.90129171e-04,
          -2.15973115e-04, -9.17812926e-05, -1.81415177e-03,  3.23961805e-03,
          -1.38099116e-03,  2.18995718e-03,  3.07070225e-03, -7.55914748e-04],
         [-3.12188050e-05, -4.35403174e-05,  5.75323892e-04, -5.10093306e-04,
          -6.95511814e-05, -1.08475573e-03,  2.78155768e-03,  1.90057015e-03,
           2.65722104e-03,  2.88408564e-03, -8.64651286e-04,  2.24631281e-03],
         [-2.86125722e-04, -3.46417401e-04, -6.03703508e-04, -9.54778009e-04,
           4.06135735e-03,  1.12142025e-04, -1.48335167e-04,  3.94355857e-04,
           2.67618920e-03, -1.73460725e-03,  2.44169985e-03, -4.17338650e-05]]

    ref_vib_energies = [0.018901874028832266, 0.01886802317926853, 0.008116977208476338, \
                        0.007240605651629329, 0.006775185236703989, 0.0008340875751463902, \
                        2.126962299980866e-05, 1.0416625239654797e-05, 2.0140364571426078e-07, \
                        8.45233427956114e-08, (1.0077399472433052e-23+1.645764228420689e-07j), \
                        (3.1088767339073406e-21+5.077181006102105e-05j)]

    vib_energies, transformation_matrix, num_coordinates = \
        get_vib_harm_freqs_and_eigvecs(coordinates, charges, masses, hess, False, 0)


    assert np.allclose(ref_vib_energies, vib_energies)
    assert np.allclose(ref_T, transformation_matrix)
    assert ref_num_coordinates == num_coordinates


def test_get_vibrational_w():

    w = [0.018901853587738812, 0.018867981781313763, 0.008117022142471952, 0.007240632909554118, \
         0.006775175945822372, 0.0008338069614039414, 9.795831917075847e-11, 9.06072465808631e-12, \
         9.06072465808631e-12, (3.468545572026408e-27+5.664564794422922e-11j), \
        (3.468545572026408e-27+5.664564794422922e-11j), (4.344353699553894e-27+7.094868010235445e-11j)]

    ref_vib_w = [0.018901853587738812, 0.018867981781313763, 0.008117022142471952, \
                 0.007240632909554118, 0.006775175945822372, 0.0008338069614039414]

    vib_w = get_vibrational_w(False, 12, w, True, 0)

    assert np.allclose(ref_vib_w, vib_w)

    # No outprojection

    ref_vib_w = [1.89018536e-02+0.00000000e+00j, 1.88679818e-02+0.00000000e+00j, \
                 8.11702214e-03+0.00000000e+00j, 7.24063291e-03+0.00000000e+00j, \
                 6.77517595e-03+0.00000000e+00j, 8.33806961e-04+0.00000000e+00j, \
                 9.79583192e-11+0.00000000e+00j, 9.06072466e-12+0.00000000e+00j, \
                 9.06072466e-12+0.00000000e+00j, 3.46854557e-27+5.66456479e-11j, \
                 3.46854557e-27+5.66456479e-11j, 4.34435370e-27+7.09486801e-11j]

    vib_w = get_vibrational_w(False, 12, w, False, 0)

    assert np.allclose(ref_vib_w, vib_w)
