# SpectroscPy 0.1.0
# SpectroscPy is a script package developed by and containing contributions from

    # Karen Oda Hjorth Dundas
    # Magnus Ringholm
    # Yann Cornation
    # Benedicte Ofstad

# The package is released under a LGPL licence.
# For questions, please contact on karen.o.dundas@uit.no

from spectroscpy import get_average_beta_aaa2, get_average_beta_baa2, get_hyperraman_SI_scs, \
                        get_hyperraman_intensities
import pytest
import numpy as np

hp_grad = \
[[[[-0.02585429, -0.06119636, -0.02452774],
   [-0.06119636, -0.13591639, -0.05684921],
   [-0.02452774, -0.05684921, -0.05992303]],
  [[-0.05568543, -0.13327782, -0.05195169],
   [-0.13327782, -0.23631437, -0.10382395],
   [-0.05195169, -0.10382395, -0.10714013]],
  [[-0.02269228, -0.05875111, -0.05599647],
   [-0.05875111, -0.11418265, -0.1059542 ],
   [-0.05599647, -0.1059542 , -0.14245346]]],
 [[[-0.34695037,  0.02191233, -0.13061186],
   [ 0.02191233,  0.01815876,  0.01214174],
   [-0.13061186,  0.01214174, -0.12043239]],
  [[ 0.01656412,  0.01457541,  0.00700599],
   [ 0.01457541,  0.00236735,  0.00712574],
   [ 0.00700599,  0.00712574,  0.00625862]],
  [[-0.14191063,  0.01292247, -0.117591  ],
   [ 0.01292247,  0.01011174,  0.00903185],
   [-0.117591  ,  0.00903185, -0.13639506]]],
 [[[-0.0377512 ,  0.0097019 ,  0.03364105],
   [ 0.0097019 ,  0.01220593, -0.02056126],
   [ 0.03364105, -0.02056126,  0.05682042]],
  [[ 0.01138673,  0.01322344, -0.01641034],
   [ 0.01322344,  0.03006642, -0.03245305],
   [-0.01641034, -0.03245305, -0.09349724]],
  [[ 0.02963712, -0.016287  ,  0.06114716],
   [-0.016287  , -0.02855091, -0.10109222],
   [ 0.06114716, -0.10109222,  0.00202657]]],
 [[[ 0.06209655,  0.00692655, -0.04728743],
   [ 0.00692655,  0.02209787, -0.02420862],
   [-0.04728743, -0.02420862, -0.1280484 ]],
  [[ 0.00783852,  0.02056714, -0.02412866],
   [ 0.02056714,  0.04056882, -0.02121934],
   [-0.02412866, -0.02121934, -0.07625015]],
  [[-0.04241862, -0.01953598, -0.1279615 ],
   [-0.01953598, -0.02149002, -0.0764536 ],
   [-0.1279615 , -0.0764536 , -0.08280653]]],
 [[[ 0.01634898, -0.00555998,  0.0049419 ],
   [-0.00555998, -0.00601333, -0.0044347 ],
   [ 0.0049419 , -0.0044347 ,  0.00412788]],
  [[-0.00383202, -0.0050067 , -0.00086818],
   [-0.0050067 , -0.01492938, -0.00464789],
   [-0.00086818, -0.00464789, -0.0059558 ]],
  [[ 0.00205103, -0.00096043,  0.01248455],
   [-0.00096043, -0.00175189, -0.02049832],
   [ 0.01248455, -0.02049832,  0.0010725 ]]],
 [[[ 0.04612187,  0.11832282,  0.02978773],
   [ 0.11832282,  0.01152498,  0.05164008],
   [ 0.02978773,  0.05164008,  0.02568898]],
  [[ 0.11761584,  0.01290794,  0.05174673],
   [ 0.01290794, -0.08658653, -0.02695814],
   [ 0.05174673, -0.02695814,  0.01776613]],
  [[ 0.0293803 ,  0.05145562,  0.02855006],
   [ 0.05145562, -0.02718296,  0.01949165],
   [ 0.02855006,  0.01949165,  0.01024218]]]]

def test_get_average_beta_aaa2():

    ref_beta_aaa2 = [0.04492455, 0.04164692, 0.00552788, 0.01098309, 0.00030553, 0.00762678]


    beta_aaa2 = get_average_beta_aaa2(hp_grad)

    assert len(ref_beta_aaa2) == len(beta_aaa2)
    for i in range(len(beta_aaa2)):
        assert ref_beta_aaa2[i] == pytest.approx(beta_aaa2[i], 1.0e-4)


def test_get_average_beta_baa2():

    ref_beta_baa2 = [4.17705882e-03, 4.94000318e-03, 1.13204548e-03, 1.74265322e-03, \
                     5.17911708e-05, 1.76171736e-03]

    beta_baa2 = get_average_beta_baa2(hp_grad)

    assert len(ref_beta_baa2) == len(beta_baa2)
    for i in range(len(beta_baa2)):
        assert ref_beta_baa2[i] == pytest.approx(beta_baa2[i], 1.0e-5)


def test_get_hyperraman_SI_scs():

    beta_baa2 = [4.17705882e-03, 4.94000318e-03, 1.13204548e-03, 1.74265322e-03, \
                 5.17911708e-05, 1.76171736e-03]
    incident_wn = 0.2
    wn = [2.06021535e-02, 2.04440138e-02, 7.77647837e-03, 6.86405419e-03, 5.86006692e-03, 9.72971519e-11]
    T = 298

    ref_sigma = [5.23419424e-102, 6.24851564e-102, 4.29380624e-102, 7.56162397e-102, \
                 2.66281592e-103, 5.60178933e-087]

    sigma = get_hyperraman_SI_scs(incident_wn, wn, beta_baa2, T)

    assert len(ref_sigma) == len(sigma)
    for i in range(len(sigma)):
        assert ref_sigma[i] == pytest.approx(sigma[i], 1.0e-130)


def test_get_hyperraman_intensities():

    incident_wn = 0.2
    wn = [2.06021535e-02, 2.04440138e-02, 7.77647837e-03, 6.86405419e-03, 5.86006692e-03, 9.72971519e-11]
    T = 298

    ref_sigma_vv = [5.62941108e-101, 5.26783995e-101, 2.09670264e-101, 4.76572115e-101, \
                    1.57089016e-102, 2.42511085e-086]
    ref_sigma_hv = [5.23419424e-102, 6.24851564e-102, 4.29380626e-102, 7.56162395e-102, \
                    2.66281592e-103, 5.60178933e-087]

    sigma_vv, sigma_hv = get_hyperraman_intensities(incident_wn, wn, hp_grad, T)

    assert len(ref_sigma_vv) == len(sigma_vv) == len(sigma_hv)
    for i in range(len(sigma_vv)):
        assert ref_sigma_vv[i] == pytest.approx(sigma_vv[i], 1.0e-130)
        assert ref_sigma_hv[i] == pytest.approx(sigma_hv[i], 1.0e-130)
