# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': '.'}

packages = \
['cognite',
 'cognite.transformations_cli',
 'cognite.transformations_cli.commands',
 'cognite.transformations_cli.commands.deploy']

package_data = \
{'': ['*']}

install_requires = \
['click>=8.0.1,<9.0.0',
 'cognite-extractor-utils>=1.5.2,<2.0.0',
 'cognite-sdk-experimental==0.60.22',
 'sqlparse>=0.4.2,<0.5.0',
 'tabulate>=0.8.9,<0.9.0',
 'types-retry>=0.1.5,<0.2.0',
 'types-tabulate>=0.8.3,<0.9.0']

entry_points = \
{'console_scripts': ['transformations-cli = '
                     'cognite.transformations_cli.__main__:main']}

setup_kwargs = {
    'name': 'cognite-transformations-cli',
    'version': '1.0.0',
    'description': 'A CLI for the Transformations service in CDF',
    'long_description': '<a href="https://cognite.com/">\n    <img src="https://github.com/cognitedata/cognite-python-docs/blob/master/img/cognite_logo.png" alt="Cognite logo" title="Cognite" align="right" height="80" />\n</a>\n\nCognite Python `transformations-cli`\n================================\n[![Build Status](https://github.com/cognitedata/transformations-cli/workflows/release/badge.svg)](https://github.com/cognitedata/transformations-cli/actions)\n[![codecov](https://codecov.io/gh/cognitedata/transformations-cli/branch/main/graph/badge.svg?token=PSkli74vvX)](https://codecov.io/gh/cognitedata/transformations-cli)\n[![PyPI version](https://badge.fury.io/py/cognite-transformations-cli.svg)](https://pypi.org/project/cognite-transformations-cli)\n![PyPI - Python Version](https://img.shields.io/pypi/pyversions/cognite-transformations-cli)\n[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/ambv/black)\n\n# Transformations CLI\n\nThe Transormations CLI is a replacement for [jetfire-cli](https://github.com/cognitedata/jetfire-cli) rewritten on top\nof the new Python SDK for Transformations.\n\n### CLI Documentation\n\nDocumentation for CLI is hosted [here](https://cognite-transformations-cli.readthedocs-hosted.com/en/latest/).\n\n### Github Action\n\n`transformations-cli` also provides a GitHub Action, which can be used to deploy transformations.\n\n1- Create transformation manifests and place them into a folder structure in your repository.\n\n#### Transformation Manifests\n\nImportant notes:\n- When a scheduled transformations represented in a manifest without schedule provided, deploy will delete the existing schedule.\n\n- When an existing notification is not provided along with the transformation to be updated, notification will be deleted.\n\n- Values specified as `${VALUE}` are treated as environment variables while `VALUE` is directly used as the actual value.\n\n- Old jetfire-cli style manifests can be used by adding `legacy: true` inside the old manifest.\n\n- The manifest directory is scanned recursively for `*.yml` and `*.yaml` files, so you can organize your transformations into separate subdirectories.\n\n##### Manifest with API keys\n\n```yaml\n   externalId: "test-cli-transform"\n   name: "test-cli-transform"\n   destination: \n   type: "assets"\n   shared: True\n   action: "upsert"\n   query: "select \'asd\' as name, \'asd\' as externalId"\n   # query:\n   #   file: query.sql\n   schedule: "* * * * *"\n   ignoreNullFields: False\n   notifications:\n   - emel.varol@cognite.com\n   authentication:\n   apiKey: ${API_KEY}\n\n   # # If you need to specity read/write authentication separately\n   # authentication:\n   #   read:\n   #     apiKey: ${API_KEY}\n   #   write:\n   #     apiKey: ${API_KEY}\n```\n\n##### Manifest with OIDC Credentials\n\n```yaml\n# Required\nexternalId: "test-cli-transform-oidc"\n# Required\nname: "test-cli-transform-oidc"\n\n# Required\n# Valid values are: "assets", "timeseries", "asset_hierarchy", events", "datapoints", \n# "string_datapoints", "sequences", "files", "labels", "relationships", "raw", "data_sets"\ndestination: \n  type: "assets"\n# When writing to RAW tables, use the following syntax:\n# destination:\n#   type: raw\n#   rawDatabase: some_database\n#   rawTable: some_table\n\n# Optional, default: True\nshared: True\n\n# Optional, default: upsert\n# Valid values are:\n#   upsert: Create new items, or update existing items if their id or externalId\n#           already exists.\n#   create: Create new items. The transformation will fail if there are id or\n#           externalId conflicts.\n#   update: Update existing items. The transformation will fail if an id or \n#           externalId does not exist.\n#   delete: Delete items by internal id.\naction: "upsert"\n\n# Required\nquery: "select \'asd\' as name, \'asd\' as externalId"\n\n# Or the path to a file containing the SQL query for this transformation.\n# query:\n#   file: query.sql\n\n# Optional, default: null\n# If null, the transformation will not be scheduled.\nschedule: "* * * * *"\nignoreNullFields: False\n\n# Optional, default: null\n# List of email adresses to send emails to on transformation errors\nnotifications:\n  - example@cognite.com\n\n# The client credentials to be used in the transformation\nauthentication:\n  clientId: ${CLIENT_ID}\n  clientSecret: ${CLIENT_SECRET}\n  tokenUrl: ${TOKEN_URL}\n  scopes: \n    - ${SCOPES}\n  cdfProjectName: ${CDF_PROJECT_NAME}\n  # audience: ""\n\n# If you need to specity read/write credentials separately\n# authentication:\n#   read:\n#     clientId: ${CLIENT_ID}\n#     clientSecret: ${CLIENT_SECRET}\n#     tokenUrl: ${TOKEN_URL}\n#     scopes: \n#       - ${SCOPES}\n#     cdfProjectName: ${CDF_PROJECT_NAME}\n#     # audience: ""\n#   write:\n#     clientId: ${CLIENT_ID}\n#     clientSecret: ${CLIENT_SECRET}\n#     tokenUrl: ${TOKEN_URL}\n#     scopes: \n#       - ${SCOPES}\n#     cdfProjectName: ${CDF_PROJECT_NAME}\n#     # audience: ""\n```\n\n2- To deploy a set of transformations in a GitHub workflow, add a step which references the action in your job.\n\n#### Deploy step with API keys\n\n```yaml\n- name: Deploy transformations\n  uses: cognitedata/transformations-cli@main\n  with:\n    path: transformations # Transformation manifest folder, relative to github root dir\n    api-key: ${{ secrets.TRANSFORMATIONS_API_KEY }}\n    # If not using the main europe-west1-1 cluster:\n    # cluster: greenfield\n    # cdf-project-name: my-project # to supress python sdk warning, it is not required for API keys.\n  env:\n    # API key to be used when running your transformations,\n    # As referenced in your transformation manifests\n    SOME_API_KEY: ${{ secrets.SOME_API_KEY }}\n```\n\nThis GitHub action takes the following inputs:\n\n| Name      | Description |\n|-----------|-------------|\n| `path`    | _(Required)_ The path to a directory containing transformation manifests. This is relative to `$GITHUB_WORKSPACE`, which will be the root of the repository when using [actions/checkout](https://github.com/actions/checkout) with default settings. |\n| `api-key` | _(Required)_ The API key used for authenticating with transformations. Equivalent to setting the `TRANSFORMATIONS_API_KEY` environment variable. |\n| `cluster` | _(Optional)_ The name of the cluster where Transformations is hosted. Equivalent to setting the `TRANSFORMATIONS_CLUSTER` environment variable. |\n\nAdditionally, you must specify environment variables for any API keys referenced in transformation manifests.\n\n#### Deploy step with OIDC credentials\n\nAlternatively when using OIDC, the action needs the client details instead of `api-key`:\n```yaml\n- name: Deploy transformations\n  uses: cognitedata/transformations-cli@main\n  env:\n      # Credentials to be used when running your transformations,\n      # as referenced in your manifests:\n      COGNITE_CLIENT_ID: my-cognite-client-id\n      COGNITE_CLIENT_SECRET: ${{ secrets.cognite_client_secret }}\n  with:\n      # Credentials used for deployment\n      path: transformations  # Transformation manifest folder, relative to github root dir\n      client-id: my-jetfire-client-id\n      client-secret: ${{ secrets.jetfire_client_secret] }}\n      token-url: https://login.microsoftonline.com/<my-azure-tenant-id>/oauth2/v2.0/token\n      cdf-project-name: my-project-name\n      # If you need to provide multiple scopes, the format: "scope1 scope2 scope3"\n      scopes: https://<my-cluster>.cognitedata.com/.default\n      # audience: "" # Optional\n```\n\nThis GitHub action takes the following inputs:\n\n| Name      | Description |\n|-----------|-------------|\n| `path`    | _(Required)_ The path to a directory containing transformation manifests. This is relative to `$GITHUB_WORKSPACE`, which will be the root of the repository when using [actions/checkout](https://github.com/actions/checkout) with default settings. |\n| `client-id` | _(Required)_ The CLIENT ID used for authenticating with transformations. Equivalent to setting the `TRANSFORMATIONS_CLIENT_ID` environment variable. |\n| `client-secret` | _(Required)_ The CLIENT SECRET used for authenticating with transformations. Equivalent to setting the `TRANSFORMATIONS_CLIENT_SECRET` environment variable. |\n| `token-url` | _(Required)_ The TOKEN URL used for requesting token to authenticate with transformations. Equivalent to setting the `TRANSFORMATIONS_TOKEN_URL` environment variable. |\n| `cdf-project-name` | _(Required)_ Equivalent to setting the `TRANSFORMATIONS_PROJECT` environment variable. |\n| `scopes` | _(Optional)_ The SCOPES used for authenticating with transformations. Equivalent to setting the `TRANSFORMATIONS_SCOPES` environment variable. Space separated if multiple needed. |\n| `audience` | _(Optional)_ The AUDIENCE used for authenticating with transformations. Equivalent to setting the `TRANSFORMATIONS_AUDIENCE` environment variable. |\n| `cluster` | _(Optional)_ The name of the cluster where Transformations is hosted. Equivalent to setting the `TRANSFORMATIONS_CLUSTER` environment variable. |\n\n\n\n### Contributing\n\nWe use [poetry](https://python-poetry.org) to manage dependencies and to administrate virtual environments. To develop\n`transformations-cli`, follow the following steps to set up your local environment:\n\n 1. Install poetry: (add `--user` if desirable)\n    ```\n    $ pip install poetry\n    ```\n 2. Clone repository:\n    ```\n    $ git clone git@github.com:cognitedata/transformations-cli.git\n    ```\n 3. Move into the newly created local repository:\n    ```\n    $ cd transformations-cli\n    ```\n 4. Create virtual environment and install dependencies:\n    ```\n    $ poetry install\n    ```\n\nAll code must pass [black](https://github.com/ambv/black) and [isort](https://github.com/timothycrosley/isort) style\nchecks to be merged. It is recommended to install pre-commit hooks to ensure this locally before commiting code:\n\n```\n$ poetry run pre-commit install\n```\n\nThis project adheres to the [Contributor Covenant v2.0](https://www.contributor-covenant.org/version/2/0/code_of_conduct/)\nas a code of conduct.\n\n\n',
    'author': 'Mathias Lohne',
    'author_email': 'mathias.lohne@cognite.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/cognitedata/transformations-cli',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
