# retux

![PyPI](https://img.shields.io/pypi/v/retux?style=plastic)
![Python version](https://img.shields.io/pypi/pyversions/retux.svg?style=plastic)
![Code style](https://img.shields.io/badge/code%20style-black-black?style=plastic)
![Discord](https://img.shields.io/discord/993549800911941672?style=plastic)

A Discord API wrapper built with good intentions.

## Introduction

The Discord bot ecosystem is dominated by libraries that offer
abstraction to the point where a bot developer no longer has
to have any considerable programming knowledge prior to developing
their own bot. While abstraction can often be a good thing for
developers, there comes a point where it serves as unnecessary
noise and confusion to writing code.

retux takes an approach towards allowing the developer to write
client-facing code that works instead of being stuck on a
library-specific error every 15 minutes.

## What does it offer?

retux will offer a wide variety of benefits that will guarantee
you as the bot developer to question your past approaches and
development cycles when creating a Discord bot.

- **Simple to understand.** Spend less time debugging your code, and more time writing what you want.
- **Easy to use.** Client-facing code shouldn't need unnecessary complexity to provide the bare minimum outcome.
- **Versatile.** Recycle current existing code paradigms elsewhere, so you can borrow assets off of one another.
- **Safe.** Bot developers are human after all. We'll correct your mistakes for you so that you can keep chugging along.

### When will version 1.0 come out?

There is currently **no set date for version 1.0**. When a
release date has been decided upon, we will let you know. :)

## Social media

Please consider checking out these social media links to get involved.

- [Discord](https://dsc.gg/retux)
