DELAY_TERMINAL_ANSWER_TRANSACTION = 120

TERMINAL_DATA_ENCODING = 'ASCII'

TERMINAL_ANSWER_SET_FULLSIZED = '1'
TERMINAL_ANSWER_SET_SMALLSIZED = '0'

TERMINAL_FORCE_AUTHORIZATION_ENABLE = 'B011'
TERMINAL_FORCE_AUTHORIZATION_DISABLE = 'B010'

TERMINAL_REQUEST_ANSWER_WAIT_FOR_TRANSACTION = 'A010'
TERMINAL_REQUEST_ANSWER_INSTANT = 'A011'

TERMINAL_TYPE_PAYMENT_CARD = '1'
TERMINAL_TYPE_PAYMENT_CHECK = 'C'
TERMINAL_TYPE_PAYMENT_AMEX = '2'
TERMINAL_TYPE_PAYMENT_CETELEM = '3'
TERMINAL_TYPE_PAYMENT_COFINOGA = '5'
TERMINAL_TYPE_PAYMENT_DINERS = '6'
TERMINAL_TYPE_PAYMENT_FRANFINANCE = '8'
TERMINAL_TYPE_PAYMENT_JCB = '9'
TERMINAL_TYPE_PAYMENT_ACCORD_FINANCE = 'A'
TERMINAL_TYPE_PAYMENT_MONEO = 'O'
TERMINAL_TYPE_PAYMENT_CUP = 'U'
TERMINAL_TYPE_PAYMENT_FINTRAX_EMV = 'F'
TERMINAL_TYPE_PAYMENT_OTHER = '0'

TERMINAL_MODE_PAYMENT_DEBIT = '0'
TERMINAL_MODE_PAYMENT_CREDIT = '1'
TERMINAL_MODE_PAYMENT_REFUND = '2'
TERMINAL_MODE_PAYMENT_AUTO = '4'

TERMINAL_PAYMENT_SUCCESS = 0
TERMINAL_PAYMENT_REJECTED = 7
TERMINAL_PAYMENT_NOT_VERIFIED = 9

TERMINAL_NUMERIC_CURRENCY_EUR = '978'
TERMINAL_NUMERIC_CURRENCY_USD = '840'

TERMINAL_ANSWER_COMPLETE_SIZE = 83  # STX + 2 char + 1 char + 8 char + 1 char + 55 char + 3 char + 10 char + ETX + LRC
TERMINAL_ANSWER_LIMITED_SIZE = 28   # STX + 2 char + 1 char + 8 char + 1 char + 3 char + 10 char + ETX + LRC

TERMINAL_ASK_REQUIRED_SIZE = 34
TERMINAL_MAXIMAL_AMOUNT_REQUESTABLE = 99999.99
TERMINAL_MINIMAL_AMOUNT_REQUESTABLE = 1.00
TERMINAL_DECIMALS_ALLOWED = 2

TERMINAL_TRANSACTION_TYPES = {
    'debit': TERMINAL_MODE_PAYMENT_DEBIT,
    'credit': TERMINAL_MODE_PAYMENT_CREDIT,
    'refund': TERMINAL_MODE_PAYMENT_REFUND
}

TERMINAL_PROBABLES_PATH = ['/dev/ttyACM0', '/dev/tty.usbmodem1411']
