# coding: utf-8

"""
    NCBI Datasets API

    NCBI service to query and download biological sequence data across all domains of life from NCBI databases.  # noqa: E501

    The version of the OpenAPI document: v1alpha
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ncbi.datasets.configuration import Configuration


class OrganismCounts(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'node': 'int',
        'subtree': 'int'
    }

    attribute_map = {
        'node': 'node',
        'subtree': 'subtree'
    }

    def __init__(self, node=None, subtree=None, local_vars_configuration=None):  # noqa: E501
        """OrganismCounts - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._node = None
        self._subtree = None
        self.discriminator = None

        if node is not None:
            self.node = node
        if subtree is not None:
            self.subtree = subtree

    @property
    def node(self):
        """Gets the node of this OrganismCounts.  # noqa: E501


        :return: The node of this OrganismCounts.  # noqa: E501
        :rtype: int
        """
        return self._node

    @node.setter
    def node(self, node):
        """Sets the node of this OrganismCounts.


        :param node: The node of this OrganismCounts.  # noqa: E501
        :type: int
        """

        self._node = node

    @property
    def subtree(self):
        """Gets the subtree of this OrganismCounts.  # noqa: E501

        The number of assemblies at this node and all children.  # noqa: E501

        :return: The subtree of this OrganismCounts.  # noqa: E501
        :rtype: int
        """
        return self._subtree

    @subtree.setter
    def subtree(self, subtree):
        """Sets the subtree of this OrganismCounts.

        The number of assemblies at this node and all children.  # noqa: E501

        :param subtree: The subtree of this OrganismCounts.  # noqa: E501
        :type: int
        """

        self._subtree = subtree

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OrganismCounts):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, OrganismCounts):
            return True

        return self.to_dict() != other.to_dict()
