"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const iam = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
// CDK parameters
const STACK_NAME = 'aws-cdk-dynamodb';
// DynamoDB table parameters
const TABLE = 'Table';
const TABLE_WITH_GLOBAL_AND_LOCAL_SECONDARY_INDEX = 'TableWithGlobalAndLocalSecondaryIndex';
const TABLE_WITH_GLOBAL_SECONDARY_INDEX = 'TableWithGlobalSecondaryIndex';
const TABLE_WITH_LOCAL_SECONDARY_INDEX = 'TableWithLocalSecondaryIndex';
const TABLE_PARTITION_KEY = { name: 'hashKey', type: lib_1.AttributeType.STRING };
const TABLE_SORT_KEY = { name: 'sortKey', type: lib_1.AttributeType.NUMBER };
// DynamoDB global secondary index parameters
const GSI_TEST_CASE_1 = 'GSI-PartitionKeyOnly';
const GSI_TEST_CASE_2 = 'GSI-PartitionAndSortKeyWithReadAndWriteCapacity';
const GSI_TEST_CASE_3 = 'GSI-ProjectionTypeKeysOnly';
const GSI_TEST_CASE_4 = 'GSI-ProjectionTypeInclude';
const GSI_TEST_CASE_5 = 'GSI-InverseTableKeySchema';
const GSI_PARTITION_KEY = { name: 'gsiHashKey', type: lib_1.AttributeType.STRING };
const GSI_SORT_KEY = { name: 'gsiSortKey', type: lib_1.AttributeType.NUMBER };
const GSI_NON_KEY = [];
for (let i = 0; i < 10; i++) { // 'A' to 'J'
    GSI_NON_KEY.push(String.fromCharCode(65 + i));
}
// DynamoDB local secondary index parameters
const LSI_TEST_CASE_1 = 'LSI-PartitionAndSortKey';
const LSI_TEST_CASE_2 = 'LSI-PartitionAndTableSortKey';
const LSI_TEST_CASE_3 = 'LSI-ProjectionTypeKeysOnly';
const LSI_TEST_CASE_4 = 'LSI-ProjectionTypeInclude';
const LSI_SORT_KEY = { name: 'lsiSortKey', type: lib_1.AttributeType.NUMBER };
const LSI_NON_KEY = [];
for (let i = 0; i < 10; i++) { // 'K' to 'T'
    LSI_NON_KEY.push(String.fromCharCode(75 + i));
}
const app = new core_1.App();
const stack = new core_1.Stack(app, STACK_NAME);
const table = new lib_1.Table(stack, TABLE, {
    partitionKey: TABLE_PARTITION_KEY,
    removalPolicy: core_1.RemovalPolicy.DESTROY,
});
const tableWithGlobalAndLocalSecondaryIndex = new lib_1.Table(stack, TABLE_WITH_GLOBAL_AND_LOCAL_SECONDARY_INDEX, {
    pointInTimeRecovery: true,
    serverSideEncryption: true,
    stream: lib_1.StreamViewType.KEYS_ONLY,
    timeToLiveAttribute: 'timeToLive',
    partitionKey: TABLE_PARTITION_KEY,
    sortKey: TABLE_SORT_KEY,
    removalPolicy: core_1.RemovalPolicy.DESTROY,
});
core_1.Tags.of(tableWithGlobalAndLocalSecondaryIndex).add('Environment', 'Production');
tableWithGlobalAndLocalSecondaryIndex.addGlobalSecondaryIndex({
    indexName: GSI_TEST_CASE_1,
    partitionKey: GSI_PARTITION_KEY,
});
tableWithGlobalAndLocalSecondaryIndex.addGlobalSecondaryIndex({
    indexName: GSI_TEST_CASE_2,
    partitionKey: GSI_PARTITION_KEY,
    sortKey: GSI_SORT_KEY,
    readCapacity: 10,
    writeCapacity: 10,
});
tableWithGlobalAndLocalSecondaryIndex.addGlobalSecondaryIndex({
    indexName: GSI_TEST_CASE_3,
    partitionKey: GSI_PARTITION_KEY,
    sortKey: GSI_SORT_KEY,
    projectionType: lib_1.ProjectionType.KEYS_ONLY,
});
tableWithGlobalAndLocalSecondaryIndex.addGlobalSecondaryIndex({
    indexName: GSI_TEST_CASE_4,
    partitionKey: GSI_PARTITION_KEY,
    sortKey: GSI_SORT_KEY,
    projectionType: lib_1.ProjectionType.INCLUDE,
    nonKeyAttributes: GSI_NON_KEY,
});
tableWithGlobalAndLocalSecondaryIndex.addGlobalSecondaryIndex({
    indexName: GSI_TEST_CASE_5,
    partitionKey: TABLE_SORT_KEY,
    sortKey: TABLE_PARTITION_KEY,
});
tableWithGlobalAndLocalSecondaryIndex.addLocalSecondaryIndex({
    indexName: LSI_TEST_CASE_2,
    sortKey: LSI_SORT_KEY,
});
tableWithGlobalAndLocalSecondaryIndex.addLocalSecondaryIndex({
    indexName: LSI_TEST_CASE_1,
    sortKey: TABLE_SORT_KEY,
});
tableWithGlobalAndLocalSecondaryIndex.addLocalSecondaryIndex({
    indexName: LSI_TEST_CASE_3,
    sortKey: LSI_SORT_KEY,
    projectionType: lib_1.ProjectionType.KEYS_ONLY,
});
tableWithGlobalAndLocalSecondaryIndex.addLocalSecondaryIndex({
    indexName: LSI_TEST_CASE_4,
    sortKey: LSI_SORT_KEY,
    projectionType: lib_1.ProjectionType.INCLUDE,
    nonKeyAttributes: LSI_NON_KEY,
});
const tableWithGlobalSecondaryIndex = new lib_1.Table(stack, TABLE_WITH_GLOBAL_SECONDARY_INDEX, {
    partitionKey: TABLE_PARTITION_KEY,
    removalPolicy: core_1.RemovalPolicy.DESTROY,
});
tableWithGlobalSecondaryIndex.addGlobalSecondaryIndex({
    indexName: GSI_TEST_CASE_1,
    partitionKey: GSI_PARTITION_KEY,
});
const tableWithLocalSecondaryIndex = new lib_1.Table(stack, TABLE_WITH_LOCAL_SECONDARY_INDEX, {
    partitionKey: TABLE_PARTITION_KEY,
    sortKey: TABLE_SORT_KEY,
    removalPolicy: core_1.RemovalPolicy.DESTROY,
});
tableWithLocalSecondaryIndex.addLocalSecondaryIndex({
    indexName: LSI_TEST_CASE_1,
    sortKey: LSI_SORT_KEY,
});
const user = new iam.User(stack, 'User');
table.grantReadData(user);
tableWithGlobalAndLocalSecondaryIndex.grantReadData(user);
app.synth();
//# sourceMappingURL=data:application/json;base64,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