"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PublicGalleryAuthorizationToken = exports.AuthorizationToken = void 0;
const iam = require("@aws-cdk/aws-iam");
/**
 * Authorization token to access private ECR repositories in the current environment via Docker CLI.
 *
 * @see https://docs.aws.amazon.com/AmazonECR/latest/userguide/registry_auth.html
 * @stability stable
 */
class AuthorizationToken {
    /**
     * Grant access to retrieve an authorization token.
     *
     * @stability stable
     */
    static grantRead(grantee) {
        grantee.grantPrincipal.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['ecr:GetAuthorizationToken'],
            // GetAuthorizationToken only allows '*'. See https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonelasticcontainerregistry.html#amazonelasticcontainerregistry-actions-as-permissions
            resources: ['*'],
        }));
    }
    constructor() {
    }
}
exports.AuthorizationToken = AuthorizationToken;
/**
 * Authorization token to access the global public ECR Gallery via Docker CLI.
 *
 * @see https://docs.aws.amazon.com/AmazonECR/latest/public/public-registries.html#public-registry-auth
 * @stability stable
 */
class PublicGalleryAuthorizationToken {
    /**
     * Grant access to retrieve an authorization token.
     *
     * @stability stable
     */
    static grantRead(grantee) {
        grantee.grantPrincipal.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['ecr-public:GetAuthorizationToken', 'sts:GetServiceBearerToken'],
            // GetAuthorizationToken only allows '*'. See https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonelasticcontainerregistry.html#amazonelasticcontainerregistry-actions-as-permissions
            // GetServiceBearerToken only allows '*'. See https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssecuritytokenservice.html#awssecuritytokenservice-actions-as-permissions
            resources: ['*'],
        }));
    }
    constructor() {
    }
}
exports.PublicGalleryAuthorizationToken = PublicGalleryAuthorizationToken;
//# sourceMappingURL=data:application/json;base64,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