ESA Moon Coverage Toolbox
=========================

<img src="https://moon-coverage.readthedocs.io/en/0.10.0/_static/moon-coverage.svg" align="right" hspace="50" vspace="50" height="200" alt="Moon coverage logo">

[
    ![CI/CD](https://juigitlab.esac.esa.int/datalab/moon-coverage/badges/main/pipeline.svg)
    ![Coverage](https://juigitlab.esac.esa.int/datalab/moon-coverage/badges/main/coverage.svg)
](https://juigitlab.esac.esa.int/datalab/moon-coverage/pipelines/main/latest)
[
    ![Documentation Status](https://readthedocs.org/projects/moon-coverage/badge/?version=latest)
](https://readthedocs.org/projects/moon-coverage/builds/)

[
    ![Latest version](https://img.shields.io/pypi/v/moon-coverage.svg?label=Latest%20release&color=lightgrey)
](https://juigitlab.esac.esa.int/datalab/moon-coverage/-/tags)
[
    ![License](https://img.shields.io/pypi/l/moon-coverage.svg?color=lightgrey&label=License)
](https://juigitlab.esac.esa.int/datalab/moon-coverage/-/blob/main/LICENSE.md)
[
    ![PyPI](https://img.shields.io/badge/PyPI-moon--coverage-blue?logo=Python&logoColor=white)
    ![Python](https://img.shields.io/pypi/pyversions/moon-coverage.svg?label=Python&logo=Python&logoColor=white)
](https://pypi.org/project/moon-coverage/)

[
    ![Docs](https://img.shields.io/badge/Docs-moon--coverage.readthedocs.io-blue?&color=orange&logo=Read%20The%20Docs&logoColor=white)
](https://moon-coverage.readthedocs.io)
[
    ![DataLab](https://img.shields.io/badge/Datalab-datalabs.esa.int-blue?&color=orange&logo=Jupyter&logoColor=white)
](https://datalabs.esa.int)
[
    ![Software Heritage](https://archive.softwareheritage.org/badge/origin/https://juigitlab.esac.esa.int/datalab/moon-coverage/)
](https://archive.softwareheritage.org/browse/origin/?origin_url=https://juigitlab.esac.esa.int/datalab/moon-coverage)

---

The [moon-coverage](https://juigitlab.esac.esa.int/datalab/moon-coverage)
python package is a toolbox to perform
surface coverage analysis based on orbital trajectory configuration.
Its main intent is to provide an easy way to compute observation
opportunities of specific region of interest above the Galilean
satellites for the ESA-JUICE mission but could be extended in the
future to other space mission.

It is actively developed by
the [Laboratory of Planetology and Geosciences](https://lpg-umr6112.fr/)
(CNRS-UMR 6112) at Nantes University (France), under
[ESA-JUICE](https://sci.esa.int/web/juice) founding support.

<p align="center">
  <img src="https://moon-coverage.readthedocs.io/en/0.10.0/_images/lpg-esa.png" alt="LPG / ESA logos"/>
</p>

📦 Installation
---------------

The package is available on [PyPI](https://pypi.org/project/moon-coverage/) and can be installed very easily:

- If you are in a [`Jupyter environnement`](https://jupyter.org/), you can use the magic command `%pip` in a notebook cell and ▶️ `Run` it:
```bash
%pip install --upgrade moon-coverage
```

- or, if you are using a `terminal environment`, you can do:
```bash
pip install --upgrade moon-coverage
```

✏️ How to cite this package
---------------------------

If you use this package for your analyses, please consider using the following citation:

> Seignovert, Benoît, Gabriel Tobie, Rozenn Robidel, Claire Vallat, Inès Belgacem, and Nicolas Altobelli.
> Python Moon-Coverage Toolbox (0.10.0) LPG - Nantes Université, 2022;
> [moon-coverage.readthedocs.io](https://moon-coverage.readthedocs.io/en/0.10.0/);
> [swh:1:rel:4f106164c660db1d505274851217bd1e1a00edea](https://archive.softwareheritage.org/browse/origin/directory/?origin_url=https://juigitlab.esac.esa.int/datalab/moon-coverage&release=0.10.0&snapshot=e4ac3ed12acbe8c17f06b8e29880ce14b33fda4a)

or can use this 📙 [bibtex file](https://juigitlab.esac.esa.int/datalab/moon-coverage/-/raw/main/moon-coverage.bib?inline=false).


⚡️ Issues and 💬 feedback
-------------------------

If you have any issue with this package, we highly recommend to take a look at:

- 📚 our [extended documentation online](https://moon-coverage.readthedocs.io/).
- 📓 the collection of [notebook examples](https://juigitlab.esac.esa.int/datalab/moon-coverage-notebooks).

If you did not find a solution there, feel free to:

- 📝 [open an issue](https://juigitlab.esac.esa.int/datalab/moon-coverage/-/issues/new) (if you have an account on the [JUICE Gitlab](https://juigitlab.esac.esa.int/datalab/moon-coverage)).
- ✉️ send us an email at [&#109;&#111;&#111;&#110;&#45;&#99;&#111;&#118;&#101;&#114;&#97;&#103;&#101;&#64;&#117;&#110;&#105;&#118;&#45;&#110;&#97;&#110;&#116;&#101;&#115;&#46;&#102;&#114;](&#109;&#97;&#105;&#108;&#116;&#111;&#58;&#109;&#111;&#111;&#110;&#45;&#99;&#111;&#118;&#101;&#114;&#97;&#103;&#101;&#64;&#117;&#110;&#105;&#118;&#45;&#110;&#97;&#110;&#116;&#101;&#115;&#46;&#102;&#114;
)


🎨 Contribution and 🐛 fix bugs
-------------------------------

Contributions are always welcome and appreciated.
An account on the [JUICE Giltab](https://juigitlab.esac.esa.int/datalab/moon-coverage) is required.

Here is the steps to suggest a change:

1. 🍴 [Fork this project](https://juigitlab.esac.esa.int/datalab/moon-coverage/-/forks/new)

2. 🐑 Clone and 📦 install the repository locally:

```bash
git clone https://juigitlab.esac.esa.int/<YOUR_USERNAME>/moon-coverage
cd moon-coverage

pip install -e .
pip install -r tests/requirements.txt -r docs/requirements.txt
```

3. ✍️ Make your edits and 🚧 write the tests.

4. 🚦 Double-check that the linters are happy 😱 🤔 😃 :
```bash
flake8 moon_coverage/ tests/ setup.py docs/conf.py
pylint --rcfile=setup.cfg moon_coverage/ tests/*/*.py setup.py
```

5. 🛠 Check that your tests succeed 👍 and you have a coverage of 100% ✨ :

```bash
pytest --cov moon_coverage tests/
```

6. 📖 Complete and ⚙️ build the documentation (if needed):
```bash
sphinx-build docs docs/_build --color -W -bhtml
```

7. 📤 Push your changes to your forked branch and 🚀 open a [new merge request](https://juigitlab.esac.esa.int/datalab/moon-coverage/-/merge_requests/new) explaining what you changed 🙌 👏 💪.
