/* test_rfft3d.cpp -- inplace autocorrelation of 4x4x4 array */

/* expected output

 0.309649795  0.310153693  0.311665416  0.310153693
 0.317712277  0.318216175  0.319727898  0.318216175
 0.341899723  0.342403620  0.343915343  0.342403620
 0.317712277  0.318216175  0.319727898  0.318216175

-0.077349462 -0.076845556 -0.075333834 -0.076845556
-0.069286972 -0.068783067 -0.067271352 -0.068783067
-0.045099523 -0.044595618 -0.043083899 -0.044595618
-0.069286972 -0.068783067 -0.067271352 -0.068783067

-0.206349209 -0.205845296 -0.204333588 -0.205845296
-0.198286727 -0.197782815 -0.196271107 -0.197782815
-0.174099267 -0.173595369 -0.172083646 -0.173595369
-0.198286727 -0.197782815 -0.196271107 -0.197782815

-0.077349462 -0.076845556 -0.075333834 -0.076845556
-0.069286972 -0.068783067 -0.067271352 -0.068783067
-0.045099523 -0.044595618 -0.043083899 -0.044595618
-0.069286972 -0.068783067 -0.067271352 -0.068783067

*/

#include <stdio.h>
#include "ics.h"

int
main(int argc, char **argv)
{
    ssize_t strides[] = {
        4 * 4 * sizeof(float), 4 * sizeof(float), sizeof(float)};
    float data[4 * 4 * 4];
    for (int i = 0; i < 4 * 4 * 4; i++) data[i] = (float)i;

    rfft3d_handle handle = rfft3d_new(4, 4, 4, ICS_AXIS0 | ICS_MODE_FCS);
    if (handle == NULL)
        return -1;
    rfft3d_autocorrelate_ff(handle, data, data, strides);
    rfft3d_del(handle);

    for (int i = 0; i < 4 * 4 * 4;) {
        if (i % 4 == 0)
            printf("\n");
        printf("%12.9f ", data[i++]);
        if (i % 16 == 0)
            printf("\n");
    }
    return 0;
}
