"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.JavascriptIndexPlugin = void 0;
const Path = require("path");
const lunr_1 = require("lunr");
const models_1 = require("../../models");
const plugins_1 = require("../../converter/plugins");
const components_1 = require("../components");
const events_1 = require("../events");
const utils_1 = require("../../utils");
const DefaultTheme_1 = require("../themes/default/DefaultTheme");
/**
 * A plugin that exports an index of the project to a javascript file.
 *
 * The resulting javascript file can be used to build a simple search function.
 */
let JavascriptIndexPlugin = class JavascriptIndexPlugin extends components_1.RendererComponent {
    /**
     * Create a new JavascriptIndexPlugin instance.
     */
    initialize() {
        this.listenTo(this.owner, events_1.RendererEvent.BEGIN, this.onRendererBegin);
    }
    /**
     * Triggered after a document has been rendered, just before it is written to disc.
     *
     * @param event  An event object describing the current render operation.
     */
    onRendererBegin(event) {
        var _a, _b, _c;
        if (!(this.owner.theme instanceof DefaultTheme_1.DefaultTheme)) {
            return;
        }
        if (event.isDefaultPrevented) {
            return;
        }
        const rows = [];
        const kinds = {};
        const kindBoosts = (_a = this.application.options.getValue("searchGroupBoosts")) !== null && _a !== void 0 ? _a : {};
        for (const reflection of event.project.getReflectionsByKind(models_1.ReflectionKind.All)) {
            if (!(reflection instanceof models_1.DeclarationReflection)) {
                continue;
            }
            if (!reflection.url ||
                !reflection.name ||
                reflection.flags.isExternal ||
                reflection.name === "") {
                continue;
            }
            let parent = reflection.parent;
            let boost = (_b = reflection.relevanceBoost) !== null && _b !== void 0 ? _b : 1;
            if (parent instanceof models_1.ProjectReflection) {
                parent = undefined;
            }
            if (!kinds[reflection.kind]) {
                kinds[reflection.kind] = plugins_1.GroupPlugin.getKindSingular(reflection.kind);
            }
            const kindBoost = kindBoosts[(_c = kinds[reflection.kind]) !== null && _c !== void 0 ? _c : ""];
            if (kindBoost != undefined) {
                boost *= kindBoost;
            }
            const row = {
                id: rows.length,
                kind: reflection.kind,
                name: reflection.name,
                url: reflection.url,
                classes: reflection.cssClasses,
            };
            if (boost !== 1) {
                row.boost = boost;
            }
            if (parent) {
                row.parent = parent.getFullName();
            }
            rows.push(row);
        }
        const builder = new lunr_1.Builder();
        builder.pipeline.add(lunr_1.trimmer);
        builder.ref("id");
        builder.field("name", { boost: 10 });
        builder.field("parent");
        rows.forEach((row) => builder.add(row));
        const index = builder.build();
        const jsonFileName = Path.join(event.outputDirectory, "assets", "search.js");
        const jsonData = JSON.stringify({
            kinds,
            rows,
            index,
        });
        (0, utils_1.writeFileSync)(jsonFileName, `window.searchData = JSON.parse(${JSON.stringify(jsonData)});`);
    }
};
JavascriptIndexPlugin = __decorate([
    (0, components_1.Component)({ name: "javascript-index" })
], JavascriptIndexPlugin);
exports.JavascriptIndexPlugin = JavascriptIndexPlugin;
