# Header
if(True):
  __doc__          = "This module contains unit tests. Passed 0.0.1"
  __version__      = "0.0.1"
  __reverse_path__ = "../"
  
  # Python Standard Imports
  import sys, os
  
  # Python Math Imports
  if(True):
    import math,cmath,random
    from decimal import *
    from numbers import Number
  
  # Logging Functions
  if(True):
    import logging, types
    
    global log
    log = logging.getLogger()
    
    def log_func(func,context,name=None):
      # Simplify Variables
      name = name if(name!=None) else func.__name__
      # Context: Extend for Non-Nested, Replace for Nested
      if(log.name == "root"): context = context  + "." + name
      else:                   context = log.name + "." + name
      context = ".".join([_.strip("_") for _ in context.split(".")])
      # Wrappers to Update Context
      def log_wrapper(*args, **kwargs):
        # Log with Context
        global log
        log = logging.getLogger(context)
        out = func(*args, **kwargs)
        log = logging.getLogger()
        return out 
      # Return Wrapped Function
      return log_wrapper
    def log_class(cls,context):
      # Add Context
      context = context + "." + cls.__name__
      # Iterate over class dict
      for name, obj in vars(cls).items():
        is_function = callable(obj) and not isinstance(obj,type)
        is_class    = callable(obj) and     isinstance(obj,type)
        if(is_function): setattr( cls, name, log_func( obj,context,name=name) )
        if(is_class):    setattr( cls, name, log_class(obj,context) )
      return cls
    def log_this(obj,context=None):
      # Initial Context
      if(context==None):context = __name__
      # Sort
      is_function = callable(obj) and not isinstance(obj,type)
      is_class    = callable(obj) and     isinstance(obj,type)
      # Return
      if(is_function): return log_func( obj,context)
      if(is_class):    return log_class(obj,context)
  
  # Repo-Script for Repo-Imports
  if(True):
    # Define Repo-Library Path.
    _file_dir_     = os.path.dirname(__file__)
    _repo_dir_     = os.path.join(_file_dir_, __reverse_path__)
    _repo_lib_dir_ = os.path.join(_repo_dir_, "src/")
    _repo_lib_dir_ = os.path.normpath(_repo_lib_dir_)
    # Add Repo-Library to Path.
    if(_repo_lib_dir_ not in sys.path): sys.path.insert(0, _repo_lib_dir_)
  
  # Additional Imports
  import pytest
  from unitment import AmbiguousUnitException,IncompatibleUnitException,UnitException,Unit,Measure
  import unitment as measure

class TestMeasureOperatorsMul:
  # Error Formula
  # sig**2 = d/dx(x*y)**2 dx**2 + d/dy(x*y)**2 dy **2
  # sig**2 = y**2 dx**2 + x**2 dy **2
  # 
  
  def test_measure_measure_mul(self):
    # Measure (Explicit Error) * Measure (Explicit Error) = Measure (Explicit Error)
    if(True):
      # Unitless * Unitless
      if(True):
        # Value 1: Int
        assert isinstance( ( Measure(value=4,error=2)  *  Measure(value=3,error=2)  ), Measure )
        error = measure._sqrt_( (Decimal("4")**2 * Decimal("2")**2 + Decimal("3")**2 * Decimal("2")**2) )
        assert (  Measure(value=4,error=2)  *  Measure(value=3,error=2)  ).value   == 12
        assert (  Measure(value=4,error=2)  *  Measure(value=3,error=2)  ).error   == error
        assert (  Measure(value=4,error=2)  *  Measure(value=3,error=2)  ).implied == False
        assert (  Measure(value=4,error=2)  *  Measure(value=3,error=2)  ).units.symbols   == Unit().symbols
        assert (  Measure(value=4,error=2)  *  Measure(value=3,error=2)  ).units.magnitude == Unit().magnitude
        assert (  Measure(value=4,error=2)  *  Measure(value=3,error=2)  ) == Measure(units=Unit(), value= 12, error=error)
        # Value 2: Float
        assert isinstance( ( Measure(value=0.4,error=0.2)  *  Measure(value=0.3,error=0.2)  ), Measure )
        error = measure._sqrt_( (0.4**2 * 0.2**2 + 0.3**2 * 0.2**2) )
        assert math.isclose( (  Measure(value=0.4,error=0.2)  *  Measure(value=0.3,error=0.2)  ).value , 0.4*0.3 )
        assert math.isclose( (  Measure(value=0.4,error=0.2)  *  Measure(value=0.3,error=0.2)  ).error , error   )
        assert (  Measure(value=0.4,error=0.2)  *  Measure(value=0.3,error=0.2)  ).implied == False
        assert (  Measure(value=0.4,error=0.2)  *  Measure(value=0.3,error=0.2)  ).units.symbols   == Unit().symbols
        assert (  Measure(value=0.4,error=0.2)  *  Measure(value=0.3,error=0.2)  ).units.magnitude == Unit().magnitude
        assert (  Measure(value=0.4,error=0.2)  *  Measure(value=0.3,error=0.2)  ) == Measure(units=Unit(), value= 0.4*0.3, error=error)
        # Value 3: Decimal
        assert isinstance( (  Measure(value=Decimal("40"),error=Decimal("20"))  *  Measure(value=Decimal("30"),error=Decimal("20"))  ), Measure )
        error = measure._sqrt_( (Decimal("40")**2 * Decimal("20")**2 + Decimal("30")**2 * Decimal("20")**2) )
        assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  Measure(value=Decimal("30"),error=Decimal("20"))  ).value   == Decimal("1200")
        assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  Measure(value=Decimal("30"),error=Decimal("20"))  ).error   == error
        assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  Measure(value=Decimal("30"),error=Decimal("20"))  ).implied == False
        assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  Measure(value=Decimal("30"),error=Decimal("20"))  ).units.symbols   == Unit().symbols
        assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  Measure(value=Decimal("30"),error=Decimal("20"))  ).units.magnitude == Unit().magnitude
        assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  Measure(value=Decimal("30"),error=Decimal("20"))  ) == Measure(units=Unit(), value= Decimal("1200"), error=error)
        # Value 4: Negative
        assert isinstance( ( Measure(value=-4,error=2)  *  Measure(value=-3,error=2)  ), Measure )
        error = measure._sqrt_( (Decimal("4")**2 * Decimal("2")**2 + Decimal("3")**2 * Decimal("2")**2) )
        assert (  Measure(value=-4,error=2)  *  Measure(value=-3,error=2)  ).value   == 12
        assert (  Measure(value=-4,error=2)  *  Measure(value=-3,error=2)  ).error   == error
        assert (  Measure(value=-4,error=2)  *  Measure(value=-3,error=2)  ).implied == False
        assert (  Measure(value=-4,error=2)  *  Measure(value=-3,error=2)  ).units.symbols   == Unit().symbols
        assert (  Measure(value=-4,error=2)  *  Measure(value=-3,error=2)  ).units.magnitude == Unit().magnitude
        assert (  Measure(value=-4,error=2)  *  Measure(value=-3,error=2)  ) == Measure(units=Unit(), value= 12, error=error)
        # Preserve Inputs
        if(True):
          a = Measure(value=4,error=2) 
          b = Measure(value=3,error=2)
          c = a*b
          c = None
          assert a == Measure(value=4,error=2) 
          assert b == Measure(value=3,error=2)
      # Unitless * Unit
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          assert isinstance( (  Measure(value=3,error=2)  *  Measure(value=4,error=2,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (Decimal("4")**2 * Decimal("2")**2 + Decimal("3")**2 * Decimal("2")**2) )
          assert (  Measure(value=3,error=2)  *  Measure(value=4,error=2,unit=Unit("cm"))  ).value   == 12
          assert (  Measure(value=3,error=2)  *  Measure(value=4,error=2,unit=Unit("cm"))  ).error   == error
          assert (  Measure(value=3,error=2)  *  Measure(value=4,error=2,unit=Unit("cm"))  ).implied == False
          assert (  Measure(value=3,error=2)  *  Measure(value=4,error=2,unit=Unit("cm"))  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=3,error=2)  *  Measure(value=4,error=2,unit=Unit("cm"))  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=3,error=2)  *  Measure(value=4,error=2,unit=Unit("cm"))  ) == Measure(units=Unit("cm"), value= 12, error=error)
          # Value 2: Float
          assert isinstance( (  Measure(value=0.3,error=0.2)  *  Measure(value=0.4,error=0.2,unit=Unit("cm")) ), Measure )
          error = measure._sqrt_( (0.4**2 * 0.2**2 + 0.3**2 * 0.2**2) )
          assert math.isclose( (  Measure(value=0.3,error=0.2)  *  Measure(value=0.4,error=0.2,unit=Unit("cm"))  ).value , 0.3*0.4 )
          assert math.isclose( (  Measure(value=0.3,error=0.2)  *  Measure(value=0.4,error=0.2,unit=Unit("cm"))  ).error , error   )
          assert (  Measure(value=0.3,error=0.2)  *  Measure(value=0.4,error=0.2,unit=Unit("cm"))  ).implied == False
          assert (  Measure(value=0.3,error=0.2)  *  Measure(value=0.4,error=0.2,unit=Unit("cm"))  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=0.3,error=0.2)  *  Measure(value=0.4,error=0.2,unit=Unit("cm"))  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=0.3,error=0.2)  *  Measure(value=0.4,error=0.2,unit=Unit("cm"))  ) == Measure(units=Unit("cm"), value= 0.3*0.4, error=error)
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("40"),error=Decimal("20"))  *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (Decimal("40")**2 * Decimal("20")**2 + Decimal("30")**2 * Decimal("20")**2) )
          assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm"))  ).value   == Decimal("1200")
          assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm"))  ).error   == error
          assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm"))  ).implied == False
          assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm"))  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm"))  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm"))  ) == Measure(units=Unit("cm"), value= Decimal("1200"), error=error)
          # Value 4: Negative
          assert isinstance( (  Measure(value=-3,error=2)  *  Measure(value=-4,error=2,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (Decimal("4")**2 * Decimal("2")**2 + Decimal("3")**2 * Decimal("2")**2) )
          assert (  Measure(value=-3,error=2)  *  Measure(value=-4,error=2,unit=Unit("cm"))  ).value   == 12
          assert (  Measure(value=-3,error=2)  *  Measure(value=-4,error=2,unit=Unit("cm"))  ).error   == error
          assert (  Measure(value=-3,error=2)  *  Measure(value=-4,error=2,unit=Unit("cm"))  ).implied == False
          assert (  Measure(value=-3,error=2)  *  Measure(value=-4,error=2,unit=Unit("cm"))  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=-3,error=2)  *  Measure(value=-4,error=2,unit=Unit("cm"))  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=-3,error=2)  *  Measure(value=-4,error=2,unit=Unit("cm"))  ) == Measure(units=Unit("cm"), value= 12, error=error)
        # Magnitude Units
        if(True):
          # Value 1: Int
          assert isinstance( (  Measure(value=5,error=1)  *  Measure(value=2,error=1,unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (Decimal(5)**2 * Decimal(5)**2 + Decimal(10)**2 * Decimal(1)**2) )/Decimal(5)
          assert (  Measure(value=5,error=1)  *  Measure(value=2,error=1,unit=Unit("5 m^2"))  ) == Measure(units=Unit("5 m^2"), value=10, error=error)
          assert (  Measure(value=5,error=1)  *  Measure(value=2,error=1,unit=Unit("5 m^2"))  ).value   == 10
          assert (  Measure(value=5,error=1)  *  Measure(value=2,error=1,unit=Unit("5 m^2"))  ).error   == error
          assert (  Measure(value=5,error=1)  *  Measure(value=2,error=1,unit=Unit("5 m^2"))  ).implied == False
          assert (  Measure(value=5,error=1)  *  Measure(value=2,error=1,unit=Unit("5 m^2"))  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=5,error=1)  *  Measure(value=2,error=1,unit=Unit("5 m^2"))  ).units.magnitude == Unit("5 m^2").magnitude
          # Value 2: Float
          assert isinstance( (  Measure(value=0.5,error=0.1)  *  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (0.5**2 * 0.5**2 + 1.0**2 * 0.1**2) )/5
          assert (  Measure(value=0.5,error=0.1)  *  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  ) == Measure(units=Unit("5 m^2"), value=0.1, error=error)
          assert math.isclose( (  Measure(value=0.5,error=0.1)  *  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  ).value , 0.1   )
          assert math.isclose( (  Measure(value=0.5,error=0.1)  *  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  ).error , error )
          assert (  Measure(value=0.5,error=0.1)  *  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  ).implied == False
          assert (  Measure(value=0.5,error=0.1)  *  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=0.5,error=0.1)  *  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  ).units.magnitude == Unit("5 m^2").magnitude
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("50"),error=Decimal("2"))  *  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (Decimal("50")**2 * Decimal("25")**2 + Decimal("100")**2 * Decimal("2")**2) )/Decimal("5")
          assert (  Measure(value=Decimal("50"),error=Decimal("2"))  *  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  ) == Measure(units=Unit("5 m^2"), value=Decimal("1000"), error=error)
          assert (  Measure(value=Decimal("50"),error=Decimal("2"))  *  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  ).value   == Decimal("1000")
          assert (  Measure(value=Decimal("50"),error=Decimal("2"))  *  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  ).error   == error
          assert (  Measure(value=Decimal("50"),error=Decimal("2"))  *  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  ).implied == False
          assert (  Measure(value=Decimal("50"),error=Decimal("2"))  *  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=Decimal("50"),error=Decimal("2"))  *  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  ).units.magnitude == Unit("5 m^2").magnitude
          # Value 4: Negative
          assert isinstance( (  Measure(value=-5,error=1)  *  Measure(value=-2,error=1,unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (Decimal(5)**2 * Decimal(5)**2 + Decimal(10)**2 * Decimal(1)**2) )/Decimal(5)
          assert (  Measure(value=-5,error=1)  *  Measure(value=-2,error=1,unit=Unit("5 m^2"))  ) == Measure(units=Unit("5 m^2"), value=10, error=error)
          assert (  Measure(value=-5,error=1)  *  Measure(value=-2,error=1,unit=Unit("5 m^2"))  ).value   == 10
          assert (  Measure(value=-5,error=1)  *  Measure(value=-2,error=1,unit=Unit("5 m^2"))  ).error   == error
          assert (  Measure(value=-5,error=1)  *  Measure(value=-2,error=1,unit=Unit("5 m^2"))  ).implied == False
          assert (  Measure(value=-5,error=1)  *  Measure(value=-2,error=1,unit=Unit("5 m^2"))  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=-5,error=1)  *  Measure(value=-2,error=1,unit=Unit("5 m^2"))  ).units.magnitude == Unit("5 m^2").magnitude
        # Convoluted Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Measure(value=300,error=2)  *  Measure(value=27,error=1,unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (Decimal("300")**2 * Decimal("1")**2 + Decimal("300.15")**2 * Decimal("2")**2) )
          assert ( Measure(value=300,error=2)  *  Measure(value=27,error=1,unit=Unit("\u00B0C")) ).value   == Decimal("300.15")*Decimal("300") - Decimal("273.15")
          assert ( Measure(value=300,error=2)  *  Measure(value=27,error=1,unit=Unit("\u00B0C")) ).error   == error
          assert ( Measure(value=300,error=2)  *  Measure(value=27,error=1,unit=Unit("\u00B0C")) ).implied == False
          assert ( Measure(value=300,error=2)  *  Measure(value=27,error=1,unit=Unit("\u00B0C")) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=300,error=2)  *  Measure(value=27,error=1,unit=Unit("\u00B0C")) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=300,error=2)  *  Measure(value=27,error=1,unit=Unit("\u00B0C")) ) == Measure(units=Unit("\u00B0C"), value= Decimal("300.15")*Decimal("300") - Decimal("273.15"), error=error)
          # Value 2: Float
          assert isinstance( ( Measure(value=299.9,error=0.02)  *  Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (299.9**2 * 0.02**2 + 300**2 * 0.02**2) )
          assert math.isclose( ( Measure(value=299.9,error=0.02)  *  Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).value   , 299.9 * 300 - 273.15 )
          assert math.isclose( ( Measure(value=299.9,error=0.02)  *  Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).error   , error )
          assert ( Measure(value=299.9,error=0.02)  *  Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).implied == False 
          assert ( Measure(value=299.9,error=0.02)  *  Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=299.9,error=0.02)  *  Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=299.9,error=0.02)  *  Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ) == Measure(units=Unit("\u00B0C"), value=299.9 * 300 - 273.15, error=error)
          # Value 3: Decimal
          assert isinstance( ( Measure(value=Decimal("300"),error=Decimal("0.02"))  *  Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (Decimal("300")**2 * Decimal("0.02")**2 + Decimal("300")**2 * Decimal("0.02")**2) )
          assert ( Measure(value=Decimal("300"),error=Decimal("0.02"))  *  Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).value   == Decimal("300") * Decimal("300") - Decimal("273.15") 
          assert ( Measure(value=Decimal("300"),error=Decimal("0.02"))  *  Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).error   == error
          assert ( Measure(value=Decimal("300"),error=Decimal("0.02"))  *  Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).implied == False
          assert ( Measure(value=Decimal("300"),error=Decimal("0.02"))  *  Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=Decimal("300"),error=Decimal("0.02"))  *  Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=Decimal("300"),error=Decimal("0.02"))  *  Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ) == Measure(units=Unit("\u00B0C"), value=Decimal("300") * Decimal("300") - Decimal("273.15"), error=error)
          # Value 4: Negative
          assert isinstance( ( Measure(value=300,error=2)  *  Measure(value=-27,error=1,unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (Decimal("300")**2 * Decimal("1")**2 + Decimal("246.15")**2 * Decimal("2")**2) )
          assert ( Measure(value=300,error=2)  *  Measure(value=-27,error=1,unit=Unit("\u00B0C")) ).value   == Decimal("246.15")*Decimal("300") - Decimal("273.15")
          assert ( Measure(value=300,error=2)  *  Measure(value=-27,error=1,unit=Unit("\u00B0C")) ).error   == error
          assert ( Measure(value=300,error=2)  *  Measure(value=-27,error=1,unit=Unit("\u00B0C")) ).implied == False
          assert ( Measure(value=300,error=2)  *  Measure(value=-27,error=1,unit=Unit("\u00B0C")) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=300,error=2)  *  Measure(value=-27,error=1,unit=Unit("\u00B0C")) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=300,error=2)  *  Measure(value=-27,error=1,unit=Unit("\u00B0C")) ) == Measure(units=Unit("\u00B0C"), value= Decimal("246.15")*Decimal("300") - Decimal("273.15"), error=error)
        # Preserve Inputs
        if(True):
          a = Measure(value=3,error=2) 
          b = Measure(value=4,error=2,unit=Unit("cm"))
          c = a*b
          c = None
          assert a == Measure(value=3,error=2) 
          assert b == Measure(value=4,error=2,unit=Unit("cm"))
      # Unit * Unitless
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Measure(value=4,error=2,unit=Unit("cm"))  *  Measure(value=3,error=2)  ), Measure )
          error = measure._sqrt_( (Decimal("4")**2 * Decimal("2")**2 + Decimal("3")**2 * Decimal("2")**2) )
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  Measure(value=3,error=2)  ).value   == 12
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  Measure(value=3,error=2)  ).error   == error
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  Measure(value=3,error=2)  ).implied == False
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  Measure(value=3,error=2)  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  Measure(value=3,error=2)  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  Measure(value=3,error=2)  ) == Measure(units=Unit("cm"), value= 12, error=error)
          # Value 2: Float
          assert isinstance( ( Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  Measure(value=0.3,error=0.2)  ), Measure )
          error = measure._sqrt_( (0.4**2 * 0.2**2 + 0.3**2 * 0.2**2) )
          assert math.isclose( (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  Measure(value=0.3,error=0.2)  ).value , 0.3*0.4 )
          assert math.isclose( (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  Measure(value=0.3,error=0.2)  ).error , error   )
          assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  Measure(value=0.3,error=0.2)  ).implied == False
          assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  Measure(value=0.3,error=0.2)  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  Measure(value=0.3,error=0.2)  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  Measure(value=0.3,error=0.2)  ) == Measure(units=Unit("cm"), value= 0.3*0.4, error=error)
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),error=Decimal("20"))  ), Measure )
          error = measure._sqrt_( (Decimal("40")**2 * Decimal("20")**2 + Decimal("30")**2 * Decimal("20")**2) )
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),error=Decimal("20"))  ).value   == Decimal("1200")
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),error=Decimal("20"))  ).error   == error
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),error=Decimal("20"))  ).implied == False
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),error=Decimal("20"))  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),error=Decimal("20"))  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),error=Decimal("20"))  ) == Measure(units=Unit("cm"), value= Decimal("1200"), error=error)
          # Value 4: Negative
          assert isinstance( ( Measure(value=-4,error=2,unit=Unit("cm"))  *  Measure(value=-3,error=2)  ), Measure )
          error = measure._sqrt_( (Decimal("4")**2 * Decimal("2")**2 + Decimal("3")**2 * Decimal("2")**2) )
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  Measure(value=-3,error=2)  ).value   == 12
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  Measure(value=-3,error=2)  ).error   == error
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  Measure(value=-3,error=2)  ).implied == False
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  Measure(value=-3,error=2)  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  Measure(value=-3,error=2)  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  Measure(value=-3,error=2)  ) == Measure(units=Unit("cm"), value= 12, error=error)
        # Magnitude Units
        if(True):
          # Value 1: Int
          assert isinstance( (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  Measure(value=5,error=1)  ) , Measure )
          error = measure._sqrt_( (Decimal(5)**2 * Decimal(5)**2 + Decimal(10)**2 * Decimal(1)**2) )/Decimal(5)
          assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  Measure(value=5,error=1)  ) == Measure(units=Unit("5 m^2"), value=10, error=error)
          assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  Measure(value=5,error=1)  ).value   == 10
          assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  Measure(value=5,error=1)  ).error   == error
          assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  Measure(value=5,error=1)  ).implied == False
          assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  Measure(value=5,error=1)  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  Measure(value=5,error=1)  ).units.magnitude == Unit("5 m^2").magnitude
          # Value 2: Float
          assert isinstance( (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  Measure(value=0.5,error=0.1)  ) , Measure )
          error = measure._sqrt_( (0.5**2 * 0.5**2 + 1.0**2 * 0.1**2) )/5
          assert (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  Measure(value=0.5,error=0.1)  ) == Measure(units=Unit("5 m^2"), value=0.1, error=error)
          assert math.isclose( (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  Measure(value=0.5,error=0.1)  ).value , 0.1   )
          assert math.isclose( (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  Measure(value=0.5,error=0.1)  ).error , error )
          assert (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  Measure(value=0.5,error=0.1)  ).implied == False
          assert (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  Measure(value=0.5,error=0.1)  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  Measure(value=0.5,error=0.1)  ).units.magnitude == Unit("5 m^2").magnitude
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  Measure(value=Decimal("50"),error=Decimal("2"))  ) , Measure )
          error = measure._sqrt_( (Decimal("50")**2 * Decimal("25")**2 + Decimal("100")**2 * Decimal("2")**2) )/Decimal("5")
          assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  Measure(value=Decimal("50"),error=Decimal("2"))  ) == Measure(units=Unit("5 m^2"), value=Decimal("1000"), error=error)
          assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  Measure(value=Decimal("50"),error=Decimal("2"))  ).value   == Decimal("1000")
          assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  Measure(value=Decimal("50"),error=Decimal("2"))  ).error   == error
          assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  Measure(value=Decimal("50"),error=Decimal("2"))  ).implied == False
          assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  Measure(value=Decimal("50"),error=Decimal("2"))  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  Measure(value=Decimal("50"),error=Decimal("2"))  ).units.magnitude == Unit("5 m^2").magnitude
          # Value 4: Negative
          assert isinstance( (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  Measure(value=-5,error=1)  ) , Measure )
          error = measure._sqrt_( (Decimal(5)**2 * Decimal(5)**2 + Decimal(10)**2 * Decimal(1)**2) )/Decimal(5)
          assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  Measure(value=-5,error=1)  ) == Measure(units=Unit("5 m^2"), value=10, error=error)
          assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  Measure(value=-5,error=1)  ).value   == 10
          assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  Measure(value=-5,error=1)  ).error   == error
          assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  Measure(value=-5,error=1)  ).implied == False
          assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  Measure(value=-5,error=1)  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  Measure(value=-5,error=1)  ).units.magnitude == Unit("5 m^2").magnitude
        # Convoluted Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  Measure(value=300,error=2) ), Measure )
          error = measure._sqrt_( (Decimal("300")**2 * Decimal("1")**2 + Decimal("300.15")**2 * Decimal("2")**2) )
          assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  Measure(value=300,error=2) ).value   == Decimal("300.15")*Decimal("300") - Decimal("273.15")
          assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  Measure(value=300,error=2) ).error   == error
          assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  Measure(value=300,error=2) ).implied == False
          assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  Measure(value=300,error=2) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  Measure(value=300,error=2) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  Measure(value=300,error=2) ) == Measure(units=Unit("\u00B0C"), value= Decimal("300.15")*Decimal("300") - Decimal("273.15"), error=error)
          # Value 2: Float
          assert isinstance( ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  Measure(value=299.9,error=0.02) ), Measure )
          error = measure._sqrt_( (299.9**2 * 0.02**2 + 300**2 * 0.02**2) )
          assert math.isclose( ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  Measure(value=299.9,error=0.02) ).value , 299.9 * 300 - 273.15 )
          assert math.isclose( ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  Measure(value=299.9,error=0.02) ).error , error )
          assert ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  Measure(value=299.9,error=0.02) ).implied == False
          assert ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  Measure(value=299.9,error=0.02) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  Measure(value=299.9,error=0.02) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  Measure(value=299.9,error=0.02) ) == Measure(units=Unit("\u00B0C"), value=299.9 * 300 - 273.15, error=error)
          # Value 3: Decimal
          assert isinstance( ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  Measure(value=Decimal("300"),error=Decimal("0.02")) ), Measure )
          error = measure._sqrt_( (Decimal("300")**2 * Decimal("0.02")**2 + Decimal("300")**2 * Decimal("0.02")**2) )
          assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  Measure(value=Decimal("300"),error=Decimal("0.02")) ).value   == Decimal("300") * Decimal("300") - Decimal("273.15") 
          assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  Measure(value=Decimal("300"),error=Decimal("0.02")) ).error   == error
          assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  Measure(value=Decimal("300"),error=Decimal("0.02")) ).implied == False
          assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  Measure(value=Decimal("300"),error=Decimal("0.02")) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  Measure(value=Decimal("300"),error=Decimal("0.02")) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  Measure(value=Decimal("300"),error=Decimal("0.02")) ) == Measure(units=Unit("\u00B0C"), value=Decimal("300") * Decimal("300") - Decimal("273.15"), error=error)
          # Value 4: Negative
          assert isinstance( ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  Measure(value=300,error=2) ), Measure )
          error = measure._sqrt_( (Decimal("300")**2 * Decimal("1")**2 + Decimal("246.15")**2 * Decimal("2")**2) )
          assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  Measure(value=300,error=2) ).value   == Decimal("246.15")*Decimal("300") - Decimal("273.15")
          assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  Measure(value=300,error=2) ).error   == error
          assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  Measure(value=300,error=2) ).implied == False
          assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  Measure(value=300,error=2) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  Measure(value=300,error=2) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  Measure(value=300,error=2) ) == Measure(units=Unit("\u00B0C"), value= Decimal("246.15")*Decimal("300") - Decimal("273.15"), error=error)
        # Preserve Inputs
        if(True):
          a = Measure(value=4,error=2,unit=Unit("cm"))
          b = Measure(value=3,error=2)
          c = a*b
          c = None
          assert a == Measure(value=4,error=2,unit=Unit("cm")) 
          assert b == Measure(value=3,error=2)
      # Units * Units
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Measure(value=4,error=2,unit=Unit("cm"))  *  Measure(value=3,error=2,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (Decimal("4")**2 * Decimal("2")**2 + Decimal("3")**2 * Decimal("2")**2) )
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  Measure(value=3,error=2,unit=Unit("cm"))  ).value   == 12
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  Measure(value=3,error=2,unit=Unit("cm"))  ).error   == error
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  Measure(value=3,error=2,unit=Unit("cm"))  ).implied == False
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  Measure(value=3,error=2,unit=Unit("cm"))  ).units.symbols   == Unit("cm^2").symbols
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  Measure(value=3,error=2,unit=Unit("cm"))  ).units.magnitude == Unit("cm^2").magnitude
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  Measure(value=3,error=2,unit=Unit("cm"))  ) == Measure(units=Unit("cm^2"), value= 12, error=error)
          # Value 2: Float
          assert isinstance( ( Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  Measure(value=0.3,error=0.2,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (0.4**2 * 0.2**2 + 0.3**2 * 0.2**2) )
          assert math.isclose( (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  Measure(value=0.3,error=0.2,unit=Unit("cm"))  ).value , 0.3*0.4 )
          assert math.isclose( (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  Measure(value=0.3,error=0.2,unit=Unit("cm"))  ).error , error   )
          assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  Measure(value=0.3,error=0.2,unit=Unit("cm"))  ).implied == False
          assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  Measure(value=0.3,error=0.2,unit=Unit("cm"))  ).units.symbols   == Unit("cm^2").symbols
          assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  Measure(value=0.3,error=0.2,unit=Unit("cm"))  ).units.magnitude == Unit("cm^2").magnitude
          assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  Measure(value=0.3,error=0.2,unit=Unit("cm"))  ) == Measure(units=Unit("cm^2"), value= 0.3*0.4, error=error)
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (Decimal("40")**2 * Decimal("20")**2 + Decimal("30")**2 * Decimal("20")**2) )
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm"))  ).value   == Decimal("1200")
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm"))  ).error   == error
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm"))  ).implied == False
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm"))  ).units.symbols   == Unit("cm^2").symbols
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm"))  ).units.magnitude == Unit("cm^2").magnitude
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm"))  ) == Measure(units=Unit("cm^2"), value= Decimal("1200"), error=error)
          # Value 4: Negative
          assert isinstance( ( Measure(value=-4,error=2,unit=Unit("cm"))  *  Measure(value=-3,error=2,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (Decimal("4")**2 * Decimal("2")**2 + Decimal("3")**2 * Decimal("2")**2) )
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  Measure(value=-3,error=2,unit=Unit("cm"))  ).value   == 12
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  Measure(value=-3,error=2,unit=Unit("cm"))  ).error   == error
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  Measure(value=-3,error=2,unit=Unit("cm"))  ).implied == False
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  Measure(value=-3,error=2,unit=Unit("cm"))  ).units.symbols   == Unit("cm^2").symbols
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  Measure(value=-3,error=2,unit=Unit("cm"))  ).units.magnitude == Unit("cm^2").magnitude
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  Measure(value=-3,error=2,unit=Unit("cm"))  ) == Measure(units=Unit("cm^2"), value= 12, error=error)
        # Magnitude Units
        if(True):
          # Value 1: Int
          assert isinstance( (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  Measure(value=5,error=1,unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (Decimal(25)**2 * Decimal(5)**2 + Decimal(10)**2 * Decimal(5)**2) )/Decimal(25)
          assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  Measure(value=5,error=1,unit=Unit("5 m^2"))  ).value   == 10
          assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  Measure(value=5,error=1,unit=Unit("5 m^2"))  ).error   == error
          assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  Measure(value=5,error=1,unit=Unit("5 m^2"))  ).implied == False
          assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  Measure(value=5,error=1,unit=Unit("5 m^2"))  ).units.symbols   == Unit("25 m^4").symbols
          assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  Measure(value=5,error=1,unit=Unit("5 m^2"))  ).units.magnitude == Unit("25 m^4").magnitude
          assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  Measure(value=5,error=1,unit=Unit("5 m^2"))  ) == Measure(units=Unit("25 m^4"), value=10, error=error)
          # Value 2: Float
          assert isinstance( (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  Measure(value=0.5,error=0.1,unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (2.5**2 * 0.5**2 + 1.0**2 * 0.5**2) )/25
          assert math.isclose( (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  Measure(value=0.5,error=0.1,unit=Unit("5 m^2"))  ).value , 0.1   )
          assert math.isclose( (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  Measure(value=0.5,error=0.1,unit=Unit("5 m^2"))  ).error , error )
          assert (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  Measure(value=0.5,error=0.1,unit=Unit("5 m^2"))  ).implied == False
          assert (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  Measure(value=0.5,error=0.1,unit=Unit("5 m^2"))  ).units.symbols   == Unit("25 m^4").symbols
          assert (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  Measure(value=0.5,error=0.1,unit=Unit("5 m^2"))  ).units.magnitude == Unit("25 m^4").magnitude
          assert (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  Measure(value=0.5,error=0.1,unit=Unit("5 m^2"))  ) == Measure(units=Unit("25 m^4"), value=0.1, error=error)
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  Measure(value=Decimal("50"),error=Decimal("2"),unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (Decimal("250")**2 * Decimal("25")**2 + Decimal("100")**2 * Decimal("10")**2) )/Decimal("25")
          assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  Measure(value=Decimal("50"),error=Decimal("2"),unit=Unit("5 m^2"))  ) == Measure(units=Unit("25 m^4"), value=Decimal("1000"), error=error)
          assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  Measure(value=Decimal("50"),error=Decimal("2"),unit=Unit("5 m^2"))  ).value   == Decimal("1000")
          assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  Measure(value=Decimal("50"),error=Decimal("2"),unit=Unit("5 m^2"))  ).error   == error
          assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  Measure(value=Decimal("50"),error=Decimal("2"),unit=Unit("5 m^2"))  ).implied == False
          assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  Measure(value=Decimal("50"),error=Decimal("2"),unit=Unit("5 m^2"))  ).units.symbols   == Unit("25 m^4").symbols
          assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  Measure(value=Decimal("50"),error=Decimal("2"),unit=Unit("5 m^2"))  ).units.magnitude == Unit("25 m^4").magnitude
          # Value 4: Negative
          assert isinstance( (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  Measure(value=-5,error=1,unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (Decimal(25)**2 * Decimal(5)**2 + Decimal(10)**2 * Decimal(5)**2) )/Decimal(25)
          assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  Measure(value=-5,error=1,unit=Unit("5 m^2"))  ) == Measure(units=Unit("25 m^4"), value=10, error=error)
          assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  Measure(value=-5,error=1,unit=Unit("5 m^2"))  ).value   == 10
          assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  Measure(value=-5,error=1,unit=Unit("5 m^2"))  ).error   == error
          assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  Measure(value=-5,error=1,unit=Unit("5 m^2"))  ).implied == False
          assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  Measure(value=-5,error=1,unit=Unit("5 m^2"))  ).units.symbols   == Unit("25 m^4").symbols
          assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  Measure(value=-5,error=1,unit=Unit("5 m^2"))  ).units.magnitude == Unit("25 m^4").magnitude
        # Convoluted Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  Measure(value=27,error=2,unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (Decimal("300.15")**2 * Decimal("1")**2 + Decimal("300.15")**2 * Decimal("2")**2) )
          assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  Measure(value=27,error=2,unit=Unit("\u00B0C")) ).value   == Decimal("300.15")*Decimal("300.15")
          assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  Measure(value=27,error=2,unit=Unit("\u00B0C")) ).error   == error
          assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  Measure(value=27,error=2,unit=Unit("\u00B0C")) ).implied == False
          assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  Measure(value=27,error=2,unit=Unit("\u00B0C")) ).units.symbols   == Unit("K^2").symbols
          assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  Measure(value=27,error=2,unit=Unit("\u00B0C")) ).units.magnitude == Unit("K^2").magnitude
          assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  Measure(value=27,error=2,unit=Unit("\u00B0C")) ) == Measure(units=Unit("K^2"), value= Decimal("300.15")*Decimal("300.15"), error=error)
          # Value 2: Float
          assert isinstance( ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (300**2 * 0.02**2 + 300**2 * 0.02**2) )
          assert math.isclose( ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).value   , 300 * 300 )
          assert math.isclose( ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).error   , error )
          assert ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).implied == False 
          assert ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).units.symbols   == Unit("K^2").symbols
          assert ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).units.magnitude == Unit("K^2").magnitude
          assert ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ) == Measure(units=Unit("K^2"), value=300 * 300, error=error)
          # Value 3: Decimal
          assert isinstance( ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (Decimal("300")**2 * Decimal("0.02")**2 + Decimal("300")**2 * Decimal("0.02")**2) )
          assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).value   == Decimal("300") * Decimal("300") 
          assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).error   == error
          assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).implied == False
          assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).units.symbols   == Unit("K^2").symbols
          assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).units.magnitude == Unit("K^2").magnitude
          assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ) == Measure(units=Unit("K^2"), value=Decimal("300") * Decimal("300"), error=error)
          # Value 4: Negative
          assert isinstance( ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  Measure(value=-27,error=2,unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (Decimal("246.15")**2 * Decimal("1")**2 + Decimal("246.15")**2 * Decimal("2")**2) )
          assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  Measure(value=-27,error=2,unit=Unit("\u00B0C")) ).value   == Decimal("246.15")*Decimal("246.15")
          assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  Measure(value=-27,error=2,unit=Unit("\u00B0C")) ).error   == error
          assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  Measure(value=-27,error=2,unit=Unit("\u00B0C")) ).implied == False
          assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  Measure(value=-27,error=2,unit=Unit("\u00B0C")) ).units.symbols   == Unit("K^2").symbols
          assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  Measure(value=-27,error=2,unit=Unit("\u00B0C")) ).units.magnitude == Unit("K^2").magnitude
          assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  Measure(value=-27,error=2,unit=Unit("\u00B0C")) ) == Measure(units=Unit("K^2"), value= Decimal("246.15")*Decimal("246.15"), error=error)
        # Canceling Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Measure(value=4,error=2,unit=Unit("cm"))  *  Measure(value=3,error=2,unit=Unit("cm^-1"))  ), Measure )
          error = measure._sqrt_( (Decimal("4")**2 * Decimal("2")**2 + Decimal("3")**2 * Decimal("2")**2) )
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  Measure(value=3,error=2,unit=Unit("cm^-1"))  ).value   == 12
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  Measure(value=3,error=2,unit=Unit("cm^-1"))  ).error   == error
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  Measure(value=3,error=2,unit=Unit("cm^-1"))  ).implied == False
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  Measure(value=3,error=2,unit=Unit("cm^-1"))  ).units.symbols   == Unit().symbols
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  Measure(value=3,error=2,unit=Unit("cm^-1"))  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  Measure(value=3,error=2,unit=Unit("cm^-1"))  ) == Measure(units=Unit(), value= 12, error=error)
          # Value 2: Float
          assert isinstance( ( Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  Measure(value=0.3,error=0.2,unit=Unit("cm^-1"))  ), Measure )
          error = measure._sqrt_( (0.4**2 * 0.2**2 + 0.3**2 * 0.2**2) )
          assert math.isclose( (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  Measure(value=0.3,error=0.2,unit=Unit("cm^-1"))  ).value , 0.3*0.4 )
          assert math.isclose( (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  Measure(value=0.3,error=0.2,unit=Unit("cm^-1"))  ).error , error   )
          assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  Measure(value=0.3,error=0.2,unit=Unit("cm^-1"))  ).implied == False
          assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  Measure(value=0.3,error=0.2,unit=Unit("cm^-1"))  ).units.symbols   == Unit().symbols
          assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  Measure(value=0.3,error=0.2,unit=Unit("cm^-1"))  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  Measure(value=0.3,error=0.2,unit=Unit("cm^-1"))  ) == Measure(units=Unit(), value= 0.3*0.4, error=error)
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm^-1"))  ), Measure )
          error = measure._sqrt_( (Decimal("40")**2 * Decimal("20")**2 + Decimal("30")**2 * Decimal("20")**2) )
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm^-1"))  ).value   == Decimal("1200")
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm^-1"))  ).error   == error
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm^-1"))  ).implied == False
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm^-1"))  ).units.symbols   == Unit().symbols
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm^-1"))  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm^-1"))  ) == Measure(units=Unit(), value= Decimal("1200"), error=error)
          # Value 4: Negative
          assert isinstance( ( Measure(value=-4,error=2,unit=Unit("cm"))  *  Measure(value=-3,error=2,unit=Unit("cm^-1"))  ), Measure )
          error = measure._sqrt_( (Decimal("4")**2 * Decimal("2")**2 + Decimal("3")**2 * Decimal("2")**2) )
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  Measure(value=-3,error=2,unit=Unit("cm^-1"))  ).value   == 12
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  Measure(value=-3,error=2,unit=Unit("cm^-1"))  ).error   == error
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  Measure(value=-3,error=2,unit=Unit("cm^-1"))  ).implied == False
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  Measure(value=-3,error=2,unit=Unit("cm^-1"))  ).units.symbols   == Unit().symbols
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  Measure(value=-3,error=2,unit=Unit("cm^-1"))  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  Measure(value=-3,error=2,unit=Unit("cm^-1"))  ) == Measure(units=Unit(), value= 12, error=error)
        # Preserve Inputs
        if(True):
          a = Measure(value=4,error=2,unit=Unit("cm"))
          b = Measure(value=3,error=2,unit=Unit("cm"))
          c = a*b
          c = None
          assert a == Measure(value=4,error=2,unit=Unit("cm"))
          assert b == Measure(value=3,error=2,unit=Unit("cm"))
    # Measure (Explicit Error) * Measure (Implicit Error) = Measure (Implicit Error)
    if(True):
      # Unitless * Unitless
      if(True):
        # Value 1: Int
        assert isinstance( ( Measure(value=4,error=2)  *  Measure(value=3)  ), Measure )
        error = measure._sqrt_( (Decimal(4)**2 * Decimal("0.5")**2 + Decimal(3)**2 * Decimal(2)**2) )
        assert (  Measure(value=4,error=2)  *  Measure(value=3)  ).value   == 12
        assert (  Measure(value=4,error=2)  *  Measure(value=3)  ).error   == error
        assert (  Measure(value=4,error=2)  *  Measure(value=3)  ).implied == True
        assert (  Measure(value=4,error=2)  *  Measure(value=3)  ).units.symbols   == Unit().symbols
        assert (  Measure(value=4,error=2)  *  Measure(value=3)  ).units.magnitude == Unit().magnitude
        assert (  Measure(value=4,error=2)  *  Measure(value=3)  ) == Measure(units=Unit(), value= 12, error=error)
        # Value 2: Float
        assert isinstance( ( Measure(value=0.4,error=0.2)  *  Measure(value=0.3)  ), Measure )
        error = measure._sqrt_( (0.4**2 * 0.05**2 + 0.3**2 * 0.2**2) )
        assert math.isclose( (  Measure(value=0.4,error=0.2)  *  Measure(value=0.3)  ).value , 0.4*0.3 )
        assert math.isclose( (  Measure(value=0.4,error=0.2)  *  Measure(value=0.3)  ).error , error   )
        assert (  Measure(value=0.4,error=0.2)  *  Measure(value=0.3)  ).implied == True
        assert (  Measure(value=0.4,error=0.2)  *  Measure(value=0.3)  ).units.symbols   == Unit().symbols
        assert (  Measure(value=0.4,error=0.2)  *  Measure(value=0.3)  ).units.magnitude == Unit().magnitude
        assert (  Measure(value=0.4,error=0.2)  *  Measure(value=0.3)  ) == Measure(units=Unit(), value= 0.4*0.3, error=error)
        # Value 3: Decimal
        assert isinstance( (  Measure(value=Decimal("40"),error=Decimal("20"))  *  Measure(value=Decimal("30"))  ), Measure )
        error = measure._sqrt_( ( Decimal("40")**2 * Decimal("5")**2 + Decimal("30")**2 * Decimal("20")**2) )
        assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  Measure(value=Decimal("30"))  ).value   == Decimal("1200")
        assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  Measure(value=Decimal("30"))  ).error   == error
        assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  Measure(value=Decimal("30"))  ).implied == True
        assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  Measure(value=Decimal("30"))  ).units.symbols   == Unit().symbols
        assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  Measure(value=Decimal("30"))  ).units.magnitude == Unit().magnitude
        assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  Measure(value=Decimal("30"))  ) == Measure(units=Unit(), value= Decimal("1200"), error=error)
        # Value 4: Negative
        assert isinstance( ( Measure(value=-4,error=2)  *  Measure(value=-3)  ), Measure )
        error = measure._sqrt_( (Decimal(4)**2 * Decimal("0.5")**2 + Decimal(3)**2 * Decimal(2)**2) )
        assert (  Measure(value=-4,error=2)  *  Measure(value=-3)  ).value   == 12
        assert (  Measure(value=-4,error=2)  *  Measure(value=-3)  ).error   == error
        assert (  Measure(value=-4,error=2)  *  Measure(value=-3)  ).implied == True
        assert (  Measure(value=-4,error=2)  *  Measure(value=-3)  ).units.symbols   == Unit().symbols
        assert (  Measure(value=-4,error=2)  *  Measure(value=-3)  ).units.magnitude == Unit().magnitude
        assert (  Measure(value=-4,error=2)  *  Measure(value=-3)  ) == Measure(units=Unit(), value= 12, error=error)
        # Preserve Inputs
        if(True):
          a = Measure(value=4,error=2) 
          b = Measure(value=3)
          c = a*b
          c = None
          assert a == Measure(value=4,error=2) 
          assert b == Measure(value=3)
      # Unitless * Unit
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          assert isinstance( (  Measure(value=3,error=2)  *  Measure(value=4,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (Decimal(3)**2 * Decimal("0.5")**2 + Decimal(4)**2 * Decimal(2)**2) )
          assert (  Measure(value=3,error=2)  *  Measure(value=4,unit=Unit("cm"))  ).value   == 12
          assert (  Measure(value=3,error=2)  *  Measure(value=4,unit=Unit("cm"))  ).error   == error
          assert (  Measure(value=3,error=2)  *  Measure(value=4,unit=Unit("cm"))  ).implied == True
          assert (  Measure(value=3,error=2)  *  Measure(value=4,unit=Unit("cm"))  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=3,error=2)  *  Measure(value=4,unit=Unit("cm"))  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=3,error=2)  *  Measure(value=4,unit=Unit("cm"))  ) == Measure(units=Unit("cm"), value= 12, error=error)
          # Value 2: Float
          assert isinstance( (  Measure(value=0.3,error=0.2)  *  Measure(value=0.4,unit=Unit("cm")) ), Measure )
          error = measure._sqrt_( (0.4**2 * 0.2**2 + 0.3**2 * 0.05**2) )
          assert math.isclose( (  Measure(value=0.3,error=0.2)  *  Measure(value=0.4,unit=Unit("cm"))  ).value , 0.3*0.4 )
          assert math.isclose( (  Measure(value=0.3,error=0.2)  *  Measure(value=0.4,unit=Unit("cm"))  ).error , error   )
          assert (  Measure(value=0.3,error=0.2)  *  Measure(value=0.4,unit=Unit("cm"))  ).implied == True
          assert (  Measure(value=0.3,error=0.2)  *  Measure(value=0.4,unit=Unit("cm"))  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=0.3,error=0.2)  *  Measure(value=0.4,unit=Unit("cm"))  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=0.3,error=0.2)  *  Measure(value=0.4,unit=Unit("cm"))  ) == Measure(units=Unit("cm"), value= 0.3*0.4, error=error)
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("40"),error=Decimal("20"))  *  Measure(value=Decimal("30"),unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( ( Decimal("40")**2 * Decimal("5")**2 + Decimal("30")**2 * Decimal("20")**2) )
          assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  Measure(value=Decimal("30"),unit=Unit("cm"))  ).value   == Decimal("1200")
          assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  Measure(value=Decimal("30"),unit=Unit("cm"))  ).error   == error
          assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  Measure(value=Decimal("30"),unit=Unit("cm"))  ).implied == True
          assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  Measure(value=Decimal("30"),unit=Unit("cm"))  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  Measure(value=Decimal("30"),unit=Unit("cm"))  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  Measure(value=Decimal("30"),unit=Unit("cm"))  ) == Measure(units=Unit("cm"), value= Decimal("1200"), error=error)
          # Value 4: Negative
          assert isinstance( (  Measure(value=-3,error=2)  *  Measure(value=-4,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (Decimal(3)**2 * Decimal("0.5")**2 + Decimal(4)**2 * Decimal(2)**2) )
          assert (  Measure(value=-3,error=2)  *  Measure(value=-4,unit=Unit("cm"))  ).value   == 12
          assert (  Measure(value=-3,error=2)  *  Measure(value=-4,unit=Unit("cm"))  ).error   == error
          assert (  Measure(value=-3,error=2)  *  Measure(value=-4,unit=Unit("cm"))  ).implied == True
          assert (  Measure(value=-3,error=2)  *  Measure(value=-4,unit=Unit("cm"))  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=-3,error=2)  *  Measure(value=-4,unit=Unit("cm"))  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=-3,error=2)  *  Measure(value=-4,unit=Unit("cm"))  ) == Measure(units=Unit("cm"), value= 12, error=error)
        # Magnitude Units
        if(True):
          # Value 1: Int
          assert isinstance( (  Measure(value=5,error=1)  *  Measure(value=2,unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (Decimal("5")**2 * Decimal("2.5")**2 + Decimal("10")**2 * Decimal("1")**2) )/Decimal("5")
          assert (  Measure(value=5,error=1)  *  Measure(value=2,unit=Unit("5 m^2"))  ) == Measure(units=Unit("5 m^2"), value=10, error=error)
          assert (  Measure(value=5,error=1)  *  Measure(value=2,unit=Unit("5 m^2"))  ).value   == 10
          #assert (  Measure(value=5,error=1)  *  Measure(value=2,unit=Unit("5 m^2"))  ).error   == error
          # The above won't work, do to changes on uncertain even for decimal operations (due to calculating and back-calculating in unit operations).
          assert Measure._dec_isclose_( (Measure(value=5,error=1)  *  Measure(value=2,unit=Unit("5 m^2"))).error , error )
          assert (  Measure(value=5,error=1)  *  Measure(value=2,unit=Unit("5 m^2"))  ).implied == True
          assert (  Measure(value=5,error=1)  *  Measure(value=2,unit=Unit("5 m^2"))  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=5,error=1)  *  Measure(value=2,unit=Unit("5 m^2"))  ).units.magnitude == Unit("5 m^2").magnitude
          # Value 2: Float
          assert isinstance( (  Measure(value=0.5,error=0.1)  *  Measure(value=0.2,unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (0.5**2 * 0.25**2 + 1.0**2 * 0.1**2) )/5
          assert (  Measure(value=0.5,error=0.1)  *  Measure(value=0.2,unit=Unit("5 m^2"))  ) == Measure(units=Unit("5 m^2"), value=0.1, error=error)
          assert math.isclose( (  Measure(value=0.5,error=0.1)  *  Measure(value=0.2,unit=Unit("5 m^2"))  ).value , 0.1   )
          assert math.isclose( (  Measure(value=0.5,error=0.1)  *  Measure(value=0.2,unit=Unit("5 m^2"))  ).error , error )
          assert (  Measure(value=0.5,error=0.1)  *  Measure(value=0.2,unit=Unit("5 m^2"))  ).implied == True
          assert (  Measure(value=0.5,error=0.1)  *  Measure(value=0.2,unit=Unit("5 m^2"))  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=0.5,error=0.1)  *  Measure(value=0.2,unit=Unit("5 m^2"))  ).units.magnitude == Unit("5 m^2").magnitude
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("50"),error=Decimal("2"))  *  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (Decimal("50")**2 * Decimal("25")**2 + Decimal("100")**2 * Decimal("2")**2) )/Decimal("5")
          assert (  Measure(value=Decimal("50"),error=Decimal("2"))  *  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  ) == Measure(units=Unit("5 m^2"), value=Decimal("1000"), error=error)
          assert (  Measure(value=Decimal("50"),error=Decimal("2"))  *  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  ).value   == Decimal("1000")
          assert (  Measure(value=Decimal("50"),error=Decimal("2"))  *  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  ).error   == error
          assert (  Measure(value=Decimal("50"),error=Decimal("2"))  *  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  ).implied == True
          assert (  Measure(value=Decimal("50"),error=Decimal("2"))  *  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=Decimal("50"),error=Decimal("2"))  *  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  ).units.magnitude == Unit("5 m^2").magnitude
          # Value 4: Negative
          assert isinstance( (  Measure(value=-5,error=1)  *  Measure(value=-2,unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (Decimal("5")**2 * Decimal("2.5")**2 + Decimal("10")**2 * Decimal("1")**2) )/Decimal("5")
          assert (  Measure(value=-5,error=1)  *  Measure(value=-2,unit=Unit("5 m^2"))  ) == Measure(units=Unit("5 m^2"), value=10, error=error)
          assert (  Measure(value=-5,error=1)  *  Measure(value=-2,unit=Unit("5 m^2"))  ).value   == 10
          #assert (  Measure(value=-5,error=1)  *  Measure(value=-2,unit=Unit("5 m^2"))  ).error   == error
          # The above won't work, do to changes on uncertain even for decimal operations (due to calculating and back-calculating in unit operations).
          assert Measure._dec_isclose_( (Measure(value=-5,error=1)  *  Measure(value=-2,unit=Unit("5 m^2"))).error , error )
          assert (  Measure(value=-5,error=1)  *  Measure(value=-2,unit=Unit("5 m^2"))  ).implied == True
          assert (  Measure(value=-5,error=1)  *  Measure(value=-2,unit=Unit("5 m^2"))  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=-5,error=1)  *  Measure(value=-2,unit=Unit("5 m^2"))  ).units.magnitude == Unit("5 m^2").magnitude
        # Convoluted Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Measure(value=300,error=2)  *  Measure(value=27,unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (Decimal("300")**2 * Decimal("0.5")**2 + Decimal("300.15")**2 * Decimal("2")**2) )
          assert ( Measure(value=300,error=2)  *  Measure(value=27,unit=Unit("\u00B0C")) ).value   == Decimal("300.15")*Decimal("300") - Decimal("273.15")
          assert ( Measure(value=300,error=2)  *  Measure(value=27,unit=Unit("\u00B0C")) ).error   == error
          assert ( Measure(value=300,error=2)  *  Measure(value=27,unit=Unit("\u00B0C")) ).implied == True
          assert ( Measure(value=300,error=2)  *  Measure(value=27,unit=Unit("\u00B0C")) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=300,error=2)  *  Measure(value=27,unit=Unit("\u00B0C")) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=300,error=2)  *  Measure(value=27,unit=Unit("\u00B0C")) ) == Measure(units=Unit("\u00B0C"), value= Decimal("300.15")*Decimal("300") - Decimal("273.15"), error=error)
          # Value 2: Float
          assert isinstance( ( Measure(value=299.9,error=0.02)  *  Measure(value=26.85,unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (299.9**2 * 0.005**2 + 300**2 * 0.02**2) )
          assert math.isclose( ( Measure(value=299.9,error=0.02)  *  Measure(value=26.85,unit=Unit("\u00B0C")) ).value  , 299.9 * 300 - 273.15 )
          assert math.isclose( ( Measure(value=299.9,error=0.02)  *  Measure(value=26.85,unit=Unit("\u00B0C")) ).error  , error )
          assert ( Measure(value=299.9,error=0.02)  *  Measure(value=26.85,unit=Unit("\u00B0C")) ).implied == True 
          assert ( Measure(value=299.9,error=0.02)  *  Measure(value=26.85,unit=Unit("\u00B0C")) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=299.9,error=0.02)  *  Measure(value=26.85,unit=Unit("\u00B0C")) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=299.9,error=0.02)  *  Measure(value=26.85,unit=Unit("\u00B0C")) ) == Measure(units=Unit("\u00B0C"), value=299.9 * 300 - 273.15, error=error)
          # Value 3: Decimal
          assert isinstance( ( Measure(value=Decimal("300"),error=Decimal("0.02"))  *  Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (Decimal("300")**2 * Decimal("0.005")**2 + Decimal("300")**2 * Decimal("0.02")**2) )
          assert ( Measure(value=Decimal("300"),error=Decimal("0.02"))  *  Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).value   == Decimal("300") * Decimal("300") - Decimal("273.15") 
          assert ( Measure(value=Decimal("300"),error=Decimal("0.02"))  *  Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).error   == error
          assert ( Measure(value=Decimal("300"),error=Decimal("0.02"))  *  Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).implied == True
          assert ( Measure(value=Decimal("300"),error=Decimal("0.02"))  *  Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=Decimal("300"),error=Decimal("0.02"))  *  Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=Decimal("300"),error=Decimal("0.02"))  *  Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ) == Measure(units=Unit("\u00B0C"), value=Decimal("300") * Decimal("300") - Decimal("273.15"), error=error)
          # Value 4: Negative
          assert isinstance( ( Measure(value=300,error=2)  *  Measure(value=-27,unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (Decimal("300")**2 * Decimal("0.5")**2 + Decimal("246.15")**2 * Decimal("2")**2) )
          assert ( Measure(value=300,error=2)  *  Measure(value=-27,unit=Unit("\u00B0C")) ).value   == Decimal("246.15")*Decimal("300") - Decimal("273.15")
          assert ( Measure(value=300,error=2)  *  Measure(value=-27,unit=Unit("\u00B0C")) ).error   == error
          assert ( Measure(value=300,error=2)  *  Measure(value=-27,unit=Unit("\u00B0C")) ).implied == True
          assert ( Measure(value=300,error=2)  *  Measure(value=-27,unit=Unit("\u00B0C")) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=300,error=2)  *  Measure(value=-27,unit=Unit("\u00B0C")) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=300,error=2)  *  Measure(value=-27,unit=Unit("\u00B0C")) ) == Measure(units=Unit("\u00B0C"), value= Decimal("246.15")*Decimal("300") - Decimal("273.15"), error=error)
        # Preserve Inputs
        if(True):
          a = Measure(value=3,error=2) 
          b = Measure(value=4,unit=Unit("cm"))
          c = a*b
          c = None
          assert a == Measure(value=3,error=2) 
          assert b == Measure(value=4,unit=Unit("cm"))
      # Unit * Unitless
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Measure(value=4,error=2,unit=Unit("cm"))  *  Measure(value=3)  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0.5")**2 + Decimal(3)**2 * Decimal(2)**2) )
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  Measure(value=3)  ).value   == 12
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  Measure(value=3)  ).error   == error 
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  Measure(value=3)  ).implied == True
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  Measure(value=3)  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  Measure(value=3)  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  Measure(value=3)  ) == Measure(units=Unit("cm"), value= 12, error=error)
          # Value 2: Float
          assert isinstance( ( Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  Measure(value=0.3)  ), Measure )
          error = measure._sqrt_( (0.4**2 * 0.05**2 + 0.3**2 * 0.2**2) )
          assert math.isclose( (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  Measure(value=0.3)  ).value , 0.3*0.4 )
          assert math.isclose( (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  Measure(value=0.3)  ).error , error   )
          assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  Measure(value=0.3)  ).implied == True
          assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  Measure(value=0.3)  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  Measure(value=0.3)  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  Measure(value=0.3)  ) == Measure(units=Unit("cm"), value= 0.3*0.4, error=error)
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  Measure(value=Decimal("30"))  ), Measure )
          error = measure._sqrt_( (Decimal("40")**2 * Decimal("5")**2 + Decimal("30")**2 * Decimal("20")**2) )
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  Measure(value=Decimal("30"))  ).value   == Decimal("1200")
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  Measure(value=Decimal("30"))  ).error   == error
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  Measure(value=Decimal("30"))  ).implied == True
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  Measure(value=Decimal("30"))  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  Measure(value=Decimal("30"))  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  Measure(value=Decimal("30"))  ) == Measure(units=Unit("cm"), value= Decimal("1200"), error=error)
          # Value 4: Negative
          assert isinstance( ( Measure(value=-4,error=2,unit=Unit("cm"))  *  Measure(value=-3)  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0.5")**2 + Decimal(3)**2 * Decimal(2)**2) )
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  Measure(value=-3)  ).value   == 12
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  Measure(value=-3)  ).error   == error
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  Measure(value=-3)  ).implied == True
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  Measure(value=-3)  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  Measure(value=-3)  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  Measure(value=-3)  ) == Measure(units=Unit("cm"), value= 12, error=error)
        # Magnitude Units
        if(True):
          # Value 1: Int
          assert isinstance( (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  Measure(value=5)  ) , Measure )
          error = measure._sqrt_( (Decimal(5)**2 * Decimal(5)**2 + Decimal(10)**2 * Decimal("0.5")**2) )/Decimal(5)
          assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  Measure(value=5)  ) == Measure(units=Unit("5 m^2"), value=10, error=error)
          assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  Measure(value=5)  ).value   == 10
          assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  Measure(value=5)  ).error   == error
          assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  Measure(value=5)  ).implied == True
          assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  Measure(value=5)  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  Measure(value=5)  ).units.magnitude == Unit("5 m^2").magnitude
          # Value 2: Float
          assert isinstance( (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  Measure(value=0.5)  ) , Measure )
          error = measure._sqrt_( (0.5**2 * 0.5**2 + 1.0**2 * 0.05**2) )/5
          assert (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  Measure(value=0.5)  ) == Measure(units=Unit("5 m^2"), value=0.1, error=error)
          assert math.isclose( (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  Measure(value=0.5)  ).value , 0.1   )
          assert math.isclose( (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  Measure(value=0.5)  ).error , error )
          assert (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  Measure(value=0.5)  ).implied == True
          assert (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  Measure(value=0.5)  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  Measure(value=0.5)  ).units.magnitude == Unit("5 m^2").magnitude
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  Measure(value=Decimal("50"))  ) , Measure )
          error = measure._sqrt_( (Decimal("50")**2 * Decimal("25")**2 + Decimal("100")**2 * Decimal("5")**2) )/Decimal("5")
          assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  Measure(value=Decimal("50"))  ) == Measure(units=Unit("5 m^2"), value=Decimal("1000"), error=error)
          assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  Measure(value=Decimal("50"))  ).value   == Decimal("1000")
          assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  Measure(value=Decimal("50"))  ).error   == error
          assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  Measure(value=Decimal("50"))  ).implied == True
          assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  Measure(value=Decimal("50"))  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  Measure(value=Decimal("50"))  ).units.magnitude == Unit("5 m^2").magnitude
          # Value 4: Negative
          assert isinstance( (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  Measure(value=-5)  ) , Measure )
          error = measure._sqrt_( (Decimal(5)**2 * Decimal(5)**2 + Decimal(10)**2 * Decimal("0.5")**2) )/Decimal(5)
          assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  Measure(value=-5)  ) == Measure(units=Unit("5 m^2"), value=10, error=error)
          assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  Measure(value=-5)  ).value   == 10
          assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  Measure(value=-5)  ).error   == error
          assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  Measure(value=-5)  ).implied == True
          assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  Measure(value=-5)  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  Measure(value=-5)  ).units.magnitude == Unit("5 m^2").magnitude
        # Convoluted Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  Measure(value=300) ), Measure )
          error = measure._sqrt_( (Decimal("300")**2 * Decimal("1")**2 + Decimal("300.15")**2 * Decimal("50")**2) )
          assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  Measure(value=300) ).value   == Decimal("300.15")*Decimal("300") - Decimal("273.15")
          assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  Measure(value=300) ).error   == error
          assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  Measure(value=300) ).implied == True
          assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  Measure(value=300) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  Measure(value=300) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  Measure(value=300) ) == Measure(units=Unit("\u00B0C"), value= Decimal("300.15")*Decimal("300") - Decimal("273.15"), error=error)
          # Value 2: Float
          assert isinstance( ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  Measure(value=299.9) ), Measure )
          error = measure._sqrt_( (299.9**2 * 0.02**2 + 300**2 * 0.05**2) )
          assert math.isclose( ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  Measure(value=299.9) ).value , 299.9 * 300 - 273.15 )
          assert math.isclose( ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  Measure(value=299.9) ).error , error )
          assert ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  Measure(value=299.9) ).implied == True
          assert ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  Measure(value=299.9) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  Measure(value=299.9) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  Measure(value=299.9) ) == Measure(units=Unit("\u00B0C"), value=299.9 * 300 - 273.15, error=error)
          # Value 3: Decimal
          assert isinstance( ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  Measure(value=Decimal("300")) ), Measure )
          error = measure._sqrt_( (Decimal("300")**2 * Decimal("0.02")**2 + Decimal("300")**2 * Decimal("50")**2) )
          assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  Measure(value=Decimal("300")) ).value   == Decimal("300") * Decimal("300") - Decimal("273.15") 
          assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  Measure(value=Decimal("300")) ).error   == error
          assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  Measure(value=Decimal("300")) ).implied == True
          assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  Measure(value=Decimal("300")) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  Measure(value=Decimal("300")) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  Measure(value=Decimal("300")) ) == Measure(units=Unit("\u00B0C"), value=Decimal("300") * Decimal("300") - Decimal("273.15"), error=error)
          # Value 4: Negative
          assert isinstance( ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  Measure(value=300) ), Measure )
          error = measure._sqrt_( (Decimal("300")**2 * Decimal("1")**2 + Decimal("246.15")**2 * Decimal("50")**2) )
          assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  Measure(value=300) ).value   == Decimal("246.15")*Decimal("300") - Decimal("273.15")
          assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  Measure(value=300) ).error   == error
          assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  Measure(value=300) ).implied == True
          assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  Measure(value=300) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  Measure(value=300) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  Measure(value=300) ) == Measure(units=Unit("\u00B0C"), value= Decimal("246.15")*Decimal("300") - Decimal("273.15"), error=error)
        # Preserve Inputs
        if(True):
          a = Measure(value=4,error=2,unit=Unit("cm"))
          b = Measure(value=3)
          c = a*b
          c = None
          assert a == Measure(value=4,error=2,unit=Unit("cm")) 
          assert b == Measure(value=3)
      # Units * Units
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Measure(value=4,error=2,unit=Unit("cm"))  *  Measure(value=3,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0.5")**2 + Decimal(3)**2 * Decimal(2)**2) )
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  Measure(value=3,unit=Unit("cm"))  ).value   == 12
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  Measure(value=3,unit=Unit("cm"))  ).error   == error
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  Measure(value=3,unit=Unit("cm"))  ).implied == True
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  Measure(value=3,unit=Unit("cm"))  ).units.symbols   == Unit("cm^2").symbols
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  Measure(value=3,unit=Unit("cm"))  ).units.magnitude == Unit("cm^2").magnitude
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  Measure(value=3,unit=Unit("cm"))  ) == Measure(units=Unit("cm^2"), value= 12, error=error)
          # Value 2: Float
          assert isinstance( ( Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  Measure(value=0.3,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (0.4**2 * 0.05**2 + 0.3**2 * 0.2**2) )
          assert math.isclose( (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  Measure(value=0.3,unit=Unit("cm"))  ).value , 0.3*0.4 )
          assert math.isclose( (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  Measure(value=0.3,unit=Unit("cm"))  ).error , error   )
          assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  Measure(value=0.3,unit=Unit("cm"))  ).implied == True
          assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  Measure(value=0.3,unit=Unit("cm"))  ).units.symbols   == Unit("cm^2").symbols
          assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  Measure(value=0.3,unit=Unit("cm"))  ).units.magnitude == Unit("cm^2").magnitude
          assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  Measure(value=0.3,unit=Unit("cm"))  ) == Measure(units=Unit("cm^2"), value= 0.3*0.4, error=error)
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (Decimal("40")**2 * Decimal("5")**2 + Decimal("30")**2 * Decimal("20")**2) )
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),unit=Unit("cm"))  ).value   == Decimal("1200")
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),unit=Unit("cm"))  ).error   == error
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),unit=Unit("cm"))  ).implied == True
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),unit=Unit("cm"))  ).units.symbols   == Unit("cm^2").symbols
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),unit=Unit("cm"))  ).units.magnitude == Unit("cm^2").magnitude
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),unit=Unit("cm"))  ) == Measure(units=Unit("cm^2"), value= Decimal("1200"), error=error)
          # Value 4: Negative
          assert isinstance( ( Measure(value=-4,error=2,unit=Unit("cm"))  *  Measure(value=-3,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0.5")**2 + Decimal(3)**2 * Decimal(2)**2) )
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  Measure(value=-3,unit=Unit("cm"))  ).value   == 12
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  Measure(value=-3,unit=Unit("cm"))  ).error   == error
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  Measure(value=-3,unit=Unit("cm"))  ).implied == True
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  Measure(value=-3,unit=Unit("cm"))  ).units.symbols   == Unit("cm^2").symbols
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  Measure(value=-3,unit=Unit("cm"))  ).units.magnitude == Unit("cm^2").magnitude
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  Measure(value=-3,unit=Unit("cm"))  ) == Measure(units=Unit("cm^2"), value= 12, error=error)
        # Magnitude Units
        if(True):
          # Value 1: Int
          assert isinstance( (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  Measure(value=5,unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (Decimal(25)**2 * Decimal(5)**2 + Decimal(10)**2 * Decimal("2.5")**2) )/Decimal(25)
          assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  Measure(value=5,unit=Unit("5 m^2"))  ).value   == 10
          assert Measure._dec_isclose_( (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  Measure(value=5,unit=Unit("5 m^2"))  ).error   , error )
          assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  Measure(value=5,unit=Unit("5 m^2"))  ).implied == True
          assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  Measure(value=5,unit=Unit("5 m^2"))  ).units.symbols   == Unit("25 m^4").symbols
          assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  Measure(value=5,unit=Unit("5 m^2"))  ).units.magnitude == Unit("25 m^4").magnitude
          assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  Measure(value=5,unit=Unit("5 m^2"))  ) == Measure(units=Unit("25 m^4"), value=10, error=error)
          # Value 2: Float
          assert isinstance( (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  Measure(value=0.5,unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (2.5**2 * 0.5**2 + 1.0**2 * 0.25**2) )/25
          assert math.isclose( (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  Measure(value=0.5,unit=Unit("5 m^2"))  ).value , 0.1   )
          assert math.isclose( (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  Measure(value=0.5,unit=Unit("5 m^2"))  ).error , error )
          assert (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  Measure(value=0.5,unit=Unit("5 m^2"))  ).implied == True
          assert (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  Measure(value=0.5,unit=Unit("5 m^2"))  ).units.symbols   == Unit("25 m^4").symbols
          assert (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  Measure(value=0.5,unit=Unit("5 m^2"))  ).units.magnitude == Unit("25 m^4").magnitude
          assert (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  Measure(value=0.5,unit=Unit("5 m^2"))  ) == Measure(units=Unit("25 m^4"), value=0.1, error=error)
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  Measure(value=Decimal("50"),unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (Decimal("250")**2 * Decimal("25")**2 + Decimal("100")**2 * Decimal("25")**2) )/Decimal("25")
          assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  Measure(value=Decimal("50"),unit=Unit("5 m^2"))  ) == Measure(units=Unit("25 m^4"), value=Decimal("1000"), error=error)
          assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  Measure(value=Decimal("50"),unit=Unit("5 m^2"))  ).value   == Decimal("1000")
          assert Measure._dec_isclose_( (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  Measure(value=Decimal("50"),unit=Unit("5 m^2"))  ).error   , error )
          assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  Measure(value=Decimal("50"),unit=Unit("5 m^2"))  ).implied == True
          assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  Measure(value=Decimal("50"),unit=Unit("5 m^2"))  ).units.symbols   == Unit("25 m^4").symbols
          assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  Measure(value=Decimal("50"),unit=Unit("5 m^2"))  ).units.magnitude == Unit("25 m^4").magnitude
          # Value 4: Negative
          assert isinstance( (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  Measure(value=-5,unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (Decimal(25)**2 * Decimal(5)**2 + Decimal(10)**2 * Decimal("2.5")**2) )/Decimal(25)
          assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  Measure(value=-5,unit=Unit("5 m^2"))  ) == Measure(units=Unit("25 m^4"), value=10, error=error)
          assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  Measure(value=-5,unit=Unit("5 m^2"))  ).value   == 10
          assert Measure._dec_isclose_( (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  Measure(value=-5,unit=Unit("5 m^2"))  ).error   , error )
          assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  Measure(value=-5,unit=Unit("5 m^2"))  ).implied == True
          assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  Measure(value=-5,unit=Unit("5 m^2"))  ).units.symbols   == Unit("25 m^4").symbols
          assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  Measure(value=-5,unit=Unit("5 m^2"))  ).units.magnitude == Unit("25 m^4").magnitude
        # Convoluted Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  Measure(value=27,unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (Decimal("300.15")**2 * Decimal("1")**2 + Decimal("300.15")**2 * Decimal("0.5")**2) )
          assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  Measure(value=27,unit=Unit("\u00B0C")) ).value   == Decimal("300.15")*Decimal("300.15")
          assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  Measure(value=27,unit=Unit("\u00B0C")) ).error   == error
          assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  Measure(value=27,unit=Unit("\u00B0C")) ).implied == True
          assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  Measure(value=27,unit=Unit("\u00B0C")) ).units.symbols   == Unit("K^2").symbols
          assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  Measure(value=27,unit=Unit("\u00B0C")) ).units.magnitude == Unit("K^2").magnitude
          assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  Measure(value=27,unit=Unit("\u00B0C")) ) == Measure(units=Unit("K^2"), value= Decimal("300.15")*Decimal("300.15"), error=error)
          # Value 2: Float
          assert isinstance( ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  Measure(value=26.85,unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (300**2 * 0.02**2 + 300**2 * 0.005**2) )
          assert math.isclose( ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  Measure(value=26.85,unit=Unit("\u00B0C")) ).value   , 300 * 300 )
          assert math.isclose( ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  Measure(value=26.85,unit=Unit("\u00B0C")) ).error   , error )
          assert ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  Measure(value=26.85,unit=Unit("\u00B0C")) ).implied == True
          assert ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  Measure(value=26.85,unit=Unit("\u00B0C")) ).units.symbols   == Unit("K^2").symbols
          assert ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  Measure(value=26.85,unit=Unit("\u00B0C")) ).units.magnitude == Unit("K^2").magnitude
          assert ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  Measure(value=26.85,unit=Unit("\u00B0C")) ) == Measure(units=Unit("K^2"), value=300 * 300, error=error)
          # Value 3: Decimal
          assert isinstance( ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (Decimal("300")**2 * Decimal("0.02")**2 + Decimal("300")**2 * Decimal("0.005")**2) )
          assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).value   == Decimal("300") * Decimal("300") 
          assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).error   == error
          assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).implied == True
          assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).units.symbols   == Unit("K^2").symbols
          assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).units.magnitude == Unit("K^2").magnitude
          assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ) == Measure(units=Unit("K^2"), value=Decimal("300") * Decimal("300"), error=error)
          # Value 4: Negative
          assert isinstance( ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  Measure(value=-27,unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (Decimal("246.15")**2 * Decimal("1")**2 + Decimal("246.15")**2 * Decimal("0.5")**2) )
          assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  Measure(value=-27,unit=Unit("\u00B0C")) ).value   == Decimal("246.15")*Decimal("246.15")
          assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  Measure(value=-27,unit=Unit("\u00B0C")) ).error   == error
          assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  Measure(value=-27,unit=Unit("\u00B0C")) ).implied == True
          assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  Measure(value=-27,unit=Unit("\u00B0C")) ).units.symbols   == Unit("K^2").symbols
          assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  Measure(value=-27,unit=Unit("\u00B0C")) ).units.magnitude == Unit("K^2").magnitude
          assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  Measure(value=-27,unit=Unit("\u00B0C")) ) == Measure(units=Unit("K^2"), value= Decimal("246.15")*Decimal("246.15"), error=error)
        # Canceling Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Measure(value=4,error=2,unit=Unit("cm"))  *  Measure(value=3,unit=Unit("cm^-1"))  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0.5")**2 + Decimal(3)**2 * Decimal(2)**2) )
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  Measure(value=3,unit=Unit("cm^-1"))  ).value   == 12
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  Measure(value=3,unit=Unit("cm^-1"))  ).error   == error
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  Measure(value=3,unit=Unit("cm^-1"))  ).implied == True
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  Measure(value=3,unit=Unit("cm^-1"))  ).units.symbols   == Unit().symbols
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  Measure(value=3,unit=Unit("cm^-1"))  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  Measure(value=3,unit=Unit("cm^-1"))  ) == Measure(units=Unit(), value= 12, error=error)
          # Value 2: Float
          assert isinstance( ( Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  Measure(value=0.3,unit=Unit("cm^-1"))  ), Measure )
          error = measure._sqrt_( (0.4**2 * 0.05**2 + 0.3**2 * 0.2**2) )
          assert math.isclose( (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  Measure(value=0.3,unit=Unit("cm^-1"))  ).value , 0.3*0.4 )
          assert math.isclose( (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  Measure(value=0.3,unit=Unit("cm^-1"))  ).error , error   )
          assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  Measure(value=0.3,unit=Unit("cm^-1"))  ).implied == True
          assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  Measure(value=0.3,unit=Unit("cm^-1"))  ).units.symbols   == Unit().symbols
          assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  Measure(value=0.3,unit=Unit("cm^-1"))  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  Measure(value=0.3,unit=Unit("cm^-1"))  ) == Measure(units=Unit(), value= 0.3*0.4, error=error)
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),unit=Unit("cm^-1"))  ), Measure )
          error = measure._sqrt_( (Decimal("40")**2 * Decimal("5")**2 + Decimal("30")**2 * Decimal("20")**2) )
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),unit=Unit("cm^-1"))  ).value   == Decimal("1200")
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),unit=Unit("cm^-1"))  ).error   == error
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),unit=Unit("cm^-1"))  ).implied == True
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),unit=Unit("cm^-1"))  ).units.symbols   == Unit().symbols
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),unit=Unit("cm^-1"))  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),unit=Unit("cm^-1"))  ) == Measure(units=Unit(), value= Decimal("1200"), error=error)
          # Value 4: Negative
          assert isinstance( ( Measure(value=-4,error=2,unit=Unit("cm"))  *  Measure(value=-3,unit=Unit("cm^-1"))  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0.5")**2 + Decimal(3)**2 * Decimal(2)**2) )
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  Measure(value=-3,unit=Unit("cm^-1"))  ).value   == 12
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  Measure(value=-3,unit=Unit("cm^-1"))  ).error   == error
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  Measure(value=-3,unit=Unit("cm^-1"))  ).implied == True
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  Measure(value=-3,unit=Unit("cm^-1"))  ).units.symbols   == Unit().symbols
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  Measure(value=-3,unit=Unit("cm^-1"))  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  Measure(value=-3,unit=Unit("cm^-1"))  ) == Measure(units=Unit(), value= 12, error=error)
        # Preserve Inputs
        if(True):
          a = Measure(value=4,error=2,unit=Unit("cm"))
          b = Measure(value=3,unit=Unit("cm"))
          c = a*b
          c = None
          assert a == Measure(value=4,error=2,unit=Unit("cm"))
          assert b == Measure(value=3,unit=Unit("cm"))
    # Measure (Implicit Error) * Measure (Explicit Error) = Measure (Implicit Error)
    if(True):
      # Unitless * Unitless
      if(True):
        # Value 1: Int
        assert isinstance( ( Measure(value=4)  *  Measure(value=3,error=2)  ), Measure )
        error = measure._sqrt_( (Decimal(4)**2 * Decimal("2")**2 + Decimal(3)**2 * Decimal("0.5")**2) )
        assert (  Measure(value=4)  *  Measure(value=3,error=2)  ).value   == 12
        assert (  Measure(value=4)  *  Measure(value=3,error=2)  ).error   == error
        assert (  Measure(value=4)  *  Measure(value=3,error=2)  ).implied == True
        assert (  Measure(value=4)  *  Measure(value=3,error=2)  ).units.symbols   == Unit().symbols
        assert (  Measure(value=4)  *  Measure(value=3,error=2)  ).units.magnitude == Unit().magnitude
        assert (  Measure(value=4)  *  Measure(value=3,error=2)  ) == Measure(units=Unit(), value= 12, error=error)
        # Value 2: Float
        assert isinstance( ( Measure(value=0.4)  *  Measure(value=0.3,error=0.2)  ), Measure )
        error = measure._sqrt_( (0.4**2 * 0.2**2 + 0.3**2 * 0.05**2) )
        assert math.isclose( (  Measure(value=0.4)  *  Measure(value=0.3,error=0.2)  ).value , 0.4*0.3 )
        assert math.isclose( (  Measure(value=0.4)  *  Measure(value=0.3,error=0.2)  ).error , error   )
        assert (  Measure(value=0.4)  *  Measure(value=0.3,error=0.2)  ).implied == True
        assert (  Measure(value=0.4)  *  Measure(value=0.3,error=0.2)  ).units.symbols   == Unit().symbols
        assert (  Measure(value=0.4)  *  Measure(value=0.3,error=0.2)  ).units.magnitude == Unit().magnitude
        assert (  Measure(value=0.4)  *  Measure(value=0.3,error=0.2)  ) == Measure(units=Unit(), value= 0.4*0.3, error=error)
        # Value 3: Decimal
        assert isinstance( (  Measure(value=Decimal("40"))  *  Measure(value=Decimal("30"),error=Decimal("20"))  ), Measure )
        error = measure._sqrt_( ( Decimal("40")**2 * Decimal("20")**2 + Decimal("30")**2 * Decimal("5")**2) )
        assert (  Measure(value=Decimal("40"))  *  Measure(value=Decimal("30"),error=Decimal("20"))  ).value   == Decimal("1200")
        assert (  Measure(value=Decimal("40"))  *  Measure(value=Decimal("30"),error=Decimal("20"))  ).error   == error
        assert (  Measure(value=Decimal("40"))  *  Measure(value=Decimal("30"),error=Decimal("20"))  ).implied == True
        assert (  Measure(value=Decimal("40"))  *  Measure(value=Decimal("30"),error=Decimal("20"))  ).units.symbols   == Unit().symbols
        assert (  Measure(value=Decimal("40"))  *  Measure(value=Decimal("30"),error=Decimal("20"))  ).units.magnitude == Unit().magnitude
        assert (  Measure(value=Decimal("40"))  *  Measure(value=Decimal("30"),error=Decimal("20"))  ) == Measure(units=Unit(), value= Decimal("1200"), error=error)
        # Value 4: Negative
        assert isinstance( ( Measure(value=-4)  *  Measure(value=-3,error=2)  ), Measure )
        error = measure._sqrt_( (Decimal(4)**2 * Decimal("2")**2 + Decimal(3)**2 * Decimal("0.5")**2) )
        assert (  Measure(value=-4)  *  Measure(value=-3,error=2)  ).value   == 12
        assert (  Measure(value=-4)  *  Measure(value=-3,error=2)  ).error   == error
        assert (  Measure(value=-4)  *  Measure(value=-3,error=2)  ).implied == True
        assert (  Measure(value=-4)  *  Measure(value=-3,error=2)  ).units.symbols   == Unit().symbols
        assert (  Measure(value=-4)  *  Measure(value=-3,error=2)  ).units.magnitude == Unit().magnitude
        assert (  Measure(value=-4)  *  Measure(value=-3,error=2)  ) == Measure(units=Unit(), value= 12, error=error)
        # Preserve Inputs
        if(True):
          a = Measure(value=4) 
          b = Measure(value=3,error=2)
          c = a*b
          c = None
          assert a == Measure(value=4) 
          assert b == Measure(value=3,error=2)
      # Unitless * Unit
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          assert isinstance( (  Measure(value=3)  *  Measure(value=4,error=2,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0.5")**2 + Decimal(3)**2 * Decimal(2)**2) )
          assert (  Measure(value=3)  *  Measure(value=4,error=2,unit=Unit("cm"))  ).value   == 12
          assert (  Measure(value=3)  *  Measure(value=4,error=2,unit=Unit("cm"))  ).error   == error
          assert (  Measure(value=3)  *  Measure(value=4,error=2,unit=Unit("cm"))  ).implied == True
          assert (  Measure(value=3)  *  Measure(value=4,error=2,unit=Unit("cm"))  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=3)  *  Measure(value=4,error=2,unit=Unit("cm"))  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=3)  *  Measure(value=4,error=2,unit=Unit("cm"))  ) == Measure(units=Unit("cm"), value= 12, error=error)
          # Value 2: Float
          assert isinstance( (  Measure(value=0.3)  *  Measure(value=0.4,error=0.2,unit=Unit("cm")) ), Measure )
          error = measure._sqrt_( (0.4**2 * 0.05**2 + 0.3**2 * 0.2**2) )
          assert math.isclose( (  Measure(value=0.3)  *  Measure(value=0.4,error=0.2,unit=Unit("cm"))  ).value , 0.3*0.4 )
          assert math.isclose( (  Measure(value=0.3)  *  Measure(value=0.4,error=0.2,unit=Unit("cm"))  ).error , error   )
          assert (  Measure(value=0.3)  *  Measure(value=0.4,error=0.2,unit=Unit("cm"))  ).implied == True
          assert (  Measure(value=0.3)  *  Measure(value=0.4,error=0.2,unit=Unit("cm"))  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=0.3)  *  Measure(value=0.4,error=0.2,unit=Unit("cm"))  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=0.3)  *  Measure(value=0.4,error=0.2,unit=Unit("cm"))  ) == Measure(units=Unit("cm"), value= 0.3*0.4, error=error)
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("40"))  *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( ( Decimal("40")**2 * Decimal("20")**2 + Decimal("30")**2 * Decimal("5")**2) )
          assert (  Measure(value=Decimal("40"))  *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm"))  ).value   == Decimal("1200")
          assert (  Measure(value=Decimal("40"))  *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm"))  ).error   == error
          assert (  Measure(value=Decimal("40"))  *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm"))  ).implied == True
          assert (  Measure(value=Decimal("40"))  *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm"))  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=Decimal("40"))  *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm"))  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=Decimal("40"))  *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm"))  ) == Measure(units=Unit("cm"), value= Decimal("1200"), error=error)
          # Value 4: Negative
          assert isinstance( (  Measure(value=-3)  *  Measure(value=-4,error=2,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0.5")**2 + Decimal(3)**2 * Decimal(2)**2) )
          assert (  Measure(value=-3)  *  Measure(value=-4,error=2,unit=Unit("cm"))  ).value   == 12
          assert (  Measure(value=-3)  *  Measure(value=-4,error=2,unit=Unit("cm"))  ).error   == error
          assert (  Measure(value=-3)  *  Measure(value=-4,error=2,unit=Unit("cm"))  ).implied == True
          assert (  Measure(value=-3)  *  Measure(value=-4,error=2,unit=Unit("cm"))  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=-3)  *  Measure(value=-4,error=2,unit=Unit("cm"))  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=-3)  *  Measure(value=-4,error=2,unit=Unit("cm"))  ) == Measure(units=Unit("cm"), value= 12, error=error)
        # Magnitude Units
        if(True):
          # Value 1: Int
          assert isinstance( (  Measure(value=5)  *  Measure(value=2,error=1,unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (Decimal(5)**2 * Decimal(5)**2 + Decimal(10)**2 * Decimal("0.5")**2) )/Decimal(5)
          assert (  Measure(value=5)  *  Measure(value=2,error=1,unit=Unit("5 m^2"))  ) == Measure(units=Unit("5 m^2"), value=10, error=error)
          assert (  Measure(value=5)  *  Measure(value=2,error=1,unit=Unit("5 m^2"))  ).value   == 10
          assert (  Measure(value=5)  *  Measure(value=2,error=1,unit=Unit("5 m^2"))  ).error   == error
          assert (  Measure(value=5)  *  Measure(value=2,error=1,unit=Unit("5 m^2"))  ).implied == True
          assert (  Measure(value=5)  *  Measure(value=2,error=1,unit=Unit("5 m^2"))  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=5)  *  Measure(value=2,error=1,unit=Unit("5 m^2"))  ).units.magnitude == Unit("5 m^2").magnitude
          # Value 2: Float
          assert isinstance( (  Measure(value=0.5)  *  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (0.5**2 * 0.5**2 + 1.0**2 * 0.05**2) )/5
          assert (  Measure(value=0.5)  *  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  ) == Measure(units=Unit("5 m^2"), value=0.1, error=error)
          assert math.isclose( (  Measure(value=0.5)  *  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  ).value , 0.1   )
          assert math.isclose( (  Measure(value=0.5)  *  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  ).error , error )
          assert (  Measure(value=0.5)  *  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  ).implied == True
          assert (  Measure(value=0.5)  *  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=0.5)  *  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  ).units.magnitude == Unit("5 m^2").magnitude
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("50"))  *  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (Decimal("50")**2 * Decimal("25")**2 + Decimal("100")**2 * Decimal("5")**2) )/Decimal("5")
          assert (  Measure(value=Decimal("50"))  *  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  ) == Measure(units=Unit("5 m^2"), value=Decimal("1000"), error=error)
          assert (  Measure(value=Decimal("50"))  *  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  ).value   == Decimal("1000")
          assert (  Measure(value=Decimal("50"))  *  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  ).error   == error
          assert (  Measure(value=Decimal("50"))  *  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  ).implied == True
          assert (  Measure(value=Decimal("50"))  *  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=Decimal("50"))  *  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  ).units.magnitude == Unit("5 m^2").magnitude
          # Value 4: Negative
          assert isinstance( (  Measure(value=-5)  *  Measure(value=-2,error=1,unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (Decimal(5)**2 * Decimal(5)**2 + Decimal(10)**2 * Decimal("0.5")**2) )/Decimal(5)
          assert (  Measure(value=-5)  *  Measure(value=-2,error=1,unit=Unit("5 m^2"))  ) == Measure(units=Unit("5 m^2"), value=10, error=error)
          assert (  Measure(value=-5)  *  Measure(value=-2,error=1,unit=Unit("5 m^2"))  ).value   == 10
          assert (  Measure(value=-5)  *  Measure(value=-2,error=1,unit=Unit("5 m^2"))  ).error   == error
          assert (  Measure(value=-5)  *  Measure(value=-2,error=1,unit=Unit("5 m^2"))  ).implied == True
          assert (  Measure(value=-5)  *  Measure(value=-2,error=1,unit=Unit("5 m^2"))  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=-5)  *  Measure(value=-2,error=1,unit=Unit("5 m^2"))  ).units.magnitude == Unit("5 m^2").magnitude
        # Convoluted Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Measure(value=300)  *  Measure(value=27,error=1,unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (Decimal("300")**2 * Decimal("1")**2 + Decimal("300.15")**2 * Decimal("50")**2) )
          assert ( Measure(value=300)  *  Measure(value=27,error=1,unit=Unit("\u00B0C")) ).value   == Decimal("300.15")*Decimal("300") - Decimal("273.15")
          assert ( Measure(value=300)  *  Measure(value=27,error=1,unit=Unit("\u00B0C")) ).error   == error
          assert ( Measure(value=300)  *  Measure(value=27,error=1,unit=Unit("\u00B0C")) ).implied == True
          assert ( Measure(value=300)  *  Measure(value=27,error=1,unit=Unit("\u00B0C")) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=300)  *  Measure(value=27,error=1,unit=Unit("\u00B0C")) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=300)  *  Measure(value=27,error=1,unit=Unit("\u00B0C")) ) == Measure(units=Unit("\u00B0C"), value= Decimal("300.15")*Decimal("300") - Decimal("273.15"), error=error)
          # Value 2: Float
          assert isinstance( ( Measure(value=299.9)  *  Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (299.9**2 * 0.02**2 + 300**2 * 0.05**2) )
          assert math.isclose( ( Measure(value=299.9)  *  Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).value   , 299.9 * 300 - 273.15 )
          assert math.isclose( ( Measure(value=299.9)  *  Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).error   , error )
          assert ( Measure(value=299.9)  *  Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).implied == True
          assert ( Measure(value=299.9)  *  Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=299.9)  *  Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=299.9)  *  Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ) == Measure(units=Unit("\u00B0C"), value=299.9 * 300 - 273.15, error=error)
          # Value 3: Decimal
          assert isinstance( ( Measure(value=Decimal("300"))  *  Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (Decimal("300")**2 * Decimal("0.02")**2 + Decimal("300")**2 * Decimal("50")**2) )
          assert ( Measure(value=Decimal("300"))  *  Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).value   == Decimal("300") * Decimal("300") - Decimal("273.15") 
          assert ( Measure(value=Decimal("300"))  *  Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).error   == error
          assert ( Measure(value=Decimal("300"))  *  Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).implied == True
          assert ( Measure(value=Decimal("300"))  *  Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=Decimal("300"))  *  Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=Decimal("300"))  *  Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ) == Measure(units=Unit("\u00B0C"), value=Decimal("300") * Decimal("300") - Decimal("273.15"), error=error)
          # Value 4: Negative
          assert isinstance( ( Measure(value=300)  *  Measure(value=-27,error=1,unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (Decimal("300")**2 * Decimal("1")**2 + Decimal("246.15")**2 * Decimal("50")**2) )
          assert ( Measure(value=300)  *  Measure(value=-27,error=1,unit=Unit("\u00B0C")) ).value   == Decimal("246.15")*Decimal("300") - Decimal("273.15")
          assert ( Measure(value=300)  *  Measure(value=-27,error=1,unit=Unit("\u00B0C")) ).error   == error
          assert ( Measure(value=300)  *  Measure(value=-27,error=1,unit=Unit("\u00B0C")) ).implied == True
          assert ( Measure(value=300)  *  Measure(value=-27,error=1,unit=Unit("\u00B0C")) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=300)  *  Measure(value=-27,error=1,unit=Unit("\u00B0C")) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=300)  *  Measure(value=-27,error=1,unit=Unit("\u00B0C")) ) == Measure(units=Unit("\u00B0C"), value= Decimal("246.15")*Decimal("300") - Decimal("273.15"), error=error)
        # Preserve Inputs
        if(True):
          a = Measure(value=3) 
          b = Measure(value=4,error=2,unit=Unit("cm"))
          c = a*b
          c = None
          assert a == Measure(value=3) 
          assert b == Measure(value=4,error=2,unit=Unit("cm"))
      # Unit * Unitless
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Measure(value=4,unit=Unit("cm"))  *  Measure(value=3,error=2)  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("2")**2 + Decimal(3)**2 * Decimal("0.5")**2) )
          assert (  Measure(value=4,unit=Unit("cm"))  *  Measure(value=3,error=2)  ).value   == 12
          assert (  Measure(value=4,unit=Unit("cm"))  *  Measure(value=3,error=2)  ).error   == error
          assert (  Measure(value=4,unit=Unit("cm"))  *  Measure(value=3,error=2)  ).implied == True
          assert (  Measure(value=4,unit=Unit("cm"))  *  Measure(value=3,error=2)  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=4,unit=Unit("cm"))  *  Measure(value=3,error=2)  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=4,unit=Unit("cm"))  *  Measure(value=3,error=2)  ) == Measure(units=Unit("cm"), value= 12, error=error)
          # Value 2: Float
          assert isinstance( ( Measure(value=0.4,unit=Unit("cm"))  *  Measure(value=0.3,error=0.2)  ), Measure )
          error = measure._sqrt_( (0.4**2 * 0.2**2 + 0.3**2 * 0.05**2) )
          assert math.isclose( (  Measure(value=0.4,unit=Unit("cm"))  *  Measure(value=0.3,error=0.2)  ).value , 0.3*0.4 )
          assert math.isclose( (  Measure(value=0.4,unit=Unit("cm"))  *  Measure(value=0.3,error=0.2)  ).error , error   )
          assert (  Measure(value=0.4,unit=Unit("cm"))  *  Measure(value=0.3,error=0.2)  ).implied == True
          assert (  Measure(value=0.4,unit=Unit("cm"))  *  Measure(value=0.3,error=0.2)  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=0.4,unit=Unit("cm"))  *  Measure(value=0.3,error=0.2)  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=0.4,unit=Unit("cm"))  *  Measure(value=0.3,error=0.2)  ) == Measure(units=Unit("cm"), value= 0.3*0.4, error=error)
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),error=Decimal("20"))  ), Measure )
          error = measure._sqrt_( ( Decimal("40")**2 * Decimal("20")**2 + Decimal("30")**2 * Decimal("5")**2) )
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),error=Decimal("20"))  ).value   == Decimal("1200")
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),error=Decimal("20"))  ).error   == error
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),error=Decimal("20"))  ).implied == True
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),error=Decimal("20"))  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),error=Decimal("20"))  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),error=Decimal("20"))  ) == Measure(units=Unit("cm"), value= Decimal("1200"), error=error)
          # Value 4: Negative
          assert isinstance( ( Measure(value=-4,unit=Unit("cm"))  *  Measure(value=-3,error=2)  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("2")**2 + Decimal(3)**2 * Decimal("0.5")**2) )
          assert (  Measure(value=-4,unit=Unit("cm"))  *  Measure(value=-3,error=2)  ).value   == 12
          assert (  Measure(value=-4,unit=Unit("cm"))  *  Measure(value=-3,error=2)  ).error   == error
          assert (  Measure(value=-4,unit=Unit("cm"))  *  Measure(value=-3,error=2)  ).implied == True
          assert (  Measure(value=-4,unit=Unit("cm"))  *  Measure(value=-3,error=2)  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=-4,unit=Unit("cm"))  *  Measure(value=-3,error=2)  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=-4,unit=Unit("cm"))  *  Measure(value=-3,error=2)  ) == Measure(units=Unit("cm"), value= 12, error=error)
        # Magnitude Units
        if(True):
          # Value 1: Int
          assert isinstance( (  Measure(value=2,unit=Unit("5 m^2"))  *  Measure(value=5,error=1)  ) , Measure )
          error = measure._sqrt_( (Decimal(5)**2 * Decimal("2.5")**2 + Decimal(10)**2 * Decimal(1)**2) )/Decimal(5)
          assert (  Measure(value=2,unit=Unit("5 m^2"))  *  Measure(value=5,error=1)  ) == Measure(units=Unit("5 m^2"), value=10, error=error)
          assert (  Measure(value=2,unit=Unit("5 m^2"))  *  Measure(value=5,error=1)  ).value   == 10
          assert Measure._dec_isclose_( (  Measure(value=2,unit=Unit("5 m^2"))  *  Measure(value=5,error=1)  ).error  , error )
          assert (  Measure(value=2,unit=Unit("5 m^2"))  *  Measure(value=5,error=1)  ).implied == True
          assert (  Measure(value=2,unit=Unit("5 m^2"))  *  Measure(value=5,error=1)  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=2,unit=Unit("5 m^2"))  *  Measure(value=5,error=1)  ).units.magnitude == Unit("5 m^2").magnitude
          # Value 2: Float
          assert isinstance( (  Measure(value=0.2,unit=Unit("5 m^2"))  *  Measure(value=0.5,error=0.1)  ) , Measure )
          error = measure._sqrt_( (0.5**2 * 0.25**2 + 1.0**2 * 0.1**2) )/5
          assert (  Measure(value=0.2,unit=Unit("5 m^2"))  *  Measure(value=0.5,error=0.1)  ) == Measure(units=Unit("5 m^2"), value=0.1, error=error)
          assert math.isclose( (  Measure(value=0.2,unit=Unit("5 m^2"))  *  Measure(value=0.5,error=0.1)  ).value , 0.1   )
          assert math.isclose( (  Measure(value=0.2,unit=Unit("5 m^2"))  *  Measure(value=0.5,error=0.1)  ).error , error )
          assert (  Measure(value=0.2,unit=Unit("5 m^2"))  *  Measure(value=0.5,error=0.1)  ).implied == True
          assert (  Measure(value=0.2,unit=Unit("5 m^2"))  *  Measure(value=0.5,error=0.1)  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=0.2,unit=Unit("5 m^2"))  *  Measure(value=0.5,error=0.1)  ).units.magnitude == Unit("5 m^2").magnitude
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  Measure(value=Decimal("50"),error=Decimal("2"))  ) , Measure )
          error = measure._sqrt_( (Decimal("50")**2 * Decimal("25")**2 + Decimal("100")**2 * Decimal("2")**2) )/Decimal("5")
          assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  Measure(value=Decimal("50"),error=Decimal("2"))  ) == Measure(units=Unit("5 m^2"), value=Decimal("1000"), error=error)
          assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  Measure(value=Decimal("50"),error=Decimal("2"))  ).value   == Decimal("1000")
          assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  Measure(value=Decimal("50"),error=Decimal("2"))  ).error   == error
          assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  Measure(value=Decimal("50"),error=Decimal("2"))  ).implied == True
          assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  Measure(value=Decimal("50"),error=Decimal("2"))  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  Measure(value=Decimal("50"),error=Decimal("2"))  ).units.magnitude == Unit("5 m^2").magnitude
          # Value 4: Negative
          assert isinstance( (  Measure(value=-2,unit=Unit("5 m^2"))  *  Measure(value=-5,error=1)  ) , Measure )
          error = measure._sqrt_( (Decimal(5)**2 * Decimal("2.5")**2 + Decimal(10)**2 * Decimal(1)**2) )/Decimal(5)
          assert (  Measure(value=-2,unit=Unit("5 m^2"))  *  Measure(value=-5,error=1)  ) == Measure(units=Unit("5 m^2"), value=10, error=error)
          assert (  Measure(value=-2,unit=Unit("5 m^2"))  *  Measure(value=-5,error=1)  ).value   == 10
          assert Measure._dec_isclose_( (  Measure(value=-2,unit=Unit("5 m^2"))  *  Measure(value=-5,error=1)  ).error   , error )
          assert (  Measure(value=-2,unit=Unit("5 m^2"))  *  Measure(value=-5,error=1)  ).implied == True
          assert (  Measure(value=-2,unit=Unit("5 m^2"))  *  Measure(value=-5,error=1)  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=-2,unit=Unit("5 m^2"))  *  Measure(value=-5,error=1)  ).units.magnitude == Unit("5 m^2").magnitude
        # Convoluted Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Measure(value=27,unit=Unit("\u00B0C"))  *  Measure(value=300,error=2) ), Measure )
          error = measure._sqrt_( (Decimal("300")**2 * Decimal("0.5")**2 + Decimal("300.15")**2 * Decimal("2")**2) )
          assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  Measure(value=300,error=2) ).value   == Decimal("300.15")*Decimal("300") - Decimal("273.15")
          assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  Measure(value=300,error=2) ).error   == error
          assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  Measure(value=300,error=2) ).implied == True
          assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  Measure(value=300,error=2) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  Measure(value=300,error=2) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  Measure(value=300,error=2) ) == Measure(units=Unit("\u00B0C"), value= Decimal("300.15")*Decimal("300") - Decimal("273.15"), error=error)
          # Value 2: Float
          assert isinstance( ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  Measure(value=299.9,error=0.02) ), Measure )
          error = measure._sqrt_( (299.9**2 * 0.005**2 + 300**2 * 0.02**2) )
          assert math.isclose( ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  Measure(value=299.9,error=0.02) ).value , 299.9 * 300 - 273.15 )
          assert math.isclose( ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  Measure(value=299.9,error=0.02) ).error , error )
          assert ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  Measure(value=299.9,error=0.02) ).implied == True
          assert ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  Measure(value=299.9,error=0.02) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  Measure(value=299.9,error=0.02) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  Measure(value=299.9,error=0.02) ) == Measure(units=Unit("\u00B0C"), value=299.9 * 300 - 273.15, error=error)
          # Value 3: Decimal
          assert isinstance( ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  Measure(value=Decimal("300"),error=Decimal("0.02")) ), Measure )
          error = measure._sqrt_( (Decimal("300")**2 * Decimal("0.005")**2 + Decimal("300")**2 * Decimal("0.02")**2) )
          assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  Measure(value=Decimal("300"),error=Decimal("0.02")) ).value   == Decimal("300") * Decimal("300") - Decimal("273.15") 
          assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  Measure(value=Decimal("300"),error=Decimal("0.02")) ).error   == error
          assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  Measure(value=Decimal("300"),error=Decimal("0.02")) ).implied == True
          assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  Measure(value=Decimal("300"),error=Decimal("0.02")) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  Measure(value=Decimal("300"),error=Decimal("0.02")) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  Measure(value=Decimal("300"),error=Decimal("0.02")) ) == Measure(units=Unit("\u00B0C"), value=Decimal("300") * Decimal("300") - Decimal("273.15"), error=error)
          # Value 4: Negative
          assert isinstance( ( Measure(value=-27,unit=Unit("\u00B0C"))  *  Measure(value=300,error=2) ), Measure )
          error = measure._sqrt_( (Decimal("300")**2 * Decimal("0.5")**2 + Decimal("246.15")**2 * Decimal("2")**2) )
          assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  Measure(value=300,error=2) ).value   == Decimal("246.15")*Decimal("300") - Decimal("273.15")
          assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  Measure(value=300,error=2) ).error   == error
          assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  Measure(value=300,error=2) ).implied == True
          assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  Measure(value=300,error=2) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  Measure(value=300,error=2) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  Measure(value=300,error=2) ) == Measure(units=Unit("\u00B0C"), value= Decimal("246.15")*Decimal("300") - Decimal("273.15"), error=error)
        # Preserve Inputs
        if(True):
          a = Measure(value=4,unit=Unit("cm"))
          b = Measure(value=3,error=2)
          c = a*b
          c = None
          assert a == Measure(value=4,unit=Unit("cm")) 
          assert b == Measure(value=3,error=2)
      # Units * Units
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Measure(value=4,unit=Unit("cm"))  *  Measure(value=3,error=2,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("2")**2 + Decimal(3)**2 * Decimal("0.5")**2) )
          assert (  Measure(value=4,unit=Unit("cm"))  *  Measure(value=3,error=2,unit=Unit("cm"))  ).value   == 12
          assert (  Measure(value=4,unit=Unit("cm"))  *  Measure(value=3,error=2,unit=Unit("cm"))  ).error   == error
          assert (  Measure(value=4,unit=Unit("cm"))  *  Measure(value=3,error=2,unit=Unit("cm"))  ).implied == True
          assert (  Measure(value=4,unit=Unit("cm"))  *  Measure(value=3,error=2,unit=Unit("cm"))  ).units.symbols   == Unit("cm^2").symbols
          assert (  Measure(value=4,unit=Unit("cm"))  *  Measure(value=3,error=2,unit=Unit("cm"))  ).units.magnitude == Unit("cm^2").magnitude
          assert (  Measure(value=4,unit=Unit("cm"))  *  Measure(value=3,error=2,unit=Unit("cm"))  ) == Measure(units=Unit("cm^2"), value= 12, error=error)
          # Value 2: Float
          assert isinstance( ( Measure(value=0.4,unit=Unit("cm"))  *  Measure(value=0.3,error=0.2,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (0.4**2 * 0.2**2 + 0.3**2 * 0.05**2) )
          assert math.isclose( (  Measure(value=0.4,unit=Unit("cm"))  *  Measure(value=0.3,error=0.2,unit=Unit("cm"))  ).value , 0.3*0.4 )
          assert math.isclose( (  Measure(value=0.4,unit=Unit("cm"))  *  Measure(value=0.3,error=0.2,unit=Unit("cm"))  ).error , error   )
          assert (  Measure(value=0.4,unit=Unit("cm"))  *  Measure(value=0.3,error=0.2,unit=Unit("cm"))  ).implied == True
          assert (  Measure(value=0.4,unit=Unit("cm"))  *  Measure(value=0.3,error=0.2,unit=Unit("cm"))  ).units.symbols   == Unit("cm^2").symbols
          assert (  Measure(value=0.4,unit=Unit("cm"))  *  Measure(value=0.3,error=0.2,unit=Unit("cm"))  ).units.magnitude == Unit("cm^2").magnitude
          assert (  Measure(value=0.4,unit=Unit("cm"))  *  Measure(value=0.3,error=0.2,unit=Unit("cm"))  ) == Measure(units=Unit("cm^2"), value= 0.3*0.4, error=error)
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( ( Decimal("40")**2 * Decimal("20")**2 + Decimal("30")**2 * Decimal("5")**2) )
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm"))  ).value   == Decimal("1200")
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm"))  ).error   == error
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm"))  ).implied == True
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm"))  ).units.symbols   == Unit("cm^2").symbols
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm"))  ).units.magnitude == Unit("cm^2").magnitude
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm"))  ) == Measure(units=Unit("cm^2"), value= Decimal("1200"), error=error)
          # Value 4: Negative
          assert isinstance( ( Measure(value=-4,unit=Unit("cm"))  *  Measure(value=-3,error=2,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("2")**2 + Decimal(3)**2 * Decimal("0.5")**2) )
          assert (  Measure(value=-4,unit=Unit("cm"))  *  Measure(value=-3,error=2,unit=Unit("cm"))  ).value   == 12
          assert (  Measure(value=-4,unit=Unit("cm"))  *  Measure(value=-3,error=2,unit=Unit("cm"))  ).error   == error
          assert (  Measure(value=-4,unit=Unit("cm"))  *  Measure(value=-3,error=2,unit=Unit("cm"))  ).implied == True
          assert (  Measure(value=-4,unit=Unit("cm"))  *  Measure(value=-3,error=2,unit=Unit("cm"))  ).units.symbols   == Unit("cm^2").symbols
          assert (  Measure(value=-4,unit=Unit("cm"))  *  Measure(value=-3,error=2,unit=Unit("cm"))  ).units.magnitude == Unit("cm^2").magnitude
          assert (  Measure(value=-4,unit=Unit("cm"))  *  Measure(value=-3,error=2,unit=Unit("cm"))  ) == Measure(units=Unit("cm^2"), value= 12, error=error)
        # Magnitude Units
        if(True):
          # Value 1: Int
          assert isinstance( (  Measure(value=2,unit=Unit("5 m^2"))  *  Measure(value=5,error=1,unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (Decimal(25)**2 * Decimal("2.5")**2 + Decimal(10)**2 * Decimal(5)**2) )/Decimal(25)
          assert (  Measure(value=2,unit=Unit("5 m^2"))  *  Measure(value=5,error=1,unit=Unit("5 m^2"))  ).value   == 10
          assert (  Measure(value=2,unit=Unit("5 m^2"))  *  Measure(value=5,error=1,unit=Unit("5 m^2"))  ).error   == error
          assert (  Measure(value=2,unit=Unit("5 m^2"))  *  Measure(value=5,error=1,unit=Unit("5 m^2"))  ).implied == True
          assert (  Measure(value=2,unit=Unit("5 m^2"))  *  Measure(value=5,error=1,unit=Unit("5 m^2"))  ).units.symbols   == Unit("25 m^4").symbols
          assert (  Measure(value=2,unit=Unit("5 m^2"))  *  Measure(value=5,error=1,unit=Unit("5 m^2"))  ).units.magnitude == Unit("25 m^4").magnitude
          assert (  Measure(value=2,unit=Unit("5 m^2"))  *  Measure(value=5,error=1,unit=Unit("5 m^2"))  ) == Measure(units=Unit("25 m^4"), value=10, error=error)
          # Value 2: Float
          assert isinstance( (  Measure(value=0.2,unit=Unit("5 m^2"))  *  Measure(value=0.5,error=0.1,unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (2.5**2 * 0.25**2 + 1.0**2 * 0.5**2) )/25
          assert math.isclose( (  Measure(value=0.2,unit=Unit("5 m^2"))  *  Measure(value=0.5,error=0.1,unit=Unit("5 m^2"))  ).value , 0.1   )
          assert math.isclose( (  Measure(value=0.2,unit=Unit("5 m^2"))  *  Measure(value=0.5,error=0.1,unit=Unit("5 m^2"))  ).error , error )
          assert (  Measure(value=0.2,unit=Unit("5 m^2"))  *  Measure(value=0.5,error=0.1,unit=Unit("5 m^2"))  ).implied == True
          assert (  Measure(value=0.2,unit=Unit("5 m^2"))  *  Measure(value=0.5,error=0.1,unit=Unit("5 m^2"))  ).units.symbols   == Unit("25 m^4").symbols
          assert (  Measure(value=0.2,unit=Unit("5 m^2"))  *  Measure(value=0.5,error=0.1,unit=Unit("5 m^2"))  ).units.magnitude == Unit("25 m^4").magnitude
          assert (  Measure(value=0.2,unit=Unit("5 m^2"))  *  Measure(value=0.5,error=0.1,unit=Unit("5 m^2"))  ) == Measure(units=Unit("25 m^4"), value=0.1, error=error)
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  Measure(value=Decimal("50"),error=Decimal("2"),unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (Decimal("250")**2 * Decimal("25")**2 + Decimal("100")**2 * Decimal("10")**2) )/Decimal("25")
          assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  Measure(value=Decimal("50"),error=Decimal("2"),unit=Unit("5 m^2"))  ) == Measure(units=Unit("25 m^4"), value=Decimal("1000"), error=error)
          assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  Measure(value=Decimal("50"),error=Decimal("2"),unit=Unit("5 m^2"))  ).value   == Decimal("1000")
          assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  Measure(value=Decimal("50"),error=Decimal("2"),unit=Unit("5 m^2"))  ).error   == error
          assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  Measure(value=Decimal("50"),error=Decimal("2"),unit=Unit("5 m^2"))  ).implied == True
          assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  Measure(value=Decimal("50"),error=Decimal("2"),unit=Unit("5 m^2"))  ).units.symbols   == Unit("25 m^4").symbols
          assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  Measure(value=Decimal("50"),error=Decimal("2"),unit=Unit("5 m^2"))  ).units.magnitude == Unit("25 m^4").magnitude
          # Value 4: Negative
          assert isinstance( (  Measure(value=-2,unit=Unit("5 m^2"))  *  Measure(value=-5,error=1,unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (Decimal(25)**2 * Decimal("2.5")**2 + Decimal(10)**2 * Decimal(5)**2) )/Decimal(25)
          assert (  Measure(value=-2,unit=Unit("5 m^2"))  *  Measure(value=-5,error=1,unit=Unit("5 m^2"))  ) == Measure(units=Unit("25 m^4"), value=10, error=error)
          assert (  Measure(value=-2,unit=Unit("5 m^2"))  *  Measure(value=-5,error=1,unit=Unit("5 m^2"))  ).value   == 10
          assert (  Measure(value=-2,unit=Unit("5 m^2"))  *  Measure(value=-5,error=1,unit=Unit("5 m^2"))  ).error   == error
          assert (  Measure(value=-2,unit=Unit("5 m^2"))  *  Measure(value=-5,error=1,unit=Unit("5 m^2"))  ).implied == True
          assert (  Measure(value=-2,unit=Unit("5 m^2"))  *  Measure(value=-5,error=1,unit=Unit("5 m^2"))  ).units.symbols   == Unit("25 m^4").symbols
          assert (  Measure(value=-2,unit=Unit("5 m^2"))  *  Measure(value=-5,error=1,unit=Unit("5 m^2"))  ).units.magnitude == Unit("25 m^4").magnitude
        # Convoluted Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Measure(value=27,unit=Unit("\u00B0C"))  *  Measure(value=27,error=2,unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (Decimal("300.15")**2 * Decimal("0.5")**2 + Decimal("300.15")**2 * Decimal("2")**2) )
          assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  Measure(value=27,error=2,unit=Unit("\u00B0C")) ).value   == Decimal("300.15")*Decimal("300.15")
          assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  Measure(value=27,error=2,unit=Unit("\u00B0C")) ).error   == error
          assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  Measure(value=27,error=2,unit=Unit("\u00B0C")) ).implied == True
          assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  Measure(value=27,error=2,unit=Unit("\u00B0C")) ).units.symbols   == Unit("K^2").symbols
          assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  Measure(value=27,error=2,unit=Unit("\u00B0C")) ).units.magnitude == Unit("K^2").magnitude
          assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  Measure(value=27,error=2,unit=Unit("\u00B0C")) ) == Measure(units=Unit("K^2"), value= Decimal("300.15")*Decimal("300.15"), error=error)
          # Value 2: Float
          assert isinstance( ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (300**2 * 0.005**2 + 300**2 * 0.02**2) )
          assert math.isclose( ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).value   , 300 * 300 )
          assert math.isclose( ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).error   , error )
          assert ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).implied == True 
          assert ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).units.symbols   == Unit("K^2").symbols
          assert ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).units.magnitude == Unit("K^2").magnitude
          assert ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ) == Measure(units=Unit("K^2"), value=300 * 300, error=error)
          # Value 3: Decimal
          assert isinstance( ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (Decimal("300")**2 * Decimal("0.005")**2 + Decimal("300")**2 * Decimal("0.02")**2) )
          assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).value   == Decimal("300") * Decimal("300") 
          assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).error   == error
          assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).implied == True
          assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).units.symbols   == Unit("K^2").symbols
          assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).units.magnitude == Unit("K^2").magnitude
          assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ) == Measure(units=Unit("K^2"), value=Decimal("300") * Decimal("300"), error=error)
          # Value 4: Negative
          assert isinstance( ( Measure(value=-27,unit=Unit("\u00B0C"))  *  Measure(value=-27,error=2,unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (Decimal("246.15")**2 * Decimal("0.5")**2 + Decimal("246.15")**2 * Decimal("2")**2) )
          assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  Measure(value=-27,error=2,unit=Unit("\u00B0C")) ).value   == Decimal("246.15")*Decimal("246.15")
          assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  Measure(value=-27,error=2,unit=Unit("\u00B0C")) ).error   == error
          assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  Measure(value=-27,error=2,unit=Unit("\u00B0C")) ).implied == True
          assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  Measure(value=-27,error=2,unit=Unit("\u00B0C")) ).units.symbols   == Unit("K^2").symbols
          assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  Measure(value=-27,error=2,unit=Unit("\u00B0C")) ).units.magnitude == Unit("K^2").magnitude
          assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  Measure(value=-27,error=2,unit=Unit("\u00B0C")) ) == Measure(units=Unit("K^2"), value= Decimal("246.15")*Decimal("246.15"), error=error)
        # Canceling Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Measure(value=4,unit=Unit("cm"))  *  Measure(value=3,error=2,unit=Unit("cm^-1"))  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("2")**2 + Decimal(3)**2 * Decimal("0.5")**2) )
          assert (  Measure(value=4,unit=Unit("cm"))  *  Measure(value=3,error=2,unit=Unit("cm^-1"))  ).value   == 12
          assert (  Measure(value=4,unit=Unit("cm"))  *  Measure(value=3,error=2,unit=Unit("cm^-1"))  ).error   == error
          assert (  Measure(value=4,unit=Unit("cm"))  *  Measure(value=3,error=2,unit=Unit("cm^-1"))  ).implied == True
          assert (  Measure(value=4,unit=Unit("cm"))  *  Measure(value=3,error=2,unit=Unit("cm^-1"))  ).units.symbols   == Unit().symbols
          assert (  Measure(value=4,unit=Unit("cm"))  *  Measure(value=3,error=2,unit=Unit("cm^-1"))  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=4,unit=Unit("cm"))  *  Measure(value=3,error=2,unit=Unit("cm^-1"))  ) == Measure(units=Unit(), value= 12, error=error)
          # Value 2: Float
          assert isinstance( ( Measure(value=0.4,unit=Unit("cm"))  *  Measure(value=0.3,error=0.2,unit=Unit("cm^-1"))  ), Measure )
          error = measure._sqrt_( (0.4**2 * 0.2**2 + 0.3**2 * 0.05**2) )
          assert math.isclose( (  Measure(value=0.4,unit=Unit("cm"))  *  Measure(value=0.3,error=0.2,unit=Unit("cm^-1"))  ).value , 0.3*0.4 )
          assert math.isclose( (  Measure(value=0.4,unit=Unit("cm"))  *  Measure(value=0.3,error=0.2,unit=Unit("cm^-1"))  ).error , error   )
          assert (  Measure(value=0.4,unit=Unit("cm"))  *  Measure(value=0.3,error=0.2,unit=Unit("cm^-1"))  ).implied == True
          assert (  Measure(value=0.4,unit=Unit("cm"))  *  Measure(value=0.3,error=0.2,unit=Unit("cm^-1"))  ).units.symbols   == Unit().symbols
          assert (  Measure(value=0.4,unit=Unit("cm"))  *  Measure(value=0.3,error=0.2,unit=Unit("cm^-1"))  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=0.4,unit=Unit("cm"))  *  Measure(value=0.3,error=0.2,unit=Unit("cm^-1"))  ) == Measure(units=Unit(), value= 0.3*0.4, error=error)
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm^-1"))  ), Measure )
          error = measure._sqrt_( ( Decimal("40")**2 * Decimal("20")**2 + Decimal("30")**2 * Decimal("5")**2) )
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm^-1"))  ).value   == Decimal("1200")
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm^-1"))  ).error   == error
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm^-1"))  ).implied == True
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm^-1"))  ).units.symbols   == Unit().symbols
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm^-1"))  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm^-1"))  ) == Measure(units=Unit(), value= Decimal("1200"), error=error)
          # Value 4: Negative
          assert isinstance( ( Measure(value=-4,unit=Unit("cm"))  *  Measure(value=-3,error=2,unit=Unit("cm^-1"))  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("2")**2 + Decimal(3)**2 * Decimal("0.5")**2) )
          assert (  Measure(value=-4,unit=Unit("cm"))  *  Measure(value=-3,error=2,unit=Unit("cm^-1"))  ).value   == 12
          assert (  Measure(value=-4,unit=Unit("cm"))  *  Measure(value=-3,error=2,unit=Unit("cm^-1"))  ).error   == error
          assert (  Measure(value=-4,unit=Unit("cm"))  *  Measure(value=-3,error=2,unit=Unit("cm^-1"))  ).implied == True
          assert (  Measure(value=-4,unit=Unit("cm"))  *  Measure(value=-3,error=2,unit=Unit("cm^-1"))  ).units.symbols   == Unit().symbols
          assert (  Measure(value=-4,unit=Unit("cm"))  *  Measure(value=-3,error=2,unit=Unit("cm^-1"))  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=-4,unit=Unit("cm"))  *  Measure(value=-3,error=2,unit=Unit("cm^-1"))  ) == Measure(units=Unit(), value= 12, error=error)
        # Preserve Inputs
        if(True):
          a = Measure(value=4,unit=Unit("cm"))
          b = Measure(value=3,error=2,unit=Unit("cm"))
          c = a*b
          c = None
          assert a == Measure(value=4,unit=Unit("cm"))
          assert b == Measure(value=3,error=2,unit=Unit("cm"))
    # Measure (Implicit Error) * Measure (Implicit Error) = Measure (Implicit Error)
    if(True):
      # Unitless * Unitless
      if(True):
        # Value 1: Int
        assert isinstance( ( Measure(value=4)  *  Measure(value=3)  ), Measure )
        error = measure._sqrt_( (Decimal("4")**2 * Decimal("0.5")**2 + Decimal("3")**2 * Decimal("0.5")**2) )
        assert (  Measure(value=4)  *  Measure(value=3)  ).value   == 12
        assert (  Measure(value=4)  *  Measure(value=3)  ).error   == error
        assert (  Measure(value=4)  *  Measure(value=3)  ).implied == True
        assert (  Measure(value=4)  *  Measure(value=3)  ).units.symbols   == Unit().symbols
        assert (  Measure(value=4)  *  Measure(value=3)  ).units.magnitude == Unit().magnitude
        assert (  Measure(value=4)  *  Measure(value=3)  ) == Measure(units=Unit(), value= 12, error=error)
        # Value 2: Float
        assert isinstance( ( Measure(value=0.4)  *  Measure(value=0.3)  ), Measure )
        error = measure._sqrt_( (0.4**2 * 0.05**2 + 0.3**2 * 0.05**2) )
        assert math.isclose( (  Measure(value=0.4)  *  Measure(value=0.3)  ).value , 0.4*0.3 )
        assert math.isclose( (  Measure(value=0.4)  *  Measure(value=0.3)  ).error , error   )
        assert (  Measure(value=0.4)  *  Measure(value=0.3)  ).implied == True
        assert (  Measure(value=0.4)  *  Measure(value=0.3)  ).units.symbols   == Unit().symbols
        assert (  Measure(value=0.4)  *  Measure(value=0.3)  ).units.magnitude == Unit().magnitude
        assert (  Measure(value=0.4)  *  Measure(value=0.3)  ) == Measure(units=Unit(), value= 0.4*0.3, error=error)
        # Value 3: Decimal
        assert isinstance( (  Measure(value=Decimal("40"))  *  Measure(value=Decimal("30"))  ), Measure )
        error = measure._sqrt_( (Decimal("40")**2 * Decimal("5")**2 + Decimal("30")**2 * Decimal("5")**2) )
        assert (  Measure(value=Decimal("40"))  *  Measure(value=Decimal("30"))  ).value   == Decimal("1200")
        assert (  Measure(value=Decimal("40"))  *  Measure(value=Decimal("30"))  ).error   == error
        assert (  Measure(value=Decimal("40"))  *  Measure(value=Decimal("30"))  ).implied == True
        assert (  Measure(value=Decimal("40"))  *  Measure(value=Decimal("30"))  ).units.symbols   == Unit().symbols
        assert (  Measure(value=Decimal("40"))  *  Measure(value=Decimal("30"))  ).units.magnitude == Unit().magnitude
        assert (  Measure(value=Decimal("40"))  *  Measure(value=Decimal("30"))  ) == Measure(units=Unit(), value= Decimal("1200"), error=error)
        # Value 4: Negative
        assert isinstance( ( Measure(value=-4)  *  Measure(value=-3)  ), Measure )
        error = measure._sqrt_( (Decimal("4")**2 * Decimal("0.5")**2 + Decimal("3")**2 * Decimal("0.5")**2) )
        assert (  Measure(value=-4)  *  Measure(value=-3)  ).value   == 12
        assert (  Measure(value=-4)  *  Measure(value=-3)  ).error   == error
        assert (  Measure(value=-4)  *  Measure(value=-3)  ).implied == True
        assert (  Measure(value=-4)  *  Measure(value=-3)  ).units.symbols   == Unit().symbols
        assert (  Measure(value=-4)  *  Measure(value=-3)  ).units.magnitude == Unit().magnitude
        assert (  Measure(value=-4)  *  Measure(value=-3)  ) == Measure(units=Unit(), value= 12, error=error)
        # Preserve Inputs
        if(True):
          a = Measure(value=4) 
          b = Measure(value=3)
          c = a*b
          c = None
          assert a == Measure(value=4) 
          assert b == Measure(value=3)
      # Unitless * Unit
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          assert isinstance( (  Measure(value=3)  *  Measure(value=4,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (Decimal("4")**2 * Decimal("0.5")**2 + Decimal("3")**2 * Decimal("0.5")**2) )
          assert (  Measure(value=3)  *  Measure(value=4,unit=Unit("cm"))  ).value   == 12
          assert (  Measure(value=3)  *  Measure(value=4,unit=Unit("cm"))  ).error   == error
          assert (  Measure(value=3)  *  Measure(value=4,unit=Unit("cm"))  ).implied == True
          assert (  Measure(value=3)  *  Measure(value=4,unit=Unit("cm"))  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=3)  *  Measure(value=4,unit=Unit("cm"))  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=3)  *  Measure(value=4,unit=Unit("cm"))  ) == Measure(units=Unit("cm"), value= 12, error=error)
          # Value 2: Float
          assert isinstance( (  Measure(value=0.3)  *  Measure(value=0.4,unit=Unit("cm")) ), Measure )
          error = measure._sqrt_( (0.4**2 * 0.05**2 + 0.3**2 * 0.05**2) )
          assert math.isclose( (  Measure(value=0.3)  *  Measure(value=0.4,unit=Unit("cm"))  ).value , 0.3*0.4 )
          assert math.isclose( (  Measure(value=0.3)  *  Measure(value=0.4,unit=Unit("cm"))  ).error , error   )
          assert (  Measure(value=0.3)  *  Measure(value=0.4,unit=Unit("cm"))  ).implied == True
          assert (  Measure(value=0.3)  *  Measure(value=0.4,unit=Unit("cm"))  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=0.3)  *  Measure(value=0.4,unit=Unit("cm"))  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=0.3)  *  Measure(value=0.4,unit=Unit("cm"))  ) == Measure(units=Unit("cm"), value= 0.3*0.4, error=error)
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("40"))  *  Measure(value=Decimal("30"),unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (Decimal("40")**2 * Decimal("5")**2 + Decimal("30")**2 * Decimal("5")**2) )
          assert (  Measure(value=Decimal("40"))  *  Measure(value=Decimal("30"),unit=Unit("cm"))  ).value   == Decimal("1200")
          assert (  Measure(value=Decimal("40"))  *  Measure(value=Decimal("30"),unit=Unit("cm"))  ).error   == error
          assert (  Measure(value=Decimal("40"))  *  Measure(value=Decimal("30"),unit=Unit("cm"))  ).implied == True
          assert (  Measure(value=Decimal("40"))  *  Measure(value=Decimal("30"),unit=Unit("cm"))  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=Decimal("40"))  *  Measure(value=Decimal("30"),unit=Unit("cm"))  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=Decimal("40"))  *  Measure(value=Decimal("30"),unit=Unit("cm"))  ) == Measure(units=Unit("cm"), value= Decimal("1200"), error=error)
          # Value 4: Negative
          assert isinstance( (  Measure(value=-3)  *  Measure(value=-4,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (Decimal("4")**2 * Decimal("0.5")**2 + Decimal("3")**2 * Decimal("0.5")**2) )
          assert (  Measure(value=-3)  *  Measure(value=-4,unit=Unit("cm"))  ).value   == 12
          assert (  Measure(value=-3)  *  Measure(value=-4,unit=Unit("cm"))  ).error   == error
          assert (  Measure(value=-3)  *  Measure(value=-4,unit=Unit("cm"))  ).implied == True
          assert (  Measure(value=-3)  *  Measure(value=-4,unit=Unit("cm"))  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=-3)  *  Measure(value=-4,unit=Unit("cm"))  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=-3)  *  Measure(value=-4,unit=Unit("cm"))  ) == Measure(units=Unit("cm"), value= 12, error=error)
        # Magnitude Units
        if(True):
          # Value 1: Int
          assert isinstance( (  Measure(value=5)  *  Measure(value=2,unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (Decimal(5)**2 * Decimal("2.5")**2 + Decimal(10)**2 * Decimal("0.5")**2) )/Decimal(5)
          assert (  Measure(value=5)  *  Measure(value=2,unit=Unit("5 m^2"))  ) == Measure(units=Unit("5 m^2"), value=10, error=error)
          assert (  Measure(value=5)  *  Measure(value=2,unit=Unit("5 m^2"))  ).value   == 10
          assert (  Measure(value=5)  *  Measure(value=2,unit=Unit("5 m^2"))  ).error   == error
          assert (  Measure(value=5)  *  Measure(value=2,unit=Unit("5 m^2"))  ).implied == True
          assert (  Measure(value=5)  *  Measure(value=2,unit=Unit("5 m^2"))  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=5)  *  Measure(value=2,unit=Unit("5 m^2"))  ).units.magnitude == Unit("5 m^2").magnitude
          # Value 2: Float
          assert isinstance( (  Measure(value=0.5)  *  Measure(value=0.2,unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (0.5**2 * 0.25**2 + 1.0**2 * 0.05**2) )/5
          assert (  Measure(value=0.5)  *  Measure(value=0.2,unit=Unit("5 m^2"))  ) == Measure(units=Unit("5 m^2"), value=0.1, error=error)
          assert math.isclose( (  Measure(value=0.5)  *  Measure(value=0.2,unit=Unit("5 m^2"))  ).value , 0.1   )
          assert math.isclose( (  Measure(value=0.5)  *  Measure(value=0.2,unit=Unit("5 m^2"))  ).error , error )
          assert (  Measure(value=0.5)  *  Measure(value=0.2,unit=Unit("5 m^2"))  ).implied == True
          assert (  Measure(value=0.5)  *  Measure(value=0.2,unit=Unit("5 m^2"))  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=0.5)  *  Measure(value=0.2,unit=Unit("5 m^2"))  ).units.magnitude == Unit("5 m^2").magnitude
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("50"))  *  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (Decimal("50")**2 * Decimal("25")**2 + Decimal("100")**2 * Decimal("5")**2) )/Decimal("5")
          assert (  Measure(value=Decimal("50"))  *  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  ) == Measure(units=Unit("5 m^2"), value=Decimal("1000"), error=error)
          assert (  Measure(value=Decimal("50"))  *  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  ).value   == Decimal("1000")
          assert (  Measure(value=Decimal("50"))  *  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  ).error   == error
          assert (  Measure(value=Decimal("50"))  *  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  ).implied == True
          assert (  Measure(value=Decimal("50"))  *  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=Decimal("50"))  *  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  ).units.magnitude == Unit("5 m^2").magnitude
          # Value 4: Negative
          assert isinstance( (  Measure(value=-5)  *  Measure(value=-2,unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (Decimal(5)**2 * Decimal("2.5")**2 + Decimal(10)**2 * Decimal("0.5")**2) )/Decimal(5)
          assert (  Measure(value=-5)  *  Measure(value=-2,unit=Unit("5 m^2"))  ) == Measure(units=Unit("5 m^2"), value=10, error=error)
          assert (  Measure(value=-5)  *  Measure(value=-2,unit=Unit("5 m^2"))  ).value   == 10
          assert (  Measure(value=-5)  *  Measure(value=-2,unit=Unit("5 m^2"))  ).error   == error
          assert (  Measure(value=-5)  *  Measure(value=-2,unit=Unit("5 m^2"))  ).implied == True
          assert (  Measure(value=-5)  *  Measure(value=-2,unit=Unit("5 m^2"))  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=-5)  *  Measure(value=-2,unit=Unit("5 m^2"))  ).units.magnitude == Unit("5 m^2").magnitude
        # Convoluted Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Measure(value=300)  *  Measure(value=27,unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (Decimal("300")**2 * Decimal("0.5")**2 + Decimal("300.15")**2 * Decimal("50")**2) )
          assert ( Measure(value=300)  *  Measure(value=27,unit=Unit("\u00B0C")) ).value   == Decimal("300.15")*Decimal("300") - Decimal("273.15")
          assert ( Measure(value=300)  *  Measure(value=27,unit=Unit("\u00B0C")) ).error   == error
          assert ( Measure(value=300)  *  Measure(value=27,unit=Unit("\u00B0C")) ).implied == True
          assert ( Measure(value=300)  *  Measure(value=27,unit=Unit("\u00B0C")) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=300)  *  Measure(value=27,unit=Unit("\u00B0C")) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=300)  *  Measure(value=27,unit=Unit("\u00B0C")) ) == Measure(units=Unit("\u00B0C"), value= Decimal("300.15")*Decimal("300") - Decimal("273.15"), error=error)
          # Value 2: Float
          assert isinstance( ( Measure(value=299.9)  *  Measure(value=26.85,unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (299.9**2 * 0.005**2 + 300**2 * 0.05**2) )
          assert math.isclose( ( Measure(value=299.9)  *  Measure(value=26.85,unit=Unit("\u00B0C")) ).value   , 299.9 * 300 - 273.15 )
          assert math.isclose( ( Measure(value=299.9)  *  Measure(value=26.85,unit=Unit("\u00B0C")) ).error   , error )
          assert ( Measure(value=299.9)  *  Measure(value=26.85,unit=Unit("\u00B0C")) ).implied == True 
          assert ( Measure(value=299.9)  *  Measure(value=26.85,unit=Unit("\u00B0C")) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=299.9)  *  Measure(value=26.85,unit=Unit("\u00B0C")) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=299.9)  *  Measure(value=26.85,unit=Unit("\u00B0C")) ) == Measure(units=Unit("\u00B0C"), value=299.9 * 300 - 273.15, error=error)
          # Value 3: Decimal
          assert isinstance( ( Measure(value=Decimal("300"))  *  Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (Decimal("300")**2 * Decimal("0.005")**2 + Decimal("300")**2 * Decimal("50")**2) )
          assert ( Measure(value=Decimal("300"))  *  Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).value   == Decimal("300") * Decimal("300") - Decimal("273.15") 
          assert ( Measure(value=Decimal("300"))  *  Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).error   == error
          assert ( Measure(value=Decimal("300"))  *  Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).implied == True
          assert ( Measure(value=Decimal("300"))  *  Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=Decimal("300"))  *  Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=Decimal("300"))  *  Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ) == Measure(units=Unit("\u00B0C"), value=Decimal("300") * Decimal("300") - Decimal("273.15"), error=error)
          # Value 4: Negative
          assert isinstance( ( Measure(value=300)  *  Measure(value=-27,unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (Decimal("300")**2 * Decimal("0.5")**2 + Decimal("246.15")**2 * Decimal("50")**2) )
          assert ( Measure(value=300)  *  Measure(value=-27,unit=Unit("\u00B0C")) ).value   == Decimal("246.15")*Decimal("300") - Decimal("273.15")
          assert ( Measure(value=300)  *  Measure(value=-27,unit=Unit("\u00B0C")) ).error   == error
          assert ( Measure(value=300)  *  Measure(value=-27,unit=Unit("\u00B0C")) ).implied == True
          assert ( Measure(value=300)  *  Measure(value=-27,unit=Unit("\u00B0C")) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=300)  *  Measure(value=-27,unit=Unit("\u00B0C")) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=300)  *  Measure(value=-27,unit=Unit("\u00B0C")) ) == Measure(units=Unit("\u00B0C"), value= Decimal("246.15")*Decimal("300") - Decimal("273.15"), error=error)
        # Preserve Inputs
        if(True):
          a = Measure(value=3) 
          b = Measure(value=4,unit=Unit("cm"))
          c = a*b
          c = None
          assert a == Measure(value=3) 
          assert b == Measure(value=4,unit=Unit("cm"))
      # Unit * Unitless
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Measure(value=4,unit=Unit("cm"))  *  Measure(value=3)  ), Measure )
          error = measure._sqrt_( (Decimal("4")**2 * Decimal("0.5")**2 + Decimal("3")**2 * Decimal("0.5")**2) )
          assert (  Measure(value=4,unit=Unit("cm"))  *  Measure(value=3)  ).value   == 12
          assert (  Measure(value=4,unit=Unit("cm"))  *  Measure(value=3)  ).error   == error
          assert (  Measure(value=4,unit=Unit("cm"))  *  Measure(value=3)  ).implied == True
          assert (  Measure(value=4,unit=Unit("cm"))  *  Measure(value=3)  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=4,unit=Unit("cm"))  *  Measure(value=3)  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=4,unit=Unit("cm"))  *  Measure(value=3)  ) == Measure(units=Unit("cm"), value= 12, error=error)
          # Value 2: Float
          assert isinstance( ( Measure(value=0.4,unit=Unit("cm"))  *  Measure(value=0.3)  ), Measure )
          error = measure._sqrt_( (0.4**2 * 0.05**2 + 0.3**2 * 0.05**2) )
          assert math.isclose( (  Measure(value=0.4,unit=Unit("cm"))  *  Measure(value=0.3)  ).value , 0.3*0.4 )
          assert math.isclose( (  Measure(value=0.4,unit=Unit("cm"))  *  Measure(value=0.3)  ).error , error   )
          assert (  Measure(value=0.4,unit=Unit("cm"))  *  Measure(value=0.3)  ).implied == True
          assert (  Measure(value=0.4,unit=Unit("cm"))  *  Measure(value=0.3)  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=0.4,unit=Unit("cm"))  *  Measure(value=0.3)  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=0.4,unit=Unit("cm"))  *  Measure(value=0.3)  ) == Measure(units=Unit("cm"), value= 0.3*0.4, error=error)
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  Measure(value=Decimal("30"))  ), Measure )
          error = measure._sqrt_( (Decimal("40")**2 * Decimal("5")**2 + Decimal("30")**2 * Decimal("5")**2) )
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  Measure(value=Decimal("30"))  ).value   == Decimal("1200")
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  Measure(value=Decimal("30"))  ).error   == error
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  Measure(value=Decimal("30"))  ).implied == True
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  Measure(value=Decimal("30"))  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  Measure(value=Decimal("30"))  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  Measure(value=Decimal("30"))  ) == Measure(units=Unit("cm"), value= Decimal("1200"), error=error)
          # Value 4: Negative
          assert isinstance( ( Measure(value=-4,unit=Unit("cm"))  *  Measure(value=-3)  ), Measure )
          error = measure._sqrt_( (Decimal("4")**2 * Decimal("0.5")**2 + Decimal("3")**2 * Decimal("0.5")**2) )
          assert (  Measure(value=-4,unit=Unit("cm"))  *  Measure(value=-3)  ).value   == 12
          assert (  Measure(value=-4,unit=Unit("cm"))  *  Measure(value=-3)  ).error   == error
          assert (  Measure(value=-4,unit=Unit("cm"))  *  Measure(value=-3)  ).implied == True
          assert (  Measure(value=-4,unit=Unit("cm"))  *  Measure(value=-3)  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=-4,unit=Unit("cm"))  *  Measure(value=-3)  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=-4,unit=Unit("cm"))  *  Measure(value=-3)  ) == Measure(units=Unit("cm"), value= 12, error=error)
        # Magnitude Units
        if(True):
          # Value 1: Int
          assert isinstance( (  Measure(value=2,unit=Unit("5 m^2"))  *  Measure(value=5)  ) , Measure )
          error = measure._sqrt_( (Decimal(5)**2 * Decimal("2.5")**2 + Decimal(10)**2 * Decimal("0.5")**2) )/Decimal(5)
          assert (  Measure(value=2,unit=Unit("5 m^2"))  *  Measure(value=5)  ) == Measure(units=Unit("5 m^2"), value=10, error=error)
          assert (  Measure(value=2,unit=Unit("5 m^2"))  *  Measure(value=5)  ).value   == 10
          assert (  Measure(value=2,unit=Unit("5 m^2"))  *  Measure(value=5)  ).error   == error
          assert (  Measure(value=2,unit=Unit("5 m^2"))  *  Measure(value=5)  ).implied == True
          assert (  Measure(value=2,unit=Unit("5 m^2"))  *  Measure(value=5)  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=2,unit=Unit("5 m^2"))  *  Measure(value=5)  ).units.magnitude == Unit("5 m^2").magnitude
          # Value 2: Float
          assert isinstance( (  Measure(value=0.2,unit=Unit("5 m^2"))  *  Measure(value=0.5)  ) , Measure )
          error = measure._sqrt_( (0.5**2 * 0.25**2 + 1.0**2 * 0.05**2) )/5
          assert (  Measure(value=0.2,unit=Unit("5 m^2"))  *  Measure(value=0.5)  ) == Measure(units=Unit("5 m^2"), value=0.1, error=error)
          assert math.isclose( (  Measure(value=0.2,unit=Unit("5 m^2"))  *  Measure(value=0.5)  ).value , 0.1   )
          assert math.isclose( (  Measure(value=0.2,unit=Unit("5 m^2"))  *  Measure(value=0.5)  ).error , error )
          assert (  Measure(value=0.2,unit=Unit("5 m^2"))  *  Measure(value=0.5)  ).implied == True
          assert (  Measure(value=0.2,unit=Unit("5 m^2"))  *  Measure(value=0.5)  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=0.2,unit=Unit("5 m^2"))  *  Measure(value=0.5)  ).units.magnitude == Unit("5 m^2").magnitude
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  Measure(value=Decimal("50"))  ) , Measure )
          error = measure._sqrt_( (Decimal("50")**2 * Decimal("25")**2 + Decimal("100")**2 * Decimal("5")**2) )/Decimal("5")
          assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  Measure(value=Decimal("50"))  ) == Measure(units=Unit("5 m^2"), value=Decimal("1000"), error=error)
          assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  Measure(value=Decimal("50"))  ).value   == Decimal("1000")
          assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  Measure(value=Decimal("50"))  ).error   == error
          assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  Measure(value=Decimal("50"))  ).implied == True
          assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  Measure(value=Decimal("50"))  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  Measure(value=Decimal("50"))  ).units.magnitude == Unit("5 m^2").magnitude
          # Value 4: Negative
          assert isinstance( (  Measure(value=-2,unit=Unit("5 m^2"))  *  Measure(value=-5)  ) , Measure )
          error = measure._sqrt_( (Decimal(5)**2 * Decimal("2.5")**2 + Decimal(10)**2 * Decimal("0.5")**2) )/Decimal(5)
          assert (  Measure(value=-2,unit=Unit("5 m^2"))  *  Measure(value=-5)  ) == Measure(units=Unit("5 m^2"), value=10, error=error)
          assert (  Measure(value=-2,unit=Unit("5 m^2"))  *  Measure(value=-5)  ).value   == 10
          assert (  Measure(value=-2,unit=Unit("5 m^2"))  *  Measure(value=-5)  ).error   == error
          assert (  Measure(value=-2,unit=Unit("5 m^2"))  *  Measure(value=-5)  ).implied == True
          assert (  Measure(value=-2,unit=Unit("5 m^2"))  *  Measure(value=-5)  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=-2,unit=Unit("5 m^2"))  *  Measure(value=-5)  ).units.magnitude == Unit("5 m^2").magnitude
        # Convoluted Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Measure(value=27,unit=Unit("\u00B0C"))  *  Measure(value=300) ), Measure )
          error = measure._sqrt_( (Decimal("300")**2 * Decimal("0.5")**2 + Decimal("300.15")**2 * Decimal("50")**2) )
          assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  Measure(value=300) ).value   == Decimal("300.15")*Decimal("300") - Decimal("273.15")
          assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  Measure(value=300) ).error   == error
          assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  Measure(value=300) ).implied == True
          assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  Measure(value=300) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  Measure(value=300) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  Measure(value=300) ) == Measure(units=Unit("\u00B0C"), value= Decimal("300.15")*Decimal("300") - Decimal("273.15"), error=error)
          # Value 2: Float
          assert isinstance( ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  Measure(value=299.9) ), Measure )
          error = measure._sqrt_( (299.9**2 * 0.005**2 + 300**2 * 0.05**2) )
          assert math.isclose( ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  Measure(value=299.9) ).value , 299.9 * 300 - 273.15 )
          assert math.isclose( ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  Measure(value=299.9) ).error , error )
          assert ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  Measure(value=299.9) ).implied == True
          assert ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  Measure(value=299.9) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  Measure(value=299.9) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  Measure(value=299.9) ) == Measure(units=Unit("\u00B0C"), value=299.9 * 300 - 273.15, error=error)
          # Value 3: Decimal
          assert isinstance( ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  Measure(value=Decimal("300")) ), Measure )
          error = measure._sqrt_( (Decimal("300")**2 * Decimal("0.005")**2 + Decimal("300")**2 * Decimal("50")**2) )
          assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  Measure(value=Decimal("300")) ).value   == Decimal("300") * Decimal("300") - Decimal("273.15") 
          assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  Measure(value=Decimal("300")) ).error   == error
          assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  Measure(value=Decimal("300")) ).implied == True
          assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  Measure(value=Decimal("300")) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  Measure(value=Decimal("300")) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  Measure(value=Decimal("300")) ) == Measure(units=Unit("\u00B0C"), value=Decimal("300") * Decimal("300") - Decimal("273.15"), error=error)
          # Value 4: Negative
          assert isinstance( ( Measure(value=-27,unit=Unit("\u00B0C"))  *  Measure(value=300) ), Measure )
          error = measure._sqrt_( (Decimal("300")**2 * Decimal("0.5")**2 + Decimal("246.15")**2 * Decimal("50")**2) )
          assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  Measure(value=300) ).value   == Decimal("246.15")*Decimal("300") - Decimal("273.15")
          assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  Measure(value=300) ).error   == error
          assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  Measure(value=300) ).implied == True
          assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  Measure(value=300) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  Measure(value=300) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  Measure(value=300) ) == Measure(units=Unit("\u00B0C"), value= Decimal("246.15")*Decimal("300") - Decimal("273.15"), error=error)
        # Preserve Inputs
        if(True):
          a = Measure(value=4,unit=Unit("cm"))
          b = Measure(value=3)
          c = a*b
          c = None
          assert a == Measure(value=4,unit=Unit("cm")) 
          assert b == Measure(value=3)
      # Units * Units
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Measure(value=4,unit=Unit("cm"))  *  Measure(value=3,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (Decimal("4")**2 * Decimal("0.5")**2 + Decimal("3")**2 * Decimal("0.5")**2) )
          assert (  Measure(value=4,unit=Unit("cm"))  *  Measure(value=3,unit=Unit("cm"))  ).value   == 12
          assert (  Measure(value=4,unit=Unit("cm"))  *  Measure(value=3,unit=Unit("cm"))  ).error   == error
          assert (  Measure(value=4,unit=Unit("cm"))  *  Measure(value=3,unit=Unit("cm"))  ).implied == True
          assert (  Measure(value=4,unit=Unit("cm"))  *  Measure(value=3,unit=Unit("cm"))  ).units.symbols   == Unit("cm^2").symbols
          assert (  Measure(value=4,unit=Unit("cm"))  *  Measure(value=3,unit=Unit("cm"))  ).units.magnitude == Unit("cm^2").magnitude
          assert (  Measure(value=4,unit=Unit("cm"))  *  Measure(value=3,unit=Unit("cm"))  ) == Measure(units=Unit("cm^2"), value= 12, error=error)
          # Value 2: Float
          assert isinstance( ( Measure(value=0.4,unit=Unit("cm"))  *  Measure(value=0.3,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (0.4**2 * 0.05**2 + 0.3**2 * 0.05**2) )
          assert math.isclose( (  Measure(value=0.4,unit=Unit("cm"))  *  Measure(value=0.3,unit=Unit("cm"))  ).value , 0.3*0.4 )
          assert math.isclose( (  Measure(value=0.4,unit=Unit("cm"))  *  Measure(value=0.3,unit=Unit("cm"))  ).error , error   )
          assert (  Measure(value=0.4,unit=Unit("cm"))  *  Measure(value=0.3,unit=Unit("cm"))  ).implied == True
          assert (  Measure(value=0.4,unit=Unit("cm"))  *  Measure(value=0.3,unit=Unit("cm"))  ).units.symbols   == Unit("cm^2").symbols
          assert (  Measure(value=0.4,unit=Unit("cm"))  *  Measure(value=0.3,unit=Unit("cm"))  ).units.magnitude == Unit("cm^2").magnitude
          assert (  Measure(value=0.4,unit=Unit("cm"))  *  Measure(value=0.3,unit=Unit("cm"))  ) == Measure(units=Unit("cm^2"), value= 0.3*0.4, error=error)
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (Decimal("40")**2 * Decimal("5")**2 + Decimal("30")**2 * Decimal("5")**2) )
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),unit=Unit("cm"))  ).value   == Decimal("1200")
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),unit=Unit("cm"))  ).error   == error
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),unit=Unit("cm"))  ).implied == True
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),unit=Unit("cm"))  ).units.symbols   == Unit("cm^2").symbols
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),unit=Unit("cm"))  ).units.magnitude == Unit("cm^2").magnitude
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),unit=Unit("cm"))  ) == Measure(units=Unit("cm^2"), value= Decimal("1200"), error=error)
          # Value 4: Negative
          assert isinstance( ( Measure(value=-4,unit=Unit("cm"))  *  Measure(value=-3,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (Decimal("4")**2 * Decimal("0.5")**2 + Decimal("3")**2 * Decimal("0.5")**2) )
          assert (  Measure(value=-4,unit=Unit("cm"))  *  Measure(value=-3,unit=Unit("cm"))  ).value   == 12
          assert (  Measure(value=-4,unit=Unit("cm"))  *  Measure(value=-3,unit=Unit("cm"))  ).error   == error
          assert (  Measure(value=-4,unit=Unit("cm"))  *  Measure(value=-3,unit=Unit("cm"))  ).implied == True
          assert (  Measure(value=-4,unit=Unit("cm"))  *  Measure(value=-3,unit=Unit("cm"))  ).units.symbols   == Unit("cm^2").symbols
          assert (  Measure(value=-4,unit=Unit("cm"))  *  Measure(value=-3,unit=Unit("cm"))  ).units.magnitude == Unit("cm^2").magnitude
          assert (  Measure(value=-4,unit=Unit("cm"))  *  Measure(value=-3,unit=Unit("cm"))  ) == Measure(units=Unit("cm^2"), value= 12, error=error)
        # Magnitude Units
        if(True):
          # Value 1: Int
          assert isinstance( (  Measure(value=2,unit=Unit("5 m^2"))  *  Measure(value=5,unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (Decimal(25)**2 * Decimal("2.5")**2 + Decimal(10)**2 * Decimal("2.5")**2) )/Decimal(25)
          assert (  Measure(value=2,unit=Unit("5 m^2"))  *  Measure(value=5,unit=Unit("5 m^2"))  ).value   == 10
          assert Measure._dec_isclose_(  (  Measure(value=2,unit=Unit("5 m^2"))  *  Measure(value=5,unit=Unit("5 m^2"))  ).error , error )
          assert (  Measure(value=2,unit=Unit("5 m^2"))  *  Measure(value=5,unit=Unit("5 m^2"))  ).implied == True
          assert (  Measure(value=2,unit=Unit("5 m^2"))  *  Measure(value=5,unit=Unit("5 m^2"))  ).units.symbols   == Unit("25 m^4").symbols
          assert (  Measure(value=2,unit=Unit("5 m^2"))  *  Measure(value=5,unit=Unit("5 m^2"))  ).units.magnitude == Unit("25 m^4").magnitude
          assert (  Measure(value=2,unit=Unit("5 m^2"))  *  Measure(value=5,unit=Unit("5 m^2"))  ) == Measure(units=Unit("25 m^4"), value=10, error=error)
          # Value 2: Float
          assert isinstance( (  Measure(value=0.2,unit=Unit("5 m^2"))  *  Measure(value=0.5,unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (2.5**2 * 0.25**2 + 1.0**2 * 0.25**2) )/25
          assert math.isclose( (  Measure(value=0.2,unit=Unit("5 m^2"))  *  Measure(value=0.5,unit=Unit("5 m^2"))  ).value , 0.1   )
          assert math.isclose( (  Measure(value=0.2,unit=Unit("5 m^2"))  *  Measure(value=0.5,unit=Unit("5 m^2"))  ).error , error )
          assert (  Measure(value=0.2,unit=Unit("5 m^2"))  *  Measure(value=0.5,unit=Unit("5 m^2"))  ).implied == True
          assert (  Measure(value=0.2,unit=Unit("5 m^2"))  *  Measure(value=0.5,unit=Unit("5 m^2"))  ).units.symbols   == Unit("25 m^4").symbols
          assert (  Measure(value=0.2,unit=Unit("5 m^2"))  *  Measure(value=0.5,unit=Unit("5 m^2"))  ).units.magnitude == Unit("25 m^4").magnitude
          assert (  Measure(value=0.2,unit=Unit("5 m^2"))  *  Measure(value=0.5,unit=Unit("5 m^2"))  ) == Measure(units=Unit("25 m^4"), value=0.1, error=error)
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  Measure(value=Decimal("50"),unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (Decimal("250")**2 * Decimal("25")**2 + Decimal("100")**2 * Decimal("25")**2) )/Decimal("25")
          assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  Measure(value=Decimal("50"),unit=Unit("5 m^2"))  ) == Measure(units=Unit("25 m^4"), value=Decimal("1000"), error=error)
          assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  Measure(value=Decimal("50"),unit=Unit("5 m^2"))  ).value   == Decimal("1000")
          assert Measure._dec_isclose_(  (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  Measure(value=Decimal("50"),unit=Unit("5 m^2"))  ).error , error )
          assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  Measure(value=Decimal("50"),unit=Unit("5 m^2"))  ).implied == True
          assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  Measure(value=Decimal("50"),unit=Unit("5 m^2"))  ).units.symbols   == Unit("25 m^4").symbols
          assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  Measure(value=Decimal("50"),unit=Unit("5 m^2"))  ).units.magnitude == Unit("25 m^4").magnitude
          # Value 4: Negative
          assert isinstance( (  Measure(value=-2,unit=Unit("5 m^2"))  *  Measure(value=-5,unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (Decimal(25)**2 * Decimal("2.5")**2 + Decimal(10)**2 * Decimal("2.5")**2) )/Decimal(25)
          assert (  Measure(value=-2,unit=Unit("5 m^2"))  *  Measure(value=-5,unit=Unit("5 m^2"))  ) == Measure(units=Unit("25 m^4"), value=10, error=error)
          assert (  Measure(value=-2,unit=Unit("5 m^2"))  *  Measure(value=-5,unit=Unit("5 m^2"))  ).value   == 10
          assert Measure._dec_isclose_( (  Measure(value=-2,unit=Unit("5 m^2"))  *  Measure(value=-5,unit=Unit("5 m^2"))  ).error , error )
          assert (  Measure(value=-2,unit=Unit("5 m^2"))  *  Measure(value=-5,unit=Unit("5 m^2"))  ).implied == True
          assert (  Measure(value=-2,unit=Unit("5 m^2"))  *  Measure(value=-5,unit=Unit("5 m^2"))  ).units.symbols   == Unit("25 m^4").symbols
          assert (  Measure(value=-2,unit=Unit("5 m^2"))  *  Measure(value=-5,unit=Unit("5 m^2"))  ).units.magnitude == Unit("25 m^4").magnitude
        # Convoluted Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Measure(value=27,unit=Unit("\u00B0C"))  *  Measure(value=27,unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (Decimal("300.15")**2 * Decimal("0.5")**2 + Decimal("300.15")**2 * Decimal("0.5")**2) )
          assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  Measure(value=27,unit=Unit("\u00B0C")) ).value   == Decimal("300.15")*Decimal("300.15")
          assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  Measure(value=27,unit=Unit("\u00B0C")) ).error   == error
          assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  Measure(value=27,unit=Unit("\u00B0C")) ).implied == True
          assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  Measure(value=27,unit=Unit("\u00B0C")) ).units.symbols   == Unit("K^2").symbols
          assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  Measure(value=27,unit=Unit("\u00B0C")) ).units.magnitude == Unit("K^2").magnitude
          assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  Measure(value=27,unit=Unit("\u00B0C")) ) == Measure(units=Unit("K^2"), value= Decimal("300.15")*Decimal("300.15"), error=error)
          # Value 2: Float
          assert isinstance( ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  Measure(value=26.85,unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (300**2 * 0.005**2 + 300**2 * 0.005**2) )
          assert math.isclose( ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  Measure(value=26.85,unit=Unit("\u00B0C")) ).value   , 300 * 300 )
          assert math.isclose( ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  Measure(value=26.85,unit=Unit("\u00B0C")) ).error   , error )
          assert ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  Measure(value=26.85,unit=Unit("\u00B0C")) ).implied == True 
          assert ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  Measure(value=26.85,unit=Unit("\u00B0C")) ).units.symbols   == Unit("K^2").symbols
          assert ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  Measure(value=26.85,unit=Unit("\u00B0C")) ).units.magnitude == Unit("K^2").magnitude
          assert ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  Measure(value=26.85,unit=Unit("\u00B0C")) ) == Measure(units=Unit("K^2"), value=300 * 300, error=error)
          # Value 3: Decimal
          assert isinstance( ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (Decimal("300")**2 * Decimal("0.005")**2 + Decimal("300")**2 * Decimal("0.005")**2) )
          assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).value   == Decimal("300") * Decimal("300") 
          assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).error   == error
          assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).implied == True
          assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).units.symbols   == Unit("K^2").symbols
          assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).units.magnitude == Unit("K^2").magnitude
          assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ) == Measure(units=Unit("K^2"), value=Decimal("300") * Decimal("300"), error=error)
          # Value 4: Negative
          assert isinstance( ( Measure(value=-27,unit=Unit("\u00B0C"))  *  Measure(value=-27,unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (Decimal("246.15")**2 * Decimal("0.5")**2 + Decimal("246.15")**2 * Decimal("0.5")**2) )
          assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  Measure(value=-27,unit=Unit("\u00B0C")) ).value   == Decimal("246.15")*Decimal("246.15")
          assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  Measure(value=-27,unit=Unit("\u00B0C")) ).error   == error
          assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  Measure(value=-27,unit=Unit("\u00B0C")) ).implied == True
          assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  Measure(value=-27,unit=Unit("\u00B0C")) ).units.symbols   == Unit("K^2").symbols
          assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  Measure(value=-27,unit=Unit("\u00B0C")) ).units.magnitude == Unit("K^2").magnitude
          assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  Measure(value=-27,unit=Unit("\u00B0C")) ) == Measure(units=Unit("K^2"), value= Decimal("246.15")*Decimal("246.15"), error=error)
        # Canceling Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Measure(value=4,unit=Unit("cm"))  *  Measure(value=3,unit=Unit("cm^-1"))  ), Measure )
          error = measure._sqrt_( (Decimal("4")**2 * Decimal("0.5")**2 + Decimal("3")**2 * Decimal("0.5")**2) )
          assert (  Measure(value=4,unit=Unit("cm"))  *  Measure(value=3,unit=Unit("cm^-1"))  ).value   == 12
          assert (  Measure(value=4,unit=Unit("cm"))  *  Measure(value=3,unit=Unit("cm^-1"))  ).error   == error
          assert (  Measure(value=4,unit=Unit("cm"))  *  Measure(value=3,unit=Unit("cm^-1"))  ).implied == True
          assert (  Measure(value=4,unit=Unit("cm"))  *  Measure(value=3,unit=Unit("cm^-1"))  ).units.symbols   == Unit().symbols
          assert (  Measure(value=4,unit=Unit("cm"))  *  Measure(value=3,unit=Unit("cm^-1"))  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=4,unit=Unit("cm"))  *  Measure(value=3,unit=Unit("cm^-1"))  ) == Measure(units=Unit(), value= 12, error=error)
          # Value 2: Float
          assert isinstance( ( Measure(value=0.4,unit=Unit("cm"))  *  Measure(value=0.3,unit=Unit("cm^-1"))  ), Measure )
          error = measure._sqrt_( (0.4**2 * 0.05**2 + 0.3**2 * 0.05**2) )
          assert math.isclose( (  Measure(value=0.4,unit=Unit("cm"))  *  Measure(value=0.3,unit=Unit("cm^-1"))  ).value , 0.3*0.4 )
          assert math.isclose( (  Measure(value=0.4,unit=Unit("cm"))  *  Measure(value=0.3,unit=Unit("cm^-1"))  ).error , error   )
          assert (  Measure(value=0.4,unit=Unit("cm"))  *  Measure(value=0.3,unit=Unit("cm^-1"))  ).implied == True
          assert (  Measure(value=0.4,unit=Unit("cm"))  *  Measure(value=0.3,unit=Unit("cm^-1"))  ).units.symbols   == Unit().symbols
          assert (  Measure(value=0.4,unit=Unit("cm"))  *  Measure(value=0.3,unit=Unit("cm^-1"))  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=0.4,unit=Unit("cm"))  *  Measure(value=0.3,unit=Unit("cm^-1"))  ) == Measure(units=Unit(), value= 0.3*0.4, error=error)
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),unit=Unit("cm^-1"))  ), Measure )
          error = measure._sqrt_( (Decimal("40")**2 * Decimal("5")**2 + Decimal("30")**2 * Decimal("5")**2) )
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),unit=Unit("cm^-1"))  ).value   == Decimal("1200")
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),unit=Unit("cm^-1"))  ).error   == error
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),unit=Unit("cm^-1"))  ).implied == True
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),unit=Unit("cm^-1"))  ).units.symbols   == Unit().symbols
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),unit=Unit("cm^-1"))  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  Measure(value=Decimal("30"),unit=Unit("cm^-1"))  ) == Measure(units=Unit(), value= Decimal("1200"), error=error)
          # Value 4: Negative
          assert isinstance( ( Measure(value=-4,unit=Unit("cm"))  *  Measure(value=-3,unit=Unit("cm^-1"))  ), Measure )
          error = measure._sqrt_( (Decimal("4")**2 * Decimal("0.5")**2 + Decimal("3")**2 * Decimal("0.5")**2) )
          assert (  Measure(value=-4,unit=Unit("cm"))  *  Measure(value=-3,unit=Unit("cm^-1"))  ).value   == 12
          assert (  Measure(value=-4,unit=Unit("cm"))  *  Measure(value=-3,unit=Unit("cm^-1"))  ).error   == error
          assert (  Measure(value=-4,unit=Unit("cm"))  *  Measure(value=-3,unit=Unit("cm^-1"))  ).implied == True
          assert (  Measure(value=-4,unit=Unit("cm"))  *  Measure(value=-3,unit=Unit("cm^-1"))  ).units.symbols   == Unit().symbols
          assert (  Measure(value=-4,unit=Unit("cm"))  *  Measure(value=-3,unit=Unit("cm^-1"))  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=-4,unit=Unit("cm"))  *  Measure(value=-3,unit=Unit("cm^-1"))  ) == Measure(units=Unit(), value= 12, error=error)
        # Preserve Inputs
        if(True):
          a = Measure(value=4,unit=Unit("cm"))
          b = Measure(value=3,unit=Unit("cm"))
          c = a*b
          c = None
          assert a == Measure(value=4,unit=Unit("cm"))
          assert b == Measure(value=3,unit=Unit("cm"))
  
  def test_measure_unit_mul(self):
    # Measure (Explicit Error) * Unit
    if(True):
      # Measure Unitless * Unit
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          assert isinstance( (  Measure(value=3,error=2)  *  Unit("cm")  ), Measure )
          error = measure._sqrt_( (Decimal(3)**2 * Decimal("0")**2 + Decimal(1)**2 * Decimal(2)**2) )
          assert (  Measure(value=3,error=2)  *  Unit("cm")  ).value   == 3
          assert (  Measure(value=3,error=2)  *  Unit("cm")  ).error   == error
          assert (  Measure(value=3,error=2)  *  Unit("cm")  ).implied == False
          assert (  Measure(value=3,error=2)  *  Unit("cm")  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=3,error=2)  *  Unit("cm")  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=3,error=2)  *  Unit("cm")  ) == Measure(units=Unit("cm"), value= 3, error=error)
          # Value 2: Float
          assert isinstance( (  Measure(value=0.3,error=0.2)  *  Unit("cm") ), Measure )
          error = measure._sqrt_( (1**2 * 0.2**2 + 0.3**2 * 0**2) )
          assert math.isclose( (  Measure(value=0.3,error=0.2)  *  Unit("cm")  ).value , 0.3 )
          assert math.isclose( (  Measure(value=0.3,error=0.2)  *  Unit("cm")  ).error , error   )
          assert (  Measure(value=0.3,error=0.2)  *  Unit("cm")  ).implied == False
          assert (  Measure(value=0.3,error=0.2)  *  Unit("cm")  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=0.3,error=0.2)  *  Unit("cm")  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=0.3,error=0.2)  *  Unit("cm")  ) == Measure(units=Unit("cm"), value= 0.3, error=error)
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("40"),error=Decimal("20"))  *  Unit("cm")  ), Measure )
          error = measure._sqrt_( ( Decimal("40")**2 * Decimal("0")**2 + Decimal("1")**2 * Decimal("20")**2) )
          assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  Unit("cm")  ).value   == Decimal("40")
          assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  Unit("cm")  ).error   == error
          assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  Unit("cm")  ).implied == False
          assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  Unit("cm")  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  Unit("cm")  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  Unit("cm")  ) == Measure(units=Unit("cm"), value= Decimal("40"), error=error)
          # Value 4: Negative
          assert isinstance( (  Measure(value=-3,error=2)  *  Unit("cm")  ), Measure )
          error = measure._sqrt_( (Decimal(3)**2 * Decimal("0")**2 + Decimal(1)**2 * Decimal(2)**2) )
          assert (  Measure(value=-3,error=2)  *  Unit("cm")  ).value   == -3
          assert (  Measure(value=-3,error=2)  *  Unit("cm")  ).error   == error
          assert (  Measure(value=-3,error=2)  *  Unit("cm")  ).implied == False
          assert (  Measure(value=-3,error=2)  *  Unit("cm")  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=-3,error=2)  *  Unit("cm")  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=-3,error=2)  *  Unit("cm")  ) == Measure(units=Unit("cm"), value=-3, error=error)
        # Magnitude Units
        if(True):
          # Value 1: Int
          assert isinstance( (  Measure(value=5,error=1)  *  Unit("5 m^2")  ) , Measure )
          error = measure._sqrt_( (Decimal("5")**2 * Decimal("0")**2 + Decimal("5")**2 * Decimal("1")**2) )/Decimal("5")
          assert (  Measure(value=5,error=1)  *  Unit("5 m^2")  ) == Measure(units=Unit("5 m^2"), value=5, error=error)
          assert (  Measure(value=5,error=1)  *  Unit("5 m^2")  ).value   == 5
          #assert (  Measure(value=5,error=1)  *  Unit("5 m^2")  ).error   == error
          # The above won't work, do to changes on uncertain even for decimal operations (due to calculating and back-calculating in unit operations).
          assert Measure._dec_isclose_( (Measure(value=5,error=1)  *  Unit("5 m^2")).error , error )
          assert (  Measure(value=5,error=1)  *  Unit("5 m^2")  ).implied == False
          assert (  Measure(value=5,error=1)  *  Unit("5 m^2")  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=5,error=1)  *  Unit("5 m^2")  ).units.magnitude == Unit("5 m^2").magnitude
          # Value 2: Float
          assert isinstance( (  Measure(value=0.5,error=0.1)  *  Unit("5 m^2")  ) , Measure )
          error = measure._sqrt_( (0.5**2 * 0**2 + 5**2 * 0.1**2) )/5
          assert (  Measure(value=0.5,error=0.1)  *  Unit("5 m^2")  ) == Measure(units=Unit("5 m^2"), value=0.5, error=error)
          assert math.isclose( (  Measure(value=0.5,error=0.1)  *  Unit("5 m^2")  ).value , 0.5   )
          assert math.isclose( (  Measure(value=0.5,error=0.1)  *  Unit("5 m^2")  ).error , error )
          assert (  Measure(value=0.5,error=0.1)  *  Unit("5 m^2")  ).implied == False
          assert (  Measure(value=0.5,error=0.1)  *  Unit("5 m^2")  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=0.5,error=0.1)  *  Unit("5 m^2")  ).units.magnitude == Unit("5 m^2").magnitude
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("50"),error=Decimal("2"))  *  Unit("5 m^2")  ) , Measure )
          error = measure._sqrt_( (Decimal("50")**2 * Decimal("0")**2 + Decimal("5")**2 * Decimal("2")**2) )/Decimal("5")
          assert (  Measure(value=Decimal("50"),error=Decimal("2"))  *  Unit("5 m^2")  ) == Measure(units=Unit("5 m^2"), value=Decimal("50"), error=error)
          assert (  Measure(value=Decimal("50"),error=Decimal("2"))  *  Unit("5 m^2")  ).value   == Decimal("50")
          assert (  Measure(value=Decimal("50"),error=Decimal("2"))  *  Unit("5 m^2")  ).error   == error
          assert (  Measure(value=Decimal("50"),error=Decimal("2"))  *  Unit("5 m^2")  ).implied == False
          assert (  Measure(value=Decimal("50"),error=Decimal("2"))  *  Unit("5 m^2")  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=Decimal("50"),error=Decimal("2"))  *  Unit("5 m^2")  ).units.magnitude == Unit("5 m^2").magnitude
          # Value 4: Negative
          assert isinstance( (  Measure(value=-5,error=1)  *  Unit("5 m^2")  ) , Measure )
          error = measure._sqrt_( (Decimal("5")**2 * Decimal("0")**2 + Decimal("5")**2 * Decimal("1")**2) )/Decimal("5")
          assert (  Measure(value=-5,error=1)  *  Unit("5 m^2")  ).value   == -5
          #assert (  Measure(value=-5,error=1)  *  Unit("-5 m^2")  ).error   == error
          # The above won't work, do to changes on uncertain even for decimal operations (due to calculating and back-calculating in unit operations).
          assert Measure._dec_isclose_( (Measure(value=-5,error=1)  *  Unit("5 m^2")).error , error )
          assert (  Measure(value=-5,error=1)  *  Unit("5 m^2")  ).implied == False
          assert (  Measure(value=-5,error=1)  *  Unit("5 m^2")  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=-5,error=1)  *  Unit("5 m^2")  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  Measure(value=-5,error=1)  *  Unit("5 m^2")  ) == Measure(units=Unit("5 m^2"), value=-5, error=error)
        # Convoluted Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Measure(value=300,error=2)  *  Unit("\u00B0C") ), Measure )
          error = measure._sqrt_( (Decimal("300")**2 * Decimal("0")**2 + Decimal("274.15")**2 * Decimal("2")**2) )
          assert ( Measure(value=300,error=2)  *  Unit("\u00B0C") ).value   == Decimal("274.15")*Decimal("300") - Decimal("273.15")
          assert ( Measure(value=300,error=2)  *  Unit("\u00B0C") ).error   == error
          assert ( Measure(value=300,error=2)  *  Unit("\u00B0C") ).implied == False
          assert ( Measure(value=300,error=2)  *  Unit("\u00B0C") ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=300,error=2)  *  Unit("\u00B0C") ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=300,error=2)  *  Unit("\u00B0C") ) == Measure(units=Unit("\u00B0C"), value= Decimal("274.15")*Decimal("300") - Decimal("273.15"), error=error)
          # Value 2: Float
          assert isinstance( ( Measure(value=299.9,error=0.02)  *  Unit("\u00B0C") ), Measure )
          error = measure._sqrt_( (299.9**2 * 0**2 + 274.15**2 * 0.02**2) )
          assert math.isclose( ( Measure(value=299.9,error=0.02)  *  Unit("\u00B0C") ).value  , 299.9 * 274.15 - 273.15 )
          assert math.isclose( ( Measure(value=299.9,error=0.02)  *  Unit("\u00B0C") ).error  , error )
          assert ( Measure(value=299.9,error=0.02)  *  Unit("\u00B0C") ).implied == False 
          assert ( Measure(value=299.9,error=0.02)  *  Unit("\u00B0C") ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=299.9,error=0.02)  *  Unit("\u00B0C") ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=299.9,error=0.02)  *  Unit("\u00B0C") ) == Measure(units=Unit("\u00B0C"), value=299.9 * 274.15 - 273.15, error=error)
          # Value 3: Decimal
          assert isinstance( ( Measure(value=Decimal("300"),error=Decimal("0.02"))  *  Unit("\u00B0C") ), Measure )
          error = measure._sqrt_( (Decimal("300")**2 * Decimal("0")**2 + Decimal("274.15")**2 * Decimal("0.02")**2) )
          assert ( Measure(value=Decimal("300"),error=Decimal("0.02"))  *  Unit("\u00B0C") ).value   == Decimal("274.15") * Decimal("300") - Decimal("273.15") 
          assert ( Measure(value=Decimal("300"),error=Decimal("0.02"))  *  Unit("\u00B0C") ).error   == error
          assert ( Measure(value=Decimal("300"),error=Decimal("0.02"))  *  Unit("\u00B0C") ).implied == False
          assert ( Measure(value=Decimal("300"),error=Decimal("0.02"))  *  Unit("\u00B0C") ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=Decimal("300"),error=Decimal("0.02"))  *  Unit("\u00B0C") ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=Decimal("300"),error=Decimal("0.02"))  *  Unit("\u00B0C") ) == Measure(units=Unit("\u00B0C"), value=Decimal("274.15") * Decimal("300") - Decimal("273.15"), error=error)
          # Value 4: Negative
          assert isinstance( ( Measure(value=-300,error=2)  *  Unit("\u00B0C") ), Measure )
          error = measure._sqrt_( (Decimal("300")**2 * Decimal("0")**2 + Decimal("274.15")**2 * Decimal("2")**2) )
          assert ( Measure(value=-300,error=2)  *  Unit("\u00B0C") ).value   == Decimal("274.15")*Decimal("-300") - Decimal("273.15")
          assert ( Measure(value=-300,error=2)  *  Unit("\u00B0C") ).error   == error
          assert ( Measure(value=-300,error=2)  *  Unit("\u00B0C") ).implied == False
          assert ( Measure(value=-300,error=2)  *  Unit("\u00B0C") ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=-300,error=2)  *  Unit("\u00B0C") ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=-300,error=2)  *  Unit("\u00B0C") ) == Measure(units=Unit("\u00B0C"), value= Decimal("274.15")*Decimal("-300") - Decimal("273.15"), error=error)
        # Preserve Inputs
        if(True):
          a = Measure(value=3,error=2) 
          b = Unit("cm")
          c = a*b
          c = None
          assert a == Measure(value=3,error=2) 
          assert b == Unit("cm")
      # Measure Units * Unit
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Measure(value=4,error=2,unit=Unit("cm"))  *  Unit("cm")  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0")**2 + Decimal(1)**2 * Decimal(2)**2) )
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  Unit("cm")  ).value   == 4
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  Unit("cm")  ).error   == error
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  Unit("cm")  ).implied == False
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  Unit("cm")  ).units.symbols   == Unit("cm^2").symbols
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  Unit("cm")  ).units.magnitude == Unit("cm^2").magnitude
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  Unit("cm")  ) == Measure(units=Unit("cm^2"), value= 4, error=error)
          # Value 2: Float
          assert isinstance( ( Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  Unit("cm")  ), Measure )
          error = measure._sqrt_( (0.4**2 * 0**2 + 1**2 * 0.2**2) )
          assert math.isclose( (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  Unit("cm")  ).value , 0.4 )
          assert math.isclose( (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  Unit("cm")  ).error , error   )
          assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  Unit("cm")  ).implied == False
          assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  Unit("cm")  ).units.symbols   == Unit("cm^2").symbols
          assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  Unit("cm")  ).units.magnitude == Unit("cm^2").magnitude
          assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  Unit("cm")  ) == Measure(units=Unit("cm^2"), value= 0.4, error=error)
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  Unit("cm")  ), Measure )
          error = measure._sqrt_( (Decimal("40")**2 * Decimal("0")**2 + Decimal("1")**2 * Decimal("20")**2) )
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  Unit("cm")  ).value   == Decimal("40")
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  Unit("cm")  ).error   == error
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  Unit("cm")  ).implied == False
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  Unit("cm")  ).units.symbols   == Unit("cm^2").symbols
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  Unit("cm")  ).units.magnitude == Unit("cm^2").magnitude
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  Unit("cm")  ) == Measure(units=Unit("cm^2"), value= Decimal("40"), error=error)
          # Value 4: Negative
          assert isinstance( ( Measure(value=-4,error=2,unit=Unit("cm"))  *  Unit("cm")  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0")**2 + Decimal(1)**2 * Decimal(2)**2) )
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  Unit("cm")  ).value   == -4
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  Unit("cm")  ).error   == error
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  Unit("cm")  ).implied == False
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  Unit("cm")  ).units.symbols   == Unit("cm^2").symbols
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  Unit("cm")  ).units.magnitude == Unit("cm^2").magnitude
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  Unit("cm")  ) == Measure(units=Unit("cm^2"), value=-4, error=error)
        # Magnitude Units
        if(True):
          # Value 1: Int
          assert isinstance( (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  Unit("5 m^2")  ) , Measure )
          error = measure._sqrt_( (Decimal(5)**2 * Decimal(5)**2 + Decimal(10)**2 * Decimal("0")**2) )/Decimal(25)
          assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  Unit("5 m^2")  ).value   == 2
          assert Measure._dec_isclose_( (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  Unit("5 m^2")  ).error   , error )
          assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  Unit("5 m^2")  ).implied == False
          assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  Unit("5 m^2")  ).units.symbols   == Unit("25 m^4").symbols
          assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  Unit("5 m^2")  ).units.magnitude == Unit("25 m^4").magnitude
          assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  Unit("5 m^2")  ) == Measure(units=Unit("25 m^4"), value=2, error=error)
          # Value 2: Float
          assert isinstance( (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  Unit("5 m^2")  ) , Measure )
          error = measure._sqrt_( (5**2 * 0.5**2 + 1.0**2 * 0**2) )/25
          assert math.isclose( (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  Unit("5 m^2")  ).value , 0.2   )
          assert math.isclose( (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  Unit("5 m^2")  ).error , error )
          assert (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  Unit("5 m^2")  ).implied == False
          assert (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  Unit("5 m^2")  ).units.symbols   == Unit("25 m^4").symbols
          assert (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  Unit("5 m^2")  ).units.magnitude == Unit("25 m^4").magnitude
          assert (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  Unit("5 m^2")  ) == Measure(units=Unit("25 m^4"), value=0.2, error=error)
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  Unit("5 m^2")  ) , Measure )
          error = measure._sqrt_( (Decimal("5")**2 * Decimal("25")**2 + Decimal("100")**2 * Decimal("0")**2) )/Decimal("25")
          assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  Unit("5 m^2")  ) == Measure(units=Unit("25 m^4"), value=Decimal("20"), error=error)
          assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  Unit("5 m^2")  ).value   == Decimal("20")
          assert Measure._dec_isclose_( (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  Unit("5 m^2")  ).error   , error )
          assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  Unit("5 m^2")  ).implied == False
          assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  Unit("5 m^2")  ).units.symbols   == Unit("25 m^4").symbols
          assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  Unit("5 m^2")  ).units.magnitude == Unit("25 m^4").magnitude
          # Value 4: Negative
          assert isinstance( (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  Unit("5 m^2")  ) , Measure )
          error = measure._sqrt_( (Decimal(5)**2 * Decimal(5)**2 + Decimal(10)**2 * Decimal("0")**2) )/Decimal(25)
          assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  Unit("5 m^2")  ) == Measure(units=Unit("25 m^4"), value=-2, error=error)
          assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  Unit("5 m^2")  ).value   == -2
          assert Measure._dec_isclose_( (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  Unit("5 m^2")  ).error   , error )
          assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  Unit("5 m^2")  ).implied == False
          assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  Unit("5 m^2")  ).units.symbols   == Unit("25 m^4").symbols
          assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  Unit("5 m^2")  ).units.magnitude == Unit("25 m^4").magnitude
        # Convoluted Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  Unit("\u00B0C") ), Measure )
          error = measure._sqrt_( (Decimal("274.15")**2 * Decimal("1")**2 + Decimal("300.15")**2 * Decimal("0")**2) )
          assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  Unit("\u00B0C") ).value   == Decimal("274.15")*Decimal("300.15")
          assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  Unit("\u00B0C") ).error   == error
          assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  Unit("\u00B0C") ).implied == False
          assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  Unit("\u00B0C") ).units.symbols   == Unit("K^2").symbols
          assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  Unit("\u00B0C") ).units.magnitude == Unit("K^2").magnitude
          assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  Unit("\u00B0C") ) == Measure(units=Unit("K^2"), value= Decimal("274.15")*Decimal("300.15"), error=error)
          # Value 2: Float
          assert isinstance( ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  Unit("\u00B0C") ), Measure )
          error = measure._sqrt_( (274.15**2 * 0.02**2 + 300**2 * 0**2) )
          assert math.isclose( ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  Unit("\u00B0C") ).value   , 274.15 * 300 )
          assert math.isclose( ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  Unit("\u00B0C") ).error   , error )
          assert ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  Unit("\u00B0C") ).implied == False
          assert ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  Unit("\u00B0C") ).units.symbols   == Unit("K^2").symbols
          assert ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  Unit("\u00B0C") ).units.magnitude == Unit("K^2").magnitude
          assert ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  Unit("\u00B0C") ) == Measure(units=Unit("K^2"), value= 274.15 * 300, error=error)
          # Value 3: Decimal
          assert isinstance( ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  Unit("\u00B0C") ), Measure )
          error = measure._sqrt_( (Decimal("274.15")**2 * Decimal("0.02")**2 + Decimal("300")**2 * Decimal("0")**2) )
          assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  Unit("\u00B0C") ).value   == Decimal("274.15") * Decimal("300") 
          assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  Unit("\u00B0C") ).error   == error
          assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  Unit("\u00B0C") ).implied == False
          assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  Unit("\u00B0C") ).units.symbols   == Unit("K^2").symbols
          assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  Unit("\u00B0C") ).units.magnitude == Unit("K^2").magnitude
          assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  Unit("\u00B0C") ) == Measure(units=Unit("K^2"), value=Decimal("274.15") * Decimal("300"), error=error)
          # Value 4: Negative
          assert isinstance( ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  Unit("\u00B0C") ), Measure )
          error = measure._sqrt_( (Decimal("274.15")**2 * Decimal("1")**2 + Decimal("246.15")**2 * Decimal("0")**2) )
          assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  Unit("\u00B0C") ).value   == Decimal("274.15")*Decimal("246.15")
          assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  Unit("\u00B0C") ).error   == error
          assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  Unit("\u00B0C") ).implied == False
          assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  Unit("\u00B0C") ).units.symbols   == Unit("K^2").symbols
          assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  Unit("\u00B0C") ).units.magnitude == Unit("K^2").magnitude
          assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  Unit("\u00B0C") ) == Measure(units=Unit("K^2"), value= Decimal("274.15")*Decimal("246.15"), error=error)
        # Canceling Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Measure(value=4,error=2,unit=Unit("cm"))  *  Unit("cm^-1")  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0")**2 + Decimal(1)**2 * Decimal(2)**2) )
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  Unit("cm^-1")  ).value   == 4
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  Unit("cm^-1")  ).error   == error
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  Unit("cm^-1")  ).implied == False
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  Unit("cm^-1")  ).units.symbols   == Unit().symbols
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  Unit("cm^-1")  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  Unit("cm^-1")  ) == Measure(units=Unit(), value= 4, error=error)
          # Value 2: Float
          assert isinstance( ( Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  Unit("cm^-1")  ), Measure )
          error = measure._sqrt_( (0.4**2 * 0**2 + 1**2 * 0.2**2) )
          assert math.isclose( (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  Unit("cm^-1")  ).value , 0.4 )
          assert math.isclose( (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  Unit("cm^-1")  ).error , error   )
          assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  Unit("cm^-1")  ).implied == False
          assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  Unit("cm^-1")  ).units.symbols   == Unit().symbols
          assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  Unit("cm^-1")  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  Unit("cm^-1")  ) == Measure(units=Unit(), value= 0.4, error=error)
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  Unit("cm^-1")  ), Measure )
          error = measure._sqrt_( (Decimal("40")**2 * Decimal("0")**2 + Decimal("1")**2 * Decimal("20")**2) )
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  Unit("cm^-1")  ).value   == Decimal("40")
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  Unit("cm^-1")  ).error   == error
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  Unit("cm^-1")  ).implied == False
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  Unit("cm^-1")  ).units.symbols   == Unit().symbols
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  Unit("cm^-1")  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  Unit("cm^-1")  ) == Measure(units=Unit(), value= Decimal("40"), error=error)
          # Value 4: Negative
          assert isinstance( ( Measure(value=-4,error=2,unit=Unit("cm"))  *  Unit("cm^-1")  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0")**2 + Decimal(1)**2 * Decimal(2)**2) )
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  Unit("cm^-1")  ).value   == -4
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  Unit("cm^-1")  ).error   == error
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  Unit("cm^-1")  ).implied == False
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  Unit("cm^-1")  ).units.symbols   == Unit().symbols
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  Unit("cm^-1")  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  Unit("cm^-1")  ) == Measure(units=Unit(), value= -4, error=error)
        # Preserve Inputs
        if(True):
          a = Measure(value=4,error=2,unit=Unit("cm"))
          b = Unit("cm")
          c = a*b
          c = None
          assert a == Measure(value=4,error=2,unit=Unit("cm"))
          assert b == Unit("cm")
    # Measure (Implicit Error) * Unit
    if(True):
      # Measure Unitless * Unit
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          assert isinstance( (  Measure(value=3)  *  Unit("cm")  ), Measure )
          error = measure._sqrt_( (Decimal(3)**2 * Decimal("0")**2 + Decimal(1)**2 * Decimal("0.5")**2) )
          assert (  Measure(value=3)  *  Unit("cm")  ).value   == 3
          assert (  Measure(value=3)  *  Unit("cm")  ).error   == error
          assert (  Measure(value=3)  *  Unit("cm")  ).implied == True
          assert (  Measure(value=3)  *  Unit("cm")  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=3)  *  Unit("cm")  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=3)  *  Unit("cm")  ) == Measure(units=Unit("cm"), value= 3, error=error)
          # Value 2: Float
          assert isinstance( (  Measure(value=0.3)  *  Unit("cm") ), Measure )
          error = measure._sqrt_( (1**2 * 0.05**2 + 0.3**2 * 0**2) )
          assert math.isclose( (  Measure(value=0.3)  *  Unit("cm")  ).value , 0.3 )
          assert math.isclose( (  Measure(value=0.3)  *  Unit("cm")  ).error , error   )
          assert (  Measure(value=0.3)  *  Unit("cm")  ).implied == True
          assert (  Measure(value=0.3)  *  Unit("cm")  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=0.3)  *  Unit("cm")  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=0.3)  *  Unit("cm")  ) == Measure(units=Unit("cm"), value= 0.3, error=error)
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("40"))  *  Unit("cm")  ), Measure )
          error = measure._sqrt_( ( Decimal("40")**2 * Decimal("0")**2 + Decimal("1")**2 * Decimal("5")**2) )
          assert (  Measure(value=Decimal("40"))  *  Unit("cm")  ).value   == Decimal("40")
          assert (  Measure(value=Decimal("40"))  *  Unit("cm")  ).error   == error
          assert (  Measure(value=Decimal("40"))  *  Unit("cm")  ).implied == True
          assert (  Measure(value=Decimal("40"))  *  Unit("cm")  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=Decimal("40"))  *  Unit("cm")  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=Decimal("40"))  *  Unit("cm")  ) == Measure(units=Unit("cm"), value= Decimal("40"), error=error)
          # Value 4: Negative
          assert isinstance( (  Measure(value=-3)  *  Unit("cm")  ), Measure )
          error = measure._sqrt_( (Decimal(3)**2 * Decimal("0")**2 + Decimal(1)**2 * Decimal("0.5")**2) )
          assert (  Measure(value=-3)  *  Unit("cm")  ).value   == -3
          assert (  Measure(value=-3)  *  Unit("cm")  ).error   == error
          assert (  Measure(value=-3)  *  Unit("cm")  ).implied == True
          assert (  Measure(value=-3)  *  Unit("cm")  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=-3)  *  Unit("cm")  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=-3)  *  Unit("cm")  ) == Measure(units=Unit("cm"), value=-3, error=error)
        # Magnitude Units
        if(True):
          # Value 1: Int
          assert isinstance( (  Measure(value=5)  *  Unit("5 m^2")  ) , Measure )
          error = measure._sqrt_( (Decimal("5")**2 * Decimal("0")**2 + Decimal("5")**2 * Decimal("0.5")**2) )/Decimal("5")
          assert (  Measure(value=5)  *  Unit("5 m^2")  ) == Measure(units=Unit("5 m^2"), value=5, error=error)
          assert (  Measure(value=5)  *  Unit("5 m^2")  ).value   == 5
          #assert (  Measure(value=5)  *  Unit("5 m^2")  ).error   == error
          # The above won't work, do to changes on uncertain even for decimal operations (due to calculating and back-calculating in unit operations).
          assert Measure._dec_isclose_( (Measure(value=5)  *  Unit("5 m^2")).error , error )
          assert (  Measure(value=5)  *  Unit("5 m^2")  ).implied == True
          assert (  Measure(value=5)  *  Unit("5 m^2")  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=5)  *  Unit("5 m^2")  ).units.magnitude == Unit("5 m^2").magnitude
          # Value 2: Float
          assert isinstance( (  Measure(value=0.5)  *  Unit("5 m^2")  ) , Measure )
          error = measure._sqrt_( (0.5**2 * 0**2 + 5**2 * 0.05**2) )/5
          assert (  Measure(value=0.5)  *  Unit("5 m^2")  ) == Measure(units=Unit("5 m^2"), value=0.5, error=error)
          assert math.isclose( (  Measure(value=0.5)  *  Unit("5 m^2")  ).value , 0.5   )
          assert math.isclose( (  Measure(value=0.5)  *  Unit("5 m^2")  ).error , error )
          assert (  Measure(value=0.5)  *  Unit("5 m^2")  ).implied == True
          assert (  Measure(value=0.5)  *  Unit("5 m^2")  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=0.5)  *  Unit("5 m^2")  ).units.magnitude == Unit("5 m^2").magnitude
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("50"))  *  Unit("5 m^2")  ) , Measure )
          error = measure._sqrt_( (Decimal("50")**2 * Decimal("0")**2 + Decimal("5")**2 * Decimal("5")**2) )/Decimal("5")
          assert (  Measure(value=Decimal("50"))  *  Unit("5 m^2")  ) == Measure(units=Unit("5 m^2"), value=Decimal("50"), error=error)
          assert (  Measure(value=Decimal("50"))  *  Unit("5 m^2")  ).value   == Decimal("50")
          assert (  Measure(value=Decimal("50"))  *  Unit("5 m^2")  ).error   == error
          assert (  Measure(value=Decimal("50"))  *  Unit("5 m^2")  ).implied == True
          assert (  Measure(value=Decimal("50"))  *  Unit("5 m^2")  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=Decimal("50"))  *  Unit("5 m^2")  ).units.magnitude == Unit("5 m^2").magnitude
          # Value 4: Negative
          assert isinstance( (  Measure(value=-5)  *  Unit("5 m^2")  ) , Measure )
          error = measure._sqrt_( (Decimal("5")**2 * Decimal("0")**2 + Decimal("5")**2 * Decimal("0.5")**2) )/Decimal("5")
          assert (  Measure(value=-5)  *  Unit("5 m^2")  ).value   == -5
          #assert (  Measure(value=-5)  *  Unit("-5 m^2")  ).error   == error
          # The above won't work, do to changes on uncertain even for decimal operations (due to calculating and back-calculating in unit operations).
          assert Measure._dec_isclose_( (Measure(value=-5)  *  Unit("5 m^2")).error , error )
          assert (  Measure(value=-5)  *  Unit("5 m^2")  ).implied == True
          assert (  Measure(value=-5)  *  Unit("5 m^2")  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=-5)  *  Unit("5 m^2")  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  Measure(value=-5)  *  Unit("5 m^2")  ) == Measure(units=Unit("5 m^2"), value=-5, error=error)
        # Convoluted Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Measure(value=300)  *  Unit("\u00B0C") ), Measure )
          error = measure._sqrt_( (Decimal("300")**2 * Decimal("0")**2 + Decimal("274.15")**2 * Decimal("50")**2) )
          assert ( Measure(value=300)  *  Unit("\u00B0C") ).value   == Decimal("274.15")*Decimal("300") - Decimal("273.15")
          assert ( Measure(value=300)  *  Unit("\u00B0C") ).error   == error
          assert ( Measure(value=300)  *  Unit("\u00B0C") ).implied == True
          assert ( Measure(value=300)  *  Unit("\u00B0C") ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=300)  *  Unit("\u00B0C") ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=300)  *  Unit("\u00B0C") ) == Measure(units=Unit("\u00B0C"), value= Decimal("274.15")*Decimal("300") - Decimal("273.15"), error=error)
          # Value 2: Float
          assert isinstance( ( Measure(value=299.9)  *  Unit("\u00B0C") ), Measure )
          error = measure._sqrt_( (299.9**2 * 0**2 + 274.15**2 * 0.05**2) )
          assert math.isclose( ( Measure(value=299.9)  *  Unit("\u00B0C") ).value  , 299.9 * 274.15 - 273.15 )
          assert math.isclose( ( Measure(value=299.9)  *  Unit("\u00B0C") ).error  , error )
          assert ( Measure(value=299.9)  *  Unit("\u00B0C") ).implied == True 
          assert ( Measure(value=299.9)  *  Unit("\u00B0C") ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=299.9)  *  Unit("\u00B0C") ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=299.9)  *  Unit("\u00B0C") ) == Measure(units=Unit("\u00B0C"), value=299.9 * 274.15 - 273.15, error=error)
          # Value 3: Decimal
          assert isinstance( ( Measure(value=Decimal("300"))  *  Unit("\u00B0C") ), Measure )
          error = measure._sqrt_( (Decimal("300")**2 * Decimal("0")**2 + Decimal("274.15")**2 * Decimal("50")**2) )
          assert ( Measure(value=Decimal("300"))  *  Unit("\u00B0C") ).value   == Decimal("274.15") * Decimal("300") - Decimal("273.15") 
          assert ( Measure(value=Decimal("300"))  *  Unit("\u00B0C") ).error   == error
          assert ( Measure(value=Decimal("300"))  *  Unit("\u00B0C") ).implied == True
          assert ( Measure(value=Decimal("300"))  *  Unit("\u00B0C") ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=Decimal("300"))  *  Unit("\u00B0C") ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=Decimal("300"))  *  Unit("\u00B0C") ) == Measure(units=Unit("\u00B0C"), value=Decimal("274.15") * Decimal("300") - Decimal("273.15"), error=error)
          # Value 4: Negative
          assert isinstance( ( Measure(value=-300)  *  Unit("\u00B0C") ), Measure )
          error = measure._sqrt_( (Decimal("300")**2 * Decimal("0")**2 + Decimal("274.15")**2 * Decimal("50")**2) )
          assert ( Measure(value=-300)  *  Unit("\u00B0C") ).value   == Decimal("274.15")*Decimal("-300") - Decimal("273.15")
          assert ( Measure(value=-300)  *  Unit("\u00B0C") ).error   == error
          assert ( Measure(value=-300)  *  Unit("\u00B0C") ).implied == True
          assert ( Measure(value=-300)  *  Unit("\u00B0C") ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=-300)  *  Unit("\u00B0C") ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=-300)  *  Unit("\u00B0C") ) == Measure(units=Unit("\u00B0C"), value= Decimal("274.15")*Decimal("-300") - Decimal("273.15"), error=error)
        # Preserve Inputs
        if(True):
          a = Measure(value=3) 
          b = Unit("cm")
          c = a*b
          c = None
          assert a == Measure(value=3) 
          assert b == Unit("cm")
      # Measure Units * Unit
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Measure(value=4,unit=Unit("cm"))  *  Unit("cm")  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0")**2 + Decimal(1)**2 * Decimal("0.5")**2) )
          assert (  Measure(value=4,unit=Unit("cm"))  *  Unit("cm")  ).value   == 4
          assert (  Measure(value=4,unit=Unit("cm"))  *  Unit("cm")  ).error   == error
          assert (  Measure(value=4,unit=Unit("cm"))  *  Unit("cm")  ).implied == True
          assert (  Measure(value=4,unit=Unit("cm"))  *  Unit("cm")  ).units.symbols   == Unit("cm^2").symbols
          assert (  Measure(value=4,unit=Unit("cm"))  *  Unit("cm")  ).units.magnitude == Unit("cm^2").magnitude
          assert (  Measure(value=4,unit=Unit("cm"))  *  Unit("cm")  ) == Measure(units=Unit("cm^2"), value= 4, error=error)
          # Value 2: Float
          assert isinstance( ( Measure(value=0.4,unit=Unit("cm"))  *  Unit("cm")  ), Measure )
          error = measure._sqrt_( (0.4**2 * 0**2 + 1**2 * 0.05**2) )
          assert math.isclose( (  Measure(value=0.4,unit=Unit("cm"))  *  Unit("cm")  ).value , 0.4 )
          assert math.isclose( (  Measure(value=0.4,unit=Unit("cm"))  *  Unit("cm")  ).error , error   )
          assert (  Measure(value=0.4,unit=Unit("cm"))  *  Unit("cm")  ).implied == True
          assert (  Measure(value=0.4,unit=Unit("cm"))  *  Unit("cm")  ).units.symbols   == Unit("cm^2").symbols
          assert (  Measure(value=0.4,unit=Unit("cm"))  *  Unit("cm")  ).units.magnitude == Unit("cm^2").magnitude
          assert (  Measure(value=0.4,unit=Unit("cm"))  *  Unit("cm")  ) == Measure(units=Unit("cm^2"), value= 0.4, error=error)
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  Unit("cm")  ), Measure )
          error = measure._sqrt_( (Decimal("40")**2 * Decimal("0")**2 + Decimal("1")**2 * Decimal("5")**2) )
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  Unit("cm")  ).value   == Decimal("40")
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  Unit("cm")  ).error   == error
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  Unit("cm")  ).implied == True
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  Unit("cm")  ).units.symbols   == Unit("cm^2").symbols
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  Unit("cm")  ).units.magnitude == Unit("cm^2").magnitude
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  Unit("cm")  ) == Measure(units=Unit("cm^2"), value= Decimal("40"), error=error)
          # Value 4: Negative
          assert isinstance( ( Measure(value=-4,unit=Unit("cm"))  *  Unit("cm")  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0")**2 + Decimal(1)**2 * Decimal("0.5")**2) )
          assert (  Measure(value=-4,unit=Unit("cm"))  *  Unit("cm")  ).value   == -4
          assert (  Measure(value=-4,unit=Unit("cm"))  *  Unit("cm")  ).error   == error
          assert (  Measure(value=-4,unit=Unit("cm"))  *  Unit("cm")  ).implied == True
          assert (  Measure(value=-4,unit=Unit("cm"))  *  Unit("cm")  ).units.symbols   == Unit("cm^2").symbols
          assert (  Measure(value=-4,unit=Unit("cm"))  *  Unit("cm")  ).units.magnitude == Unit("cm^2").magnitude
          assert (  Measure(value=-4,unit=Unit("cm"))  *  Unit("cm")  ) == Measure(units=Unit("cm^2"), value=-4, error=error)
        # Magnitude Units
        if(True):
          # Value 1: Int
          assert isinstance( (  Measure(value=2,unit=Unit("5 m^2"))  *  Unit("5 m^2")  ) , Measure )
          error = measure._sqrt_( (Decimal(5)**2 * Decimal("2.5")**2 + Decimal(10)**2 * Decimal("0")**2) )/Decimal(25)
          assert (  Measure(value=2,unit=Unit("5 m^2"))  *  Unit("5 m^2")  ).value   == 2
          assert Measure._dec_isclose_( (  Measure(value=2,unit=Unit("5 m^2"))  *  Unit("5 m^2")  ).error   , error )
          assert (  Measure(value=2,unit=Unit("5 m^2"))  *  Unit("5 m^2")  ).implied == True
          assert (  Measure(value=2,unit=Unit("5 m^2"))  *  Unit("5 m^2")  ).units.symbols   == Unit("25 m^4").symbols
          assert (  Measure(value=2,unit=Unit("5 m^2"))  *  Unit("5 m^2")  ).units.magnitude == Unit("25 m^4").magnitude
          assert (  Measure(value=2,unit=Unit("5 m^2"))  *  Unit("5 m^2")  ) == Measure(units=Unit("25 m^4"), value=2, error=error)
          # Value 2: Float
          assert isinstance( (  Measure(value=0.2,unit=Unit("5 m^2"))  *  Unit("5 m^2")  ) , Measure )
          error = measure._sqrt_( (5**2 * 0.25**2 + 1.0**2 * 0**2) )/25
          assert math.isclose( (  Measure(value=0.2,unit=Unit("5 m^2"))  *  Unit("5 m^2")  ).value , 0.2   )
          assert math.isclose( (  Measure(value=0.2,unit=Unit("5 m^2"))  *  Unit("5 m^2")  ).error , error )
          assert (  Measure(value=0.2,unit=Unit("5 m^2"))  *  Unit("5 m^2")  ).implied == True
          assert (  Measure(value=0.2,unit=Unit("5 m^2"))  *  Unit("5 m^2")  ).units.symbols   == Unit("25 m^4").symbols
          assert (  Measure(value=0.2,unit=Unit("5 m^2"))  *  Unit("5 m^2")  ).units.magnitude == Unit("25 m^4").magnitude
          assert (  Measure(value=0.2,unit=Unit("5 m^2"))  *  Unit("5 m^2")  ) == Measure(units=Unit("25 m^4"), value=0.2, error=error)
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  Unit("5 m^2")  ) , Measure )
          error = measure._sqrt_( (Decimal("5")**2 * Decimal("25")**2 + Decimal("100")**2 * Decimal("0")**2) )/Decimal("25")
          assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  Unit("5 m^2")  ) == Measure(units=Unit("25 m^4"), value=Decimal("20"), error=error)
          assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  Unit("5 m^2")  ).value   == Decimal("20")
          assert Measure._dec_isclose_( (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  Unit("5 m^2")  ).error   , error )
          assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  Unit("5 m^2")  ).implied == True
          assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  Unit("5 m^2")  ).units.symbols   == Unit("25 m^4").symbols
          assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  Unit("5 m^2")  ).units.magnitude == Unit("25 m^4").magnitude
          # Value 4: Negative
          assert isinstance( (  Measure(value=-2,unit=Unit("5 m^2"))  *  Unit("5 m^2")  ) , Measure )
          error = measure._sqrt_( (Decimal(5)**2 * Decimal("2.5")**2 + Decimal(10)**2 * Decimal("0")**2) )/Decimal(25)
          assert (  Measure(value=-2,unit=Unit("5 m^2"))  *  Unit("5 m^2")  ) == Measure(units=Unit("25 m^4"), value=-2, error=error)
          assert (  Measure(value=-2,unit=Unit("5 m^2"))  *  Unit("5 m^2")  ).value   == -2
          assert Measure._dec_isclose_( (  Measure(value=-2,unit=Unit("5 m^2"))  *  Unit("5 m^2")  ).error   , error )
          assert (  Measure(value=-2,unit=Unit("5 m^2"))  *  Unit("5 m^2")  ).implied == True
          assert (  Measure(value=-2,unit=Unit("5 m^2"))  *  Unit("5 m^2")  ).units.symbols   == Unit("25 m^4").symbols
          assert (  Measure(value=-2,unit=Unit("5 m^2"))  *  Unit("5 m^2")  ).units.magnitude == Unit("25 m^4").magnitude
        # Convoluted Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Measure(value=27,unit=Unit("\u00B0C"))  *  Unit("\u00B0C") ), Measure )
          error = measure._sqrt_( (Decimal("274.15")**2 * Decimal("0.5")**2 + Decimal("300.15")**2 * Decimal("0")**2) )
          assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  Unit("\u00B0C") ).value   == Decimal("274.15")*Decimal("300.15")
          assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  Unit("\u00B0C") ).error   == error
          assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  Unit("\u00B0C") ).implied == True
          assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  Unit("\u00B0C") ).units.symbols   == Unit("K^2").symbols
          assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  Unit("\u00B0C") ).units.magnitude == Unit("K^2").magnitude
          assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  Unit("\u00B0C") ) == Measure(units=Unit("K^2"), value= Decimal("274.15")*Decimal("300.15"), error=error)
          # Value 2: Float
          assert isinstance( ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  Unit("\u00B0C") ), Measure )
          error = measure._sqrt_( (274.15**2 * 0.005**2 + 300**2 * 0**2) )
          assert math.isclose( ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  Unit("\u00B0C") ).value   , 274.15 * 300 )
          assert math.isclose( ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  Unit("\u00B0C") ).error   , error )
          assert ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  Unit("\u00B0C") ).implied == True
          assert ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  Unit("\u00B0C") ).units.symbols   == Unit("K^2").symbols
          assert ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  Unit("\u00B0C") ).units.magnitude == Unit("K^2").magnitude
          assert ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  Unit("\u00B0C") ) == Measure(units=Unit("K^2"), value= 274.15 * 300, error=error)
          # Value 3: Decimal
          assert isinstance( ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  Unit("\u00B0C") ), Measure )
          error = measure._sqrt_( (Decimal("274.15")**2 * Decimal("0.005")**2 + Decimal("300")**2 * Decimal("0")**2) )
          assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  Unit("\u00B0C") ).value   == Decimal("274.15") * Decimal("300") 
          assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  Unit("\u00B0C") ).error   == error
          assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  Unit("\u00B0C") ).implied == True
          assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  Unit("\u00B0C") ).units.symbols   == Unit("K^2").symbols
          assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  Unit("\u00B0C") ).units.magnitude == Unit("K^2").magnitude
          assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  Unit("\u00B0C") ) == Measure(units=Unit("K^2"), value=Decimal("274.15") * Decimal("300"), error=error)
          # Value 4: Negative
          assert isinstance( ( Measure(value=-27,unit=Unit("\u00B0C"))  *  Unit("\u00B0C") ), Measure )
          error = measure._sqrt_( (Decimal("274.15")**2 * Decimal("0.5")**2 + Decimal("246.15")**2 * Decimal("0")**2) )
          assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  Unit("\u00B0C") ).value   == Decimal("274.15")*Decimal("246.15")
          assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  Unit("\u00B0C") ).error   == error
          assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  Unit("\u00B0C") ).implied == True
          assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  Unit("\u00B0C") ).units.symbols   == Unit("K^2").symbols
          assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  Unit("\u00B0C") ).units.magnitude == Unit("K^2").magnitude
          assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  Unit("\u00B0C") ) == Measure(units=Unit("K^2"), value= Decimal("274.15")*Decimal("246.15"), error=error)
        # Canceling Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Measure(value=4,unit=Unit("cm"))  *  Unit("cm^-1")  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0")**2 + Decimal(1)**2 * Decimal("0.5")**2) )
          assert (  Measure(value=4,unit=Unit("cm"))  *  Unit("cm^-1")  ).value   == 4
          assert (  Measure(value=4,unit=Unit("cm"))  *  Unit("cm^-1")  ).error   == error
          assert (  Measure(value=4,unit=Unit("cm"))  *  Unit("cm^-1")  ).implied == True
          assert (  Measure(value=4,unit=Unit("cm"))  *  Unit("cm^-1")  ).units.symbols   == Unit().symbols
          assert (  Measure(value=4,unit=Unit("cm"))  *  Unit("cm^-1")  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=4,unit=Unit("cm"))  *  Unit("cm^-1")  ) == Measure(units=Unit(), value= 4, error=error)
          # Value 2: Float
          assert isinstance( ( Measure(value=0.4,unit=Unit("cm"))  *  Unit("cm^-1")  ), Measure )
          error = measure._sqrt_( (0.4**2 * 0**2 + 1**2 * 0.05**2) )
          assert math.isclose( (  Measure(value=0.4,unit=Unit("cm"))  *  Unit("cm^-1")  ).value , 0.4 )
          assert math.isclose( (  Measure(value=0.4,unit=Unit("cm"))  *  Unit("cm^-1")  ).error , error   )
          assert (  Measure(value=0.4,unit=Unit("cm"))  *  Unit("cm^-1")  ).implied == True
          assert (  Measure(value=0.4,unit=Unit("cm"))  *  Unit("cm^-1")  ).units.symbols   == Unit().symbols
          assert (  Measure(value=0.4,unit=Unit("cm"))  *  Unit("cm^-1")  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=0.4,unit=Unit("cm"))  *  Unit("cm^-1")  ) == Measure(units=Unit(), value= 0.4, error=error)
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  Unit("cm^-1")  ), Measure )
          error = measure._sqrt_( (Decimal("40")**2 * Decimal("0")**2 + Decimal("1")**2 * Decimal("5")**2) )
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  Unit("cm^-1")  ).value   == Decimal("40")
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  Unit("cm^-1")  ).error   == error
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  Unit("cm^-1")  ).implied == True
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  Unit("cm^-1")  ).units.symbols   == Unit().symbols
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  Unit("cm^-1")  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  Unit("cm^-1")  ) == Measure(units=Unit(), value= Decimal("40"), error=error)
          # Value 4: Negative
          assert isinstance( ( Measure(value=-4,unit=Unit("cm"))  *  Unit("cm^-1")  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0")**2 + Decimal(1)**2 * Decimal("0.5")**2) )
          assert (  Measure(value=-4,unit=Unit("cm"))  *  Unit("cm^-1")  ).value   == -4
          assert (  Measure(value=-4,unit=Unit("cm"))  *  Unit("cm^-1")  ).error   == error
          assert (  Measure(value=-4,unit=Unit("cm"))  *  Unit("cm^-1")  ).implied == True
          assert (  Measure(value=-4,unit=Unit("cm"))  *  Unit("cm^-1")  ).units.symbols   == Unit().symbols
          assert (  Measure(value=-4,unit=Unit("cm"))  *  Unit("cm^-1")  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=-4,unit=Unit("cm"))  *  Unit("cm^-1")  ) == Measure(units=Unit(), value= -4, error=error)
        # Preserve Inputs
        if(True):
          a = Measure(value=4,unit=Unit("cm"))
          b = Unit("cm")
          c = a*b
          c = None
          assert a == Measure(value=4,unit=Unit("cm"))
          assert b == Unit("cm")
    # Unit * Measure (Explicit Error)
    if(True):
      # Unit * Measure Unitless
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          assert isinstance( (  Unit("cm") * Measure(value=3,error=2)  ), Measure )
          error = measure._sqrt_( (Decimal(3)**2 * Decimal("0")**2 + Decimal(1)**2 * Decimal(2)**2) )
          assert (  Unit("cm") * Measure(value=3,error=2)  ).value   == 3
          assert (  Unit("cm") * Measure(value=3,error=2)  ).error   == error
          assert (  Unit("cm") * Measure(value=3,error=2)  ).implied == False
          assert (  Unit("cm") * Measure(value=3,error=2)  ).units.symbols   == Unit("cm").symbols
          assert (  Unit("cm") * Measure(value=3,error=2)  ).units.magnitude == Unit("cm").magnitude
          assert (  Unit("cm") * Measure(value=3,error=2)  ) == Measure(units=Unit("cm"), value= 3, error=error)
          # Value 2: Float
          assert isinstance( (  Unit("cm") * Measure(value=0.3,error=0.2) ), Measure )
          error = measure._sqrt_( (1**2 * 0.2**2 + 0.3**2 * 0**2) )
          assert math.isclose( (  Unit("cm") * Measure(value=0.3,error=0.2)  ).value , 0.3 )
          assert math.isclose( (  Unit("cm") * Measure(value=0.3,error=0.2)  ).error , error   )
          assert (  Unit("cm") * Measure(value=0.3,error=0.2)  ).implied == False
          assert (  Unit("cm") * Measure(value=0.3,error=0.2)  ).units.symbols   == Unit("cm").symbols
          assert (  Unit("cm") * Measure(value=0.3,error=0.2)  ).units.magnitude == Unit("cm").magnitude
          assert (  Unit("cm") * Measure(value=0.3,error=0.2)  ) == Measure(units=Unit("cm"), value= 0.3, error=error)
          # Value 3: Decimal
          assert isinstance( (  Unit("cm") * Measure(value=Decimal("40"),error=Decimal("20"))  ), Measure )
          error = measure._sqrt_( ( Decimal("40")**2 * Decimal("0")**2 + Decimal("1")**2 * Decimal("20")**2) )
          assert (  Unit("cm") * Measure(value=Decimal("40"),error=Decimal("20"))  ).value   == Decimal("40")
          assert (  Unit("cm") * Measure(value=Decimal("40"),error=Decimal("20"))  ).error   == error
          assert (  Unit("cm") * Measure(value=Decimal("40"),error=Decimal("20"))  ).implied == False
          assert (  Unit("cm") * Measure(value=Decimal("40"),error=Decimal("20"))  ).units.symbols   == Unit("cm").symbols
          assert (  Unit("cm") * Measure(value=Decimal("40"),error=Decimal("20"))  ).units.magnitude == Unit("cm").magnitude
          assert (  Unit("cm") * Measure(value=Decimal("40"),error=Decimal("20"))  ) == Measure(units=Unit("cm"), value= Decimal("40"), error=error)
          # Value 4: Negative
          assert isinstance( (  Unit("cm") * Measure(value=-3,error=2)  ), Measure )
          error = measure._sqrt_( (Decimal(3)**2 * Decimal("0")**2 + Decimal(1)**2 * Decimal(2)**2) )
          assert (  Unit("cm") * Measure(value=-3,error=2)  ).value   == -3
          assert (  Unit("cm") * Measure(value=-3,error=2)  ).error   == error
          assert (  Unit("cm") * Measure(value=-3,error=2)  ).implied == False
          assert (  Unit("cm") * Measure(value=-3,error=2)  ).units.symbols   == Unit("cm").symbols
          assert (  Unit("cm") * Measure(value=-3,error=2)  ).units.magnitude == Unit("cm").magnitude
          assert (  Unit("cm") * Measure(value=-3,error=2)  ) == Measure(units=Unit("cm"), value=-3, error=error)
        # Magnitude Units
        if(True):
          # Value 1: Int
          assert isinstance( (  Unit("5 m^2") * Measure(value=5,error=1)  ) , Measure )
          error = measure._sqrt_( (Decimal("5")**2 * Decimal("0")**2 + Decimal("5")**2 * Decimal("1")**2) )/Decimal("5")
          assert (  Unit("5 m^2") * Measure(value=5,error=1)  ) == Measure(units=Unit("5 m^2"), value=5, error=error)
          assert (  Unit("5 m^2") * Measure(value=5,error=1)  ).value   == 5
          #assert (  Unit("5 m^2") * Measure(value=5,error=1)  ).error   == error
          # The above won't work, do to changes on uncertain even for decimal operations (due to calculating and back-calculating in unit operations).
          assert Measure._dec_isclose_( (Unit("5 m^2") * Measure(value=5,error=1)).error , error )
          assert (  Unit("5 m^2") * Measure(value=5,error=1)  ).implied == False
          assert (  Unit("5 m^2") * Measure(value=5,error=1)  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Unit("5 m^2") * Measure(value=5,error=1)  ).units.magnitude == Unit("5 m^2").magnitude
          # Value 2: Float
          assert isinstance( (  Unit("5 m^2") * Measure(value=0.5,error=0.1)  ) , Measure )
          error = measure._sqrt_( (0.5**2 * 0**2 + 5**2 * 0.1**2) )/5
          assert (  Unit("5 m^2") * Measure(value=0.5,error=0.1)  ) == Measure(units=Unit("5 m^2"), value=0.5, error=error)
          assert math.isclose( (  Unit("5 m^2") * Measure(value=0.5,error=0.1)  ).value , 0.5   )
          assert math.isclose( (  Unit("5 m^2") * Measure(value=0.5,error=0.1)  ).error , error )
          assert (  Unit("5 m^2") * Measure(value=0.5,error=0.1)  ).implied == False
          assert (  Unit("5 m^2") * Measure(value=0.5,error=0.1)  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Unit("5 m^2") * Measure(value=0.5,error=0.1)  ).units.magnitude == Unit("5 m^2").magnitude
          # Value 3: Decimal
          assert isinstance( (  Unit("5 m^2") * Measure(value=Decimal("50"),error=Decimal("2"))  ) , Measure )
          error = measure._sqrt_( (Decimal("50")**2 * Decimal("0")**2 + Decimal("5")**2 * Decimal("2")**2) )/Decimal("5")
          assert (  Unit("5 m^2") * Measure(value=Decimal("50"),error=Decimal("2"))  ) == Measure(units=Unit("5 m^2"), value=Decimal("50"), error=error)
          assert (  Unit("5 m^2") * Measure(value=Decimal("50"),error=Decimal("2"))  ).value   == Decimal("50")
          assert (  Unit("5 m^2") * Measure(value=Decimal("50"),error=Decimal("2"))  ).error   == error
          assert (  Unit("5 m^2") * Measure(value=Decimal("50"),error=Decimal("2"))  ).implied == False
          assert (  Unit("5 m^2") * Measure(value=Decimal("50"),error=Decimal("2"))  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Unit("5 m^2") * Measure(value=Decimal("50"),error=Decimal("2"))  ).units.magnitude == Unit("5 m^2").magnitude
          # Value 4: Negative
          assert isinstance( (  Unit("5 m^2") * Measure(value=-5,error=1)  ) , Measure )
          error = measure._sqrt_( (Decimal("5")**2 * Decimal("0")**2 + Decimal("5")**2 * Decimal("1")**2) )/Decimal("5")
          assert (  Unit("5 m^2") * Measure(value=-5,error=1)  ).value   == -5
          #assert (  Unit("-5 m^2") * Measure(value=-5,error=1)  ).error   == error
          # The above won't work, do to changes on uncertain even for decimal operations (due to calculating and back-calculating in unit operations).
          assert Measure._dec_isclose_( (Unit("5 m^2") * Measure(value=-5,error=1)).error , error )
          assert (  Unit("5 m^2") * Measure(value=-5,error=1)  ).implied == False
          assert (  Unit("5 m^2") * Measure(value=-5,error=1)  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Unit("5 m^2") * Measure(value=-5,error=1)  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  Unit("5 m^2") * Measure(value=-5,error=1)  ) == Measure(units=Unit("5 m^2"), value=-5, error=error)
        # Convoluted Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Unit("\u00B0C") * Measure(value=300,error=2) ), Measure )
          error = measure._sqrt_( (Decimal("300")**2 * Decimal("0")**2 + Decimal("274.15")**2 * Decimal("2")**2) )
          assert ( Unit("\u00B0C") * Measure(value=300,error=2) ).value   == Decimal("274.15")*Decimal("300") - Decimal("273.15")
          assert ( Unit("\u00B0C") * Measure(value=300,error=2) ).error   == error
          assert ( Unit("\u00B0C") * Measure(value=300,error=2) ).implied == False
          assert ( Unit("\u00B0C") * Measure(value=300,error=2) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Unit("\u00B0C") * Measure(value=300,error=2) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Unit("\u00B0C") * Measure(value=300,error=2) ) == Measure(units=Unit("\u00B0C"), value= Decimal("274.15")*Decimal("300") - Decimal("273.15"), error=error)
          # Value 2: Float
          assert isinstance( ( Unit("\u00B0C") * Measure(value=299.9,error=0.02) ), Measure )
          error = measure._sqrt_( (299.9**2 * 0**2 + 274.15**2 * 0.02**2) )
          assert math.isclose( ( Unit("\u00B0C") * Measure(value=299.9,error=0.02) ).value  , 299.9 * 274.15 - 273.15 )
          assert math.isclose( ( Unit("\u00B0C") * Measure(value=299.9,error=0.02) ).error  , error )
          assert ( Unit("\u00B0C") * Measure(value=299.9,error=0.02) ).implied == False 
          assert ( Unit("\u00B0C") * Measure(value=299.9,error=0.02) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Unit("\u00B0C") * Measure(value=299.9,error=0.02) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Unit("\u00B0C") * Measure(value=299.9,error=0.02) ) == Measure(units=Unit("\u00B0C"), value=299.9 * 274.15 - 273.15, error=error)
          # Value 3: Decimal
          assert isinstance( ( Unit("\u00B0C") * Measure(value=Decimal("300"),error=Decimal("0.02")) ), Measure )
          error = measure._sqrt_( (Decimal("300")**2 * Decimal("0")**2 + Decimal("274.15")**2 * Decimal("0.02")**2) )
          assert ( Unit("\u00B0C") * Measure(value=Decimal("300"),error=Decimal("0.02")) ).value   == Decimal("274.15") * Decimal("300") - Decimal("273.15") 
          assert ( Unit("\u00B0C") * Measure(value=Decimal("300"),error=Decimal("0.02")) ).error   == error
          assert ( Unit("\u00B0C") * Measure(value=Decimal("300"),error=Decimal("0.02")) ).implied == False
          assert ( Unit("\u00B0C") * Measure(value=Decimal("300"),error=Decimal("0.02")) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Unit("\u00B0C") * Measure(value=Decimal("300"),error=Decimal("0.02")) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Unit("\u00B0C") * Measure(value=Decimal("300"),error=Decimal("0.02")) ) == Measure(units=Unit("\u00B0C"), value=Decimal("274.15") * Decimal("300") - Decimal("273.15"), error=error)
          # Value 4: Negative
          assert isinstance( ( Unit("\u00B0C") * Measure(value=-300,error=2) ), Measure )
          error = measure._sqrt_( (Decimal("300")**2 * Decimal("0")**2 + Decimal("274.15")**2 * Decimal("2")**2) )
          assert ( Unit("\u00B0C") * Measure(value=-300,error=2) ).value   == Decimal("274.15")*Decimal("-300") - Decimal("273.15")
          assert ( Unit("\u00B0C") * Measure(value=-300,error=2) ).error   == error
          assert ( Unit("\u00B0C") * Measure(value=-300,error=2) ).implied == False
          assert ( Unit("\u00B0C") * Measure(value=-300,error=2) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Unit("\u00B0C") * Measure(value=-300,error=2) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Unit("\u00B0C") * Measure(value=-300,error=2) ) == Measure(units=Unit("\u00B0C"), value= Decimal("274.15")*Decimal("-300") - Decimal("273.15"), error=error)
        # Preserve Inputs
        if(True):
          a = Unit("cm")
          b = Measure(value=3,error=2) 
          c = a*b
          c = None
          assert a == Unit("cm")
          assert b == Measure(value=3,error=2) 
      # Unit * Measure Units
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Unit("cm") * Measure(value=4,error=2,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0")**2 + Decimal(1)**2 * Decimal(2)**2) )
          assert (  Unit("cm") * Measure(value=4,error=2,unit=Unit("cm"))  ).value   == 4
          assert (  Unit("cm") * Measure(value=4,error=2,unit=Unit("cm"))  ).error   == error
          assert (  Unit("cm") * Measure(value=4,error=2,unit=Unit("cm"))  ).implied == False
          assert (  Unit("cm") * Measure(value=4,error=2,unit=Unit("cm"))  ).units.symbols   == Unit("cm^2").symbols
          assert (  Unit("cm") * Measure(value=4,error=2,unit=Unit("cm"))  ).units.magnitude == Unit("cm^2").magnitude
          assert (  Unit("cm") * Measure(value=4,error=2,unit=Unit("cm"))  ) == Measure(units=Unit("cm^2"), value= 4, error=error)
          # Value 2: Float
          assert isinstance( ( Unit("cm") * Measure(value=0.4,error=0.2,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (0.4**2 * 0**2 + 1**2 * 0.2**2) )
          assert math.isclose( (  Unit("cm") * Measure(value=0.4,error=0.2,unit=Unit("cm"))  ).value , 0.4 )
          assert math.isclose( (  Unit("cm") * Measure(value=0.4,error=0.2,unit=Unit("cm"))  ).error , error   )
          assert (  Unit("cm") * Measure(value=0.4,error=0.2,unit=Unit("cm"))  ).implied == False
          assert (  Unit("cm") * Measure(value=0.4,error=0.2,unit=Unit("cm"))  ).units.symbols   == Unit("cm^2").symbols
          assert (  Unit("cm") * Measure(value=0.4,error=0.2,unit=Unit("cm"))  ).units.magnitude == Unit("cm^2").magnitude
          assert (  Unit("cm") * Measure(value=0.4,error=0.2,unit=Unit("cm"))  ) == Measure(units=Unit("cm^2"), value= 0.4, error=error)
          # Value 3: Decimal
          assert isinstance( (  Unit("cm") * Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (Decimal("40")**2 * Decimal("0")**2 + Decimal("1")**2 * Decimal("20")**2) )
          assert (  Unit("cm") * Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  ).value   == Decimal("40")
          assert (  Unit("cm") * Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  ).error   == error
          assert (  Unit("cm") * Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  ).implied == False
          assert (  Unit("cm") * Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  ).units.symbols   == Unit("cm^2").symbols
          assert (  Unit("cm") * Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  ).units.magnitude == Unit("cm^2").magnitude
          assert (  Unit("cm") * Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  ) == Measure(units=Unit("cm^2"), value= Decimal("40"), error=error)
          # Value 4: Negative
          assert isinstance( ( Unit("cm") * Measure(value=-4,error=2,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0")**2 + Decimal(1)**2 * Decimal(2)**2) )
          assert (  Unit("cm") * Measure(value=-4,error=2,unit=Unit("cm"))  ).value   == -4
          assert (  Unit("cm") * Measure(value=-4,error=2,unit=Unit("cm"))  ).error   == error
          assert (  Unit("cm") * Measure(value=-4,error=2,unit=Unit("cm"))  ).implied == False
          assert (  Unit("cm") * Measure(value=-4,error=2,unit=Unit("cm"))  ).units.symbols   == Unit("cm^2").symbols
          assert (  Unit("cm") * Measure(value=-4,error=2,unit=Unit("cm"))  ).units.magnitude == Unit("cm^2").magnitude
          assert (  Unit("cm") * Measure(value=-4,error=2,unit=Unit("cm"))  ) == Measure(units=Unit("cm^2"), value=-4, error=error)
        # Magnitude Units
        if(True):
          # Value 1: Int
          assert isinstance( (  Unit("5 m^2") * Measure(value=2,error=1,unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (Decimal(5)**2 * Decimal(5)**2 + Decimal(10)**2 * Decimal("0")**2) )/Decimal(25)
          assert (  Unit("5 m^2") * Measure(value=2,error=1,unit=Unit("5 m^2"))  ).value   == 2
          assert Measure._dec_isclose_( (  Unit("5 m^2") * Measure(value=2,error=1,unit=Unit("5 m^2"))  ).error   , error )
          assert (  Unit("5 m^2") * Measure(value=2,error=1,unit=Unit("5 m^2"))  ).implied == False
          assert (  Unit("5 m^2") * Measure(value=2,error=1,unit=Unit("5 m^2"))  ).units.symbols   == Unit("25 m^4").symbols
          assert (  Unit("5 m^2") * Measure(value=2,error=1,unit=Unit("5 m^2"))  ).units.magnitude == Unit("25 m^4").magnitude
          assert (  Unit("5 m^2") * Measure(value=2,error=1,unit=Unit("5 m^2"))  ) == Measure(units=Unit("25 m^4"), value=2, error=error)
          # Value 2: Float
          assert isinstance( (  Unit("5 m^2") * Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (5**2 * 0.5**2 + 1.0**2 * 0**2) )/25
          assert math.isclose( (  Unit("5 m^2") * Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  ).value , 0.2   )
          assert math.isclose( (  Unit("5 m^2") * Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  ).error , error )
          assert (  Unit("5 m^2") * Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  ).implied == False
          assert (  Unit("5 m^2") * Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  ).units.symbols   == Unit("25 m^4").symbols
          assert (  Unit("5 m^2") * Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  ).units.magnitude == Unit("25 m^4").magnitude
          assert (  Unit("5 m^2") * Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  ) == Measure(units=Unit("25 m^4"), value=0.2, error=error)
          # Value 3: Decimal
          assert isinstance( (  Unit("5 m^2") * Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (Decimal("5")**2 * Decimal("25")**2 + Decimal("100")**2 * Decimal("0")**2) )/Decimal("25")
          assert (  Unit("5 m^2") * Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  ) == Measure(units=Unit("25 m^4"), value=Decimal("20"), error=error)
          assert (  Unit("5 m^2") * Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  ).value   == Decimal("20")
          assert Measure._dec_isclose_( (  Unit("5 m^2") * Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  ).error   , error )
          assert (  Unit("5 m^2") * Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  ).implied == False
          assert (  Unit("5 m^2") * Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  ).units.symbols   == Unit("25 m^4").symbols
          assert (  Unit("5 m^2") * Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  ).units.magnitude == Unit("25 m^4").magnitude
          # Value 4: Negative
          assert isinstance( (  Unit("5 m^2") * Measure(value=-2,error=1,unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (Decimal(5)**2 * Decimal(5)**2 + Decimal(10)**2 * Decimal("0")**2) )/Decimal(25)
          assert (  Unit("5 m^2") * Measure(value=-2,error=1,unit=Unit("5 m^2"))  ) == Measure(units=Unit("25 m^4"), value=-2, error=error)
          assert (  Unit("5 m^2") * Measure(value=-2,error=1,unit=Unit("5 m^2"))  ).value   == -2
          assert Measure._dec_isclose_( (  Unit("5 m^2") * Measure(value=-2,error=1,unit=Unit("5 m^2"))  ).error   , error )
          assert (  Unit("5 m^2") * Measure(value=-2,error=1,unit=Unit("5 m^2"))  ).implied == False
          assert (  Unit("5 m^2") * Measure(value=-2,error=1,unit=Unit("5 m^2"))  ).units.symbols   == Unit("25 m^4").symbols
          assert (  Unit("5 m^2") * Measure(value=-2,error=1,unit=Unit("5 m^2"))  ).units.magnitude == Unit("25 m^4").magnitude
        # Convoluted Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Unit("\u00B0C") * Measure(value=27,error=1,unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (Decimal("274.15")**2 * Decimal("1")**2 + Decimal("300.15")**2 * Decimal("0")**2) )
          assert ( Unit("\u00B0C") * Measure(value=27,error=1,unit=Unit("\u00B0C")) ).value   == Decimal("274.15")*Decimal("300.15")
          assert ( Unit("\u00B0C") * Measure(value=27,error=1,unit=Unit("\u00B0C")) ).error   == error
          assert ( Unit("\u00B0C") * Measure(value=27,error=1,unit=Unit("\u00B0C")) ).implied == False
          assert ( Unit("\u00B0C") * Measure(value=27,error=1,unit=Unit("\u00B0C")) ).units.symbols   == Unit("K^2").symbols
          assert ( Unit("\u00B0C") * Measure(value=27,error=1,unit=Unit("\u00B0C")) ).units.magnitude == Unit("K^2").magnitude
          assert ( Unit("\u00B0C") * Measure(value=27,error=1,unit=Unit("\u00B0C")) ) == Measure(units=Unit("K^2"), value= Decimal("274.15")*Decimal("300.15"), error=error)
          # Value 2: Float
          assert isinstance( ( Unit("\u00B0C") * Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (274.15**2 * 0.02**2 + 300**2 * 0**2) )
          assert math.isclose( ( Unit("\u00B0C") * Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).value   , 274.15 * 300 )
          assert math.isclose( ( Unit("\u00B0C") * Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).error   , error )
          assert ( Unit("\u00B0C") * Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).implied == False
          assert ( Unit("\u00B0C") * Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).units.symbols   == Unit("K^2").symbols
          assert ( Unit("\u00B0C") * Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).units.magnitude == Unit("K^2").magnitude
          assert ( Unit("\u00B0C") * Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ) == Measure(units=Unit("K^2"), value= 274.15 * 300, error=error)
          # Value 3: Decimal
          assert isinstance( ( Unit("\u00B0C") * Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (Decimal("274.15")**2 * Decimal("0.02")**2 + Decimal("300")**2 * Decimal("0")**2) )
          assert ( Unit("\u00B0C") * Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).value   == Decimal("274.15") * Decimal("300") 
          assert ( Unit("\u00B0C") * Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).error   == error
          assert ( Unit("\u00B0C") * Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).implied == False
          assert ( Unit("\u00B0C") * Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).units.symbols   == Unit("K^2").symbols
          assert ( Unit("\u00B0C") * Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).units.magnitude == Unit("K^2").magnitude
          assert ( Unit("\u00B0C") * Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ) == Measure(units=Unit("K^2"), value=Decimal("274.15") * Decimal("300"), error=error)
          # Value 4: Negative
          assert isinstance( ( Unit("\u00B0C") * Measure(value=-27,error=1,unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (Decimal("274.15")**2 * Decimal("1")**2 + Decimal("246.15")**2 * Decimal("0")**2) )
          assert ( Unit("\u00B0C") * Measure(value=-27,error=1,unit=Unit("\u00B0C")) ).value   == Decimal("274.15")*Decimal("246.15")
          assert ( Unit("\u00B0C") * Measure(value=-27,error=1,unit=Unit("\u00B0C")) ).error   == error
          assert ( Unit("\u00B0C") * Measure(value=-27,error=1,unit=Unit("\u00B0C")) ).implied == False
          assert ( Unit("\u00B0C") * Measure(value=-27,error=1,unit=Unit("\u00B0C")) ).units.symbols   == Unit("K^2").symbols
          assert ( Unit("\u00B0C") * Measure(value=-27,error=1,unit=Unit("\u00B0C")) ).units.magnitude == Unit("K^2").magnitude
          assert ( Unit("\u00B0C") * Measure(value=-27,error=1,unit=Unit("\u00B0C")) ) == Measure(units=Unit("K^2"), value= Decimal("274.15")*Decimal("246.15"), error=error)
        # Canceling Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Unit("cm^-1") * Measure(value=4,error=2,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0")**2 + Decimal(1)**2 * Decimal(2)**2) )
          assert (  Unit("cm^-1") * Measure(value=4,error=2,unit=Unit("cm"))  ).value   == 4
          assert (  Unit("cm^-1") * Measure(value=4,error=2,unit=Unit("cm"))  ).error   == error
          assert (  Unit("cm^-1") * Measure(value=4,error=2,unit=Unit("cm"))  ).implied == False
          assert (  Unit("cm^-1") * Measure(value=4,error=2,unit=Unit("cm"))  ).units.symbols   == Unit().symbols
          assert (  Unit("cm^-1") * Measure(value=4,error=2,unit=Unit("cm"))  ).units.magnitude == Unit().magnitude
          assert (  Unit("cm^-1") * Measure(value=4,error=2,unit=Unit("cm"))  ) == Measure(units=Unit(), value= 4, error=error)
          # Value 2: Float
          assert isinstance( ( Unit("cm^-1") * Measure(value=0.4,error=0.2,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (0.4**2 * 0**2 + 1**2 * 0.2**2) )
          assert math.isclose( (  Unit("cm^-1") * Measure(value=0.4,error=0.2,unit=Unit("cm"))  ).value , 0.4 )
          assert math.isclose( (  Unit("cm^-1") * Measure(value=0.4,error=0.2,unit=Unit("cm"))  ).error , error   )
          assert (  Unit("cm^-1") * Measure(value=0.4,error=0.2,unit=Unit("cm"))  ).implied == False
          assert (  Unit("cm^-1") * Measure(value=0.4,error=0.2,unit=Unit("cm"))  ).units.symbols   == Unit().symbols
          assert (  Unit("cm^-1") * Measure(value=0.4,error=0.2,unit=Unit("cm"))  ).units.magnitude == Unit().magnitude
          assert (  Unit("cm^-1") * Measure(value=0.4,error=0.2,unit=Unit("cm"))  ) == Measure(units=Unit(), value= 0.4, error=error)
          # Value 3: Decimal
          assert isinstance( (  Unit("cm^-1") * Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (Decimal("40")**2 * Decimal("0")**2 + Decimal("1")**2 * Decimal("20")**2) )
          assert (  Unit("cm^-1") * Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  ).value   == Decimal("40")
          assert (  Unit("cm^-1") * Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  ).error   == error
          assert (  Unit("cm^-1") * Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  ).implied == False
          assert (  Unit("cm^-1") * Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  ).units.symbols   == Unit().symbols
          assert (  Unit("cm^-1") * Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  ).units.magnitude == Unit().magnitude
          assert (  Unit("cm^-1") * Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  ) == Measure(units=Unit(), value= Decimal("40"), error=error)
          # Value 4: Negative
          assert isinstance( ( Unit("cm^-1") * Measure(value=-4,error=2,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0")**2 + Decimal(1)**2 * Decimal(2)**2) )
          assert (  Unit("cm^-1") * Measure(value=-4,error=2,unit=Unit("cm"))  ).value   == -4
          assert (  Unit("cm^-1") * Measure(value=-4,error=2,unit=Unit("cm"))  ).error   == error
          assert (  Unit("cm^-1") * Measure(value=-4,error=2,unit=Unit("cm"))  ).implied == False
          assert (  Unit("cm^-1") * Measure(value=-4,error=2,unit=Unit("cm"))  ).units.symbols   == Unit().symbols
          assert (  Unit("cm^-1") * Measure(value=-4,error=2,unit=Unit("cm"))  ).units.magnitude == Unit().magnitude
          assert (  Unit("cm^-1") * Measure(value=-4,error=2,unit=Unit("cm"))  ) == Measure(units=Unit(), value= -4, error=error)
        # Preserve Inputs
        if(True):
          a = Unit("cm")
          b = Measure(value=4,error=2,unit=Unit("cm"))
          c = a*b
          c = None
          assert a == Unit("cm")
          assert b == Measure(value=4,error=2,unit=Unit("cm"))
    # Unit * Measure (Implicit Error)
    if(True):
      # Unit * Measure Unitless
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          assert isinstance( (  Unit("cm") * Measure(value=3)  ), Measure )
          error = measure._sqrt_( (Decimal(3)**2 * Decimal("0")**2 + Decimal(1)**2 * Decimal("0.5")**2) )
          assert (  Unit("cm") * Measure(value=3)  ).value   == 3
          assert (  Unit("cm") * Measure(value=3)  ).error   == error
          assert (  Unit("cm") * Measure(value=3)  ).implied == True
          assert (  Unit("cm") * Measure(value=3)  ).units.symbols   == Unit("cm").symbols
          assert (  Unit("cm") * Measure(value=3)  ).units.magnitude == Unit("cm").magnitude
          assert (  Unit("cm") * Measure(value=3)  ) == Measure(units=Unit("cm"), value= 3, error=error)
          # Value 2: Float
          assert isinstance( (  Unit("cm") * Measure(value=0.3) ), Measure )
          error = measure._sqrt_( (1**2 * 0.05**2 + 0.3**2 * 0**2) )
          assert math.isclose( (  Unit("cm") * Measure(value=0.3)  ).value , 0.3 )
          assert math.isclose( (  Unit("cm") * Measure(value=0.3)  ).error , error   )
          assert (  Unit("cm") * Measure(value=0.3)  ).implied == True
          assert (  Unit("cm") * Measure(value=0.3)  ).units.symbols   == Unit("cm").symbols
          assert (  Unit("cm") * Measure(value=0.3)  ).units.magnitude == Unit("cm").magnitude
          assert (  Unit("cm") * Measure(value=0.3)  ) == Measure(units=Unit("cm"), value= 0.3, error=error)
          # Value 3: Decimal
          assert isinstance( (  Unit("cm") * Measure(value=Decimal("40"))  ), Measure )
          error = measure._sqrt_( ( Decimal("40")**2 * Decimal("0")**2 + Decimal("1")**2 * Decimal("5")**2) )
          assert (  Unit("cm") * Measure(value=Decimal("40"))  ).value   == Decimal("40")
          assert (  Unit("cm") * Measure(value=Decimal("40"))  ).error   == error
          assert (  Unit("cm") * Measure(value=Decimal("40"))  ).implied == True
          assert (  Unit("cm") * Measure(value=Decimal("40"))  ).units.symbols   == Unit("cm").symbols
          assert (  Unit("cm") * Measure(value=Decimal("40"))  ).units.magnitude == Unit("cm").magnitude
          assert (  Unit("cm") * Measure(value=Decimal("40"))  ) == Measure(units=Unit("cm"), value= Decimal("40"), error=error)
          # Value 4: Negative
          assert isinstance( (  Unit("cm") * Measure(value=-3)  ), Measure )
          error = measure._sqrt_( (Decimal(3)**2 * Decimal("0")**2 + Decimal(1)**2 * Decimal("0.5")**2) )
          assert (  Unit("cm") * Measure(value=-3)  ).value   == -3
          assert (  Unit("cm") * Measure(value=-3)  ).error   == error
          assert (  Unit("cm") * Measure(value=-3)  ).implied == True
          assert (  Unit("cm") * Measure(value=-3)  ).units.symbols   == Unit("cm").symbols
          assert (  Unit("cm") * Measure(value=-3)  ).units.magnitude == Unit("cm").magnitude
          assert (  Unit("cm") * Measure(value=-3)  ) == Measure(units=Unit("cm"), value=-3, error=error)
        # Magnitude Units
        if(True):
          # Value 1: Int
          assert isinstance( (  Unit("5 m^2") * Measure(value=5)  ) , Measure )
          error = measure._sqrt_( (Decimal("5")**2 * Decimal("0")**2 + Decimal("5")**2 * Decimal("0.5")**2) )/Decimal("5")
          assert (  Unit("5 m^2") * Measure(value=5)  ) == Measure(units=Unit("5 m^2"), value=5, error=error)
          assert (  Unit("5 m^2") * Measure(value=5)  ).value   == 5
          #assert (  Unit("5 m^2") * Measure(value=5)  ).error   == error
          # The above won't work, do to changes on uncertain even for decimal operations (due to calculating and back-calculating in unit operations).
          assert Measure._dec_isclose_( (Unit("5 m^2") * Measure(value=5)).error , error )
          assert (  Unit("5 m^2") * Measure(value=5)  ).implied == True
          assert (  Unit("5 m^2") * Measure(value=5)  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Unit("5 m^2") * Measure(value=5)  ).units.magnitude == Unit("5 m^2").magnitude
          # Value 2: Float
          assert isinstance( (  Unit("5 m^2") * Measure(value=0.5)  ) , Measure )
          error = measure._sqrt_( (0.5**2 * 0**2 + 5**2 * 0.05**2) )/5
          assert (  Unit("5 m^2") * Measure(value=0.5)  ) == Measure(units=Unit("5 m^2"), value=0.5, error=error)
          assert math.isclose( (  Unit("5 m^2") * Measure(value=0.5)  ).value , 0.5   )
          assert math.isclose( (  Unit("5 m^2") * Measure(value=0.5)  ).error , error )
          assert (  Unit("5 m^2") * Measure(value=0.5)  ).implied == True
          assert (  Unit("5 m^2") * Measure(value=0.5)  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Unit("5 m^2") * Measure(value=0.5)  ).units.magnitude == Unit("5 m^2").magnitude
          # Value 3: Decimal
          assert isinstance( (  Unit("5 m^2") * Measure(value=Decimal("50"))  ) , Measure )
          error = measure._sqrt_( (Decimal("50")**2 * Decimal("0")**2 + Decimal("5")**2 * Decimal("5")**2) )/Decimal("5")
          assert (  Unit("5 m^2") * Measure(value=Decimal("50"))  ) == Measure(units=Unit("5 m^2"), value=Decimal("50"), error=error)
          assert (  Unit("5 m^2") * Measure(value=Decimal("50"))  ).value   == Decimal("50")
          assert (  Unit("5 m^2") * Measure(value=Decimal("50"))  ).error   == error
          assert (  Unit("5 m^2") * Measure(value=Decimal("50"))  ).implied == True
          assert (  Unit("5 m^2") * Measure(value=Decimal("50"))  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Unit("5 m^2") * Measure(value=Decimal("50"))  ).units.magnitude == Unit("5 m^2").magnitude
          # Value 4: Negative
          assert isinstance( (  Unit("5 m^2") * Measure(value=-5)  ) , Measure )
          error = measure._sqrt_( (Decimal("5")**2 * Decimal("0")**2 + Decimal("5")**2 * Decimal("0.5")**2) )/Decimal("5")
          assert (  Unit("5 m^2") * Measure(value=-5)  ).value   == -5
          #assert (  Unit("-5 m^2") * Measure(value=-5)  ).error   == error
          # The above won't work, do to changes on uncertain even for decimal operations (due to calculating and back-calculating in unit operations).
          assert Measure._dec_isclose_( (Unit("5 m^2") * Measure(value=-5)).error , error )
          assert (  Unit("5 m^2") * Measure(value=-5)  ).implied == True
          assert (  Unit("5 m^2") * Measure(value=-5)  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Unit("5 m^2") * Measure(value=-5)  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  Unit("5 m^2") * Measure(value=-5)  ) == Measure(units=Unit("5 m^2"), value=-5, error=error)
        # Convoluted Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Unit("\u00B0C") * Measure(value=300) ), Measure )
          error = measure._sqrt_( (Decimal("300")**2 * Decimal("0")**2 + Decimal("274.15")**2 * Decimal("50")**2) )
          assert ( Unit("\u00B0C") * Measure(value=300) ).value   == Decimal("274.15")*Decimal("300") - Decimal("273.15")
          assert ( Unit("\u00B0C") * Measure(value=300) ).error   == error
          assert ( Unit("\u00B0C") * Measure(value=300) ).implied == True
          assert ( Unit("\u00B0C") * Measure(value=300) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Unit("\u00B0C") * Measure(value=300) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Unit("\u00B0C") * Measure(value=300) ) == Measure(units=Unit("\u00B0C"), value= Decimal("274.15")*Decimal("300") - Decimal("273.15"), error=error)
          # Value 2: Float
          assert isinstance( ( Unit("\u00B0C") * Measure(value=299.9) ), Measure )
          error = measure._sqrt_( (299.9**2 * 0**2 + 274.15**2 * 0.05**2) )
          assert math.isclose( ( Unit("\u00B0C") * Measure(value=299.9) ).value  , 299.9 * 274.15 - 273.15 )
          assert math.isclose( ( Unit("\u00B0C") * Measure(value=299.9) ).error  , error )
          assert ( Unit("\u00B0C") * Measure(value=299.9) ).implied == True 
          assert ( Unit("\u00B0C") * Measure(value=299.9) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Unit("\u00B0C") * Measure(value=299.9) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Unit("\u00B0C") * Measure(value=299.9) ) == Measure(units=Unit("\u00B0C"), value=299.9 * 274.15 - 273.15, error=error)
          # Value 3: Decimal
          assert isinstance( ( Unit("\u00B0C") * Measure(value=Decimal("300")) ), Measure )
          error = measure._sqrt_( (Decimal("300")**2 * Decimal("0")**2 + Decimal("274.15")**2 * Decimal("50")**2) )
          assert ( Unit("\u00B0C") * Measure(value=Decimal("300")) ).value   == Decimal("274.15") * Decimal("300") - Decimal("273.15") 
          assert ( Unit("\u00B0C") * Measure(value=Decimal("300")) ).error   == error
          assert ( Unit("\u00B0C") * Measure(value=Decimal("300")) ).implied == True
          assert ( Unit("\u00B0C") * Measure(value=Decimal("300")) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Unit("\u00B0C") * Measure(value=Decimal("300")) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Unit("\u00B0C") * Measure(value=Decimal("300")) ) == Measure(units=Unit("\u00B0C"), value=Decimal("274.15") * Decimal("300") - Decimal("273.15"), error=error)
          # Value 4: Negative
          assert isinstance( ( Unit("\u00B0C") * Measure(value=-300) ), Measure )
          error = measure._sqrt_( (Decimal("300")**2 * Decimal("0")**2 + Decimal("274.15")**2 * Decimal("50")**2) )
          assert ( Unit("\u00B0C") * Measure(value=-300) ).value   == Decimal("274.15")*Decimal("-300") - Decimal("273.15")
          assert ( Unit("\u00B0C") * Measure(value=-300) ).error   == error
          assert ( Unit("\u00B0C") * Measure(value=-300) ).implied == True
          assert ( Unit("\u00B0C") * Measure(value=-300) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Unit("\u00B0C") * Measure(value=-300) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Unit("\u00B0C") * Measure(value=-300) ) == Measure(units=Unit("\u00B0C"), value= Decimal("274.15")*Decimal("-300") - Decimal("273.15"), error=error)
        # Preserve Inputs
        if(True):
          a = Unit("cm")
          b = Measure(value=3) 
          c = a*b
          c = None
          assert a == Unit("cm")
          assert b == Measure(value=3) 
      # Unit * Measure Units
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Unit("cm") * Measure(value=4,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0")**2 + Decimal(1)**2 * Decimal("0.5")**2) )
          assert (  Unit("cm") * Measure(value=4,unit=Unit("cm"))  ).value   == 4
          assert (  Unit("cm") * Measure(value=4,unit=Unit("cm"))  ).error   == error
          assert (  Unit("cm") * Measure(value=4,unit=Unit("cm"))  ).implied == True
          assert (  Unit("cm") * Measure(value=4,unit=Unit("cm"))  ).units.symbols   == Unit("cm^2").symbols
          assert (  Unit("cm") * Measure(value=4,unit=Unit("cm"))  ).units.magnitude == Unit("cm^2").magnitude
          assert (  Unit("cm") * Measure(value=4,unit=Unit("cm"))  ) == Measure(units=Unit("cm^2"), value= 4, error=error)
          # Value 2: Float
          assert isinstance( ( Unit("cm") * Measure(value=0.4,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (0.4**2 * 0**2 + 1**2 * 0.05**2) )
          assert math.isclose( (  Unit("cm") * Measure(value=0.4,unit=Unit("cm"))  ).value , 0.4 )
          assert math.isclose( (  Unit("cm") * Measure(value=0.4,unit=Unit("cm"))  ).error , error   )
          assert (  Unit("cm") * Measure(value=0.4,unit=Unit("cm"))  ).implied == True
          assert (  Unit("cm") * Measure(value=0.4,unit=Unit("cm"))  ).units.symbols   == Unit("cm^2").symbols
          assert (  Unit("cm") * Measure(value=0.4,unit=Unit("cm"))  ).units.magnitude == Unit("cm^2").magnitude
          assert (  Unit("cm") * Measure(value=0.4,unit=Unit("cm"))  ) == Measure(units=Unit("cm^2"), value= 0.4, error=error)
          # Value 3: Decimal
          assert isinstance( (  Unit("cm") * Measure(value=Decimal("40"),unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (Decimal("40")**2 * Decimal("0")**2 + Decimal("1")**2 * Decimal("5")**2) )
          assert (  Unit("cm") * Measure(value=Decimal("40"),unit=Unit("cm"))  ).value   == Decimal("40")
          assert (  Unit("cm") * Measure(value=Decimal("40"),unit=Unit("cm"))  ).error   == error
          assert (  Unit("cm") * Measure(value=Decimal("40"),unit=Unit("cm"))  ).implied == True
          assert (  Unit("cm") * Measure(value=Decimal("40"),unit=Unit("cm"))  ).units.symbols   == Unit("cm^2").symbols
          assert (  Unit("cm") * Measure(value=Decimal("40"),unit=Unit("cm"))  ).units.magnitude == Unit("cm^2").magnitude
          assert (  Unit("cm") * Measure(value=Decimal("40"),unit=Unit("cm"))  ) == Measure(units=Unit("cm^2"), value= Decimal("40"), error=error)
          # Value 4: Negative
          assert isinstance( ( Unit("cm") * Measure(value=-4,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0")**2 + Decimal(1)**2 * Decimal("0.5")**2) )
          assert (  Unit("cm") * Measure(value=-4,unit=Unit("cm"))  ).value   == -4
          assert (  Unit("cm") * Measure(value=-4,unit=Unit("cm"))  ).error   == error
          assert (  Unit("cm") * Measure(value=-4,unit=Unit("cm"))  ).implied == True
          assert (  Unit("cm") * Measure(value=-4,unit=Unit("cm"))  ).units.symbols   == Unit("cm^2").symbols
          assert (  Unit("cm") * Measure(value=-4,unit=Unit("cm"))  ).units.magnitude == Unit("cm^2").magnitude
          assert (  Unit("cm") * Measure(value=-4,unit=Unit("cm"))  ) == Measure(units=Unit("cm^2"), value=-4, error=error)
        # Magnitude Units
        if(True):
          # Value 1: Int
          assert isinstance( (  Unit("5 m^2") * Measure(value=2,unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (Decimal(5)**2 * Decimal("2.5")**2 + Decimal(10)**2 * Decimal("0")**2) )/Decimal(25)
          assert (  Unit("5 m^2") * Measure(value=2,unit=Unit("5 m^2"))  ).value   == 2
          assert Measure._dec_isclose_( (  Unit("5 m^2") * Measure(value=2,unit=Unit("5 m^2"))  ).error   , error )
          assert (  Unit("5 m^2") * Measure(value=2,unit=Unit("5 m^2"))  ).implied == True
          assert (  Unit("5 m^2") * Measure(value=2,unit=Unit("5 m^2"))  ).units.symbols   == Unit("25 m^4").symbols
          assert (  Unit("5 m^2") * Measure(value=2,unit=Unit("5 m^2"))  ).units.magnitude == Unit("25 m^4").magnitude
          assert (  Unit("5 m^2") * Measure(value=2,unit=Unit("5 m^2"))  ) == Measure(units=Unit("25 m^4"), value=2, error=error)
          # Value 2: Float
          assert isinstance( (  Unit("5 m^2") * Measure(value=0.2,unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (5**2 * 0.25**2 + 1.0**2 * 0**2) )/25
          assert math.isclose( (  Unit("5 m^2") * Measure(value=0.2,unit=Unit("5 m^2"))  ).value , 0.2   )
          assert math.isclose( (  Unit("5 m^2") * Measure(value=0.2,unit=Unit("5 m^2"))  ).error , error )
          assert (  Unit("5 m^2") * Measure(value=0.2,unit=Unit("5 m^2"))  ).implied == True
          assert (  Unit("5 m^2") * Measure(value=0.2,unit=Unit("5 m^2"))  ).units.symbols   == Unit("25 m^4").symbols
          assert (  Unit("5 m^2") * Measure(value=0.2,unit=Unit("5 m^2"))  ).units.magnitude == Unit("25 m^4").magnitude
          assert (  Unit("5 m^2") * Measure(value=0.2,unit=Unit("5 m^2"))  ) == Measure(units=Unit("25 m^4"), value=0.2, error=error)
          # Value 3: Decimal
          assert isinstance( (  Unit("5 m^2") * Measure(value=Decimal("20"),unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (Decimal("5")**2 * Decimal("25")**2 + Decimal("100")**2 * Decimal("0")**2) )/Decimal("25")
          assert (  Unit("5 m^2") * Measure(value=Decimal("20"),unit=Unit("5 m^2"))  ) == Measure(units=Unit("25 m^4"), value=Decimal("20"), error=error)
          assert (  Unit("5 m^2") * Measure(value=Decimal("20"),unit=Unit("5 m^2"))  ).value   == Decimal("20")
          assert Measure._dec_isclose_( (  Unit("5 m^2") * Measure(value=Decimal("20"),unit=Unit("5 m^2"))  ).error   , error )
          assert (  Unit("5 m^2") * Measure(value=Decimal("20"),unit=Unit("5 m^2"))  ).implied == True
          assert (  Unit("5 m^2") * Measure(value=Decimal("20"),unit=Unit("5 m^2"))  ).units.symbols   == Unit("25 m^4").symbols
          assert (  Unit("5 m^2") * Measure(value=Decimal("20"),unit=Unit("5 m^2"))  ).units.magnitude == Unit("25 m^4").magnitude
          # Value 4: Negative
          assert isinstance( (  Unit("5 m^2") * Measure(value=-2,unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (Decimal(5)**2 * Decimal("2.5")**2 + Decimal(10)**2 * Decimal("0")**2) )/Decimal(25)
          assert (  Unit("5 m^2") * Measure(value=-2,unit=Unit("5 m^2"))  ) == Measure(units=Unit("25 m^4"), value=-2, error=error)
          assert (  Unit("5 m^2") * Measure(value=-2,unit=Unit("5 m^2"))  ).value   == -2
          assert Measure._dec_isclose_( (  Unit("5 m^2") * Measure(value=-2,unit=Unit("5 m^2"))  ).error   , error )
          assert (  Unit("5 m^2") * Measure(value=-2,unit=Unit("5 m^2"))  ).implied == True
          assert (  Unit("5 m^2") * Measure(value=-2,unit=Unit("5 m^2"))  ).units.symbols   == Unit("25 m^4").symbols
          assert (  Unit("5 m^2") * Measure(value=-2,unit=Unit("5 m^2"))  ).units.magnitude == Unit("25 m^4").magnitude
        # Convoluted Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Unit("\u00B0C") * Measure(value=27,unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (Decimal("274.15")**2 * Decimal("0.5")**2 + Decimal("300.15")**2 * Decimal("0")**2) )
          assert ( Unit("\u00B0C") * Measure(value=27,unit=Unit("\u00B0C")) ).value   == Decimal("274.15")*Decimal("300.15")
          assert ( Unit("\u00B0C") * Measure(value=27,unit=Unit("\u00B0C")) ).error   == error
          assert ( Unit("\u00B0C") * Measure(value=27,unit=Unit("\u00B0C")) ).implied == True
          assert ( Unit("\u00B0C") * Measure(value=27,unit=Unit("\u00B0C")) ).units.symbols   == Unit("K^2").symbols
          assert ( Unit("\u00B0C") * Measure(value=27,unit=Unit("\u00B0C")) ).units.magnitude == Unit("K^2").magnitude
          assert ( Unit("\u00B0C") * Measure(value=27,unit=Unit("\u00B0C")) ) == Measure(units=Unit("K^2"), value= Decimal("274.15")*Decimal("300.15"), error=error)
          # Value 2: Float
          assert isinstance( ( Unit("\u00B0C") * Measure(value=26.85,unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (274.15**2 * 0.005**2 + 300**2 * 0**2) )
          assert math.isclose( ( Unit("\u00B0C") * Measure(value=26.85,unit=Unit("\u00B0C")) ).value   , 274.15 * 300 )
          assert math.isclose( ( Unit("\u00B0C") * Measure(value=26.85,unit=Unit("\u00B0C")) ).error   , error )
          assert ( Unit("\u00B0C") * Measure(value=26.85,unit=Unit("\u00B0C")) ).implied == True
          assert ( Unit("\u00B0C") * Measure(value=26.85,unit=Unit("\u00B0C")) ).units.symbols   == Unit("K^2").symbols
          assert ( Unit("\u00B0C") * Measure(value=26.85,unit=Unit("\u00B0C")) ).units.magnitude == Unit("K^2").magnitude
          assert ( Unit("\u00B0C") * Measure(value=26.85,unit=Unit("\u00B0C")) ) == Measure(units=Unit("K^2"), value= 274.15 * 300, error=error)
          # Value 3: Decimal
          assert isinstance( ( Unit("\u00B0C") * Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (Decimal("274.15")**2 * Decimal("0.005")**2 + Decimal("300")**2 * Decimal("0")**2) )
          assert ( Unit("\u00B0C") * Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).value   == Decimal("274.15") * Decimal("300") 
          assert ( Unit("\u00B0C") * Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).error   == error
          assert ( Unit("\u00B0C") * Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).implied == True
          assert ( Unit("\u00B0C") * Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).units.symbols   == Unit("K^2").symbols
          assert ( Unit("\u00B0C") * Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).units.magnitude == Unit("K^2").magnitude
          assert ( Unit("\u00B0C") * Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ) == Measure(units=Unit("K^2"), value=Decimal("274.15") * Decimal("300"), error=error)
          # Value 4: Negative
          assert isinstance( ( Unit("\u00B0C") * Measure(value=-27,unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (Decimal("274.15")**2 * Decimal("0.5")**2 + Decimal("246.15")**2 * Decimal("0")**2) )
          assert ( Unit("\u00B0C") * Measure(value=-27,unit=Unit("\u00B0C")) ).value   == Decimal("274.15")*Decimal("246.15")
          assert ( Unit("\u00B0C") * Measure(value=-27,unit=Unit("\u00B0C")) ).error   == error
          assert ( Unit("\u00B0C") * Measure(value=-27,unit=Unit("\u00B0C")) ).implied == True
          assert ( Unit("\u00B0C") * Measure(value=-27,unit=Unit("\u00B0C")) ).units.symbols   == Unit("K^2").symbols
          assert ( Unit("\u00B0C") * Measure(value=-27,unit=Unit("\u00B0C")) ).units.magnitude == Unit("K^2").magnitude
          assert ( Unit("\u00B0C") * Measure(value=-27,unit=Unit("\u00B0C")) ) == Measure(units=Unit("K^2"), value= Decimal("274.15")*Decimal("246.15"), error=error)
        # Canceling Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Unit("cm^-1") * Measure(value=4,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0")**2 + Decimal(1)**2 * Decimal("0.5")**2) )
          assert (  Unit("cm^-1") * Measure(value=4,unit=Unit("cm"))  ).value   == 4
          assert (  Unit("cm^-1") * Measure(value=4,unit=Unit("cm"))  ).error   == error
          assert (  Unit("cm^-1") * Measure(value=4,unit=Unit("cm"))  ).implied == True
          assert (  Unit("cm^-1") * Measure(value=4,unit=Unit("cm"))  ).units.symbols   == Unit().symbols
          assert (  Unit("cm^-1") * Measure(value=4,unit=Unit("cm"))  ).units.magnitude == Unit().magnitude
          assert (  Unit("cm^-1") * Measure(value=4,unit=Unit("cm"))  ) == Measure(units=Unit(), value= 4, error=error)
          # Value 2: Float
          assert isinstance( ( Unit("cm^-1") * Measure(value=0.4,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (0.4**2 * 0**2 + 1**2 * 0.05**2) )
          assert math.isclose( (  Unit("cm^-1") * Measure(value=0.4,unit=Unit("cm"))  ).value , 0.4 )
          assert math.isclose( (  Unit("cm^-1") * Measure(value=0.4,unit=Unit("cm"))  ).error , error   )
          assert (  Unit("cm^-1") * Measure(value=0.4,unit=Unit("cm"))  ).implied == True
          assert (  Unit("cm^-1") * Measure(value=0.4,unit=Unit("cm"))  ).units.symbols   == Unit().symbols
          assert (  Unit("cm^-1") * Measure(value=0.4,unit=Unit("cm"))  ).units.magnitude == Unit().magnitude
          assert (  Unit("cm^-1") * Measure(value=0.4,unit=Unit("cm"))  ) == Measure(units=Unit(), value= 0.4, error=error)
          # Value 3: Decimal
          assert isinstance( (  Unit("cm^-1") * Measure(value=Decimal("40"),unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (Decimal("40")**2 * Decimal("0")**2 + Decimal("1")**2 * Decimal("5")**2) )
          assert (  Unit("cm^-1") * Measure(value=Decimal("40"),unit=Unit("cm"))  ).value   == Decimal("40")
          assert (  Unit("cm^-1") * Measure(value=Decimal("40"),unit=Unit("cm"))  ).error   == error
          assert (  Unit("cm^-1") * Measure(value=Decimal("40"),unit=Unit("cm"))  ).implied == True
          assert (  Unit("cm^-1") * Measure(value=Decimal("40"),unit=Unit("cm"))  ).units.symbols   == Unit().symbols
          assert (  Unit("cm^-1") * Measure(value=Decimal("40"),unit=Unit("cm"))  ).units.magnitude == Unit().magnitude
          assert (  Unit("cm^-1") * Measure(value=Decimal("40"),unit=Unit("cm"))  ) == Measure(units=Unit(), value= Decimal("40"), error=error)
          # Value 4: Negative
          assert isinstance( ( Unit("cm^-1") * Measure(value=-4,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0")**2 + Decimal(1)**2 * Decimal("0.5")**2) )
          assert (  Unit("cm^-1") * Measure(value=-4,unit=Unit("cm"))  ).value   == -4
          assert (  Unit("cm^-1") * Measure(value=-4,unit=Unit("cm"))  ).error   == error
          assert (  Unit("cm^-1") * Measure(value=-4,unit=Unit("cm"))  ).implied == True
          assert (  Unit("cm^-1") * Measure(value=-4,unit=Unit("cm"))  ).units.symbols   == Unit().symbols
          assert (  Unit("cm^-1") * Measure(value=-4,unit=Unit("cm"))  ).units.magnitude == Unit().magnitude
          assert (  Unit("cm^-1") * Measure(value=-4,unit=Unit("cm"))  ) == Measure(units=Unit(), value= -4, error=error)
        # Preserve Inputs
        if(True):
          a = Unit("cm")
          b = Measure(value=4,unit=Unit("cm"))
          c = a*b
          c = None
          assert a == Unit("cm")
          assert b == Measure(value=4,unit=Unit("cm"))
    
  def test_measure_decimal_mul(self):
    # Measure (Explicit Error) * Decimal
    if(True):
      # Measure Unitless * Decimal
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          assert isinstance( (  Measure(value=3,error=2)  *  Decimal("3")  ), Measure )
          error = measure._sqrt_( (Decimal(3)**2 * Decimal("0")**2 + Decimal(3)**2 * Decimal(2)**2) )
          assert (  Measure(value=3,error=2)  *  Decimal("3")  ).value   == 9
          assert (  Measure(value=3,error=2)  *  Decimal("3")  ).error   == error
          assert (  Measure(value=3,error=2)  *  Decimal("3")  ).implied == False
          assert (  Measure(value=3,error=2)  *  Decimal("3")  ).units.symbols   == Unit().symbols
          assert (  Measure(value=3,error=2)  *  Decimal("3")  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=3,error=2)  *  Decimal("3")  ) == Measure(units=Unit(), value= 9, error=error)
          # Value 2: Float
          assert isinstance( (  Measure(value=0.3,error=0.2)  *  Decimal("3") ), Measure )
          error = measure._sqrt_( (3**2 * 0.2**2 + 0.3**2 * 0**2) )
          assert math.isclose( (  Measure(value=0.3,error=0.2)  *  Decimal("3")  ).value , 0.3*3 )
          assert math.isclose( (  Measure(value=0.3,error=0.2)  *  Decimal("3")  ).error , error   )
          assert (  Measure(value=0.3,error=0.2)  *  Decimal("3")  ).implied == False
          assert (  Measure(value=0.3,error=0.2)  *  Decimal("3")  ).units.symbols   == Unit().symbols
          assert (  Measure(value=0.3,error=0.2)  *  Decimal("3")  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=0.3,error=0.2)  *  Decimal("3")  ) == Measure(units=Unit(), value= 0.3*3, error=error)
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("40"),error=Decimal("20"))  *  Decimal("3")  ), Measure )
          error = measure._sqrt_( ( Decimal("40")**2 * Decimal("0")**2 + Decimal("3")**2 * Decimal("20")**2) )
          assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  Decimal("3")  ).value   == Decimal("40")*Decimal("3")
          assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  Decimal("3")  ).error   == error
          assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  Decimal("3")  ).implied == False
          assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  Decimal("3")  ).units.symbols   == Unit().symbols
          assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  Decimal("3")  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  Decimal("3")  ) == Measure(units=Unit(), value= Decimal("40")*Decimal("3"), error=error)
          # Value 4: Negative
          assert isinstance( (  Measure(value=-3,error=2)  *  Decimal("3")  ), Measure )
          error = measure._sqrt_( (Decimal(3)**2 * Decimal("0")**2 + Decimal("3")**2 * Decimal(2)**2) )
          assert (  Measure(value=-3,error=2)  *  Decimal("3")  ).value   == -3*3
          assert (  Measure(value=-3,error=2)  *  Decimal("3")  ).error   == error
          assert (  Measure(value=-3,error=2)  *  Decimal("3")  ).implied == False
          assert (  Measure(value=-3,error=2)  *  Decimal("3")  ).units.symbols   == Unit().symbols
          assert (  Measure(value=-3,error=2)  *  Decimal("3")  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=-3,error=2)  *  Decimal("3")  ) == Measure(units=Unit(), value=-3*3, error=error)
        # Preserve Inputs
        if(True):
          a = Measure(value=3,error=2) 
          b = Decimal("3")
          c = a*b
          c = None
          assert a == Measure(value=3,error=2) 
          assert b == Decimal("3")
      # Measure Units * Decimal
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Measure(value=4,error=2,unit=Unit("cm"))  *  Decimal("3")  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0")**2 + Decimal(3)**2 * Decimal(2)**2) )
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  Decimal("3")  ).value   == 4*3
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  Decimal("3")  ).error   == error
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  Decimal("3")  ).implied == False
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  Decimal("3")  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  Decimal("3")  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  Decimal("3")  ) == Measure(units=Unit("cm"), value= 4*3, error=error)
          # Value 2: Float
          assert isinstance( ( Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  Decimal("3")  ), Measure )
          error = measure._sqrt_( (0.4**2 * 0**2 + 3**2 * 0.2**2) )
          assert math.isclose( (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  Decimal("3")  ).value , 0.4*3 )
          assert math.isclose( (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  Decimal("3")  ).error , error   )
          assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  Decimal("3")  ).implied == False
          assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  Decimal("3")  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  Decimal("3")  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  Decimal("3")  ) == Measure(units=Unit("cm"), value= 0.4*3, error=error)
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  Decimal("3")  ), Measure )
          error = measure._sqrt_( (Decimal("40")**2 * Decimal("0")**2 + Decimal("3")**2 * Decimal("20")**2) )
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  Decimal("3")  ).value   == Decimal("40")*Decimal("3")
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  Decimal("3")  ).error   == error
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  Decimal("3")  ).implied == False
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  Decimal("3")  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  Decimal("3")  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  Decimal("3")  ) == Measure(units=Unit("cm"), value= Decimal("40")*Decimal("3"), error=error)
          # Value 4: Negative
          assert isinstance( ( Measure(value=-4,error=2,unit=Unit("cm"))  *  Decimal("3")  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0")**2 + Decimal("3")**2 * Decimal(2)**2) )
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  Decimal("3")  ).value   == -4*Decimal("3")
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  Decimal("3")  ).error   == error
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  Decimal("3")  ).implied == False
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  Decimal("3")  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  Decimal("3")  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  Decimal("3")  ) == Measure(units=Unit("cm"), value=-4*Decimal("3"), error=error)
        # Magnitude Units
        if(True):
          # Value 1: Int
          assert isinstance( (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  Decimal("3")  ) , Measure )
          error = measure._sqrt_( (Decimal("3")**2 * Decimal(5)**2 + Decimal(10)**2 * Decimal("0")**2) )/Decimal(5)
          assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  Decimal("3")  ).value   == 2*  Decimal("3")
          assert Measure._dec_isclose_( (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  Decimal("3")  ).error   , error )
          assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  Decimal("3")  ).implied == False
          assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  Decimal("3")  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  Decimal("3")  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  Decimal("3")  ) == Measure(units=Unit("5 m^2"), value=2*  Decimal("3"), error=error)
          # Value 2: Float
          assert isinstance( (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  Decimal("3")  ) , Measure )
          error = measure._sqrt_( (3**2 * 0.5**2 + 1.0**2 * 0**2) )/5
          assert math.isclose( (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  Decimal("3")  ).value , 0.2*3   )
          assert math.isclose( (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  Decimal("3")  ).error , error )
          assert (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  Decimal("3")  ).implied == False
          assert (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  Decimal("3")  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  Decimal("3")  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  Decimal("3")  ) == Measure(units=Unit("5 m^2"), value=0.2*3, error=error)
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  Decimal("3")  ) , Measure )
          error = measure._sqrt_( (Decimal("3")**2 * Decimal("25")**2 + Decimal("100")**2 * Decimal("0")**2) )/Decimal("5")
          assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  Decimal("3")  ).value   == Decimal("20")*Decimal("3")
          assert Measure._dec_isclose_( (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  Decimal("3")  ).error   , error )
          assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  Decimal("3")  ).implied == False
          assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  Decimal("3")  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  Decimal("3")  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  Decimal("3")  ) == Measure(units=Unit("5 m^2"), value=Decimal("20")*Decimal("3"), error=error)
          # Value 4: Negative
          assert isinstance( (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  Decimal("3")  ) , Measure )
          error = measure._sqrt_( (Decimal("3")**2 * Decimal(5)**2 + Decimal(10)**2 * Decimal("0")**2) )/Decimal(5)
          assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  Decimal("3")  ).value   == -2*Decimal("3")
          assert Measure._dec_isclose_( (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  Decimal("3")  ).error   , error )
          assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  Decimal("3")  ).implied == False
          assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  Decimal("3")  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  Decimal("3")  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  Decimal("3")  ) == Measure(units=Unit("5 m^2"), value=-2*Decimal("3"), error=error)
        # Convoluted Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  Decimal("3") ), Measure )
          error = measure._sqrt_( (Decimal("3")**2 * Decimal("1")**2 + Decimal("300.15")**2 * Decimal("0")**2) )
          assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  Decimal("3") ).value   == Decimal("3")*Decimal("300.15")-Decimal("273.15")
          assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  Decimal("3") ).error   == error
          assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  Decimal("3") ).implied == False
          assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  Decimal("3") ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  Decimal("3") ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  Decimal("3") ) == Measure(units=Unit("\u00B0C"), value=Decimal("3")*Decimal("300.15")-Decimal("273.15"), error=error)
          # Value 2: Float
          assert isinstance( ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  Decimal("3") ), Measure )
          error = measure._sqrt_( (3**2 * 0.02**2 + 300**2 * 0**2) )
          assert math.isclose( ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  Decimal("3") ).value   , 3 * 300 - 273.15 )
          assert math.isclose( ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  Decimal("3") ).error   , error )
          assert ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  Decimal("3") ).implied == False
          assert ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  Decimal("3") ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  Decimal("3") ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  Decimal("3") ) == Measure(units=Unit("\u00B0C"), value= 3 * 300 - 273.15, error=error)
          # Value 3: Decimal
          assert isinstance( ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  Decimal("3") ), Measure )
          error = measure._sqrt_( (Decimal("3")**2 * Decimal("0.02")**2 + Decimal("300")**2 * Decimal("0")**2) )
          assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  Decimal("3") ).value   == Decimal("3") * Decimal("300") -Decimal("273.15")
          assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  Decimal("3") ).error   == error
          assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  Decimal("3") ).implied == False
          assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  Decimal("3") ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  Decimal("3") ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  Decimal("3") ) == Measure(units=Unit("\u00B0C"), value=Decimal("3") * Decimal("300")-Decimal("273.15"), error=error)
          # Value 4: Negative
          assert isinstance( ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  Decimal("3") ), Measure )
          error = measure._sqrt_( (Decimal("3")**2 * Decimal("1")**2 + Decimal("246.15")**2 * Decimal("0")**2) )
          assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  Decimal("3") ).value   == Decimal("3")*Decimal("246.15")-Decimal("273.15")
          assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  Decimal("3") ).error   == error
          assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  Decimal("3") ).implied == False
          assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  Decimal("3") ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  Decimal("3") ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  Decimal("3") ) == Measure(units=Unit("\u00B0C"), value= Decimal("3")*Decimal("246.15")-Decimal("273.15"), error=error)
        # Preserve Inputs
        if(True):
          a = Measure(value=4,error=2,unit=Unit("cm"))
          b = Decimal("3")
          c = a*b
          c = None
          assert a == Measure(value=4,error=2,unit=Unit("cm"))
          assert b == Decimal("3")
    # Measure (Implicit Error) * Decimal
    if(True):
      # Measure Unitless * Decimal
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          assert isinstance( (  Measure(value=3)  *  Decimal("3")  ), Measure )
          error = measure._sqrt_( (Decimal(3)**2 * Decimal("0")**2 + Decimal(3)**2 * Decimal("0.5")**2) )
          assert (  Measure(value=3)  *  Decimal("3")  ).value   == 9
          assert (  Measure(value=3)  *  Decimal("3")  ).error   == error
          assert (  Measure(value=3)  *  Decimal("3")  ).implied == True
          assert (  Measure(value=3)  *  Decimal("3")  ).units.symbols   == Unit().symbols
          assert (  Measure(value=3)  *  Decimal("3")  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=3)  *  Decimal("3")  ) == Measure(units=Unit(), value= 9, error=error)
          # Value 2: Float
          assert isinstance( (  Measure(value=0.3)  *  Decimal("3") ), Measure )
          error = measure._sqrt_( (3**2 * 0.05**2 + 0.3**2 * 0**2) )
          assert math.isclose( (  Measure(value=0.3)  *  Decimal("3")  ).value , 0.3*3 )
          assert math.isclose( (  Measure(value=0.3)  *  Decimal("3")  ).error , error   )
          assert (  Measure(value=0.3)  *  Decimal("3")  ).implied == True
          assert (  Measure(value=0.3)  *  Decimal("3")  ).units.symbols   == Unit().symbols
          assert (  Measure(value=0.3)  *  Decimal("3")  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=0.3)  *  Decimal("3")  ) == Measure(units=Unit(), value= 0.3*3, error=error)
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("40"))  *  Decimal("3")  ), Measure )
          error = measure._sqrt_( ( Decimal("40")**2 * Decimal("0")**2 + Decimal("3")**2 * Decimal("5")**2) )
          assert (  Measure(value=Decimal("40"))  *  Decimal("3")  ).value   == Decimal("40")*Decimal("3")
          assert (  Measure(value=Decimal("40"))  *  Decimal("3")  ).error   == error
          assert (  Measure(value=Decimal("40"))  *  Decimal("3")  ).implied == True
          assert (  Measure(value=Decimal("40"))  *  Decimal("3")  ).units.symbols   == Unit().symbols
          assert (  Measure(value=Decimal("40"))  *  Decimal("3")  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=Decimal("40"))  *  Decimal("3")  ) == Measure(units=Unit(), value= Decimal("40")*Decimal("3"), error=error)
          # Value 4: Negative
          assert isinstance( (  Measure(value=-3)  *  Decimal("3")  ), Measure )
          error = measure._sqrt_( (Decimal(3)**2 * Decimal("0")**2 + Decimal("3")**2 * Decimal("0.5")**2) )
          assert (  Measure(value=-3)  *  Decimal("3")  ).value   == -3*3
          assert (  Measure(value=-3)  *  Decimal("3")  ).error   == error
          assert (  Measure(value=-3)  *  Decimal("3")  ).implied == True
          assert (  Measure(value=-3)  *  Decimal("3")  ).units.symbols   == Unit().symbols
          assert (  Measure(value=-3)  *  Decimal("3")  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=-3)  *  Decimal("3")  ) == Measure(units=Unit(), value=-3*3, error=error)
        # Preserve Inputs
        if(True):
          a = Measure(value=3) 
          b = Decimal("3")
          c = a*b
          c = None
          assert a == Measure(value=3) 
          assert b == Decimal("3")
      # Measure Units * Decimal
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Measure(value=4,unit=Unit("cm"))  *  Decimal("3")  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0")**2 + Decimal(3)**2 * Decimal("0.5")**2) )
          assert (  Measure(value=4,unit=Unit("cm"))  *  Decimal("3")  ).value   == 4*3
          assert (  Measure(value=4,unit=Unit("cm"))  *  Decimal("3")  ).error   == error
          assert (  Measure(value=4,unit=Unit("cm"))  *  Decimal("3")  ).implied == True
          assert (  Measure(value=4,unit=Unit("cm"))  *  Decimal("3")  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=4,unit=Unit("cm"))  *  Decimal("3")  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=4,unit=Unit("cm"))  *  Decimal("3")  ) == Measure(units=Unit("cm"), value= 4*3, error=error)
          # Value 2: Float
          assert isinstance( ( Measure(value=0.4,unit=Unit("cm"))  *  Decimal("3")  ), Measure )
          error = measure._sqrt_( (0.4**2 * 0**2 + 3**2 * 0.05**2) )
          assert math.isclose( (  Measure(value=0.4,unit=Unit("cm"))  *  Decimal("3")  ).value , 0.4*3 )
          assert math.isclose( (  Measure(value=0.4,unit=Unit("cm"))  *  Decimal("3")  ).error , error   )
          assert (  Measure(value=0.4,unit=Unit("cm"))  *  Decimal("3")  ).implied == True
          assert (  Measure(value=0.4,unit=Unit("cm"))  *  Decimal("3")  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=0.4,unit=Unit("cm"))  *  Decimal("3")  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=0.4,unit=Unit("cm"))  *  Decimal("3")  ) == Measure(units=Unit("cm"), value= 0.4*3, error=error)
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  Decimal("3")  ), Measure )
          error = measure._sqrt_( (Decimal("40")**2 * Decimal("0")**2 + Decimal("3")**2 * Decimal("5")**2) )
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  Decimal("3")  ).value   == Decimal("40")*Decimal("3")
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  Decimal("3")  ).error   == error
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  Decimal("3")  ).implied == True
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  Decimal("3")  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  Decimal("3")  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  Decimal("3")  ) == Measure(units=Unit("cm"), value= Decimal("40")*Decimal("3"), error=error)
          # Value 4: Negative
          assert isinstance( ( Measure(value=-4,unit=Unit("cm"))  *  Decimal("3")  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0")**2 + Decimal("3")**2 * Decimal("0.5")**2) )
          assert (  Measure(value=-4,unit=Unit("cm"))  *  Decimal("3")  ).value   == -4*Decimal("3")
          assert (  Measure(value=-4,unit=Unit("cm"))  *  Decimal("3")  ).error   == error
          assert (  Measure(value=-4,unit=Unit("cm"))  *  Decimal("3")  ).implied == True
          assert (  Measure(value=-4,unit=Unit("cm"))  *  Decimal("3")  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=-4,unit=Unit("cm"))  *  Decimal("3")  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=-4,unit=Unit("cm"))  *  Decimal("3")  ) == Measure(units=Unit("cm"), value=-4*Decimal("3"), error=error)
        # Magnitude Units
        if(True):
          # Value 1: Int
          assert isinstance( (  Measure(value=2,unit=Unit("5 m^2"))  *  Decimal("3")  ) , Measure )
          error = measure._sqrt_( (Decimal("3")**2 * Decimal("2.5")**2 + Decimal(10)**2 * Decimal("0")**2) )/Decimal(5)
          assert (  Measure(value=2,unit=Unit("5 m^2"))  *  Decimal("3")  ).value   == 2*  Decimal("3")
          assert Measure._dec_isclose_( (  Measure(value=2,unit=Unit("5 m^2"))  *  Decimal("3")  ).error   , error )
          assert (  Measure(value=2,unit=Unit("5 m^2"))  *  Decimal("3")  ).implied == True
          assert (  Measure(value=2,unit=Unit("5 m^2"))  *  Decimal("3")  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=2,unit=Unit("5 m^2"))  *  Decimal("3")  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  Measure(value=2,unit=Unit("5 m^2"))  *  Decimal("3")  ) == Measure(units=Unit("5 m^2"), value=2*  Decimal("3"), error=error)
          # Value 2: Float
          assert isinstance( (  Measure(value=0.2,unit=Unit("5 m^2"))  *  Decimal("3")  ) , Measure )
          error = measure._sqrt_( (3**2 * 0.25**2 + 1.0**2 * 0**2) )/5
          assert math.isclose( (  Measure(value=0.2,unit=Unit("5 m^2"))  *  Decimal("3")  ).value , 0.2*3   )
          assert math.isclose( (  Measure(value=0.2,unit=Unit("5 m^2"))  *  Decimal("3")  ).error , error )
          assert (  Measure(value=0.2,unit=Unit("5 m^2"))  *  Decimal("3")  ).implied == True
          assert (  Measure(value=0.2,unit=Unit("5 m^2"))  *  Decimal("3")  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=0.2,unit=Unit("5 m^2"))  *  Decimal("3")  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  Measure(value=0.2,unit=Unit("5 m^2"))  *  Decimal("3")  ) == Measure(units=Unit("5 m^2"), value=0.2*3, error=error)
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  Decimal("3")  ) , Measure )
          error = measure._sqrt_( (Decimal("3")**2 * Decimal("25")**2 + Decimal("100")**2 * Decimal("0")**2) )/Decimal("5")
          assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  Decimal("3")  ).value   == Decimal("20")*Decimal("3")
          assert Measure._dec_isclose_( (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  Decimal("3")  ).error   , error )
          assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  Decimal("3")  ).implied == True
          assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  Decimal("3")  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  Decimal("3")  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  Decimal("3")  ) == Measure(units=Unit("5 m^2"), value=Decimal("20")*Decimal("3"), error=error)
          # Value 4: Negative
          assert isinstance( (  Measure(value=-2,unit=Unit("5 m^2"))  *  Decimal("3")  ) , Measure )
          error = measure._sqrt_( (Decimal("3")**2 * Decimal("2.5")**2 + Decimal(10)**2 * Decimal("0")**2) )/Decimal(5)
          assert (  Measure(value=-2,unit=Unit("5 m^2"))  *  Decimal("3")  ).value   == -2*Decimal("3")
          assert Measure._dec_isclose_( (  Measure(value=-2,unit=Unit("5 m^2"))  *  Decimal("3")  ).error   , error )
          assert (  Measure(value=-2,unit=Unit("5 m^2"))  *  Decimal("3")  ).implied == True
          assert (  Measure(value=-2,unit=Unit("5 m^2"))  *  Decimal("3")  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=-2,unit=Unit("5 m^2"))  *  Decimal("3")  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  Measure(value=-2,unit=Unit("5 m^2"))  *  Decimal("3")  ) == Measure(units=Unit("5 m^2"), value=-2*Decimal("3"), error=error)
        # Convoluted Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Measure(value=27,unit=Unit("\u00B0C"))  *  Decimal("3") ), Measure )
          error = measure._sqrt_( (Decimal("3")**2 * Decimal("0.5")**2 + Decimal("300.15")**2 * Decimal("0")**2) )
          assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  Decimal("3") ).value   == Decimal("3")*Decimal("300.15")-Decimal("273.15")
          assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  Decimal("3") ).error   == error
          assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  Decimal("3") ).implied == True
          assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  Decimal("3") ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  Decimal("3") ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  Decimal("3") ) == Measure(units=Unit("\u00B0C"), value=Decimal("3")*Decimal("300.15")-Decimal("273.15"), error=error)
          # Value 2: Float
          assert isinstance( ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  Decimal("3") ), Measure )
          error = measure._sqrt_( (3**2 * 0.005**2 + 300**2 * 0**2) )
          assert math.isclose( ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  Decimal("3") ).value   , 3 * 300 - 273.15 )
          assert math.isclose( ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  Decimal("3") ).error   , error )
          assert ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  Decimal("3") ).implied == True
          assert ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  Decimal("3") ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  Decimal("3") ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  Decimal("3") ) == Measure(units=Unit("\u00B0C"), value= 3 * 300 - 273.15, error=error)
          # Value 3: Decimal
          assert isinstance( ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  Decimal("3") ), Measure )
          error = measure._sqrt_( (Decimal("3")**2 * Decimal("0.005")**2 + Decimal("300")**2 * Decimal("0")**2) )
          assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  Decimal("3") ).value   == Decimal("3") * Decimal("300") -Decimal("273.15")
          assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  Decimal("3") ).error   == error
          assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  Decimal("3") ).implied == True
          assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  Decimal("3") ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  Decimal("3") ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  Decimal("3") ) == Measure(units=Unit("\u00B0C"), value=Decimal("3") * Decimal("300")-Decimal("273.15"), error=error)
          # Value 4: Negative
          assert isinstance( ( Measure(value=-27,unit=Unit("\u00B0C"))  *  Decimal("3") ), Measure )
          error = measure._sqrt_( (Decimal("3")**2 * Decimal("0.5")**2 + Decimal("246.15")**2 * Decimal("0")**2) )
          assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  Decimal("3") ).value   == Decimal("3")*Decimal("246.15")-Decimal("273.15")
          assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  Decimal("3") ).error   == error
          assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  Decimal("3") ).implied == True
          assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  Decimal("3") ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  Decimal("3") ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  Decimal("3") ) == Measure(units=Unit("\u00B0C"), value= Decimal("3")*Decimal("246.15")-Decimal("273.15"), error=error)
        # Preserve Inputs
        if(True):
          a = Measure(value=4,unit=Unit("cm"))
          b = Decimal("3")
          c = a*b
          c = None
          assert a == Measure(value=4,unit=Unit("cm"))
          assert b == Decimal("3")
    # Decimal * Measure (Explicit Error)
    if(True):
      # Decimal * Measure Unitless
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          assert isinstance( (  Decimal("3") * Measure(value=3,error=2)  ), Measure )
          error = measure._sqrt_( (Decimal(3)**2 * Decimal("0")**2 + Decimal(3)**2 * Decimal(2)**2) )
          assert (  Decimal("3") * Measure(value=3,error=2)  ).value   == 9
          assert (  Decimal("3") * Measure(value=3,error=2)  ).error   == error
          assert (  Decimal("3") * Measure(value=3,error=2)  ).implied == False
          assert (  Decimal("3") * Measure(value=3,error=2)  ).units.symbols   == Unit().symbols
          assert (  Decimal("3") * Measure(value=3,error=2)  ).units.magnitude == Unit().magnitude
          assert (  Decimal("3") * Measure(value=3,error=2)  ) == Measure(units=Unit(), value= 9, error=error)
          # Value 2: Float
          assert isinstance( (  Decimal("3") * Measure(value=0.3,error=0.2) ), Measure )
          error = measure._sqrt_( (3**2 * 0.2**2 + 0.3**2 * 0**2) )
          assert math.isclose( (  Decimal("3") * Measure(value=0.3,error=0.2)  ).value , 0.3*3 )
          assert math.isclose( (  Decimal("3") * Measure(value=0.3,error=0.2)  ).error , error   )
          assert (  Decimal("3") * Measure(value=0.3,error=0.2)  ).implied == False
          assert (  Decimal("3") * Measure(value=0.3,error=0.2)  ).units.symbols   == Unit().symbols
          assert (  Decimal("3") * Measure(value=0.3,error=0.2)  ).units.magnitude == Unit().magnitude
          assert (  Decimal("3") * Measure(value=0.3,error=0.2)  ) == Measure(units=Unit(), value= 0.3*3, error=error)
          # Value 3: Decimal
          assert isinstance( (  Decimal("3") * Measure(value=Decimal("40"),error=Decimal("20"))  ), Measure )
          error = measure._sqrt_( ( Decimal("40")**2 * Decimal("0")**2 + Decimal("3")**2 * Decimal("20")**2) )
          assert (  Decimal("3") * Measure(value=Decimal("40"),error=Decimal("20"))  ).value   == Decimal("40")*Decimal("3")
          assert (  Decimal("3") * Measure(value=Decimal("40"),error=Decimal("20"))  ).error   == error
          assert (  Decimal("3") * Measure(value=Decimal("40"),error=Decimal("20"))  ).implied == False
          assert (  Decimal("3") * Measure(value=Decimal("40"),error=Decimal("20"))  ).units.symbols   == Unit().symbols
          assert (  Decimal("3") * Measure(value=Decimal("40"),error=Decimal("20"))  ).units.magnitude == Unit().magnitude
          assert (  Decimal("3") * Measure(value=Decimal("40"),error=Decimal("20"))  ) == Measure(units=Unit(), value= Decimal("40")*Decimal("3"), error=error)
          # Value 4: Negative
          assert isinstance( (  Decimal("3") * Measure(value=-3,error=2)  ), Measure )
          error = measure._sqrt_( (Decimal(3)**2 * Decimal("0")**2 + Decimal("3")**2 * Decimal(2)**2) )
          assert (  Decimal("3") * Measure(value=-3,error=2)  ).value   == -3*3
          assert (  Decimal("3") * Measure(value=-3,error=2)  ).error   == error
          assert (  Decimal("3") * Measure(value=-3,error=2)  ).implied == False
          assert (  Decimal("3") * Measure(value=-3,error=2)  ).units.symbols   == Unit().symbols
          assert (  Decimal("3") * Measure(value=-3,error=2)  ).units.magnitude == Unit().magnitude
          assert (  Decimal("3") * Measure(value=-3,error=2)  ) == Measure(units=Unit(), value=-3*3, error=error)
        # Preserve Inputs
        if(True):
          a = Decimal("3")
          b = Measure(value=3,error=2) 
          c = a*b
          c = None
          assert a == Decimal("3")
          assert b == Measure(value=3,error=2) 
      # Decimal * Measure Units 
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Decimal("3") * Measure(value=4,error=2,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0")**2 + Decimal(3)**2 * Decimal(2)**2) )
          assert (  Decimal("3") * Measure(value=4,error=2,unit=Unit("cm"))  ).value   == 4*3
          assert (  Decimal("3") * Measure(value=4,error=2,unit=Unit("cm"))  ).error   == error
          assert (  Decimal("3") * Measure(value=4,error=2,unit=Unit("cm"))  ).implied == False
          assert (  Decimal("3") * Measure(value=4,error=2,unit=Unit("cm"))  ).units.symbols   == Unit("cm").symbols
          assert (  Decimal("3") * Measure(value=4,error=2,unit=Unit("cm"))  ).units.magnitude == Unit("cm").magnitude
          assert (  Decimal("3") * Measure(value=4,error=2,unit=Unit("cm"))  ) == Measure(units=Unit("cm"), value= 4*3, error=error)
          # Value 2: Float
          assert isinstance( ( Decimal("3") * Measure(value=0.4,error=0.2,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (0.4**2 * 0**2 + 3**2 * 0.2**2) )
          assert math.isclose( (  Decimal("3") * Measure(value=0.4,error=0.2,unit=Unit("cm"))  ).value , 0.4*3 )
          assert math.isclose( (  Decimal("3") * Measure(value=0.4,error=0.2,unit=Unit("cm"))  ).error , error   )
          assert (  Decimal("3") * Measure(value=0.4,error=0.2,unit=Unit("cm"))  ).implied == False
          assert (  Decimal("3") * Measure(value=0.4,error=0.2,unit=Unit("cm"))  ).units.symbols   == Unit("cm").symbols
          assert (  Decimal("3") * Measure(value=0.4,error=0.2,unit=Unit("cm"))  ).units.magnitude == Unit("cm").magnitude
          assert (  Decimal("3") * Measure(value=0.4,error=0.2,unit=Unit("cm"))  ) == Measure(units=Unit("cm"), value= 0.4*3, error=error)
          # Value 3: Decimal
          assert isinstance( (  Decimal("3") * Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (Decimal("40")**2 * Decimal("0")**2 + Decimal("3")**2 * Decimal("20")**2) )
          assert (  Decimal("3") * Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  ).value   == Decimal("40")*Decimal("3")
          assert (  Decimal("3") * Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  ).error   == error
          assert (  Decimal("3") * Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  ).implied == False
          assert (  Decimal("3") * Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  ).units.symbols   == Unit("cm").symbols
          assert (  Decimal("3") * Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  ).units.magnitude == Unit("cm").magnitude
          assert (  Decimal("3") * Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  ) == Measure(units=Unit("cm"), value= Decimal("40")*Decimal("3"), error=error)
          # Value 4: Negative
          assert isinstance( ( Decimal("3") * Measure(value=-4,error=2,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0")**2 + Decimal("3")**2 * Decimal(2)**2) )
          assert (  Decimal("3") * Measure(value=-4,error=2,unit=Unit("cm"))  ).value   == -4*Decimal("3")
          assert (  Decimal("3") * Measure(value=-4,error=2,unit=Unit("cm"))  ).error   == error
          assert (  Decimal("3") * Measure(value=-4,error=2,unit=Unit("cm"))  ).implied == False
          assert (  Decimal("3") * Measure(value=-4,error=2,unit=Unit("cm"))  ).units.symbols   == Unit("cm").symbols
          assert (  Decimal("3") * Measure(value=-4,error=2,unit=Unit("cm"))  ).units.magnitude == Unit("cm").magnitude
          assert (  Decimal("3") * Measure(value=-4,error=2,unit=Unit("cm"))  ) == Measure(units=Unit("cm"), value=-4*Decimal("3"), error=error)
        # Magnitude Units
        if(True):
          # Value 1: Int
          assert isinstance( (  Decimal("3") * Measure(value=2,error=1,unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (Decimal("3")**2 * Decimal(5)**2 + Decimal(10)**2 * Decimal("0")**2) )/Decimal(5)
          assert (  Decimal("3") * Measure(value=2,error=1,unit=Unit("5 m^2"))  ).value   == 2*  Decimal("3")
          assert Measure._dec_isclose_( (  Decimal("3") * Measure(value=2,error=1,unit=Unit("5 m^2"))  ).error   , error )
          assert (  Decimal("3") * Measure(value=2,error=1,unit=Unit("5 m^2"))  ).implied == False
          assert (  Decimal("3") * Measure(value=2,error=1,unit=Unit("5 m^2"))  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Decimal("3") * Measure(value=2,error=1,unit=Unit("5 m^2"))  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  Decimal("3") * Measure(value=2,error=1,unit=Unit("5 m^2"))  ) == Measure(units=Unit("5 m^2"), value=2*  Decimal("3"), error=error)
          # Value 2: Float
          assert isinstance( (  Decimal("3") * Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (3**2 * 0.5**2 + 1.0**2 * 0**2) )/5
          assert math.isclose( (  Decimal("3") * Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  ).value , 0.2*3   )
          assert math.isclose( (  Decimal("3") * Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  ).error , error )
          assert (  Decimal("3") * Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  ).implied == False
          assert (  Decimal("3") * Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Decimal("3") * Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  Decimal("3") * Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  ) == Measure(units=Unit("5 m^2"), value=0.2*3, error=error)
          # Value 3: Decimal
          assert isinstance( (  Decimal("3") * Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (Decimal("3")**2 * Decimal("25")**2 + Decimal("100")**2 * Decimal("0")**2) )/Decimal("5")
          assert (  Decimal("3") * Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  ).value   == Decimal("20")*Decimal("3")
          assert Measure._dec_isclose_( (  Decimal("3") * Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  ).error   , error )
          assert (  Decimal("3") * Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  ).implied == False
          assert (  Decimal("3") * Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Decimal("3") * Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  Decimal("3") * Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  ) == Measure(units=Unit("5 m^2"), value=Decimal("20")*Decimal("3"), error=error)
          # Value 4: Negative
          assert isinstance( (  Decimal("3") * Measure(value=-2,error=1,unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (Decimal("3")**2 * Decimal(5)**2 + Decimal(10)**2 * Decimal("0")**2) )/Decimal(5)
          assert (  Decimal("3") * Measure(value=-2,error=1,unit=Unit("5 m^2"))  ).value   == -2*Decimal("3")
          assert Measure._dec_isclose_( (  Decimal("3") * Measure(value=-2,error=1,unit=Unit("5 m^2"))  ).error   , error )
          assert (  Decimal("3") * Measure(value=-2,error=1,unit=Unit("5 m^2"))  ).implied == False
          assert (  Decimal("3") * Measure(value=-2,error=1,unit=Unit("5 m^2"))  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Decimal("3") * Measure(value=-2,error=1,unit=Unit("5 m^2"))  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  Decimal("3") * Measure(value=-2,error=1,unit=Unit("5 m^2"))  ) == Measure(units=Unit("5 m^2"), value=-2*Decimal("3"), error=error)
        # Convoluted Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Decimal("3") * Measure(value=27,error=1,unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (Decimal("3")**2 * Decimal("1")**2 + Decimal("300.15")**2 * Decimal("0")**2) )
          assert ( Decimal("3") * Measure(value=27,error=1,unit=Unit("\u00B0C")) ).value   == Decimal("3")*Decimal("300.15")-Decimal("273.15")
          assert ( Decimal("3") * Measure(value=27,error=1,unit=Unit("\u00B0C")) ).error   == error
          assert ( Decimal("3") * Measure(value=27,error=1,unit=Unit("\u00B0C")) ).implied == False
          assert ( Decimal("3") * Measure(value=27,error=1,unit=Unit("\u00B0C")) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Decimal("3") * Measure(value=27,error=1,unit=Unit("\u00B0C")) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Decimal("3") * Measure(value=27,error=1,unit=Unit("\u00B0C")) ) == Measure(units=Unit("\u00B0C"), value=Decimal("3")*Decimal("300.15")-Decimal("273.15"), error=error)
          # Value 2: Float
          assert isinstance( ( Decimal("3") * Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (3**2 * 0.02**2 + 300**2 * 0**2) )
          assert math.isclose( ( Decimal("3") * Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).value   , 3 * 300 - 273.15 )
          assert math.isclose( ( Decimal("3") * Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).error   , error )
          assert ( Decimal("3") * Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).implied == False
          assert ( Decimal("3") * Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Decimal("3") * Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Decimal("3") * Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ) == Measure(units=Unit("\u00B0C"), value= 3 * 300 - 273.15, error=error)
          # Value 3: Decimal
          assert isinstance( ( Decimal("3") * Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (Decimal("3")**2 * Decimal("0.02")**2 + Decimal("300")**2 * Decimal("0")**2) )
          assert ( Decimal("3") * Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).value   == Decimal("3") * Decimal("300") -Decimal("273.15")
          assert ( Decimal("3") * Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).error   == error
          assert ( Decimal("3") * Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).implied == False
          assert ( Decimal("3") * Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Decimal("3") * Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Decimal("3") * Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ) == Measure(units=Unit("\u00B0C"), value=Decimal("3") * Decimal("300")-Decimal("273.15"), error=error)
          # Value 4: Negative
          assert isinstance( ( Decimal("3") * Measure(value=-27,error=1,unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (Decimal("3")**2 * Decimal("1")**2 + Decimal("246.15")**2 * Decimal("0")**2) )
          assert ( Decimal("3") * Measure(value=-27,error=1,unit=Unit("\u00B0C")) ).value   == Decimal("3")*Decimal("246.15")-Decimal("273.15")
          assert ( Decimal("3") * Measure(value=-27,error=1,unit=Unit("\u00B0C")) ).error   == error
          assert ( Decimal("3") * Measure(value=-27,error=1,unit=Unit("\u00B0C")) ).implied == False
          assert ( Decimal("3") * Measure(value=-27,error=1,unit=Unit("\u00B0C")) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Decimal("3") * Measure(value=-27,error=1,unit=Unit("\u00B0C")) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Decimal("3") * Measure(value=-27,error=1,unit=Unit("\u00B0C")) ) == Measure(units=Unit("\u00B0C"), value= Decimal("3")*Decimal("246.15")-Decimal("273.15"), error=error)
        # Preserve Inputs
        if(True):
          a = Decimal("3")
          b = Measure(value=4,error=2,unit=Unit("cm"))
          c = a*b
          c = None
          assert a == Decimal("3")
          assert b == Measure(value=4,error=2,unit=Unit("cm"))
    # Decimal * Measure (Implicit Error)
    if(True):
      # Decimal * Measure Unitless
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          assert isinstance( (  Decimal("3") * Measure(value=3)  ), Measure )
          error = measure._sqrt_( (Decimal(3)**2 * Decimal("0")**2 + Decimal(3)**2 * Decimal("0.5")**2) )
          assert (  Decimal("3") * Measure(value=3)  ).value   == 9
          assert (  Decimal("3") * Measure(value=3)  ).error   == error
          assert (  Decimal("3") * Measure(value=3)  ).implied == True
          assert (  Decimal("3") * Measure(value=3)  ).units.symbols   == Unit().symbols
          assert (  Decimal("3") * Measure(value=3)  ).units.magnitude == Unit().magnitude
          assert (  Decimal("3") * Measure(value=3)  ) == Measure(units=Unit(), value= 9, error=error)
          # Value 2: Float
          assert isinstance( (  Decimal("3") * Measure(value=0.3) ), Measure )
          error = measure._sqrt_( (3**2 * 0.05**2 + 0.3**2 * 0**2) )
          assert math.isclose( (  Decimal("3") * Measure(value=0.3)  ).value , 0.3*3 )
          assert math.isclose( (  Decimal("3") * Measure(value=0.3)  ).error , error   )
          assert (  Decimal("3") * Measure(value=0.3)  ).implied == True
          assert (  Decimal("3") * Measure(value=0.3)  ).units.symbols   == Unit().symbols
          assert (  Decimal("3") * Measure(value=0.3)  ).units.magnitude == Unit().magnitude
          assert (  Decimal("3") * Measure(value=0.3)  ) == Measure(units=Unit(), value= 0.3*3, error=error)
          # Value 3: Decimal
          assert isinstance( (  Decimal("3") * Measure(value=Decimal("40"))  ), Measure )
          error = measure._sqrt_( ( Decimal("40")**2 * Decimal("0")**2 + Decimal("3")**2 * Decimal("5")**2) )
          assert (  Decimal("3") * Measure(value=Decimal("40"))  ).value   == Decimal("40")*Decimal("3")
          assert (  Decimal("3") * Measure(value=Decimal("40"))  ).error   == error
          assert (  Decimal("3") * Measure(value=Decimal("40"))  ).implied == True
          assert (  Decimal("3") * Measure(value=Decimal("40"))  ).units.symbols   == Unit().symbols
          assert (  Decimal("3") * Measure(value=Decimal("40"))  ).units.magnitude == Unit().magnitude
          assert (  Decimal("3") * Measure(value=Decimal("40"))  ) == Measure(units=Unit(), value= Decimal("40")*Decimal("3"), error=error)
          # Value 4: Negative
          assert isinstance( (  Decimal("3") * Measure(value=-3)  ), Measure )
          error = measure._sqrt_( (Decimal(3)**2 * Decimal("0")**2 + Decimal("3")**2 * Decimal("0.5")**2) )
          assert (  Decimal("3") * Measure(value=-3)  ).value   == -3*3
          assert (  Decimal("3") * Measure(value=-3)  ).error   == error
          assert (  Decimal("3") * Measure(value=-3)  ).implied == True
          assert (  Decimal("3") * Measure(value=-3)  ).units.symbols   == Unit().symbols
          assert (  Decimal("3") * Measure(value=-3)  ).units.magnitude == Unit().magnitude
          assert (  Decimal("3") * Measure(value=-3)  ) == Measure(units=Unit(), value=-3*3, error=error)
        # Preserve Inputs
        if(True):
          a = Decimal("3")
          b = Measure(value=3) 
          c = a*b
          c = None
          assert a == Decimal("3") 
          assert b == Measure(value=3) 
      # Decimal * Measure Units
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Decimal("3") * Measure(value=4,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0")**2 + Decimal(3)**2 * Decimal("0.5")**2) )
          assert (  Decimal("3") * Measure(value=4,unit=Unit("cm"))  ).value   == 4*3
          assert (  Decimal("3") * Measure(value=4,unit=Unit("cm"))  ).error   == error
          assert (  Decimal("3") * Measure(value=4,unit=Unit("cm"))  ).implied == True
          assert (  Decimal("3") * Measure(value=4,unit=Unit("cm"))  ).units.symbols   == Unit("cm").symbols
          assert (  Decimal("3") * Measure(value=4,unit=Unit("cm"))  ).units.magnitude == Unit("cm").magnitude
          assert (  Decimal("3") * Measure(value=4,unit=Unit("cm"))  ) == Measure(units=Unit("cm"), value= 4*3, error=error)
          # Value 2: Float
          assert isinstance( ( Decimal("3") * Measure(value=0.4,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (0.4**2 * 0**2 + 3**2 * 0.05**2) )
          assert math.isclose( (  Decimal("3") * Measure(value=0.4,unit=Unit("cm"))  ).value , 0.4*3 )
          assert math.isclose( (  Decimal("3") * Measure(value=0.4,unit=Unit("cm"))  ).error , error   )
          assert (  Decimal("3") * Measure(value=0.4,unit=Unit("cm"))  ).implied == True
          assert (  Decimal("3") * Measure(value=0.4,unit=Unit("cm"))  ).units.symbols   == Unit("cm").symbols
          assert (  Decimal("3") * Measure(value=0.4,unit=Unit("cm"))  ).units.magnitude == Unit("cm").magnitude
          assert (  Decimal("3") * Measure(value=0.4,unit=Unit("cm"))  ) == Measure(units=Unit("cm"), value= 0.4*3, error=error)
          # Value 3: Decimal
          assert isinstance( (  Decimal("3") * Measure(value=Decimal("40"),unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (Decimal("40")**2 * Decimal("0")**2 + Decimal("3")**2 * Decimal("5")**2) )
          assert (  Decimal("3") * Measure(value=Decimal("40"),unit=Unit("cm"))  ).value   == Decimal("40")*Decimal("3")
          assert (  Decimal("3") * Measure(value=Decimal("40"),unit=Unit("cm"))  ).error   == error
          assert (  Decimal("3") * Measure(value=Decimal("40"),unit=Unit("cm"))  ).implied == True
          assert (  Decimal("3") * Measure(value=Decimal("40"),unit=Unit("cm"))  ).units.symbols   == Unit("cm").symbols
          assert (  Decimal("3") * Measure(value=Decimal("40"),unit=Unit("cm"))  ).units.magnitude == Unit("cm").magnitude
          assert (  Decimal("3") * Measure(value=Decimal("40"),unit=Unit("cm"))  ) == Measure(units=Unit("cm"), value= Decimal("40")*Decimal("3"), error=error)
          # Value 4: Negative
          assert isinstance( ( Decimal("3") * Measure(value=-4,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0")**2 + Decimal("3")**2 * Decimal("0.5")**2) )
          assert (  Decimal("3") * Measure(value=-4,unit=Unit("cm"))  ).value   == -4*Decimal("3")
          assert (  Decimal("3") * Measure(value=-4,unit=Unit("cm"))  ).error   == error
          assert (  Decimal("3") * Measure(value=-4,unit=Unit("cm"))  ).implied == True
          assert (  Decimal("3") * Measure(value=-4,unit=Unit("cm"))  ).units.symbols   == Unit("cm").symbols
          assert (  Decimal("3") * Measure(value=-4,unit=Unit("cm"))  ).units.magnitude == Unit("cm").magnitude
          assert (  Decimal("3") * Measure(value=-4,unit=Unit("cm"))  ) == Measure(units=Unit("cm"), value=-4*Decimal("3"), error=error)
        # Magnitude Units
        if(True):
          # Value 1: Int
          assert isinstance( (  Decimal("3") * Measure(value=2,unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (Decimal("3")**2 * Decimal("2.5")**2 + Decimal(10)**2 * Decimal("0")**2) )/Decimal(5)
          assert (  Decimal("3") * Measure(value=2,unit=Unit("5 m^2"))  ).value   == 2*  Decimal("3")
          assert Measure._dec_isclose_( (  Decimal("3") * Measure(value=2,unit=Unit("5 m^2"))  ).error   , error )
          assert (  Decimal("3") * Measure(value=2,unit=Unit("5 m^2"))  ).implied == True
          assert (  Decimal("3") * Measure(value=2,unit=Unit("5 m^2"))  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Decimal("3") * Measure(value=2,unit=Unit("5 m^2"))  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  Decimal("3") * Measure(value=2,unit=Unit("5 m^2"))  ) == Measure(units=Unit("5 m^2"), value=2*  Decimal("3"), error=error)
          # Value 2: Float
          assert isinstance( (  Decimal("3") * Measure(value=0.2,unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (3**2 * 0.25**2 + 1.0**2 * 0**2) )/5
          assert math.isclose( (  Decimal("3") * Measure(value=0.2,unit=Unit("5 m^2"))  ).value , 0.2*3   )
          assert math.isclose( (  Decimal("3") * Measure(value=0.2,unit=Unit("5 m^2"))  ).error , error )
          assert (  Decimal("3") * Measure(value=0.2,unit=Unit("5 m^2"))  ).implied == True
          assert (  Decimal("3") * Measure(value=0.2,unit=Unit("5 m^2"))  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Decimal("3") * Measure(value=0.2,unit=Unit("5 m^2"))  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  Decimal("3") * Measure(value=0.2,unit=Unit("5 m^2"))  ) == Measure(units=Unit("5 m^2"), value=0.2*3, error=error)
          # Value 3: Decimal
          assert isinstance( (  Decimal("3") * Measure(value=Decimal("20"),unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (Decimal("3")**2 * Decimal("25")**2 + Decimal("100")**2 * Decimal("0")**2) )/Decimal("5")
          assert (  Decimal("3") * Measure(value=Decimal("20"),unit=Unit("5 m^2"))  ).value   == Decimal("20")*Decimal("3")
          assert Measure._dec_isclose_( (  Decimal("3") * Measure(value=Decimal("20"),unit=Unit("5 m^2"))  ).error   , error )
          assert (  Decimal("3") * Measure(value=Decimal("20"),unit=Unit("5 m^2"))  ).implied == True
          assert (  Decimal("3") * Measure(value=Decimal("20"),unit=Unit("5 m^2"))  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Decimal("3") * Measure(value=Decimal("20"),unit=Unit("5 m^2"))  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  Decimal("3") * Measure(value=Decimal("20"),unit=Unit("5 m^2"))  ) == Measure(units=Unit("5 m^2"), value=Decimal("20")*Decimal("3"), error=error)
          # Value 4: Negative
          assert isinstance( (  Decimal("3") * Measure(value=-2,unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (Decimal("3")**2 * Decimal("2.5")**2 + Decimal(10)**2 * Decimal("0")**2) )/Decimal(5)
          assert (  Decimal("3") * Measure(value=-2,unit=Unit("5 m^2"))  ).value   == -2*Decimal("3")
          assert Measure._dec_isclose_( (  Decimal("3") * Measure(value=-2,unit=Unit("5 m^2"))  ).error   , error )
          assert (  Decimal("3") * Measure(value=-2,unit=Unit("5 m^2"))  ).implied == True
          assert (  Decimal("3") * Measure(value=-2,unit=Unit("5 m^2"))  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Decimal("3") * Measure(value=-2,unit=Unit("5 m^2"))  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  Decimal("3") * Measure(value=-2,unit=Unit("5 m^2"))  ) == Measure(units=Unit("5 m^2"), value=-2*Decimal("3"), error=error)
        # Convoluted Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Decimal("3") * Measure(value=27,unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (Decimal("3")**2 * Decimal("0.5")**2 + Decimal("300.15")**2 * Decimal("0")**2) )
          assert ( Decimal("3") * Measure(value=27,unit=Unit("\u00B0C")) ).value   == Decimal("3")*Decimal("300.15")-Decimal("273.15")
          assert ( Decimal("3") * Measure(value=27,unit=Unit("\u00B0C")) ).error   == error
          assert ( Decimal("3") * Measure(value=27,unit=Unit("\u00B0C")) ).implied == True
          assert ( Decimal("3") * Measure(value=27,unit=Unit("\u00B0C")) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Decimal("3") * Measure(value=27,unit=Unit("\u00B0C")) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Decimal("3") * Measure(value=27,unit=Unit("\u00B0C")) ) == Measure(units=Unit("\u00B0C"), value=Decimal("3")*Decimal("300.15")-Decimal("273.15"), error=error)
          # Value 2: Float
          assert isinstance( ( Decimal("3") * Measure(value=26.85,unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (3**2 * 0.005**2 + 300**2 * 0**2) )
          assert math.isclose( ( Decimal("3") * Measure(value=26.85,unit=Unit("\u00B0C")) ).value   , 3 * 300 - 273.15 )
          assert math.isclose( ( Decimal("3") * Measure(value=26.85,unit=Unit("\u00B0C")) ).error   , error )
          assert ( Decimal("3") * Measure(value=26.85,unit=Unit("\u00B0C")) ).implied == True
          assert ( Decimal("3") * Measure(value=26.85,unit=Unit("\u00B0C")) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Decimal("3") * Measure(value=26.85,unit=Unit("\u00B0C")) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Decimal("3") * Measure(value=26.85,unit=Unit("\u00B0C")) ) == Measure(units=Unit("\u00B0C"), value= 3 * 300 - 273.15, error=error)
          # Value 3: Decimal
          assert isinstance( ( Decimal("3") * Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (Decimal("3")**2 * Decimal("0.005")**2 + Decimal("300")**2 * Decimal("0")**2) )
          assert ( Decimal("3") * Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).value   == Decimal("3") * Decimal("300") -Decimal("273.15")
          assert ( Decimal("3") * Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).error   == error
          assert ( Decimal("3") * Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).implied == True
          assert ( Decimal("3") * Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Decimal("3") * Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Decimal("3") * Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ) == Measure(units=Unit("\u00B0C"), value=Decimal("3") * Decimal("300")-Decimal("273.15"), error=error)
          # Value 4: Negative
          assert isinstance( ( Decimal("3") * Measure(value=-27,unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (Decimal("3")**2 * Decimal("0.5")**2 + Decimal("246.15")**2 * Decimal("0")**2) )
          assert ( Decimal("3") * Measure(value=-27,unit=Unit("\u00B0C")) ).value   == Decimal("3")*Decimal("246.15")-Decimal("273.15")
          assert ( Decimal("3") * Measure(value=-27,unit=Unit("\u00B0C")) ).error   == error
          assert ( Decimal("3") * Measure(value=-27,unit=Unit("\u00B0C")) ).implied == True
          assert ( Decimal("3") * Measure(value=-27,unit=Unit("\u00B0C")) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Decimal("3") * Measure(value=-27,unit=Unit("\u00B0C")) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Decimal("3") * Measure(value=-27,unit=Unit("\u00B0C")) ) == Measure(units=Unit("\u00B0C"), value= Decimal("3")*Decimal("246.15")-Decimal("273.15"), error=error)
        # Preserve Inputs
        if(True):
          a = Decimal("3")
          b = Measure(value=4,unit=Unit("cm"))
          c = a*b
          c = None
          assert a == Decimal("3")
          assert b == Measure(value=4,unit=Unit("cm"))
    
  def test_measure_int_mul(self):
    # Measure (Explicit Error) * Int
    if(True):
      # Measure Unitless * Int
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          assert isinstance( (  Measure(value=3,error=2)  *  3  ), Measure )
          error = measure._sqrt_( (Decimal(3)**2 * Decimal("0")**2 + Decimal(3)**2 * Decimal(2)**2) )
          assert (  Measure(value=3,error=2)  *  3  ).value   == 9
          assert (  Measure(value=3,error=2)  *  3  ).error   == error
          assert (  Measure(value=3,error=2)  *  3  ).implied == False
          assert (  Measure(value=3,error=2)  *  3  ).units.symbols   == Unit().symbols
          assert (  Measure(value=3,error=2)  *  3  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=3,error=2)  *  3  ) == Measure(units=Unit(), value= 9, error=error)
          # Value 2: Float
          assert isinstance( (  Measure(value=0.3,error=0.2)  *  3 ), Measure )
          error = measure._sqrt_( (3**2 * 0.2**2 + 0.3**2 * 0**2) )
          assert math.isclose( (  Measure(value=0.3,error=0.2)  *  3  ).value , 0.3*3 )
          assert math.isclose( (  Measure(value=0.3,error=0.2)  *  3  ).error , error   )
          assert (  Measure(value=0.3,error=0.2)  *  3  ).implied == False
          assert (  Measure(value=0.3,error=0.2)  *  3  ).units.symbols   == Unit().symbols
          assert (  Measure(value=0.3,error=0.2)  *  3  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=0.3,error=0.2)  *  3  ) == Measure(units=Unit(), value= 0.3*3, error=error)
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("40"),error=Decimal("20"))  *  3  ), Measure )
          error = measure._sqrt_( ( Decimal("40")**2 * Decimal("0")**2 + 3**2 * Decimal("20")**2) )
          assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  3  ).value   == Decimal("40")*3
          assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  3  ).error   == error
          assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  3  ).implied == False
          assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  3  ).units.symbols   == Unit().symbols
          assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  3  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  3  ) == Measure(units=Unit(), value= Decimal("40")*3, error=error)
          # Value 4: Negative
          assert isinstance( (  Measure(value=-3,error=2)  *  3  ), Measure )
          error = measure._sqrt_( (Decimal(3)**2 * Decimal("0")**2 + 3**2 * Decimal(2)**2) )
          assert (  Measure(value=-3,error=2)  *  3  ).value   == -3*3
          assert (  Measure(value=-3,error=2)  *  3  ).error   == error
          assert (  Measure(value=-3,error=2)  *  3  ).implied == False
          assert (  Measure(value=-3,error=2)  *  3  ).units.symbols   == Unit().symbols
          assert (  Measure(value=-3,error=2)  *  3  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=-3,error=2)  *  3  ) == Measure(units=Unit(), value=-3*3, error=error)
        # Preserve Inputs
        if(True):
          a = Measure(value=3,error=2) 
          b = 3
          c = a*b
          c = None
          assert a == Measure(value=3,error=2) 
          assert b == 3
      # Measure Units * Int
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Measure(value=4,error=2,unit=Unit("cm"))  *  3  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0")**2 + Decimal(3)**2 * Decimal(2)**2) )
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  3  ).value   == 4*3
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  3  ).error   == error
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  3  ).implied == False
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  3  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  3  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  3  ) == Measure(units=Unit("cm"), value= 4*3, error=error)
          # Value 2: Float
          assert isinstance( ( Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  3  ), Measure )
          error = measure._sqrt_( (0.4**2 * 0**2 + 3**2 * 0.2**2) )
          assert math.isclose( (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  3  ).value , 0.4*3 )
          assert math.isclose( (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  3  ).error , error   )
          assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  3  ).implied == False
          assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  3  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  3  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  3  ) == Measure(units=Unit("cm"), value= 0.4*3, error=error)
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  3  ), Measure )
          error = measure._sqrt_( (Decimal("40")**2 * Decimal("0")**2 + 3**2 * Decimal("20")**2) )
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  3  ).value   == Decimal("40")*3
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  3  ).error   == error
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  3  ).implied == False
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  3  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  3  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  3  ) == Measure(units=Unit("cm"), value= Decimal("40")*3, error=error)
          # Value 4: Negative
          assert isinstance( ( Measure(value=-4,error=2,unit=Unit("cm"))  *  3  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0")**2 + 3**2 * Decimal(2)**2) )
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  3  ).value   == -4*3
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  3  ).error   == error
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  3  ).implied == False
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  3  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  3  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  3  ) == Measure(units=Unit("cm"), value=-4*3, error=error)
        # Magnitude Units
        if(True):
          # Value 1: Int
          assert isinstance( (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  3  ) , Measure )
          error = measure._sqrt_( (3**2 * Decimal(5)**2 + Decimal(10)**2 * Decimal("0")**2) )/Decimal(5)
          assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  3  ).value   == 2*  3
          assert Measure._dec_isclose_( (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  3  ).error   , error )
          assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  3  ).implied == False
          assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  3  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  3  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  3  ) == Measure(units=Unit("5 m^2"), value=2*  3, error=error)
          # Value 2: Float
          assert isinstance( (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  3  ) , Measure )
          error = measure._sqrt_( (3**2 * 0.5**2 + 1.0**2 * 0**2) )/5
          assert math.isclose( (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  3  ).value , 0.2*3   )
          assert math.isclose( (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  3  ).error , error )
          assert (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  3  ).implied == False
          assert (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  3  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  3  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  3  ) == Measure(units=Unit("5 m^2"), value=0.2*3, error=error)
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  3  ) , Measure )
          error = measure._sqrt_( (3**2 * Decimal("25")**2 + Decimal("100")**2 * Decimal("0")**2) )/Decimal("5")
          assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  3  ).value   == Decimal("20")*3
          assert Measure._dec_isclose_( (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  3  ).error   , error )
          assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  3  ).implied == False
          assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  3  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  3  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  3  ) == Measure(units=Unit("5 m^2"), value=Decimal("20")*3, error=error)
          # Value 4: Negative
          assert isinstance( (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  3  ) , Measure )
          error = measure._sqrt_( (3**2 * Decimal(5)**2 + Decimal(10)**2 * Decimal("0")**2) )/Decimal(5)
          assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  3  ).value   == -2*3
          assert Measure._dec_isclose_( (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  3  ).error   , error )
          assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  3  ).implied == False
          assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  3  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  3  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  3  ) == Measure(units=Unit("5 m^2"), value=-2*3, error=error)
        # Convoluted Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  3 ), Measure )
          error = measure._sqrt_( (3**2 * Decimal("1")**2 + Decimal("300.15")**2 * Decimal("0")**2) )
          assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  3 ).value   == 3*Decimal("300.15")-Decimal("273.15")
          assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  3 ).error   == error
          assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  3 ).implied == False
          assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  3 ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  3 ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  3 ) == Measure(units=Unit("\u00B0C"), value=3*Decimal("300.15")-Decimal("273.15"), error=error)
          # Value 2: Float
          assert isinstance( ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  3 ), Measure )
          error = measure._sqrt_( (3**2 * 0.02**2 + 300**2 * 0**2) )
          assert math.isclose( ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  3 ).value   , 3 * 300 - 273.15 )
          assert math.isclose( ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  3 ).error   , error )
          assert ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  3 ).implied == False
          assert ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  3 ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  3 ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  3 ) == Measure(units=Unit("\u00B0C"), value= 3 * 300 - 273.15, error=error)
          # Value 3: Decimal
          assert isinstance( ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  3 ), Measure )
          error = measure._sqrt_( (3**2 * Decimal("0.02")**2 + Decimal("300")**2 * Decimal("0")**2) )
          assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  3 ).value   == 3 * Decimal("300") -Decimal("273.15")
          assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  3 ).error   == error
          assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  3 ).implied == False
          assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  3 ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  3 ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  3 ) == Measure(units=Unit("\u00B0C"), value=3 * Decimal("300")-Decimal("273.15"), error=error)
          # Value 4: Negative
          assert isinstance( ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  3 ), Measure )
          error = measure._sqrt_( (3**2 * Decimal("1")**2 + Decimal("246.15")**2 * Decimal("0")**2) )
          assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  3 ).value   == 3*Decimal("246.15")-Decimal("273.15")
          assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  3 ).error   == error
          assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  3 ).implied == False
          assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  3 ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  3 ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  3 ) == Measure(units=Unit("\u00B0C"), value= 3*Decimal("246.15")-Decimal("273.15"), error=error)
        # Preserve Inputs
        if(True):
          a = Measure(value=4,error=2,unit=Unit("cm"))
          b = 3
          c = a*b
          c = None
          assert a == Measure(value=4,error=2,unit=Unit("cm"))
          assert b == 3
    # Measure (Implicit Error) * Int
    if(True):
      # Measure Unitless * Int
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          assert isinstance( (  Measure(value=3)  *  3  ), Measure )
          error = measure._sqrt_( (Decimal(3)**2 * Decimal("0")**2 + Decimal(3)**2 * Decimal("0.5")**2) )
          assert (  Measure(value=3)  *  3  ).value   == 9
          assert (  Measure(value=3)  *  3  ).error   == error
          assert (  Measure(value=3)  *  3  ).implied == True
          assert (  Measure(value=3)  *  3  ).units.symbols   == Unit().symbols
          assert (  Measure(value=3)  *  3  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=3)  *  3  ) == Measure(units=Unit(), value= 9, error=error)
          # Value 2: Float
          assert isinstance( (  Measure(value=0.3)  *  3 ), Measure )
          error = measure._sqrt_( (3**2 * 0.05**2 + 0.3**2 * 0**2) )
          assert math.isclose( (  Measure(value=0.3)  *  3  ).value , 0.3*3 )
          assert math.isclose( (  Measure(value=0.3)  *  3  ).error , error   )
          assert (  Measure(value=0.3)  *  3  ).implied == True
          assert (  Measure(value=0.3)  *  3  ).units.symbols   == Unit().symbols
          assert (  Measure(value=0.3)  *  3  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=0.3)  *  3  ) == Measure(units=Unit(), value= 0.3*3, error=error)
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("40"))  *  3  ), Measure )
          error = measure._sqrt_( ( Decimal("40")**2 * Decimal("0")**2 + 3**2 * Decimal("5")**2) )
          assert (  Measure(value=Decimal("40"))  *  3  ).value   == Decimal("40")*3
          assert (  Measure(value=Decimal("40"))  *  3  ).error   == error
          assert (  Measure(value=Decimal("40"))  *  3  ).implied == True
          assert (  Measure(value=Decimal("40"))  *  3  ).units.symbols   == Unit().symbols
          assert (  Measure(value=Decimal("40"))  *  3  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=Decimal("40"))  *  3  ) == Measure(units=Unit(), value= Decimal("40")*3, error=error)
          # Value 4: Negative
          assert isinstance( (  Measure(value=-3)  *  3  ), Measure )
          error = measure._sqrt_( (Decimal(3)**2 * Decimal("0")**2 + 3**2 * Decimal("0.5")**2) )
          assert (  Measure(value=-3)  *  3  ).value   == -3*3
          assert (  Measure(value=-3)  *  3  ).error   == error
          assert (  Measure(value=-3)  *  3  ).implied == True
          assert (  Measure(value=-3)  *  3  ).units.symbols   == Unit().symbols
          assert (  Measure(value=-3)  *  3  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=-3)  *  3  ) == Measure(units=Unit(), value=-3*3, error=error)
        # Preserve Inputs
        if(True):
          a = Measure(value=3) 
          b = 3
          c = a*b
          c = None
          assert a == Measure(value=3) 
          assert b == 3
      # Measure Units * Int
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Measure(value=4,unit=Unit("cm"))  *  3  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0")**2 + Decimal(3)**2 * Decimal("0.5")**2) )
          assert (  Measure(value=4,unit=Unit("cm"))  *  3  ).value   == 4*3
          assert (  Measure(value=4,unit=Unit("cm"))  *  3  ).error   == error
          assert (  Measure(value=4,unit=Unit("cm"))  *  3  ).implied == True
          assert (  Measure(value=4,unit=Unit("cm"))  *  3  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=4,unit=Unit("cm"))  *  3  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=4,unit=Unit("cm"))  *  3  ) == Measure(units=Unit("cm"), value= 4*3, error=error)
          # Value 2: Float
          assert isinstance( ( Measure(value=0.4,unit=Unit("cm"))  *  3  ), Measure )
          error = measure._sqrt_( (0.4**2 * 0**2 + 3**2 * 0.05**2) )
          assert math.isclose( (  Measure(value=0.4,unit=Unit("cm"))  *  3  ).value , 0.4*3 )
          assert math.isclose( (  Measure(value=0.4,unit=Unit("cm"))  *  3  ).error , error   )
          assert (  Measure(value=0.4,unit=Unit("cm"))  *  3  ).implied == True
          assert (  Measure(value=0.4,unit=Unit("cm"))  *  3  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=0.4,unit=Unit("cm"))  *  3  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=0.4,unit=Unit("cm"))  *  3  ) == Measure(units=Unit("cm"), value= 0.4*3, error=error)
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  3  ), Measure )
          error = measure._sqrt_( (Decimal("40")**2 * Decimal("0")**2 + 3**2 * Decimal("5")**2) )
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  3  ).value   == Decimal("40")*3
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  3  ).error   == error
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  3  ).implied == True
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  3  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  3  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  3  ) == Measure(units=Unit("cm"), value= Decimal("40")*3, error=error)
          # Value 4: Negative
          assert isinstance( ( Measure(value=-4,unit=Unit("cm"))  *  3  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0")**2 + 3**2 * Decimal("0.5")**2) )
          assert (  Measure(value=-4,unit=Unit("cm"))  *  3  ).value   == -4*3
          assert (  Measure(value=-4,unit=Unit("cm"))  *  3  ).error   == error
          assert (  Measure(value=-4,unit=Unit("cm"))  *  3  ).implied == True
          assert (  Measure(value=-4,unit=Unit("cm"))  *  3  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=-4,unit=Unit("cm"))  *  3  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=-4,unit=Unit("cm"))  *  3  ) == Measure(units=Unit("cm"), value=-4*3, error=error)
        # Magnitude Units
        if(True):
          # Value 1: Int
          assert isinstance( (  Measure(value=2,unit=Unit("5 m^2"))  *  3  ) , Measure )
          error = measure._sqrt_( (3**2 * Decimal("2.5")**2 + Decimal(10)**2 * Decimal("0")**2) )/Decimal(5)
          assert (  Measure(value=2,unit=Unit("5 m^2"))  *  3  ).value   == 2*  3
          assert Measure._dec_isclose_( (  Measure(value=2,unit=Unit("5 m^2"))  *  3  ).error   , error )
          assert (  Measure(value=2,unit=Unit("5 m^2"))  *  3  ).implied == True
          assert (  Measure(value=2,unit=Unit("5 m^2"))  *  3  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=2,unit=Unit("5 m^2"))  *  3  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  Measure(value=2,unit=Unit("5 m^2"))  *  3  ) == Measure(units=Unit("5 m^2"), value=2*  3, error=error)
          # Value 2: Float
          assert isinstance( (  Measure(value=0.2,unit=Unit("5 m^2"))  *  3  ) , Measure )
          error = measure._sqrt_( (3**2 * 0.25**2 + 1.0**2 * 0**2) )/5
          assert math.isclose( (  Measure(value=0.2,unit=Unit("5 m^2"))  *  3  ).value , 0.2*3   )
          assert math.isclose( (  Measure(value=0.2,unit=Unit("5 m^2"))  *  3  ).error , error )
          assert (  Measure(value=0.2,unit=Unit("5 m^2"))  *  3  ).implied == True
          assert (  Measure(value=0.2,unit=Unit("5 m^2"))  *  3  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=0.2,unit=Unit("5 m^2"))  *  3  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  Measure(value=0.2,unit=Unit("5 m^2"))  *  3  ) == Measure(units=Unit("5 m^2"), value=0.2*3, error=error)
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  3  ) , Measure )
          error = measure._sqrt_( (3**2 * Decimal("25")**2 + Decimal("100")**2 * Decimal("0")**2) )/Decimal("5")
          assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  3  ).value   == Decimal("20")*3
          assert Measure._dec_isclose_( (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  3  ).error   , error )
          assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  3  ).implied == True
          assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  3  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  3  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  3  ) == Measure(units=Unit("5 m^2"), value=Decimal("20")*3, error=error)
          # Value 4: Negative
          assert isinstance( (  Measure(value=-2,unit=Unit("5 m^2"))  *  3  ) , Measure )
          error = measure._sqrt_( (3**2 * Decimal("2.5")**2 + Decimal(10)**2 * Decimal("0")**2) )/Decimal(5)
          assert (  Measure(value=-2,unit=Unit("5 m^2"))  *  3  ).value   == -2*3
          assert Measure._dec_isclose_( (  Measure(value=-2,unit=Unit("5 m^2"))  *  3  ).error   , error )
          assert (  Measure(value=-2,unit=Unit("5 m^2"))  *  3  ).implied == True
          assert (  Measure(value=-2,unit=Unit("5 m^2"))  *  3  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=-2,unit=Unit("5 m^2"))  *  3  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  Measure(value=-2,unit=Unit("5 m^2"))  *  3  ) == Measure(units=Unit("5 m^2"), value=-2*3, error=error)
        # Convoluted Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Measure(value=27,unit=Unit("\u00B0C"))  *  3 ), Measure )
          error = measure._sqrt_( (3**2 * Decimal("0.5")**2 + Decimal("300.15")**2 * Decimal("0")**2) )
          assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  3 ).value   == 3*Decimal("300.15")-Decimal("273.15")
          assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  3 ).error   == error
          assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  3 ).implied == True
          assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  3 ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  3 ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  3 ) == Measure(units=Unit("\u00B0C"), value=3*Decimal("300.15")-Decimal("273.15"), error=error)
          # Value 2: Float
          assert isinstance( ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  3 ), Measure )
          error = measure._sqrt_( (3**2 * 0.005**2 + 300**2 * 0**2) )
          assert math.isclose( ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  3 ).value   , 3 * 300 - 273.15 )
          assert math.isclose( ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  3 ).error   , error )
          assert ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  3 ).implied == True
          assert ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  3 ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  3 ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  3 ) == Measure(units=Unit("\u00B0C"), value= 3 * 300 - 273.15, error=error)
          # Value 3: Decimal
          assert isinstance( ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  3 ), Measure )
          error = measure._sqrt_( (3**2 * Decimal("0.005")**2 + Decimal("300")**2 * Decimal("0")**2) )
          assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  3 ).value   == 3 * Decimal("300") -Decimal("273.15")
          assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  3 ).error   == error
          assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  3 ).implied == True
          assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  3 ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  3 ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  3 ) == Measure(units=Unit("\u00B0C"), value=3 * Decimal("300")-Decimal("273.15"), error=error)
          # Value 4: Negative
          assert isinstance( ( Measure(value=-27,unit=Unit("\u00B0C"))  *  3 ), Measure )
          error = measure._sqrt_( (3**2 * Decimal("0.5")**2 + Decimal("246.15")**2 * Decimal("0")**2) )
          assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  3 ).value   == 3*Decimal("246.15")-Decimal("273.15")
          assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  3 ).error   == error
          assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  3 ).implied == True
          assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  3 ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  3 ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  3 ) == Measure(units=Unit("\u00B0C"), value= 3*Decimal("246.15")-Decimal("273.15"), error=error)
        # Preserve Inputs
        if(True):
          a = Measure(value=4,unit=Unit("cm"))
          b = 3
          c = a*b
          c = None
          assert a == Measure(value=4,unit=Unit("cm"))
          assert b == 3
    # Int * Measure (Explicit Error)
    if(True):
      # Int * Measure Unitless
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          assert isinstance( (  3 * Measure(value=3,error=2)  ), Measure )
          error = measure._sqrt_( (Decimal(3)**2 * Decimal("0")**2 + Decimal(3)**2 * Decimal(2)**2) )
          assert (  3 * Measure(value=3,error=2)  ).value   == 9
          assert (  3 * Measure(value=3,error=2)  ).error   == error
          assert (  3 * Measure(value=3,error=2)  ).implied == False
          assert (  3 * Measure(value=3,error=2)  ).units.symbols   == Unit().symbols
          assert (  3 * Measure(value=3,error=2)  ).units.magnitude == Unit().magnitude
          assert (  3 * Measure(value=3,error=2)  ) == Measure(units=Unit(), value= 9, error=error)
          # Value 2: Float
          assert isinstance( (  3 * Measure(value=0.3,error=0.2) ), Measure )
          error = measure._sqrt_( (3**2 * 0.2**2 + 0.3**2 * 0**2) )
          assert math.isclose( (  3 * Measure(value=0.3,error=0.2)  ).value , 0.3*3 )
          assert math.isclose( (  3 * Measure(value=0.3,error=0.2)  ).error , error   )
          assert (  3 * Measure(value=0.3,error=0.2)  ).implied == False
          assert (  3 * Measure(value=0.3,error=0.2)  ).units.symbols   == Unit().symbols
          assert (  3 * Measure(value=0.3,error=0.2)  ).units.magnitude == Unit().magnitude
          assert (  3 * Measure(value=0.3,error=0.2)  ) == Measure(units=Unit(), value= 0.3*3, error=error)
          # Value 3: Decimal
          assert isinstance( (  3 * Measure(value=Decimal("40"),error=Decimal("20"))  ), Measure )
          error = measure._sqrt_( ( Decimal("40")**2 * Decimal("0")**2 + 3**2 * Decimal("20")**2) )
          assert (  3 * Measure(value=Decimal("40"),error=Decimal("20"))  ).value   == Decimal("40")*3
          assert (  3 * Measure(value=Decimal("40"),error=Decimal("20"))  ).error   == error
          assert (  3 * Measure(value=Decimal("40"),error=Decimal("20"))  ).implied == False
          assert (  3 * Measure(value=Decimal("40"),error=Decimal("20"))  ).units.symbols   == Unit().symbols
          assert (  3 * Measure(value=Decimal("40"),error=Decimal("20"))  ).units.magnitude == Unit().magnitude
          assert (  3 * Measure(value=Decimal("40"),error=Decimal("20"))  ) == Measure(units=Unit(), value= Decimal("40")*3, error=error)
          # Value 4: Negative
          assert isinstance( (  3 * Measure(value=-3,error=2)  ), Measure )
          error = measure._sqrt_( (Decimal(3)**2 * Decimal("0")**2 + 3**2 * Decimal(2)**2) )
          assert (  3 * Measure(value=-3,error=2)  ).value   == -3*3
          assert (  3 * Measure(value=-3,error=2)  ).error   == error
          assert (  3 * Measure(value=-3,error=2)  ).implied == False
          assert (  3 * Measure(value=-3,error=2)  ).units.symbols   == Unit().symbols
          assert (  3 * Measure(value=-3,error=2)  ).units.magnitude == Unit().magnitude
          assert (  3 * Measure(value=-3,error=2)  ) == Measure(units=Unit(), value=-3*3, error=error)
        # Preserve Inputs
        if(True):
          a = 3
          b = Measure(value=3,error=2) 
          c = a*b
          c = None
          assert a == 3
          assert b == Measure(value=3,error=2) 
      # Int * Measure Units 
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          assert isinstance( ( 3 * Measure(value=4,error=2,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0")**2 + Decimal(3)**2 * Decimal(2)**2) )
          assert (  3 * Measure(value=4,error=2,unit=Unit("cm"))  ).value   == 4*3
          assert (  3 * Measure(value=4,error=2,unit=Unit("cm"))  ).error   == error
          assert (  3 * Measure(value=4,error=2,unit=Unit("cm"))  ).implied == False
          assert (  3 * Measure(value=4,error=2,unit=Unit("cm"))  ).units.symbols   == Unit("cm").symbols
          assert (  3 * Measure(value=4,error=2,unit=Unit("cm"))  ).units.magnitude == Unit("cm").magnitude
          assert (  3 * Measure(value=4,error=2,unit=Unit("cm"))  ) == Measure(units=Unit("cm"), value= 4*3, error=error)
          # Value 2: Float
          assert isinstance( ( 3 * Measure(value=0.4,error=0.2,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (0.4**2 * 0**2 + 3**2 * 0.2**2) )
          assert math.isclose( (  3 * Measure(value=0.4,error=0.2,unit=Unit("cm"))  ).value , 0.4*3 )
          assert math.isclose( (  3 * Measure(value=0.4,error=0.2,unit=Unit("cm"))  ).error , error   )
          assert (  3 * Measure(value=0.4,error=0.2,unit=Unit("cm"))  ).implied == False
          assert (  3 * Measure(value=0.4,error=0.2,unit=Unit("cm"))  ).units.symbols   == Unit("cm").symbols
          assert (  3 * Measure(value=0.4,error=0.2,unit=Unit("cm"))  ).units.magnitude == Unit("cm").magnitude
          assert (  3 * Measure(value=0.4,error=0.2,unit=Unit("cm"))  ) == Measure(units=Unit("cm"), value= 0.4*3, error=error)
          # Value 3: Decimal
          assert isinstance( (  3 * Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (Decimal("40")**2 * Decimal("0")**2 + 3**2 * Decimal("20")**2) )
          assert (  3 * Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  ).value   == Decimal("40")*3
          assert (  3 * Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  ).error   == error
          assert (  3 * Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  ).implied == False
          assert (  3 * Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  ).units.symbols   == Unit("cm").symbols
          assert (  3 * Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  ).units.magnitude == Unit("cm").magnitude
          assert (  3 * Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  ) == Measure(units=Unit("cm"), value= Decimal("40")*3, error=error)
          # Value 4: Negative
          assert isinstance( ( 3 * Measure(value=-4,error=2,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0")**2 + 3**2 * Decimal(2)**2) )
          assert (  3 * Measure(value=-4,error=2,unit=Unit("cm"))  ).value   == -4*3
          assert (  3 * Measure(value=-4,error=2,unit=Unit("cm"))  ).error   == error
          assert (  3 * Measure(value=-4,error=2,unit=Unit("cm"))  ).implied == False
          assert (  3 * Measure(value=-4,error=2,unit=Unit("cm"))  ).units.symbols   == Unit("cm").symbols
          assert (  3 * Measure(value=-4,error=2,unit=Unit("cm"))  ).units.magnitude == Unit("cm").magnitude
          assert (  3 * Measure(value=-4,error=2,unit=Unit("cm"))  ) == Measure(units=Unit("cm"), value=-4*3, error=error)
        # Magnitude Units
        if(True):
          # Value 1: Int
          assert isinstance( (  3 * Measure(value=2,error=1,unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (3**2 * Decimal(5)**2 + Decimal(10)**2 * Decimal("0")**2) )/Decimal(5)
          assert (  3 * Measure(value=2,error=1,unit=Unit("5 m^2"))  ).value   == 2*  3
          assert Measure._dec_isclose_( (  3 * Measure(value=2,error=1,unit=Unit("5 m^2"))  ).error   , error )
          assert (  3 * Measure(value=2,error=1,unit=Unit("5 m^2"))  ).implied == False
          assert (  3 * Measure(value=2,error=1,unit=Unit("5 m^2"))  ).units.symbols   == Unit("5 m^2").symbols
          assert (  3 * Measure(value=2,error=1,unit=Unit("5 m^2"))  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  3 * Measure(value=2,error=1,unit=Unit("5 m^2"))  ) == Measure(units=Unit("5 m^2"), value=2*  3, error=error)
          # Value 2: Float
          assert isinstance( (  3 * Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (3**2 * 0.5**2 + 1.0**2 * 0**2) )/5
          assert math.isclose( (  3 * Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  ).value , 0.2*3   )
          assert math.isclose( (  3 * Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  ).error , error )
          assert (  3 * Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  ).implied == False
          assert (  3 * Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  ).units.symbols   == Unit("5 m^2").symbols
          assert (  3 * Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  3 * Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  ) == Measure(units=Unit("5 m^2"), value=0.2*3, error=error)
          # Value 3: Decimal
          assert isinstance( (  3 * Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (3**2 * Decimal("25")**2 + Decimal("100")**2 * Decimal("0")**2) )/Decimal("5")
          assert (  3 * Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  ).value   == Decimal("20")*3
          assert Measure._dec_isclose_( (  3 * Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  ).error   , error )
          assert (  3 * Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  ).implied == False
          assert (  3 * Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  ).units.symbols   == Unit("5 m^2").symbols
          assert (  3 * Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  3 * Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  ) == Measure(units=Unit("5 m^2"), value=Decimal("20")*3, error=error)
          # Value 4: Negative
          assert isinstance( (  3 * Measure(value=-2,error=1,unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (3**2 * Decimal(5)**2 + Decimal(10)**2 * Decimal("0")**2) )/Decimal(5)
          assert (  3 * Measure(value=-2,error=1,unit=Unit("5 m^2"))  ).value   == -2*3
          assert Measure._dec_isclose_( (  3 * Measure(value=-2,error=1,unit=Unit("5 m^2"))  ).error   , error )
          assert (  3 * Measure(value=-2,error=1,unit=Unit("5 m^2"))  ).implied == False
          assert (  3 * Measure(value=-2,error=1,unit=Unit("5 m^2"))  ).units.symbols   == Unit("5 m^2").symbols
          assert (  3 * Measure(value=-2,error=1,unit=Unit("5 m^2"))  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  3 * Measure(value=-2,error=1,unit=Unit("5 m^2"))  ) == Measure(units=Unit("5 m^2"), value=-2*3, error=error)
        # Convoluted Units
        if(True):
          # Value 1: Int
          assert isinstance( ( 3 * Measure(value=27,error=1,unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (3**2 * Decimal("1")**2 + Decimal("300.15")**2 * Decimal("0")**2) )
          assert ( 3 * Measure(value=27,error=1,unit=Unit("\u00B0C")) ).value   == 3*Decimal("300.15")-Decimal("273.15")
          assert ( 3 * Measure(value=27,error=1,unit=Unit("\u00B0C")) ).error   == error
          assert ( 3 * Measure(value=27,error=1,unit=Unit("\u00B0C")) ).implied == False
          assert ( 3 * Measure(value=27,error=1,unit=Unit("\u00B0C")) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( 3 * Measure(value=27,error=1,unit=Unit("\u00B0C")) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( 3 * Measure(value=27,error=1,unit=Unit("\u00B0C")) ) == Measure(units=Unit("\u00B0C"), value=3*Decimal("300.15")-Decimal("273.15"), error=error)
          # Value 2: Float
          assert isinstance( ( 3 * Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (3**2 * 0.02**2 + 300**2 * 0**2) )
          assert math.isclose( ( 3 * Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).value   , 3 * 300 - 273.15 )
          assert math.isclose( ( 3 * Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).error   , error )
          assert ( 3 * Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).implied == False
          assert ( 3 * Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( 3 * Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( 3 * Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ) == Measure(units=Unit("\u00B0C"), value= 3 * 300 - 273.15, error=error)
          # Value 3: Decimal
          assert isinstance( ( 3 * Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (3**2 * Decimal("0.02")**2 + Decimal("300")**2 * Decimal("0")**2) )
          assert ( 3 * Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).value   == 3 * Decimal("300") -Decimal("273.15")
          assert ( 3 * Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).error   == error
          assert ( 3 * Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).implied == False
          assert ( 3 * Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( 3 * Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( 3 * Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ) == Measure(units=Unit("\u00B0C"), value=3 * Decimal("300")-Decimal("273.15"), error=error)
          # Value 4: Negative
          assert isinstance( ( 3 * Measure(value=-27,error=1,unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (3**2 * Decimal("1")**2 + Decimal("246.15")**2 * Decimal("0")**2) )
          assert ( 3 * Measure(value=-27,error=1,unit=Unit("\u00B0C")) ).value   == 3*Decimal("246.15")-Decimal("273.15")
          assert ( 3 * Measure(value=-27,error=1,unit=Unit("\u00B0C")) ).error   == error
          assert ( 3 * Measure(value=-27,error=1,unit=Unit("\u00B0C")) ).implied == False
          assert ( 3 * Measure(value=-27,error=1,unit=Unit("\u00B0C")) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( 3 * Measure(value=-27,error=1,unit=Unit("\u00B0C")) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( 3 * Measure(value=-27,error=1,unit=Unit("\u00B0C")) ) == Measure(units=Unit("\u00B0C"), value= 3*Decimal("246.15")-Decimal("273.15"), error=error)
        # Preserve Inputs
        if(True):
          a = 3
          b = Measure(value=4,error=2,unit=Unit("cm"))
          c = a*b
          c = None
          assert a == 3
          assert b == Measure(value=4,error=2,unit=Unit("cm"))
    # Int * Measure (Implicit Error)
    if(True):
      # Int * Measure Unitless
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          assert isinstance( (  3 * Measure(value=3)  ), Measure )
          error = measure._sqrt_( (Decimal(3)**2 * Decimal("0")**2 + Decimal(3)**2 * Decimal("0.5")**2) )
          assert (  3 * Measure(value=3)  ).value   == 9
          assert (  3 * Measure(value=3)  ).error   == error
          assert (  3 * Measure(value=3)  ).implied == True
          assert (  3 * Measure(value=3)  ).units.symbols   == Unit().symbols
          assert (  3 * Measure(value=3)  ).units.magnitude == Unit().magnitude
          assert (  3 * Measure(value=3)  ) == Measure(units=Unit(), value= 9, error=error)
          # Value 2: Float
          assert isinstance( (  3 * Measure(value=0.3) ), Measure )
          error = measure._sqrt_( (3**2 * 0.05**2 + 0.3**2 * 0**2) )
          assert math.isclose( (  3 * Measure(value=0.3)  ).value , 0.3*3 )
          assert math.isclose( (  3 * Measure(value=0.3)  ).error , error   )
          assert (  3 * Measure(value=0.3)  ).implied == True
          assert (  3 * Measure(value=0.3)  ).units.symbols   == Unit().symbols
          assert (  3 * Measure(value=0.3)  ).units.magnitude == Unit().magnitude
          assert (  3 * Measure(value=0.3)  ) == Measure(units=Unit(), value= 0.3*3, error=error)
          # Value 3: Decimal
          assert isinstance( (  3 * Measure(value=Decimal("40"))  ), Measure )
          error = measure._sqrt_( ( Decimal("40")**2 * Decimal("0")**2 + 3**2 * Decimal("5")**2) )
          assert (  3 * Measure(value=Decimal("40"))  ).value   == Decimal("40")*3
          assert (  3 * Measure(value=Decimal("40"))  ).error   == error
          assert (  3 * Measure(value=Decimal("40"))  ).implied == True
          assert (  3 * Measure(value=Decimal("40"))  ).units.symbols   == Unit().symbols
          assert (  3 * Measure(value=Decimal("40"))  ).units.magnitude == Unit().magnitude
          assert (  3 * Measure(value=Decimal("40"))  ) == Measure(units=Unit(), value= Decimal("40")*3, error=error)
          # Value 4: Negative
          assert isinstance( (  3 * Measure(value=-3)  ), Measure )
          error = measure._sqrt_( (Decimal(3)**2 * Decimal("0")**2 + 3**2 * Decimal("0.5")**2) )
          assert (  3 * Measure(value=-3)  ).value   == -3*3
          assert (  3 * Measure(value=-3)  ).error   == error
          assert (  3 * Measure(value=-3)  ).implied == True
          assert (  3 * Measure(value=-3)  ).units.symbols   == Unit().symbols
          assert (  3 * Measure(value=-3)  ).units.magnitude == Unit().magnitude
          assert (  3 * Measure(value=-3)  ) == Measure(units=Unit(), value=-3*3, error=error)
        # Preserve Inputs
        if(True):
          a = 3
          b = Measure(value=3) 
          c = a*b
          c = None
          assert a == 3 
          assert b == Measure(value=3) 
      # Int * Measure Units
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          assert isinstance( ( 3 * Measure(value=4,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0")**2 + Decimal(3)**2 * Decimal("0.5")**2) )
          assert (  3 * Measure(value=4,unit=Unit("cm"))  ).value   == 4*3
          assert (  3 * Measure(value=4,unit=Unit("cm"))  ).error   == error
          assert (  3 * Measure(value=4,unit=Unit("cm"))  ).implied == True
          assert (  3 * Measure(value=4,unit=Unit("cm"))  ).units.symbols   == Unit("cm").symbols
          assert (  3 * Measure(value=4,unit=Unit("cm"))  ).units.magnitude == Unit("cm").magnitude
          assert (  3 * Measure(value=4,unit=Unit("cm"))  ) == Measure(units=Unit("cm"), value= 4*3, error=error)
          # Value 2: Float
          assert isinstance( ( 3 * Measure(value=0.4,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (0.4**2 * 0**2 + 3**2 * 0.05**2) )
          assert math.isclose( (  3 * Measure(value=0.4,unit=Unit("cm"))  ).value , 0.4*3 )
          assert math.isclose( (  3 * Measure(value=0.4,unit=Unit("cm"))  ).error , error   )
          assert (  3 * Measure(value=0.4,unit=Unit("cm"))  ).implied == True
          assert (  3 * Measure(value=0.4,unit=Unit("cm"))  ).units.symbols   == Unit("cm").symbols
          assert (  3 * Measure(value=0.4,unit=Unit("cm"))  ).units.magnitude == Unit("cm").magnitude
          assert (  3 * Measure(value=0.4,unit=Unit("cm"))  ) == Measure(units=Unit("cm"), value= 0.4*3, error=error)
          # Value 3: Decimal
          assert isinstance( (  3 * Measure(value=Decimal("40"),unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (Decimal("40")**2 * Decimal("0")**2 + 3**2 * Decimal("5")**2) )
          assert (  3 * Measure(value=Decimal("40"),unit=Unit("cm"))  ).value   == Decimal("40")*3
          assert (  3 * Measure(value=Decimal("40"),unit=Unit("cm"))  ).error   == error
          assert (  3 * Measure(value=Decimal("40"),unit=Unit("cm"))  ).implied == True
          assert (  3 * Measure(value=Decimal("40"),unit=Unit("cm"))  ).units.symbols   == Unit("cm").symbols
          assert (  3 * Measure(value=Decimal("40"),unit=Unit("cm"))  ).units.magnitude == Unit("cm").magnitude
          assert (  3 * Measure(value=Decimal("40"),unit=Unit("cm"))  ) == Measure(units=Unit("cm"), value= Decimal("40")*3, error=error)
          # Value 4: Negative
          assert isinstance( ( 3 * Measure(value=-4,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0")**2 + 3**2 * Decimal("0.5")**2) )
          assert (  3 * Measure(value=-4,unit=Unit("cm"))  ).value   == -4*3
          assert (  3 * Measure(value=-4,unit=Unit("cm"))  ).error   == error
          assert (  3 * Measure(value=-4,unit=Unit("cm"))  ).implied == True
          assert (  3 * Measure(value=-4,unit=Unit("cm"))  ).units.symbols   == Unit("cm").symbols
          assert (  3 * Measure(value=-4,unit=Unit("cm"))  ).units.magnitude == Unit("cm").magnitude
          assert (  3 * Measure(value=-4,unit=Unit("cm"))  ) == Measure(units=Unit("cm"), value=-4*3, error=error)
        # Magnitude Units
        if(True):
          # Value 1: Int
          assert isinstance( (  3 * Measure(value=2,unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (3**2 * Decimal("2.5")**2 + Decimal(10)**2 * Decimal("0")**2) )/Decimal(5)
          assert (  3 * Measure(value=2,unit=Unit("5 m^2"))  ).value   == 2*  3
          assert Measure._dec_isclose_( (  3 * Measure(value=2,unit=Unit("5 m^2"))  ).error   , error )
          assert (  3 * Measure(value=2,unit=Unit("5 m^2"))  ).implied == True
          assert (  3 * Measure(value=2,unit=Unit("5 m^2"))  ).units.symbols   == Unit("5 m^2").symbols
          assert (  3 * Measure(value=2,unit=Unit("5 m^2"))  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  3 * Measure(value=2,unit=Unit("5 m^2"))  ) == Measure(units=Unit("5 m^2"), value=2*  3, error=error)
          # Value 2: Float
          assert isinstance( (  3 * Measure(value=0.2,unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (3**2 * 0.25**2 + 1.0**2 * 0**2) )/5
          assert math.isclose( (  3 * Measure(value=0.2,unit=Unit("5 m^2"))  ).value , 0.2*3   )
          assert math.isclose( (  3 * Measure(value=0.2,unit=Unit("5 m^2"))  ).error , error )
          assert (  3 * Measure(value=0.2,unit=Unit("5 m^2"))  ).implied == True
          assert (  3 * Measure(value=0.2,unit=Unit("5 m^2"))  ).units.symbols   == Unit("5 m^2").symbols
          assert (  3 * Measure(value=0.2,unit=Unit("5 m^2"))  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  3 * Measure(value=0.2,unit=Unit("5 m^2"))  ) == Measure(units=Unit("5 m^2"), value=0.2*3, error=error)
          # Value 3: Decimal
          assert isinstance( (  3 * Measure(value=Decimal("20"),unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (3**2 * Decimal("25")**2 + Decimal("100")**2 * Decimal("0")**2) )/Decimal("5")
          assert (  3 * Measure(value=Decimal("20"),unit=Unit("5 m^2"))  ).value   == Decimal("20")*3
          assert Measure._dec_isclose_( (  3 * Measure(value=Decimal("20"),unit=Unit("5 m^2"))  ).error   , error )
          assert (  3 * Measure(value=Decimal("20"),unit=Unit("5 m^2"))  ).implied == True
          assert (  3 * Measure(value=Decimal("20"),unit=Unit("5 m^2"))  ).units.symbols   == Unit("5 m^2").symbols
          assert (  3 * Measure(value=Decimal("20"),unit=Unit("5 m^2"))  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  3 * Measure(value=Decimal("20"),unit=Unit("5 m^2"))  ) == Measure(units=Unit("5 m^2"), value=Decimal("20")*3, error=error)
          # Value 4: Negative
          assert isinstance( (  3 * Measure(value=-2,unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (3**2 * Decimal("2.5")**2 + Decimal(10)**2 * Decimal("0")**2) )/Decimal(5)
          assert (  3 * Measure(value=-2,unit=Unit("5 m^2"))  ).value   == -2*3
          assert Measure._dec_isclose_( (  3 * Measure(value=-2,unit=Unit("5 m^2"))  ).error   , error )
          assert (  3 * Measure(value=-2,unit=Unit("5 m^2"))  ).implied == True
          assert (  3 * Measure(value=-2,unit=Unit("5 m^2"))  ).units.symbols   == Unit("5 m^2").symbols
          assert (  3 * Measure(value=-2,unit=Unit("5 m^2"))  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  3 * Measure(value=-2,unit=Unit("5 m^2"))  ) == Measure(units=Unit("5 m^2"), value=-2*3, error=error)
        # Convoluted Units
        if(True):
          # Value 1: Int
          assert isinstance( ( 3 * Measure(value=27,unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (3**2 * Decimal("0.5")**2 + Decimal("300.15")**2 * Decimal("0")**2) )
          assert ( 3 * Measure(value=27,unit=Unit("\u00B0C")) ).value   == 3*Decimal("300.15")-Decimal("273.15")
          assert ( 3 * Measure(value=27,unit=Unit("\u00B0C")) ).error   == error
          assert ( 3 * Measure(value=27,unit=Unit("\u00B0C")) ).implied == True
          assert ( 3 * Measure(value=27,unit=Unit("\u00B0C")) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( 3 * Measure(value=27,unit=Unit("\u00B0C")) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( 3 * Measure(value=27,unit=Unit("\u00B0C")) ) == Measure(units=Unit("\u00B0C"), value=3*Decimal("300.15")-Decimal("273.15"), error=error)
          # Value 2: Float
          assert isinstance( ( 3 * Measure(value=26.85,unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (3**2 * 0.005**2 + 300**2 * 0**2) )
          assert math.isclose( ( 3 * Measure(value=26.85,unit=Unit("\u00B0C")) ).value   , 3 * 300 - 273.15 )
          assert math.isclose( ( 3 * Measure(value=26.85,unit=Unit("\u00B0C")) ).error   , error )
          assert ( 3 * Measure(value=26.85,unit=Unit("\u00B0C")) ).implied == True
          assert ( 3 * Measure(value=26.85,unit=Unit("\u00B0C")) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( 3 * Measure(value=26.85,unit=Unit("\u00B0C")) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( 3 * Measure(value=26.85,unit=Unit("\u00B0C")) ) == Measure(units=Unit("\u00B0C"), value= 3 * 300 - 273.15, error=error)
          # Value 3: Decimal
          assert isinstance( ( 3 * Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (3**2 * Decimal("0.005")**2 + Decimal("300")**2 * Decimal("0")**2) )
          assert ( 3 * Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).value   == 3 * Decimal("300") -Decimal("273.15")
          assert ( 3 * Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).error   == error
          assert ( 3 * Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).implied == True
          assert ( 3 * Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( 3 * Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( 3 * Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ) == Measure(units=Unit("\u00B0C"), value=3 * Decimal("300")-Decimal("273.15"), error=error)
          # Value 4: Negative
          assert isinstance( ( 3 * Measure(value=-27,unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (3**2 * Decimal("0.5")**2 + Decimal("246.15")**2 * Decimal("0")**2) )
          assert ( 3 * Measure(value=-27,unit=Unit("\u00B0C")) ).value   == 3*Decimal("246.15")-Decimal("273.15")
          assert ( 3 * Measure(value=-27,unit=Unit("\u00B0C")) ).error   == error
          assert ( 3 * Measure(value=-27,unit=Unit("\u00B0C")) ).implied == True
          assert ( 3 * Measure(value=-27,unit=Unit("\u00B0C")) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( 3 * Measure(value=-27,unit=Unit("\u00B0C")) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( 3 * Measure(value=-27,unit=Unit("\u00B0C")) ) == Measure(units=Unit("\u00B0C"), value= 3*Decimal("246.15")-Decimal("273.15"), error=error)
        # Preserve Inputs
        if(True):
          a = 3
          b = Measure(value=4,unit=Unit("cm"))
          c = a*b
          c = None
          assert a == 3
          assert b == Measure(value=4,unit=Unit("cm"))
    
  def test_measure_float_mul(self):
    # Measure (Explicit Error) * Float
    if(True):
      # Measure Unitless * Float
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          assert isinstance( (  Measure(value=3,error=2)  *  0.3  ), Measure )
          error = measure._sqrt_( 3**2 * 0**2 + 0.3**2 * 2**2 )
          assert math.isclose( (  Measure(value=3,error=2)  *  0.3  ).value , 3*0.3 )
          assert math.isclose( (  Measure(value=3,error=2)  *  0.3  ).error , error )
          assert (  Measure(value=3,error=2)  *  0.3  ).implied == False
          assert (  Measure(value=3,error=2)  *  0.3  ).units.symbols   == Unit().symbols
          assert (  Measure(value=3,error=2)  *  0.3  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=3,error=2)  *  0.3  ) == Measure(units=Unit(), value= 3*0.3, error=error)
          # Value 2: Float
          assert isinstance( (  Measure(value=0.3,error=0.2)  *  0.3 ), Measure )
          error = measure._sqrt_( 0.3**2 * 0.2**2 + 0.3**2 * 0**2 )
          assert math.isclose( (  Measure(value=0.3,error=0.2)  *  0.3  ).value , 0.3*0.3 )
          assert math.isclose( (  Measure(value=0.3,error=0.2)  *  0.3  ).error , error   )
          assert (  Measure(value=0.3,error=0.2)  *  0.3  ).implied == False
          assert (  Measure(value=0.3,error=0.2)  *  0.3  ).units.symbols   == Unit().symbols
          assert (  Measure(value=0.3,error=0.2)  *  0.3  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=0.3,error=0.2)  *  0.3  ) == Measure(units=Unit(), value= 0.3*0.3, error=error)
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("40"),error=Decimal("20"))  *  0.3  ), Measure )
          error = measure._sqrt_(  40.0**2 * 0**2 + 0.3**2 * 20.0**2 )
          assert math.isclose( (  Measure(value=Decimal("40"),error=Decimal("20"))  *  0.3  ).value , 40.0*0.3 )
          assert math.isclose( (  Measure(value=Decimal("40"),error=Decimal("20"))  *  0.3  ).error , error )
          assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  0.3  ).implied == False
          assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  0.3  ).units.symbols   == Unit().symbols
          assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  0.3  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  0.3  ) == Measure(units=Unit(), value=40.0*0.3, error=error)
          # Value 4: Negative
          assert isinstance( (  Measure(value=-3,error=2)  *  0.3  ), Measure )
          error = measure._sqrt_( 3**2 * 0**2 + 0.3**2 * 2**2 )
          assert math.isclose( (  Measure(value=-3,error=2)  *  0.3  ).value   , -3*0.3 )
          assert math.isclose( (  Measure(value=-3,error=2)  *  0.3  ).error   , error  )
          assert (  Measure(value=-3,error=2)  *  0.3  ).implied == False
          assert (  Measure(value=-3,error=2)  *  0.3  ).units.symbols   == Unit().symbols
          assert (  Measure(value=-3,error=2)  *  0.3  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=-3,error=2)  *  0.3  ) == Measure(units=Unit(), value=-3*0.3, error=error)
        # Preserve Inputs
        if(True):
          a = Measure(value=3,error=2) 
          b = 0.3
          c = a*b
          c = None
          assert a == Measure(value=3,error=2) 
          assert b == 0.3
      # Measure Units * Float
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Measure(value=4,error=2,unit=Unit("cm"))  *  0.3  ), Measure )
          error = measure._sqrt_( 4**2 * 0**2 + 0.3**2 * 2**2 )
          assert math.isclose( (  Measure(value=4,error=2,unit=Unit("cm"))  *  0.3  ).value , 4*0.3 )
          assert math.isclose( (  Measure(value=4,error=2,unit=Unit("cm"))  *  0.3  ).error , error )
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  0.3  ).implied == False
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  0.3  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  0.3  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  0.3  ) == Measure(units=Unit("cm"), value= 4*0.3, error=error)
          # Value 2: Float
          assert isinstance( ( Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  0.3  ), Measure )
          error = measure._sqrt_( 0.4**2 * 0**2 + 0.3**2 * 0.2**2 )
          assert math.isclose( (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  0.3  ).value , 0.4*0.3 )
          assert math.isclose( (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  0.3  ).error , error   )
          assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  0.3  ).implied == False
          assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  0.3  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  0.3  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  0.3  ) == Measure(units=Unit("cm"), value= 0.4*0.3, error=error)
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  0.3  ), Measure )
          error = measure._sqrt_( 40.0**2 * 0**2 + 0.3**2 * 20.0**2 )
          assert math.isclose( (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  0.3  ).value , 40.0*0.3 )
          assert math.isclose( (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  0.3  ).error , error    )
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  0.3  ).implied == False
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  0.3  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  0.3  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  0.3  ) == Measure(units=Unit("cm"), value= 40.0*0.3, error=error)
          # Value 4: Negative
          assert isinstance( ( Measure(value=-4,error=2,unit=Unit("cm"))  *  0.3  ), Measure )
          error = measure._sqrt_( 4**2 * 0**2 + 0.3**2 * 2**2 )
          assert math.isclose( (  Measure(value=-4,error=2,unit=Unit("cm"))  *  0.3  ).value , -4*0.3 )
          assert math.isclose( (  Measure(value=-4,error=2,unit=Unit("cm"))  *  0.3  ).error , error  )
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  0.3  ).implied == False
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  0.3  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  0.3  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  0.3  ) == Measure(units=Unit("cm"), value=-4*0.3, error=error)
        # Magnitude Units
        if(True):
          # Value 1: Int
          assert isinstance( (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  0.3  ) , Measure )
          error = measure._sqrt_( 0.3**2 * 5**2 + 10**2 * 0**2 )/5
          assert math.isclose( (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  0.3  ).value   , 2*0.3 )
          assert math.isclose( (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  0.3  ).error   , error )
          assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  0.3  ).implied == False
          assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  0.3  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  0.3  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  0.3  ) == Measure(units=Unit("5 m^2"), value=2*  0.3, error=error)
          # Value 2: Float
          assert isinstance( (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  0.3  ) , Measure )
          error = measure._sqrt_( 0.3**2 * 0.5**2 + 1.0**2 * 0**2 )/5
          assert math.isclose( (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  0.3  ).value , 0.2*0.3   )
          assert math.isclose( (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  0.3  ).error , error )
          assert (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  0.3  ).implied == False
          assert (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  0.3  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  0.3  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  0.3  ) == Measure(units=Unit("5 m^2"), value=0.2*0.3, error=error)
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  0.3  ) , Measure )
          error = measure._sqrt_( 0.3**2 * 25**2 + 100**2 * 0**2 )/5
          assert math.isclose( (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  0.3  ).value   , 20.0*0.3 )
          assert math.isclose( (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  0.3  ).error   , error    )
          assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  0.3  ).implied == False
          assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  0.3  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  0.3  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  0.3  ) == Measure(units=Unit("5 m^2"), value=20.0*0.3, error=error)
          # Value 4: Negative
          assert isinstance( (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  0.3  ) , Measure )
          error = measure._sqrt_( 0.3**2 * 5**2 + 10**2 * 0**2 )/5
          assert math.isclose( (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  0.3  ).value   , -2*0.3 )
          assert math.isclose( (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  0.3  ).error   , error  )
          assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  0.3  ).implied == False
          assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  0.3  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  0.3  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  0.3  ) == Measure(units=Unit("5 m^2"), value=-2*0.3, error=error)
        # Convoluted Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  0.3 ), Measure )
          error = measure._sqrt_( 0.3**2 * 1**2 + 300.15**2 * 0**2 )
          assert math.isclose( ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  0.3 ).value , 0.3*300.15-273.15 )
          assert math.isclose( ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  0.3 ).error , error )
          assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  0.3 ).implied == False
          assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  0.3 ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  0.3 ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  0.3 ) == Measure(units=Unit("\u00B0C"), value=0.3*300.15-273.15, error=error)
          # Value 2: Float
          assert isinstance( ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  0.3 ), Measure )
          error = measure._sqrt_( 0.3**2 * 0.02**2 + 300**2 * 0**2 )
          assert math.isclose( ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  0.3 ).value   , 0.3 * 300 - 273.15 )
          assert math.isclose( ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  0.3 ).error   , error )
          assert ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  0.3 ).implied == False
          assert ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  0.3 ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  0.3 ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  0.3 ) == Measure(units=Unit("\u00B0C"), value= 0.3 * 300 - 273.15, error=error)
          # Value 3: Decimal
          assert isinstance( ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  0.3 ), Measure )
          error = measure._sqrt_( 0.3**2 * 0.02**2 + 300.0**2 * 0**2 )
          assert math.isclose( ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  0.3 ).value , 0.3*300-273.15 )
          assert math.isclose( ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  0.3 ).error , error )
          assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  0.3 ).implied == False
          assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  0.3 ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  0.3 ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  0.3 ) == Measure(units=Unit("\u00B0C"), value=0.3*300-273.15, error=error)
          # Value 4: Negative
          assert isinstance( ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  0.3 ), Measure )
          error = measure._sqrt_( 0.3**2 * 1**2 + 246.15**2 * 0**2 )
          assert math.isclose( ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  0.3 ).value , 0.3*246.15-273.15 )
          assert math.isclose( ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  0.3 ).error , error )
          assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  0.3 ).implied == False
          assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  0.3 ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  0.3 ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  0.3 ) == Measure(units=Unit("\u00B0C"), value= 0.3*246.15-273.15, error=error)
        # Preserve Inputs
        if(True):
          a = Measure(value=4,error=2,unit=Unit("cm"))
          b = 0.3
          c = a*b
          c = None
          assert a == Measure(value=4,error=2,unit=Unit("cm"))
          assert b == 0.3
    # Measure (Implicit Error) * Float
    if(True):
      # Measure Unitless * Float
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          assert isinstance( (  Measure(value=3)  *  0.3  ), Measure )
          error = measure._sqrt_( 3**2 * 0**2 + 0.3**2 * 0.5**2 )
          assert math.isclose( (  Measure(value=3)  *  0.3  ).value   , 0.9 )
          assert math.isclose( (  Measure(value=3)  *  0.3  ).error   , error )
          assert (  Measure(value=3)  *  0.3  ).implied == True
          assert (  Measure(value=3)  *  0.3  ).units.symbols   == Unit().symbols
          assert (  Measure(value=3)  *  0.3  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=3)  *  0.3  ) == Measure(units=Unit(), value= 0.9, error=error)
          # Value 2: Float
          assert isinstance( (  Measure(value=0.3)  *  0.3 ), Measure )
          error = measure._sqrt_( 0.3**2 * 0.05**2 + 0.3**2 * 0**2 )
          assert math.isclose( (  Measure(value=0.3)  *  0.3  ).value , 0.3*0.3 )
          assert math.isclose( (  Measure(value=0.3)  *  0.3  ).error , error   )
          assert (  Measure(value=0.3)  *  0.3  ).implied == True
          assert (  Measure(value=0.3)  *  0.3  ).units.symbols   == Unit().symbols
          assert (  Measure(value=0.3)  *  0.3  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=0.3)  *  0.3  ) == Measure(units=Unit(), value= 0.3*0.3, error=error)
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("40"))  *  0.3  ), Measure )
          error = measure._sqrt_(  40.0**2 * 0**2 + 0.3**2 * 5**2 )
          assert math.isclose( (  Measure(value=Decimal("40"))  *  0.3  ).value , 40.0*0.3 )
          assert math.isclose( (  Measure(value=Decimal("40"))  *  0.3  ).error , error    )
          assert (  Measure(value=Decimal("40"))  *  0.3  ).implied == True
          assert (  Measure(value=Decimal("40"))  *  0.3  ).units.symbols   == Unit().symbols
          assert (  Measure(value=Decimal("40"))  *  0.3  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=Decimal("40"))  *  0.3  ) == Measure(units=Unit(), value= 40.0*0.3, error=error)
          # Value 4: Negative
          assert isinstance( (  Measure(value=-3)  *  0.3  ), Measure )
          error = measure._sqrt_( 3**2 * 0**2 + 0.3**2 * 0.5**2 )
          assert math.isclose( (  Measure(value=-3)  *  0.3  ).value  , -3*0.3  )
          assert math.isclose( (  Measure(value=-3)  *  0.3  ).error  , error )
          assert (  Measure(value=-3)  *  0.3  ).implied == True
          assert (  Measure(value=-3)  *  0.3  ).units.symbols   == Unit().symbols
          assert (  Measure(value=-3)  *  0.3  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=-3)  *  0.3  ) == Measure(units=Unit(), value=-3*0.3, error=error)
        # Preserve Inputs
        if(True):
          a = Measure(value=3) 
          b = 0.3
          c = a*b
          c = None
          assert a == Measure(value=3) 
          assert b == 0.3
      # Measure Units * Float
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Measure(value=4,unit=Unit("cm"))  *  0.3  ), Measure )
          error = measure._sqrt_( 4**2 * 0**2 + 0.3**2 * 0.5**2 )
          assert math.isclose( (  Measure(value=4,unit=Unit("cm"))  *  0.3  ).value , 4*0.3 )
          assert math.isclose( (  Measure(value=4,unit=Unit("cm"))  *  0.3  ).error , error )
          assert (  Measure(value=4,unit=Unit("cm"))  *  0.3  ).implied == True
          assert (  Measure(value=4,unit=Unit("cm"))  *  0.3  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=4,unit=Unit("cm"))  *  0.3  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=4,unit=Unit("cm"))  *  0.3  ) == Measure(units=Unit("cm"), value= 4*0.3, error=error)
          # Value 2: Float
          assert isinstance( ( Measure(value=0.4,unit=Unit("cm"))  *  0.3  ), Measure )
          error = measure._sqrt_( 0.4**2 * 0**2 + 0.3**2 * 0.05**2 )
          assert math.isclose( (  Measure(value=0.4,unit=Unit("cm"))  *  0.3  ).value , 0.4*0.3 )
          assert math.isclose( (  Measure(value=0.4,unit=Unit("cm"))  *  0.3  ).error , error   )
          assert (  Measure(value=0.4,unit=Unit("cm"))  *  0.3  ).implied == True
          assert (  Measure(value=0.4,unit=Unit("cm"))  *  0.3  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=0.4,unit=Unit("cm"))  *  0.3  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=0.4,unit=Unit("cm"))  *  0.3  ) == Measure(units=Unit("cm"), value= 0.4*0.3, error=error)
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  0.3  ), Measure )
          error = measure._sqrt_( 40.0**2 * 0**2 + 0.3**2 * 5**2 )
          assert math.isclose( (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  0.3  ).value , 40.0*0.3 )
          assert math.isclose( (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  0.3  ).error , error    )
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  0.3  ).implied == True
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  0.3  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  0.3  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  0.3  ) == Measure(units=Unit("cm"), value= 40.0*0.3, error=error)
          # Value 4: Negative
          assert isinstance( ( Measure(value=-4,unit=Unit("cm"))  *  0.3  ), Measure )
          error = measure._sqrt_( 4**2 * 0**2 + 0.3**2 * 0.5**2 )
          assert math.isclose( (  Measure(value=-4,unit=Unit("cm"))  *  0.3  ).value , -4*0.3 )
          assert math.isclose( (  Measure(value=-4,unit=Unit("cm"))  *  0.3  ).error , error  )
          assert (  Measure(value=-4,unit=Unit("cm"))  *  0.3  ).implied == True
          assert (  Measure(value=-4,unit=Unit("cm"))  *  0.3  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=-4,unit=Unit("cm"))  *  0.3  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=-4,unit=Unit("cm"))  *  0.3  ) == Measure(units=Unit("cm"), value=-4*0.3, error=error)
        # Magnitude Units
        if(True):
          # Value 1: Int
          assert isinstance( (  Measure(value=2,unit=Unit("5 m^2"))  *  0.3  ) , Measure )
          error = measure._sqrt_( 0.3**2 * 2.5**2 + 10**2 * 0**2 )/5
          assert math.isclose( (  Measure(value=2,unit=Unit("5 m^2"))  *  0.3  ).value   , 2*0.3 )
          assert math.isclose( (  Measure(value=2,unit=Unit("5 m^2"))  *  0.3  ).error   , error )
          assert (  Measure(value=2,unit=Unit("5 m^2"))  *  0.3  ).implied == True
          assert (  Measure(value=2,unit=Unit("5 m^2"))  *  0.3  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=2,unit=Unit("5 m^2"))  *  0.3  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  Measure(value=2,unit=Unit("5 m^2"))  *  0.3  ) == Measure(units=Unit("5 m^2"), value=2*  0.3, error=error)
          # Value 2: Float
          assert isinstance( (  Measure(value=0.2,unit=Unit("5 m^2"))  *  0.3  ) , Measure )
          error = measure._sqrt_( 0.3**2 * 0.25**2 + 1.0**2 * 0**2 )/5
          assert math.isclose( (  Measure(value=0.2,unit=Unit("5 m^2"))  *  0.3  ).value , 0.2*0.3   )
          assert math.isclose( (  Measure(value=0.2,unit=Unit("5 m^2"))  *  0.3  ).error , error )
          assert (  Measure(value=0.2,unit=Unit("5 m^2"))  *  0.3  ).implied == True
          assert (  Measure(value=0.2,unit=Unit("5 m^2"))  *  0.3  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=0.2,unit=Unit("5 m^2"))  *  0.3  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  Measure(value=0.2,unit=Unit("5 m^2"))  *  0.3  ) == Measure(units=Unit("5 m^2"), value=0.2*0.3, error=error)
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  0.3  ) , Measure )
          error = measure._sqrt_( 0.3**2 * 25**2 + 100**2 * 0**2 )/5
          assert math.isclose( (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  0.3  ).value   , 20.0*0.3 )
          assert math.isclose( (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  0.3  ).error   , error )
          assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  0.3  ).implied == True
          assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  0.3  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  0.3  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  0.3  ) == Measure(units=Unit("5 m^2"), value=20.0*0.3, error=error)
          # Value 4: Negative
          assert isinstance( (  Measure(value=-2,unit=Unit("5 m^2"))  *  0.3  ) , Measure )
          error = measure._sqrt_( 0.3**2 * 2.5**2 + 10**2 * 0**2 )/5
          assert math.isclose( (  Measure(value=-2,unit=Unit("5 m^2"))  *  0.3  ).value   , -2*0.3 )
          assert math.isclose( (  Measure(value=-2,unit=Unit("5 m^2"))  *  0.3  ).error   , error  )
          assert (  Measure(value=-2,unit=Unit("5 m^2"))  *  0.3  ).implied == True
          assert (  Measure(value=-2,unit=Unit("5 m^2"))  *  0.3  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=-2,unit=Unit("5 m^2"))  *  0.3  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  Measure(value=-2,unit=Unit("5 m^2"))  *  0.3  ) == Measure(units=Unit("5 m^2"), value=-2*0.3, error=error)
        # Convoluted Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Measure(value=27,unit=Unit("\u00B0C"))  *  0.3 ), Measure )
          error = measure._sqrt_( 0.3**2 * 0.5**2 + 300.15**2 * 0**2 )
          assert math.isclose( ( Measure(value=27,unit=Unit("\u00B0C"))  *  0.3 ).value , 0.3*300.15-273.15 )
          assert math.isclose( ( Measure(value=27,unit=Unit("\u00B0C"))  *  0.3 ).error , error )
          assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  0.3 ).implied == True
          assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  0.3 ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  0.3 ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  0.3 ) == Measure(units=Unit("\u00B0C"), value=0.3*300.15-273.15, error=error)
          # Value 2: Float
          assert isinstance( ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  0.3 ), Measure )
          error = measure._sqrt_( 0.3**2 * 0.005**2 + 300**2 * 0**2 )
          assert math.isclose( ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  0.3 ).value   , 0.3 * 300 - 273.15 )
          assert math.isclose( ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  0.3 ).error   , error )
          assert ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  0.3 ).implied == True
          assert ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  0.3 ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  0.3 ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  0.3 ) == Measure(units=Unit("\u00B0C"), value= 0.3 * 300 - 273.15, error=error)
          # Value 3: Decimal
          assert isinstance( ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  0.3 ), Measure )
          error = measure._sqrt_( 0.3**2 * 0.005**2 + 300.0**2 * 0**2 )
          assert math.isclose( ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  0.3 ).value , 0.3*300-273.15 )
          assert math.isclose( ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  0.3 ).error , error )
          assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  0.3 ).implied == True
          assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  0.3 ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  0.3 ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  0.3 ) == Measure(units=Unit("\u00B0C"), value=0.3*300-273.15, error=error)
          # Value 4: Negative
          assert isinstance( ( Measure(value=-27,unit=Unit("\u00B0C"))  *  0.3 ), Measure )
          error = measure._sqrt_( 0.3**2 * 0.5**2 + 246.15**2 * 0**2 )
          assert math.isclose( ( Measure(value=-27,unit=Unit("\u00B0C"))  *  0.3 ).value , 0.3*246.15-273.15 )
          assert math.isclose( ( Measure(value=-27,unit=Unit("\u00B0C"))  *  0.3 ).error , error )
          assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  0.3 ).implied == True
          assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  0.3 ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  0.3 ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  0.3 ) == Measure(units=Unit("\u00B0C"), value= 0.3*246.15-273.15, error=error)
        # Preserve Inputs
        if(True):
          a = Measure(value=4,unit=Unit("cm"))
          b = 0.3
          c = a*b
          c = None
          assert a == Measure(value=4,unit=Unit("cm"))
          assert b == 0.3
    # Float * Measure (Explicit Error)
    if(True):
      # Float * Measure Unitless
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          assert isinstance( (  0.3 * Measure(value=3,error=2)  ), Measure )
          error = measure._sqrt_( 3**2 * 0**2 + 0.3**2 * 2**2 )
          assert math.isclose( (  0.3 * Measure(value=3,error=2)  ).value , 0.3*3 )
          assert math.isclose( (  0.3 * Measure(value=3,error=2)  ).error , error )
          assert (  0.3 * Measure(value=3,error=2)  ).implied == False
          assert (  0.3 * Measure(value=3,error=2)  ).units.symbols   == Unit().symbols
          assert (  0.3 * Measure(value=3,error=2)  ).units.magnitude == Unit().magnitude
          assert (  0.3 * Measure(value=3,error=2)  ) == Measure(units=Unit(), value= 3*0.3, error=error)
          # Value 2: Float
          assert isinstance( (  0.3 * Measure(value=0.3,error=0.2) ), Measure )
          error = measure._sqrt_( 0.3**2 * 0.2**2 + 0.3**2 * 0**2 )
          assert math.isclose( (  0.3 * Measure(value=0.3,error=0.2)  ).value , 0.3*0.3 )
          assert math.isclose( (  0.3 * Measure(value=0.3,error=0.2)  ).error , error )
          assert (  0.3 * Measure(value=0.3,error=0.2)  ).implied == False
          assert (  0.3 * Measure(value=0.3,error=0.2)  ).units.symbols   == Unit().symbols
          assert (  0.3 * Measure(value=0.3,error=0.2)  ).units.magnitude == Unit().magnitude
          assert (  0.3 * Measure(value=0.3,error=0.2)  ) == Measure(units=Unit(), value= 0.3*0.3, error=error)
          # Value 3: Decimal
          assert isinstance( (  0.3 * Measure(value=Decimal("40"),error=Decimal("20"))  ), Measure )
          error = measure._sqrt_(  40.0**2 * 0**2 + 0.3**2 * 20.0**2 )
          assert math.isclose( (  0.3 * Measure(value=Decimal("40"),error=Decimal("20"))  ).value , 40.0*0.3 )
          assert math.isclose( (  0.3 * Measure(value=Decimal("40"),error=Decimal("20"))  ).error , error )
          assert (  0.3 * Measure(value=Decimal("40"),error=Decimal("20"))  ).implied == False
          assert (  0.3 * Measure(value=Decimal("40"),error=Decimal("20"))  ).units.symbols   == Unit().symbols
          assert (  0.3 * Measure(value=Decimal("40"),error=Decimal("20"))  ).units.magnitude == Unit().magnitude
          assert (  0.3 * Measure(value=Decimal("40"),error=Decimal("20"))  ) == Measure(units=Unit(), value= 40.0*0.3, error=error)
          # Value 4: Negative
          assert isinstance( (  0.3 * Measure(value=-3,error=2)  ), Measure )
          error = measure._sqrt_( 3**2 * 0**2 + 0.3**2 * 2**2 )
          assert math.isclose( (  0.3 * Measure(value=-3,error=2)  ).value , -3*0.3 )
          assert math.isclose( (  0.3 * Measure(value=-3,error=2)  ).error , error )
          assert (  0.3 * Measure(value=-3,error=2)  ).implied == False
          assert (  0.3 * Measure(value=-3,error=2)  ).units.symbols   == Unit().symbols
          assert (  0.3 * Measure(value=-3,error=2)  ).units.magnitude == Unit().magnitude
          assert (  0.3 * Measure(value=-3,error=2)  ) == Measure(units=Unit(), value=-3*0.3, error=error)
        # Preserve Inputs
        if(True):
          a = 0.3
          b = Measure(value=3,error=2) 
          c = a*b
          c = None
          assert a == 0.3
          assert b == Measure(value=3,error=2) 
      # Float * Measure Units 
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          assert isinstance( ( 0.3 * Measure(value=4,error=2,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( 4**2 * 0**2 + 0.3**2 * 2**2 )
          assert math.isclose( (  0.3 * Measure(value=4,error=2,unit=Unit("cm"))  ).value , 4*0.3 )
          assert math.isclose( (  0.3 * Measure(value=4,error=2,unit=Unit("cm"))  ).error , error )
          assert (  0.3 * Measure(value=4,error=2,unit=Unit("cm"))  ).implied == False
          assert (  0.3 * Measure(value=4,error=2,unit=Unit("cm"))  ).units.symbols   == Unit("cm").symbols
          assert (  0.3 * Measure(value=4,error=2,unit=Unit("cm"))  ).units.magnitude == Unit("cm").magnitude
          assert (  0.3 * Measure(value=4,error=2,unit=Unit("cm"))  ) == Measure(units=Unit("cm"), value= 4*0.3, error=error)
          # Value 2: Float
          assert isinstance( ( 0.3 * Measure(value=0.4,error=0.2,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( 0.4**2 * 0**2 + 0.3**2 * 0.2**2 )
          assert math.isclose( (  0.3 * Measure(value=0.4,error=0.2,unit=Unit("cm"))  ).value , 0.4*0.3 )
          assert math.isclose( (  0.3 * Measure(value=0.4,error=0.2,unit=Unit("cm"))  ).error , error   )
          assert (  0.3 * Measure(value=0.4,error=0.2,unit=Unit("cm"))  ).implied == False
          assert (  0.3 * Measure(value=0.4,error=0.2,unit=Unit("cm"))  ).units.symbols   == Unit("cm").symbols
          assert (  0.3 * Measure(value=0.4,error=0.2,unit=Unit("cm"))  ).units.magnitude == Unit("cm").magnitude
          assert (  0.3 * Measure(value=0.4,error=0.2,unit=Unit("cm"))  ) == Measure(units=Unit("cm"), value= 0.4*0.3, error=error)
          # Value 3: Decimal
          assert isinstance( (  0.3 * Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( 40.0**2 * 0**2 + 0.3**2 * 20.0**2 )
          assert math.isclose( (  0.3 * Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  ).value , 40.0*0.3 )
          assert math.isclose( (  0.3 * Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  ).error , error )
          assert (  0.3 * Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  ).implied == False
          assert (  0.3 * Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  ).units.symbols   == Unit("cm").symbols
          assert (  0.3 * Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  ).units.magnitude == Unit("cm").magnitude
          assert (  0.3 * Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  ) == Measure(units=Unit("cm"), value= 40.0*0.3, error=error)
          # Value 4: Negative
          assert isinstance( ( 0.3 * Measure(value=-4,error=2,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( 4**2 * 0**2 + 0.3**2 * 2**2 )
          assert math.isclose( (  0.3 * Measure(value=-4,error=2,unit=Unit("cm"))  ).value , -4*0.3 )
          assert math.isclose( (  0.3 * Measure(value=-4,error=2,unit=Unit("cm"))  ).error , error  )
          assert (  0.3 * Measure(value=-4,error=2,unit=Unit("cm"))  ).implied == False
          assert (  0.3 * Measure(value=-4,error=2,unit=Unit("cm"))  ).units.symbols   == Unit("cm").symbols
          assert (  0.3 * Measure(value=-4,error=2,unit=Unit("cm"))  ).units.magnitude == Unit("cm").magnitude
          assert (  0.3 * Measure(value=-4,error=2,unit=Unit("cm"))  ) == Measure(units=Unit("cm"), value=-4*0.3, error=error)
        # Magnitude Units
        if(True):
          # Value 1: Int
          assert isinstance( (  0.3 * Measure(value=2,error=1,unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( 0.3**2 * 5**2 + 10**2 * 0**2 )/5
          assert math.isclose( (  0.3 * Measure(value=2,error=1,unit=Unit("5 m^2"))  ).value   , 2*0.3 )
          assert math.isclose( (  0.3 * Measure(value=2,error=1,unit=Unit("5 m^2"))  ).error   , error )
          assert (  0.3 * Measure(value=2,error=1,unit=Unit("5 m^2"))  ).implied == False
          assert (  0.3 * Measure(value=2,error=1,unit=Unit("5 m^2"))  ).units.symbols   == Unit("5 m^2").symbols
          assert (  0.3 * Measure(value=2,error=1,unit=Unit("5 m^2"))  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  0.3 * Measure(value=2,error=1,unit=Unit("5 m^2"))  ) == Measure(units=Unit("5 m^2"), value=2*  0.3, error=error)
          # Value 2: Float
          assert isinstance( (  0.3 * Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( 0.3**2 * 0.5**2 + 1.0**2 * 0**2 )/5
          assert math.isclose( (  0.3 * Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  ).value , 0.2*0.3 )
          assert math.isclose( (  0.3 * Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  ).error , error )
          assert (  0.3 * Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  ).implied == False
          assert (  0.3 * Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  ).units.symbols   == Unit("5 m^2").symbols
          assert (  0.3 * Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  0.3 * Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  ) == Measure(units=Unit("5 m^2"), value=0.2*0.3, error=error)
          # Value 3: Decimal
          assert isinstance( (  0.3 * Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( 0.3**2 * 25**2 + 100**2 * 0**2 )/5
          assert math.isclose( (  0.3 * Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  ).value   , 20.0*0.3 )
          assert math.isclose( (  0.3 * Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  ).error   , error )
          assert (  0.3 * Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  ).implied == False
          assert (  0.3 * Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  ).units.symbols   == Unit("5 m^2").symbols
          assert (  0.3 * Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  0.3 * Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  ) == Measure(units=Unit("5 m^2"), value=20.0*0.3, error=error)
          # Value 4: Negative
          assert isinstance( (  0.3 * Measure(value=-2,error=1,unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( 0.3**2 * 5**2 + 10**2 * 0**2 )/5
          assert math.isclose( (  0.3 * Measure(value=-2,error=1,unit=Unit("5 m^2"))  ).value   , -2*0.3 )
          assert math.isclose( (  0.3 * Measure(value=-2,error=1,unit=Unit("5 m^2"))  ).error   , error  )
          assert (  0.3 * Measure(value=-2,error=1,unit=Unit("5 m^2"))  ).implied == False
          assert (  0.3 * Measure(value=-2,error=1,unit=Unit("5 m^2"))  ).units.symbols   == Unit("5 m^2").symbols
          assert (  0.3 * Measure(value=-2,error=1,unit=Unit("5 m^2"))  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  0.3 * Measure(value=-2,error=1,unit=Unit("5 m^2"))  ) == Measure(units=Unit("5 m^2"), value=-2*0.3, error=error)
        # Convoluted Units
        if(True):
          # Value 1: Int
          assert isinstance( ( 0.3 * Measure(value=27,error=1,unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( 0.3**2 * 1**2 + 300.15**2 * 0**2 )
          assert math.isclose( ( 0.3 * Measure(value=27,error=1,unit=Unit("\u00B0C")) ).value   , 0.3*300.15-273.15 )
          assert math.isclose( ( 0.3 * Measure(value=27,error=1,unit=Unit("\u00B0C")) ).error   , error )
          assert ( 0.3 * Measure(value=27,error=1,unit=Unit("\u00B0C")) ).implied == False
          assert ( 0.3 * Measure(value=27,error=1,unit=Unit("\u00B0C")) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( 0.3 * Measure(value=27,error=1,unit=Unit("\u00B0C")) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( 0.3 * Measure(value=27,error=1,unit=Unit("\u00B0C")) ) == Measure(units=Unit("\u00B0C"), value=0.3*300.15-273.15, error=error)
          # Value 2: Float
          assert isinstance( ( 0.3 * Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( 0.3**2 * 0.02**2 + 300**2 * 0**2 )
          assert math.isclose( ( 0.3 * Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).value   , 0.3 * 300 - 273.15 )
          assert math.isclose( ( 0.3 * Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).error   , error )
          assert ( 0.3 * Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).implied == False
          assert ( 0.3 * Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( 0.3 * Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( 0.3 * Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ) == Measure(units=Unit("\u00B0C"), value= 0.3 * 300 - 273.15, error=error)
          # Value 3: Decimal
          assert isinstance( ( 0.3 * Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( 0.3**2 * 0.02**2 + 300.0**2 * 0**2 )
          assert math.isclose( ( 0.3 * Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).value , 0.3*300-273.15 )
          assert math.isclose( ( 0.3 * Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).error , error )
          assert ( 0.3 * Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).implied == False
          assert ( 0.3 * Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( 0.3 * Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( 0.3 * Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ) == Measure(units=Unit("\u00B0C"), value=0.3*300-273.15, error=error)
          # Value 4: Negative
          assert isinstance( ( 0.3 * Measure(value=-27,error=1,unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( 0.3**2 * 1**2 + 246.15**2 * 0**2 )
          assert math.isclose( ( 0.3 * Measure(value=-27,error=1,unit=Unit("\u00B0C")) ).value , 0.3*246.15-273.15 )
          assert math.isclose( ( 0.3 * Measure(value=-27,error=1,unit=Unit("\u00B0C")) ).error , error )
          assert ( 0.3 * Measure(value=-27,error=1,unit=Unit("\u00B0C")) ).implied == False
          assert ( 0.3 * Measure(value=-27,error=1,unit=Unit("\u00B0C")) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( 0.3 * Measure(value=-27,error=1,unit=Unit("\u00B0C")) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( 0.3 * Measure(value=-27,error=1,unit=Unit("\u00B0C")) ) == Measure(units=Unit("\u00B0C"), value= 0.3*246.15-273.15, error=error)
        # Preserve Inputs
        if(True):
          a = 0.3
          b = Measure(value=4,error=2,unit=Unit("cm"))
          c = a*b
          c = None
          assert a == 0.3
          assert b == Measure(value=4,error=2,unit=Unit("cm"))
    # Float * Measure (Implicit Error)
    if(True):
      # Float * Measure Unitless
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          assert isinstance( (  0.3 * Measure(value=3)  ), Measure )
          error = measure._sqrt_( 3**2 * 0**2 + 0.3**2 * 0.5**2 )
          assert math.isclose( (  0.3 * Measure(value=3)  ).value , 0.3*3 )
          assert math.isclose( (  0.3 * Measure(value=3)  ).error , error )
          assert (  0.3 * Measure(value=3)  ).implied == True
          assert (  0.3 * Measure(value=3)  ).units.symbols   == Unit().symbols
          assert (  0.3 * Measure(value=3)  ).units.magnitude == Unit().magnitude
          assert (  0.3 * Measure(value=3)  ) == Measure(units=Unit(), value= 0.3*3, error=error)
          # Value 2: Float
          assert isinstance( (  0.3 * Measure(value=0.3) ), Measure )
          error = measure._sqrt_( 0.3**2 * 0.05**2 + 0.3**2 * 0**2 )
          assert math.isclose( (  0.3 * Measure(value=0.3)  ).value , 0.3*0.3 )
          assert math.isclose( (  0.3 * Measure(value=0.3)  ).error , error   )
          assert (  0.3 * Measure(value=0.3)  ).implied == True
          assert (  0.3 * Measure(value=0.3)  ).units.symbols   == Unit().symbols
          assert (  0.3 * Measure(value=0.3)  ).units.magnitude == Unit().magnitude
          assert (  0.3 * Measure(value=0.3)  ) == Measure(units=Unit(), value= 0.3*0.3, error=error)
          # Value 3: Decimal
          assert isinstance( (  0.3 * Measure(value=Decimal("40"))  ), Measure )
          error = measure._sqrt_(  40.0**2 * 0**2 + 0.3**2 * 5**2 )
          assert math.isclose( (  0.3 * Measure(value=Decimal("40"))  ).value , 40.0*0.3 )
          assert math.isclose((  0.3 * Measure(value=Decimal("40"))  ).error  , error )
          assert (  0.3 * Measure(value=Decimal("40"))  ).implied == True
          assert (  0.3 * Measure(value=Decimal("40"))  ).units.symbols   == Unit().symbols
          assert (  0.3 * Measure(value=Decimal("40"))  ).units.magnitude == Unit().magnitude
          assert (  0.3 * Measure(value=Decimal("40"))  ) == Measure(units=Unit(), value= 40.0*0.3, error=error)
          # Value 4: Negative
          assert isinstance( (  0.3 * Measure(value=-3)  ), Measure )
          error = measure._sqrt_( 3**2 * 0**2 + 0.3**2 * 0.5**2 )
          assert math.isclose((  0.3 * Measure(value=-3)  ).value , -3*0.3  )
          assert math.isclose((  0.3 * Measure(value=-3)  ).error , error )
          assert (  0.3 * Measure(value=-3)  ).implied == True
          assert (  0.3 * Measure(value=-3)  ).units.symbols   == Unit().symbols
          assert (  0.3 * Measure(value=-3)  ).units.magnitude == Unit().magnitude
          assert (  0.3 * Measure(value=-3)  ) == Measure(units=Unit(), value=-3*0.3, error=error)
        # Preserve Inputs
        if(True):
          a = 0.3
          b = Measure(value=3) 
          c = a*b
          c = None
          assert a == 0.3 
          assert b == Measure(value=3) 
      # Float * Measure Units
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          assert isinstance( ( 0.3 * Measure(value=4,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( 4**2 * 0**2 + 0.3**2 * 0.5**2 )
          assert math.isclose( (  0.3 * Measure(value=4,unit=Unit("cm"))  ).value , 4*0.3 )
          assert math.isclose( (  0.3 * Measure(value=4,unit=Unit("cm"))  ).error , error )
          assert (  0.3 * Measure(value=4,unit=Unit("cm"))  ).implied == True
          assert (  0.3 * Measure(value=4,unit=Unit("cm"))  ).units.symbols   == Unit("cm").symbols
          assert (  0.3 * Measure(value=4,unit=Unit("cm"))  ).units.magnitude == Unit("cm").magnitude
          assert (  0.3 * Measure(value=4,unit=Unit("cm"))  ) == Measure(units=Unit("cm"), value= 4*0.3, error=error)
          # Value 2: Float
          assert isinstance( ( 0.3 * Measure(value=0.4,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( 0.4**2 * 0**2 + 0.3**2 * 0.05**2 )
          assert math.isclose( (  0.3 * Measure(value=0.4,unit=Unit("cm"))  ).value , 0.4*0.3 )
          assert math.isclose( (  0.3 * Measure(value=0.4,unit=Unit("cm"))  ).error , error   )
          assert (  0.3 * Measure(value=0.4,unit=Unit("cm"))  ).implied == True
          assert (  0.3 * Measure(value=0.4,unit=Unit("cm"))  ).units.symbols   == Unit("cm").symbols
          assert (  0.3 * Measure(value=0.4,unit=Unit("cm"))  ).units.magnitude == Unit("cm").magnitude
          assert (  0.3 * Measure(value=0.4,unit=Unit("cm"))  ) == Measure(units=Unit("cm"), value= 0.4*0.3, error=error)
          # Value 3: Decimal
          assert isinstance( (  0.3 * Measure(value=Decimal("40"),unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( 40.0**2 * 0**2 + 0.3**2 * 5**2 )
          assert math.isclose( (  0.3 * Measure(value=Decimal("40"),unit=Unit("cm"))  ).value , 40.0*0.3 )
          assert math.isclose( (  0.3 * Measure(value=Decimal("40"),unit=Unit("cm"))  ).error , error )
          assert (  0.3 * Measure(value=Decimal("40"),unit=Unit("cm"))  ).implied == True
          assert (  0.3 * Measure(value=Decimal("40"),unit=Unit("cm"))  ).units.symbols   == Unit("cm").symbols
          assert (  0.3 * Measure(value=Decimal("40"),unit=Unit("cm"))  ).units.magnitude == Unit("cm").magnitude
          assert (  0.3 * Measure(value=Decimal("40"),unit=Unit("cm"))  ) == Measure(units=Unit("cm"), value= 40.0*0.3, error=error)
          # Value 4: Negative
          assert isinstance( ( 0.3 * Measure(value=-4,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( 4**2 * 0**2 + 0.3**2 * 0.5**2 )
          assert math.isclose( (  0.3 * Measure(value=-4,unit=Unit("cm"))  ).value , -4*0.3 )
          assert math.isclose( (  0.3 * Measure(value=-4,unit=Unit("cm"))  ).error , error  )
          assert (  0.3 * Measure(value=-4,unit=Unit("cm"))  ).implied == True
          assert (  0.3 * Measure(value=-4,unit=Unit("cm"))  ).units.symbols   == Unit("cm").symbols
          assert (  0.3 * Measure(value=-4,unit=Unit("cm"))  ).units.magnitude == Unit("cm").magnitude
          assert (  0.3 * Measure(value=-4,unit=Unit("cm"))  ) == Measure(units=Unit("cm"), value=-4*0.3, error=error)
        # Magnitude Units
        if(True):
          # Value 1: Int
          assert isinstance( (  0.3 * Measure(value=2,unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( 0.3**2 * 2.5**2 + 10**2 * 0**2 )/5
          assert math.isclose( (  0.3 * Measure(value=2,unit=Unit("5 m^2"))  ).value , 2*0.3 )
          assert math.isclose( (  0.3 * Measure(value=2,unit=Unit("5 m^2"))  ).error , error )
          assert (  0.3 * Measure(value=2,unit=Unit("5 m^2"))  ).implied == True
          assert (  0.3 * Measure(value=2,unit=Unit("5 m^2"))  ).units.symbols   == Unit("5 m^2").symbols
          assert (  0.3 * Measure(value=2,unit=Unit("5 m^2"))  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  0.3 * Measure(value=2,unit=Unit("5 m^2"))  ) == Measure(units=Unit("5 m^2"), value=2*  0.3, error=error)
          # Value 2: Float
          assert isinstance( (  0.3 * Measure(value=0.2,unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( 0.3**2 * 0.25**2 + 1.0**2 * 0**2 )/5
          assert math.isclose( (  0.3 * Measure(value=0.2,unit=Unit("5 m^2"))  ).value , 0.2*0.3   )
          assert math.isclose( (  0.3 * Measure(value=0.2,unit=Unit("5 m^2"))  ).error , error )
          assert (  0.3 * Measure(value=0.2,unit=Unit("5 m^2"))  ).implied == True
          assert (  0.3 * Measure(value=0.2,unit=Unit("5 m^2"))  ).units.symbols   == Unit("5 m^2").symbols
          assert (  0.3 * Measure(value=0.2,unit=Unit("5 m^2"))  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  0.3 * Measure(value=0.2,unit=Unit("5 m^2"))  ) == Measure(units=Unit("5 m^2"), value=0.2*0.3, error=error)
          # Value 3: Decimal
          assert isinstance( (  0.3 * Measure(value=Decimal("20"),unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( 0.3**2 * 25**2 + 100**2 * 0**2 )/5
          assert math.isclose( (  0.3 * Measure(value=Decimal("20"),unit=Unit("5 m^2"))  ).value , 20.0*0.3 )
          assert math.isclose( (  0.3 * Measure(value=Decimal("20"),unit=Unit("5 m^2"))  ).error , error )
          assert (  0.3 * Measure(value=Decimal("20"),unit=Unit("5 m^2"))  ).implied == True
          assert (  0.3 * Measure(value=Decimal("20"),unit=Unit("5 m^2"))  ).units.symbols   == Unit("5 m^2").symbols
          assert (  0.3 * Measure(value=Decimal("20"),unit=Unit("5 m^2"))  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  0.3 * Measure(value=Decimal("20"),unit=Unit("5 m^2"))  ) == Measure(units=Unit("5 m^2"), value=20.0*0.3, error=error)
          # Value 4: Negative
          assert isinstance( (  0.3 * Measure(value=-2,unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( 0.3**2 * 2.5**2 + 10**2 * 0**2 )/5
          assert math.isclose( (  0.3 * Measure(value=-2,unit=Unit("5 m^2"))  ).value , -2*0.3 )
          assert math.isclose( (  0.3 * Measure(value=-2,unit=Unit("5 m^2"))  ).error , error  )
          assert (  0.3 * Measure(value=-2,unit=Unit("5 m^2"))  ).implied == True
          assert (  0.3 * Measure(value=-2,unit=Unit("5 m^2"))  ).units.symbols   == Unit("5 m^2").symbols
          assert (  0.3 * Measure(value=-2,unit=Unit("5 m^2"))  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  0.3 * Measure(value=-2,unit=Unit("5 m^2"))  ) == Measure(units=Unit("5 m^2"), value=-2*0.3, error=error)
        # Convoluted Units
        if(True):
          # Value 1: Int
          assert isinstance( ( 0.3 * Measure(value=27,unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( 0.3**2 * 0.5**2 + 300.15**2 * 0**2 )
          assert math.isclose( ( 0.3 * Measure(value=27,unit=Unit("\u00B0C")) ).value , 0.3*300.15-273.15 )
          assert math.isclose( ( 0.3 * Measure(value=27,unit=Unit("\u00B0C")) ).error , error )
          assert ( 0.3 * Measure(value=27,unit=Unit("\u00B0C")) ).implied == True
          assert ( 0.3 * Measure(value=27,unit=Unit("\u00B0C")) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( 0.3 * Measure(value=27,unit=Unit("\u00B0C")) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( 0.3 * Measure(value=27,unit=Unit("\u00B0C")) ) == Measure(units=Unit("\u00B0C"), value=0.3*300.15-273.15, error=error)
          # Value 2: Float
          assert isinstance( ( 0.3 * Measure(value=26.85,unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( 0.3**2 * 0.005**2 + 300**2 * 0**2 )
          assert math.isclose( ( 0.3 * Measure(value=26.85,unit=Unit("\u00B0C")) ).value   , 0.3 * 300 - 273.15 )
          assert math.isclose( ( 0.3 * Measure(value=26.85,unit=Unit("\u00B0C")) ).error   , error )
          assert ( 0.3 * Measure(value=26.85,unit=Unit("\u00B0C")) ).implied == True
          assert ( 0.3 * Measure(value=26.85,unit=Unit("\u00B0C")) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( 0.3 * Measure(value=26.85,unit=Unit("\u00B0C")) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( 0.3 * Measure(value=26.85,unit=Unit("\u00B0C")) ) == Measure(units=Unit("\u00B0C"), value= 0.3 * 300 - 273.15, error=error)
          # Value 3: Decimal
          assert isinstance( ( 0.3 * Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( 0.3**2 * 0.005**2 + 300.0**2 * 0**2 )
          assert math.isclose( ( 0.3 * Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).value , 0.3*300-273.15 )
          assert math.isclose( ( 0.3 * Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).error , error )
          assert ( 0.3 * Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).implied == True
          assert ( 0.3 * Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( 0.3 * Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( 0.3 * Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ) == Measure(units=Unit("\u00B0C"), value=0.3*300-273.15, error=error)
          # Value 4: Negative
          assert isinstance( ( 0.3 * Measure(value=-27,unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( 0.3**2 * 0.5**2 + 246.15**2 * 0**2 )
          assert math.isclose( ( 0.3 * Measure(value=-27,unit=Unit("\u00B0C")) ).value , 0.3*246.15-273.15 )
          assert math.isclose( ( 0.3 * Measure(value=-27,unit=Unit("\u00B0C")) ).error , error )
          assert ( 0.3 * Measure(value=-27,unit=Unit("\u00B0C")) ).implied == True
          assert ( 0.3 * Measure(value=-27,unit=Unit("\u00B0C")) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( 0.3 * Measure(value=-27,unit=Unit("\u00B0C")) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( 0.3 * Measure(value=-27,unit=Unit("\u00B0C")) ) == Measure(units=Unit("\u00B0C"), value= 0.3*246.15-273.15, error=error)
        # Preserve Inputs
        if(True):
          a = 0.3
          b = Measure(value=4,unit=Unit("cm"))
          c = a*b
          c = None
          assert a == 0.3
          assert b == Measure(value=4,unit=Unit("cm"))
  
  def test_measure_str_measure_mul(self):
    # These are dependent on Measure str parser 
    
    # Str Measure * Measure
    if(True):
      # Str Measure (Explicit Error) * Measure (Explicit Error) = Measure (Explicit Error)
      if(True):
        # Unitless * Unitless
        if(True):
          # Value 1: Int
          assert isinstance( ( "4 ± 2"   *  Measure(value=3,error=2)  ), Measure )
          error = measure._sqrt_( (Decimal("4")**2 * Decimal("2")**2 + Decimal("3")**2 * Decimal("2")**2) )
          assert (  "4 ± 2"   *  Measure(value=3,error=2)  ).value   == 12
          assert (  "4 ± 2"   *  Measure(value=3,error=2)  ).error   == error
          assert (  "4 ± 2"   *  Measure(value=3,error=2)  ).implied == False
          assert (  "4 ± 2"   *  Measure(value=3,error=2)  ).units.symbols   == Unit().symbols
          assert (  "4 ± 2"   *  Measure(value=3,error=2)  ).units.magnitude == Unit().magnitude
          assert (  "4 ± 2"   *  Measure(value=3,error=2)  ) == Measure(units=Unit(), value= 12, error=error)
          # Value 2: Float
          assert isinstance( ( "0.4 ± 0.2"   *  Measure(value=0.3,error=0.2)  ), Measure )
          error = measure._sqrt_( (0.4**2 * 0.2**2 + 0.3**2 * 0.2**2) )
          assert math.isclose( (  "0.4 ± 0.2"   *  Measure(value=0.3,error=0.2)  ).value , 0.4*0.3 )
          assert math.isclose( (  "0.4 ± 0.2"   *  Measure(value=0.3,error=0.2)  ).error , error   )
          assert (  "0.4 ± 0.2"   *  Measure(value=0.3,error=0.2)  ).implied == False
          assert (  "0.4 ± 0.2"   *  Measure(value=0.3,error=0.2)  ).units.symbols   == Unit().symbols
          assert (  "0.4 ± 0.2"   *  Measure(value=0.3,error=0.2)  ).units.magnitude == Unit().magnitude
          assert (  "0.4 ± 0.2"   *  Measure(value=0.3,error=0.2)  ) == Measure(units=Unit(), value= 0.4*0.3, error=error)
          # Value 3: Decimal
          assert isinstance( (  "40 ± 20"   *  Measure(value=Decimal("30"),error=Decimal("20"))  ), Measure )
          error = measure._sqrt_( (Decimal("40")**2 * Decimal("20")**2 + Decimal("30")**2 * Decimal("20")**2) )
          assert (  "40 ± 20"   *  Measure(value=Decimal("30"),error=Decimal("20"))  ).value   == Decimal("1200")
          assert (  "40 ± 20"   *  Measure(value=Decimal("30"),error=Decimal("20"))  ).error   == error
          assert (  "40 ± 20"   *  Measure(value=Decimal("30"),error=Decimal("20"))  ).implied == False
          assert (  "40 ± 20"   *  Measure(value=Decimal("30"),error=Decimal("20"))  ).units.symbols   == Unit().symbols
          assert (  "40 ± 20"   *  Measure(value=Decimal("30"),error=Decimal("20"))  ).units.magnitude == Unit().magnitude
          assert (  "40 ± 20"   *  Measure(value=Decimal("30"),error=Decimal("20"))  ) == Measure(units=Unit(), value= Decimal("1200"), error=error)
          # Value 4: Negative
          assert isinstance( ( "-4 ± 2"   *  Measure(value=-3,error=2)  ), Measure )
          error = measure._sqrt_( (Decimal("4")**2 * Decimal("2")**2 + Decimal("3")**2 * Decimal("2")**2) )
          assert (  "-4 ± 2"   *  Measure(value=-3,error=2)  ).value   == 12
          assert (  "-4 ± 2"   *  Measure(value=-3,error=2)  ).error   == error
          assert (  "-4 ± 2"   *  Measure(value=-3,error=2)  ).implied == False
          assert (  "-4 ± 2"   *  Measure(value=-3,error=2)  ).units.symbols   == Unit().symbols
          assert (  "-4 ± 2"   *  Measure(value=-3,error=2)  ).units.magnitude == Unit().magnitude
          assert (  "-4 ± 2"   *  Measure(value=-3,error=2)  ) == Measure(units=Unit(), value= 12, error=error)
          # Preserve Inputs
          if(True):
            a = "4 ± 2"  
            b = Measure(value=3,error=2)
            c = a*b
            c = None
            assert a == "4 ± 2"  
            assert b == Measure(value=3,error=2)
        # Unitless * Unit
        if(True):
          # Normal Units
          if(True):
            # Value 1: Int
            assert isinstance( (  "3 ± 2"  *  Measure(value=4,error=2,unit=Unit("cm"))  ), Measure )
            error = measure._sqrt_( (Decimal("4")**2 * Decimal("2")**2 + Decimal("3")**2 * Decimal("2")**2) )
            assert (  "3 ± 2"  *  Measure(value=4,error=2,unit=Unit("cm"))  ).value   == 12
            assert (  "3 ± 2"  *  Measure(value=4,error=2,unit=Unit("cm"))  ).error   == error
            assert (  "3 ± 2"  *  Measure(value=4,error=2,unit=Unit("cm"))  ).implied == False
            assert (  "3 ± 2"  *  Measure(value=4,error=2,unit=Unit("cm"))  ).units.symbols   == Unit("cm").symbols
            assert (  "3 ± 2"  *  Measure(value=4,error=2,unit=Unit("cm"))  ).units.magnitude == Unit("cm").magnitude
            assert (  "3 ± 2"  *  Measure(value=4,error=2,unit=Unit("cm"))  ) == Measure(units=Unit("cm"), value= 12, error=error)
            # Value 2: Float
            assert isinstance( (  "0.3 ± 0.2"  *  Measure(value=0.4,error=0.2,unit=Unit("cm")) ), Measure )
            error = measure._sqrt_( (0.4**2 * 0.2**2 + 0.3**2 * 0.2**2) )
            assert math.isclose( (  "0.3 ± 0.2"  *  Measure(value=0.4,error=0.2,unit=Unit("cm"))  ).value , 0.3*0.4 )
            assert math.isclose( (  "0.3 ± 0.2"  *  Measure(value=0.4,error=0.2,unit=Unit("cm"))  ).error , error   )
            assert (  "0.3 ± 0.2"  *  Measure(value=0.4,error=0.2,unit=Unit("cm"))  ).implied == False
            assert (  "0.3 ± 0.2"  *  Measure(value=0.4,error=0.2,unit=Unit("cm"))  ).units.symbols   == Unit("cm").symbols
            assert (  "0.3 ± 0.2"  *  Measure(value=0.4,error=0.2,unit=Unit("cm"))  ).units.magnitude == Unit("cm").magnitude
            assert (  "0.3 ± 0.2"  *  Measure(value=0.4,error=0.2,unit=Unit("cm"))  ) == Measure(units=Unit("cm"), value= 0.3*0.4, error=error)
            # Value 3: Decimal
            assert isinstance( (  "40 ± 20"  *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm"))  ), Measure )
            error = measure._sqrt_( (Decimal("40")**2 * Decimal("20")**2 + Decimal("30")**2 * Decimal("20")**2) )
            assert (  "40 ± 20"  *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm"))  ).value   == Decimal("1200")
            assert (  "40 ± 20"  *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm"))  ).error   == error
            assert (  "40 ± 20"  *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm"))  ).implied == False
            assert (  "40 ± 20"  *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm"))  ).units.symbols   == Unit("cm").symbols
            assert (  "40 ± 20"  *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm"))  ).units.magnitude == Unit("cm").magnitude
            assert (  "40 ± 20"  *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm"))  ) == Measure(units=Unit("cm"), value= Decimal("1200"), error=error)
            # Value 4: Negative
            assert isinstance( (  "-3 ± 2"  *  Measure(value=-4,error=2,unit=Unit("cm"))  ), Measure )
            error = measure._sqrt_( (Decimal("4")**2 * Decimal("2")**2 + Decimal("3")**2 * Decimal("2")**2) )
            assert (  "-3 ± 2"  *  Measure(value=-4,error=2,unit=Unit("cm"))  ).value   == 12
            assert (  "-3 ± 2"  *  Measure(value=-4,error=2,unit=Unit("cm"))  ).error   == error
            assert (  "-3 ± 2"  *  Measure(value=-4,error=2,unit=Unit("cm"))  ).implied == False
            assert (  "-3 ± 2"  *  Measure(value=-4,error=2,unit=Unit("cm"))  ).units.symbols   == Unit("cm").symbols
            assert (  "-3 ± 2"  *  Measure(value=-4,error=2,unit=Unit("cm"))  ).units.magnitude == Unit("cm").magnitude
            assert (  "-3 ± 2"  *  Measure(value=-4,error=2,unit=Unit("cm"))  ) == Measure(units=Unit("cm"), value= 12, error=error)
          # Magnitude Units
          if(True):
            # Value 1: Int
            assert isinstance( (  "5 ± 1"  *  Measure(value=2,error=1,unit=Unit("5 m^2"))  ) , Measure )
            error = measure._sqrt_( (Decimal(5)**2 * Decimal(5)**2 + Decimal(10)**2 * Decimal(1)**2) )/Decimal(5)
            assert (  "5 ± 1"  *  Measure(value=2,error=1,unit=Unit("5 m^2"))  ) == Measure(units=Unit("5 m^2"), value=10, error=error)
            assert (  "5 ± 1"  *  Measure(value=2,error=1,unit=Unit("5 m^2"))  ).value   == 10
            assert (  "5 ± 1"  *  Measure(value=2,error=1,unit=Unit("5 m^2"))  ).error   == error
            assert (  "5 ± 1"  *  Measure(value=2,error=1,unit=Unit("5 m^2"))  ).implied == False
            assert (  "5 ± 1"  *  Measure(value=2,error=1,unit=Unit("5 m^2"))  ).units.symbols   == Unit("5 m^2").symbols
            assert (  "5 ± 1"  *  Measure(value=2,error=1,unit=Unit("5 m^2"))  ).units.magnitude == Unit("5 m^2").magnitude
            # Value 2: Float
            assert isinstance( (  "0.5 ± 0.1"  *  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  ) , Measure )
            error = measure._sqrt_( (0.5**2 * 0.5**2 + 1.0**2 * 0.1**2) )/5
            assert (  "0.5 ± 0.1"  *  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  ) == Measure(units=Unit("5 m^2"), value=0.1, error=error)
            assert math.isclose( (  "0.5 ± 0.1"  *  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  ).value , 0.1   )
            assert math.isclose( (  "0.5 ± 0.1"  *  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  ).error , error )
            assert (  "0.5 ± 0.1"  *  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  ).implied == False
            assert (  "0.5 ± 0.1"  *  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  ).units.symbols   == Unit("5 m^2").symbols
            assert (  "0.5 ± 0.1"  *  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  ).units.magnitude == Unit("5 m^2").magnitude
            # Value 3: Decimal
            assert isinstance( (  "50 ± 2"  *  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  ) , Measure )
            error = measure._sqrt_( (Decimal("50")**2 * Decimal("25")**2 + Decimal("100")**2 * Decimal("2")**2) )/Decimal("5")
            assert (  "50 ± 2"  *  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  ) == Measure(units=Unit("5 m^2"), value=Decimal("1000"), error=error)
            assert (  "50 ± 2"  *  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  ).value   == Decimal("1000")
            assert (  "50 ± 2"  *  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  ).error   == error
            assert (  "50 ± 2"  *  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  ).implied == False
            assert (  "50 ± 2"  *  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  ).units.symbols   == Unit("5 m^2").symbols
            assert (  "50 ± 2"  *  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  ).units.magnitude == Unit("5 m^2").magnitude
            # Value 4: Negative
            assert isinstance( (  "-5 ± 1"  *  Measure(value=-2,error=1,unit=Unit("5 m^2"))  ) , Measure )
            error = measure._sqrt_( (Decimal(5)**2 * Decimal(5)**2 + Decimal(10)**2 * Decimal(1)**2) )/Decimal(5)
            assert (  "-5 ± 1"  *  Measure(value=-2,error=1,unit=Unit("5 m^2"))  ) == Measure(units=Unit("5 m^2"), value=10, error=error)
            assert (  "-5 ± 1"  *  Measure(value=-2,error=1,unit=Unit("5 m^2"))  ).value   == 10
            assert (  "-5 ± 1"  *  Measure(value=-2,error=1,unit=Unit("5 m^2"))  ).error   == error
            assert (  "-5 ± 1"  *  Measure(value=-2,error=1,unit=Unit("5 m^2"))  ).implied == False
            assert (  "-5 ± 1"  *  Measure(value=-2,error=1,unit=Unit("5 m^2"))  ).units.symbols   == Unit("5 m^2").symbols
            assert (  "-5 ± 1"  *  Measure(value=-2,error=1,unit=Unit("5 m^2"))  ).units.magnitude == Unit("5 m^2").magnitude
          # Convoluted Units
          if(True):
            # Value 1: Int
            assert isinstance( ( "300 ± 2"  *  Measure(value=27,error=1,unit=Unit("\u00B0C")) ), Measure )
            error = measure._sqrt_( (Decimal("300")**2 * Decimal("1")**2 + Decimal("300.15")**2 * Decimal("2")**2) )
            assert ( "300 ± 2"  *  Measure(value=27,error=1,unit=Unit("\u00B0C")) ).value   == Decimal("300.15")*Decimal("300") - Decimal("273.15")
            assert ( "300 ± 2"  *  Measure(value=27,error=1,unit=Unit("\u00B0C")) ).error   == error
            assert ( "300 ± 2"  *  Measure(value=27,error=1,unit=Unit("\u00B0C")) ).implied == False
            assert ( "300 ± 2"  *  Measure(value=27,error=1,unit=Unit("\u00B0C")) ).units.symbols   == Unit("\u00B0C").symbols
            assert ( "300 ± 2"  *  Measure(value=27,error=1,unit=Unit("\u00B0C")) ).units.magnitude == Unit("\u00B0C").magnitude
            assert ( "300 ± 2"  *  Measure(value=27,error=1,unit=Unit("\u00B0C")) ) == Measure(units=Unit("\u00B0C"), value= Decimal("300.15")*Decimal("300") - Decimal("273.15"), error=error)
            # Value 2: Float
            assert isinstance( ( "299.9 ± 0.02"  *  Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ), Measure )
            error = measure._sqrt_( (299.9**2 * 0.02**2 + 300**2 * 0.02**2) )
            assert math.isclose( ( "299.9 ± 0.02"  *  Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).value   , 299.9 * 300 - 273.15 )
            assert math.isclose( ( "299.9 ± 0.02"  *  Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).error   , error )
            assert ( "299.9 ± 0.02"  *  Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).implied == False 
            assert ( "299.9 ± 0.02"  *  Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).units.symbols   == Unit("\u00B0C").symbols
            assert ( "299.9 ± 0.02"  *  Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).units.magnitude == Unit("\u00B0C").magnitude
            assert ( "299.9 ± 0.02"  *  Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ) == Measure(units=Unit("\u00B0C"), value=299.9 * 300 - 273.15, error=error)
            # Value 3: Decimal
            assert isinstance( ( "300 ± 0.02"  *  Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ), Measure )
            error = measure._sqrt_( (Decimal("300")**2 * Decimal("0.02")**2 + Decimal("300")**2 * Decimal("0.02")**2) )
            assert ( "300 ± 0.02"  *  Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).value   == Decimal("300") * Decimal("300") - Decimal("273.15") 
            assert ( "300 ± 0.02"  *  Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).error   == error
            assert ( "300 ± 0.02"  *  Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).implied == False
            assert ( "300 ± 0.02"  *  Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).units.symbols   == Unit("\u00B0C").symbols
            assert ( "300 ± 0.02"  *  Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).units.magnitude == Unit("\u00B0C").magnitude
            assert ( "300 ± 0.02"  *  Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ) == Measure(units=Unit("\u00B0C"), value=Decimal("300") * Decimal("300") - Decimal("273.15"), error=error)
            # Value 4: Negative
            assert isinstance( ( "300 ± 2"  *  Measure(value=-27,error=1,unit=Unit("\u00B0C")) ), Measure )
            error = measure._sqrt_( (Decimal("300")**2 * Decimal("1")**2 + Decimal("246.15")**2 * Decimal("2")**2) )
            assert ( "300 ± 2"  *  Measure(value=-27,error=1,unit=Unit("\u00B0C")) ).value   == Decimal("246.15")*Decimal("300") - Decimal("273.15")
            assert ( "300 ± 2"  *  Measure(value=-27,error=1,unit=Unit("\u00B0C")) ).error   == error
            assert ( "300 ± 2"  *  Measure(value=-27,error=1,unit=Unit("\u00B0C")) ).implied == False
            assert ( "300 ± 2"  *  Measure(value=-27,error=1,unit=Unit("\u00B0C")) ).units.symbols   == Unit("\u00B0C").symbols
            assert ( "300 ± 2"  *  Measure(value=-27,error=1,unit=Unit("\u00B0C")) ).units.magnitude == Unit("\u00B0C").magnitude
            assert ( "300 ± 2"  *  Measure(value=-27,error=1,unit=Unit("\u00B0C")) ) == Measure(units=Unit("\u00B0C"), value= Decimal("246.15")*Decimal("300") - Decimal("273.15"), error=error)
          # Preserve Inputs
          if(True):
            a = "3 ± 2" 
            b = Measure(value=4,error=2,unit=Unit("cm"))
            c = a*b
            c = None
            assert a == "3 ± 2" 
            assert b == Measure(value=4,error=2,unit=Unit("cm"))
        # Unit * Unitless
        if(True):
          # Normal Units
          if(True):
            # Value 1: Int
            assert isinstance( ( "4 ± 2 cm"   *  Measure(value=3,error=2)  ), Measure )
            error = measure._sqrt_( (Decimal("4")**2 * Decimal("2")**2 + Decimal("3")**2 * Decimal("2")**2) )
            assert (  "4 ± 2 cm"   *  Measure(value=3,error=2)  ).value   == 12
            assert (  "4 ± 2 cm"   *  Measure(value=3,error=2)  ).error   == error
            assert (  "4 ± 2 cm"   *  Measure(value=3,error=2)  ).implied == False
            assert (  "4 ± 2 cm"   *  Measure(value=3,error=2)  ).units.symbols   == Unit("cm").symbols
            assert (  "4 ± 2 cm"   *  Measure(value=3,error=2)  ).units.magnitude == Unit("cm").magnitude
            assert (  "4 ± 2 cm"   *  Measure(value=3,error=2)  ) == Measure(units=Unit("cm"), value= 12, error=error)
            # Value 2: Float
            assert isinstance( ( "0.4 ± 0.2 cm"   *  Measure(value=0.3,error=0.2)  ), Measure )
            error = measure._sqrt_( (0.4**2 * 0.2**2 + 0.3**2 * 0.2**2) )
            assert math.isclose( (  "0.4 ± 0.2 cm"   *  Measure(value=0.3,error=0.2)  ).value , 0.3*0.4 )
            assert math.isclose( (  "0.4 ± 0.2 cm"   *  Measure(value=0.3,error=0.2)  ).error , error   )
            assert (  "0.4 ± 0.2 cm"   *  Measure(value=0.3,error=0.2)  ).implied == False
            assert (  "0.4 ± 0.2 cm"   *  Measure(value=0.3,error=0.2)  ).units.symbols   == Unit("cm").symbols
            assert (  "0.4 ± 0.2 cm"   *  Measure(value=0.3,error=0.2)  ).units.magnitude == Unit("cm").magnitude
            assert (  "0.4 ± 0.2 cm"   *  Measure(value=0.3,error=0.2)  ) == Measure(units=Unit("cm"), value= 0.3*0.4, error=error)
            # Value 3: Decimal
            assert isinstance( (  "40 ± 20 cm"   *  Measure(value=Decimal("30"),error=Decimal("20"))  ), Measure )
            error = measure._sqrt_( (Decimal("40")**2 * Decimal("20")**2 + Decimal("30")**2 * Decimal("20")**2) )
            assert (  "40 ± 20 cm"   *  Measure(value=Decimal("30"),error=Decimal("20"))  ).value   == Decimal("1200")
            assert (  "40 ± 20 cm"   *  Measure(value=Decimal("30"),error=Decimal("20"))  ).error   == error
            assert (  "40 ± 20 cm"   *  Measure(value=Decimal("30"),error=Decimal("20"))  ).implied == False
            assert (  "40 ± 20 cm"   *  Measure(value=Decimal("30"),error=Decimal("20"))  ).units.symbols   == Unit("cm").symbols
            assert (  "40 ± 20 cm"   *  Measure(value=Decimal("30"),error=Decimal("20"))  ).units.magnitude == Unit("cm").magnitude
            assert (  "40 ± 20 cm"   *  Measure(value=Decimal("30"),error=Decimal("20"))  ) == Measure(units=Unit("cm"), value= Decimal("1200"), error=error)
            # Value 4: Negative
            assert isinstance( ( "-4 ± 2 cm"   *  Measure(value=-3,error=2)  ), Measure )
            error = measure._sqrt_( (Decimal("4")**2 * Decimal("2")**2 + Decimal("3")**2 * Decimal("2")**2) )
            assert (  "-4 ± 2 cm"   *  Measure(value=-3,error=2)  ).value   == 12
            assert (  "-4 ± 2 cm"   *  Measure(value=-3,error=2)  ).error   == error
            assert (  "-4 ± 2 cm"   *  Measure(value=-3,error=2)  ).implied == False
            assert (  "-4 ± 2 cm"   *  Measure(value=-3,error=2)  ).units.symbols   == Unit("cm").symbols
            assert (  "-4 ± 2 cm"   *  Measure(value=-3,error=2)  ).units.magnitude == Unit("cm").magnitude
            assert (  "-4 ± 2 cm"   *  Measure(value=-3,error=2)  ) == Measure(units=Unit("cm"), value= 12, error=error)
          # Magnitude Units
          if(True):
            # Value 1: Int
            assert isinstance( (  "2 ± 1 * 5 m^2"   *  Measure(value=5,error=1)  ) , Measure )
            error = measure._sqrt_( (Decimal(5)**2 * Decimal(5)**2 + Decimal(10)**2 * Decimal(1)**2) )/Decimal(5)
            assert (  "2 ± 1 * 5 m^2"   *  Measure(value=5,error=1)  ) == Measure(units=Unit("5 m^2"), value=10, error=error)
            assert (  "2 ± 1 * 5 m^2"   *  Measure(value=5,error=1)  ).value   == 10
            assert (  "2 ± 1 * 5 m^2"   *  Measure(value=5,error=1)  ).error   == error
            assert (  "2 ± 1 * 5 m^2"   *  Measure(value=5,error=1)  ).implied == False
            assert (  "2 ± 1 * 5 m^2"   *  Measure(value=5,error=1)  ).units.symbols   == Unit("5 m^2").symbols
            assert (  "2 ± 1 * 5 m^2"   *  Measure(value=5,error=1)  ).units.magnitude == Unit("5 m^2").magnitude
            # Value 2: Float
            assert isinstance( (  "0.2 ± 0.1 * 5 m^2"   *  Measure(value=0.5,error=0.1)  ) , Measure )
            error = measure._sqrt_( (0.5**2 * 0.5**2 + 1.0**2 * 0.1**2) )/5
            assert (  "0.2 ± 0.1 * 5 m^2"   *  Measure(value=0.5,error=0.1)  ) == Measure(units=Unit("5 m^2"), value=0.1, error=error)
            assert math.isclose( (  "0.2 ± 0.1 * 5 m^2"   *  Measure(value=0.5,error=0.1)  ).value , 0.1   )
            assert math.isclose( (  "0.2 ± 0.1 * 5 m^2"   *  Measure(value=0.5,error=0.1)  ).error , error )
            assert (  "0.2 ± 0.1 * 5 m^2"   *  Measure(value=0.5,error=0.1)  ).implied == False
            assert (  "0.2 ± 0.1 * 5 m^2"   *  Measure(value=0.5,error=0.1)  ).units.symbols   == Unit("5 m^2").symbols
            assert (  "0.2 ± 0.1 * 5 m^2"   *  Measure(value=0.5,error=0.1)  ).units.magnitude == Unit("5 m^2").magnitude
            # Value 3: Decimal
            assert isinstance( (  "20 ± 5 * 5 m^2"   *  Measure(value=Decimal("50"),error=Decimal("2"))  ) , Measure )
            error = measure._sqrt_( (Decimal("50")**2 * Decimal("25")**2 + Decimal("100")**2 * Decimal("2")**2) )/Decimal("5")
            assert (  "20 ± 5 * 5 m^2"   *  Measure(value=Decimal("50"),error=Decimal("2"))  ) == Measure(units=Unit("5 m^2"), value=Decimal("1000"), error=error)
            assert (  "20 ± 5 * 5 m^2"   *  Measure(value=Decimal("50"),error=Decimal("2"))  ).value   == Decimal("1000")
            assert (  "20 ± 5 * 5 m^2"   *  Measure(value=Decimal("50"),error=Decimal("2"))  ).error   == error
            assert (  "20 ± 5 * 5 m^2"   *  Measure(value=Decimal("50"),error=Decimal("2"))  ).implied == False
            assert (  "20 ± 5 * 5 m^2"   *  Measure(value=Decimal("50"),error=Decimal("2"))  ).units.symbols   == Unit("5 m^2").symbols
            assert (  "20 ± 5 * 5 m^2"   *  Measure(value=Decimal("50"),error=Decimal("2"))  ).units.magnitude == Unit("5 m^2").magnitude
            # Value 4: Negative
            assert isinstance( (  "-2 ± 1 * 5 m^2"   *  Measure(value=-5,error=1)  ) , Measure )
            error = measure._sqrt_( (Decimal(5)**2 * Decimal(5)**2 + Decimal(10)**2 * Decimal(1)**2) )/Decimal(5)
            assert (  "-2 ± 1 * 5 m^2"   *  Measure(value=-5,error=1)  ) == Measure(units=Unit("5 m^2"), value=10, error=error)
            assert (  "-2 ± 1 * 5 m^2"   *  Measure(value=-5,error=1)  ).value   == 10
            assert (  "-2 ± 1 * 5 m^2"   *  Measure(value=-5,error=1)  ).error   == error
            assert (  "-2 ± 1 * 5 m^2"   *  Measure(value=-5,error=1)  ).implied == False
            assert (  "-2 ± 1 * 5 m^2"   *  Measure(value=-5,error=1)  ).units.symbols   == Unit("5 m^2").symbols
            assert (  "-2 ± 1 * 5 m^2"   *  Measure(value=-5,error=1)  ).units.magnitude == Unit("5 m^2").magnitude
          # Convoluted Units
          if(True):
            # Value 1: Int
            assert isinstance( ( "27 ± 1 \u00B0C"   *  Measure(value=300,error=2) ), Measure )
            error = measure._sqrt_( (Decimal("300")**2 * Decimal("1")**2 + Decimal("300.15")**2 * Decimal("2")**2) )
            assert ( "27 ± 1 \u00B0C"   *  Measure(value=300,error=2) ).value   == Decimal("300.15")*Decimal("300") - Decimal("273.15")
            assert ( "27 ± 1 \u00B0C"   *  Measure(value=300,error=2) ).error   == error
            assert ( "27 ± 1 \u00B0C"   *  Measure(value=300,error=2) ).implied == False
            assert ( "27 ± 1 \u00B0C"   *  Measure(value=300,error=2) ).units.symbols   == Unit("\u00B0C").symbols
            assert ( "27 ± 1 \u00B0C"   *  Measure(value=300,error=2) ).units.magnitude == Unit("\u00B0C").magnitude
            assert ( "27 ± 1 \u00B0C"   *  Measure(value=300,error=2) ) == Measure(units=Unit("\u00B0C"), value= Decimal("300.15")*Decimal("300") - Decimal("273.15"), error=error)
            # Value 2: Float
            assert isinstance( ( "26.85 ± 0.02 \u00B0C"   *  Measure(value=299.9,error=0.02) ), Measure )
            error = measure._sqrt_( (299.9**2 * 0.02**2 + 300**2 * 0.02**2) )
            assert math.isclose( ( "26.85 ± 0.02 \u00B0C"   *  Measure(value=299.9,error=0.02) ).value , 299.9 * 300 - 273.15 )
            assert math.isclose( ( "26.85 ± 0.02 \u00B0C"   *  Measure(value=299.9,error=0.02) ).error , error )
            assert ( "26.85 ± 0.02 \u00B0C"   *  Measure(value=299.9,error=0.02) ).implied == False
            assert ( "26.85 ± 0.02 \u00B0C"   *  Measure(value=299.9,error=0.02) ).units.symbols   == Unit("\u00B0C").symbols
            assert ( "26.85 ± 0.02 \u00B0C"   *  Measure(value=299.9,error=0.02) ).units.magnitude == Unit("\u00B0C").magnitude
            assert ( "26.85 ± 0.02 \u00B0C"   *  Measure(value=299.9,error=0.02) ) == Measure(units=Unit("\u00B0C"), value=299.9 * 300 - 273.15, error=error)
            # Value 3: Decimal
            assert isinstance( ( "26.85 ± 0.02 \u00B0C"   *  Measure(value=Decimal("300"),error=Decimal("0.02")) ), Measure )
            error = measure._sqrt_( (Decimal("300")**2 * Decimal("0.02")**2 + Decimal("300")**2 * Decimal("0.02")**2) )
            assert ( "26.85 ± 0.02 \u00B0C"   *  Measure(value=Decimal("300"),error=Decimal("0.02")) ).value   == Decimal("300") * Decimal("300") - Decimal("273.15") 
            assert ( "26.85 ± 0.02 \u00B0C"   *  Measure(value=Decimal("300"),error=Decimal("0.02")) ).error   == error
            assert ( "26.85 ± 0.02 \u00B0C"   *  Measure(value=Decimal("300"),error=Decimal("0.02")) ).implied == False
            assert ( "26.85 ± 0.02 \u00B0C"   *  Measure(value=Decimal("300"),error=Decimal("0.02")) ).units.symbols   == Unit("\u00B0C").symbols
            assert ( "26.85 ± 0.02 \u00B0C"   *  Measure(value=Decimal("300"),error=Decimal("0.02")) ).units.magnitude == Unit("\u00B0C").magnitude
            assert ( "26.85 ± 0.02 \u00B0C"   *  Measure(value=Decimal("300"),error=Decimal("0.02")) ) == Measure(units=Unit("\u00B0C"), value=Decimal("300") * Decimal("300") - Decimal("273.15"), error=error)
            # Value 4: Negative
            assert isinstance( ( "-27 ± 1 \u00B0C"   *  Measure(value=300,error=2) ), Measure )
            error = measure._sqrt_( (Decimal("300")**2 * Decimal("1")**2 + Decimal("246.15")**2 * Decimal("2")**2) )
            assert ( "-27 ± 1 \u00B0C"   *  Measure(value=300,error=2) ).value   == Decimal("246.15")*Decimal("300") - Decimal("273.15")
            assert ( "-27 ± 1 \u00B0C"   *  Measure(value=300,error=2) ).error   == error
            assert ( "-27 ± 1 \u00B0C"   *  Measure(value=300,error=2) ).implied == False
            assert ( "-27 ± 1 \u00B0C"   *  Measure(value=300,error=2) ).units.symbols   == Unit("\u00B0C").symbols
            assert ( "-27 ± 1 \u00B0C"   *  Measure(value=300,error=2) ).units.magnitude == Unit("\u00B0C").magnitude
            assert ( "-27 ± 1 \u00B0C"   *  Measure(value=300,error=2) ) == Measure(units=Unit("\u00B0C"), value= Decimal("246.15")*Decimal("300") - Decimal("273.15"), error=error)
          # Preserve Inputs
          if(True):
            a = "4 ± 2 cm" 
            b = Measure(value=3,error=2)
            c = a*b
            c = None
            assert a == "4 ± 2 cm"  
            assert b == Measure(value=3,error=2)
        # Units * Units
        if(True):
          # Normal Units
          if(True):
            # Value 1: Int
            assert isinstance( ( "4 ± 2 cm"   *  Measure(value=3,error=2,unit=Unit("cm"))  ), Measure )
            error = measure._sqrt_( (Decimal("4")**2 * Decimal("2")**2 + Decimal("3")**2 * Decimal("2")**2) )
            assert (  "4 ± 2 cm"   *  Measure(value=3,error=2,unit=Unit("cm"))  ).value   == 12
            assert (  "4 ± 2 cm"   *  Measure(value=3,error=2,unit=Unit("cm"))  ).error   == error
            assert (  "4 ± 2 cm"   *  Measure(value=3,error=2,unit=Unit("cm"))  ).implied == False
            assert (  "4 ± 2 cm"   *  Measure(value=3,error=2,unit=Unit("cm"))  ).units.symbols   == Unit("cm^2").symbols
            assert (  "4 ± 2 cm"   *  Measure(value=3,error=2,unit=Unit("cm"))  ).units.magnitude == Unit("cm^2").magnitude
            assert (  "4 ± 2 cm"   *  Measure(value=3,error=2,unit=Unit("cm"))  ) == Measure(units=Unit("cm^2"), value= 12, error=error)
            # Value 2: Float
            assert isinstance( ( "0.4 ± 0.2 cm"   *  Measure(value=0.3,error=0.2,unit=Unit("cm"))  ), Measure )
            error = measure._sqrt_( (0.4**2 * 0.2**2 + 0.3**2 * 0.2**2) )
            assert math.isclose( (  "0.4 ± 0.2 cm"   *  Measure(value=0.3,error=0.2,unit=Unit("cm"))  ).value , 0.3*0.4 )
            assert math.isclose( (  "0.4 ± 0.2 cm"   *  Measure(value=0.3,error=0.2,unit=Unit("cm"))  ).error , error   )
            assert (  "0.4 ± 0.2 cm"   *  Measure(value=0.3,error=0.2,unit=Unit("cm"))  ).implied == False
            assert (  "0.4 ± 0.2 cm"   *  Measure(value=0.3,error=0.2,unit=Unit("cm"))  ).units.symbols   == Unit("cm^2").symbols
            assert (  "0.4 ± 0.2 cm"   *  Measure(value=0.3,error=0.2,unit=Unit("cm"))  ).units.magnitude == Unit("cm^2").magnitude
            assert (  "0.4 ± 0.2 cm"   *  Measure(value=0.3,error=0.2,unit=Unit("cm"))  ) == Measure(units=Unit("cm^2"), value= 0.3*0.4, error=error)
            # Value 3: Decimal
            assert isinstance( (  "40 ± 20 cm"   *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm"))  ), Measure )
            error = measure._sqrt_( (Decimal("40")**2 * Decimal("20")**2 + Decimal("30")**2 * Decimal("20")**2) )
            assert (  "40 ± 20 cm"   *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm"))  ).value   == Decimal("1200")
            assert (  "40 ± 20 cm"   *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm"))  ).error   == error
            assert (  "40 ± 20 cm"   *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm"))  ).implied == False
            assert (  "40 ± 20 cm"   *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm"))  ).units.symbols   == Unit("cm^2").symbols
            assert (  "40 ± 20 cm"   *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm"))  ).units.magnitude == Unit("cm^2").magnitude
            assert (  "40 ± 20 cm"   *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm"))  ) == Measure(units=Unit("cm^2"), value= Decimal("1200"), error=error)
            # Value 4: Negative
            assert isinstance( ( "-4 ± 2 cm"   *  Measure(value=-3,error=2,unit=Unit("cm"))  ), Measure )
            error = measure._sqrt_( (Decimal("4")**2 * Decimal("2")**2 + Decimal("3")**2 * Decimal("2")**2) )
            assert (  "-4 ± 2 cm"   *  Measure(value=-3,error=2,unit=Unit("cm"))  ).value   == 12
            assert (  "-4 ± 2 cm"   *  Measure(value=-3,error=2,unit=Unit("cm"))  ).error   == error
            assert (  "-4 ± 2 cm"   *  Measure(value=-3,error=2,unit=Unit("cm"))  ).implied == False
            assert (  "-4 ± 2 cm"   *  Measure(value=-3,error=2,unit=Unit("cm"))  ).units.symbols   == Unit("cm^2").symbols
            assert (  "-4 ± 2 cm"   *  Measure(value=-3,error=2,unit=Unit("cm"))  ).units.magnitude == Unit("cm^2").magnitude
            assert (  "-4 ± 2 cm"   *  Measure(value=-3,error=2,unit=Unit("cm"))  ) == Measure(units=Unit("cm^2"), value= 12, error=error)
          # Magnitude Units
          if(True):
            # Value 1: Int
            assert isinstance( (  "2 ± 1 * 5 m^2"   *  Measure(value=5,error=1,unit=Unit("5 m^2"))  ) , Measure )
            error = measure._sqrt_( (Decimal(25)**2 * Decimal(5)**2 + Decimal(10)**2 * Decimal(5)**2) )/Decimal(25)
            assert (  "2 ± 1 * 5 m^2"   *  Measure(value=5,error=1,unit=Unit("5 m^2"))  ).value   == 10
            assert (  "2 ± 1 * 5 m^2"   *  Measure(value=5,error=1,unit=Unit("5 m^2"))  ).error   == error
            assert (  "2 ± 1 * 5 m^2"   *  Measure(value=5,error=1,unit=Unit("5 m^2"))  ).implied == False
            assert (  "2 ± 1 * 5 m^2"   *  Measure(value=5,error=1,unit=Unit("5 m^2"))  ).units.symbols   == Unit("25 m^4").symbols
            assert (  "2 ± 1 * 5 m^2"   *  Measure(value=5,error=1,unit=Unit("5 m^2"))  ).units.magnitude == Unit("25 m^4").magnitude
            assert (  "2 ± 1 * 5 m^2"   *  Measure(value=5,error=1,unit=Unit("5 m^2"))  ) == Measure(units=Unit("25 m^4"), value=10, error=error)
            # Value 2: Float
            assert isinstance( (  "0.2 ± 0.1 * 5 m^2"   *  Measure(value=0.5,error=0.1,unit=Unit("5 m^4"))  ) , Measure )
            error = measure._sqrt_( (2.5**2 * 0.5**2 + 1.0**2 * 0.5**2) )/25
            assert math.isclose( (  "0.2 ± 0.1 * 5 m^2"   *  Measure(value=0.5,error=0.1,unit=Unit("5 m^2"))  ).value , 0.1   )
            assert math.isclose( (  "0.2 ± 0.1 * 5 m^2"   *  Measure(value=0.5,error=0.1,unit=Unit("5 m^2"))  ).error , error )
            assert (  "0.2 ± 0.1 * 5 m^2"   *  Measure(value=0.5,error=0.1,unit=Unit("5 m^2"))  ).implied == False
            assert (  "0.2 ± 0.1 * 5 m^2"   *  Measure(value=0.5,error=0.1,unit=Unit("5 m^2"))  ).units.symbols   == Unit("25 m^4").symbols
            assert (  "0.2 ± 0.1 * 5 m^2"   *  Measure(value=0.5,error=0.1,unit=Unit("5 m^2"))  ).units.magnitude == Unit("25 m^4").magnitude
            assert (  "0.2 ± 0.1 * 5 m^2"   *  Measure(value=0.5,error=0.1,unit=Unit("5 m^2"))  ) == Measure(units=Unit("25 m^4"), value=0.1, error=error)
            # Value 3: Decimal
            assert isinstance( (  "20 ± 5 * 5 m^2"   *  Measure(value=Decimal("50"),error=Decimal("2"),unit=Unit("5 m^2"))  ) , Measure )
            error = measure._sqrt_( (Decimal("250")**2 * Decimal("25")**2 + Decimal("100")**2 * Decimal("10")**2) )/Decimal("25")
            assert (  "20 ± 5 * 5 m^2"   *  Measure(value=Decimal("50"),error=Decimal("2"),unit=Unit("5 m^2"))  ) == Measure(units=Unit("25 m^4"), value=Decimal("1000"), error=error)
            assert (  "20 ± 5 * 5 m^2"   *  Measure(value=Decimal("50"),error=Decimal("2"),unit=Unit("5 m^2"))  ).value   == Decimal("1000")
            assert (  "20 ± 5 * 5 m^2"   *  Measure(value=Decimal("50"),error=Decimal("2"),unit=Unit("5 m^2"))  ).error   == error
            assert (  "20 ± 5 * 5 m^2"   *  Measure(value=Decimal("50"),error=Decimal("2"),unit=Unit("5 m^2"))  ).implied == False
            assert (  "20 ± 5 * 5 m^2"   *  Measure(value=Decimal("50"),error=Decimal("2"),unit=Unit("5 m^2"))  ).units.symbols   == Unit("25 m^4").symbols
            assert (  "20 ± 5 * 5 m^2"   *  Measure(value=Decimal("50"),error=Decimal("2"),unit=Unit("5 m^2"))  ).units.magnitude == Unit("25 m^4").magnitude
            # Value 4: Negative
            assert isinstance( (  "-2 ± 1 * 5 m^2"   *  Measure(value=-5,error=1,unit=Unit("5 m^2"))  ) , Measure )
            error = measure._sqrt_( (Decimal(25)**2 * Decimal(5)**2 + Decimal(10)**2 * Decimal(5)**2) )/Decimal(25)
            assert (  "-2 ± 1 * 5 m^2"   *  Measure(value=-5,error=1,unit=Unit("5 m^2"))  ) == Measure(units=Unit("25 m^4"), value=10, error=error)
            assert (  "-2 ± 1 * 5 m^2"   *  Measure(value=-5,error=1,unit=Unit("5 m^2"))  ).value   == 10
            assert (  "-2 ± 1 * 5 m^2"   *  Measure(value=-5,error=1,unit=Unit("5 m^2"))  ).error   == error
            assert (  "-2 ± 1 * 5 m^2"   *  Measure(value=-5,error=1,unit=Unit("5 m^2"))  ).implied == False
            assert (  "-2 ± 1 * 5 m^2"   *  Measure(value=-5,error=1,unit=Unit("5 m^2"))  ).units.symbols   == Unit("25 m^4").symbols
            assert (  "-2 ± 1 * 5 m^2"   *  Measure(value=-5,error=1,unit=Unit("5 m^2"))  ).units.magnitude == Unit("25 m^4").magnitude
          # Convoluted Units
          if(True):
            # Value 1: Int
            assert isinstance( ( "27 ± 1 \u00B0C"   *  Measure(value=27,error=2,unit=Unit("\u00B0C")) ), Measure )
            error = measure._sqrt_( (Decimal("300.15")**2 * Decimal("1")**2 + Decimal("300.15")**2 * Decimal("2")**2) )
            assert ( "27 ± 1 \u00B0C"   *  Measure(value=27,error=2,unit=Unit("\u00B0C")) ).value   == Decimal("300.15")*Decimal("300.15")
            assert ( "27 ± 1 \u00B0C"   *  Measure(value=27,error=2,unit=Unit("\u00B0C")) ).error   == error
            assert ( "27 ± 1 \u00B0C"   *  Measure(value=27,error=2,unit=Unit("\u00B0C")) ).implied == False
            assert ( "27 ± 1 \u00B0C"   *  Measure(value=27,error=2,unit=Unit("\u00B0C")) ).units.symbols   == Unit("K^2").symbols
            assert ( "27 ± 1 \u00B0C"   *  Measure(value=27,error=2,unit=Unit("\u00B0C")) ).units.magnitude == Unit("K^2").magnitude
            assert ( "27 ± 1 \u00B0C"   *  Measure(value=27,error=2,unit=Unit("\u00B0C")) ) == Measure(units=Unit("K^2"), value= Decimal("300.15")*Decimal("300.15"), error=error)
            # Value 2: Float
            assert isinstance( ( "26.85 ± 0.02 \u00B0C"  *  Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ), Measure )
            error = measure._sqrt_( (300**2 * 0.02**2 + 300**2 * 0.02**2) )
            assert math.isclose( ( "26.85 ± 0.02 \u00B0C"  *  Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).value   , 300 * 300 )
            assert math.isclose( ( "26.85 ± 0.02 \u00B0C"  *  Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).error   , error )
            assert ( "26.85 ± 0.02 \u00B0C"  *  Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).implied == False 
            assert ( "26.85 ± 0.02 \u00B0C"  *  Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).units.symbols   == Unit("K^2").symbols
            assert ( "26.85 ± 0.02 \u00B0C"  *  Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).units.magnitude == Unit("K^2").magnitude
            assert ( "26.85 ± 0.02 \u00B0C"  *  Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ) == Measure(units=Unit("K^2"), value=300 * 300, error=error)
            # Value 3: Decimal
            assert isinstance( ( "26.85 ± 0.02 \u00B0C" *  Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ), Measure )
            error = measure._sqrt_( (Decimal("300")**2 * Decimal("0.02")**2 + Decimal("300")**2 * Decimal("0.02")**2) )
            assert ( "26.85 ± 0.02 \u00B0C" *  Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).value   == Decimal("300") * Decimal("300") 
            assert ( "26.85 ± 0.02 \u00B0C" *  Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).error   == error
            assert ( "26.85 ± 0.02 \u00B0C" *  Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).implied == False
            assert ( "26.85 ± 0.02 \u00B0C" *  Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).units.symbols   == Unit("K^2").symbols
            assert ( "26.85 ± 0.02 \u00B0C" *  Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).units.magnitude == Unit("K^2").magnitude
            assert ( "26.85 ± 0.02 \u00B0C" *  Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ) == Measure(units=Unit("K^2"), value=Decimal("300") * Decimal("300"), error=error)
            # Value 4: Negative
            assert isinstance( ( "-27 ± 1 \u00B0C"   *  Measure(value=-27,error=2,unit=Unit("\u00B0C")) ), Measure )
            error = measure._sqrt_( (Decimal("246.15")**2 * Decimal("1")**2 + Decimal("246.15")**2 * Decimal("2")**2) )
            assert ( "-27 ± 1 \u00B0C"   *  Measure(value=-27,error=2,unit=Unit("\u00B0C")) ).value   == Decimal("246.15")*Decimal("246.15")
            assert ( "-27 ± 1 \u00B0C"   *  Measure(value=-27,error=2,unit=Unit("\u00B0C")) ).error   == error
            assert ( "-27 ± 1 \u00B0C"   *  Measure(value=-27,error=2,unit=Unit("\u00B0C")) ).implied == False
            assert ( "-27 ± 1 \u00B0C"   *  Measure(value=-27,error=2,unit=Unit("\u00B0C")) ).units.symbols   == Unit("K^2").symbols
            assert ( "-27 ± 1 \u00B0C"   *  Measure(value=-27,error=2,unit=Unit("\u00B0C")) ).units.magnitude == Unit("K^2").magnitude
            assert ( "-27 ± 1 \u00B0C"   *  Measure(value=-27,error=2,unit=Unit("\u00B0C")) ) == Measure(units=Unit("K^2"), value= Decimal("246.15")*Decimal("246.15"), error=error)
          # Canceling Units
          if(True):
            # Value 1: Int
            assert isinstance( ( "4 ± 2 cm"   *  Measure(value=3,error=2,unit=Unit("cm^-1"))  ), Measure )
            error = measure._sqrt_( (Decimal("4")**2 * Decimal("2")**2 + Decimal("3")**2 * Decimal("2")**2) )
            assert (  "4 ± 2 cm"   *  Measure(value=3,error=2,unit=Unit("cm^-1"))  ).value   == 12
            assert (  "4 ± 2 cm"   *  Measure(value=3,error=2,unit=Unit("cm^-1"))  ).error   == error
            assert (  "4 ± 2 cm"   *  Measure(value=3,error=2,unit=Unit("cm^-1"))  ).implied == False
            assert (  "4 ± 2 cm"   *  Measure(value=3,error=2,unit=Unit("cm^-1"))  ).units.symbols   == Unit().symbols
            assert (  "4 ± 2 cm"   *  Measure(value=3,error=2,unit=Unit("cm^-1"))  ).units.magnitude == Unit().magnitude
            assert (  "4 ± 2 cm"   *  Measure(value=3,error=2,unit=Unit("cm^-1"))  ) == Measure(units=Unit(), value= 12, error=error)
            # Value 2: Float
            assert isinstance( ( "0.4 ± 0.2 cm"   *  Measure(value=0.3,error=0.2,unit=Unit("cm^-1"))  ), Measure )
            error = measure._sqrt_( (0.4**2 * 0.2**2 + 0.3**2 * 0.2**2) )
            assert math.isclose( (  "0.4 ± 0.2 cm"   *  Measure(value=0.3,error=0.2,unit=Unit("cm^-1"))  ).value , 0.3*0.4 )
            assert math.isclose( (  "0.4 ± 0.2 cm"   *  Measure(value=0.3,error=0.2,unit=Unit("cm^-1"))  ).error , error   )
            assert (  "0.4 ± 0.2 cm"   *  Measure(value=0.3,error=0.2,unit=Unit("cm^-1"))  ).implied == False
            assert (  "0.4 ± 0.2 cm"   *  Measure(value=0.3,error=0.2,unit=Unit("cm^-1"))  ).units.symbols   == Unit().symbols
            assert (  "0.4 ± 0.2 cm"   *  Measure(value=0.3,error=0.2,unit=Unit("cm^-1"))  ).units.magnitude == Unit().magnitude
            assert (  "0.4 ± 0.2 cm"   *  Measure(value=0.3,error=0.2,unit=Unit("cm^-1"))  ) == Measure(units=Unit(), value= 0.3*0.4, error=error)
            # Value 3: Decimal
            assert isinstance( (  "40 ± 20 cm"   *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm^-1"))  ), Measure )
            error = measure._sqrt_( (Decimal("40")**2 * Decimal("20")**2 + Decimal("30")**2 * Decimal("20")**2) )
            assert (  "40 ± 20 cm"   *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm^-1"))  ).value   == Decimal("1200")
            assert (  "40 ± 20 cm"   *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm^-1"))  ).error   == error
            assert (  "40 ± 20 cm"   *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm^-1"))  ).implied == False
            assert (  "40 ± 20 cm"   *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm^-1"))  ).units.symbols   == Unit().symbols
            assert (  "40 ± 20 cm"   *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm^-1"))  ).units.magnitude == Unit().magnitude
            assert (  "40 ± 20 cm"   *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm^-1"))  ) == Measure(units=Unit(), value= Decimal("1200"), error=error)
            # Value 4: Negative
            assert isinstance( ( "-4 ± 2 cm"   *  Measure(value=-3,error=2,unit=Unit("cm^-1"))  ), Measure )
            error = measure._sqrt_( (Decimal("4")**2 * Decimal("2")**2 + Decimal("3")**2 * Decimal("2")**2) )
            assert (  "-4 ± 2 cm"   *  Measure(value=-3,error=2,unit=Unit("cm^-1"))  ).value   == 12
            assert (  "-4 ± 2 cm"   *  Measure(value=-3,error=2,unit=Unit("cm^-1"))  ).error   == error
            assert (  "-4 ± 2 cm"   *  Measure(value=-3,error=2,unit=Unit("cm^-1"))  ).implied == False
            assert (  "-4 ± 2 cm"   *  Measure(value=-3,error=2,unit=Unit("cm^-1"))  ).units.symbols   == Unit().symbols
            assert (  "-4 ± 2 cm"   *  Measure(value=-3,error=2,unit=Unit("cm^-1"))  ).units.magnitude == Unit().magnitude
            assert (  "-4 ± 2 cm"   *  Measure(value=-3,error=2,unit=Unit("cm^-1"))  ) == Measure(units=Unit(), value= 12, error=error)
          # Preserve Inputs
          if(True):
            a = "4 ± 2 cm" 
            b = Measure(value=3,error=2,unit=Unit("cm"))
            c = a*b
            c = None
            assert a == "4 ± 2 cm" 
            assert b == Measure(value=3,error=2,unit=Unit("cm"))
      # Str Measure (Explicit Error) * Measure (Implicit Error) = Measure (Implicit Error)
      if(True):
        # Unitless * Unitless
        if(True):
          # Value 1: Int
          assert isinstance( ( "4 ± 2"   *  Measure(value=3)  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0.5")**2 + Decimal(3)**2 * Decimal(2)**2) )
          assert (  "4 ± 2"   *  Measure(value=3)  ).value   == 12
          assert (  "4 ± 2"   *  Measure(value=3)  ).error   == error
          assert (  "4 ± 2"   *  Measure(value=3)  ).implied == True
          assert (  "4 ± 2"   *  Measure(value=3)  ).units.symbols   == Unit().symbols
          assert (  "4 ± 2"   *  Measure(value=3)  ).units.magnitude == Unit().magnitude
          assert (  "4 ± 2"   *  Measure(value=3)  ) == Measure(units=Unit(), value= 12, error=error)
          # Value 2: Float
          assert isinstance( ( "0.4 ± 0.2"   *  Measure(value=0.3)  ), Measure )
          error = measure._sqrt_( (0.4**2 * 0.05**2 + 0.3**2 * 0.2**2) )
          assert math.isclose( (  "0.4 ± 0.2"   *  Measure(value=0.3)  ).value , 0.4*0.3 )
          assert math.isclose( (  "0.4 ± 0.2"   *  Measure(value=0.3)  ).error , error   )
          assert (  "0.4 ± 0.2"   *  Measure(value=0.3)  ).implied == True
          assert (  "0.4 ± 0.2"   *  Measure(value=0.3)  ).units.symbols   == Unit().symbols
          assert (  "0.4 ± 0.2"   *  Measure(value=0.3)  ).units.magnitude == Unit().magnitude
          assert (  "0.4 ± 0.2"   *  Measure(value=0.3)  ) == Measure(units=Unit(), value= 0.4*0.3, error=error)
          # Value 3: Decimal
          assert isinstance( (  "40 ± 20"   *  Measure(value=Decimal("30"))  ), Measure )
          error = measure._sqrt_( ( Decimal("40")**2 * Decimal("5")**2 + Decimal("30")**2 * Decimal("20")**2) )
          assert (  "40 ± 20"   *  Measure(value=Decimal("30"))  ).value   == Decimal("1200")
          assert (  "40 ± 20"   *  Measure(value=Decimal("30"))  ).error   == error
          assert (  "40 ± 20"   *  Measure(value=Decimal("30"))  ).implied == True
          assert (  "40 ± 20"   *  Measure(value=Decimal("30"))  ).units.symbols   == Unit().symbols
          assert (  "40 ± 20"   *  Measure(value=Decimal("30"))  ).units.magnitude == Unit().magnitude
          assert (  "40 ± 20"   *  Measure(value=Decimal("30"))  ) == Measure(units=Unit(), value= Decimal("1200"), error=error)
          # Value 4: Negative
          assert isinstance( ( "-4 ± 2"   *  Measure(value=-3)  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0.5")**2 + Decimal(3)**2 * Decimal(2)**2) )
          assert (  "-4 ± 2"   *  Measure(value=-3)  ).value   == 12
          assert (  "-4 ± 2"   *  Measure(value=-3)  ).error   == error
          assert (  "-4 ± 2"   *  Measure(value=-3)  ).implied == True
          assert (  "-4 ± 2"   *  Measure(value=-3)  ).units.symbols   == Unit().symbols
          assert (  "-4 ± 2"   *  Measure(value=-3)  ).units.magnitude == Unit().magnitude
          assert (  "-4 ± 2"   *  Measure(value=-3)  ) == Measure(units=Unit(), value= 12, error=error)
          # Preserve Inputs
          if(True):
            a = "4 ± 2"  
            b = Measure(value=3)
            c = a*b
            c = None
            assert a == "4 ± 2"  
            assert b == Measure(value=3)
        # Unitless * Unit
        if(True):
          # Normal Units
          if(True):
            # Value 1: Int
            assert isinstance( (  "3 ± 2"   *  Measure(value=4,unit=Unit("cm"))  ), Measure )
            error = measure._sqrt_( (Decimal(3)**2 * Decimal("0.5")**2 + Decimal(4)**2 * Decimal(2)**2) )
            assert (  "3 ± 2"   *  Measure(value=4,unit=Unit("cm"))  ).value   == 12
            assert (  "3 ± 2"   *  Measure(value=4,unit=Unit("cm"))  ).error   == error
            assert (  "3 ± 2"   *  Measure(value=4,unit=Unit("cm"))  ).implied == True
            assert (  "3 ± 2"   *  Measure(value=4,unit=Unit("cm"))  ).units.symbols   == Unit("cm").symbols
            assert (  "3 ± 2"   *  Measure(value=4,unit=Unit("cm"))  ).units.magnitude == Unit("cm").magnitude
            assert (  "3 ± 2"   *  Measure(value=4,unit=Unit("cm"))  ) == Measure(units=Unit("cm"), value= 12, error=error)
            # Value 2: Float
            assert isinstance( (  "0.3 ± 0.2"   *  Measure(value=0.4,unit=Unit("cm")) ), Measure )
            error = measure._sqrt_( (0.4**2 * 0.2**2 + 0.3**2 * 0.05**2) )
            assert math.isclose( (  "0.3 ± 0.2"   *  Measure(value=0.4,unit=Unit("cm"))  ).value , 0.3*0.4 )
            assert math.isclose( (  "0.3 ± 0.2"   *  Measure(value=0.4,unit=Unit("cm"))  ).error , error   )
            assert (  "0.3 ± 0.2"   *  Measure(value=0.4,unit=Unit("cm"))  ).implied == True
            assert (  "0.3 ± 0.2"   *  Measure(value=0.4,unit=Unit("cm"))  ).units.symbols   == Unit("cm").symbols
            assert (  "0.3 ± 0.2"   *  Measure(value=0.4,unit=Unit("cm"))  ).units.magnitude == Unit("cm").magnitude
            assert (  "0.3 ± 0.2"   *  Measure(value=0.4,unit=Unit("cm"))  ) == Measure(units=Unit("cm"), value= 0.3*0.4, error=error)
            # Value 3: Decimal
            assert isinstance( (  "40 ± 20"   *  Measure(value=Decimal("30"),unit=Unit("cm"))  ), Measure )
            error = measure._sqrt_( ( Decimal("40")**2 * Decimal("5")**2 + Decimal("30")**2 * Decimal("20")**2) )
            assert (  "40 ± 20"   *  Measure(value=Decimal("30"),unit=Unit("cm"))  ).value   == Decimal("1200")
            assert (  "40 ± 20"   *  Measure(value=Decimal("30"),unit=Unit("cm"))  ).error   == error
            assert (  "40 ± 20"   *  Measure(value=Decimal("30"),unit=Unit("cm"))  ).implied == True
            assert (  "40 ± 20"   *  Measure(value=Decimal("30"),unit=Unit("cm"))  ).units.symbols   == Unit("cm").symbols
            assert (  "40 ± 20"   *  Measure(value=Decimal("30"),unit=Unit("cm"))  ).units.magnitude == Unit("cm").magnitude
            assert (  "40 ± 20"   *  Measure(value=Decimal("30"),unit=Unit("cm"))  ) == Measure(units=Unit("cm"), value= Decimal("1200"), error=error)
            # Value 4: Negative
            assert isinstance( (  "-3 ± 2"   *  Measure(value=-4,unit=Unit("cm"))  ), Measure )
            error = measure._sqrt_( (Decimal(3)**2 * Decimal("0.5")**2 + Decimal(4)**2 * Decimal(2)**2) )
            assert (  "-3 ± 2"   *  Measure(value=-4,unit=Unit("cm"))  ).value   == 12
            assert (  "-3 ± 2"   *  Measure(value=-4,unit=Unit("cm"))  ).error   == error
            assert (  "-3 ± 2"   *  Measure(value=-4,unit=Unit("cm"))  ).implied == True
            assert (  "-3 ± 2"   *  Measure(value=-4,unit=Unit("cm"))  ).units.symbols   == Unit("cm").symbols
            assert (  "-3 ± 2"   *  Measure(value=-4,unit=Unit("cm"))  ).units.magnitude == Unit("cm").magnitude
            assert (  "-3 ± 2"   *  Measure(value=-4,unit=Unit("cm"))  ) == Measure(units=Unit("cm"), value= 12, error=error)
          # Magnitude Units
          if(True):
            # Value 1: Int
            assert isinstance( (  "5 ± 1"   *  Measure(value=2,unit=Unit("5 m^2"))  ) , Measure )
            error = measure._sqrt_( (Decimal("5")**2 * Decimal("2.5")**2 + Decimal("10")**2 * Decimal("1")**2) )/Decimal("5")
            assert (  "5 ± 1"   *  Measure(value=2,unit=Unit("5 m^2"))  ) == Measure(units=Unit("5 m^2"), value=10, error=error)
            assert (  "5 ± 1"   *  Measure(value=2,unit=Unit("5 m^2"))  ).value   == 10
            #assert (  "5 ± 1"   *  Measure(value=2,unit=Unit("5 m^2"))  ).error   == error
            # The above won't work, do to changes on uncertain even for decimal operations (due to calculating and back-calculating in unit operations).
            assert Measure._dec_isclose_( ("5 ± 1"   *  Measure(value=2,unit=Unit("5 m^2"))).error , error )
            assert (  "5 ± 1"   *  Measure(value=2,unit=Unit("5 m^2"))  ).implied == True
            assert (  "5 ± 1"   *  Measure(value=2,unit=Unit("5 m^2"))  ).units.symbols   == Unit("5 m^2").symbols
            assert (  "5 ± 1"   *  Measure(value=2,unit=Unit("5 m^2"))  ).units.magnitude == Unit("5 m^2").magnitude
            # Value 2: Float
            assert isinstance( (  "0.5 ± 0.1"   *  Measure(value=0.2,unit=Unit("5 m^2"))  ) , Measure )
            error = measure._sqrt_( (0.5**2 * 0.25**2 + 1.0**2 * 0.1**2) )/5
            assert (  "0.5 ± 0.1"   *  Measure(value=0.2,unit=Unit("5 m^2"))  ) == Measure(units=Unit("5 m^2"), value=0.1, error=error)
            assert math.isclose( (  "0.5 ± 0.1"   *  Measure(value=0.2,unit=Unit("5 m^2"))  ).value , 0.1   )
            assert math.isclose( (  "0.5 ± 0.1"   *  Measure(value=0.2,unit=Unit("5 m^2"))  ).error , error )
            assert (  "0.5 ± 0.1"   *  Measure(value=0.2,unit=Unit("5 m^2"))  ).implied == True
            assert (  "0.5 ± 0.1"   *  Measure(value=0.2,unit=Unit("5 m^2"))  ).units.symbols   == Unit("5 m^2").symbols
            assert (  "0.5 ± 0.1"   *  Measure(value=0.2,unit=Unit("5 m^2"))  ).units.magnitude == Unit("5 m^2").magnitude
            # Value 3: Decimal
            assert isinstance( (  "50 ± 2"   *  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  ) , Measure )
            error = measure._sqrt_( (Decimal("50")**2 * Decimal("25")**2 + Decimal("100")**2 * Decimal("2")**2) )/Decimal("5")
            assert (  "50 ± 2"   *  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  ) == Measure(units=Unit("5 m^2"), value=Decimal("1000"), error=error)
            assert (  "50 ± 2"   *  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  ).value   == Decimal("1000")
            assert (  "50 ± 2"   *  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  ).error   == error
            assert (  "50 ± 2"   *  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  ).implied == True
            assert (  "50 ± 2"   *  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  ).units.symbols   == Unit("5 m^2").symbols
            assert (  "50 ± 2"   *  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  ).units.magnitude == Unit("5 m^2").magnitude
            # Value 4: Negative
            assert isinstance( (  "-5 ± 1"   *  Measure(value=-2,unit=Unit("5 m^2"))  ) , Measure )
            error = measure._sqrt_( (Decimal("5")**2 * Decimal("2.5")**2 + Decimal("10")**2 * Decimal("1")**2) )/Decimal("5")
            assert (  "-5 ± 1"   *  Measure(value=-2,unit=Unit("5 m^2"))  ) == Measure(units=Unit("5 m^2"), value=10, error=error)
            assert (  "-5 ± 1"   *  Measure(value=-2,unit=Unit("5 m^2"))  ).value   == 10
            #assert (  "-5 ± 1"   *  Measure(value=-2,unit=Unit("5 m^2"))  ).error   == error
            # The above won't work, do to changes on uncertain even for decimal operations (due to calculating and back-calculating in unit operations).
            assert Measure._dec_isclose_( ("-5 ± 1"   *  Measure(value=-2,unit=Unit("5 m^2"))).error , error )
            assert (  "-5 ± 1"   *  Measure(value=-2,unit=Unit("5 m^2"))  ).implied == True
            assert (  "-5 ± 1"   *  Measure(value=-2,unit=Unit("5 m^2"))  ).units.symbols   == Unit("5 m^2").symbols
            assert (  "-5 ± 1"   *  Measure(value=-2,unit=Unit("5 m^2"))  ).units.magnitude == Unit("5 m^2").magnitude
          # Convoluted Units
          if(True):
            # Value 1: Int
            assert isinstance( ( "300 ± 2"   *  Measure(value=27,unit=Unit("\u00B0C")) ), Measure )
            error = measure._sqrt_( (Decimal("300")**2 * Decimal("0.5")**2 + Decimal("300.15")**2 * Decimal("2")**2) )
            assert ( "300 ± 2"   *  Measure(value=27,unit=Unit("\u00B0C")) ).value   == Decimal("300.15")*Decimal("300") - Decimal("273.15")
            assert ( "300 ± 2"   *  Measure(value=27,unit=Unit("\u00B0C")) ).error   == error
            assert ( "300 ± 2"   *  Measure(value=27,unit=Unit("\u00B0C")) ).implied == True
            assert ( "300 ± 2"   *  Measure(value=27,unit=Unit("\u00B0C")) ).units.symbols   == Unit("\u00B0C").symbols
            assert ( "300 ± 2"   *  Measure(value=27,unit=Unit("\u00B0C")) ).units.magnitude == Unit("\u00B0C").magnitude
            assert ( "300 ± 2"   *  Measure(value=27,unit=Unit("\u00B0C")) ) == Measure(units=Unit("\u00B0C"), value= Decimal("300.15")*Decimal("300") - Decimal("273.15"), error=error)
            # Value 2: Float
            assert isinstance( ( "299.9 ± 0.02"   *  Measure(value=26.85,unit=Unit("\u00B0C")) ), Measure )
            error = measure._sqrt_( (299.9**2 * 0.005**2 + 300**2 * 0.02**2) )
            assert math.isclose( ( "299.9 ± 0.02"   *  Measure(value=26.85,unit=Unit("\u00B0C")) ).value  , 299.9 * 300 - 273.15 )
            assert math.isclose( ( "299.9 ± 0.02"   *  Measure(value=26.85,unit=Unit("\u00B0C")) ).error  , error )
            assert ( "299.9 ± 0.02"   *  Measure(value=26.85,unit=Unit("\u00B0C")) ).implied == True 
            assert ( "299.9 ± 0.02"   *  Measure(value=26.85,unit=Unit("\u00B0C")) ).units.symbols   == Unit("\u00B0C").symbols
            assert ( "299.9 ± 0.02"   *  Measure(value=26.85,unit=Unit("\u00B0C")) ).units.magnitude == Unit("\u00B0C").magnitude
            assert ( "299.9 ± 0.02"   *  Measure(value=26.85,unit=Unit("\u00B0C")) ) == Measure(units=Unit("\u00B0C"), value=299.9 * 300 - 273.15, error=error)
            # Value 3: Decimal
            assert isinstance( ( "300 ± 0.02"   *  Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ), Measure )
            error = measure._sqrt_( (Decimal("300")**2 * Decimal("0.005")**2 + Decimal("300")**2 * Decimal("0.02")**2) )
            assert ( "300 ± 0.02"   *  Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).value   == Decimal("300") * Decimal("300") - Decimal("273.15") 
            assert ( "300 ± 0.02"   *  Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).error   == error
            assert ( "300 ± 0.02"   *  Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).implied == True
            assert ( "300 ± 0.02"   *  Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).units.symbols   == Unit("\u00B0C").symbols
            assert ( "300 ± 0.02"   *  Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).units.magnitude == Unit("\u00B0C").magnitude
            assert ( "300 ± 0.02"   *  Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ) == Measure(units=Unit("\u00B0C"), value=Decimal("300") * Decimal("300") - Decimal("273.15"), error=error)
            # Value 4: Negative
            assert isinstance( ( "300 ± 2"   *  Measure(value=-27,unit=Unit("\u00B0C")) ), Measure )
            error = measure._sqrt_( (Decimal("300")**2 * Decimal("0.5")**2 + Decimal("246.15")**2 * Decimal("2")**2) )
            assert ( "300 ± 2"   *  Measure(value=-27,unit=Unit("\u00B0C")) ).value   == Decimal("246.15")*Decimal("300") - Decimal("273.15")
            assert ( "300 ± 2"   *  Measure(value=-27,unit=Unit("\u00B0C")) ).error   == error
            assert ( "300 ± 2"   *  Measure(value=-27,unit=Unit("\u00B0C")) ).implied == True
            assert ( "300 ± 2"   *  Measure(value=-27,unit=Unit("\u00B0C")) ).units.symbols   == Unit("\u00B0C").symbols
            assert ( "300 ± 2"   *  Measure(value=-27,unit=Unit("\u00B0C")) ).units.magnitude == Unit("\u00B0C").magnitude
            assert ( "300 ± 2"   *  Measure(value=-27,unit=Unit("\u00B0C")) ) == Measure(units=Unit("\u00B0C"), value= Decimal("246.15")*Decimal("300") - Decimal("273.15"), error=error)
          # Preserve Inputs
          if(True):
            a = "3 ± 2"  
            b = Measure(value=4,unit=Unit("cm"))
            c = a*b
            c = None
            assert a == "3 ± 2"  
            assert b == Measure(value=4,unit=Unit("cm"))
        # Unit * Unitless
        if(True):
          # Normal Units
          if(True):
            # Value 1: Int
            assert isinstance( ( "4 ± 2 cm"   *  Measure(value=3)  ), Measure )
            error = measure._sqrt_( (Decimal(4)**2 * Decimal("0.5")**2 + Decimal(3)**2 * Decimal(2)**2) )
            assert (  "4 ± 2 cm"   *  Measure(value=3)  ).value   == 12
            assert (  "4 ± 2 cm"   *  Measure(value=3)  ).error   == error 
            assert (  "4 ± 2 cm"   *  Measure(value=3)  ).implied == True
            assert (  "4 ± 2 cm"   *  Measure(value=3)  ).units.symbols   == Unit("cm").symbols
            assert (  "4 ± 2 cm"   *  Measure(value=3)  ).units.magnitude == Unit("cm").magnitude
            assert (  "4 ± 2 cm"   *  Measure(value=3)  ) == Measure(units=Unit("cm"), value= 12, error=error)
            # Value 2: Float
            assert isinstance( ( "0.4 ± 0.2 cm"   *  Measure(value=0.3)  ), Measure )
            error = measure._sqrt_( (0.4**2 * 0.05**2 + 0.3**2 * 0.2**2) )
            assert math.isclose( (  "0.4 ± 0.2 cm"   *  Measure(value=0.3)  ).value , 0.3*0.4 )
            assert math.isclose( (  "0.4 ± 0.2 cm"   *  Measure(value=0.3)  ).error , error   )
            assert (  "0.4 ± 0.2 cm"   *  Measure(value=0.3)  ).implied == True
            assert (  "0.4 ± 0.2 cm"   *  Measure(value=0.3)  ).units.symbols   == Unit("cm").symbols
            assert (  "0.4 ± 0.2 cm"   *  Measure(value=0.3)  ).units.magnitude == Unit("cm").magnitude
            assert (  "0.4 ± 0.2 cm"   *  Measure(value=0.3)  ) == Measure(units=Unit("cm"), value= 0.3*0.4, error=error)
            # Value 3: Decimal
            assert isinstance( (  "40 ± 20 cm"   *  Measure(value=Decimal("30"))  ), Measure )
            error = measure._sqrt_( (Decimal("40")**2 * Decimal("5")**2 + Decimal("30")**2 * Decimal("20")**2) )
            assert (  "40 ± 20 cm"   *  Measure(value=Decimal("30"))  ).value   == Decimal("1200")
            assert (  "40 ± 20 cm"   *  Measure(value=Decimal("30"))  ).error   == error
            assert (  "40 ± 20 cm"   *  Measure(value=Decimal("30"))  ).implied == True
            assert (  "40 ± 20 cm"   *  Measure(value=Decimal("30"))  ).units.symbols   == Unit("cm").symbols
            assert (  "40 ± 20 cm"   *  Measure(value=Decimal("30"))  ).units.magnitude == Unit("cm").magnitude
            assert (  "40 ± 20 cm"   *  Measure(value=Decimal("30"))  ) == Measure(units=Unit("cm"), value= Decimal("1200"), error=error)
            # Value 4: Negative
            assert isinstance( ( "-4 ± 2 cm"   *  Measure(value=-3)  ), Measure )
            error = measure._sqrt_( (Decimal(4)**2 * Decimal("0.5")**2 + Decimal(3)**2 * Decimal(2)**2) )
            assert (  "-4 ± 2 cm"   *  Measure(value=-3)  ).value   == 12
            assert (  "-4 ± 2 cm"   *  Measure(value=-3)  ).error   == error
            assert (  "-4 ± 2 cm"   *  Measure(value=-3)  ).implied == True
            assert (  "-4 ± 2 cm"   *  Measure(value=-3)  ).units.symbols   == Unit("cm").symbols
            assert (  "-4 ± 2 cm"   *  Measure(value=-3)  ).units.magnitude == Unit("cm").magnitude
            assert (  "-4 ± 2 cm"   *  Measure(value=-3)  ) == Measure(units=Unit("cm"), value= 12, error=error)
          # Magnitude Units
          if(True):
            # Value 1: Int
            assert isinstance( (  "2 ± 1 * 5 m^2"   *  Measure(value=5)  ) , Measure )
            error = measure._sqrt_( (Decimal(5)**2 * Decimal(5)**2 + Decimal(10)**2 * Decimal("0.5")**2) )/Decimal(5)
            assert (  "2 ± 1 * 5 m^2"   *  Measure(value=5)  ) == Measure(units=Unit("5 m^2"), value=10, error=error)
            assert (  "2 ± 1 * 5 m^2"   *  Measure(value=5)  ).value   == 10
            assert (  "2 ± 1 * 5 m^2"   *  Measure(value=5)  ).error   == error
            assert (  "2 ± 1 * 5 m^2"   *  Measure(value=5)  ).implied == True
            assert (  "2 ± 1 * 5 m^2"   *  Measure(value=5)  ).units.symbols   == Unit("5 m^2").symbols
            assert (  "2 ± 1 * 5 m^2"   *  Measure(value=5)  ).units.magnitude == Unit("5 m^2").magnitude
            # Value 2: Float
            assert isinstance( (  "0.2 ± 0.1 * 5 m^2"   *  Measure(value=0.5)  ) , Measure )
            error = measure._sqrt_( (0.5**2 * 0.5**2 + 1.0**2 * 0.05**2) )/5
            assert (  "0.2 ± 0.1 * 5 m^2"   *  Measure(value=0.5)  ) == Measure(units=Unit("5 m^2"), value=0.1, error=error)
            assert math.isclose( (  "0.2 ± 0.1 * 5 m^2"   *  Measure(value=0.5)  ).value , 0.1   )
            assert math.isclose( (  "0.2 ± 0.1 * 5 m^2"   *  Measure(value=0.5)  ).error , error )
            assert (  "0.2 ± 0.1 * 5 m^2"   *  Measure(value=0.5)  ).implied == True
            assert (  "0.2 ± 0.1 * 5 m^2"   *  Measure(value=0.5)  ).units.symbols   == Unit("5 m^2").symbols
            assert (  "0.2 ± 0.1 * 5 m^2"   *  Measure(value=0.5)  ).units.magnitude == Unit("5 m^2").magnitude
            # Value 3: Decimal
            assert isinstance( (  "20 ± 5 * 5 m^2"   *  Measure(value=Decimal("50"))  ) , Measure )
            error = measure._sqrt_( (Decimal("50")**2 * Decimal("25")**2 + Decimal("100")**2 * Decimal("5")**2) )/Decimal("5")
            assert (  "20 ± 5 * 5 m^2"   *  Measure(value=Decimal("50"))  ) == Measure(units=Unit("5 m^2"), value=Decimal("1000"), error=error)
            assert (  "20 ± 5 * 5 m^2"   *  Measure(value=Decimal("50"))  ).value   == Decimal("1000")
            assert (  "20 ± 5 * 5 m^2"   *  Measure(value=Decimal("50"))  ).error   == error
            assert (  "20 ± 5 * 5 m^2"   *  Measure(value=Decimal("50"))  ).implied == True
            assert (  "20 ± 5 * 5 m^2"   *  Measure(value=Decimal("50"))  ).units.symbols   == Unit("5 m^2").symbols
            assert (  "20 ± 5 * 5 m^2"   *  Measure(value=Decimal("50"))  ).units.magnitude == Unit("5 m^2").magnitude
            # Value 4: Negative
            assert isinstance( (  "-2 ± 1 * 5 m^2"   *  Measure(value=-5)  ) , Measure )
            error = measure._sqrt_( (Decimal(5)**2 * Decimal(5)**2 + Decimal(10)**2 * Decimal("0.5")**2) )/Decimal(5)
            assert (  "-2 ± 1 * 5 m^2"   *  Measure(value=-5)  ) == Measure(units=Unit("5 m^2"), value=10, error=error)
            assert (  "-2 ± 1 * 5 m^2"   *  Measure(value=-5)  ).value   == 10
            assert (  "-2 ± 1 * 5 m^2"   *  Measure(value=-5)  ).error   == error
            assert (  "-2 ± 1 * 5 m^2"   *  Measure(value=-5)  ).implied == True
            assert (  "-2 ± 1 * 5 m^2"   *  Measure(value=-5)  ).units.symbols   == Unit("5 m^2").symbols
            assert (  "-2 ± 1 * 5 m^2"   *  Measure(value=-5)  ).units.magnitude == Unit("5 m^2").magnitude
          # Convoluted Units
          if(True):
            # Value 1: Int
            assert isinstance( ( "27 ± 1 \u00B0C"   *  Measure(value=300) ), Measure )
            error = measure._sqrt_( (Decimal("300")**2 * Decimal("1")**2 + Decimal("300.15")**2 * Decimal("50")**2) )
            assert ( "27 ± 1 \u00B0C"   *  Measure(value=300) ).value   == Decimal("300.15")*Decimal("300") - Decimal("273.15")
            assert ( "27 ± 1 \u00B0C"   *  Measure(value=300) ).error   == error
            assert ( "27 ± 1 \u00B0C"   *  Measure(value=300) ).implied == True
            assert ( "27 ± 1 \u00B0C"   *  Measure(value=300) ).units.symbols   == Unit("\u00B0C").symbols
            assert ( "27 ± 1 \u00B0C"   *  Measure(value=300) ).units.magnitude == Unit("\u00B0C").magnitude
            assert ( "27 ± 1 \u00B0C"   *  Measure(value=300) ) == Measure(units=Unit("\u00B0C"), value= Decimal("300.15")*Decimal("300") - Decimal("273.15"), error=error)
            # Value 2: Float
            assert isinstance( ( "26.85 ± 0.02 \u00B0C"   *  Measure(value=299.9) ), Measure )
            error = measure._sqrt_( (299.9**2 * 0.02**2 + 300**2 * 0.05**2) )
            assert math.isclose( ( "26.85 ± 0.02 \u00B0C"   *  Measure(value=299.9) ).value , 299.9 * 300 - 273.15 )
            assert math.isclose( ( "26.85 ± 0.02 \u00B0C"   *  Measure(value=299.9) ).error , error )
            assert ( "26.85 ± 0.02 \u00B0C"   *  Measure(value=299.9) ).implied == True
            assert ( "26.85 ± 0.02 \u00B0C"   *  Measure(value=299.9) ).units.symbols   == Unit("\u00B0C").symbols
            assert ( "26.85 ± 0.02 \u00B0C"   *  Measure(value=299.9) ).units.magnitude == Unit("\u00B0C").magnitude
            assert ( "26.85 ± 0.02 \u00B0C"   *  Measure(value=299.9) ) == Measure(units=Unit("\u00B0C"), value=299.9 * 300 - 273.15, error=error)
            # Value 3: Decimal
            assert isinstance( ( "26.85 ± 0.02 \u00B0C"   *  Measure(value=Decimal("300")) ), Measure )
            error = measure._sqrt_( (Decimal("300")**2 * Decimal("0.02")**2 + Decimal("300")**2 * Decimal("50")**2) )
            assert ( "26.85 ± 0.02 \u00B0C"   *  Measure(value=Decimal("300")) ).value   == Decimal("300") * Decimal("300") - Decimal("273.15") 
            assert ( "26.85 ± 0.02 \u00B0C"   *  Measure(value=Decimal("300")) ).error   == error
            assert ( "26.85 ± 0.02 \u00B0C"   *  Measure(value=Decimal("300")) ).implied == True
            assert ( "26.85 ± 0.02 \u00B0C"   *  Measure(value=Decimal("300")) ).units.symbols   == Unit("\u00B0C").symbols
            assert ( "26.85 ± 0.02 \u00B0C"   *  Measure(value=Decimal("300")) ).units.magnitude == Unit("\u00B0C").magnitude
            assert ( "26.85 ± 0.02 \u00B0C"   *  Measure(value=Decimal("300")) ) == Measure(units=Unit("\u00B0C"), value=Decimal("300") * Decimal("300") - Decimal("273.15"), error=error)
            # Value 4: Negative
            assert isinstance( ( "-27 ± 1 \u00B0C"   *  Measure(value=300) ), Measure )
            error = measure._sqrt_( (Decimal("300")**2 * Decimal("1")**2 + Decimal("246.15")**2 * Decimal("50")**2) )
            assert ( "-27 ± 1 \u00B0C"   *  Measure(value=300) ).value   == Decimal("246.15")*Decimal("300") - Decimal("273.15")
            assert ( "-27 ± 1 \u00B0C"   *  Measure(value=300) ).error   == error
            assert ( "-27 ± 1 \u00B0C"   *  Measure(value=300) ).implied == True
            assert ( "-27 ± 1 \u00B0C"   *  Measure(value=300) ).units.symbols   == Unit("\u00B0C").symbols
            assert ( "-27 ± 1 \u00B0C"   *  Measure(value=300) ).units.magnitude == Unit("\u00B0C").magnitude
            assert ( "-27 ± 1 \u00B0C"   *  Measure(value=300) ) == Measure(units=Unit("\u00B0C"), value= Decimal("246.15")*Decimal("300") - Decimal("273.15"), error=error)
          # Preserve Inputs
          if(True):
            a = "4 ± 2 cm" 
            b = Measure(value=3)
            c = a*b
            c = None
            assert a == "4 ± 2 cm"  
            assert b == Measure(value=3)
        # Units * Units
        if(True):
          # Normal Units
          if(True):
            # Value 1: Int
            assert isinstance( ( "4 ± 2 cm"   *  Measure(value=3,unit=Unit("cm"))  ), Measure )
            error = measure._sqrt_( (Decimal(4)**2 * Decimal("0.5")**2 + Decimal(3)**2 * Decimal(2)**2) )
            assert (  "4 ± 2 cm"   *  Measure(value=3,unit=Unit("cm"))  ).value   == 12
            assert (  "4 ± 2 cm"   *  Measure(value=3,unit=Unit("cm"))  ).error   == error
            assert (  "4 ± 2 cm"   *  Measure(value=3,unit=Unit("cm"))  ).implied == True
            assert (  "4 ± 2 cm"   *  Measure(value=3,unit=Unit("cm"))  ).units.symbols   == Unit("cm^2").symbols
            assert (  "4 ± 2 cm"   *  Measure(value=3,unit=Unit("cm"))  ).units.magnitude == Unit("cm^2").magnitude
            assert (  "4 ± 2 cm"   *  Measure(value=3,unit=Unit("cm"))  ) == Measure(units=Unit("cm^2"), value= 12, error=error)
            # Value 2: Float
            assert isinstance( ( "0.4 ± 0.2 cm"   *  Measure(value=0.3,unit=Unit("cm"))  ), Measure )
            error = measure._sqrt_( (0.4**2 * 0.05**2 + 0.3**2 * 0.2**2) )
            assert math.isclose( (  "0.4 ± 0.2 cm"   *  Measure(value=0.3,unit=Unit("cm"))  ).value , 0.3*0.4 )
            assert math.isclose( (  "0.4 ± 0.2 cm"   *  Measure(value=0.3,unit=Unit("cm"))  ).error , error   )
            assert (  "0.4 ± 0.2 cm"   *  Measure(value=0.3,unit=Unit("cm"))  ).implied == True
            assert (  "0.4 ± 0.2 cm"   *  Measure(value=0.3,unit=Unit("cm"))  ).units.symbols   == Unit("cm^2").symbols
            assert (  "0.4 ± 0.2 cm"   *  Measure(value=0.3,unit=Unit("cm"))  ).units.magnitude == Unit("cm^2").magnitude
            assert (  "0.4 ± 0.2 cm"   *  Measure(value=0.3,unit=Unit("cm"))  ) == Measure(units=Unit("cm^2"), value= 0.3*0.4, error=error)
            # Value 3: Decimal
            assert isinstance( (  "40 ± 20 cm"   *  Measure(value=Decimal("30"),unit=Unit("cm"))  ), Measure )
            error = measure._sqrt_( (Decimal("40")**2 * Decimal("5")**2 + Decimal("30")**2 * Decimal("20")**2) )
            assert (  "40 ± 20 cm"   *  Measure(value=Decimal("30"),unit=Unit("cm"))  ).value   == Decimal("1200")
            assert (  "40 ± 20 cm"   *  Measure(value=Decimal("30"),unit=Unit("cm"))  ).error   == error
            assert (  "40 ± 20 cm"   *  Measure(value=Decimal("30"),unit=Unit("cm"))  ).implied == True
            assert (  "40 ± 20 cm"   *  Measure(value=Decimal("30"),unit=Unit("cm"))  ).units.symbols   == Unit("cm^2").symbols
            assert (  "40 ± 20 cm"   *  Measure(value=Decimal("30"),unit=Unit("cm"))  ).units.magnitude == Unit("cm^2").magnitude
            assert (  "40 ± 20 cm"   *  Measure(value=Decimal("30"),unit=Unit("cm"))  ) == Measure(units=Unit("cm^2"), value= Decimal("1200"), error=error)
            # Value 4: Negative
            assert isinstance( ( "-4 ± 2 cm"   *  Measure(value=-3,unit=Unit("cm"))  ), Measure )
            error = measure._sqrt_( (Decimal(4)**2 * Decimal("0.5")**2 + Decimal(3)**2 * Decimal(2)**2) )
            assert (  "-4 ± 2 cm"   *  Measure(value=-3,unit=Unit("cm"))  ).value   == 12
            assert (  "-4 ± 2 cm"   *  Measure(value=-3,unit=Unit("cm"))  ).error   == error
            assert (  "-4 ± 2 cm"   *  Measure(value=-3,unit=Unit("cm"))  ).implied == True
            assert (  "-4 ± 2 cm"   *  Measure(value=-3,unit=Unit("cm"))  ).units.symbols   == Unit("cm^2").symbols
            assert (  "-4 ± 2 cm"   *  Measure(value=-3,unit=Unit("cm"))  ).units.magnitude == Unit("cm^2").magnitude
            assert (  "-4 ± 2 cm"   *  Measure(value=-3,unit=Unit("cm"))  ) == Measure(units=Unit("cm^2"), value= 12, error=error)
          # Magnitude Units
          if(True):
            # Value 1: Int
            assert isinstance( (  "2 ± 1 * 5 m^2"   *  Measure(value=5,unit=Unit("5 m^2"))  ) , Measure )
            error = measure._sqrt_( (Decimal(25)**2 * Decimal(5)**2 + Decimal(10)**2 * Decimal("2.5")**2) )/Decimal(25)
            assert (  "2 ± 1 * 5 m^2"   *  Measure(value=5,unit=Unit("5 m^2"))  ).value   == 10
            assert Measure._dec_isclose_( (  "2 ± 1 * 5 m^2"   *  Measure(value=5,unit=Unit("5 m^2"))  ).error   , error )
            assert (  "2 ± 1 * 5 m^2"   *  Measure(value=5,unit=Unit("5 m^2"))  ).implied == True
            assert (  "2 ± 1 * 5 m^2"   *  Measure(value=5,unit=Unit("5 m^2"))  ).units.symbols   == Unit("25 m^4").symbols
            assert (  "2 ± 1 * 5 m^2"   *  Measure(value=5,unit=Unit("5 m^2"))  ).units.magnitude == Unit("25 m^4").magnitude
            assert (  "2 ± 1 * 5 m^2"   *  Measure(value=5,unit=Unit("5 m^2"))  ) == Measure(units=Unit("25 m^4"), value=10, error=error)
            # Value 2: Float
            assert isinstance( (  "0.2 ± 0.1 * 5 m^2"   *  Measure(value=0.5,unit=Unit("5 m^4"))  ) , Measure )
            error = measure._sqrt_( (2.5**2 * 0.5**2 + 1.0**2 * 0.25**2) )/25
            assert math.isclose( (  "0.2 ± 0.1 * 5 m^2"   *  Measure(value=0.5,unit=Unit("5 m^2"))  ).value , 0.1   )
            assert math.isclose( (  "0.2 ± 0.1 * 5 m^2"   *  Measure(value=0.5,unit=Unit("5 m^2"))  ).error , error )
            assert (  "0.2 ± 0.1 * 5 m^2"   *  Measure(value=0.5,unit=Unit("5 m^2"))  ).implied == True
            assert (  "0.2 ± 0.1 * 5 m^2"   *  Measure(value=0.5,unit=Unit("5 m^2"))  ).units.symbols   == Unit("25 m^4").symbols
            assert (  "0.2 ± 0.1 * 5 m^2"   *  Measure(value=0.5,unit=Unit("5 m^2"))  ).units.magnitude == Unit("25 m^4").magnitude
            assert (  "0.2 ± 0.1 * 5 m^2"   *  Measure(value=0.5,unit=Unit("5 m^2"))  ) == Measure(units=Unit("25 m^4"), value=0.1, error=error)
            # Value 3: Decimal
            assert isinstance( (  "20 ± 5 * 5 m^2"   *  Measure(value=Decimal("50"),unit=Unit("5 m^2"))  ) , Measure )
            error = measure._sqrt_( (Decimal("250")**2 * Decimal("25")**2 + Decimal("100")**2 * Decimal("25")**2) )/Decimal("25")
            assert (  "20 ± 5 * 5 m^2"   *  Measure(value=Decimal("50"),unit=Unit("5 m^2"))  ) == Measure(units=Unit("25 m^4"), value=Decimal("1000"), error=error)
            assert (  "20 ± 5 * 5 m^2"   *  Measure(value=Decimal("50"),unit=Unit("5 m^2"))  ).value   == Decimal("1000")
            assert Measure._dec_isclose_( (  "20 ± 5 * 5 m^2"   *  Measure(value=Decimal("50"),unit=Unit("5 m^2"))  ).error   , error )
            assert (  "20 ± 5 * 5 m^2"   *  Measure(value=Decimal("50"),unit=Unit("5 m^2"))  ).implied == True
            assert (  "20 ± 5 * 5 m^2"   *  Measure(value=Decimal("50"),unit=Unit("5 m^2"))  ).units.symbols   == Unit("25 m^4").symbols
            assert (  "20 ± 5 * 5 m^2"   *  Measure(value=Decimal("50"),unit=Unit("5 m^2"))  ).units.magnitude == Unit("25 m^4").magnitude
            # Value 4: Negative
            assert isinstance( (  "-2 ± 1 * 5 m^2"   *  Measure(value=-5,unit=Unit("5 m^2"))  ) , Measure )
            error = measure._sqrt_( (Decimal(25)**2 * Decimal(5)**2 + Decimal(10)**2 * Decimal("2.5")**2) )/Decimal(25)
            assert (  "-2 ± 1 * 5 m^2"   *  Measure(value=-5,unit=Unit("5 m^2"))  ) == Measure(units=Unit("25 m^4"), value=10, error=error)
            assert (  "-2 ± 1 * 5 m^2"   *  Measure(value=-5,unit=Unit("5 m^2"))  ).value   == 10
            assert Measure._dec_isclose_( (  "-2 ± 1 * 5 m^2"   *  Measure(value=-5,unit=Unit("5 m^2"))  ).error   , error )
            assert (  "-2 ± 1 * 5 m^2"   *  Measure(value=-5,unit=Unit("5 m^2"))  ).implied == True
            assert (  "-2 ± 1 * 5 m^2"   *  Measure(value=-5,unit=Unit("5 m^2"))  ).units.symbols   == Unit("25 m^4").symbols
            assert (  "-2 ± 1 * 5 m^2"   *  Measure(value=-5,unit=Unit("5 m^2"))  ).units.magnitude == Unit("25 m^4").magnitude
          # Convoluted Units
          if(True):
            # Value 1: Int
            assert isinstance( ( "27 ± 1 \u00B0C"   *  Measure(value=27,unit=Unit("\u00B0C")) ), Measure )
            error = measure._sqrt_( (Decimal("300.15")**2 * Decimal("1")**2 + Decimal("300.15")**2 * Decimal("0.5")**2) )
            assert ( "27 ± 1 \u00B0C"   *  Measure(value=27,unit=Unit("\u00B0C")) ).value   == Decimal("300.15")*Decimal("300.15")
            assert ( "27 ± 1 \u00B0C"   *  Measure(value=27,unit=Unit("\u00B0C")) ).error   == error
            assert ( "27 ± 1 \u00B0C"   *  Measure(value=27,unit=Unit("\u00B0C")) ).implied == True
            assert ( "27 ± 1 \u00B0C"   *  Measure(value=27,unit=Unit("\u00B0C")) ).units.symbols   == Unit("K^2").symbols
            assert ( "27 ± 1 \u00B0C"   *  Measure(value=27,unit=Unit("\u00B0C")) ).units.magnitude == Unit("K^2").magnitude
            assert ( "27 ± 1 \u00B0C"   *  Measure(value=27,unit=Unit("\u00B0C")) ) == Measure(units=Unit("K^2"), value= Decimal("300.15")*Decimal("300.15"), error=error)
            # Value 2: Float
            assert isinstance( ( "26.85 ± 0.02 \u00B0C"   *  Measure(value=26.85,unit=Unit("\u00B0C")) ), Measure )
            error = measure._sqrt_( (300**2 * 0.02**2 + 300**2 * 0.005**2) )
            assert math.isclose( ( "26.85 ± 0.02 \u00B0C"   *  Measure(value=26.85,unit=Unit("\u00B0C")) ).value   , 300 * 300 )
            assert math.isclose( ( "26.85 ± 0.02 \u00B0C"   *  Measure(value=26.85,unit=Unit("\u00B0C")) ).error   , error )
            assert ( "26.85 ± 0.02 \u00B0C"   *  Measure(value=26.85,unit=Unit("\u00B0C")) ).implied == True
            assert ( "26.85 ± 0.02 \u00B0C"   *  Measure(value=26.85,unit=Unit("\u00B0C")) ).units.symbols   == Unit("K^2").symbols
            assert ( "26.85 ± 0.02 \u00B0C"   *  Measure(value=26.85,unit=Unit("\u00B0C")) ).units.magnitude == Unit("K^2").magnitude
            assert ( "26.85 ± 0.02 \u00B0C"   *  Measure(value=26.85,unit=Unit("\u00B0C")) ) == Measure(units=Unit("K^2"), value=300 * 300, error=error)
            # Value 3: Decimal
            assert isinstance( ( "26.85 ± 0.02 \u00B0C"   *  Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ), Measure )
            error = measure._sqrt_( (Decimal("300")**2 * Decimal("0.02")**2 + Decimal("300")**2 * Decimal("0.005")**2) )
            assert ( "26.85 ± 0.02 \u00B0C"   *  Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).value   == Decimal("300") * Decimal("300") 
            assert ( "26.85 ± 0.02 \u00B0C"   *  Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).error   == error
            assert ( "26.85 ± 0.02 \u00B0C"   *  Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).implied == True
            assert ( "26.85 ± 0.02 \u00B0C"   *  Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).units.symbols   == Unit("K^2").symbols
            assert ( "26.85 ± 0.02 \u00B0C"   *  Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).units.magnitude == Unit("K^2").magnitude
            assert ( "26.85 ± 0.02 \u00B0C"   *  Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ) == Measure(units=Unit("K^2"), value=Decimal("300") * Decimal("300"), error=error)
            # Value 4: Negative
            assert isinstance( ( "-27 ± 1 \u00B0C"   *  Measure(value=-27,unit=Unit("\u00B0C")) ), Measure )
            error = measure._sqrt_( (Decimal("246.15")**2 * Decimal("1")**2 + Decimal("246.15")**2 * Decimal("0.5")**2) )
            assert ( "-27 ± 1 \u00B0C"   *  Measure(value=-27,unit=Unit("\u00B0C")) ).value   == Decimal("246.15")*Decimal("246.15")
            assert ( "-27 ± 1 \u00B0C"   *  Measure(value=-27,unit=Unit("\u00B0C")) ).error   == error
            assert ( "-27 ± 1 \u00B0C"   *  Measure(value=-27,unit=Unit("\u00B0C")) ).implied == True
            assert ( "-27 ± 1 \u00B0C"   *  Measure(value=-27,unit=Unit("\u00B0C")) ).units.symbols   == Unit("K^2").symbols
            assert ( "-27 ± 1 \u00B0C"   *  Measure(value=-27,unit=Unit("\u00B0C")) ).units.magnitude == Unit("K^2").magnitude
            assert ( "-27 ± 1 \u00B0C"   *  Measure(value=-27,unit=Unit("\u00B0C")) ) == Measure(units=Unit("K^2"), value= Decimal("246.15")*Decimal("246.15"), error=error)
          # Canceling Units
          if(True):
            # Value 1: Int
            assert isinstance( ( "4 ± 2 cm"   *  Measure(value=3,unit=Unit("cm^-1"))  ), Measure )
            error = measure._sqrt_( (Decimal(4)**2 * Decimal("0.5")**2 + Decimal(3)**2 * Decimal(2)**2) )
            assert (  "4 ± 2 cm"   *  Measure(value=3,unit=Unit("cm^-1"))  ).value   == 12
            assert (  "4 ± 2 cm"   *  Measure(value=3,unit=Unit("cm^-1"))  ).error   == error
            assert (  "4 ± 2 cm"   *  Measure(value=3,unit=Unit("cm^-1"))  ).implied == True
            assert (  "4 ± 2 cm"   *  Measure(value=3,unit=Unit("cm^-1"))  ).units.symbols   == Unit().symbols
            assert (  "4 ± 2 cm"   *  Measure(value=3,unit=Unit("cm^-1"))  ).units.magnitude == Unit().magnitude
            assert (  "4 ± 2 cm"   *  Measure(value=3,unit=Unit("cm^-1"))  ) == Measure(units=Unit(), value= 12, error=error)
            # Value 2: Float
            assert isinstance( ( "0.4 ± 0.2 cm"   *  Measure(value=0.3,unit=Unit("cm^-1"))  ), Measure )
            error = measure._sqrt_( (0.4**2 * 0.05**2 + 0.3**2 * 0.2**2) )
            assert math.isclose( (  "0.4 ± 0.2 cm"   *  Measure(value=0.3,unit=Unit("cm^-1"))  ).value , 0.3*0.4 )
            assert math.isclose( (  "0.4 ± 0.2 cm"   *  Measure(value=0.3,unit=Unit("cm^-1"))  ).error , error   )
            assert (  "0.4 ± 0.2 cm"   *  Measure(value=0.3,unit=Unit("cm^-1"))  ).implied == True
            assert (  "0.4 ± 0.2 cm"   *  Measure(value=0.3,unit=Unit("cm^-1"))  ).units.symbols   == Unit().symbols
            assert (  "0.4 ± 0.2 cm"   *  Measure(value=0.3,unit=Unit("cm^-1"))  ).units.magnitude == Unit().magnitude
            assert (  "0.4 ± 0.2 cm"   *  Measure(value=0.3,unit=Unit("cm^-1"))  ) == Measure(units=Unit(), value= 0.3*0.4, error=error)
            # Value 3: Decimal
            assert isinstance( (  "40 ± 20 cm"   *  Measure(value=Decimal("30"),unit=Unit("cm^-1"))  ), Measure )
            error = measure._sqrt_( (Decimal("40")**2 * Decimal("5")**2 + Decimal("30")**2 * Decimal("20")**2) )
            assert (  "40 ± 20 cm"   *  Measure(value=Decimal("30"),unit=Unit("cm^-1"))  ).value   == Decimal("1200")
            assert (  "40 ± 20 cm"   *  Measure(value=Decimal("30"),unit=Unit("cm^-1"))  ).error   == error
            assert (  "40 ± 20 cm"   *  Measure(value=Decimal("30"),unit=Unit("cm^-1"))  ).implied == True
            assert (  "40 ± 20 cm"   *  Measure(value=Decimal("30"),unit=Unit("cm^-1"))  ).units.symbols   == Unit().symbols
            assert (  "40 ± 20 cm"   *  Measure(value=Decimal("30"),unit=Unit("cm^-1"))  ).units.magnitude == Unit().magnitude
            assert (  "40 ± 20 cm"   *  Measure(value=Decimal("30"),unit=Unit("cm^-1"))  ) == Measure(units=Unit(), value= Decimal("1200"), error=error)
            # Value 4: Negative
            assert isinstance( ( "-4 ± 2 cm"   *  Measure(value=-3,unit=Unit("cm^-1"))  ), Measure )
            error = measure._sqrt_( (Decimal(4)**2 * Decimal("0.5")**2 + Decimal(3)**2 * Decimal(2)**2) )
            assert (  "-4 ± 2 cm"   *  Measure(value=-3,unit=Unit("cm^-1"))  ).value   == 12
            assert (  "-4 ± 2 cm"   *  Measure(value=-3,unit=Unit("cm^-1"))  ).error   == error
            assert (  "-4 ± 2 cm"   *  Measure(value=-3,unit=Unit("cm^-1"))  ).implied == True
            assert (  "-4 ± 2 cm"   *  Measure(value=-3,unit=Unit("cm^-1"))  ).units.symbols   == Unit().symbols
            assert (  "-4 ± 2 cm"   *  Measure(value=-3,unit=Unit("cm^-1"))  ).units.magnitude == Unit().magnitude
            assert (  "-4 ± 2 cm"   *  Measure(value=-3,unit=Unit("cm^-1"))  ) == Measure(units=Unit(), value= 12, error=error)
          # Preserve Inputs
          if(True):
            a = "4 ± 2 cm" 
            b = Measure(value=3,unit=Unit("cm"))
            c = a*b
            c = None
            assert a == "4 ± 2 cm" 
            assert b == Measure(value=3,unit=Unit("cm"))
      # Str Measure (Implicit Error) * Measure (Explicit Error) = Measure (Implicit Error)
      if(True):
        # Unitless * Unitless
        if(True):
          # PASS:   Str Implicit Error Unitless Measures are indistinguishable from Numbers.
          pass
        # Unitless * Unit
        if(True):
          # PASS:   Str Implicit Error Unitless Measures are indistinguishable from Numbers.
          pass
        # Unit * Unitless
        if(True):
          # Normal Units
          if(True):
            # Value 1: Int
            assert isinstance( ( "4 cm"  *  Measure(value=3,error=2)  ), Measure )
            error = measure._sqrt_( (Decimal(4)**2 * Decimal("2")**2 + Decimal(3)**2 * Decimal("0.5")**2) )
            assert (  "4 cm"  *  Measure(value=3,error=2)  ).value   == 12
            assert (  "4 cm"  *  Measure(value=3,error=2)  ).error   == error
            assert (  "4 cm"  *  Measure(value=3,error=2)  ).implied == True
            assert (  "4 cm"  *  Measure(value=3,error=2)  ).units.symbols   == Unit("cm").symbols
            assert (  "4 cm"  *  Measure(value=3,error=2)  ).units.magnitude == Unit("cm").magnitude
            assert (  "4 cm"  *  Measure(value=3,error=2)  ) == Measure(units=Unit("cm"), value= 12, error=error)
            # Value 2: Float
            assert isinstance( ( "0.4 cm"  *  Measure(value=0.3,error=0.2)  ), Measure )
            error = measure._sqrt_( (0.4**2 * 0.2**2 + 0.3**2 * 0.05**2) )
            assert math.isclose( (  "0.4 cm"  *  Measure(value=0.3,error=0.2)  ).value , 0.3*0.4 )
            assert math.isclose( (  "0.4 cm"  *  Measure(value=0.3,error=0.2)  ).error , error   )
            assert (  "0.4 cm"  *  Measure(value=0.3,error=0.2)  ).implied == True
            assert (  "0.4 cm"  *  Measure(value=0.3,error=0.2)  ).units.symbols   == Unit("cm").symbols
            assert (  "0.4 cm"  *  Measure(value=0.3,error=0.2)  ).units.magnitude == Unit("cm").magnitude
            assert (  "0.4 cm"  *  Measure(value=0.3,error=0.2)  ) == Measure(units=Unit("cm"), value= 0.3*0.4, error=error)
            # Value 3: Decimal
            assert isinstance( (  "40 cm"  *  Measure(value=Decimal("30"),error=Decimal("20"))  ), Measure )
            error = measure._sqrt_( ( Decimal("40")**2 * Decimal("20")**2 + Decimal("30")**2 * Decimal("5")**2) )
            assert (  "40 cm"  *  Measure(value=Decimal("30"),error=Decimal("20"))  ).value   == Decimal("1200")
            assert (  "40 cm"  *  Measure(value=Decimal("30"),error=Decimal("20"))  ).error   == error
            assert (  "40 cm"  *  Measure(value=Decimal("30"),error=Decimal("20"))  ).implied == True
            assert (  "40 cm"  *  Measure(value=Decimal("30"),error=Decimal("20"))  ).units.symbols   == Unit("cm").symbols
            assert (  "40 cm"  *  Measure(value=Decimal("30"),error=Decimal("20"))  ).units.magnitude == Unit("cm").magnitude
            assert (  "40 cm"  *  Measure(value=Decimal("30"),error=Decimal("20"))  ) == Measure(units=Unit("cm"), value= Decimal("1200"), error=error)
            # Value 4: Negative
            assert isinstance( ( "-4 cm"  *  Measure(value=-3,error=2)  ), Measure )
            error = measure._sqrt_( (Decimal(4)**2 * Decimal("2")**2 + Decimal(3)**2 * Decimal("0.5")**2) )
            assert (  "-4 cm"  *  Measure(value=-3,error=2)  ).value   == 12
            assert (  "-4 cm"  *  Measure(value=-3,error=2)  ).error   == error
            assert (  "-4 cm"  *  Measure(value=-3,error=2)  ).implied == True
            assert (  "-4 cm"  *  Measure(value=-3,error=2)  ).units.symbols   == Unit("cm").symbols
            assert (  "-4 cm"  *  Measure(value=-3,error=2)  ).units.magnitude == Unit("cm").magnitude
            assert (  "-4 cm"  *  Measure(value=-3,error=2)  ) == Measure(units=Unit("cm"), value= 12, error=error)
          # Magnitude Units
          if(True):
            # Value 1: Int
            assert isinstance( (  "2 * 5 m^2"  *  Measure(value=5,error=1)  ) , Measure )
            error = measure._sqrt_( (Decimal(5)**2 * Decimal("2.5")**2 + Decimal(10)**2 * Decimal(1)**2) )/Decimal(5)
            assert (  "2 * 5 m^2"  *  Measure(value=5,error=1)  ) == Measure(units=Unit("5 m^2"), value=10, error=error)
            assert (  "2 * 5 m^2"  *  Measure(value=5,error=1)  ).value   == 10
            assert Measure._dec_isclose_( (  "2 * 5 m^2"  *  Measure(value=5,error=1)  ).error  , error )
            assert (  "2 * 5 m^2"  *  Measure(value=5,error=1)  ).implied == True
            assert (  "2 * 5 m^2"  *  Measure(value=5,error=1)  ).units.symbols   == Unit("5 m^2").symbols
            assert (  "2 * 5 m^2"  *  Measure(value=5,error=1)  ).units.magnitude == Unit("5 m^2").magnitude
            # Value 2: Float
            assert isinstance( (  "0.2 * 5 m^2"  *  Measure(value=0.5,error=0.1)  ) , Measure )
            error = measure._sqrt_( (0.5**2 * 0.25**2 + 1.0**2 * 0.1**2) )/5
            assert (  "0.2 * 5 m^2"  *  Measure(value=0.5,error=0.1)  ) == Measure(units=Unit("5 m^2"), value=0.1, error=error)
            assert math.isclose( (  "0.2 * 5 m^2"  *  Measure(value=0.5,error=0.1)  ).value , 0.1   )
            assert math.isclose( (  "0.2 * 5 m^2"  *  Measure(value=0.5,error=0.1)  ).error , error )
            assert (  "0.2 * 5 m^2"  *  Measure(value=0.5,error=0.1)  ).implied == True
            assert (  "0.2 * 5 m^2"  *  Measure(value=0.5,error=0.1)  ).units.symbols   == Unit("5 m^2").symbols
            assert (  "0.2 * 5 m^2"  *  Measure(value=0.5,error=0.1)  ).units.magnitude == Unit("5 m^2").magnitude
            # Value 3: Decimal
            assert isinstance( (  "20 * 5 m^2"  *  Measure(value=Decimal("50"),error=Decimal("2"))  ) , Measure )
            error = measure._sqrt_( (Decimal("50")**2 * Decimal("25")**2 + Decimal("100")**2 * Decimal("2")**2) )/Decimal("5")
            assert (  "20 * 5 m^2"  *  Measure(value=Decimal("50"),error=Decimal("2"))  ) == Measure(units=Unit("5 m^2"), value=Decimal("1000"), error=error)
            assert (  "20 * 5 m^2"  *  Measure(value=Decimal("50"),error=Decimal("2"))  ).value   == Decimal("1000")
            assert (  "20 * 5 m^2"  *  Measure(value=Decimal("50"),error=Decimal("2"))  ).error   == error
            assert (  "20 * 5 m^2"  *  Measure(value=Decimal("50"),error=Decimal("2"))  ).implied == True
            assert (  "20 * 5 m^2"  *  Measure(value=Decimal("50"),error=Decimal("2"))  ).units.symbols   == Unit("5 m^2").symbols
            assert (  "20 * 5 m^2"  *  Measure(value=Decimal("50"),error=Decimal("2"))  ).units.magnitude == Unit("5 m^2").magnitude
            # Value 4: Negative
            assert isinstance( (  "-2 * 5 m^2"  *  Measure(value=-5,error=1)  ) , Measure )
            error = measure._sqrt_( (Decimal(5)**2 * Decimal("2.5")**2 + Decimal(10)**2 * Decimal(1)**2) )/Decimal(5)
            assert (  "-2 * 5 m^2"  *  Measure(value=-5,error=1)  ) == Measure(units=Unit("5 m^2"), value=10, error=error)
            assert (  "-2 * 5 m^2"  *  Measure(value=-5,error=1)  ).value   == 10
            assert Measure._dec_isclose_( (  "-2 * 5 m^2"  *  Measure(value=-5,error=1)  ).error   , error )
            assert (  "-2 * 5 m^2"  *  Measure(value=-5,error=1)  ).implied == True
            assert (  "-2 * 5 m^2"  *  Measure(value=-5,error=1)  ).units.symbols   == Unit("5 m^2").symbols
            assert (  "-2 * 5 m^2"  *  Measure(value=-5,error=1)  ).units.magnitude == Unit("5 m^2").magnitude
          # Convoluted Units
          if(True):
            # Value 1: Int
            assert isinstance( ( "27 \u00B0C"  *  Measure(value=300,error=2) ), Measure )
            error = measure._sqrt_( (Decimal("300")**2 * Decimal("0.5")**2 + Decimal("300.15")**2 * Decimal("2")**2) )
            assert ( "27 \u00B0C"  *  Measure(value=300,error=2) ).value   == Decimal("300.15")*Decimal("300") - Decimal("273.15")
            assert ( "27 \u00B0C"  *  Measure(value=300,error=2) ).error   == error
            assert ( "27 \u00B0C"  *  Measure(value=300,error=2) ).implied == True
            assert ( "27 \u00B0C"  *  Measure(value=300,error=2) ).units.symbols   == Unit("\u00B0C").symbols
            assert ( "27 \u00B0C"  *  Measure(value=300,error=2) ).units.magnitude == Unit("\u00B0C").magnitude
            assert ( "27 \u00B0C"  *  Measure(value=300,error=2) ) == Measure(units=Unit("\u00B0C"), value= Decimal("300.15")*Decimal("300") - Decimal("273.15"), error=error)
            # Value 2: Float
            assert isinstance( ( "26.85 \u00B0C"  *  Measure(value=299.9,error=0.02) ), Measure )
            error = measure._sqrt_( (299.9**2 * 0.005**2 + 300**2 * 0.02**2) )
            assert math.isclose( ( "26.85 \u00B0C"  *  Measure(value=299.9,error=0.02) ).value , 299.9 * 300 - 273.15 )
            assert math.isclose( ( "26.85 \u00B0C"  *  Measure(value=299.9,error=0.02) ).error , error )
            assert ( "26.85 \u00B0C"  *  Measure(value=299.9,error=0.02) ).implied == True
            assert ( "26.85 \u00B0C"  *  Measure(value=299.9,error=0.02) ).units.symbols   == Unit("\u00B0C").symbols
            assert ( "26.85 \u00B0C"  *  Measure(value=299.9,error=0.02) ).units.magnitude == Unit("\u00B0C").magnitude
            assert ( "26.85 \u00B0C"  *  Measure(value=299.9,error=0.02) ) == Measure(units=Unit("\u00B0C"), value=299.9 * 300 - 273.15, error=error)
            # Value 3: Decimal
            assert isinstance( ( "26.85 \u00B0C"  *  Measure(value=Decimal("300"),error=Decimal("0.02")) ), Measure )
            error = measure._sqrt_( (Decimal("300")**2 * Decimal("0.005")**2 + Decimal("300")**2 * Decimal("0.02")**2) )
            assert ( "26.85 \u00B0C"  *  Measure(value=Decimal("300"),error=Decimal("0.02")) ).value   == Decimal("300") * Decimal("300") - Decimal("273.15") 
            assert ( "26.85 \u00B0C"  *  Measure(value=Decimal("300"),error=Decimal("0.02")) ).error   == error
            assert ( "26.85 \u00B0C"  *  Measure(value=Decimal("300"),error=Decimal("0.02")) ).implied == True
            assert ( "26.85 \u00B0C"  *  Measure(value=Decimal("300"),error=Decimal("0.02")) ).units.symbols   == Unit("\u00B0C").symbols
            assert ( "26.85 \u00B0C"  *  Measure(value=Decimal("300"),error=Decimal("0.02")) ).units.magnitude == Unit("\u00B0C").magnitude
            assert ( "26.85 \u00B0C"  *  Measure(value=Decimal("300"),error=Decimal("0.02")) ) == Measure(units=Unit("\u00B0C"), value=Decimal("300") * Decimal("300") - Decimal("273.15"), error=error)
            # Value 4: Negative
            assert isinstance( ( "-27 \u00B0C"  *  Measure(value=300,error=2) ), Measure )
            error = measure._sqrt_( (Decimal("300")**2 * Decimal("0.5")**2 + Decimal("246.15")**2 * Decimal("2")**2) )
            assert ( "-27 \u00B0C"  *  Measure(value=300,error=2) ).value   == Decimal("246.15")*Decimal("300") - Decimal("273.15")
            assert ( "-27 \u00B0C"  *  Measure(value=300,error=2) ).error   == error
            assert ( "-27 \u00B0C"  *  Measure(value=300,error=2) ).implied == True
            assert ( "-27 \u00B0C"  *  Measure(value=300,error=2) ).units.symbols   == Unit("\u00B0C").symbols
            assert ( "-27 \u00B0C"  *  Measure(value=300,error=2) ).units.magnitude == Unit("\u00B0C").magnitude
            assert ( "-27 \u00B0C"  *  Measure(value=300,error=2) ) == Measure(units=Unit("\u00B0C"), value= Decimal("246.15")*Decimal("300") - Decimal("273.15"), error=error)
          # Preserve Inputs
          if(True):
            a = "4 cm"
            b = Measure(value=3,error=2)
            c = a*b
            c = None
            assert a == "4 cm" 
            assert b == Measure(value=3,error=2)
        # Units * Units
        if(True):
          # Normal Units
          if(True):
            # Value 1: Int
            assert isinstance( ( "4 cm"  *  Measure(value=3,error=2,unit=Unit("cm"))  ), Measure )
            error = measure._sqrt_( (Decimal(4)**2 * Decimal("2")**2 + Decimal(3)**2 * Decimal("0.5")**2) )
            assert (  "4 cm"  *  Measure(value=3,error=2,unit=Unit("cm"))  ).value   == 12
            assert (  "4 cm"  *  Measure(value=3,error=2,unit=Unit("cm"))  ).error   == error
            assert (  "4 cm"  *  Measure(value=3,error=2,unit=Unit("cm"))  ).implied == True
            assert (  "4 cm"  *  Measure(value=3,error=2,unit=Unit("cm"))  ).units.symbols   == Unit("cm^2").symbols
            assert (  "4 cm"  *  Measure(value=3,error=2,unit=Unit("cm"))  ).units.magnitude == Unit("cm^2").magnitude
            assert (  "4 cm"  *  Measure(value=3,error=2,unit=Unit("cm"))  ) == Measure(units=Unit("cm^2"), value= 12, error=error)
            # Value 2: Float
            assert isinstance( ( "0.4 cm"  *  Measure(value=0.3,error=0.2,unit=Unit("cm"))  ), Measure )
            error = measure._sqrt_( (0.4**2 * 0.2**2 + 0.3**2 * 0.05**2) )
            assert math.isclose( (  "0.4 cm"  *  Measure(value=0.3,error=0.2,unit=Unit("cm"))  ).value , 0.3*0.4 )
            assert math.isclose( (  "0.4 cm"  *  Measure(value=0.3,error=0.2,unit=Unit("cm"))  ).error , error   )
            assert (  "0.4 cm"  *  Measure(value=0.3,error=0.2,unit=Unit("cm"))  ).implied == True
            assert (  "0.4 cm"  *  Measure(value=0.3,error=0.2,unit=Unit("cm"))  ).units.symbols   == Unit("cm^2").symbols
            assert (  "0.4 cm"  *  Measure(value=0.3,error=0.2,unit=Unit("cm"))  ).units.magnitude == Unit("cm^2").magnitude
            assert (  "0.4 cm"  *  Measure(value=0.3,error=0.2,unit=Unit("cm"))  ) == Measure(units=Unit("cm^2"), value= 0.3*0.4, error=error)
            # Value 3: Decimal
            assert isinstance( (  "40 cm"  *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm"))  ), Measure )
            error = measure._sqrt_( ( Decimal("40")**2 * Decimal("20")**2 + Decimal("30")**2 * Decimal("5")**2) )
            assert (  "40 cm"  *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm"))  ).value   == Decimal("1200")
            assert (  "40 cm"  *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm"))  ).error   == error
            assert (  "40 cm"  *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm"))  ).implied == True
            assert (  "40 cm"  *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm"))  ).units.symbols   == Unit("cm^2").symbols
            assert (  "40 cm"  *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm"))  ).units.magnitude == Unit("cm^2").magnitude
            assert (  "40 cm"  *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm"))  ) == Measure(units=Unit("cm^2"), value= Decimal("1200"), error=error)
            # Value 4: Negative
            assert isinstance( ( "-4 cm"  *  Measure(value=-3,error=2,unit=Unit("cm"))  ), Measure )
            error = measure._sqrt_( (Decimal(4)**2 * Decimal("2")**2 + Decimal(3)**2 * Decimal("0.5")**2) )
            assert (  "-4 cm"  *  Measure(value=-3,error=2,unit=Unit("cm"))  ).value   == 12
            assert (  "-4 cm"  *  Measure(value=-3,error=2,unit=Unit("cm"))  ).error   == error
            assert (  "-4 cm"  *  Measure(value=-3,error=2,unit=Unit("cm"))  ).implied == True
            assert (  "-4 cm"  *  Measure(value=-3,error=2,unit=Unit("cm"))  ).units.symbols   == Unit("cm^2").symbols
            assert (  "-4 cm"  *  Measure(value=-3,error=2,unit=Unit("cm"))  ).units.magnitude == Unit("cm^2").magnitude
            assert (  "-4 cm"  *  Measure(value=-3,error=2,unit=Unit("cm"))  ) == Measure(units=Unit("cm^2"), value= 12, error=error)
          # Magnitude Units
          if(True):
            # Value 1: Int
            assert isinstance( (  "2 * 5 m^2"  *  Measure(value=5,error=1,unit=Unit("5 m^2"))  ) , Measure )
            error = measure._sqrt_( (Decimal(25)**2 * Decimal("2.5")**2 + Decimal(10)**2 * Decimal(5)**2) )/Decimal(25)
            assert (  "2 * 5 m^2"  *  Measure(value=5,error=1,unit=Unit("5 m^2"))  ).value   == 10
            assert (  "2 * 5 m^2"  *  Measure(value=5,error=1,unit=Unit("5 m^2"))  ).error   == error
            assert (  "2 * 5 m^2"  *  Measure(value=5,error=1,unit=Unit("5 m^2"))  ).implied == True
            assert (  "2 * 5 m^2"  *  Measure(value=5,error=1,unit=Unit("5 m^2"))  ).units.symbols   == Unit("25 m^4").symbols
            assert (  "2 * 5 m^2"  *  Measure(value=5,error=1,unit=Unit("5 m^2"))  ).units.magnitude == Unit("25 m^4").magnitude
            assert (  "2 * 5 m^2"  *  Measure(value=5,error=1,unit=Unit("5 m^2"))  ) == Measure(units=Unit("25 m^4"), value=10, error=error)
            # Value 2: Float
            assert isinstance( (  "0.2 * 5 m^2"  *  Measure(value=0.5,error=0.1,unit=Unit("5 m^4"))  ) , Measure )
            error = measure._sqrt_( (2.5**2 * 0.25**2 + 1.0**2 * 0.5**2) )/25
            assert math.isclose( (  "0.2 * 5 m^2"  *  Measure(value=0.5,error=0.1,unit=Unit("5 m^2"))  ).value , 0.1   )
            assert math.isclose( (  "0.2 * 5 m^2"  *  Measure(value=0.5,error=0.1,unit=Unit("5 m^2"))  ).error , error )
            assert (  "0.2 * 5 m^2"  *  Measure(value=0.5,error=0.1,unit=Unit("5 m^2"))  ).implied == True
            assert (  "0.2 * 5 m^2"  *  Measure(value=0.5,error=0.1,unit=Unit("5 m^2"))  ).units.symbols   == Unit("25 m^4").symbols
            assert (  "0.2 * 5 m^2"  *  Measure(value=0.5,error=0.1,unit=Unit("5 m^2"))  ).units.magnitude == Unit("25 m^4").magnitude
            assert (  "0.2 * 5 m^2"  *  Measure(value=0.5,error=0.1,unit=Unit("5 m^2"))  ) == Measure(units=Unit("25 m^4"), value=0.1, error=error)
            # Value 3: Decimal
            assert isinstance( (  "20 * 5 m^2"  *  Measure(value=Decimal("50"),error=Decimal("2"),unit=Unit("5 m^2"))  ) , Measure )
            error = measure._sqrt_( (Decimal("250")**2 * Decimal("25")**2 + Decimal("100")**2 * Decimal("10")**2) )/Decimal("25")
            assert (  "20 * 5 m^2"  *  Measure(value=Decimal("50"),error=Decimal("2"),unit=Unit("5 m^2"))  ) == Measure(units=Unit("25 m^4"), value=Decimal("1000"), error=error)
            assert (  "20 * 5 m^2"  *  Measure(value=Decimal("50"),error=Decimal("2"),unit=Unit("5 m^2"))  ).value   == Decimal("1000")
            assert (  "20 * 5 m^2"  *  Measure(value=Decimal("50"),error=Decimal("2"),unit=Unit("5 m^2"))  ).error   == error
            assert (  "20 * 5 m^2"  *  Measure(value=Decimal("50"),error=Decimal("2"),unit=Unit("5 m^2"))  ).implied == True
            assert (  "20 * 5 m^2"  *  Measure(value=Decimal("50"),error=Decimal("2"),unit=Unit("5 m^2"))  ).units.symbols   == Unit("25 m^4").symbols
            assert (  "20 * 5 m^2"  *  Measure(value=Decimal("50"),error=Decimal("2"),unit=Unit("5 m^2"))  ).units.magnitude == Unit("25 m^4").magnitude
            # Value 4: Negative
            assert isinstance( (  "-2 * 5 m^2"  *  Measure(value=-5,error=1,unit=Unit("5 m^2"))  ) , Measure )
            error = measure._sqrt_( (Decimal(25)**2 * Decimal("2.5")**2 + Decimal(10)**2 * Decimal(5)**2) )/Decimal(25)
            assert (  "-2 * 5 m^2"  *  Measure(value=-5,error=1,unit=Unit("5 m^2"))  ) == Measure(units=Unit("25 m^4"), value=10, error=error)
            assert (  "-2 * 5 m^2"  *  Measure(value=-5,error=1,unit=Unit("5 m^2"))  ).value   == 10
            assert (  "-2 * 5 m^2"  *  Measure(value=-5,error=1,unit=Unit("5 m^2"))  ).error   == error
            assert (  "-2 * 5 m^2"  *  Measure(value=-5,error=1,unit=Unit("5 m^2"))  ).implied == True
            assert (  "-2 * 5 m^2"  *  Measure(value=-5,error=1,unit=Unit("5 m^2"))  ).units.symbols   == Unit("25 m^4").symbols
            assert (  "-2 * 5 m^2"  *  Measure(value=-5,error=1,unit=Unit("5 m^2"))  ).units.magnitude == Unit("25 m^4").magnitude
          # Convoluted Units
          if(True):
            # Value 1: Int
            assert isinstance( ( "27 \u00B0C"  *  Measure(value=27,error=2,unit=Unit("\u00B0C")) ), Measure )
            error = measure._sqrt_( (Decimal("300.15")**2 * Decimal("0.5")**2 + Decimal("300.15")**2 * Decimal("2")**2) )
            assert ( "27 \u00B0C"  *  Measure(value=27,error=2,unit=Unit("\u00B0C")) ).value   == Decimal("300.15")*Decimal("300.15")
            assert ( "27 \u00B0C"  *  Measure(value=27,error=2,unit=Unit("\u00B0C")) ).error   == error
            assert ( "27 \u00B0C"  *  Measure(value=27,error=2,unit=Unit("\u00B0C")) ).implied == True
            assert ( "27 \u00B0C"  *  Measure(value=27,error=2,unit=Unit("\u00B0C")) ).units.symbols   == Unit("K^2").symbols
            assert ( "27 \u00B0C"  *  Measure(value=27,error=2,unit=Unit("\u00B0C")) ).units.magnitude == Unit("K^2").magnitude
            assert ( "27 \u00B0C"  *  Measure(value=27,error=2,unit=Unit("\u00B0C")) ) == Measure(units=Unit("K^2"), value= Decimal("300.15")*Decimal("300.15"), error=error)
            # Value 2: Float
            assert isinstance( ( "26.85 \u00B0C"  *  Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ), Measure )
            error = measure._sqrt_( (300**2 * 0.005**2 + 300**2 * 0.02**2) )
            assert math.isclose( ( "26.85 \u00B0C"  *  Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).value   , 300 * 300 )
            assert math.isclose( ( "26.85 \u00B0C"  *  Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).error   , error )
            assert ( "26.85 \u00B0C"  *  Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).implied == True 
            assert ( "26.85 \u00B0C"  *  Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).units.symbols   == Unit("K^2").symbols
            assert ( "26.85 \u00B0C"  *  Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).units.magnitude == Unit("K^2").magnitude
            assert ( "26.85 \u00B0C"  *  Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ) == Measure(units=Unit("K^2"), value=300 * 300, error=error)
            # Value 3: Decimal
            assert isinstance( ( "26.85 \u00B0C"  *  Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ), Measure )
            error = measure._sqrt_( (Decimal("300")**2 * Decimal("0.005")**2 + Decimal("300")**2 * Decimal("0.02")**2) )
            assert ( "26.85 \u00B0C"  *  Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).value   == Decimal("300") * Decimal("300") 
            assert ( "26.85 \u00B0C"  *  Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).error   == error
            assert ( "26.85 \u00B0C"  *  Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).implied == True
            assert ( "26.85 \u00B0C"  *  Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).units.symbols   == Unit("K^2").symbols
            assert ( "26.85 \u00B0C"  *  Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).units.magnitude == Unit("K^2").magnitude
            assert ( "26.85 \u00B0C"  *  Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ) == Measure(units=Unit("K^2"), value=Decimal("300") * Decimal("300"), error=error)
            # Value 4: Negative
            assert isinstance( ( "-27 \u00B0C"  *  Measure(value=-27,error=2,unit=Unit("\u00B0C")) ), Measure )
            error = measure._sqrt_( (Decimal("246.15")**2 * Decimal("0.5")**2 + Decimal("246.15")**2 * Decimal("2")**2) )
            assert ( "-27 \u00B0C"  *  Measure(value=-27,error=2,unit=Unit("\u00B0C")) ).value   == Decimal("246.15")*Decimal("246.15")
            assert ( "-27 \u00B0C"  *  Measure(value=-27,error=2,unit=Unit("\u00B0C")) ).error   == error
            assert ( "-27 \u00B0C"  *  Measure(value=-27,error=2,unit=Unit("\u00B0C")) ).implied == True
            assert ( "-27 \u00B0C"  *  Measure(value=-27,error=2,unit=Unit("\u00B0C")) ).units.symbols   == Unit("K^2").symbols
            assert ( "-27 \u00B0C"  *  Measure(value=-27,error=2,unit=Unit("\u00B0C")) ).units.magnitude == Unit("K^2").magnitude
            assert ( "-27 \u00B0C"  *  Measure(value=-27,error=2,unit=Unit("\u00B0C")) ) == Measure(units=Unit("K^2"), value= Decimal("246.15")*Decimal("246.15"), error=error)
          # Canceling Units
          if(True):
            # Value 1: Int
            assert isinstance( ( "4 cm"  *  Measure(value=3,error=2,unit=Unit("cm^-1"))  ), Measure )
            error = measure._sqrt_( (Decimal(4)**2 * Decimal("2")**2 + Decimal(3)**2 * Decimal("0.5")**2) )
            assert (  "4 cm"  *  Measure(value=3,error=2,unit=Unit("cm^-1"))  ).value   == 12
            assert (  "4 cm"  *  Measure(value=3,error=2,unit=Unit("cm^-1"))  ).error   == error
            assert (  "4 cm"  *  Measure(value=3,error=2,unit=Unit("cm^-1"))  ).implied == True
            assert (  "4 cm"  *  Measure(value=3,error=2,unit=Unit("cm^-1"))  ).units.symbols   == Unit().symbols
            assert (  "4 cm"  *  Measure(value=3,error=2,unit=Unit("cm^-1"))  ).units.magnitude == Unit().magnitude
            assert (  "4 cm"  *  Measure(value=3,error=2,unit=Unit("cm^-1"))  ) == Measure(units=Unit(), value= 12, error=error)
            # Value 2: Float
            assert isinstance( ( "0.4 cm"  *  Measure(value=0.3,error=0.2,unit=Unit("cm^-1"))  ), Measure )
            error = measure._sqrt_( (0.4**2 * 0.2**2 + 0.3**2 * 0.05**2) )
            assert math.isclose( (  "0.4 cm"  *  Measure(value=0.3,error=0.2,unit=Unit("cm^-1"))  ).value , 0.3*0.4 )
            assert math.isclose( (  "0.4 cm"  *  Measure(value=0.3,error=0.2,unit=Unit("cm^-1"))  ).error , error   )
            assert (  "0.4 cm"  *  Measure(value=0.3,error=0.2,unit=Unit("cm^-1"))  ).implied == True
            assert (  "0.4 cm"  *  Measure(value=0.3,error=0.2,unit=Unit("cm^-1"))  ).units.symbols   == Unit().symbols
            assert (  "0.4 cm"  *  Measure(value=0.3,error=0.2,unit=Unit("cm^-1"))  ).units.magnitude == Unit().magnitude
            assert (  "0.4 cm"  *  Measure(value=0.3,error=0.2,unit=Unit("cm^-1"))  ) == Measure(units=Unit(), value= 0.3*0.4, error=error)
            # Value 3: Decimal
            assert isinstance( (  "40 cm"  *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm^-1"))  ), Measure )
            error = measure._sqrt_( ( Decimal("40")**2 * Decimal("20")**2 + Decimal("30")**2 * Decimal("5")**2) )
            assert (  "40 cm"  *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm^-1"))  ).value   == Decimal("1200")
            assert (  "40 cm"  *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm^-1"))  ).error   == error
            assert (  "40 cm"  *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm^-1"))  ).implied == True
            assert (  "40 cm"  *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm^-1"))  ).units.symbols   == Unit().symbols
            assert (  "40 cm"  *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm^-1"))  ).units.magnitude == Unit().magnitude
            assert (  "40 cm"  *  Measure(value=Decimal("30"),error=Decimal("20"),unit=Unit("cm^-1"))  ) == Measure(units=Unit(), value= Decimal("1200"), error=error)
            # Value 4: Negative
            assert isinstance( ( "-4 cm"  *  Measure(value=-3,error=2,unit=Unit("cm^-1"))  ), Measure )
            error = measure._sqrt_( (Decimal(4)**2 * Decimal("2")**2 + Decimal(3)**2 * Decimal("0.5")**2) )
            assert (  "-4 cm"  *  Measure(value=-3,error=2,unit=Unit("cm^-1"))  ).value   == 12
            assert (  "-4 cm"  *  Measure(value=-3,error=2,unit=Unit("cm^-1"))  ).error   == error
            assert (  "-4 cm"  *  Measure(value=-3,error=2,unit=Unit("cm^-1"))  ).implied == True
            assert (  "-4 cm"  *  Measure(value=-3,error=2,unit=Unit("cm^-1"))  ).units.symbols   == Unit().symbols
            assert (  "-4 cm"  *  Measure(value=-3,error=2,unit=Unit("cm^-1"))  ).units.magnitude == Unit().magnitude
            assert (  "-4 cm"  *  Measure(value=-3,error=2,unit=Unit("cm^-1"))  ) == Measure(units=Unit(), value= 12, error=error)
          # Preserve Inputs
          if(True):
            a = "4 cm"
            b = Measure(value=3,error=2,unit=Unit("cm"))
            c = a*b
            c = None
            assert a == "4 cm"
            assert b == Measure(value=3,error=2,unit=Unit("cm"))
      # Str Measure (Implicit Error) * Measure (Implicit Error) = Measure (Implicit Error)
      if(True):
        # Unitless * Unitless
        if(True):
          # PASS:   Str Implicit Error Unitless Measures are indistinguishable from Numbers.
          pass 
        # Unitless * Unit
        if(True):
          # PASS:   Str Implicit Error Unitless Measures are indistinguishable from Numbers.
          pass
        # Unit * Unitless
        if(True):
          # Normal Units
          if(True):
            # Value 1: Int
            assert isinstance( ( "4 cm"  *  Measure(value=3)  ), Measure )
            error = measure._sqrt_( (Decimal("4")**2 * Decimal("0.5")**2 + Decimal("3")**2 * Decimal("0.5")**2) )
            assert (  "4 cm"  *  Measure(value=3)  ).value   == 12
            assert (  "4 cm"  *  Measure(value=3)  ).error   == error
            assert (  "4 cm"  *  Measure(value=3)  ).implied == True
            assert (  "4 cm"  *  Measure(value=3)  ).units.symbols   == Unit("cm").symbols
            assert (  "4 cm"  *  Measure(value=3)  ).units.magnitude == Unit("cm").magnitude
            assert (  "4 cm"  *  Measure(value=3)  ) == Measure(units=Unit("cm"), value= 12, error=error)
            # Value 2: Float
            assert isinstance( ( "0.4 cm"  *  Measure(value=0.3)  ), Measure )
            error = measure._sqrt_( (0.4**2 * 0.05**2 + 0.3**2 * 0.05**2) )
            assert math.isclose( (  "0.4 cm"  *  Measure(value=0.3)  ).value , 0.3*0.4 )
            assert math.isclose( (  "0.4 cm"  *  Measure(value=0.3)  ).error , error   )
            assert (  "0.4 cm"  *  Measure(value=0.3)  ).implied == True
            assert (  "0.4 cm"  *  Measure(value=0.3)  ).units.symbols   == Unit("cm").symbols
            assert (  "0.4 cm"  *  Measure(value=0.3)  ).units.magnitude == Unit("cm").magnitude
            assert (  "0.4 cm"  *  Measure(value=0.3)  ) == Measure(units=Unit("cm"), value= 0.3*0.4, error=error)
            # Value 3: Decimal
            assert isinstance( (  "40 cm"  *  Measure(value=Decimal("30"))  ), Measure )
            error = measure._sqrt_( (Decimal("40")**2 * Decimal("5")**2 + Decimal("30")**2 * Decimal("5")**2) )
            assert (  "40 cm"  *  Measure(value=Decimal("30"))  ).value   == Decimal("1200")
            assert (  "40 cm"  *  Measure(value=Decimal("30"))  ).error   == error
            assert (  "40 cm"  *  Measure(value=Decimal("30"))  ).implied == True
            assert (  "40 cm"  *  Measure(value=Decimal("30"))  ).units.symbols   == Unit("cm").symbols
            assert (  "40 cm"  *  Measure(value=Decimal("30"))  ).units.magnitude == Unit("cm").magnitude
            assert (  "40 cm"  *  Measure(value=Decimal("30"))  ) == Measure(units=Unit("cm"), value= Decimal("1200"), error=error)
            # Value 4: Negative
            assert isinstance( ( "-4 cm"  *  Measure(value=-3)  ), Measure )
            error = measure._sqrt_( (Decimal("4")**2 * Decimal("0.5")**2 + Decimal("3")**2 * Decimal("0.5")**2) )
            assert (  "-4 cm"  *  Measure(value=-3)  ).value   == 12
            assert (  "-4 cm"  *  Measure(value=-3)  ).error   == error
            assert (  "-4 cm"  *  Measure(value=-3)  ).implied == True
            assert (  "-4 cm"  *  Measure(value=-3)  ).units.symbols   == Unit("cm").symbols
            assert (  "-4 cm"  *  Measure(value=-3)  ).units.magnitude == Unit("cm").magnitude
            assert (  "-4 cm"  *  Measure(value=-3)  ) == Measure(units=Unit("cm"), value= 12, error=error)
          # Magnitude Units
          if(True):
            # Value 1: Int
            assert isinstance( (  "2 * 5 m^2"  *  Measure(value=5)  ) , Measure )
            error = measure._sqrt_( (Decimal(5)**2 * Decimal("2.5")**2 + Decimal(10)**2 * Decimal("0.5")**2) )/Decimal(5)
            assert (  "2 * 5 m^2"  *  Measure(value=5)  ) == Measure(units=Unit("5 m^2"), value=10, error=error)
            assert (  "2 * 5 m^2"  *  Measure(value=5)  ).value   == 10
            assert (  "2 * 5 m^2"  *  Measure(value=5)  ).error   == error
            assert (  "2 * 5 m^2"  *  Measure(value=5)  ).implied == True
            assert (  "2 * 5 m^2"  *  Measure(value=5)  ).units.symbols   == Unit("5 m^2").symbols
            assert (  "2 * 5 m^2"  *  Measure(value=5)  ).units.magnitude == Unit("5 m^2").magnitude
            # Value 2: Float
            assert isinstance( (  "0.2 * 5 m^2"  *  Measure(value=0.5)  ) , Measure )
            error = measure._sqrt_( (0.5**2 * 0.25**2 + 1.0**2 * 0.05**2) )/5
            assert (  "0.2 * 5 m^2"  *  Measure(value=0.5)  ) == Measure(units=Unit("5 m^2"), value=0.1, error=error)
            assert math.isclose( (  "0.2 * 5 m^2"  *  Measure(value=0.5)  ).value , 0.1   )
            assert math.isclose( (  "0.2 * 5 m^2"  *  Measure(value=0.5)  ).error , error )
            assert (  "0.2 * 5 m^2"  *  Measure(value=0.5)  ).implied == True
            assert (  "0.2 * 5 m^2"  *  Measure(value=0.5)  ).units.symbols   == Unit("5 m^2").symbols
            assert (  "0.2 * 5 m^2"  *  Measure(value=0.5)  ).units.magnitude == Unit("5 m^2").magnitude
            # Value 3: Decimal
            assert isinstance( (  "20 * 5 m^2"  *  Measure(value=Decimal("50"))  ) , Measure )
            error = measure._sqrt_( (Decimal("50")**2 * Decimal("25")**2 + Decimal("100")**2 * Decimal("5")**2) )/Decimal("5")
            assert (  "20 * 5 m^2"  *  Measure(value=Decimal("50"))  ) == Measure(units=Unit("5 m^2"), value=Decimal("1000"), error=error)
            assert (  "20 * 5 m^2"  *  Measure(value=Decimal("50"))  ).value   == Decimal("1000")
            assert (  "20 * 5 m^2"  *  Measure(value=Decimal("50"))  ).error   == error
            assert (  "20 * 5 m^2"  *  Measure(value=Decimal("50"))  ).implied == True
            assert (  "20 * 5 m^2"  *  Measure(value=Decimal("50"))  ).units.symbols   == Unit("5 m^2").symbols
            assert (  "20 * 5 m^2"  *  Measure(value=Decimal("50"))  ).units.magnitude == Unit("5 m^2").magnitude
            # Value 4: Negative
            assert isinstance( (  "-2 * 5 m^2"  *  Measure(value=-5)  ) , Measure )
            error = measure._sqrt_( (Decimal(5)**2 * Decimal("2.5")**2 + Decimal(10)**2 * Decimal("0.5")**2) )/Decimal(5)
            assert (  "-2 * 5 m^2"  *  Measure(value=-5)  ) == Measure(units=Unit("5 m^2"), value=10, error=error)
            assert (  "-2 * 5 m^2"  *  Measure(value=-5)  ).value   == 10
            assert (  "-2 * 5 m^2"  *  Measure(value=-5)  ).error   == error
            assert (  "-2 * 5 m^2"  *  Measure(value=-5)  ).implied == True
            assert (  "-2 * 5 m^2"  *  Measure(value=-5)  ).units.symbols   == Unit("5 m^2").symbols
            assert (  "-2 * 5 m^2"  *  Measure(value=-5)  ).units.magnitude == Unit("5 m^2").magnitude
          # Convoluted Units
          if(True):
            # Value 1: Int
            assert isinstance( ( "27 \u00B0C"  *  Measure(value=300) ), Measure )
            error = measure._sqrt_( (Decimal("300")**2 * Decimal("0.5")**2 + Decimal("300.15")**2 * Decimal("50")**2) )
            assert ( "27 \u00B0C"  *  Measure(value=300) ).value   == Decimal("300.15")*Decimal("300") - Decimal("273.15")
            assert ( "27 \u00B0C"  *  Measure(value=300) ).error   == error
            assert ( "27 \u00B0C"  *  Measure(value=300) ).implied == True
            assert ( "27 \u00B0C"  *  Measure(value=300) ).units.symbols   == Unit("\u00B0C").symbols
            assert ( "27 \u00B0C"  *  Measure(value=300) ).units.magnitude == Unit("\u00B0C").magnitude
            assert ( "27 \u00B0C"  *  Measure(value=300) ) == Measure(units=Unit("\u00B0C"), value= Decimal("300.15")*Decimal("300") - Decimal("273.15"), error=error)
            # Value 2: Float
            assert isinstance( ( "26.85 \u00B0C"  *  Measure(value=299.9) ), Measure )
            error = measure._sqrt_( (299.9**2 * 0.005**2 + 300**2 * 0.05**2) )
            assert math.isclose( ( "26.85 \u00B0C"  *  Measure(value=299.9) ).value , 299.9 * 300 - 273.15 )
            assert math.isclose( ( "26.85 \u00B0C"  *  Measure(value=299.9) ).error , error )
            assert ( "26.85 \u00B0C"  *  Measure(value=299.9) ).implied == True
            assert ( "26.85 \u00B0C"  *  Measure(value=299.9) ).units.symbols   == Unit("\u00B0C").symbols
            assert ( "26.85 \u00B0C"  *  Measure(value=299.9) ).units.magnitude == Unit("\u00B0C").magnitude
            assert ( "26.85 \u00B0C"  *  Measure(value=299.9) ) == Measure(units=Unit("\u00B0C"), value=299.9 * 300 - 273.15, error=error)
            # Value 3: Decimal
            assert isinstance( ( "26.85 \u00B0C"  *  Measure(value=Decimal("300")) ), Measure )
            error = measure._sqrt_( (Decimal("300")**2 * Decimal("0.005")**2 + Decimal("300")**2 * Decimal("50")**2) )
            assert ( "26.85 \u00B0C"  *  Measure(value=Decimal("300")) ).value   == Decimal("300") * Decimal("300") - Decimal("273.15") 
            assert ( "26.85 \u00B0C"  *  Measure(value=Decimal("300")) ).error   == error
            assert ( "26.85 \u00B0C"  *  Measure(value=Decimal("300")) ).implied == True
            assert ( "26.85 \u00B0C"  *  Measure(value=Decimal("300")) ).units.symbols   == Unit("\u00B0C").symbols
            assert ( "26.85 \u00B0C"  *  Measure(value=Decimal("300")) ).units.magnitude == Unit("\u00B0C").magnitude
            assert ( "26.85 \u00B0C"  *  Measure(value=Decimal("300")) ) == Measure(units=Unit("\u00B0C"), value=Decimal("300") * Decimal("300") - Decimal("273.15"), error=error)
            # Value 4: Negative
            assert isinstance( ( "-27 \u00B0C"  *  Measure(value=300) ), Measure )
            error = measure._sqrt_( (Decimal("300")**2 * Decimal("0.5")**2 + Decimal("246.15")**2 * Decimal("50")**2) )
            assert ( "-27 \u00B0C"  *  Measure(value=300) ).value   == Decimal("246.15")*Decimal("300") - Decimal("273.15")
            assert ( "-27 \u00B0C"  *  Measure(value=300) ).error   == error
            assert ( "-27 \u00B0C"  *  Measure(value=300) ).implied == True
            assert ( "-27 \u00B0C"  *  Measure(value=300) ).units.symbols   == Unit("\u00B0C").symbols
            assert ( "-27 \u00B0C"  *  Measure(value=300) ).units.magnitude == Unit("\u00B0C").magnitude
            assert ( "-27 \u00B0C"  *  Measure(value=300) ) == Measure(units=Unit("\u00B0C"), value= Decimal("246.15")*Decimal("300") - Decimal("273.15"), error=error)
          # Preserve Inputs
          if(True):
            a = "4 cm"
            b = Measure(value=3)
            c = a*b
            c = None
            assert a == "4 cm" 
            assert b == Measure(value=3)
        # Units * Units
        if(True):
          # Normal Units
          if(True):
            # Value 1: Int
            assert isinstance( ( "4 cm"  *  Measure(value=3,unit=Unit("cm"))  ), Measure )
            error = measure._sqrt_( (Decimal("4")**2 * Decimal("0.5")**2 + Decimal("3")**2 * Decimal("0.5")**2) )
            assert (  "4 cm"  *  Measure(value=3,unit=Unit("cm"))  ).value   == 12
            assert (  "4 cm"  *  Measure(value=3,unit=Unit("cm"))  ).error   == error
            assert (  "4 cm"  *  Measure(value=3,unit=Unit("cm"))  ).implied == True
            assert (  "4 cm"  *  Measure(value=3,unit=Unit("cm"))  ).units.symbols   == Unit("cm^2").symbols
            assert (  "4 cm"  *  Measure(value=3,unit=Unit("cm"))  ).units.magnitude == Unit("cm^2").magnitude
            assert (  "4 cm"  *  Measure(value=3,unit=Unit("cm"))  ) == Measure(units=Unit("cm^2"), value= 12, error=error)
            # Value 2: Float
            assert isinstance( ( "0.4 cm"  *  Measure(value=0.3,unit=Unit("cm"))  ), Measure )
            error = measure._sqrt_( (0.4**2 * 0.05**2 + 0.3**2 * 0.05**2) )
            assert math.isclose( (  "0.4 cm"  *  Measure(value=0.3,unit=Unit("cm"))  ).value , 0.3*0.4 )
            assert math.isclose( (  "0.4 cm"  *  Measure(value=0.3,unit=Unit("cm"))  ).error , error   )
            assert (  "0.4 cm"  *  Measure(value=0.3,unit=Unit("cm"))  ).implied == True
            assert (  "0.4 cm"  *  Measure(value=0.3,unit=Unit("cm"))  ).units.symbols   == Unit("cm^2").symbols
            assert (  "0.4 cm"  *  Measure(value=0.3,unit=Unit("cm"))  ).units.magnitude == Unit("cm^2").magnitude
            assert (  "0.4 cm"  *  Measure(value=0.3,unit=Unit("cm"))  ) == Measure(units=Unit("cm^2"), value= 0.3*0.4, error=error)
            # Value 3: Decimal
            assert isinstance( (  "40 cm"  *  Measure(value=Decimal("30"),unit=Unit("cm"))  ), Measure )
            error = measure._sqrt_( (Decimal("40")**2 * Decimal("5")**2 + Decimal("30")**2 * Decimal("5")**2) )
            assert (  "40 cm"  *  Measure(value=Decimal("30"),unit=Unit("cm"))  ).value   == Decimal("1200")
            assert (  "40 cm"  *  Measure(value=Decimal("30"),unit=Unit("cm"))  ).error   == error
            assert (  "40 cm"  *  Measure(value=Decimal("30"),unit=Unit("cm"))  ).implied == True
            assert (  "40 cm"  *  Measure(value=Decimal("30"),unit=Unit("cm"))  ).units.symbols   == Unit("cm^2").symbols
            assert (  "40 cm"  *  Measure(value=Decimal("30"),unit=Unit("cm"))  ).units.magnitude == Unit("cm^2").magnitude
            assert (  "40 cm"  *  Measure(value=Decimal("30"),unit=Unit("cm"))  ) == Measure(units=Unit("cm^2"), value= Decimal("1200"), error=error)
            # Value 4: Negative
            assert isinstance( ( "-4 cm"  *  Measure(value=-3,unit=Unit("cm"))  ), Measure )
            error = measure._sqrt_( (Decimal("4")**2 * Decimal("0.5")**2 + Decimal("3")**2 * Decimal("0.5")**2) )
            assert (  "-4 cm"  *  Measure(value=-3,unit=Unit("cm"))  ).value   == 12
            assert (  "-4 cm"  *  Measure(value=-3,unit=Unit("cm"))  ).error   == error
            assert (  "-4 cm"  *  Measure(value=-3,unit=Unit("cm"))  ).implied == True
            assert (  "-4 cm"  *  Measure(value=-3,unit=Unit("cm"))  ).units.symbols   == Unit("cm^2").symbols
            assert (  "-4 cm"  *  Measure(value=-3,unit=Unit("cm"))  ).units.magnitude == Unit("cm^2").magnitude
            assert (  "-4 cm"  *  Measure(value=-3,unit=Unit("cm"))  ) == Measure(units=Unit("cm^2"), value= 12, error=error)
          # Magnitude Units
          if(True):
            # Value 1: Int
            assert isinstance( (  "2 * 5 m^2"  *  Measure(value=5,unit=Unit("5 m^2"))  ) , Measure )
            error = measure._sqrt_( (Decimal(25)**2 * Decimal("2.5")**2 + Decimal(10)**2 * Decimal("2.5")**2) )/Decimal(25)
            assert (  "2 * 5 m^2"  *  Measure(value=5,unit=Unit("5 m^2"))  ).value   == 10
            assert Measure._dec_isclose_(  (  "2 * 5 m^2"  *  Measure(value=5,unit=Unit("5 m^2"))  ).error , error )
            assert (  "2 * 5 m^2"  *  Measure(value=5,unit=Unit("5 m^2"))  ).implied == True
            assert (  "2 * 5 m^2"  *  Measure(value=5,unit=Unit("5 m^2"))  ).units.symbols   == Unit("25 m^4").symbols
            assert (  "2 * 5 m^2"  *  Measure(value=5,unit=Unit("5 m^2"))  ).units.magnitude == Unit("25 m^4").magnitude
            assert (  "2 * 5 m^2"  *  Measure(value=5,unit=Unit("5 m^2"))  ) == Measure(units=Unit("25 m^4"), value=10, error=error)
            # Value 2: Float
            assert isinstance( (  "0.2 * 5 m^2"  *  Measure(value=0.5,unit=Unit("5 m^4"))  ) , Measure )
            error = measure._sqrt_( (2.5**2 * 0.25**2 + 1.0**2 * 0.25**2) )/25
            assert math.isclose( (  "0.2 * 5 m^2"  *  Measure(value=0.5,unit=Unit("5 m^2"))  ).value , 0.1   )
            assert math.isclose( (  "0.2 * 5 m^2"  *  Measure(value=0.5,unit=Unit("5 m^2"))  ).error , error )
            assert (  "0.2 * 5 m^2"  *  Measure(value=0.5,unit=Unit("5 m^2"))  ).implied == True
            assert (  "0.2 * 5 m^2"  *  Measure(value=0.5,unit=Unit("5 m^2"))  ).units.symbols   == Unit("25 m^4").symbols
            assert (  "0.2 * 5 m^2"  *  Measure(value=0.5,unit=Unit("5 m^2"))  ).units.magnitude == Unit("25 m^4").magnitude
            assert (  "0.2 * 5 m^2"  *  Measure(value=0.5,unit=Unit("5 m^2"))  ) == Measure(units=Unit("25 m^4"), value=0.1, error=error)
            # Value 3: Decimal
            assert isinstance( (  "20 * 5 m^2"  *  Measure(value=Decimal("50"),unit=Unit("5 m^2"))  ) , Measure )
            error = measure._sqrt_( (Decimal("250")**2 * Decimal("25")**2 + Decimal("100")**2 * Decimal("25")**2) )/Decimal("25")
            assert (  "20 * 5 m^2"  *  Measure(value=Decimal("50"),unit=Unit("5 m^2"))  ) == Measure(units=Unit("25 m^4"), value=Decimal("1000"), error=error)
            assert (  "20 * 5 m^2"  *  Measure(value=Decimal("50"),unit=Unit("5 m^2"))  ).value   == Decimal("1000")
            assert Measure._dec_isclose_(  (  "20 * 5 m^2"  *  Measure(value=Decimal("50"),unit=Unit("5 m^2"))  ).error , error )
            assert (  "20 * 5 m^2"  *  Measure(value=Decimal("50"),unit=Unit("5 m^2"))  ).implied == True
            assert (  "20 * 5 m^2"  *  Measure(value=Decimal("50"),unit=Unit("5 m^2"))  ).units.symbols   == Unit("25 m^4").symbols
            assert (  "20 * 5 m^2"  *  Measure(value=Decimal("50"),unit=Unit("5 m^2"))  ).units.magnitude == Unit("25 m^4").magnitude
            # Value 4: Negative
            assert isinstance( (  "-2 * 5 m^2"  *  Measure(value=-5,unit=Unit("5 m^2"))  ) , Measure )
            error = measure._sqrt_( (Decimal(25)**2 * Decimal("2.5")**2 + Decimal(10)**2 * Decimal("2.5")**2) )/Decimal(25)
            assert (  "-2 * 5 m^2"  *  Measure(value=-5,unit=Unit("5 m^2"))  ) == Measure(units=Unit("25 m^4"), value=10, error=error)
            assert (  "-2 * 5 m^2"  *  Measure(value=-5,unit=Unit("5 m^2"))  ).value   == 10
            assert Measure._dec_isclose_( (  "-2 * 5 m^2"  *  Measure(value=-5,unit=Unit("5 m^2"))  ).error , error )
            assert (  "-2 * 5 m^2"  *  Measure(value=-5,unit=Unit("5 m^2"))  ).implied == True
            assert (  "-2 * 5 m^2"  *  Measure(value=-5,unit=Unit("5 m^2"))  ).units.symbols   == Unit("25 m^4").symbols
            assert (  "-2 * 5 m^2"  *  Measure(value=-5,unit=Unit("5 m^2"))  ).units.magnitude == Unit("25 m^4").magnitude
          # Convoluted Units
          if(True):
            # Value 1: Int
            assert isinstance( ( "27 \u00B0C"  *  Measure(value=27,unit=Unit("\u00B0C")) ), Measure )
            error = measure._sqrt_( (Decimal("300.15")**2 * Decimal("0.5")**2 + Decimal("300.15")**2 * Decimal("0.5")**2) )
            assert ( "27 \u00B0C"  *  Measure(value=27,unit=Unit("\u00B0C")) ).value   == Decimal("300.15")*Decimal("300.15")
            assert ( "27 \u00B0C"  *  Measure(value=27,unit=Unit("\u00B0C")) ).error   == error
            assert ( "27 \u00B0C"  *  Measure(value=27,unit=Unit("\u00B0C")) ).implied == True
            assert ( "27 \u00B0C"  *  Measure(value=27,unit=Unit("\u00B0C")) ).units.symbols   == Unit("K^2").symbols
            assert ( "27 \u00B0C"  *  Measure(value=27,unit=Unit("\u00B0C")) ).units.magnitude == Unit("K^2").magnitude
            assert ( "27 \u00B0C"  *  Measure(value=27,unit=Unit("\u00B0C")) ) == Measure(units=Unit("K^2"), value= Decimal("300.15")*Decimal("300.15"), error=error)
            # Value 2: Float
            assert isinstance( ( "26.85 \u00B0C"  *  Measure(value=26.85,unit=Unit("\u00B0C")) ), Measure )
            error = measure._sqrt_( (300**2 * 0.005**2 + 300**2 * 0.005**2) )
            assert math.isclose( ( "26.85 \u00B0C"  *  Measure(value=26.85,unit=Unit("\u00B0C")) ).value   , 300 * 300 )
            assert math.isclose( ( "26.85 \u00B0C"  *  Measure(value=26.85,unit=Unit("\u00B0C")) ).error   , error )
            assert ( "26.85 \u00B0C"  *  Measure(value=26.85,unit=Unit("\u00B0C")) ).implied == True 
            assert ( "26.85 \u00B0C"  *  Measure(value=26.85,unit=Unit("\u00B0C")) ).units.symbols   == Unit("K^2").symbols
            assert ( "26.85 \u00B0C"  *  Measure(value=26.85,unit=Unit("\u00B0C")) ).units.magnitude == Unit("K^2").magnitude
            assert ( "26.85 \u00B0C"  *  Measure(value=26.85,unit=Unit("\u00B0C")) ) == Measure(units=Unit("K^2"), value=300 * 300, error=error)
            # Value 3: Decimal
            assert isinstance( ( "26.85 \u00B0C"  *  Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ), Measure )
            error = measure._sqrt_( (Decimal("300")**2 * Decimal("0.005")**2 + Decimal("300")**2 * Decimal("0.005")**2) )
            assert ( "26.85 \u00B0C"  *  Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).value   == Decimal("300") * Decimal("300") 
            assert ( "26.85 \u00B0C"  *  Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).error   == error
            assert ( "26.85 \u00B0C"  *  Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).implied == True
            assert ( "26.85 \u00B0C"  *  Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).units.symbols   == Unit("K^2").symbols
            assert ( "26.85 \u00B0C"  *  Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).units.magnitude == Unit("K^2").magnitude
            assert ( "26.85 \u00B0C"  *  Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ) == Measure(units=Unit("K^2"), value=Decimal("300") * Decimal("300"), error=error)
            # Value 4: Negative
            assert isinstance( ( "-27 \u00B0C"  *  Measure(value=-27,unit=Unit("\u00B0C")) ), Measure )
            error = measure._sqrt_( (Decimal("246.15")**2 * Decimal("0.5")**2 + Decimal("246.15")**2 * Decimal("0.5")**2) )
            assert ( "-27 \u00B0C"  *  Measure(value=-27,unit=Unit("\u00B0C")) ).value   == Decimal("246.15")*Decimal("246.15")
            assert ( "-27 \u00B0C"  *  Measure(value=-27,unit=Unit("\u00B0C")) ).error   == error
            assert ( "-27 \u00B0C"  *  Measure(value=-27,unit=Unit("\u00B0C")) ).implied == True
            assert ( "-27 \u00B0C"  *  Measure(value=-27,unit=Unit("\u00B0C")) ).units.symbols   == Unit("K^2").symbols
            assert ( "-27 \u00B0C"  *  Measure(value=-27,unit=Unit("\u00B0C")) ).units.magnitude == Unit("K^2").magnitude
            assert ( "-27 \u00B0C"  *  Measure(value=-27,unit=Unit("\u00B0C")) ) == Measure(units=Unit("K^2"), value= Decimal("246.15")*Decimal("246.15"), error=error)
          # Canceling Units
          if(True):
            # Value 1: Int
            assert isinstance( ( "4 cm"  *  Measure(value=3,unit=Unit("cm^-1"))  ), Measure )
            error = measure._sqrt_( (Decimal("4")**2 * Decimal("0.5")**2 + Decimal("3")**2 * Decimal("0.5")**2) )
            assert (  "4 cm"  *  Measure(value=3,unit=Unit("cm^-1"))  ).value   == 12
            assert (  "4 cm"  *  Measure(value=3,unit=Unit("cm^-1"))  ).error   == error
            assert (  "4 cm"  *  Measure(value=3,unit=Unit("cm^-1"))  ).implied == True
            assert (  "4 cm"  *  Measure(value=3,unit=Unit("cm^-1"))  ).units.symbols   == Unit().symbols
            assert (  "4 cm"  *  Measure(value=3,unit=Unit("cm^-1"))  ).units.magnitude == Unit().magnitude
            assert (  "4 cm"  *  Measure(value=3,unit=Unit("cm^-1"))  ) == Measure(units=Unit(), value= 12, error=error)
            # Value 2: Float
            assert isinstance( ( "0.4 cm"  *  Measure(value=0.3,unit=Unit("cm^-1"))  ), Measure )
            error = measure._sqrt_( (0.4**2 * 0.05**2 + 0.3**2 * 0.05**2) )
            assert math.isclose( (  "0.4 cm"  *  Measure(value=0.3,unit=Unit("cm^-1"))  ).value , 0.3*0.4 )
            assert math.isclose( (  "0.4 cm"  *  Measure(value=0.3,unit=Unit("cm^-1"))  ).error , error   )
            assert (  "0.4 cm"  *  Measure(value=0.3,unit=Unit("cm^-1"))  ).implied == True
            assert (  "0.4 cm"  *  Measure(value=0.3,unit=Unit("cm^-1"))  ).units.symbols   == Unit().symbols
            assert (  "0.4 cm"  *  Measure(value=0.3,unit=Unit("cm^-1"))  ).units.magnitude == Unit().magnitude
            assert (  "0.4 cm"  *  Measure(value=0.3,unit=Unit("cm^-1"))  ) == Measure(units=Unit(), value= 0.3*0.4, error=error)
            # Value 3: Decimal
            assert isinstance( (  "40 cm"  *  Measure(value=Decimal("30"),unit=Unit("cm^-1"))  ), Measure )
            error = measure._sqrt_( (Decimal("40")**2 * Decimal("5")**2 + Decimal("30")**2 * Decimal("5")**2) )
            assert (  "40 cm"  *  Measure(value=Decimal("30"),unit=Unit("cm^-1"))  ).value   == Decimal("1200")
            assert (  "40 cm"  *  Measure(value=Decimal("30"),unit=Unit("cm^-1"))  ).error   == error
            assert (  "40 cm"  *  Measure(value=Decimal("30"),unit=Unit("cm^-1"))  ).implied == True
            assert (  "40 cm"  *  Measure(value=Decimal("30"),unit=Unit("cm^-1"))  ).units.symbols   == Unit().symbols
            assert (  "40 cm"  *  Measure(value=Decimal("30"),unit=Unit("cm^-1"))  ).units.magnitude == Unit().magnitude
            assert (  "40 cm"  *  Measure(value=Decimal("30"),unit=Unit("cm^-1"))  ) == Measure(units=Unit(), value= Decimal("1200"), error=error)
            # Value 4: Negative
            assert isinstance( ( "-4 cm"  *  Measure(value=-3,unit=Unit("cm^-1"))  ), Measure )
            error = measure._sqrt_( (Decimal("4")**2 * Decimal("0.5")**2 + Decimal("3")**2 * Decimal("0.5")**2) )
            assert (  "-4 cm"  *  Measure(value=-3,unit=Unit("cm^-1"))  ).value   == 12
            assert (  "-4 cm"  *  Measure(value=-3,unit=Unit("cm^-1"))  ).error   == error
            assert (  "-4 cm"  *  Measure(value=-3,unit=Unit("cm^-1"))  ).implied == True
            assert (  "-4 cm"  *  Measure(value=-3,unit=Unit("cm^-1"))  ).units.symbols   == Unit().symbols
            assert (  "-4 cm"  *  Measure(value=-3,unit=Unit("cm^-1"))  ).units.magnitude == Unit().magnitude
            assert (  "-4 cm"  *  Measure(value=-3,unit=Unit("cm^-1"))  ) == Measure(units=Unit(), value= 12, error=error)
          # Preserve Inputs
          if(True):
            a = "4 cm"
            b = Measure(value=3,unit=Unit("cm"))
            c = a*b
            c = None
            assert a == "4 cm"
            assert b == Measure(value=3,unit=Unit("cm"))
    # Measure * Str Measure
    if(True):
      # Measure (Explicit Error) * Str Measure (Explicit Error) = Measure (Explicit Error)
      if(True):
        # Unitless * Unitless
        if(True):
          # Value 1: Int
          assert isinstance( ( Measure(value=4,error=2)  *  "3 ± 2"  ), Measure )
          error = measure._sqrt_( (Decimal("4")**2 * Decimal("2")**2 + Decimal("3")**2 * Decimal("2")**2) )
          assert (  Measure(value=4,error=2)  *  "3 ± 2"  ).value   == 12
          assert (  Measure(value=4,error=2)  *  "3 ± 2"  ).error   == error
          assert (  Measure(value=4,error=2)  *  "3 ± 2"  ).implied == False
          assert (  Measure(value=4,error=2)  *  "3 ± 2"  ).units.symbols   == Unit().symbols
          assert (  Measure(value=4,error=2)  *  "3 ± 2"  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=4,error=2)  *  "3 ± 2"  ) == Measure(units=Unit(), value= 12, error=error)
          # Value 2: Float
          assert isinstance( ( Measure(value=0.4,error=0.2)  *  "0.3 ± 0.2"  ), Measure )
          error = measure._sqrt_( (0.4**2 * 0.2**2 + 0.3**2 * 0.2**2) )
          assert math.isclose( (  Measure(value=0.4,error=0.2)  *  "0.3 ± 0.2"  ).value , 0.4*0.3 )
          assert math.isclose( (  Measure(value=0.4,error=0.2)  *  "0.3 ± 0.2"  ).error , error   )
          assert (  Measure(value=0.4,error=0.2)  *  "0.3 ± 0.2"  ).implied == False
          assert (  Measure(value=0.4,error=0.2)  *  "0.3 ± 0.2"  ).units.symbols   == Unit().symbols
          assert (  Measure(value=0.4,error=0.2)  *  "0.3 ± 0.2"  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=0.4,error=0.2)  *  "0.3 ± 0.2"  ) == Measure(units=Unit(), value= 0.4*0.3, error=error)
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("40"),error=Decimal("20"))  *  "30 ± 20"  ), Measure )
          error = measure._sqrt_( (Decimal("40")**2 * Decimal("20")**2 + Decimal("30")**2 * Decimal("20")**2) )
          assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  "30 ± 20"  ).value   == Decimal("1200")
          assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  "30 ± 20"  ).error   == error
          assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  "30 ± 20"  ).implied == False
          assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  "30 ± 20"  ).units.symbols   == Unit().symbols
          assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  "30 ± 20"  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  "30 ± 20"  ) == Measure(units=Unit(), value= Decimal("1200"), error=error)
          # Value 4: Negative
          assert isinstance( ( Measure(value=-4,error=2)  *  "-3 ± 2"  ), Measure )
          error = measure._sqrt_( (Decimal("4")**2 * Decimal("2")**2 + Decimal("3")**2 * Decimal("2")**2) )
          assert (  Measure(value=-4,error=2)  *  "-3 ± 2"  ).value   == 12
          assert (  Measure(value=-4,error=2)  *  "-3 ± 2"  ).error   == error
          assert (  Measure(value=-4,error=2)  *  "-3 ± 2"  ).implied == False
          assert (  Measure(value=-4,error=2)  *  "-3 ± 2"  ).units.symbols   == Unit().symbols
          assert (  Measure(value=-4,error=2)  *  "-3 ± 2"  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=-4,error=2)  *  "-3 ± 2"  ) == Measure(units=Unit(), value= 12, error=error)
          # Preserve Inputs
          if(True):
            a = Measure(value=4,error=2) 
            b = "3 ± 2"
            c = a*b
            c = None
            assert a == Measure(value=4,error=2) 
            assert b == "3 ± 2"
        # Unitless * Unit
        if(True):
          # Normal Units
          if(True):
            # Value 1: Int
            assert isinstance( (  Measure(value=3,error=2)  *  "4 ± 2 cm"  ), Measure )
            error = measure._sqrt_( (Decimal("4")**2 * Decimal("2")**2 + Decimal("3")**2 * Decimal("2")**2) )
            assert (  Measure(value=3,error=2)  *  "4 ± 2 cm"  ).value   == 12
            assert (  Measure(value=3,error=2)  *  "4 ± 2 cm"  ).error   == error
            assert (  Measure(value=3,error=2)  *  "4 ± 2 cm"  ).implied == False
            assert (  Measure(value=3,error=2)  *  "4 ± 2 cm"  ).units.symbols   == Unit("cm").symbols
            assert (  Measure(value=3,error=2)  *  "4 ± 2 cm"  ).units.magnitude == Unit("cm").magnitude
            assert (  Measure(value=3,error=2)  *  "4 ± 2 cm"  ) == Measure(units=Unit("cm"), value= 12, error=error)
            # Value 2: Float
            assert isinstance( (  Measure(value=0.3,error=0.2)  *  "0.4 ± 0.2 cm" ), Measure )
            error = measure._sqrt_( (0.4**2 * 0.2**2 + 0.3**2 * 0.2**2) )
            assert math.isclose( (  Measure(value=0.3,error=0.2)  *  "0.4 ± 0.2 cm"  ).value , 0.3*0.4 )
            assert math.isclose( (  Measure(value=0.3,error=0.2)  *  "0.4 ± 0.2 cm"  ).error , error   )
            assert (  Measure(value=0.3,error=0.2)  *  "0.4 ± 0.2 cm"  ).implied == False
            assert (  Measure(value=0.3,error=0.2)  *  "0.4 ± 0.2 cm"  ).units.symbols   == Unit("cm").symbols
            assert (  Measure(value=0.3,error=0.2)  *  "0.4 ± 0.2 cm"  ).units.magnitude == Unit("cm").magnitude
            assert (  Measure(value=0.3,error=0.2)  *  "0.4 ± 0.2 cm"  ) == Measure(units=Unit("cm"), value= 0.3*0.4, error=error)
            # Value 3: Decimal
            assert isinstance( (  Measure(value=Decimal("40"),error=Decimal("20"))  *  "30 ± 20 cm"  ), Measure )
            error = measure._sqrt_( (Decimal("40")**2 * Decimal("20")**2 + Decimal("30")**2 * Decimal("20")**2) )
            assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  "30 ± 20 cm"  ).value   == Decimal("1200")
            assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  "30 ± 20 cm"  ).error   == error
            assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  "30 ± 20 cm"  ).implied == False
            assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  "30 ± 20 cm"  ).units.symbols   == Unit("cm").symbols
            assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  "30 ± 20 cm"  ).units.magnitude == Unit("cm").magnitude
            assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  "30 ± 20 cm"  ) == Measure(units=Unit("cm"), value= Decimal("1200"), error=error)
            # Value 4: Negative
            assert isinstance( (  Measure(value=-3,error=2)  *  "-4 ± 2 cm"  ), Measure )
            error = measure._sqrt_( (Decimal("4")**2 * Decimal("2")**2 + Decimal("3")**2 * Decimal("2")**2) )
            assert (  Measure(value=-3,error=2)  *  "-4 ± 2 cm"  ).value   == 12
            assert (  Measure(value=-3,error=2)  *  "-4 ± 2 cm"  ).error   == error
            assert (  Measure(value=-3,error=2)  *  "-4 ± 2 cm"  ).implied == False
            assert (  Measure(value=-3,error=2)  *  "-4 ± 2 cm"  ).units.symbols   == Unit("cm").symbols
            assert (  Measure(value=-3,error=2)  *  "-4 ± 2 cm"  ).units.magnitude == Unit("cm").magnitude
            assert (  Measure(value=-3,error=2)  *  "-4 ± 2 cm"  ) == Measure(units=Unit("cm"), value= 12, error=error)
          # Magnitude Units
          if(True):
            # Value 1: Int
            assert isinstance( (  Measure(value=5,error=1)  *  "2 ± 1 * 5 m^2"  ) , Measure )
            error = measure._sqrt_( (Decimal(5)**2 * Decimal(5)**2 + Decimal(10)**2 * Decimal(1)**2) )/Decimal(5)
            assert (  Measure(value=5,error=1)  *  "2 ± 1 * 5 m^2"  ) == Measure(units=Unit("5 m^2"), value=10, error=error)
            assert (  Measure(value=5,error=1)  *  "2 ± 1 * 5 m^2"  ).value   == 10
            assert (  Measure(value=5,error=1)  *  "2 ± 1 * 5 m^2"  ).error   == error
            assert (  Measure(value=5,error=1)  *  "2 ± 1 * 5 m^2"  ).implied == False
            assert (  Measure(value=5,error=1)  *  "2 ± 1 * 5 m^2"  ).units.symbols   == Unit("5 m^2").symbols
            assert (  Measure(value=5,error=1)  *  "2 ± 1 * 5 m^2"  ).units.magnitude == Unit("5 m^2").magnitude
            # Value 2: Float
            assert isinstance( (  Measure(value=0.5,error=0.1)  *  "0.2 ± 0.1 * 5 m^2"  ) , Measure )
            error = measure._sqrt_( (0.5**2 * 0.5**2 + 1.0**2 * 0.1**2) )/5
            assert (  Measure(value=0.5,error=0.1)  *  "0.2 ± 0.1 * 5 m^2"  ) == Measure(units=Unit("5 m^2"), value=0.1, error=error)
            assert math.isclose( (  Measure(value=0.5,error=0.1)  *  "0.2 ± 0.1 * 5 m^2"  ).value , 0.1   )
            assert math.isclose( (  Measure(value=0.5,error=0.1)  *  "0.2 ± 0.1 * 5 m^2"  ).error , error )
            assert (  Measure(value=0.5,error=0.1)  *  "0.2 ± 0.1 * 5 m^2"  ).implied == False
            assert (  Measure(value=0.5,error=0.1)  *  "0.2 ± 0.1 * 5 m^2"  ).units.symbols   == Unit("5 m^2").symbols
            assert (  Measure(value=0.5,error=0.1)  *  "0.2 ± 0.1 * 5 m^2"  ).units.magnitude == Unit("5 m^2").magnitude
            # Value 3: Decimal
            assert isinstance( (  Measure(value=Decimal("50"),error=Decimal("2"))  *  "20 ± 5 * 5 m^2"  ) , Measure )
            error = measure._sqrt_( (Decimal("50")**2 * Decimal("25")**2 + Decimal("100")**2 * Decimal("2")**2) )/Decimal("5")
            assert (  Measure(value=Decimal("50"),error=Decimal("2"))  *  "20 ± 5 * 5 m^2"  ) == Measure(units=Unit("5 m^2"), value=Decimal("1000"), error=error)
            assert (  Measure(value=Decimal("50"),error=Decimal("2"))  *  "20 ± 5 * 5 m^2"  ).value   == Decimal("1000")
            assert (  Measure(value=Decimal("50"),error=Decimal("2"))  *  "20 ± 5 * 5 m^2"  ).error   == error
            assert (  Measure(value=Decimal("50"),error=Decimal("2"))  *  "20 ± 5 * 5 m^2"  ).implied == False
            assert (  Measure(value=Decimal("50"),error=Decimal("2"))  *  "20 ± 5 * 5 m^2"  ).units.symbols   == Unit("5 m^2").symbols
            assert (  Measure(value=Decimal("50"),error=Decimal("2"))  *  "20 ± 5 * 5 m^2"  ).units.magnitude == Unit("5 m^2").magnitude
            # Value 4: Negative
            assert isinstance( (  Measure(value=-5,error=1)  *  "-2 ± 1 * 5 m^2"  ) , Measure )
            error = measure._sqrt_( (Decimal(5)**2 * Decimal(5)**2 + Decimal(10)**2 * Decimal(1)**2) )/Decimal(5)
            assert (  Measure(value=-5,error=1)  *  "-2 ± 1 * 5 m^2"  ) == Measure(units=Unit("5 m^2"), value=10, error=error)
            assert (  Measure(value=-5,error=1)  *  "-2 ± 1 * 5 m^2"  ).value   == 10
            assert (  Measure(value=-5,error=1)  *  "-2 ± 1 * 5 m^2"  ).error   == error
            assert (  Measure(value=-5,error=1)  *  "-2 ± 1 * 5 m^2"  ).implied == False
            assert (  Measure(value=-5,error=1)  *  "-2 ± 1 * 5 m^2"  ).units.symbols   == Unit("5 m^2").symbols
            assert (  Measure(value=-5,error=1)  *  "-2 ± 1 * 5 m^2"  ).units.magnitude == Unit("5 m^2").magnitude
          # Convoluted Units
          if(True):
            # Value 1: Int
            assert isinstance( ( Measure(value=300,error=2)  *  "27 ± 1 \u00B0C" ), Measure )
            error = measure._sqrt_( (Decimal("300")**2 * Decimal("1")**2 + Decimal("300.15")**2 * Decimal("2")**2) )
            assert ( Measure(value=300,error=2)  *  "27 ± 1 \u00B0C" ).value   == Decimal("300.15")*Decimal("300") - Decimal("273.15")
            assert ( Measure(value=300,error=2)  *  "27 ± 1 \u00B0C" ).error   == error
            assert ( Measure(value=300,error=2)  *  "27 ± 1 \u00B0C" ).implied == False
            assert ( Measure(value=300,error=2)  *  "27 ± 1 \u00B0C" ).units.symbols   == Unit("\u00B0C").symbols
            assert ( Measure(value=300,error=2)  *  "27 ± 1 \u00B0C" ).units.magnitude == Unit("\u00B0C").magnitude
            assert ( Measure(value=300,error=2)  *  "27 ± 1 \u00B0C" ) == Measure(units=Unit("\u00B0C"), value= Decimal("300.15")*Decimal("300") - Decimal("273.15"), error=error)
            # Value 2: Float
            assert isinstance( ( Measure(value=299.9,error=0.02)  *  "26.85 ± 0.02 \u00B0C" ), Measure )
            error = measure._sqrt_( (299.9**2 * 0.02**2 + 300**2 * 0.02**2) )
            assert math.isclose( ( Measure(value=299.9,error=0.02)  *  "26.85 ± 0.02 \u00B0C" ).value   , 299.9 * 300 - 273.15 )
            assert math.isclose( ( Measure(value=299.9,error=0.02)  *  "26.85 ± 0.02 \u00B0C" ).error   , error )
            assert ( Measure(value=299.9,error=0.02)  *  "26.85 ± 0.02 \u00B0C" ).implied == False 
            assert ( Measure(value=299.9,error=0.02)  *  "26.85 ± 0.02 \u00B0C" ).units.symbols   == Unit("\u00B0C").symbols
            assert ( Measure(value=299.9,error=0.02)  *  "26.85 ± 0.02 \u00B0C" ).units.magnitude == Unit("\u00B0C").magnitude
            assert ( Measure(value=299.9,error=0.02)  *  "26.85 ± 0.02 \u00B0C" ) == Measure(units=Unit("\u00B0C"), value=299.9 * 300 - 273.15, error=error)
            # Value 3: Decimal
            assert isinstance( ( Measure(value=Decimal("300"),error=Decimal("0.02"))  *  "26.85 ± 0.02 \u00B0C" ), Measure )
            error = measure._sqrt_( (Decimal("300")**2 * Decimal("0.02")**2 + Decimal("300")**2 * Decimal("0.02")**2) )
            assert ( Measure(value=Decimal("300"),error=Decimal("0.02"))  *  "26.85 ± 0.02 \u00B0C" ).value   == Decimal("300") * Decimal("300") - Decimal("273.15") 
            assert ( Measure(value=Decimal("300"),error=Decimal("0.02"))  *  "26.85 ± 0.02 \u00B0C" ).error   == error
            assert ( Measure(value=Decimal("300"),error=Decimal("0.02"))  *  "26.85 ± 0.02 \u00B0C" ).implied == False
            assert ( Measure(value=Decimal("300"),error=Decimal("0.02"))  *  "26.85 ± 0.02 \u00B0C" ).units.symbols   == Unit("\u00B0C").symbols
            assert ( Measure(value=Decimal("300"),error=Decimal("0.02"))  *  "26.85 ± 0.02 \u00B0C" ).units.magnitude == Unit("\u00B0C").magnitude
            assert ( Measure(value=Decimal("300"),error=Decimal("0.02"))  *  "26.85 ± 0.02 \u00B0C" ) == Measure(units=Unit("\u00B0C"), value=Decimal("300") * Decimal("300") - Decimal("273.15"), error=error)
            # Value 4: Negative
            assert isinstance( ( Measure(value=300,error=2)  *  "-27 ± 1 \u00B0C" ), Measure )
            error = measure._sqrt_( (Decimal("300")**2 * Decimal("1")**2 + Decimal("246.15")**2 * Decimal("2")**2) )
            assert ( Measure(value=300,error=2)  *  "-27 ± 1 \u00B0C" ).value   == Decimal("246.15")*Decimal("300") - Decimal("273.15")
            assert ( Measure(value=300,error=2)  *  "-27 ± 1 \u00B0C" ).error   == error
            assert ( Measure(value=300,error=2)  *  "-27 ± 1 \u00B0C" ).implied == False
            assert ( Measure(value=300,error=2)  *  "-27 ± 1 \u00B0C" ).units.symbols   == Unit("\u00B0C").symbols
            assert ( Measure(value=300,error=2)  *  "-27 ± 1 \u00B0C" ).units.magnitude == Unit("\u00B0C").magnitude
            assert ( Measure(value=300,error=2)  *  "-27 ± 1 \u00B0C" ) == Measure(units=Unit("\u00B0C"), value= Decimal("246.15")*Decimal("300") - Decimal("273.15"), error=error)
          # Preserve Inputs
          if(True):
            a = Measure(value=3,error=2) 
            b = "4 ± 2 cm"
            c = a*b
            c = None
            assert a == Measure(value=3,error=2) 
            assert b == "4 ± 2 cm"
        # Unit * Unitless
        if(True):
          # Normal Units
          if(True):
            # Value 1: Int
            assert isinstance( ( Measure(value=4,error=2,unit=Unit("cm"))  *  "3 ± 2"  ), Measure )
            error = measure._sqrt_( (Decimal("4")**2 * Decimal("2")**2 + Decimal("3")**2 * Decimal("2")**2) )
            assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  "3 ± 2"  ).value   == 12
            assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  "3 ± 2"  ).error   == error
            assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  "3 ± 2"  ).implied == False
            assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  "3 ± 2"  ).units.symbols   == Unit("cm").symbols
            assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  "3 ± 2"  ).units.magnitude == Unit("cm").magnitude
            assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  "3 ± 2"  ) == Measure(units=Unit("cm"), value= 12, error=error)
            # Value 2: Float
            assert isinstance( ( Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  "0.3 ± 0.2"  ), Measure )
            error = measure._sqrt_( (0.4**2 * 0.2**2 + 0.3**2 * 0.2**2) )
            assert math.isclose( (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  "0.3 ± 0.2"  ).value , 0.3*0.4 )
            assert math.isclose( (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  "0.3 ± 0.2"  ).error , error   )
            assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  "0.3 ± 0.2"  ).implied == False
            assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  "0.3 ± 0.2"  ).units.symbols   == Unit("cm").symbols
            assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  "0.3 ± 0.2"  ).units.magnitude == Unit("cm").magnitude
            assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  "0.3 ± 0.2"  ) == Measure(units=Unit("cm"), value= 0.3*0.4, error=error)
            # Value 3: Decimal
            assert isinstance( (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  "30 ± 20"  ), Measure )
            error = measure._sqrt_( (Decimal("40")**2 * Decimal("20")**2 + Decimal("30")**2 * Decimal("20")**2) )
            assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  "30 ± 20"  ).value   == Decimal("1200")
            assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  "30 ± 20"  ).error   == error
            assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  "30 ± 20"  ).implied == False
            assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  "30 ± 20"  ).units.symbols   == Unit("cm").symbols
            assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  "30 ± 20"  ).units.magnitude == Unit("cm").magnitude
            assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  "30 ± 20"  ) == Measure(units=Unit("cm"), value= Decimal("1200"), error=error)
            # Value 4: Negative
            assert isinstance( ( Measure(value=-4,error=2,unit=Unit("cm"))  *  "-3 ± 2"  ), Measure )
            error = measure._sqrt_( (Decimal("4")**2 * Decimal("2")**2 + Decimal("3")**2 * Decimal("2")**2) )
            assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  "-3 ± 2"  ).value   == 12
            assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  "-3 ± 2"  ).error   == error
            assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  "-3 ± 2"  ).implied == False
            assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  "-3 ± 2"  ).units.symbols   == Unit("cm").symbols
            assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  "-3 ± 2"  ).units.magnitude == Unit("cm").magnitude
            assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  "-3 ± 2"  ) == Measure(units=Unit("cm"), value= 12, error=error)
          # Magnitude Units
          if(True):
            # Value 1: Int
            assert isinstance( (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  "5 ± 1"  ) , Measure )
            error = measure._sqrt_( (Decimal(5)**2 * Decimal(5)**2 + Decimal(10)**2 * Decimal(1)**2) )/Decimal(5)
            assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  "5 ± 1"  ) == Measure(units=Unit("5 m^2"), value=10, error=error)
            assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  "5 ± 1"  ).value   == 10
            assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  "5 ± 1"  ).error   == error
            assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  "5 ± 1"  ).implied == False
            assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  "5 ± 1"  ).units.symbols   == Unit("5 m^2").symbols
            assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  "5 ± 1"  ).units.magnitude == Unit("5 m^2").magnitude
            # Value 2: Float
            assert isinstance( (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  "0.5 ± 0.1"  ) , Measure )
            error = measure._sqrt_( (0.5**2 * 0.5**2 + 1.0**2 * 0.1**2) )/5
            assert (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  "0.5 ± 0.1"  ) == Measure(units=Unit("5 m^2"), value=0.1, error=error)
            assert math.isclose( (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  "0.5 ± 0.1"  ).value , 0.1   )
            assert math.isclose( (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  "0.5 ± 0.1"  ).error , error )
            assert (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  "0.5 ± 0.1"  ).implied == False
            assert (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  "0.5 ± 0.1"  ).units.symbols   == Unit("5 m^2").symbols
            assert (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  "0.5 ± 0.1"  ).units.magnitude == Unit("5 m^2").magnitude
            # Value 3: Decimal
            assert isinstance( (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  "50 ± 2"  ) , Measure )
            error = measure._sqrt_( (Decimal("50")**2 * Decimal("25")**2 + Decimal("100")**2 * Decimal("2")**2) )/Decimal("5")
            assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  "50 ± 2"  ) == Measure(units=Unit("5 m^2"), value=Decimal("1000"), error=error)
            assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  "50 ± 2"  ).value   == Decimal("1000")
            assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  "50 ± 2"  ).error   == error
            assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  "50 ± 2"  ).implied == False
            assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  "50 ± 2"  ).units.symbols   == Unit("5 m^2").symbols
            assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  "50 ± 2"  ).units.magnitude == Unit("5 m^2").magnitude
            # Value 4: Negative
            assert isinstance( (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  "-5 ± 1"  ) , Measure )
            error = measure._sqrt_( (Decimal(5)**2 * Decimal(5)**2 + Decimal(10)**2 * Decimal(1)**2) )/Decimal(5)
            assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  "-5 ± 1"  ) == Measure(units=Unit("5 m^2"), value=10, error=error)
            assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  "-5 ± 1"  ).value   == 10
            assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  "-5 ± 1"  ).error   == error
            assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  "-5 ± 1"  ).implied == False
            assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  "-5 ± 1"  ).units.symbols   == Unit("5 m^2").symbols
            assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  "-5 ± 1"  ).units.magnitude == Unit("5 m^2").magnitude
          # Convoluted Units
          if(True):
            # Value 1: Int
            assert isinstance( ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  "300 ± 2" ), Measure )
            error = measure._sqrt_( (Decimal("300")**2 * Decimal("1")**2 + Decimal("300.15")**2 * Decimal("2")**2) )
            assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  "300 ± 2" ).value   == Decimal("300.15")*Decimal("300") - Decimal("273.15")
            assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  "300 ± 2" ).error   == error
            assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  "300 ± 2" ).implied == False
            assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  "300 ± 2" ).units.symbols   == Unit("\u00B0C").symbols
            assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  "300 ± 2" ).units.magnitude == Unit("\u00B0C").magnitude
            assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  "300 ± 2" ) == Measure(units=Unit("\u00B0C"), value= Decimal("300.15")*Decimal("300") - Decimal("273.15"), error=error)
            # Value 2: Float
            assert isinstance( ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  "299.9 ± 0.02" ), Measure )
            error = measure._sqrt_( (299.9**2 * 0.02**2 + 300**2 * 0.02**2) )
            assert math.isclose( ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  "299.9 ± 0.02" ).value , 299.9 * 300 - 273.15 )
            assert math.isclose( ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  "299.9 ± 0.02" ).error , error )
            assert ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  "299.9 ± 0.02" ).implied == False
            assert ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  "299.9 ± 0.02" ).units.symbols   == Unit("\u00B0C").symbols
            assert ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  "299.9 ± 0.02" ).units.magnitude == Unit("\u00B0C").magnitude
            assert ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  "299.9 ± 0.02" ) == Measure(units=Unit("\u00B0C"), value=299.9 * 300 - 273.15, error=error)
            # Value 3: Decimal
            assert isinstance( ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  "300 ± 0.02" ), Measure )
            error = measure._sqrt_( (Decimal("300")**2 * Decimal("0.02")**2 + Decimal("300")**2 * Decimal("0.02")**2) )
            assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  "300 ± 0.02" ).value   == Decimal("300") * Decimal("300") - Decimal("273.15") 
            assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  "300 ± 0.02" ).error   == error
            assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  "300 ± 0.02" ).implied == False
            assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  "300 ± 0.02" ).units.symbols   == Unit("\u00B0C").symbols
            assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  "300 ± 0.02" ).units.magnitude == Unit("\u00B0C").magnitude
            assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  "300 ± 0.02" ) == Measure(units=Unit("\u00B0C"), value=Decimal("300") * Decimal("300") - Decimal("273.15"), error=error)
            # Value 4: Negative
            assert isinstance( ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  "300 ± 2" ), Measure )
            error = measure._sqrt_( (Decimal("300")**2 * Decimal("1")**2 + Decimal("246.15")**2 * Decimal("2")**2) )
            assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  "300 ± 2" ).value   == Decimal("246.15")*Decimal("300") - Decimal("273.15")
            assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  "300 ± 2" ).error   == error
            assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  "300 ± 2" ).implied == False
            assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  "300 ± 2" ).units.symbols   == Unit("\u00B0C").symbols
            assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  "300 ± 2" ).units.magnitude == Unit("\u00B0C").magnitude
            assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  "300 ± 2" ) == Measure(units=Unit("\u00B0C"), value= Decimal("246.15")*Decimal("300") - Decimal("273.15"), error=error)
          # Preserve Inputs
          if(True):
            a = Measure(value=4,error=2,unit=Unit("cm"))
            b = "3 ± 2"
            c = a*b
            c = None
            assert a == Measure(value=4,error=2,unit=Unit("cm")) 
            assert b == "3 ± 2"
        # Units * Units
        if(True):
          # Normal Units
          if(True):
            # Value 1: Int
            assert isinstance( ( Measure(value=4,error=2,unit=Unit("cm"))  *  "3 ± 2 cm"  ), Measure )
            error = measure._sqrt_( (Decimal("4")**2 * Decimal("2")**2 + Decimal("3")**2 * Decimal("2")**2) )
            assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  "3 ± 2 cm"  ).value   == 12
            assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  "3 ± 2 cm"  ).error   == error
            assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  "3 ± 2 cm"  ).implied == False
            assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  "3 ± 2 cm"  ).units.symbols   == Unit("cm^2").symbols
            assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  "3 ± 2 cm"  ).units.magnitude == Unit("cm^2").magnitude
            assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  "3 ± 2 cm"  ) == Measure(units=Unit("cm^2"), value= 12, error=error)
            # Value 2: Float
            assert isinstance( ( Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  "0.3 ± 0.2 cm"  ), Measure )
            error = measure._sqrt_( (0.4**2 * 0.2**2 + 0.3**2 * 0.2**2) )
            assert math.isclose( (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  "0.3 ± 0.2 cm"  ).value , 0.3*0.4 )
            assert math.isclose( (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  "0.3 ± 0.2 cm"  ).error , error   )
            assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  "0.3 ± 0.2 cm"  ).implied == False
            assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  "0.3 ± 0.2 cm"  ).units.symbols   == Unit("cm^2").symbols
            assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  "0.3 ± 0.2 cm"  ).units.magnitude == Unit("cm^2").magnitude
            assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  "0.3 ± 0.2 cm"  ) == Measure(units=Unit("cm^2"), value= 0.3*0.4, error=error)
            # Value 3: Decimal
            assert isinstance( (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  "30 ± 20 cm"  ), Measure )
            error = measure._sqrt_( (Decimal("40")**2 * Decimal("20")**2 + Decimal("30")**2 * Decimal("20")**2) )
            assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  "30 ± 20 cm"  ).value   == Decimal("1200")
            assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  "30 ± 20 cm"  ).error   == error
            assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  "30 ± 20 cm"  ).implied == False
            assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  "30 ± 20 cm"  ).units.symbols   == Unit("cm^2").symbols
            assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  "30 ± 20 cm"  ).units.magnitude == Unit("cm^2").magnitude
            assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  "30 ± 20 cm"  ) == Measure(units=Unit("cm^2"), value= Decimal("1200"), error=error)
            # Value 4: Negative
            assert isinstance( ( Measure(value=-4,error=2,unit=Unit("cm"))  *  "-3 ± 2 cm"  ), Measure )
            error = measure._sqrt_( (Decimal("4")**2 * Decimal("2")**2 + Decimal("3")**2 * Decimal("2")**2) )
            assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  "-3 ± 2 cm"  ).value   == 12
            assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  "-3 ± 2 cm"  ).error   == error
            assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  "-3 ± 2 cm"  ).implied == False
            assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  "-3 ± 2 cm"  ).units.symbols   == Unit("cm^2").symbols
            assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  "-3 ± 2 cm"  ).units.magnitude == Unit("cm^2").magnitude
            assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  "-3 ± 2 cm"  ) == Measure(units=Unit("cm^2"), value= 12, error=error)
          # Magnitude Units
          if(True):
            # Value 1: Int
            assert isinstance( (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  "5 ± 1 * 5 m^2"  ) , Measure )
            error = measure._sqrt_( (Decimal(25)**2 * Decimal(5)**2 + Decimal(10)**2 * Decimal(5)**2) )/Decimal(25)
            assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  "5 ± 1 * 5 m^2"  ).value   == 10
            assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  "5 ± 1 * 5 m^2"  ).error   == error
            assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  "5 ± 1 * 5 m^2"  ).implied == False
            assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  "5 ± 1 * 5 m^2"  ).units.symbols   == Unit("25 m^4").symbols
            assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  "5 ± 1 * 5 m^2"  ).units.magnitude == Unit("25 m^4").magnitude
            assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  "5 ± 1 * 5 m^2"  ) == Measure(units=Unit("25 m^4"), value=10, error=error)
            # Value 2: Float
            assert isinstance( (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  "0.5 ± 0.1 * 5 m^2"  ) , Measure )
            error = measure._sqrt_( (2.5**2 * 0.5**2 + 1.0**2 * 0.5**2) )/25
            assert math.isclose( (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  "0.5 ± 0.1 * 5 m^2"  ).value , 0.1   )
            assert math.isclose( (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  "0.5 ± 0.1 * 5 m^2"  ).error , error )
            assert (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  "0.5 ± 0.1 * 5 m^2"  ).implied == False
            assert (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  "0.5 ± 0.1 * 5 m^2"  ).units.symbols   == Unit("25 m^4").symbols
            assert (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  "0.5 ± 0.1 * 5 m^2"  ).units.magnitude == Unit("25 m^4").magnitude
            assert (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  "0.5 ± 0.1 * 5 m^2"  ) == Measure(units=Unit("25 m^4"), value=0.1, error=error)
            # Value 3: Decimal
            assert isinstance( (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  "50 ± 2 * 5 m^2"  ) , Measure )
            error = measure._sqrt_( (Decimal("250")**2 * Decimal("25")**2 + Decimal("100")**2 * Decimal("10")**2) )/Decimal("25")
            assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  "50 ± 2 * 5 m^2"  ) == Measure(units=Unit("25 m^4"), value=Decimal("1000"), error=error)
            assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  "50 ± 2 * 5 m^2"  ).value   == Decimal("1000")
            assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  "50 ± 2 * 5 m^2"  ).error   == error
            assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  "50 ± 2 * 5 m^2"  ).implied == False
            assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  "50 ± 2 * 5 m^2"  ).units.symbols   == Unit("25 m^4").symbols
            assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  "50 ± 2 * 5 m^2"  ).units.magnitude == Unit("25 m^4").magnitude
            # Value 4: Negative
            assert isinstance( (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  "-5 ± 1 * 5 m^2"  ) , Measure )
            error = measure._sqrt_( (Decimal(25)**2 * Decimal(5)**2 + Decimal(10)**2 * Decimal(5)**2) )/Decimal(25)
            assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  "-5 ± 1 * 5 m^2"  ) == Measure(units=Unit("25 m^4"), value=10, error=error)
            assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  "-5 ± 1 * 5 m^2"  ).value   == 10
            assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  "-5 ± 1 * 5 m^2"  ).error   == error
            assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  "-5 ± 1 * 5 m^2"  ).implied == False
            assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  "-5 ± 1 * 5 m^2"  ).units.symbols   == Unit("25 m^4").symbols
            assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  "-5 ± 1 * 5 m^2"  ).units.magnitude == Unit("25 m^4").magnitude
          # Convoluted Units
          if(True):
            # Value 1: Int
            assert isinstance( ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  "27 ± 2 \u00B0C" ), Measure )
            error = measure._sqrt_( (Decimal("300.15")**2 * Decimal("1")**2 + Decimal("300.15")**2 * Decimal("2")**2) )
            assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  "27 ± 2 \u00B0C" ).value   == Decimal("300.15")*Decimal("300.15")
            assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  "27 ± 2 \u00B0C" ).error   == error
            assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  "27 ± 2 \u00B0C" ).implied == False
            assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  "27 ± 2 \u00B0C" ).units.symbols   == Unit("K^2").symbols
            assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  "27 ± 2 \u00B0C" ).units.magnitude == Unit("K^2").magnitude
            assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  "27 ± 2 \u00B0C" ) == Measure(units=Unit("K^2"), value= Decimal("300.15")*Decimal("300.15"), error=error)
            # Value 2: Float
            assert isinstance( ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  "26.85 ± 0.02 \u00B0C" ), Measure )
            error = measure._sqrt_( (300**2 * 0.02**2 + 300**2 * 0.02**2) )
            assert math.isclose( ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  "26.85 ± 0.02 \u00B0C" ).value   , 300 * 300 )
            assert math.isclose( ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  "26.85 ± 0.02 \u00B0C" ).error   , error )
            assert ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  "26.85 ± 0.02 \u00B0C" ).implied == False 
            assert ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  "26.85 ± 0.02 \u00B0C" ).units.symbols   == Unit("K^2").symbols
            assert ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  "26.85 ± 0.02 \u00B0C" ).units.magnitude == Unit("K^2").magnitude
            assert ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  "26.85 ± 0.02 \u00B0C" ) == Measure(units=Unit("K^2"), value=300 * 300, error=error)
            # Value 3: Decimal
            assert isinstance( ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  "26.85 ± 0.02 \u00B0C" ), Measure )
            error = measure._sqrt_( (Decimal("300")**2 * Decimal("0.02")**2 + Decimal("300")**2 * Decimal("0.02")**2) )
            assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  "26.85 ± 0.02 \u00B0C" ).value   == Decimal("300") * Decimal("300") 
            assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  "26.85 ± 0.02 \u00B0C" ).error   == error
            assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  "26.85 ± 0.02 \u00B0C" ).implied == False
            assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  "26.85 ± 0.02 \u00B0C" ).units.symbols   == Unit("K^2").symbols
            assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  "26.85 ± 0.02 \u00B0C" ).units.magnitude == Unit("K^2").magnitude
            assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  "26.85 ± 0.02 \u00B0C" ) == Measure(units=Unit("K^2"), value=Decimal("300") * Decimal("300"), error=error)
            # Value 4: Negative
            assert isinstance( ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  "-27 ± 2 \u00B0C" ), Measure )
            error = measure._sqrt_( (Decimal("246.15")**2 * Decimal("1")**2 + Decimal("246.15")**2 * Decimal("2")**2) )
            assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  "-27 ± 2 \u00B0C" ).value   == Decimal("246.15")*Decimal("246.15")
            assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  "-27 ± 2 \u00B0C" ).error   == error
            assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  "-27 ± 2 \u00B0C" ).implied == False
            assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  "-27 ± 2 \u00B0C" ).units.symbols   == Unit("K^2").symbols
            assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  "-27 ± 2 \u00B0C" ).units.magnitude == Unit("K^2").magnitude
            assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  "-27 ± 2 \u00B0C" ) == Measure(units=Unit("K^2"), value= Decimal("246.15")*Decimal("246.15"), error=error)
          # Canceling Units
          if(True):
            # Value 1: Int
            assert isinstance( ( Measure(value=4,error=2,unit=Unit("cm"))  *  "3 ± 2 cm^-1"  ), Measure )
            error = measure._sqrt_( (Decimal("4")**2 * Decimal("2")**2 + Decimal("3")**2 * Decimal("2")**2) )
            assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  "3 ± 2 cm^-1"  ).value   == 12
            assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  "3 ± 2 cm^-1"  ).error   == error
            assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  "3 ± 2 cm^-1"  ).implied == False
            assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  "3 ± 2 cm^-1"  ).units.symbols   == Unit().symbols
            assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  "3 ± 2 cm^-1"  ).units.magnitude == Unit().magnitude
            assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  "3 ± 2 cm^-1"  ) == Measure(units=Unit(), value= 12, error=error)
            # Value 2: Float
            assert isinstance( ( Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  "0.3 ± 0.2 cm^-1"  ), Measure )
            error = measure._sqrt_( (0.4**2 * 0.2**2 + 0.3**2 * 0.2**2) )
            assert math.isclose( (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  "0.3 ± 0.2 cm^-1"  ).value , 0.3*0.4 )
            assert math.isclose( (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  "0.3 ± 0.2 cm^-1"  ).error , error   )
            assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  "0.3 ± 0.2 cm^-1"  ).implied == False
            assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  "0.3 ± 0.2 cm^-1"  ).units.symbols   == Unit().symbols
            assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  "0.3 ± 0.2 cm^-1"  ).units.magnitude == Unit().magnitude
            assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  "0.3 ± 0.2 cm^-1"  ) == Measure(units=Unit(), value= 0.3*0.4, error=error)
            # Value 3: Decimal
            assert isinstance( (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  * "30 ± 20 cm^-1"  ), Measure )
            error = measure._sqrt_( (Decimal("40")**2 * Decimal("20")**2 + Decimal("30")**2 * Decimal("20")**2) )
            assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  * "30 ± 20 cm^-1"  ).value   == Decimal("1200")
            assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  * "30 ± 20 cm^-1"  ).error   == error
            assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  * "30 ± 20 cm^-1"  ).implied == False
            assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  * "30 ± 20 cm^-1"  ).units.symbols   == Unit().symbols
            assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  * "30 ± 20 cm^-1"  ).units.magnitude == Unit().magnitude
            assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  * "30 ± 20 cm^-1"  ) == Measure(units=Unit(), value= Decimal("1200"), error=error)
            # Value 4: Negative
            assert isinstance( ( Measure(value=-4,error=2,unit=Unit("cm"))  *  "-3 ± 2 cm^-1"  ), Measure )
            error = measure._sqrt_( (Decimal("4")**2 * Decimal("2")**2 + Decimal("3")**2 * Decimal("2")**2) )
            assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  "-3 ± 2 cm^-1"  ).value   == 12
            assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  "-3 ± 2 cm^-1"  ).error   == error
            assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  "-3 ± 2 cm^-1"  ).implied == False
            assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  "-3 ± 2 cm^-1"  ).units.symbols   == Unit().symbols
            assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  "-3 ± 2 cm^-1"  ).units.magnitude == Unit().magnitude
            assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  "-3 ± 2 cm^-1"  ) == Measure(units=Unit(), value= 12, error=error)
          # Preserve Inputs
          if(True):
            a = Measure(value=4,error=2,unit=Unit("cm"))
            b = "3 ± 2 cm"
            c = a*b
            c = None
            assert a == Measure(value=4,error=2,unit=Unit("cm"))
            assert b == "3 ± 2 cm"
      # Measure (Explicit Error) * Str Measure (Implicit Error) = Measure (Implicit Error)
      if(True):
        # Unitless * Unitless
        if(True):
          # PASS:   Str Implicit Error Unitless Measures are indistinguishable from Numbers.
          pass
        # Unitless * Unit
        if(True):
          # Normal Units
          if(True):
            # Value 1: Int
            assert isinstance( (  Measure(value=3,error=2)  *  "4 cm"  ), Measure )
            error = measure._sqrt_( (Decimal(3)**2 * Decimal("0.5")**2 + Decimal(4)**2 * Decimal(2)**2) )
            assert (  Measure(value=3,error=2)  *  "4 cm"  ).value   == 12
            assert (  Measure(value=3,error=2)  *  "4 cm"  ).error   == error
            assert (  Measure(value=3,error=2)  *  "4 cm"  ).implied == True
            assert (  Measure(value=3,error=2)  *  "4 cm"  ).units.symbols   == Unit("cm").symbols
            assert (  Measure(value=3,error=2)  *  "4 cm"  ).units.magnitude == Unit("cm").magnitude
            assert (  Measure(value=3,error=2)  *  "4 cm"  ) == Measure(units=Unit("cm"), value= 12, error=error)
            # Value 2: Float
            assert isinstance( (  Measure(value=0.3,error=0.2)  *  "0.4 cm" ), Measure )
            error = measure._sqrt_( (0.4**2 * 0.2**2 + 0.3**2 * 0.05**2) )
            assert math.isclose( (  Measure(value=0.3,error=0.2)  *  "0.4 cm"  ).value , 0.3*0.4 )
            assert math.isclose( (  Measure(value=0.3,error=0.2)  *  "0.4 cm"  ).error , error   )
            assert (  Measure(value=0.3,error=0.2)  *  "0.4 cm"  ).implied == True
            assert (  Measure(value=0.3,error=0.2)  *  "0.4 cm"  ).units.symbols   == Unit("cm").symbols
            assert (  Measure(value=0.3,error=0.2)  *  "0.4 cm"  ).units.magnitude == Unit("cm").magnitude
            assert (  Measure(value=0.3,error=0.2)  *  "0.4 cm"  ) == Measure(units=Unit("cm"), value= 0.3*0.4, error=error)
            # Value 3: Decimal
            assert isinstance( (  Measure(value=Decimal("40"),error=Decimal("20"))  *  "30 cm"  ), Measure )
            error = measure._sqrt_( ( Decimal("40")**2 * Decimal("5")**2 + Decimal("30")**2 * Decimal("20")**2) )
            assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  "30 cm"  ).value   == Decimal("1200")
            assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  "30 cm"  ).error   == error
            assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  "30 cm"  ).implied == True
            assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  "30 cm"  ).units.symbols   == Unit("cm").symbols
            assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  "30 cm"  ).units.magnitude == Unit("cm").magnitude
            assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  "30 cm"  ) == Measure(units=Unit("cm"), value= Decimal("1200"), error=error)
            # Value 4: Negative
            assert isinstance( (  Measure(value=-3,error=2)  *  "-4 cm"  ), Measure )
            error = measure._sqrt_( (Decimal(3)**2 * Decimal("0.5")**2 + Decimal(4)**2 * Decimal(2)**2) )
            assert (  Measure(value=-3,error=2)  *  "-4 cm"  ).value   == 12
            assert (  Measure(value=-3,error=2)  *  "-4 cm"  ).error   == error
            assert (  Measure(value=-3,error=2)  *  "-4 cm"  ).implied == True
            assert (  Measure(value=-3,error=2)  *  "-4 cm"  ).units.symbols   == Unit("cm").symbols
            assert (  Measure(value=-3,error=2)  *  "-4 cm"  ).units.magnitude == Unit("cm").magnitude
            assert (  Measure(value=-3,error=2)  *  "-4 cm"  ) == Measure(units=Unit("cm"), value= 12, error=error)
          # Magnitude Units
          if(True):
            # Value 1: Int
            assert isinstance( (  Measure(value=5,error=1)  *  "2 * 5 m^2"  ) , Measure )
            error = measure._sqrt_( (Decimal("5")**2 * Decimal("2.5")**2 + Decimal("10")**2 * Decimal("1")**2) )/Decimal("5")
            assert (  Measure(value=5,error=1)  *  "2 * 5 m^2"  ) == Measure(units=Unit("5 m^2"), value=10, error=error)
            assert (  Measure(value=5,error=1)  *  "2 * 5 m^2"  ).value   == 10
            #assert (  Measure(value=5,error=1)  *  "2 * 5 m^2"  ).error   == error
            # The above won't work, do to changes on uncertain even for decimal operations (due to calculating and back-calculating in unit operations).
            assert Measure._dec_isclose_( (Measure(value=5,error=1)  *  "2 * 5 m^2").error , error )
            assert (  Measure(value=5,error=1)  *  "2 * 5 m^2"  ).implied == True
            assert (  Measure(value=5,error=1)  *  "2 * 5 m^2"  ).units.symbols   == Unit("5 m^2").symbols
            assert (  Measure(value=5,error=1)  *  "2 * 5 m^2"  ).units.magnitude == Unit("5 m^2").magnitude
            # Value 2: Float
            assert isinstance( (  Measure(value=0.5,error=0.1)  *  "0.2 * 5 m^2"  ) , Measure )
            error = measure._sqrt_( (0.5**2 * 0.25**2 + 1.0**2 * 0.1**2) )/5
            assert (  Measure(value=0.5,error=0.1)  *  "0.2 * 5 m^2"  ) == Measure(units=Unit("5 m^2"), value=0.1, error=error)
            assert math.isclose( (  Measure(value=0.5,error=0.1)  *  "0.2 * 5 m^2"  ).value , 0.1   )
            assert math.isclose( (  Measure(value=0.5,error=0.1)  *  "0.2 * 5 m^2"  ).error , error )
            assert (  Measure(value=0.5,error=0.1)  *  "0.2 * 5 m^2"  ).implied == True
            assert (  Measure(value=0.5,error=0.1)  *  "0.2 * 5 m^2"  ).units.symbols   == Unit("5 m^2").symbols
            assert (  Measure(value=0.5,error=0.1)  *  "0.2 * 5 m^2"  ).units.magnitude == Unit("5 m^2").magnitude
            # Value 3: Decimal
            assert isinstance( (  Measure(value=Decimal("50"),error=Decimal("2"))  *  "20 * 5 m^2"  ) , Measure )
            error = measure._sqrt_( (Decimal("50")**2 * Decimal("25")**2 + Decimal("100")**2 * Decimal("2")**2) )/Decimal("5")
            assert (  Measure(value=Decimal("50"),error=Decimal("2"))  *  "20 * 5 m^2"  ) == Measure(units=Unit("5 m^2"), value=Decimal("1000"), error=error)
            assert (  Measure(value=Decimal("50"),error=Decimal("2"))  *  "20 * 5 m^2"  ).value   == Decimal("1000")
            assert (  Measure(value=Decimal("50"),error=Decimal("2"))  *  "20 * 5 m^2"  ).error   == error
            assert (  Measure(value=Decimal("50"),error=Decimal("2"))  *  "20 * 5 m^2"  ).implied == True
            assert (  Measure(value=Decimal("50"),error=Decimal("2"))  *  "20 * 5 m^2"  ).units.symbols   == Unit("5 m^2").symbols
            assert (  Measure(value=Decimal("50"),error=Decimal("2"))  *  "20 * 5 m^2"  ).units.magnitude == Unit("5 m^2").magnitude
            # Value 4: Negative
            assert isinstance( (  Measure(value=-5,error=1)  *  "-2 * 5 m^2"  ) , Measure )
            error = measure._sqrt_( (Decimal("5")**2 * Decimal("2.5")**2 + Decimal("10")**2 * Decimal("1")**2) )/Decimal("5")
            assert (  Measure(value=-5,error=1)  *  "-2 * 5 m^2"  ) == Measure(units=Unit("5 m^2"), value=10, error=error)
            assert (  Measure(value=-5,error=1)  *  "-2 * 5 m^2"  ).value   == 10
            #assert (  Measure(value=-5,error=1)  *  "-2 * 5 m^2"  ).error   == error
            # The above won't work, do to changes on uncertain even for decimal operations (due to calculating and back-calculating in unit operations).
            assert Measure._dec_isclose_( (Measure(value=-5,error=1)  *  "-2 * 5 m^2").error , error )
            assert (  Measure(value=-5,error=1)  *  "-2 * 5 m^2"  ).implied == True
            assert (  Measure(value=-5,error=1)  *  "-2 * 5 m^2"  ).units.symbols   == Unit("5 m^2").symbols
            assert (  Measure(value=-5,error=1)  *  "-2 * 5 m^2"  ).units.magnitude == Unit("5 m^2").magnitude
          # Convoluted Units
          if(True):
            # Value 1: Int
            assert isinstance( ( Measure(value=300,error=2)  *  "27 \u00B0C" ), Measure )
            error = measure._sqrt_( (Decimal("300")**2 * Decimal("0.5")**2 + Decimal("300.15")**2 * Decimal("2")**2) )
            assert ( Measure(value=300,error=2)  *  "27 \u00B0C" ).value   == Decimal("300.15")*Decimal("300") - Decimal("273.15")
            assert ( Measure(value=300,error=2)  *  "27 \u00B0C" ).error   == error
            assert ( Measure(value=300,error=2)  *  "27 \u00B0C" ).implied == True
            assert ( Measure(value=300,error=2)  *  "27 \u00B0C" ).units.symbols   == Unit("\u00B0C").symbols
            assert ( Measure(value=300,error=2)  *  "27 \u00B0C" ).units.magnitude == Unit("\u00B0C").magnitude
            assert ( Measure(value=300,error=2)  *  "27 \u00B0C" ) == Measure(units=Unit("\u00B0C"), value= Decimal("300.15")*Decimal("300") - Decimal("273.15"), error=error)
            # Value 2: Float
            assert isinstance( ( Measure(value=299.9,error=0.02)  *  "26.85 \u00B0C" ), Measure )
            error = measure._sqrt_( (299.9**2 * 0.005**2 + 300**2 * 0.02**2) )
            assert math.isclose( ( Measure(value=299.9,error=0.02)  *  "26.85 \u00B0C" ).value  , 299.9 * 300 - 273.15 )
            assert math.isclose( ( Measure(value=299.9,error=0.02)  *  "26.85 \u00B0C" ).error  , error )
            assert ( Measure(value=299.9,error=0.02)  *  "26.85 \u00B0C" ).implied == True 
            assert ( Measure(value=299.9,error=0.02)  *  "26.85 \u00B0C" ).units.symbols   == Unit("\u00B0C").symbols
            assert ( Measure(value=299.9,error=0.02)  *  "26.85 \u00B0C" ).units.magnitude == Unit("\u00B0C").magnitude
            assert ( Measure(value=299.9,error=0.02)  *  "26.85 \u00B0C" ) == Measure(units=Unit("\u00B0C"), value=299.9 * 300 - 273.15, error=error)
            # Value 3: Decimal
            assert isinstance( ( Measure(value=Decimal("300"),error=Decimal("0.02"))  *  "26.85 \u00B0C" ), Measure )
            error = measure._sqrt_( (Decimal("300")**2 * Decimal("0.005")**2 + Decimal("300")**2 * Decimal("0.02")**2) )
            assert ( Measure(value=Decimal("300"),error=Decimal("0.02"))  *  "26.85 \u00B0C" ).value   == Decimal("300") * Decimal("300") - Decimal("273.15") 
            assert ( Measure(value=Decimal("300"),error=Decimal("0.02"))  *  "26.85 \u00B0C" ).error   == error
            assert ( Measure(value=Decimal("300"),error=Decimal("0.02"))  *  "26.85 \u00B0C" ).implied == True
            assert ( Measure(value=Decimal("300"),error=Decimal("0.02"))  *  "26.85 \u00B0C" ).units.symbols   == Unit("\u00B0C").symbols
            assert ( Measure(value=Decimal("300"),error=Decimal("0.02"))  *  "26.85 \u00B0C" ).units.magnitude == Unit("\u00B0C").magnitude
            assert ( Measure(value=Decimal("300"),error=Decimal("0.02"))  *  "26.85 \u00B0C" ) == Measure(units=Unit("\u00B0C"), value=Decimal("300") * Decimal("300") - Decimal("273.15"), error=error)
            # Value 4: Negative
            assert isinstance( ( Measure(value=300,error=2)  *  "-27 \u00B0C" ), Measure )
            error = measure._sqrt_( (Decimal("300")**2 * Decimal("0.5")**2 + Decimal("246.15")**2 * Decimal("2")**2) )
            assert ( Measure(value=300,error=2)  *  "-27 \u00B0C" ).value   == Decimal("246.15")*Decimal("300") - Decimal("273.15")
            assert ( Measure(value=300,error=2)  *  "-27 \u00B0C" ).error   == error
            assert ( Measure(value=300,error=2)  *  "-27 \u00B0C" ).implied == True
            assert ( Measure(value=300,error=2)  *  "-27 \u00B0C" ).units.symbols   == Unit("\u00B0C").symbols
            assert ( Measure(value=300,error=2)  *  "-27 \u00B0C" ).units.magnitude == Unit("\u00B0C").magnitude
            assert ( Measure(value=300,error=2)  *  "-27 \u00B0C" ) == Measure(units=Unit("\u00B0C"), value= Decimal("246.15")*Decimal("300") - Decimal("273.15"), error=error)
          # Preserve Inputs
          if(True):
            a = Measure(value=3,error=2) 
            b = "4 cm"
            c = a*b
            c = None
            assert a == Measure(value=3,error=2) 
            assert b == "4 cm"
        # Unit * Unitless
        if(True):
          # PASS:   Str Implicit Error Unitless Measures are indistinguishable from Numbers.
          pass
        # Units * Units
        if(True):
          # Normal Units
          if(True):
            # Value 1: Int
            assert isinstance( ( Measure(value=4,error=2,unit=Unit("cm"))  *  "3 cm"  ), Measure )
            error = measure._sqrt_( (Decimal(4)**2 * Decimal("0.5")**2 + Decimal(3)**2 * Decimal(2)**2) )
            assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  "3 cm"  ).value   == 12
            assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  "3 cm"  ).error   == error
            assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  "3 cm"  ).implied == True
            assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  "3 cm"  ).units.symbols   == Unit("cm^2").symbols
            assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  "3 cm"  ).units.magnitude == Unit("cm^2").magnitude
            assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  "3 cm"  ) == Measure(units=Unit("cm^2"), value= 12, error=error)
            # Value 2: Float
            assert isinstance( ( Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  "0.3 cm"  ), Measure )
            error = measure._sqrt_( (0.4**2 * 0.05**2 + 0.3**2 * 0.2**2) )
            assert math.isclose( (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  "0.3 cm"  ).value , 0.3*0.4 )
            assert math.isclose( (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  "0.3 cm"  ).error , error   )
            assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  "0.3 cm"  ).implied == True
            assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  "0.3 cm"  ).units.symbols   == Unit("cm^2").symbols
            assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  "0.3 cm"  ).units.magnitude == Unit("cm^2").magnitude
            assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  "0.3 cm"  ) == Measure(units=Unit("cm^2"), value= 0.3*0.4, error=error)
            # Value 3: Decimal
            assert isinstance( (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  "30 cm"  ), Measure )
            error = measure._sqrt_( (Decimal("40")**2 * Decimal("5")**2 + Decimal("30")**2 * Decimal("20")**2) )
            assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  "30 cm"  ).value   == Decimal("1200")
            assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  "30 cm"  ).error   == error
            assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  "30 cm"  ).implied == True
            assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  "30 cm"  ).units.symbols   == Unit("cm^2").symbols
            assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  "30 cm"  ).units.magnitude == Unit("cm^2").magnitude
            assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  "30 cm"  ) == Measure(units=Unit("cm^2"), value= Decimal("1200"), error=error)
            # Value 4: Negative
            assert isinstance( ( Measure(value=-4,error=2,unit=Unit("cm"))  *  "-3 cm"  ), Measure )
            error = measure._sqrt_( (Decimal(4)**2 * Decimal("0.5")**2 + Decimal(3)**2 * Decimal(2)**2) )
            assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  "-3 cm"  ).value   == 12
            assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  "-3 cm"  ).error   == error
            assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  "-3 cm"  ).implied == True
            assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  "-3 cm"  ).units.symbols   == Unit("cm^2").symbols
            assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  "-3 cm"  ).units.magnitude == Unit("cm^2").magnitude
            assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  "-3 cm"  ) == Measure(units=Unit("cm^2"), value= 12, error=error)
          # Magnitude Units
          if(True):
            # Value 1: Int
            assert isinstance( (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  "5 * 5 m^2"  ) , Measure )
            error = measure._sqrt_( (Decimal(25)**2 * Decimal(5)**2 + Decimal(10)**2 * Decimal("2.5")**2) )/Decimal(25)
            assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  "5 * 5 m^2"  ).value   == 10
            assert Measure._dec_isclose_( (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  "5 * 5 m^2"  ).error   , error )
            assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  "5 * 5 m^2"  ).implied == True
            assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  "5 * 5 m^2"  ).units.symbols   == Unit("25 m^4").symbols
            assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  "5 * 5 m^2"  ).units.magnitude == Unit("25 m^4").magnitude
            assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  "5 * 5 m^2"  ) == Measure(units=Unit("25 m^4"), value=10, error=error)
            # Value 2: Float
            assert isinstance( (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  "0.5 * 5 m^2"  ) , Measure )
            error = measure._sqrt_( (2.5**2 * 0.5**2 + 1.0**2 * 0.25**2) )/25
            assert math.isclose( (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  "0.5 * 5 m^2"  ).value , 0.1   )
            assert math.isclose( (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  "0.5 * 5 m^2"  ).error , error )
            assert (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  "0.5 * 5 m^2"  ).implied == True
            assert (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  "0.5 * 5 m^2"  ).units.symbols   == Unit("25 m^4").symbols
            assert (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  "0.5 * 5 m^2"  ).units.magnitude == Unit("25 m^4").magnitude
            assert (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  "0.5 * 5 m^2"  ) == Measure(units=Unit("25 m^4"), value=0.1, error=error)
            # Value 3: Decimal
            assert isinstance( (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  "50 * 5 m^2"  ) , Measure )
            error = measure._sqrt_( (Decimal("250")**2 * Decimal("25")**2 + Decimal("100")**2 * Decimal("25")**2) )/Decimal("25")
            assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  "50 * 5 m^2"  ) == Measure(units=Unit("25 m^4"), value=Decimal("1000"), error=error)
            assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  "50 * 5 m^2"  ).value   == Decimal("1000")
            assert Measure._dec_isclose_( (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  "50 * 5 m^2"  ).error   , error )
            assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  "50 * 5 m^2"  ).implied == True
            assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  "50 * 5 m^2"  ).units.symbols   == Unit("25 m^4").symbols
            assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  "50 * 5 m^2"  ).units.magnitude == Unit("25 m^4").magnitude
            # Value 4: Negative
            assert isinstance( (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  "-5 * 5 m^2"  ) , Measure )
            error = measure._sqrt_( (Decimal(25)**2 * Decimal(5)**2 + Decimal(10)**2 * Decimal("2.5")**2) )/Decimal(25)
            assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  "-5 * 5 m^2"  ) == Measure(units=Unit("25 m^4"), value=10, error=error)
            assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  "-5 * 5 m^2"  ).value   == 10
            assert Measure._dec_isclose_( (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  "-5 * 5 m^2"  ).error   , error )
            assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  "-5 * 5 m^2"  ).implied == True
            assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  "-5 * 5 m^2"  ).units.symbols   == Unit("25 m^4").symbols
            assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  "-5 * 5 m^2"  ).units.magnitude == Unit("25 m^4").magnitude
          # Convoluted Units
          if(True):
            # Value 1: Int
            assert isinstance( ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  "27 \u00B0C" ), Measure )
            error = measure._sqrt_( (Decimal("300.15")**2 * Decimal("1")**2 + Decimal("300.15")**2 * Decimal("0.5")**2) )
            assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  "27 \u00B0C" ).value   == Decimal("300.15")*Decimal("300.15")
            assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  "27 \u00B0C" ).error   == error
            assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  "27 \u00B0C" ).implied == True
            assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  "27 \u00B0C" ).units.symbols   == Unit("K^2").symbols
            assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  "27 \u00B0C" ).units.magnitude == Unit("K^2").magnitude
            assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  "27 \u00B0C" ) == Measure(units=Unit("K^2"), value= Decimal("300.15")*Decimal("300.15"), error=error)
            # Value 2: Float
            assert isinstance( ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  "26.85 \u00B0C" ), Measure )
            error = measure._sqrt_( (300**2 * 0.02**2 + 300**2 * 0.005**2) )
            assert math.isclose( ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  "26.85 \u00B0C" ).value   , 300 * 300 )
            assert math.isclose( ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  "26.85 \u00B0C" ).error   , error )
            assert ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  "26.85 \u00B0C" ).implied == True
            assert ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  "26.85 \u00B0C" ).units.symbols   == Unit("K^2").symbols
            assert ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  "26.85 \u00B0C" ).units.magnitude == Unit("K^2").magnitude
            assert ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  "26.85 \u00B0C" ) == Measure(units=Unit("K^2"), value=300 * 300, error=error)
            # Value 3: Decimal
            assert isinstance( ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  "26.85 \u00B0C" ), Measure )
            error = measure._sqrt_( (Decimal("300")**2 * Decimal("0.02")**2 + Decimal("300")**2 * Decimal("0.005")**2) )
            assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  "26.85 \u00B0C" ).value   == Decimal("300") * Decimal("300") 
            assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  "26.85 \u00B0C" ).error   == error
            assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  "26.85 \u00B0C" ).implied == True
            assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  "26.85 \u00B0C" ).units.symbols   == Unit("K^2").symbols
            assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  "26.85 \u00B0C" ).units.magnitude == Unit("K^2").magnitude
            assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  "26.85 \u00B0C" ) == Measure(units=Unit("K^2"), value=Decimal("300") * Decimal("300"), error=error)
            # Value 4: Negative
            assert isinstance( ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  "-27 \u00B0C" ), Measure )
            error = measure._sqrt_( (Decimal("246.15")**2 * Decimal("1")**2 + Decimal("246.15")**2 * Decimal("0.5")**2) )
            assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  "-27 \u00B0C" ).value   == Decimal("246.15")*Decimal("246.15")
            assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  "-27 \u00B0C" ).error   == error
            assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  "-27 \u00B0C" ).implied == True
            assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  "-27 \u00B0C" ).units.symbols   == Unit("K^2").symbols
            assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  "-27 \u00B0C" ).units.magnitude == Unit("K^2").magnitude
            assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  "-27 \u00B0C" ) == Measure(units=Unit("K^2"), value= Decimal("246.15")*Decimal("246.15"), error=error)
          # Canceling Units
          if(True):
            # Value 1: Int
            assert isinstance( ( Measure(value=4,error=2,unit=Unit("cm"))  *  "3 cm^-1"  ), Measure )
            error = measure._sqrt_( (Decimal(4)**2 * Decimal("0.5")**2 + Decimal(3)**2 * Decimal(2)**2) )
            assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  "3 cm^-1"  ).value   == 12
            assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  "3 cm^-1"  ).error   == error
            assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  "3 cm^-1"  ).implied == True
            assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  "3 cm^-1"  ).units.symbols   == Unit().symbols
            assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  "3 cm^-1"  ).units.magnitude == Unit().magnitude
            assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  "3 cm^-1"  ) == Measure(units=Unit(), value= 12, error=error)
            # Value 2: Float
            assert isinstance( ( Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  "0.3 cm^-1"  ), Measure )
            error = measure._sqrt_( (0.4**2 * 0.05**2 + 0.3**2 * 0.2**2) )
            assert math.isclose( (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  "0.3 cm^-1"  ).value , 0.3*0.4 )
            assert math.isclose( (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  "0.3 cm^-1"  ).error , error   )
            assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  "0.3 cm^-1"  ).implied == True
            assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  "0.3 cm^-1"  ).units.symbols   == Unit().symbols
            assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  "0.3 cm^-1"  ).units.magnitude == Unit().magnitude
            assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  "0.3 cm^-1"  ) == Measure(units=Unit(), value= 0.3*0.4, error=error)
            # Value 3: Decimal
            assert isinstance( (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  "30 cm^-1"  ), Measure )
            error = measure._sqrt_( (Decimal("40")**2 * Decimal("5")**2 + Decimal("30")**2 * Decimal("20")**2) )
            assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  "30 cm^-1"  ).value   == Decimal("1200")
            assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  "30 cm^-1"  ).error   == error
            assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  "30 cm^-1"  ).implied == True
            assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  "30 cm^-1"  ).units.symbols   == Unit().symbols
            assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  "30 cm^-1"  ).units.magnitude == Unit().magnitude
            assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  "30 cm^-1"  ) == Measure(units=Unit(), value= Decimal("1200"), error=error)
            # Value 4: Negative
            assert isinstance( ( Measure(value=-4,error=2,unit=Unit("cm"))  *  "-3 cm^-1"  ), Measure )
            error = measure._sqrt_( (Decimal(4)**2 * Decimal("0.5")**2 + Decimal(3)**2 * Decimal(2)**2) )
            assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  "-3 cm^-1"  ).value   == 12
            assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  "-3 cm^-1"  ).error   == error
            assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  "-3 cm^-1"  ).implied == True
            assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  "-3 cm^-1"  ).units.symbols   == Unit().symbols
            assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  "-3 cm^-1"  ).units.magnitude == Unit().magnitude
            assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  "-3 cm^-1"  ) == Measure(units=Unit(), value= 12, error=error)
          # Preserve Inputs
          if(True):
            a = Measure(value=4,error=2,unit=Unit("cm"))
            b = "3 cm"
            c = a*b
            c = None
            assert a == Measure(value=4,error=2,unit=Unit("cm"))
            assert b == "3 cm"
      # Measure (Implicit Error) * Str Measure (Explicit Error) = Measure (Implicit Error)
      if(True):
        # Unitless * Unitless
        if(True):
          # Value 1: Int
          assert isinstance( ( Measure(value=4)  *  "3 ± 2"  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("2")**2 + Decimal(3)**2 * Decimal("0.5")**2) )
          assert (  Measure(value=4)  *  "3 ± 2"  ).value   == 12
          assert (  Measure(value=4)  *  "3 ± 2"  ).error   == error
          assert (  Measure(value=4)  *  "3 ± 2"  ).implied == True
          assert (  Measure(value=4)  *  "3 ± 2"  ).units.symbols   == Unit().symbols
          assert (  Measure(value=4)  *  "3 ± 2"  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=4)  *  "3 ± 2"  ) == Measure(units=Unit(), value= 12, error=error)
          # Value 2: Float
          assert isinstance( ( Measure(value=0.4)  *  "0.3 ± 0.2"  ), Measure )
          error = measure._sqrt_( (0.4**2 * 0.2**2 + 0.3**2 * 0.05**2) )
          assert math.isclose( (  Measure(value=0.4)  *  "0.3 ± 0.2"  ).value , 0.4*0.3 )
          assert math.isclose( (  Measure(value=0.4)  *  "0.3 ± 0.2"  ).error , error   )
          assert (  Measure(value=0.4)  *  "0.3 ± 0.2"  ).implied == True
          assert (  Measure(value=0.4)  *  "0.3 ± 0.2"  ).units.symbols   == Unit().symbols
          assert (  Measure(value=0.4)  *  "0.3 ± 0.2"  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=0.4)  *  "0.3 ± 0.2"  ) == Measure(units=Unit(), value= 0.4*0.3, error=error)
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("40"))  *  "30 ± 20"  ), Measure )
          error = measure._sqrt_( ( Decimal("40")**2 * Decimal("20")**2 + Decimal("30")**2 * Decimal("5")**2) )
          assert (  Measure(value=Decimal("40"))  *  "30 ± 20"  ).value   == Decimal("1200")
          assert (  Measure(value=Decimal("40"))  *  "30 ± 20"  ).error   == error
          assert (  Measure(value=Decimal("40"))  *  "30 ± 20"  ).implied == True
          assert (  Measure(value=Decimal("40"))  *  "30 ± 20"  ).units.symbols   == Unit().symbols
          assert (  Measure(value=Decimal("40"))  *  "30 ± 20"  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=Decimal("40"))  *  "30 ± 20"  ) == Measure(units=Unit(), value= Decimal("1200"), error=error)
          # Value 4: Negative
          assert isinstance( ( Measure(value=-4)  *  "-3 ± 2"  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("2")**2 + Decimal(3)**2 * Decimal("0.5")**2) )
          assert (  Measure(value=-4)  *  "-3 ± 2"  ).value   == 12
          assert (  Measure(value=-4)  *  "-3 ± 2"  ).error   == error
          assert (  Measure(value=-4)  *  "-3 ± 2"  ).implied == True
          assert (  Measure(value=-4)  *  "-3 ± 2"  ).units.symbols   == Unit().symbols
          assert (  Measure(value=-4)  *  "-3 ± 2"  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=-4)  *  "-3 ± 2"  ) == Measure(units=Unit(), value= 12, error=error)
          # Preserve Inputs
          if(True):
            a = Measure(value=4) 
            b = "3 ± 2"
            c = a*b
            c = None
            assert a == Measure(value=4) 
            assert b == "3 ± 2"
        # Unitless * Unit
        if(True):
          # Normal Units
          if(True):
            # Value 1: Int
            assert isinstance( (  Measure(value=3)  *  "4 ± 2 cm"  ), Measure )
            error = measure._sqrt_( (Decimal(4)**2 * Decimal("0.5")**2 + Decimal(3)**2 * Decimal(2)**2) )
            assert (  Measure(value=3)  *  "4 ± 2 cm"  ).value   == 12
            assert (  Measure(value=3)  *  "4 ± 2 cm"  ).error   == error
            assert (  Measure(value=3)  *  "4 ± 2 cm"  ).implied == True
            assert (  Measure(value=3)  *  "4 ± 2 cm"  ).units.symbols   == Unit("cm").symbols
            assert (  Measure(value=3)  *  "4 ± 2 cm"  ).units.magnitude == Unit("cm").magnitude
            assert (  Measure(value=3)  *  "4 ± 2 cm"  ) == Measure(units=Unit("cm"), value= 12, error=error)
            # Value 2: Float
            assert isinstance( (  Measure(value=0.3)  *  "0.4 ± 0.2 cm" ), Measure )
            error = measure._sqrt_( (0.4**2 * 0.05**2 + 0.3**2 * 0.2**2) )
            assert math.isclose( (  Measure(value=0.3)  *  "0.4 ± 0.2 cm"  ).value , 0.3*0.4 )
            assert math.isclose( (  Measure(value=0.3)  *  "0.4 ± 0.2 cm"  ).error , error   )
            assert (  Measure(value=0.3)  *  "0.4 ± 0.2 cm"  ).implied == True
            assert (  Measure(value=0.3)  *  "0.4 ± 0.2 cm"  ).units.symbols   == Unit("cm").symbols
            assert (  Measure(value=0.3)  *  "0.4 ± 0.2 cm"  ).units.magnitude == Unit("cm").magnitude
            assert (  Measure(value=0.3)  *  "0.4 ± 0.2 cm"  ) == Measure(units=Unit("cm"), value= 0.3*0.4, error=error)
            # Value 3: Decimal
            assert isinstance( (  Measure(value=Decimal("40"))  *  "30 ± 20 cm"  ), Measure )
            error = measure._sqrt_( ( Decimal("40")**2 * Decimal("20")**2 + Decimal("30")**2 * Decimal("5")**2) )
            assert (  Measure(value=Decimal("40"))  *  "30 ± 20 cm"  ).value   == Decimal("1200")
            assert (  Measure(value=Decimal("40"))  *  "30 ± 20 cm"  ).error   == error
            assert (  Measure(value=Decimal("40"))  *  "30 ± 20 cm"  ).implied == True
            assert (  Measure(value=Decimal("40"))  *  "30 ± 20 cm"  ).units.symbols   == Unit("cm").symbols
            assert (  Measure(value=Decimal("40"))  *  "30 ± 20 cm"  ).units.magnitude == Unit("cm").magnitude
            assert (  Measure(value=Decimal("40"))  *  "30 ± 20 cm"  ) == Measure(units=Unit("cm"), value= Decimal("1200"), error=error)
            # Value 4: Negative
            assert isinstance( (  Measure(value=-3)  *  "-4 ± 2 cm"  ), Measure )
            error = measure._sqrt_( (Decimal(4)**2 * Decimal("0.5")**2 + Decimal(3)**2 * Decimal(2)**2) )
            assert (  Measure(value=-3)  *  "-4 ± 2 cm"  ).value   == 12
            assert (  Measure(value=-3)  *  "-4 ± 2 cm"  ).error   == error
            assert (  Measure(value=-3)  *  "-4 ± 2 cm"  ).implied == True
            assert (  Measure(value=-3)  *  "-4 ± 2 cm"  ).units.symbols   == Unit("cm").symbols
            assert (  Measure(value=-3)  *  "-4 ± 2 cm"  ).units.magnitude == Unit("cm").magnitude
            assert (  Measure(value=-3)  *  "-4 ± 2 cm"  ) == Measure(units=Unit("cm"), value= 12, error=error)
          # Magnitude Units
          if(True):
            # Value 1: Int
            assert isinstance( (  Measure(value=5)  *  "2 ± 1 * 5 m^2"  ) , Measure )
            error = measure._sqrt_( (Decimal(5)**2 * Decimal(5)**2 + Decimal(10)**2 * Decimal("0.5")**2) )/Decimal(5)
            assert (  Measure(value=5)  *  "2 ± 1 * 5 m^2"  ) == Measure(units=Unit("5 m^2"), value=10, error=error)
            assert (  Measure(value=5)  *  "2 ± 1 * 5 m^2"  ).value   == 10
            assert (  Measure(value=5)  *  "2 ± 1 * 5 m^2"  ).error   == error
            assert (  Measure(value=5)  *  "2 ± 1 * 5 m^2"  ).implied == True
            assert (  Measure(value=5)  *  "2 ± 1 * 5 m^2"  ).units.symbols   == Unit("5 m^2").symbols
            assert (  Measure(value=5)  *  "2 ± 1 * 5 m^2"  ).units.magnitude == Unit("5 m^2").magnitude
            # Value 2: Float
            assert isinstance( (  Measure(value=0.5)  *  "0.2 ± 0.1 * 5 m^2"  ) , Measure )
            error = measure._sqrt_( (0.5**2 * 0.5**2 + 1.0**2 * 0.05**2) )/5
            assert (  Measure(value=0.5)  *  "0.2 ± 0.1 * 5 m^2"  ) == Measure(units=Unit("5 m^2"), value=0.1, error=error)
            assert math.isclose( (  Measure(value=0.5)  *  "0.2 ± 0.1 * 5 m^2"  ).value , 0.1   )
            assert math.isclose( (  Measure(value=0.5)  *  "0.2 ± 0.1 * 5 m^2"  ).error , error )
            assert (  Measure(value=0.5)  *  "0.2 ± 0.1 * 5 m^2"  ).implied == True
            assert (  Measure(value=0.5)  *  "0.2 ± 0.1 * 5 m^2"  ).units.symbols   == Unit("5 m^2").symbols
            assert (  Measure(value=0.5)  *  "0.2 ± 0.1 * 5 m^2"  ).units.magnitude == Unit("5 m^2").magnitude
            # Value 3: Decimal
            assert isinstance( (  Measure(value=Decimal("50"))  *  "20 ± 5 * 5 m^2"  ) , Measure )
            error = measure._sqrt_( (Decimal("50")**2 * Decimal("25")**2 + Decimal("100")**2 * Decimal("5")**2) )/Decimal("5")
            assert (  Measure(value=Decimal("50"))  *  "20 ± 5 * 5 m^2"  ) == Measure(units=Unit("5 m^2"), value=Decimal("1000"), error=error)
            assert (  Measure(value=Decimal("50"))  *  "20 ± 5 * 5 m^2"  ).value   == Decimal("1000")
            assert (  Measure(value=Decimal("50"))  *  "20 ± 5 * 5 m^2"  ).error   == error
            assert (  Measure(value=Decimal("50"))  *  "20 ± 5 * 5 m^2"  ).implied == True
            assert (  Measure(value=Decimal("50"))  *  "20 ± 5 * 5 m^2"  ).units.symbols   == Unit("5 m^2").symbols
            assert (  Measure(value=Decimal("50"))  *  "20 ± 5 * 5 m^2"  ).units.magnitude == Unit("5 m^2").magnitude
            # Value 4: Negative
            assert isinstance( (  Measure(value=-5)  *  "-2 ± 1 * 5 m^2"  ) , Measure )
            error = measure._sqrt_( (Decimal(5)**2 * Decimal(5)**2 + Decimal(10)**2 * Decimal("0.5")**2) )/Decimal(5)
            assert (  Measure(value=-5)  *  "-2 ± 1 * 5 m^2"  ) == Measure(units=Unit("5 m^2"), value=10, error=error)
            assert (  Measure(value=-5)  *  "-2 ± 1 * 5 m^2"  ).value   == 10
            assert (  Measure(value=-5)  *  "-2 ± 1 * 5 m^2"  ).error   == error
            assert (  Measure(value=-5)  *  "-2 ± 1 * 5 m^2"  ).implied == True
            assert (  Measure(value=-5)  *  "-2 ± 1 * 5 m^2"  ).units.symbols   == Unit("5 m^2").symbols
            assert (  Measure(value=-5)  *  "-2 ± 1 * 5 m^2"  ).units.magnitude == Unit("5 m^2").magnitude
          # Convoluted Units
          if(True):
            # Value 1: Int
            assert isinstance( ( Measure(value=300)  *  "27 ± 1 \u00B0C" ), Measure )
            error = measure._sqrt_( (Decimal("300")**2 * Decimal("1")**2 + Decimal("300.15")**2 * Decimal("50")**2) )
            assert ( Measure(value=300)  *  "27 ± 1 \u00B0C" ).value   == Decimal("300.15")*Decimal("300") - Decimal("273.15")
            assert ( Measure(value=300)  *  "27 ± 1 \u00B0C" ).error   == error
            assert ( Measure(value=300)  *  "27 ± 1 \u00B0C" ).implied == True
            assert ( Measure(value=300)  *  "27 ± 1 \u00B0C" ).units.symbols   == Unit("\u00B0C").symbols
            assert ( Measure(value=300)  *  "27 ± 1 \u00B0C" ).units.magnitude == Unit("\u00B0C").magnitude
            assert ( Measure(value=300)  *  "27 ± 1 \u00B0C" ) == Measure(units=Unit("\u00B0C"), value= Decimal("300.15")*Decimal("300") - Decimal("273.15"), error=error)
            # Value 2: Float
            assert isinstance( ( Measure(value=299.9)  *  "26.85 ± 0.02 \u00B0C" ), Measure )
            error = measure._sqrt_( (299.9**2 * 0.02**2 + 300**2 * 0.05**2) )
            assert math.isclose( ( Measure(value=299.9)  *  "26.85 ± 0.02 \u00B0C" ).value   , 299.9 * 300 - 273.15 )
            assert math.isclose( ( Measure(value=299.9)  *  "26.85 ± 0.02 \u00B0C" ).error   , error )
            assert ( Measure(value=299.9)  *  "26.85 ± 0.02 \u00B0C" ).implied == True
            assert ( Measure(value=299.9)  *  "26.85 ± 0.02 \u00B0C" ).units.symbols   == Unit("\u00B0C").symbols
            assert ( Measure(value=299.9)  *  "26.85 ± 0.02 \u00B0C" ).units.magnitude == Unit("\u00B0C").magnitude
            assert ( Measure(value=299.9)  *  "26.85 ± 0.02 \u00B0C" ) == Measure(units=Unit("\u00B0C"), value=299.9 * 300 - 273.15, error=error)
            # Value 3: Decimal
            assert isinstance( ( Measure(value=Decimal("300"))  *  "26.85 ± 0.02 \u00B0C" ), Measure )
            error = measure._sqrt_( (Decimal("300")**2 * Decimal("0.02")**2 + Decimal("300")**2 * Decimal("50")**2) )
            assert ( Measure(value=Decimal("300"))  *  "26.85 ± 0.02 \u00B0C" ).value   == Decimal("300") * Decimal("300") - Decimal("273.15") 
            assert ( Measure(value=Decimal("300"))  *  "26.85 ± 0.02 \u00B0C" ).error   == error
            assert ( Measure(value=Decimal("300"))  *  "26.85 ± 0.02 \u00B0C" ).implied == True
            assert ( Measure(value=Decimal("300"))  *  "26.85 ± 0.02 \u00B0C" ).units.symbols   == Unit("\u00B0C").symbols
            assert ( Measure(value=Decimal("300"))  *  "26.85 ± 0.02 \u00B0C" ).units.magnitude == Unit("\u00B0C").magnitude
            assert ( Measure(value=Decimal("300"))  *  "26.85 ± 0.02 \u00B0C" ) == Measure(units=Unit("\u00B0C"), value=Decimal("300") * Decimal("300") - Decimal("273.15"), error=error)
            # Value 4: Negative
            assert isinstance( ( Measure(value=300)  *  "-27 ± 1 \u00B0C" ), Measure )
            error = measure._sqrt_( (Decimal("300")**2 * Decimal("1")**2 + Decimal("246.15")**2 * Decimal("50")**2) )
            assert ( Measure(value=300)  *  "-27 ± 1 \u00B0C" ).value   == Decimal("246.15")*Decimal("300") - Decimal("273.15")
            assert ( Measure(value=300)  *  "-27 ± 1 \u00B0C" ).error   == error
            assert ( Measure(value=300)  *  "-27 ± 1 \u00B0C" ).implied == True
            assert ( Measure(value=300)  *  "-27 ± 1 \u00B0C" ).units.symbols   == Unit("\u00B0C").symbols
            assert ( Measure(value=300)  *  "-27 ± 1 \u00B0C" ).units.magnitude == Unit("\u00B0C").magnitude
            assert ( Measure(value=300)  *  "-27 ± 1 \u00B0C" ) == Measure(units=Unit("\u00B0C"), value= Decimal("246.15")*Decimal("300") - Decimal("273.15"), error=error)
          # Preserve Inputs
          if(True):
            a = Measure(value=3) 
            b = "4 ± 2 cm"
            c = a*b
            c = None
            assert a == Measure(value=3) 
            assert b == "4 ± 2 cm"
        # Unit * Unitless
        if(True):
          # Normal Units
          if(True):
            # Value 1: Int
            assert isinstance( ( Measure(value=4,unit=Unit("cm"))  *  "3 ± 2"  ), Measure )
            error = measure._sqrt_( (Decimal(4)**2 * Decimal("2")**2 + Decimal(3)**2 * Decimal("0.5")**2) )
            assert (  Measure(value=4,unit=Unit("cm"))  *  "3 ± 2"  ).value   == 12
            assert (  Measure(value=4,unit=Unit("cm"))  *  "3 ± 2"  ).error   == error
            assert (  Measure(value=4,unit=Unit("cm"))  *  "3 ± 2"  ).implied == True
            assert (  Measure(value=4,unit=Unit("cm"))  *  "3 ± 2"  ).units.symbols   == Unit("cm").symbols
            assert (  Measure(value=4,unit=Unit("cm"))  *  "3 ± 2"  ).units.magnitude == Unit("cm").magnitude
            assert (  Measure(value=4,unit=Unit("cm"))  *  "3 ± 2"  ) == Measure(units=Unit("cm"), value= 12, error=error)
            # Value 2: Float
            assert isinstance( ( Measure(value=0.4,unit=Unit("cm"))  *  "0.3 ± 0.2"  ), Measure )
            error = measure._sqrt_( (0.4**2 * 0.2**2 + 0.3**2 * 0.05**2) )
            assert math.isclose( (  Measure(value=0.4,unit=Unit("cm"))  *  "0.3 ± 0.2"  ).value , 0.3*0.4 )
            assert math.isclose( (  Measure(value=0.4,unit=Unit("cm"))  *  "0.3 ± 0.2"  ).error , error   )
            assert (  Measure(value=0.4,unit=Unit("cm"))  *  "0.3 ± 0.2"  ).implied == True
            assert (  Measure(value=0.4,unit=Unit("cm"))  *  "0.3 ± 0.2"  ).units.symbols   == Unit("cm").symbols
            assert (  Measure(value=0.4,unit=Unit("cm"))  *  "0.3 ± 0.2"  ).units.magnitude == Unit("cm").magnitude
            assert (  Measure(value=0.4,unit=Unit("cm"))  *  "0.3 ± 0.2"  ) == Measure(units=Unit("cm"), value= 0.3*0.4, error=error)
            # Value 3: Decimal
            assert isinstance( (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  "30 ± 20"  ), Measure )
            error = measure._sqrt_( ( Decimal("40")**2 * Decimal("20")**2 + Decimal("30")**2 * Decimal("5")**2) )
            assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  "30 ± 20"  ).value   == Decimal("1200")
            assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  "30 ± 20"  ).error   == error
            assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  "30 ± 20"  ).implied == True
            assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  "30 ± 20"  ).units.symbols   == Unit("cm").symbols
            assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  "30 ± 20"  ).units.magnitude == Unit("cm").magnitude
            assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  "30 ± 20"  ) == Measure(units=Unit("cm"), value= Decimal("1200"), error=error)
            # Value 4: Negative
            assert isinstance( ( Measure(value=-4,unit=Unit("cm"))  *  "-3 ± 2"  ), Measure )
            error = measure._sqrt_( (Decimal(4)**2 * Decimal("2")**2 + Decimal(3)**2 * Decimal("0.5")**2) )
            assert (  Measure(value=-4,unit=Unit("cm"))  *  "-3 ± 2"  ).value   == 12
            assert (  Measure(value=-4,unit=Unit("cm"))  *  "-3 ± 2"  ).error   == error
            assert (  Measure(value=-4,unit=Unit("cm"))  *  "-3 ± 2"  ).implied == True
            assert (  Measure(value=-4,unit=Unit("cm"))  *  "-3 ± 2"  ).units.symbols   == Unit("cm").symbols
            assert (  Measure(value=-4,unit=Unit("cm"))  *  "-3 ± 2"  ).units.magnitude == Unit("cm").magnitude
            assert (  Measure(value=-4,unit=Unit("cm"))  *  "-3 ± 2"  ) == Measure(units=Unit("cm"), value= 12, error=error)
          # Magnitude Units
          if(True):
            # Value 1: Int
            assert isinstance( (  Measure(value=2,unit=Unit("5 m^2"))  *  "5 ± 1"  ) , Measure )
            error = measure._sqrt_( (Decimal(5)**2 * Decimal("2.5")**2 + Decimal(10)**2 * Decimal(1)**2) )/Decimal(5)
            assert (  Measure(value=2,unit=Unit("5 m^2"))  *  "5 ± 1"  ) == Measure(units=Unit("5 m^2"), value=10, error=error)
            assert (  Measure(value=2,unit=Unit("5 m^2"))  *  "5 ± 1"  ).value   == 10
            assert Measure._dec_isclose_( (  Measure(value=2,unit=Unit("5 m^2"))  *  "5 ± 1"  ).error  , error )
            assert (  Measure(value=2,unit=Unit("5 m^2"))  *  "5 ± 1"  ).implied == True
            assert (  Measure(value=2,unit=Unit("5 m^2"))  *  "5 ± 1"  ).units.symbols   == Unit("5 m^2").symbols
            assert (  Measure(value=2,unit=Unit("5 m^2"))  *  "5 ± 1"  ).units.magnitude == Unit("5 m^2").magnitude
            # Value 2: Float
            assert isinstance( (  Measure(value=0.2,unit=Unit("5 m^2"))  *  "0.5 ± 0.1"  ) , Measure )
            error = measure._sqrt_( (0.5**2 * 0.25**2 + 1.0**2 * 0.1**2) )/5
            assert (  Measure(value=0.2,unit=Unit("5 m^2"))  *  "0.5 ± 0.1"  ) == Measure(units=Unit("5 m^2"), value=0.1, error=error)
            assert math.isclose( (  Measure(value=0.2,unit=Unit("5 m^2"))  *  "0.5 ± 0.1"  ).value , 0.1   )
            assert math.isclose( (  Measure(value=0.2,unit=Unit("5 m^2"))  *  "0.5 ± 0.1"  ).error , error )
            assert (  Measure(value=0.2,unit=Unit("5 m^2"))  *  "0.5 ± 0.1"  ).implied == True
            assert (  Measure(value=0.2,unit=Unit("5 m^2"))  *  "0.5 ± 0.1"  ).units.symbols   == Unit("5 m^2").symbols
            assert (  Measure(value=0.2,unit=Unit("5 m^2"))  *  "0.5 ± 0.1"  ).units.magnitude == Unit("5 m^2").magnitude
            # Value 3: Decimal
            assert isinstance( (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  "50 ± 2"  ) , Measure )
            error = measure._sqrt_( (Decimal("50")**2 * Decimal("25")**2 + Decimal("100")**2 * Decimal("2")**2) )/Decimal("5")
            assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  "50 ± 2"  ) == Measure(units=Unit("5 m^2"), value=Decimal("1000"), error=error)
            assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  "50 ± 2"  ).value   == Decimal("1000")
            assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  "50 ± 2"  ).error   == error
            assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  "50 ± 2"  ).implied == True
            assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  "50 ± 2"  ).units.symbols   == Unit("5 m^2").symbols
            assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  "50 ± 2"  ).units.magnitude == Unit("5 m^2").magnitude
            # Value 4: Negative
            assert isinstance( (  Measure(value=-2,unit=Unit("5 m^2"))  *  "-5 ± 1"  ) , Measure )
            error = measure._sqrt_( (Decimal(5)**2 * Decimal("2.5")**2 + Decimal(10)**2 * Decimal(1)**2) )/Decimal(5)
            assert (  Measure(value=-2,unit=Unit("5 m^2"))  *  "-5 ± 1"  ) == Measure(units=Unit("5 m^2"), value=10, error=error)
            assert (  Measure(value=-2,unit=Unit("5 m^2"))  *  "-5 ± 1"  ).value   == 10
            assert Measure._dec_isclose_( (  Measure(value=-2,unit=Unit("5 m^2"))  *  "-5 ± 1"  ).error   , error )
            assert (  Measure(value=-2,unit=Unit("5 m^2"))  *  "-5 ± 1"  ).implied == True
            assert (  Measure(value=-2,unit=Unit("5 m^2"))  *  "-5 ± 1"  ).units.symbols   == Unit("5 m^2").symbols
            assert (  Measure(value=-2,unit=Unit("5 m^2"))  *  "-5 ± 1"  ).units.magnitude == Unit("5 m^2").magnitude
          # Convoluted Units
          if(True):
            # Value 1: Int
            assert isinstance( ( Measure(value=27,unit=Unit("\u00B0C"))  *  "300 ± 2" ), Measure )
            error = measure._sqrt_( (Decimal("300")**2 * Decimal("0.5")**2 + Decimal("300.15")**2 * Decimal("2")**2) )
            assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  "300 ± 2" ).value   == Decimal("300.15")*Decimal("300") - Decimal("273.15")
            assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  "300 ± 2" ).error   == error
            assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  "300 ± 2" ).implied == True
            assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  "300 ± 2" ).units.symbols   == Unit("\u00B0C").symbols
            assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  "300 ± 2" ).units.magnitude == Unit("\u00B0C").magnitude
            assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  "300 ± 2" ) == Measure(units=Unit("\u00B0C"), value= Decimal("300.15")*Decimal("300") - Decimal("273.15"), error=error)
            # Value 2: Float
            assert isinstance( ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  "299.9 ± 0.02" ), Measure )
            error = measure._sqrt_( (299.9**2 * 0.005**2 + 300**2 * 0.02**2) )
            assert math.isclose( ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  "299.9 ± 0.02" ).value , 299.9 * 300 - 273.15 )
            assert math.isclose( ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  "299.9 ± 0.02" ).error , error )
            assert ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  "299.9 ± 0.02" ).implied == True
            assert ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  "299.9 ± 0.02" ).units.symbols   == Unit("\u00B0C").symbols
            assert ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  "299.9 ± 0.02" ).units.magnitude == Unit("\u00B0C").magnitude
            assert ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  "299.9 ± 0.02" ) == Measure(units=Unit("\u00B0C"), value=299.9 * 300 - 273.15, error=error)
            # Value 3: Decimal
            assert isinstance( ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  "300 ± 0.02" ), Measure )
            error = measure._sqrt_( (Decimal("300")**2 * Decimal("0.005")**2 + Decimal("300")**2 * Decimal("0.02")**2) )
            assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  "300 ± 0.02" ).value   == Decimal("300") * Decimal("300") - Decimal("273.15") 
            assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  "300 ± 0.02" ).error   == error
            assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  "300 ± 0.02" ).implied == True
            assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  "300 ± 0.02" ).units.symbols   == Unit("\u00B0C").symbols
            assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  "300 ± 0.02" ).units.magnitude == Unit("\u00B0C").magnitude
            assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  "300 ± 0.02" ) == Measure(units=Unit("\u00B0C"), value=Decimal("300") * Decimal("300") - Decimal("273.15"), error=error)
            # Value 4: Negative
            assert isinstance( ( Measure(value=-27,unit=Unit("\u00B0C"))  *  "300 ± 2" ), Measure )
            error = measure._sqrt_( (Decimal("300")**2 * Decimal("0.5")**2 + Decimal("246.15")**2 * Decimal("2")**2) )
            assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  "300 ± 2" ).value   == Decimal("246.15")*Decimal("300") - Decimal("273.15")
            assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  "300 ± 2" ).error   == error
            assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  "300 ± 2" ).implied == True
            assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  "300 ± 2" ).units.symbols   == Unit("\u00B0C").symbols
            assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  "300 ± 2" ).units.magnitude == Unit("\u00B0C").magnitude
            assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  "300 ± 2" ) == Measure(units=Unit("\u00B0C"), value= Decimal("246.15")*Decimal("300") - Decimal("273.15"), error=error)
          # Preserve Inputs
          if(True):
            a = Measure(value=4,unit=Unit("cm"))
            b = "3 ± 2"
            c = a*b
            c = None
            assert a == Measure(value=4,unit=Unit("cm")) 
            assert b == "3 ± 2"
        # Units * Units
        if(True):
          # Normal Units
          if(True):
            # Value 1: Int
            assert isinstance( ( Measure(value=4,unit=Unit("cm"))  *  "3 ± 2 cm"  ), Measure )
            error = measure._sqrt_( (Decimal(4)**2 * Decimal("2")**2 + Decimal(3)**2 * Decimal("0.5")**2) )
            assert (  Measure(value=4,unit=Unit("cm"))  *  "3 ± 2 cm"  ).value   == 12
            assert (  Measure(value=4,unit=Unit("cm"))  *  "3 ± 2 cm"  ).error   == error
            assert (  Measure(value=4,unit=Unit("cm"))  *  "3 ± 2 cm"  ).implied == True
            assert (  Measure(value=4,unit=Unit("cm"))  *  "3 ± 2 cm"  ).units.symbols   == Unit("cm^2").symbols
            assert (  Measure(value=4,unit=Unit("cm"))  *  "3 ± 2 cm"  ).units.magnitude == Unit("cm^2").magnitude
            assert (  Measure(value=4,unit=Unit("cm"))  *  "3 ± 2 cm"  ) == Measure(units=Unit("cm^2"), value= 12, error=error)
            # Value 2: Float
            assert isinstance( ( Measure(value=0.4,unit=Unit("cm"))  *  "0.3 ± 0.2 cm"  ), Measure )
            error = measure._sqrt_( (0.4**2 * 0.2**2 + 0.3**2 * 0.05**2) )
            assert math.isclose( (  Measure(value=0.4,unit=Unit("cm"))  *  "0.3 ± 0.2 cm"  ).value , 0.3*0.4 )
            assert math.isclose( (  Measure(value=0.4,unit=Unit("cm"))  *  "0.3 ± 0.2 cm"  ).error , error   )
            assert (  Measure(value=0.4,unit=Unit("cm"))  *  "0.3 ± 0.2 cm"  ).implied == True
            assert (  Measure(value=0.4,unit=Unit("cm"))  *  "0.3 ± 0.2 cm"  ).units.symbols   == Unit("cm^2").symbols
            assert (  Measure(value=0.4,unit=Unit("cm"))  *  "0.3 ± 0.2 cm"  ).units.magnitude == Unit("cm^2").magnitude
            assert (  Measure(value=0.4,unit=Unit("cm"))  *  "0.3 ± 0.2 cm"  ) == Measure(units=Unit("cm^2"), value= 0.3*0.4, error=error)
            # Value 3: Decimal
            assert isinstance( (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  "30 ± 20 cm"  ), Measure )
            error = measure._sqrt_( ( Decimal("40")**2 * Decimal("20")**2 + Decimal("30")**2 * Decimal("5")**2) )
            assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  "30 ± 20 cm"  ).value   == Decimal("1200")
            assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  "30 ± 20 cm"  ).error   == error
            assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  "30 ± 20 cm"  ).implied == True
            assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  "30 ± 20 cm"  ).units.symbols   == Unit("cm^2").symbols
            assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  "30 ± 20 cm"  ).units.magnitude == Unit("cm^2").magnitude
            assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  "30 ± 20 cm"  ) == Measure(units=Unit("cm^2"), value= Decimal("1200"), error=error)
            # Value 4: Negative
            assert isinstance( ( Measure(value=-4,unit=Unit("cm"))  *  "-3 ± 2 cm"  ), Measure )
            error = measure._sqrt_( (Decimal(4)**2 * Decimal("2")**2 + Decimal(3)**2 * Decimal("0.5")**2) )
            assert (  Measure(value=-4,unit=Unit("cm"))  *  "-3 ± 2 cm"  ).value   == 12
            assert (  Measure(value=-4,unit=Unit("cm"))  *  "-3 ± 2 cm"  ).error   == error
            assert (  Measure(value=-4,unit=Unit("cm"))  *  "-3 ± 2 cm"  ).implied == True
            assert (  Measure(value=-4,unit=Unit("cm"))  *  "-3 ± 2 cm"  ).units.symbols   == Unit("cm^2").symbols
            assert (  Measure(value=-4,unit=Unit("cm"))  *  "-3 ± 2 cm"  ).units.magnitude == Unit("cm^2").magnitude
            assert (  Measure(value=-4,unit=Unit("cm"))  *  "-3 ± 2 cm"  ) == Measure(units=Unit("cm^2"), value= 12, error=error)
          # Magnitude Units
          if(True):
            # Value 1: Int
            assert isinstance( (  Measure(value=2,unit=Unit("5 m^2"))  *  "5 ± 1 * 5 m^2"  ) , Measure )
            error = measure._sqrt_( (Decimal(25)**2 * Decimal("2.5")**2 + Decimal(10)**2 * Decimal(5)**2) )/Decimal(25)
            assert (  Measure(value=2,unit=Unit("5 m^2"))  *  "5 ± 1 * 5 m^2"  ).value   == 10
            assert (  Measure(value=2,unit=Unit("5 m^2"))  *  "5 ± 1 * 5 m^2"  ).error   == error
            assert (  Measure(value=2,unit=Unit("5 m^2"))  *  "5 ± 1 * 5 m^2"  ).implied == True
            assert (  Measure(value=2,unit=Unit("5 m^2"))  *  "5 ± 1 * 5 m^2"  ).units.symbols   == Unit("25 m^4").symbols
            assert (  Measure(value=2,unit=Unit("5 m^2"))  *  "5 ± 1 * 5 m^2"  ).units.magnitude == Unit("25 m^4").magnitude
            assert (  Measure(value=2,unit=Unit("5 m^2"))  *  "5 ± 1 * 5 m^2"  ) == Measure(units=Unit("25 m^4"), value=10, error=error)
            # Value 2: Float
            assert isinstance( (  Measure(value=0.2,unit=Unit("5 m^2"))  *  "0.5 ± 0.1 * 5 m^2"  ) , Measure )
            error = measure._sqrt_( (2.5**2 * 0.25**2 + 1.0**2 * 0.5**2) )/25
            assert math.isclose( (  Measure(value=0.2,unit=Unit("5 m^2"))  *  "0.5 ± 0.1 * 5 m^2"  ).value , 0.1   )
            assert math.isclose( (  Measure(value=0.2,unit=Unit("5 m^2"))  *  "0.5 ± 0.1 * 5 m^2"  ).error , error )
            assert (  Measure(value=0.2,unit=Unit("5 m^2"))  *  "0.5 ± 0.1 * 5 m^2"  ).implied == True
            assert (  Measure(value=0.2,unit=Unit("5 m^2"))  *  "0.5 ± 0.1 * 5 m^2"  ).units.symbols   == Unit("25 m^4").symbols
            assert (  Measure(value=0.2,unit=Unit("5 m^2"))  *  "0.5 ± 0.1 * 5 m^2"  ).units.magnitude == Unit("25 m^4").magnitude
            assert (  Measure(value=0.2,unit=Unit("5 m^2"))  *  "0.5 ± 0.1 * 5 m^2"  ) == Measure(units=Unit("25 m^4"), value=0.1, error=error)
            # Value 3: Decimal
            assert isinstance( (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  "50 ± 2 * 5 m^2"  ) , Measure )
            error = measure._sqrt_( (Decimal("250")**2 * Decimal("25")**2 + Decimal("100")**2 * Decimal("10")**2) )/Decimal("25")
            assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  "50 ± 2 * 5 m^2"  ) == Measure(units=Unit("25 m^4"), value=Decimal("1000"), error=error)
            assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  "50 ± 2 * 5 m^2"  ).value   == Decimal("1000")
            assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  "50 ± 2 * 5 m^2"  ).error   == error
            assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  "50 ± 2 * 5 m^2"  ).implied == True
            assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  "50 ± 2 * 5 m^2"  ).units.symbols   == Unit("25 m^4").symbols
            assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  "50 ± 2 * 5 m^2"  ).units.magnitude == Unit("25 m^4").magnitude
            # Value 4: Negative
            assert isinstance( (  Measure(value=-2,unit=Unit("5 m^2"))  *  "-5 ± 1 * 5 m^2"  ) , Measure )
            error = measure._sqrt_( (Decimal(25)**2 * Decimal("2.5")**2 + Decimal(10)**2 * Decimal(5)**2) )/Decimal(25)
            assert (  Measure(value=-2,unit=Unit("5 m^2"))  *  "-5 ± 1 * 5 m^2"  ) == Measure(units=Unit("25 m^4"), value=10, error=error)
            assert (  Measure(value=-2,unit=Unit("5 m^2"))  *  "-5 ± 1 * 5 m^2"  ).value   == 10
            assert (  Measure(value=-2,unit=Unit("5 m^2"))  *  "-5 ± 1 * 5 m^2"  ).error   == error
            assert (  Measure(value=-2,unit=Unit("5 m^2"))  *  "-5 ± 1 * 5 m^2"  ).implied == True
            assert (  Measure(value=-2,unit=Unit("5 m^2"))  *  "-5 ± 1 * 5 m^2"  ).units.symbols   == Unit("25 m^4").symbols
            assert (  Measure(value=-2,unit=Unit("5 m^2"))  *  "-5 ± 1 * 5 m^2"  ).units.magnitude == Unit("25 m^4").magnitude
          # Convoluted Units
          if(True):
            # Value 1: Int
            assert isinstance( ( Measure(value=27,unit=Unit("\u00B0C"))  *  "27 ± 2 \u00B0C" ), Measure )
            error = measure._sqrt_( (Decimal("300.15")**2 * Decimal("0.5")**2 + Decimal("300.15")**2 * Decimal("2")**2) )
            assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  "27 ± 2 \u00B0C" ).value   == Decimal("300.15")*Decimal("300.15")
            assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  "27 ± 2 \u00B0C" ).error   == error
            assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  "27 ± 2 \u00B0C" ).implied == True
            assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  "27 ± 2 \u00B0C" ).units.symbols   == Unit("K^2").symbols
            assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  "27 ± 2 \u00B0C" ).units.magnitude == Unit("K^2").magnitude
            assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  "27 ± 2 \u00B0C" ) == Measure(units=Unit("K^2"), value= Decimal("300.15")*Decimal("300.15"), error=error)
            # Value 2: Float
            assert isinstance( ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  "26.85 ± 0.02 \u00B0C" ), Measure )
            error = measure._sqrt_( (300**2 * 0.005**2 + 300**2 * 0.02**2) )
            assert math.isclose( ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  "26.85 ± 0.02 \u00B0C" ).value   , 300 * 300 )
            assert math.isclose( ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  "26.85 ± 0.02 \u00B0C" ).error   , error )
            assert ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  "26.85 ± 0.02 \u00B0C" ).implied == True 
            assert ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  "26.85 ± 0.02 \u00B0C" ).units.symbols   == Unit("K^2").symbols
            assert ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  "26.85 ± 0.02 \u00B0C" ).units.magnitude == Unit("K^2").magnitude
            assert ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  "26.85 ± 0.02 \u00B0C" ) == Measure(units=Unit("K^2"), value=300 * 300, error=error)
            # Value 3: Decimal
            assert isinstance( ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  "26.85 ± 0.02 \u00B0C" ), Measure )
            error = measure._sqrt_( (Decimal("300")**2 * Decimal("0.005")**2 + Decimal("300")**2 * Decimal("0.02")**2) )
            assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  "26.85 ± 0.02 \u00B0C" ).value   == Decimal("300") * Decimal("300") 
            assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  "26.85 ± 0.02 \u00B0C" ).error   == error
            assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  "26.85 ± 0.02 \u00B0C" ).implied == True
            assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  "26.85 ± 0.02 \u00B0C" ).units.symbols   == Unit("K^2").symbols
            assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  "26.85 ± 0.02 \u00B0C" ).units.magnitude == Unit("K^2").magnitude
            assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  "26.85 ± 0.02 \u00B0C" ) == Measure(units=Unit("K^2"), value=Decimal("300") * Decimal("300"), error=error)
            # Value 4: Negative
            assert isinstance( ( Measure(value=-27,unit=Unit("\u00B0C"))  *  "-27 ± 2 \u00B0C" ), Measure )
            error = measure._sqrt_( (Decimal("246.15")**2 * Decimal("0.5")**2 + Decimal("246.15")**2 * Decimal("2")**2) )
            assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  "-27 ± 2 \u00B0C" ).value   == Decimal("246.15")*Decimal("246.15")
            assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  "-27 ± 2 \u00B0C" ).error   == error
            assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  "-27 ± 2 \u00B0C" ).implied == True
            assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  "-27 ± 2 \u00B0C" ).units.symbols   == Unit("K^2").symbols
            assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  "-27 ± 2 \u00B0C" ).units.magnitude == Unit("K^2").magnitude
            assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  "-27 ± 2 \u00B0C" ) == Measure(units=Unit("K^2"), value= Decimal("246.15")*Decimal("246.15"), error=error)
          # Canceling Units
          if(True):
            # Value 1: Int
            assert isinstance( ( Measure(value=4,unit=Unit("cm"))  *  "3 ± 2 cm^-1"  ), Measure )
            error = measure._sqrt_( (Decimal(4)**2 * Decimal("2")**2 + Decimal(3)**2 * Decimal("0.5")**2) )
            assert (  Measure(value=4,unit=Unit("cm"))  *  "3 ± 2 cm^-1"  ).value   == 12
            assert (  Measure(value=4,unit=Unit("cm"))  *  "3 ± 2 cm^-1"  ).error   == error
            assert (  Measure(value=4,unit=Unit("cm"))  *  "3 ± 2 cm^-1"  ).implied == True
            assert (  Measure(value=4,unit=Unit("cm"))  *  "3 ± 2 cm^-1"  ).units.symbols   == Unit().symbols
            assert (  Measure(value=4,unit=Unit("cm"))  *  "3 ± 2 cm^-1"  ).units.magnitude == Unit().magnitude
            assert (  Measure(value=4,unit=Unit("cm"))  *  "3 ± 2 cm^-1"  ) == Measure(units=Unit(), value= 12, error=error)
            # Value 2: Float
            assert isinstance( ( Measure(value=0.4,unit=Unit("cm"))  *  "0.3 ± 0.2 cm^-1"  ), Measure )
            error = measure._sqrt_( (0.4**2 * 0.2**2 + 0.3**2 * 0.05**2) )
            assert math.isclose( (  Measure(value=0.4,unit=Unit("cm"))  *  "0.3 ± 0.2 cm^-1"  ).value , 0.3*0.4 )
            assert math.isclose( (  Measure(value=0.4,unit=Unit("cm"))  *  "0.3 ± 0.2 cm^-1"  ).error , error   )
            assert (  Measure(value=0.4,unit=Unit("cm"))  *  "0.3 ± 0.2 cm^-1"  ).implied == True
            assert (  Measure(value=0.4,unit=Unit("cm"))  *  "0.3 ± 0.2 cm^-1"  ).units.symbols   == Unit().symbols
            assert (  Measure(value=0.4,unit=Unit("cm"))  *  "0.3 ± 0.2 cm^-1"  ).units.magnitude == Unit().magnitude
            assert (  Measure(value=0.4,unit=Unit("cm"))  *  "0.3 ± 0.2 cm^-1"  ) == Measure(units=Unit(), value= 0.3*0.4, error=error)
            # Value 3: Decimal
            assert isinstance( (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  "30 ± 20 cm^-1"  ), Measure )
            error = measure._sqrt_( ( Decimal("40")**2 * Decimal("20")**2 + Decimal("30")**2 * Decimal("5")**2) )
            assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  "30 ± 20 cm^-1"  ).value   == Decimal("1200")
            assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  "30 ± 20 cm^-1"  ).error   == error
            assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  "30 ± 20 cm^-1"  ).implied == True
            assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  "30 ± 20 cm^-1"  ).units.symbols   == Unit().symbols
            assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  "30 ± 20 cm^-1"  ).units.magnitude == Unit().magnitude
            assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  "30 ± 20 cm^-1"  ) == Measure(units=Unit(), value= Decimal("1200"), error=error)
            # Value 4: Negative
            assert isinstance( ( Measure(value=-4,unit=Unit("cm"))  *  "-3 ± 2 cm^-1"  ), Measure )
            error = measure._sqrt_( (Decimal(4)**2 * Decimal("2")**2 + Decimal(3)**2 * Decimal("0.5")**2) )
            assert (  Measure(value=-4,unit=Unit("cm"))  *  "-3 ± 2 cm^-1"  ).value   == 12
            assert (  Measure(value=-4,unit=Unit("cm"))  *  "-3 ± 2 cm^-1"  ).error   == error
            assert (  Measure(value=-4,unit=Unit("cm"))  *  "-3 ± 2 cm^-1"  ).implied == True
            assert (  Measure(value=-4,unit=Unit("cm"))  *  "-3 ± 2 cm^-1"  ).units.symbols   == Unit().symbols
            assert (  Measure(value=-4,unit=Unit("cm"))  *  "-3 ± 2 cm^-1"  ).units.magnitude == Unit().magnitude
            assert (  Measure(value=-4,unit=Unit("cm"))  *  "-3 ± 2 cm^-1"  ) == Measure(units=Unit(), value= 12, error=error)
          # Preserve Inputs
          if(True):
            a = Measure(value=4,unit=Unit("cm"))
            b = "3 ± 2 cm"
            c = a*b
            c = None
            assert a == Measure(value=4,unit=Unit("cm"))
            assert b == "3 ± 2 cm"
      # Measure (Implicit Error) * Str Measure (Implicit Error) = Measure (Implicit Error)
      if(True):
        # Unitless * Unitless
        if(True):
          # PASS:   Str Implicit Error Unitless Measures are indistinguishable from Numbers.
          pass
        # Unitless * Unit
        if(True):
          # Normal Units
          if(True):
            # Value 1: Int
            assert isinstance( (  Measure(value=3)  *  "4 cm"  ), Measure )
            error = measure._sqrt_( (Decimal("4")**2 * Decimal("0.5")**2 + Decimal("3")**2 * Decimal("0.5")**2) )
            assert (  Measure(value=3)  *  "4 cm"  ).value   == 12
            assert (  Measure(value=3)  *  "4 cm"  ).error   == error
            assert (  Measure(value=3)  *  "4 cm"  ).implied == True
            assert (  Measure(value=3)  *  "4 cm"  ).units.symbols   == Unit("cm").symbols
            assert (  Measure(value=3)  *  "4 cm"  ).units.magnitude == Unit("cm").magnitude
            assert (  Measure(value=3)  *  "4 cm"  ) == Measure(units=Unit("cm"), value= 12, error=error)
            # Value 2: Float
            assert isinstance( (  Measure(value=0.3)  *  "0.4 cm" ), Measure )
            error = measure._sqrt_( (0.4**2 * 0.05**2 + 0.3**2 * 0.05**2) )
            assert math.isclose( (  Measure(value=0.3)  *  "0.4 cm"  ).value , 0.3*0.4 )
            assert math.isclose( (  Measure(value=0.3)  *  "0.4 cm"  ).error , error   )
            assert (  Measure(value=0.3)  *  "0.4 cm"  ).implied == True
            assert (  Measure(value=0.3)  *  "0.4 cm"  ).units.symbols   == Unit("cm").symbols
            assert (  Measure(value=0.3)  *  "0.4 cm"  ).units.magnitude == Unit("cm").magnitude
            assert (  Measure(value=0.3)  *  "0.4 cm"  ) == Measure(units=Unit("cm"), value= 0.3*0.4, error=error)
            # Value 3: Decimal
            assert isinstance( (  Measure(value=Decimal("40"))  *  "30 cm"  ), Measure )
            error = measure._sqrt_( (Decimal("40")**2 * Decimal("5")**2 + Decimal("30")**2 * Decimal("5")**2) )
            assert (  Measure(value=Decimal("40"))  *  "30 cm"  ).value   == Decimal("1200")
            assert (  Measure(value=Decimal("40"))  *  "30 cm"  ).error   == error
            assert (  Measure(value=Decimal("40"))  *  "30 cm"  ).implied == True
            assert (  Measure(value=Decimal("40"))  *  "30 cm"  ).units.symbols   == Unit("cm").symbols
            assert (  Measure(value=Decimal("40"))  *  "30 cm"  ).units.magnitude == Unit("cm").magnitude
            assert (  Measure(value=Decimal("40"))  *  "30 cm"  ) == Measure(units=Unit("cm"), value= Decimal("1200"), error=error)
            # Value 4: Negative
            assert isinstance( (  Measure(value=-3)  *  "-4 cm"  ), Measure )
            error = measure._sqrt_( (Decimal("4")**2 * Decimal("0.5")**2 + Decimal("3")**2 * Decimal("0.5")**2) )
            assert (  Measure(value=-3)  *  "-4 cm"  ).value   == 12
            assert (  Measure(value=-3)  *  "-4 cm"  ).error   == error
            assert (  Measure(value=-3)  *  "-4 cm"  ).implied == True
            assert (  Measure(value=-3)  *  "-4 cm"  ).units.symbols   == Unit("cm").symbols
            assert (  Measure(value=-3)  *  "-4 cm"  ).units.magnitude == Unit("cm").magnitude
            assert (  Measure(value=-3)  *  "-4 cm"  ) == Measure(units=Unit("cm"), value= 12, error=error)
          # Magnitude Units
          if(True):
            # Value 1: Int
            assert isinstance( (  Measure(value=5)  *  "2 * 5 m^2"  ) , Measure )
            error = measure._sqrt_( (Decimal(5)**2 * Decimal("2.5")**2 + Decimal(10)**2 * Decimal("0.5")**2) )/Decimal(5)
            assert (  Measure(value=5)  *  "2 * 5 m^2"  ) == Measure(units=Unit("5 m^2"), value=10, error=error)
            assert (  Measure(value=5)  *  "2 * 5 m^2"  ).value   == 10
            assert (  Measure(value=5)  *  "2 * 5 m^2"  ).error   == error
            assert (  Measure(value=5)  *  "2 * 5 m^2"  ).implied == True
            assert (  Measure(value=5)  *  "2 * 5 m^2"  ).units.symbols   == Unit("5 m^2").symbols
            assert (  Measure(value=5)  *  "2 * 5 m^2"  ).units.magnitude == Unit("5 m^2").magnitude
            # Value 2: Float
            assert isinstance( (  Measure(value=0.5)  *  "0.2 * 5 m^2"  ) , Measure )
            error = measure._sqrt_( (0.5**2 * 0.25**2 + 1.0**2 * 0.05**2) )/5
            assert (  Measure(value=0.5)  *  "0.2 * 5 m^2"  ) == Measure(units=Unit("5 m^2"), value=0.1, error=error)
            assert math.isclose( (  Measure(value=0.5)  *  "0.2 * 5 m^2"  ).value , 0.1   )
            assert math.isclose( (  Measure(value=0.5)  *  "0.2 * 5 m^2"  ).error , error )
            assert (  Measure(value=0.5)  *  "0.2 * 5 m^2"  ).implied == True
            assert (  Measure(value=0.5)  *  "0.2 * 5 m^2"  ).units.symbols   == Unit("5 m^2").symbols
            assert (  Measure(value=0.5)  *  "0.2 * 5 m^2"  ).units.magnitude == Unit("5 m^2").magnitude
            # Value 3: Decimal
            assert isinstance( (  Measure(value=Decimal("50"))  *  "20 * 5 m^2"  ) , Measure )
            error = measure._sqrt_( (Decimal("50")**2 * Decimal("25")**2 + Decimal("100")**2 * Decimal("5")**2) )/Decimal("5")
            assert (  Measure(value=Decimal("50"))  *  "20 * 5 m^2"  ) == Measure(units=Unit("5 m^2"), value=Decimal("1000"), error=error)
            assert (  Measure(value=Decimal("50"))  *  "20 * 5 m^2"  ).value   == Decimal("1000")
            assert (  Measure(value=Decimal("50"))  *  "20 * 5 m^2"  ).error   == error
            assert (  Measure(value=Decimal("50"))  *  "20 * 5 m^2"  ).implied == True
            assert (  Measure(value=Decimal("50"))  *  "20 * 5 m^2"  ).units.symbols   == Unit("5 m^2").symbols
            assert (  Measure(value=Decimal("50"))  *  "20 * 5 m^2"  ).units.magnitude == Unit("5 m^2").magnitude
            # Value 4: Negative
            assert isinstance( (  Measure(value=-5)  *  "-2 * 5 m^2"  ) , Measure )
            error = measure._sqrt_( (Decimal(5)**2 * Decimal("2.5")**2 + Decimal(10)**2 * Decimal("0.5")**2) )/Decimal(5)
            assert (  Measure(value=-5)  *  "-2 * 5 m^2"  ) == Measure(units=Unit("5 m^2"), value=10, error=error)
            assert (  Measure(value=-5)  *  "-2 * 5 m^2"  ).value   == 10
            assert (  Measure(value=-5)  *  "-2 * 5 m^2"  ).error   == error
            assert (  Measure(value=-5)  *  "-2 * 5 m^2"  ).implied == True
            assert (  Measure(value=-5)  *  "-2 * 5 m^2"  ).units.symbols   == Unit("5 m^2").symbols
            assert (  Measure(value=-5)  *  "-2 * 5 m^2"  ).units.magnitude == Unit("5 m^2").magnitude
          # Convoluted Units
          if(True):
            # Value 1: Int
            assert isinstance( ( Measure(value=300)  *  "27 \u00B0C" ), Measure )
            error = measure._sqrt_( (Decimal("300")**2 * Decimal("0.5")**2 + Decimal("300.15")**2 * Decimal("50")**2) )
            assert ( Measure(value=300)  *  "27 \u00B0C" ).value   == Decimal("300.15")*Decimal("300") - Decimal("273.15")
            assert ( Measure(value=300)  *  "27 \u00B0C" ).error   == error
            assert ( Measure(value=300)  *  "27 \u00B0C" ).implied == True
            assert ( Measure(value=300)  *  "27 \u00B0C" ).units.symbols   == Unit("\u00B0C").symbols
            assert ( Measure(value=300)  *  "27 \u00B0C" ).units.magnitude == Unit("\u00B0C").magnitude
            assert ( Measure(value=300)  *  "27 \u00B0C" ) == Measure(units=Unit("\u00B0C"), value= Decimal("300.15")*Decimal("300") - Decimal("273.15"), error=error)
            # Value 2: Float
            assert isinstance( ( Measure(value=299.9)  *  "26.85 \u00B0C" ), Measure )
            error = measure._sqrt_( (299.9**2 * 0.005**2 + 300**2 * 0.05**2) )
            assert math.isclose( ( Measure(value=299.9)  *  "26.85 \u00B0C" ).value   , 299.9 * 300 - 273.15 )
            assert math.isclose( ( Measure(value=299.9)  *  "26.85 \u00B0C" ).error   , error )
            assert ( Measure(value=299.9)  *  "26.85 \u00B0C" ).implied == True 
            assert ( Measure(value=299.9)  *  "26.85 \u00B0C" ).units.symbols   == Unit("\u00B0C").symbols
            assert ( Measure(value=299.9)  *  "26.85 \u00B0C" ).units.magnitude == Unit("\u00B0C").magnitude
            assert ( Measure(value=299.9)  *  "26.85 \u00B0C" ) == Measure(units=Unit("\u00B0C"), value=299.9 * 300 - 273.15, error=error)
            # Value 3: Decimal
            assert isinstance( ( Measure(value=Decimal("300"))  *  "26.85 \u00B0C" ), Measure )
            error = measure._sqrt_( (Decimal("300")**2 * Decimal("0.005")**2 + Decimal("300")**2 * Decimal("50")**2) )
            assert ( Measure(value=Decimal("300"))  *  "26.85 \u00B0C" ).value   == Decimal("300") * Decimal("300") - Decimal("273.15") 
            assert ( Measure(value=Decimal("300"))  *  "26.85 \u00B0C" ).error   == error
            assert ( Measure(value=Decimal("300"))  *  "26.85 \u00B0C" ).implied == True
            assert ( Measure(value=Decimal("300"))  *  "26.85 \u00B0C" ).units.symbols   == Unit("\u00B0C").symbols
            assert ( Measure(value=Decimal("300"))  *  "26.85 \u00B0C" ).units.magnitude == Unit("\u00B0C").magnitude
            assert ( Measure(value=Decimal("300"))  *  "26.85 \u00B0C" ) == Measure(units=Unit("\u00B0C"), value=Decimal("300") * Decimal("300") - Decimal("273.15"), error=error)
            # Value 4: Negative
            assert isinstance( ( Measure(value=300)  *  "-27 \u00B0C" ), Measure )
            error = measure._sqrt_( (Decimal("300")**2 * Decimal("0.5")**2 + Decimal("246.15")**2 * Decimal("50")**2) )
            assert ( Measure(value=300)  *  "-27 \u00B0C" ).value   == Decimal("246.15")*Decimal("300") - Decimal("273.15")
            assert ( Measure(value=300)  *  "-27 \u00B0C" ).error   == error
            assert ( Measure(value=300)  *  "-27 \u00B0C" ).implied == True
            assert ( Measure(value=300)  *  "-27 \u00B0C" ).units.symbols   == Unit("\u00B0C").symbols
            assert ( Measure(value=300)  *  "-27 \u00B0C" ).units.magnitude == Unit("\u00B0C").magnitude
            assert ( Measure(value=300)  *  "-27 \u00B0C" ) == Measure(units=Unit("\u00B0C"), value= Decimal("246.15")*Decimal("300") - Decimal("273.15"), error=error)
          # Preserve Inputs
          if(True):
            a = Measure(value=3) 
            b = "4 cm"
            c = a*b
            c = None
            assert a == Measure(value=3) 
            assert b == "4 cm"
        # Unit * Unitless
        if(True):
          # PASS:   Str Implicit Error Unitless Measures are indistinguishable from Numbers.
          pass
        # Units * Units
        if(True):
          # Normal Units
          if(True):
            # Value 1: Int
            assert isinstance( ( Measure(value=4,unit=Unit("cm"))  *  "3 cm"  ), Measure )
            error = measure._sqrt_( (Decimal("4")**2 * Decimal("0.5")**2 + Decimal("3")**2 * Decimal("0.5")**2) )
            assert (  Measure(value=4,unit=Unit("cm"))  *  "3 cm"  ).value   == 12
            assert (  Measure(value=4,unit=Unit("cm"))  *  "3 cm"  ).error   == error
            assert (  Measure(value=4,unit=Unit("cm"))  *  "3 cm"  ).implied == True
            assert (  Measure(value=4,unit=Unit("cm"))  *  "3 cm"  ).units.symbols   == Unit("cm^2").symbols
            assert (  Measure(value=4,unit=Unit("cm"))  *  "3 cm"  ).units.magnitude == Unit("cm^2").magnitude
            assert (  Measure(value=4,unit=Unit("cm"))  *  "3 cm"  ) == Measure(units=Unit("cm^2"), value= 12, error=error)
            # Value 2: Float
            assert isinstance( ( Measure(value=0.4,unit=Unit("cm"))  *  "0.3 cm"  ), Measure )
            error = measure._sqrt_( (0.4**2 * 0.05**2 + 0.3**2 * 0.05**2) )
            assert math.isclose( (  Measure(value=0.4,unit=Unit("cm"))  *  "0.3 cm"  ).value , 0.3*0.4 )
            assert math.isclose( (  Measure(value=0.4,unit=Unit("cm"))  *  "0.3 cm"  ).error , error   )
            assert (  Measure(value=0.4,unit=Unit("cm"))  *  "0.3 cm"  ).implied == True
            assert (  Measure(value=0.4,unit=Unit("cm"))  *  "0.3 cm"  ).units.symbols   == Unit("cm^2").symbols
            assert (  Measure(value=0.4,unit=Unit("cm"))  *  "0.3 cm"  ).units.magnitude == Unit("cm^2").magnitude
            assert (  Measure(value=0.4,unit=Unit("cm"))  *  "0.3 cm"  ) == Measure(units=Unit("cm^2"), value= 0.3*0.4, error=error)
            # Value 3: Decimal
            assert isinstance( (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  "30 cm"  ), Measure )
            error = measure._sqrt_( (Decimal("40")**2 * Decimal("5")**2 + Decimal("30")**2 * Decimal("5")**2) )
            assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  "30 cm"  ).value   == Decimal("1200")
            assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  "30 cm"  ).error   == error
            assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  "30 cm"  ).implied == True
            assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  "30 cm"  ).units.symbols   == Unit("cm^2").symbols
            assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  "30 cm"  ).units.magnitude == Unit("cm^2").magnitude
            assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  "30 cm"  ) == Measure(units=Unit("cm^2"), value= Decimal("1200"), error=error)
            # Value 4: Negative
            assert isinstance( ( Measure(value=-4,unit=Unit("cm"))  *  "-3 cm"  ), Measure )
            error = measure._sqrt_( (Decimal("4")**2 * Decimal("0.5")**2 + Decimal("3")**2 * Decimal("0.5")**2) )
            assert (  Measure(value=-4,unit=Unit("cm"))  *  "-3 cm"  ).value   == 12
            assert (  Measure(value=-4,unit=Unit("cm"))  *  "-3 cm"  ).error   == error
            assert (  Measure(value=-4,unit=Unit("cm"))  *  "-3 cm"  ).implied == True
            assert (  Measure(value=-4,unit=Unit("cm"))  *  "-3 cm"  ).units.symbols   == Unit("cm^2").symbols
            assert (  Measure(value=-4,unit=Unit("cm"))  *  "-3 cm"  ).units.magnitude == Unit("cm^2").magnitude
            assert (  Measure(value=-4,unit=Unit("cm"))  *  "-3 cm"  ) == Measure(units=Unit("cm^2"), value= 12, error=error)
          # Magnitude Units
          if(True):
            # Value 1: Int
            assert isinstance( (  Measure(value=2,unit=Unit("5 m^2"))  *  "5 * 5 m^2"  ) , Measure )
            error = measure._sqrt_( (Decimal(25)**2 * Decimal("2.5")**2 + Decimal(10)**2 * Decimal("2.5")**2) )/Decimal(25)
            assert (  Measure(value=2,unit=Unit("5 m^2"))  *  "5 * 5 m^2"  ).value   == 10
            assert Measure._dec_isclose_(  (  Measure(value=2,unit=Unit("5 m^2"))  *  "5 * 5 m^2"  ).error , error )
            assert (  Measure(value=2,unit=Unit("5 m^2"))  *  "5 * 5 m^2"  ).implied == True
            assert (  Measure(value=2,unit=Unit("5 m^2"))  *  "5 * 5 m^2"  ).units.symbols   == Unit("25 m^4").symbols
            assert (  Measure(value=2,unit=Unit("5 m^2"))  *  "5 * 5 m^2"  ).units.magnitude == Unit("25 m^4").magnitude
            assert (  Measure(value=2,unit=Unit("5 m^2"))  *  "5 * 5 m^2"  ) == Measure(units=Unit("25 m^4"), value=10, error=error)
            # Value 2: Float
            assert isinstance( (  Measure(value=0.2,unit=Unit("5 m^2"))  *  "0.5 * 5 m^2"  ) , Measure )
            error = measure._sqrt_( (2.5**2 * 0.25**2 + 1.0**2 * 0.25**2) )/25
            assert math.isclose( (  Measure(value=0.2,unit=Unit("5 m^2"))  *  "0.5 * 5 m^2"  ).value , 0.1   )
            assert math.isclose( (  Measure(value=0.2,unit=Unit("5 m^2"))  *  "0.5 * 5 m^2"  ).error , error )
            assert (  Measure(value=0.2,unit=Unit("5 m^2"))  *  "0.5 * 5 m^2"  ).implied == True
            assert (  Measure(value=0.2,unit=Unit("5 m^2"))  *  "0.5 * 5 m^2"  ).units.symbols   == Unit("25 m^4").symbols
            assert (  Measure(value=0.2,unit=Unit("5 m^2"))  *  "0.5 * 5 m^2"  ).units.magnitude == Unit("25 m^4").magnitude
            assert (  Measure(value=0.2,unit=Unit("5 m^2"))  *  "0.5 * 5 m^2"  ) == Measure(units=Unit("25 m^4"), value=0.1, error=error)
            # Value 3: Decimal
            assert isinstance( (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  "50 * 5 m^2"  ) , Measure )
            error = measure._sqrt_( (Decimal("250")**2 * Decimal("25")**2 + Decimal("100")**2 * Decimal("25")**2) )/Decimal("25")
            assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  "50 * 5 m^2"  ) == Measure(units=Unit("25 m^4"), value=Decimal("1000"), error=error)
            assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  "50 * 5 m^2"  ).value   == Decimal("1000")
            assert Measure._dec_isclose_(  (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  "50 * 5 m^2"  ).error , error )
            assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  "50 * 5 m^2"  ).implied == True
            assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  "50 * 5 m^2"  ).units.symbols   == Unit("25 m^4").symbols
            assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  "50 * 5 m^2"  ).units.magnitude == Unit("25 m^4").magnitude
            # Value 4: Negative
            assert isinstance( (  Measure(value=-2,unit=Unit("5 m^2"))  *  "-5 * 5 m^2"  ) , Measure )
            error = measure._sqrt_( (Decimal(25)**2 * Decimal("2.5")**2 + Decimal(10)**2 * Decimal("2.5")**2) )/Decimal(25)
            assert (  Measure(value=-2,unit=Unit("5 m^2"))  *  "-5 * 5 m^2"  ) == Measure(units=Unit("25 m^4"), value=10, error=error)
            assert (  Measure(value=-2,unit=Unit("5 m^2"))  *  "-5 * 5 m^2"  ).value   == 10
            assert Measure._dec_isclose_( (  Measure(value=-2,unit=Unit("5 m^2"))  *  "-5 * 5 m^2"  ).error , error )
            assert (  Measure(value=-2,unit=Unit("5 m^2"))  *  "-5 * 5 m^2"  ).implied == True
            assert (  Measure(value=-2,unit=Unit("5 m^2"))  *  "-5 * 5 m^2"  ).units.symbols   == Unit("25 m^4").symbols
            assert (  Measure(value=-2,unit=Unit("5 m^2"))  *  "-5 * 5 m^2"  ).units.magnitude == Unit("25 m^4").magnitude
          # Convoluted Units
          if(True):
            # Value 1: Int
            assert isinstance( ( Measure(value=27,unit=Unit("\u00B0C"))  *  "27 \u00B0C" ), Measure )
            error = measure._sqrt_( (Decimal("300.15")**2 * Decimal("0.5")**2 + Decimal("300.15")**2 * Decimal("0.5")**2) )
            assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  "27 \u00B0C" ).value   == Decimal("300.15")*Decimal("300.15")
            assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  "27 \u00B0C" ).error   == error
            assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  "27 \u00B0C" ).implied == True
            assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  "27 \u00B0C" ).units.symbols   == Unit("K^2").symbols
            assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  "27 \u00B0C" ).units.magnitude == Unit("K^2").magnitude
            assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  "27 \u00B0C" ) == Measure(units=Unit("K^2"), value= Decimal("300.15")*Decimal("300.15"), error=error)
            # Value 2: Float
            assert isinstance( ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  "26.85 \u00B0C" ), Measure )
            error = measure._sqrt_( (300**2 * 0.005**2 + 300**2 * 0.005**2) )
            assert math.isclose( ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  "26.85 \u00B0C" ).value   , 300 * 300 )
            assert math.isclose( ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  "26.85 \u00B0C" ).error   , error )
            assert ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  "26.85 \u00B0C" ).implied == True 
            assert ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  "26.85 \u00B0C" ).units.symbols   == Unit("K^2").symbols
            assert ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  "26.85 \u00B0C" ).units.magnitude == Unit("K^2").magnitude
            assert ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  "26.85 \u00B0C" ) == Measure(units=Unit("K^2"), value=300 * 300, error=error)
            # Value 3: Decimal
            assert isinstance( ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  "26.85 * \u00B0C" ), Measure )
            error = measure._sqrt_( (Decimal("300")**2 * Decimal("0.005")**2 + Decimal("300")**2 * Decimal("0.005")**2) )
            assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  "26.85 \u00B0C" ).value   == Decimal("300") * Decimal("300") 
            assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  "26.85 \u00B0C" ).error   == error
            assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  "26.85 \u00B0C" ).implied == True
            assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  "26.85 \u00B0C" ).units.symbols   == Unit("K^2").symbols
            assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  "26.85 \u00B0C" ).units.magnitude == Unit("K^2").magnitude
            assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  "26.85 \u00B0C" ) == Measure(units=Unit("K^2"), value=Decimal("300") * Decimal("300"), error=error)
            # Value 4: Negative
            assert isinstance( ( Measure(value=-27,unit=Unit("\u00B0C"))  *  "-27 \u00B0C" ), Measure )
            error = measure._sqrt_( (Decimal("246.15")**2 * Decimal("0.5")**2 + Decimal("246.15")**2 * Decimal("0.5")**2) )
            assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  "-27 \u00B0C" ).value   == Decimal("246.15")*Decimal("246.15")
            assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  "-27 \u00B0C" ).error   == error
            assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  "-27 \u00B0C" ).implied == True
            assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  "-27 \u00B0C" ).units.symbols   == Unit("K^2").symbols
            assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  "-27 \u00B0C" ).units.magnitude == Unit("K^2").magnitude
            assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  "-27 \u00B0C" ) == Measure(units=Unit("K^2"), value= Decimal("246.15")*Decimal("246.15"), error=error)
          # Canceling Units
          if(True):
            # Value 1: Int
            assert isinstance( ( Measure(value=4,unit=Unit("cm"))  *  "3 cm^-1"  ), Measure )
            error = measure._sqrt_( (Decimal("4")**2 * Decimal("0.5")**2 + Decimal("3")**2 * Decimal("0.5")**2) )
            assert (  Measure(value=4,unit=Unit("cm"))  *  "3 cm^-1"  ).value   == 12
            assert (  Measure(value=4,unit=Unit("cm"))  *  "3 cm^-1"  ).error   == error
            assert (  Measure(value=4,unit=Unit("cm"))  *  "3 cm^-1"  ).implied == True
            assert (  Measure(value=4,unit=Unit("cm"))  *  "3 cm^-1"  ).units.symbols   == Unit().symbols
            assert (  Measure(value=4,unit=Unit("cm"))  *  "3 cm^-1"  ).units.magnitude == Unit().magnitude
            assert (  Measure(value=4,unit=Unit("cm"))  *  "3 cm^-1"  ) == Measure(units=Unit(), value= 12, error=error)
            # Value 2: Float
            assert isinstance( ( Measure(value=0.4,unit=Unit("cm"))  *  "0.3 cm^-1"  ), Measure )
            error = measure._sqrt_( (0.4**2 * 0.05**2 + 0.3**2 * 0.05**2) )
            assert math.isclose( (  Measure(value=0.4,unit=Unit("cm"))  *  "0.3 cm^-1"  ).value , 0.3*0.4 )
            assert math.isclose( (  Measure(value=0.4,unit=Unit("cm"))  *  "0.3 cm^-1"  ).error , error   )
            assert (  Measure(value=0.4,unit=Unit("cm"))  *  "0.3 cm^-1"  ).implied == True
            assert (  Measure(value=0.4,unit=Unit("cm"))  *  "0.3 cm^-1"  ).units.symbols   == Unit().symbols
            assert (  Measure(value=0.4,unit=Unit("cm"))  *  "0.3 cm^-1"  ).units.magnitude == Unit().magnitude
            assert (  Measure(value=0.4,unit=Unit("cm"))  *  "0.3 cm^-1"  ) == Measure(units=Unit(), value= 0.3*0.4, error=error)
            # Value 3: Decimal
            assert isinstance( (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  "30 cm^-1"  ), Measure )
            error = measure._sqrt_( (Decimal("40")**2 * Decimal("5")**2 + Decimal("30")**2 * Decimal("5")**2) )
            assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  "30 cm^-1"  ).value   == Decimal("1200")
            assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  "30 cm^-1"  ).error   == error
            assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  "30 cm^-1"  ).implied == True
            assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  "30 cm^-1"  ).units.symbols   == Unit().symbols
            assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  "30 cm^-1"  ).units.magnitude == Unit().magnitude
            assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  "30 cm^-1"  ) == Measure(units=Unit(), value= Decimal("1200"), error=error)
            # Value 4: Negative
            assert isinstance( ( Measure(value=-4,unit=Unit("cm"))  *  "-3 cm^-1"  ), Measure )
            error = measure._sqrt_( (Decimal("4")**2 * Decimal("0.5")**2 + Decimal("3")**2 * Decimal("0.5")**2) )
            assert (  Measure(value=-4,unit=Unit("cm"))  *  "-3 cm^-1"  ).value   == 12
            assert (  Measure(value=-4,unit=Unit("cm"))  *  "-3 cm^-1"  ).error   == error
            assert (  Measure(value=-4,unit=Unit("cm"))  *  "-3 cm^-1"  ).implied == True
            assert (  Measure(value=-4,unit=Unit("cm"))  *  "-3 cm^-1"  ).units.symbols   == Unit().symbols
            assert (  Measure(value=-4,unit=Unit("cm"))  *  "-3 cm^-1"  ).units.magnitude == Unit().magnitude
            assert (  Measure(value=-4,unit=Unit("cm"))  *  "-3 cm^-1"  ) == Measure(units=Unit(), value= 12, error=error)
          # Preserve Inputs
          if(True):
            a = Measure(value=4,unit=Unit("cm"))
            b = "3 cm"
            c = a*b
            c = None
            assert a == Measure(value=4,unit=Unit("cm"))
            assert b == "3 cm"
  
  def test_measure_str_unit_mul(self):
    # These are dependent on Measure str parser 
    
    # Measure (Explicit Error) * Str Unit 
    if(True):
      # Measure Unitless * Unit
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          assert isinstance( (  Measure(value=3,error=2)  *  "cm"  ), Measure )
          error = measure._sqrt_( (Decimal(3)**2 * Decimal("0")**2 + Decimal(1)**2 * Decimal(2)**2) )
          assert (  Measure(value=3,error=2)  *  "cm"  ).value   == 3
          assert (  Measure(value=3,error=2)  *  "cm"  ).error   == error
          assert (  Measure(value=3,error=2)  *  "cm"  ).implied == False
          assert (  Measure(value=3,error=2)  *  "cm"  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=3,error=2)  *  "cm"  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=3,error=2)  *  "cm"  ) == Measure(units=Unit("cm"), value= 3, error=error)
          # Value 2: Float
          assert isinstance( (  Measure(value=0.3,error=0.2)  *  "cm" ), Measure )
          error = measure._sqrt_( (1**2 * 0.2**2 + 0.3**2 * 0**2) )
          assert math.isclose( (  Measure(value=0.3,error=0.2)  *  "cm"  ).value , 0.3 )
          assert math.isclose( (  Measure(value=0.3,error=0.2)  *  "cm"  ).error , error   )
          assert (  Measure(value=0.3,error=0.2)  *  "cm"  ).implied == False
          assert (  Measure(value=0.3,error=0.2)  *  "cm"  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=0.3,error=0.2)  *  "cm"  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=0.3,error=0.2)  *  "cm"  ) == Measure(units=Unit("cm"), value= 0.3, error=error)
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("40"),error=Decimal("20"))  *  "cm"  ), Measure )
          error = measure._sqrt_( ( Decimal("40")**2 * Decimal("0")**2 + Decimal("1")**2 * Decimal("20")**2) )
          assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  "cm"  ).value   == Decimal("40")
          assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  "cm"  ).error   == error
          assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  "cm"  ).implied == False
          assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  "cm"  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  "cm"  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=Decimal("40"),error=Decimal("20"))  *  "cm"  ) == Measure(units=Unit("cm"), value= Decimal("40"), error=error)
          # Value 4: Negative
          assert isinstance( (  Measure(value=-3,error=2)  *  "cm"  ), Measure )
          error = measure._sqrt_( (Decimal(3)**2 * Decimal("0")**2 + Decimal(1)**2 * Decimal(2)**2) )
          assert (  Measure(value=-3,error=2)  *  "cm"  ).value   == -3
          assert (  Measure(value=-3,error=2)  *  "cm"  ).error   == error
          assert (  Measure(value=-3,error=2)  *  "cm"  ).implied == False
          assert (  Measure(value=-3,error=2)  *  "cm"  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=-3,error=2)  *  "cm"  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=-3,error=2)  *  "cm"  ) == Measure(units=Unit("cm"), value=-3, error=error)
        # Magnitude Units
        if(False):
          # FALSE:  Not sure this work around notation should be maintained.
          # PASS:   Str Magnitude Units are indistinguishable from Measures.
          pass
          # Value 1: Int
          assert isinstance( (  Measure(value=5,error=1)  *  " * 5 m^2"  ) , Measure )
          error = measure._sqrt_( (Decimal("5")**2 * Decimal("0")**2 + Decimal("5")**2 * Decimal("1")**2) )/Decimal("5")
          assert (  Measure(value=5,error=1)  *  " * 5 m^2"  ) == Measure(units=Unit("5 m^2"), value=5, error=error)
          assert (  Measure(value=5,error=1)  *  " * 5 m^2"  ).value   == 5
          #assert (  Measure(value=5,error=1)  *  "5 m^2"  ).error   == error
          # The above won't work, do to changes on uncertain even for decimal operations (due to calculating and back-calculating in unit operations).
          assert Measure._dec_isclose_( (Measure(value=5,error=1)  *  " * 5 m^2" ).error , error )
          assert (  Measure(value=5,error=1)  *  " * 5 m^2"  ).implied == False
          assert (  Measure(value=5,error=1)  *  " * 5 m^2"  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=5,error=1)  *  " * 5 m^2"  ).units.magnitude == Unit("5 m^2").magnitude
          # Value 2: Float
          assert isinstance( (  Measure(value=0.5,error=0.1)  *  " * 5 m^2"  ) , Measure )
          error = measure._sqrt_( (0.5**2 * 0**2 + 5**2 * 0.1**2) )/5
          assert (  Measure(value=0.5,error=0.1)  *  " * 5 m^2"  ) == Measure(units=Unit("5 m^2"), value=0.5, error=error)
          assert math.isclose( (  Measure(value=0.5,error=0.1)  *  " * 5 m^2"  ).value , 0.5   )
          assert math.isclose( (  Measure(value=0.5,error=0.1)  *  " * 5 m^2"  ).error , error )
          assert (  Measure(value=0.5,error=0.1)  *  " * 5 m^2"  ).implied == False
          assert (  Measure(value=0.5,error=0.1)  *  " * 5 m^2"  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=0.5,error=0.1)  *  " * 5 m^2"  ).units.magnitude == Unit("5 m^2").magnitude
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("50"),error=Decimal("2"))  *  " * 5 m^2"  ) , Measure )
          error = measure._sqrt_( (Decimal("50")**2 * Decimal("0")**2 + Decimal("5")**2 * Decimal("2")**2) )/Decimal("5")
          assert (  Measure(value=Decimal("50"),error=Decimal("2"))  *  " * 5 m^2"  ) == Measure(units=Unit("5 m^2"), value=Decimal("50"), error=error)
          assert (  Measure(value=Decimal("50"),error=Decimal("2"))  *  " * 5 m^2"  ).value   == Decimal("50")
          assert (  Measure(value=Decimal("50"),error=Decimal("2"))  *  " * 5 m^2"  ).error   == error
          assert (  Measure(value=Decimal("50"),error=Decimal("2"))  *  " * 5 m^2"  ).implied == False
          assert (  Measure(value=Decimal("50"),error=Decimal("2"))  *  " * 5 m^2"  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=Decimal("50"),error=Decimal("2"))  *  " * 5 m^2"  ).units.magnitude == Unit("5 m^2").magnitude
          # Value 4: Negative
          assert isinstance( (  Measure(value=-5,error=1)  *  " * 5 m^2"  ) , Measure )
          error = measure._sqrt_( (Decimal("5")**2 * Decimal("0")**2 + Decimal("5")**2 * Decimal("1")**2) )/Decimal("5")
          assert (  Measure(value=-5,error=1)  *  " * 5 m^2"  ).value   == -5
          #assert (  Measure(value=-5,error=1)  *  "-5 m^2"  ).error   == error
          # The above won't work, do to changes on uncertain even for decimal operations (due to calculating and back-calculating in unit operations).
          assert Measure._dec_isclose_( (Measure(value=-5,error=1)  *  Unit("5 m^2")).error , error )
          assert (  Measure(value=-5,error=1)  *  " * 5 m^2"  ).implied == False
          assert (  Measure(value=-5,error=1)  *  " * 5 m^2"  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=-5,error=1)  *  " * 5 m^2"  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  Measure(value=-5,error=1)  *  " * 5 m^2"  ) == Measure(units=Unit("5 m^2"), value=-5, error=error)
        # Convoluted Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Measure(value=300,error=2)  *  "\u00B0C" ), Measure )
          error = measure._sqrt_( (Decimal("300")**2 * Decimal("0")**2 + Decimal("274.15")**2 * Decimal("2")**2) )
          assert ( Measure(value=300,error=2)  *  "\u00B0C" ).value   == Decimal("274.15")*Decimal("300") - Decimal("273.15")
          assert ( Measure(value=300,error=2)  *  "\u00B0C" ).error   == error
          assert ( Measure(value=300,error=2)  *  "\u00B0C" ).implied == False
          assert ( Measure(value=300,error=2)  *  "\u00B0C" ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=300,error=2)  *  "\u00B0C" ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=300,error=2)  *  "\u00B0C" ) == Measure(units=Unit("\u00B0C"), value= Decimal("274.15")*Decimal("300") - Decimal("273.15"), error=error)
          # Value 2: Float
          assert isinstance( ( Measure(value=299.9,error=0.02)  *  "\u00B0C" ), Measure )
          error = measure._sqrt_( (299.9**2 * 0**2 + 274.15**2 * 0.02**2) )
          assert math.isclose( ( Measure(value=299.9,error=0.02)  *  "\u00B0C" ).value  , 299.9 * 274.15 - 273.15 )
          assert math.isclose( ( Measure(value=299.9,error=0.02)  *  "\u00B0C" ).error  , error )
          assert ( Measure(value=299.9,error=0.02)  *  "\u00B0C" ).implied == False 
          assert ( Measure(value=299.9,error=0.02)  *  "\u00B0C" ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=299.9,error=0.02)  *  "\u00B0C" ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=299.9,error=0.02)  *  "\u00B0C" ) == Measure(units=Unit("\u00B0C"), value=299.9 * 274.15 - 273.15, error=error)
          # Value 3: Decimal
          assert isinstance( ( Measure(value=Decimal("300"),error=Decimal("0.02"))  *  "\u00B0C" ), Measure )
          error = measure._sqrt_( (Decimal("300")**2 * Decimal("0")**2 + Decimal("274.15")**2 * Decimal("0.02")**2) )
          assert ( Measure(value=Decimal("300"),error=Decimal("0.02"))  *  "\u00B0C" ).value   == Decimal("274.15") * Decimal("300") - Decimal("273.15") 
          assert ( Measure(value=Decimal("300"),error=Decimal("0.02"))  *  "\u00B0C" ).error   == error
          assert ( Measure(value=Decimal("300"),error=Decimal("0.02"))  *  "\u00B0C" ).implied == False
          assert ( Measure(value=Decimal("300"),error=Decimal("0.02"))  *  "\u00B0C" ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=Decimal("300"),error=Decimal("0.02"))  *  "\u00B0C" ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=Decimal("300"),error=Decimal("0.02"))  *  "\u00B0C" ) == Measure(units=Unit("\u00B0C"), value=Decimal("274.15") * Decimal("300") - Decimal("273.15"), error=error)
          # Value 4: Negative
          assert isinstance( ( Measure(value=-300,error=2)  *  "\u00B0C" ), Measure )
          error = measure._sqrt_( (Decimal("300")**2 * Decimal("0")**2 + Decimal("274.15")**2 * Decimal("2")**2) )
          assert ( Measure(value=-300,error=2)  *  "\u00B0C" ).value   == Decimal("274.15")*Decimal("-300") - Decimal("273.15")
          assert ( Measure(value=-300,error=2)  *  "\u00B0C" ).error   == error
          assert ( Measure(value=-300,error=2)  *  "\u00B0C" ).implied == False
          assert ( Measure(value=-300,error=2)  *  "\u00B0C" ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=-300,error=2)  *  "\u00B0C" ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=-300,error=2)  *  "\u00B0C" ) == Measure(units=Unit("\u00B0C"), value= Decimal("274.15")*Decimal("-300") - Decimal("273.15"), error=error)
        # Preserve Inputs
        if(True):
          a = Measure(value=3,error=2) 
          b = "cm"
          c = a*b
          c = None
          assert a == Measure(value=3,error=2) 
          assert b == "cm"
      # Measure Units * Unit
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Measure(value=4,error=2,unit=Unit("cm"))  *  "cm"  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0")**2 + Decimal(1)**2 * Decimal(2)**2) )
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  "cm"  ).value   == 4
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  "cm"  ).error   == error
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  "cm"  ).implied == False
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  "cm"  ).units.symbols   == Unit("cm^2").symbols
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  "cm"  ).units.magnitude == Unit("cm^2").magnitude
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  "cm"  ) == Measure(units=Unit("cm^2"), value= 4, error=error)
          # Value 2: Float
          assert isinstance( ( Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  "cm"  ), Measure )
          error = measure._sqrt_( (0.4**2 * 0**2 + 1**2 * 0.2**2) )
          assert math.isclose( (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  "cm"  ).value , 0.4 )
          assert math.isclose( (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  "cm"  ).error , error   )
          assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  "cm"  ).implied == False
          assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  "cm"  ).units.symbols   == Unit("cm^2").symbols
          assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  "cm"  ).units.magnitude == Unit("cm^2").magnitude
          assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  "cm"  ) == Measure(units=Unit("cm^2"), value= 0.4, error=error)
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  "cm"  ), Measure )
          error = measure._sqrt_( (Decimal("40")**2 * Decimal("0")**2 + Decimal("1")**2 * Decimal("20")**2) )
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  "cm"  ).value   == Decimal("40")
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  "cm"  ).error   == error
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  "cm"  ).implied == False
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  "cm"  ).units.symbols   == Unit("cm^2").symbols
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  "cm"  ).units.magnitude == Unit("cm^2").magnitude
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  "cm"  ) == Measure(units=Unit("cm^2"), value= Decimal("40"), error=error)
          # Value 4: Negative
          assert isinstance( ( Measure(value=-4,error=2,unit=Unit("cm"))  *  "cm"  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0")**2 + Decimal(1)**2 * Decimal(2)**2) )
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  "cm"  ).value   == -4
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  "cm"  ).error   == error
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  "cm"  ).implied == False
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  "cm"  ).units.symbols   == Unit("cm^2").symbols
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  "cm"  ).units.magnitude == Unit("cm^2").magnitude
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  "cm"  ) == Measure(units=Unit("cm^2"), value=-4, error=error)
        # Magnitude Units
        if(False):
          # FALSE:  Not sure this work around notation should be maintained.
          # PASS:   Str Magnitude Units are indistinguishable from Measures.
          pass
          # Value 1: Int
          assert isinstance( (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  " * 5 m^2"  ) , Measure )
          error  = measure._sqrt_( ( Decimal(5)**2 * Decimal(5)**2 + Decimal(10)**2 * Decimal("0")**2) )/Decimal(25)
          assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  " * 5 m^2"  ).value   == 2
          assert Measure._dec_isclose_( (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  " * 5 m^2"  ).error   , error )
          assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  " * 5 m^2"  ).implied == False
          assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  " * 5 m^2"  ).units.symbols   == Unit("25 m^4").symbols
          assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  " * 5 m^2"  ).units.magnitude == Unit("25 m^4").magnitude
          assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  *  " * 5 m^2"  ) == Measure(units=Unit("25 m^4"), value=2, error=error)
          # Value 2: Float
          assert isinstance( (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  " * 5 m^2"  ) , Measure )
          error = measure._sqrt_( (5**2 * 0.5**2 + 1.0**2 * 0**2) )/25
          assert math.isclose( (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  " * 5 m^2"  ).value , 0.2   )
          assert math.isclose( (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  " * 5 m^2"  ).error , error )
          assert (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  " * 5 m^2"  ).implied == False
          assert (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  " * 5 m^2"  ).units.symbols   == Unit("25 m^4").symbols
          assert (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  " * 5 m^2"  ).units.magnitude == Unit("25 m^4").magnitude
          assert (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  *  " * 5 m^2"  ) == Measure(units=Unit("25 m^4"), value=0.2, error=error)
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  " * 5 m^2"  ) , Measure )
          error = measure._sqrt_( (Decimal("5")**2 * Decimal("25")**2 + Decimal("100")**2 * Decimal("0")**2) )/Decimal("25")
          assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  " * 5 m^2"  ) == Measure(units=Unit("25 m^4"), value=Decimal("20"), error=error)
          assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  " * 5 m^2"  ).value   == Decimal("20")
          assert Measure._dec_isclose_( (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  " * 5 m^2"  ).error   , error )
          assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  " * 5 m^2"  ).implied == False
          assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  " * 5 m^2"  ).units.symbols   == Unit("25 m^4").symbols
          assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  *  " * 5 m^2"  ).units.magnitude == Unit("25 m^4").magnitude
          # Value 4: Negative
          assert isinstance( (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  " * 5 m^2"  ) , Measure )
          error = measure._sqrt_( (Decimal(5)**2 * Decimal(5)**2 + Decimal(10)**2 * Decimal("0")**2) )/Decimal(25)
          assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  " * 5 m^2"  ) == Measure(units=Unit("25 m^4"), value=-2, error=error)
          assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  " * 5 m^2"  ).value   == -2
          assert Measure._dec_isclose_( (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  " * 5 m^2"  ).error   , error )
          assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  " * 5 m^2"  ).implied == False
          assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  " * 5 m^2"  ).units.symbols   == Unit("25 m^4").symbols
          assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  *  " * 5 m^2"  ).units.magnitude == Unit("25 m^4").magnitude
        # Convoluted Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  "\u00B0C" ), Measure )
          error = measure._sqrt_( (Decimal("274.15")**2 * Decimal("1")**2 + Decimal("300.15")**2 * Decimal("0")**2) )
          assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  "\u00B0C" ).value   == Decimal("274.15")*Decimal("300.15")
          assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  "\u00B0C" ).error   == error
          assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  "\u00B0C" ).implied == False
          assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  "\u00B0C" ).units.symbols   == Unit("K^2").symbols
          assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  "\u00B0C" ).units.magnitude == Unit("K^2").magnitude
          assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  *  "\u00B0C" ) == Measure(units=Unit("K^2"), value= Decimal("274.15")*Decimal("300.15"), error=error)
          # Value 2: Float
          assert isinstance( ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  "\u00B0C" ), Measure )
          error = measure._sqrt_( (274.15**2 * 0.02**2 + 300**2 * 0**2) )
          assert math.isclose( ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  "\u00B0C" ).value   , 274.15 * 300 )
          assert math.isclose( ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  "\u00B0C" ).error   , error )
          assert ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  "\u00B0C" ).implied == False
          assert ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  "\u00B0C" ).units.symbols   == Unit("K^2").symbols
          assert ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  "\u00B0C" ).units.magnitude == Unit("K^2").magnitude
          assert ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  *  "\u00B0C" ) == Measure(units=Unit("K^2"), value= 274.15 * 300, error=error)
          # Value 3: Decimal
          assert isinstance( ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  "\u00B0C" ), Measure )
          error = measure._sqrt_( (Decimal("274.15")**2 * Decimal("0.02")**2 + Decimal("300")**2 * Decimal("0")**2) )
          assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  "\u00B0C" ).value   == Decimal("274.15") * Decimal("300") 
          assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  "\u00B0C" ).error   == error
          assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  "\u00B0C" ).implied == False
          assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  "\u00B0C" ).units.symbols   == Unit("K^2").symbols
          assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  "\u00B0C" ).units.magnitude == Unit("K^2").magnitude
          assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  *  "\u00B0C" ) == Measure(units=Unit("K^2"), value=Decimal("274.15") * Decimal("300"), error=error)
          # Value 4: Negative
          assert isinstance( ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  "\u00B0C" ), Measure )
          error = measure._sqrt_( (Decimal("274.15")**2 * Decimal("1")**2 + Decimal("246.15")**2 * Decimal("0")**2) )
          assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  "\u00B0C" ).value   == Decimal("274.15")*Decimal("246.15")
          assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  "\u00B0C" ).error   == error
          assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  "\u00B0C" ).implied == False
          assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  "\u00B0C" ).units.symbols   == Unit("K^2").symbols
          assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  "\u00B0C" ).units.magnitude == Unit("K^2").magnitude
          assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  *  "\u00B0C" ) == Measure(units=Unit("K^2"), value= Decimal("274.15")*Decimal("246.15"), error=error)
        # Canceling Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Measure(value=4,error=2,unit=Unit("cm"))  *  "cm^-1"  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0")**2 + Decimal(1)**2 * Decimal(2)**2) )
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  "cm^-1"  ).value   == 4
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  "cm^-1"  ).error   == error
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  "cm^-1"  ).implied == False
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  "cm^-1"  ).units.symbols   == Unit().symbols
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  "cm^-1"  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  *  "cm^-1"  ) == Measure(units=Unit(), value= 4, error=error)
          # Value 2: Float
          assert isinstance( ( Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  "cm^-1"  ), Measure )
          error = measure._sqrt_( (0.4**2 * 0**2 + 1**2 * 0.2**2) )
          assert math.isclose( (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  "cm^-1"  ).value , 0.4 )
          assert math.isclose( (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  "cm^-1"  ).error , error   )
          assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  "cm^-1"  ).implied == False
          assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  "cm^-1"  ).units.symbols   == Unit().symbols
          assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  "cm^-1"  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  *  "cm^-1"  ) == Measure(units=Unit(), value= 0.4, error=error)
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  "cm^-1"  ), Measure )
          error = measure._sqrt_( (Decimal("40")**2 * Decimal("0")**2 + Decimal("1")**2 * Decimal("20")**2) )
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  "cm^-1"  ).value   == Decimal("40")
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  "cm^-1"  ).error   == error
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  "cm^-1"  ).implied == False
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  "cm^-1"  ).units.symbols   == Unit().symbols
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  "cm^-1"  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  *  "cm^-1"  ) == Measure(units=Unit(), value= Decimal("40"), error=error)
          # Value 4: Negative
          assert isinstance( ( Measure(value=-4,error=2,unit=Unit("cm"))  *  "cm^-1"  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0")**2 + Decimal(1)**2 * Decimal(2)**2) )
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  "cm^-1"  ).value   == -4
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  "cm^-1"  ).error   == error
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  "cm^-1"  ).implied == False
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  "cm^-1"  ).units.symbols   == Unit().symbols
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  "cm^-1"  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  *  "cm^-1"  ) == Measure(units=Unit(), value= -4, error=error)
        # Preserve Inputs
        if(True):
          a = Measure(value=4,error=2,unit=Unit("cm"))
          b = "cm"
          c = a*b
          c = None
          assert a == Measure(value=4,error=2,unit=Unit("cm"))
          assert b == "cm"
    # Measure (Implicit Error) * Str Unit
    if(True):
      # Measure Unitless * Unit
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          assert isinstance( (  Measure(value=3)  *  "cm"  ), Measure )
          error = measure._sqrt_( (Decimal(3)**2 * Decimal("0")**2 + Decimal(1)**2 * Decimal("0.5")**2) )
          assert (  Measure(value=3)  *  "cm"  ).value   == 3
          assert (  Measure(value=3)  *  "cm"  ).error   == error
          assert (  Measure(value=3)  *  "cm"  ).implied == True
          assert (  Measure(value=3)  *  "cm"  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=3)  *  "cm"  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=3)  *  "cm"  ) == Measure(units=Unit("cm"), value= 3, error=error)
          # Value 2: Float
          assert isinstance( (  Measure(value=0.3)  *  "cm" ), Measure )
          error = measure._sqrt_( (1**2 * 0.05**2 + 0.3**2 * 0**2) )
          assert math.isclose( (  Measure(value=0.3)  *  "cm"  ).value , 0.3 )
          assert math.isclose( (  Measure(value=0.3)  *  "cm"  ).error , error   )
          assert (  Measure(value=0.3)  *  "cm"  ).implied == True
          assert (  Measure(value=0.3)  *  "cm"  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=0.3)  *  "cm"  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=0.3)  *  "cm"  ) == Measure(units=Unit("cm"), value= 0.3, error=error)
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("40"))  *  "cm"  ), Measure )
          error = measure._sqrt_( ( Decimal("40")**2 * Decimal("0")**2 + Decimal("1")**2 * Decimal("5")**2) )
          assert (  Measure(value=Decimal("40"))  *  "cm"  ).value   == Decimal("40")
          assert (  Measure(value=Decimal("40"))  *  "cm"  ).error   == error
          assert (  Measure(value=Decimal("40"))  *  "cm"  ).implied == True
          assert (  Measure(value=Decimal("40"))  *  "cm"  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=Decimal("40"))  *  "cm"  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=Decimal("40"))  *  "cm"  ) == Measure(units=Unit("cm"), value= Decimal("40"), error=error)
          # Value 4: Negative
          assert isinstance( (  Measure(value=-3)  *  "cm"  ), Measure )
          error = measure._sqrt_( (Decimal(3)**2 * Decimal("0")**2 + Decimal(1)**2 * Decimal("0.5")**2) )
          assert (  Measure(value=-3)  *  "cm"  ).value   == -3
          assert (  Measure(value=-3)  *  "cm"  ).error   == error
          assert (  Measure(value=-3)  *  "cm"  ).implied == True
          assert (  Measure(value=-3)  *  "cm"  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=-3)  *  "cm"  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=-3)  *  "cm"  ) == Measure(units=Unit("cm"), value=-3, error=error)
        # Magnitude Units
        if(False):
          # FALSE:  Not sure this work around notation should be maintained.
          # PASS:   Str Magnitude Units are indistinguishable from Measures.
          pass
          # Value 1: Int
          assert isinstance( (  Measure(value=5)  *  " * 5 m^2"  ) , Measure )
          error = measure._sqrt_( (Decimal("5")**2 * Decimal("0")**2 + Decimal("5")**2 * Decimal("0.5")**2) )/Decimal("5")
          assert (  Measure(value=5)  *  " * 5 m^2"  ) == Measure(units=Unit("5 m^2"), value=5, error=error)
          assert (  Measure(value=5)  *  " * 5 m^2"  ).value   == 5
          #assert (  Measure(value=5)  *  " * 5 m^2"  ).error   == error
          # The above won't work, do to changes on uncertain even for decimal operations (due to calculating and back-calculating in unit operations).
          assert Measure._dec_isclose_( (Measure(value=5)  *  Unit("5 m^2")).error , error )
          assert (  Measure(value=5)  *  " * 5 m^2"  ).implied == True
          assert (  Measure(value=5)  *  " * 5 m^2"  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=5)  *  " * 5 m^2"  ).units.magnitude == Unit("5 m^2").magnitude
          # Value 2: Float
          assert isinstance( (  Measure(value=0.5)  *  " * 5 m^2"  ) , Measure )
          error = measure._sqrt_( (0.5**2 * 0**2 + 5**2 * 0.05**2) )/5
          assert (  Measure(value=0.5)  *  " * 5 m^2"  ) == Measure(units=Unit("5 m^2"), value=0.5, error=error)
          assert math.isclose( (  Measure(value=0.5)  *  " * 5 m^2"  ).value , 0.5   )
          assert math.isclose( (  Measure(value=0.5)  *  " * 5 m^2"  ).error , error )
          assert (  Measure(value=0.5)  *  " * 5 m^2"  ).implied == True
          assert (  Measure(value=0.5)  *  " * 5 m^2"  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=0.5)  *  " * 5 m^2"  ).units.magnitude == Unit("5 m^2").magnitude
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("50"))  *  " * 5 m^2"  ) , Measure )
          error = measure._sqrt_( (Decimal("50")**2 * Decimal("0")**2 + Decimal("5")**2 * Decimal("5")**2) )/Decimal("5")
          assert (  Measure(value=Decimal("50"))  *  " * 5 m^2"  ) == Measure(units=Unit("5 m^2"), value=Decimal("50"), error=error)
          assert (  Measure(value=Decimal("50"))  *  " * 5 m^2"  ).value   == Decimal("50")
          assert (  Measure(value=Decimal("50"))  *  " * 5 m^2"  ).error   == error
          assert (  Measure(value=Decimal("50"))  *  " * 5 m^2"  ).implied == True
          assert (  Measure(value=Decimal("50"))  *  " * 5 m^2"  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=Decimal("50"))  *  " * 5 m^2"  ).units.magnitude == Unit("5 m^2").magnitude
          # Value 4: Negative
          assert isinstance( (  Measure(value=-5)  *  " * 5 m^2"  ) , Measure )
          error = measure._sqrt_( (Decimal("5")**2 * Decimal("0")**2 + Decimal("5")**2 * Decimal("0.5")**2) )/Decimal("5")
          assert (  Measure(value=-5)  *  " * 5 m^2"  ).value   == -5
          #assert (  Measure(value=-5)  *  "-5 m^2"  ).error   == error
          # The above won't work, do to changes on uncertain even for decimal operations (due to calculating and back-calculating in unit operations).
          assert Measure._dec_isclose_( (Measure(value=-5)  *  Unit("5 m^2")).error , error )
          assert (  Measure(value=-5)  *  " * 5 m^2"  ).implied == True
          assert (  Measure(value=-5)  *  " * 5 m^2"  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=-5)  *  " * 5 m^2"  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  Measure(value=-5)  *  " * 5 m^2"  ) == Measure(units=Unit("5 m^2"), value=-5, error=error)
        # Convoluted Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Measure(value=300)  *  "\u00B0C" ), Measure )
          error = measure._sqrt_( (Decimal("300")**2 * Decimal("0")**2 + Decimal("274.15")**2 * Decimal("50")**2) )
          assert ( Measure(value=300)  *  "\u00B0C" ).value   == Decimal("274.15")*Decimal("300") - Decimal("273.15")
          assert ( Measure(value=300)  *  "\u00B0C" ).error   == error
          assert ( Measure(value=300)  *  "\u00B0C" ).implied == True
          assert ( Measure(value=300)  *  "\u00B0C" ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=300)  *  "\u00B0C" ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=300)  *  "\u00B0C" ) == Measure(units=Unit("\u00B0C"), value= Decimal("274.15")*Decimal("300") - Decimal("273.15"), error=error)
          # Value 2: Float
          assert isinstance( ( Measure(value=299.9)  *  "\u00B0C" ), Measure )
          error = measure._sqrt_( (299.9**2 * 0**2 + 274.15**2 * 0.05**2) )
          assert math.isclose( ( Measure(value=299.9)  *  "\u00B0C" ).value  , 299.9 * 274.15 - 273.15 )
          assert math.isclose( ( Measure(value=299.9)  *  "\u00B0C" ).error  , error )
          assert ( Measure(value=299.9)  *  "\u00B0C" ).implied == True 
          assert ( Measure(value=299.9)  *  "\u00B0C" ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=299.9)  *  "\u00B0C" ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=299.9)  *  "\u00B0C" ) == Measure(units=Unit("\u00B0C"), value=299.9 * 274.15 - 273.15, error=error)
          # Value 3: Decimal
          assert isinstance( ( Measure(value=Decimal("300"))  *  "\u00B0C" ), Measure )
          error = measure._sqrt_( (Decimal("300")**2 * Decimal("0")**2 + Decimal("274.15")**2 * Decimal("50")**2) )
          assert ( Measure(value=Decimal("300"))  *  "\u00B0C" ).value   == Decimal("274.15") * Decimal("300") - Decimal("273.15") 
          assert ( Measure(value=Decimal("300"))  *  "\u00B0C" ).error   == error
          assert ( Measure(value=Decimal("300"))  *  "\u00B0C" ).implied == True
          assert ( Measure(value=Decimal("300"))  *  "\u00B0C" ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=Decimal("300"))  *  "\u00B0C" ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=Decimal("300"))  *  "\u00B0C" ) == Measure(units=Unit("\u00B0C"), value=Decimal("274.15") * Decimal("300") - Decimal("273.15"), error=error)
          # Value 4: Negative
          assert isinstance( ( Measure(value=-300)  *  "\u00B0C" ), Measure )
          error = measure._sqrt_( (Decimal("300")**2 * Decimal("0")**2 + Decimal("274.15")**2 * Decimal("50")**2) )
          assert ( Measure(value=-300)  *  "\u00B0C" ).value   == Decimal("274.15")*Decimal("-300") - Decimal("273.15")
          assert ( Measure(value=-300)  *  "\u00B0C" ).error   == error
          assert ( Measure(value=-300)  *  "\u00B0C" ).implied == True
          assert ( Measure(value=-300)  *  "\u00B0C" ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=-300)  *  "\u00B0C" ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=-300)  *  "\u00B0C" ) == Measure(units=Unit("\u00B0C"), value= Decimal("274.15")*Decimal("-300") - Decimal("273.15"), error=error)
        # Preserve Inputs
        if(True):
          a = Measure(value=3) 
          b = "cm"
          c = a*b
          c = None
          assert a == Measure(value=3) 
          assert b == "cm"
      # Measure Units * Unit
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Measure(value=4,unit=Unit("cm"))  *  "cm"  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0")**2 + Decimal(1)**2 * Decimal("0.5")**2) )
          assert (  Measure(value=4,unit=Unit("cm"))  *  "cm"  ).value   == 4
          assert (  Measure(value=4,unit=Unit("cm"))  *  "cm"  ).error   == error
          assert (  Measure(value=4,unit=Unit("cm"))  *  "cm"  ).implied == True
          assert (  Measure(value=4,unit=Unit("cm"))  *  "cm"  ).units.symbols   == Unit("cm^2").symbols
          assert (  Measure(value=4,unit=Unit("cm"))  *  "cm"  ).units.magnitude == Unit("cm^2").magnitude
          assert (  Measure(value=4,unit=Unit("cm"))  *  "cm"  ) == Measure(units=Unit("cm^2"), value= 4, error=error)
          # Value 2: Float
          assert isinstance( ( Measure(value=0.4,unit=Unit("cm"))  *  "cm"  ), Measure )
          error = measure._sqrt_( (0.4**2 * 0**2 + 1**2 * 0.05**2) )
          assert math.isclose( (  Measure(value=0.4,unit=Unit("cm"))  *  "cm"  ).value , 0.4 )
          assert math.isclose( (  Measure(value=0.4,unit=Unit("cm"))  *  "cm"  ).error , error   )
          assert (  Measure(value=0.4,unit=Unit("cm"))  *  "cm"  ).implied == True
          assert (  Measure(value=0.4,unit=Unit("cm"))  *  "cm"  ).units.symbols   == Unit("cm^2").symbols
          assert (  Measure(value=0.4,unit=Unit("cm"))  *  "cm"  ).units.magnitude == Unit("cm^2").magnitude
          assert (  Measure(value=0.4,unit=Unit("cm"))  *  "cm"  ) == Measure(units=Unit("cm^2"), value= 0.4, error=error)
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  "cm"  ), Measure )
          error = measure._sqrt_( (Decimal("40")**2 * Decimal("0")**2 + Decimal("1")**2 * Decimal("5")**2) )
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  "cm"  ).value   == Decimal("40")
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  "cm"  ).error   == error
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  "cm"  ).implied == True
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  "cm"  ).units.symbols   == Unit("cm^2").symbols
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  "cm"  ).units.magnitude == Unit("cm^2").magnitude
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  "cm"  ) == Measure(units=Unit("cm^2"), value= Decimal("40"), error=error)
          # Value 4: Negative
          assert isinstance( ( Measure(value=-4,unit=Unit("cm"))  *  "cm"  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0")**2 + Decimal(1)**2 * Decimal("0.5")**2) )
          assert (  Measure(value=-4,unit=Unit("cm"))  *  "cm"  ).value   == -4
          assert (  Measure(value=-4,unit=Unit("cm"))  *  "cm"  ).error   == error
          assert (  Measure(value=-4,unit=Unit("cm"))  *  "cm"  ).implied == True
          assert (  Measure(value=-4,unit=Unit("cm"))  *  "cm"  ).units.symbols   == Unit("cm^2").symbols
          assert (  Measure(value=-4,unit=Unit("cm"))  *  "cm"  ).units.magnitude == Unit("cm^2").magnitude
          assert (  Measure(value=-4,unit=Unit("cm"))  *  "cm"  ) == Measure(units=Unit("cm^2"), value=-4, error=error)
        # Magnitude Units
        if(False):
          # FALSE:  Not sure this work around notation should be maintained.
          # PASS:   Str Magnitude Units are indistinguishable from Measures.
          pass
          # Value 1: Int
          assert isinstance( (  Measure(value=2,unit=Unit("5 m^2"))  *  " * 5 m^2"  ) , Measure )
          error = measure._sqrt_( (Decimal(5)**2 * Decimal("2.5")**2 + Decimal(10)**2 * Decimal("0")**2) )/Decimal(25)
          assert (  Measure(value=2,unit=Unit("5 m^2"))  *  " * 5 m^2"  ).value   == 2
          assert Measure._dec_isclose_( (  Measure(value=2,unit=Unit("5 m^2"))  *  " * 5 m^2"  ).error   , error )
          assert (  Measure(value=2,unit=Unit("5 m^2"))  *  " * 5 m^2"  ).implied == True
          assert (  Measure(value=2,unit=Unit("5 m^2"))  *  " * 5 m^2"  ).units.symbols   == Unit("25 m^4").symbols
          assert (  Measure(value=2,unit=Unit("5 m^2"))  *  " * 5 m^2"  ).units.magnitude == Unit("25 m^4").magnitude
          assert (  Measure(value=2,unit=Unit("5 m^2"))  *  " * 5 m^2"  ) == Measure(units=Unit("25 m^4"), value=2, error=error)
          # Value 2: Float
          assert isinstance( (  Measure(value=0.2,unit=Unit("5 m^2"))  *  " * 5 m^2"  ) , Measure )
          error = measure._sqrt_( (5**2 * 0.25**2 + 1.0**2 * 0**2) )/25
          assert math.isclose( (  Measure(value=0.2,unit=Unit("5 m^2"))  *  " * 5 m^2"  ).value , 0.2   )
          assert math.isclose( (  Measure(value=0.2,unit=Unit("5 m^2"))  *  " * 5 m^2"  ).error , error )
          assert (  Measure(value=0.2,unit=Unit("5 m^2"))  *  " * 5 m^2"  ).implied == True
          assert (  Measure(value=0.2,unit=Unit("5 m^2"))  *  " * 5 m^2"  ).units.symbols   == Unit("25 m^4").symbols
          assert (  Measure(value=0.2,unit=Unit("5 m^2"))  *  " * 5 m^2"  ).units.magnitude == Unit("25 m^4").magnitude
          assert (  Measure(value=0.2,unit=Unit("5 m^2"))  *  " * 5 m^2"  ) == Measure(units=Unit("25 m^4"), value=0.2, error=error)
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  " * 5 m^2"  ) , Measure )
          error = measure._sqrt_( (Decimal("5")**2 * Decimal("25")**2 + Decimal("100")**2 * Decimal("0")**2) )/Decimal("25")
          assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  " * 5 m^2"  ) == Measure(units=Unit("25 m^4"), value=Decimal("20"), error=error)
          assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  " * 5 m^2"  ).value   == Decimal("20")
          assert Measure._dec_isclose_( (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  " * 5 m^2"  ).error   , error )
          assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  " * 5 m^2"  ).implied == True
          assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  " * 5 m^2"  ).units.symbols   == Unit("25 m^4").symbols
          assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  *  " * 5 m^2"  ).units.magnitude == Unit("25 m^4").magnitude
          # Value 4: Negative
          assert isinstance( (  Measure(value=-2,unit=Unit("5 m^2"))  *  " * 5 m^2"  ) , Measure )
          error = measure._sqrt_( (Decimal(5)**2 * Decimal("2.5")**2 + Decimal(10)**2 * Decimal("0")**2) )/Decimal(25)
          assert (  Measure(value=-2,unit=Unit("5 m^2"))  *  " * 5 m^2"  ) == Measure(units=Unit("25 m^4"), value=-2, error=error)
          assert (  Measure(value=-2,unit=Unit("5 m^2"))  *  " * 5 m^2"  ).value   == -2
          assert Measure._dec_isclose_( (  Measure(value=-2,unit=Unit("5 m^2"))  *  " * 5 m^2"  ).error   , error )
          assert (  Measure(value=-2,unit=Unit("5 m^2"))  *  " * 5 m^2"  ).implied == True
          assert (  Measure(value=-2,unit=Unit("5 m^2"))  *  " * 5 m^2"  ).units.symbols   == Unit("25 m^4").symbols
          assert (  Measure(value=-2,unit=Unit("5 m^2"))  *  " * 5 m^2"  ).units.magnitude == Unit("25 m^4").magnitude
        # Convoluted Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Measure(value=27,unit=Unit("\u00B0C"))  *  "\u00B0C" ), Measure )
          error = measure._sqrt_( (Decimal("274.15")**2 * Decimal("0.5")**2 + Decimal("300.15")**2 * Decimal("0")**2) )
          assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  "\u00B0C" ).value   == Decimal("274.15")*Decimal("300.15")
          assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  "\u00B0C" ).error   == error
          assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  "\u00B0C" ).implied == True
          assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  "\u00B0C" ).units.symbols   == Unit("K^2").symbols
          assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  "\u00B0C" ).units.magnitude == Unit("K^2").magnitude
          assert ( Measure(value=27,unit=Unit("\u00B0C"))  *  "\u00B0C" ) == Measure(units=Unit("K^2"), value= Decimal("274.15")*Decimal("300.15"), error=error)
          # Value 2: Float
          assert isinstance( ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  "\u00B0C" ), Measure )
          error = measure._sqrt_( (274.15**2 * 0.005**2 + 300**2 * 0**2) )
          assert math.isclose( ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  "\u00B0C" ).value   , 274.15 * 300 )
          assert math.isclose( ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  "\u00B0C" ).error   , error )
          assert ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  "\u00B0C" ).implied == True
          assert ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  "\u00B0C" ).units.symbols   == Unit("K^2").symbols
          assert ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  "\u00B0C" ).units.magnitude == Unit("K^2").magnitude
          assert ( Measure(value=26.85,unit=Unit("\u00B0C"))  *  "\u00B0C" ) == Measure(units=Unit("K^2"), value= 274.15 * 300, error=error)
          # Value 3: Decimal
          assert isinstance( ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  "\u00B0C" ), Measure )
          error = measure._sqrt_( (Decimal("274.15")**2 * Decimal("0.005")**2 + Decimal("300")**2 * Decimal("0")**2) )
          assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  "\u00B0C" ).value   == Decimal("274.15") * Decimal("300") 
          assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  "\u00B0C" ).error   == error
          assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  "\u00B0C" ).implied == True
          assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  "\u00B0C" ).units.symbols   == Unit("K^2").symbols
          assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  "\u00B0C" ).units.magnitude == Unit("K^2").magnitude
          assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  *  "\u00B0C" ) == Measure(units=Unit("K^2"), value=Decimal("274.15") * Decimal("300"), error=error)
          # Value 4: Negative
          assert isinstance( ( Measure(value=-27,unit=Unit("\u00B0C"))  *  "\u00B0C" ), Measure )
          error = measure._sqrt_( (Decimal("274.15")**2 * Decimal("0.5")**2 + Decimal("246.15")**2 * Decimal("0")**2) )
          assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  "\u00B0C" ).value   == Decimal("274.15")*Decimal("246.15")
          assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  "\u00B0C" ).error   == error
          assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  "\u00B0C" ).implied == True
          assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  "\u00B0C" ).units.symbols   == Unit("K^2").symbols
          assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  "\u00B0C" ).units.magnitude == Unit("K^2").magnitude
          assert ( Measure(value=-27,unit=Unit("\u00B0C"))  *  "\u00B0C" ) == Measure(units=Unit("K^2"), value= Decimal("274.15")*Decimal("246.15"), error=error)
        # Canceling Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Measure(value=4,unit=Unit("cm"))  *  "cm^-1"  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0")**2 + Decimal(1)**2 * Decimal("0.5")**2) )
          assert (  Measure(value=4,unit=Unit("cm"))  *  "cm^-1"  ).value   == 4
          assert (  Measure(value=4,unit=Unit("cm"))  *  "cm^-1"  ).error   == error
          assert (  Measure(value=4,unit=Unit("cm"))  *  "cm^-1"  ).implied == True
          assert (  Measure(value=4,unit=Unit("cm"))  *  "cm^-1"  ).units.symbols   == Unit().symbols
          assert (  Measure(value=4,unit=Unit("cm"))  *  "cm^-1"  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=4,unit=Unit("cm"))  *  "cm^-1"  ) == Measure(units=Unit(), value= 4, error=error)
          # Value 2: Float
          assert isinstance( ( Measure(value=0.4,unit=Unit("cm"))  *  "cm^-1"  ), Measure )
          error = measure._sqrt_( (0.4**2 * 0**2 + 1**2 * 0.05**2) )
          assert math.isclose( (  Measure(value=0.4,unit=Unit("cm"))  *  "cm^-1"  ).value , 0.4 )
          assert math.isclose( (  Measure(value=0.4,unit=Unit("cm"))  *  "cm^-1"  ).error , error   )
          assert (  Measure(value=0.4,unit=Unit("cm"))  *  "cm^-1"  ).implied == True
          assert (  Measure(value=0.4,unit=Unit("cm"))  *  "cm^-1"  ).units.symbols   == Unit().symbols
          assert (  Measure(value=0.4,unit=Unit("cm"))  *  "cm^-1"  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=0.4,unit=Unit("cm"))  *  "cm^-1"  ) == Measure(units=Unit(), value= 0.4, error=error)
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  "cm^-1"  ), Measure )
          error = measure._sqrt_( (Decimal("40")**2 * Decimal("0")**2 + Decimal("1")**2 * Decimal("5")**2) )
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  "cm^-1"  ).value   == Decimal("40")
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  "cm^-1"  ).error   == error
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  "cm^-1"  ).implied == True
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  "cm^-1"  ).units.symbols   == Unit().symbols
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  "cm^-1"  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  *  "cm^-1"  ) == Measure(units=Unit(), value= Decimal("40"), error=error)
          # Value 4: Negative
          assert isinstance( ( Measure(value=-4,unit=Unit("cm"))  *  "cm^-1"  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0")**2 + Decimal(1)**2 * Decimal("0.5")**2) )
          assert (  Measure(value=-4,unit=Unit("cm"))  *  "cm^-1"  ).value   == -4
          assert (  Measure(value=-4,unit=Unit("cm"))  *  "cm^-1"  ).error   == error
          assert (  Measure(value=-4,unit=Unit("cm"))  *  "cm^-1"  ).implied == True
          assert (  Measure(value=-4,unit=Unit("cm"))  *  "cm^-1"  ).units.symbols   == Unit().symbols
          assert (  Measure(value=-4,unit=Unit("cm"))  *  "cm^-1"  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=-4,unit=Unit("cm"))  *  "cm^-1"  ) == Measure(units=Unit(), value= -4, error=error)
        # Preserve Inputs
        if(True):
          a = Measure(value=4,unit=Unit("cm"))
          b = "cm"
          c = a*b
          c = None
          assert a == Measure(value=4,unit=Unit("cm"))
          assert b == "cm"
    # Str Unit * Measure (Explicit Error)
    if(True):
      # Unit * Measure Unitless
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          assert isinstance( (  "cm" * Measure(value=3,error=2)  ), Measure )
          error = measure._sqrt_( (Decimal(3)**2 * Decimal("0")**2 + Decimal(1)**2 * Decimal(2)**2) )
          assert (  "cm" * Measure(value=3,error=2)  ).value   == 3
          assert (  "cm" * Measure(value=3,error=2)  ).error   == error
          assert (  "cm" * Measure(value=3,error=2)  ).implied == False
          assert (  "cm" * Measure(value=3,error=2)  ).units.symbols   == Unit("cm").symbols
          assert (  "cm" * Measure(value=3,error=2)  ).units.magnitude == Unit("cm").magnitude
          assert (  "cm" * Measure(value=3,error=2)  ) == Measure(units=Unit("cm"), value= 3, error=error)
          # Value 2: Float
          assert isinstance( (  "cm" * Measure(value=0.3,error=0.2) ), Measure )
          error = measure._sqrt_( (1**2 * 0.2**2 + 0.3**2 * 0**2) )
          assert math.isclose( (  "cm" * Measure(value=0.3,error=0.2)  ).value , 0.3 )
          assert math.isclose( (  "cm" * Measure(value=0.3,error=0.2)  ).error , error   )
          assert (  "cm" * Measure(value=0.3,error=0.2)  ).implied == False
          assert (  "cm" * Measure(value=0.3,error=0.2)  ).units.symbols   == Unit("cm").symbols
          assert (  "cm" * Measure(value=0.3,error=0.2)  ).units.magnitude == Unit("cm").magnitude
          assert (  "cm" * Measure(value=0.3,error=0.2)  ) == Measure(units=Unit("cm"), value= 0.3, error=error)
          # Value 3: Decimal
          assert isinstance( (  "cm" * Measure(value=Decimal("40"),error=Decimal("20"))  ), Measure )
          error = measure._sqrt_( ( Decimal("40")**2 * Decimal("0")**2 + Decimal("1")**2 * Decimal("20")**2) )
          assert (  "cm" * Measure(value=Decimal("40"),error=Decimal("20"))  ).value   == Decimal("40")
          assert (  "cm" * Measure(value=Decimal("40"),error=Decimal("20"))  ).error   == error
          assert (  "cm" * Measure(value=Decimal("40"),error=Decimal("20"))  ).implied == False
          assert (  "cm" * Measure(value=Decimal("40"),error=Decimal("20"))  ).units.symbols   == Unit("cm").symbols
          assert (  "cm" * Measure(value=Decimal("40"),error=Decimal("20"))  ).units.magnitude == Unit("cm").magnitude
          assert (  "cm" * Measure(value=Decimal("40"),error=Decimal("20"))  ) == Measure(units=Unit("cm"), value= Decimal("40"), error=error)
          # Value 4: Negative
          assert isinstance( (  "cm" * Measure(value=-3,error=2)  ), Measure )
          error = measure._sqrt_( (Decimal(3)**2 * Decimal("0")**2 + Decimal(1)**2 * Decimal(2)**2) )
          assert (  "cm" * Measure(value=-3,error=2)  ).value   == -3
          assert (  "cm" * Measure(value=-3,error=2)  ).error   == error
          assert (  "cm" * Measure(value=-3,error=2)  ).implied == False
          assert (  "cm" * Measure(value=-3,error=2)  ).units.symbols   == Unit("cm").symbols
          assert (  "cm" * Measure(value=-3,error=2)  ).units.magnitude == Unit("cm").magnitude
          assert (  "cm" * Measure(value=-3,error=2)  ) == Measure(units=Unit("cm"), value=-3, error=error)
        # Magnitude Units
        if(False):
          # FALSE:  Not sure this work around notation should be maintained.
          # PASS:   Str Magnitude Units are indistinguishable from Measures.
          pass
          # Value 1: Int
          assert isinstance( (  " * 5 m^2" * Measure(value=5,error=1)  ) , Measure )
          error = measure._sqrt_( (Decimal("5")**2 * Decimal("0")**2 + Decimal("5")**2 * Decimal("1")**2) )/Decimal("5")
          assert (  " * 5 m^2" * Measure(value=5,error=1)  ) == Measure(units=Unit("5 m^2"), value=5, error=error)
          assert (  " * 5 m^2" * Measure(value=5,error=1)  ).value   == 5
          #assert (  " * 5 m^2" * Measure(value=5,error=1)  ).error   == error
          # The above won't work, do to changes on uncertain even for decimal operations (due to calculating and back-calculating in unit operations).
          assert Measure._dec_isclose_( (" * 5 m^2" * Measure(value=5,error=1)).error , error )
          assert (  " * 5 m^2" * Measure(value=5,error=1)  ).implied == False
          assert (  " * 5 m^2" * Measure(value=5,error=1)  ).units.symbols   == Unit("5 m^2").symbols
          assert (  " * 5 m^2" * Measure(value=5,error=1)  ).units.magnitude == Unit("5 m^2").magnitude
          # Value 2: Float
          assert isinstance( (  " * 5 m^2" * Measure(value=0.5,error=0.1)  ) , Measure )
          error = measure._sqrt_( (0.5**2 * 0**2 + 5**2 * 0.1**2) )/5
          assert (  " * 5 m^2" * Measure(value=0.5,error=0.1)  ) == Measure(units=Unit("5 m^2"), value=0.5, error=error)
          assert math.isclose( (  " * 5 m^2" * Measure(value=0.5,error=0.1)  ).value , 0.5   )
          assert math.isclose( (  " * 5 m^2" * Measure(value=0.5,error=0.1)  ).error , error )
          assert (  " * 5 m^2" * Measure(value=0.5,error=0.1)  ).implied == False
          assert (  " * 5 m^2" * Measure(value=0.5,error=0.1)  ).units.symbols   == Unit("5 m^2").symbols
          assert (  " * 5 m^2" * Measure(value=0.5,error=0.1)  ).units.magnitude == Unit("5 m^2").magnitude
          # Value 3: Decimal
          assert isinstance( (  " * 5 m^2" * Measure(value=Decimal("50"),error=Decimal("2"))  ) , Measure )
          error = measure._sqrt_( (Decimal("50")**2 * Decimal("0")**2 + Decimal("5")**2 * Decimal("2")**2) )/Decimal("5")
          assert (  " * 5 m^2" * Measure(value=Decimal("50"),error=Decimal("2"))  ) == Measure(units=Unit("5 m^2"), value=Decimal("50"), error=error)
          assert (  " * 5 m^2" * Measure(value=Decimal("50"),error=Decimal("2"))  ).value   == Decimal("50")
          assert (  " * 5 m^2" * Measure(value=Decimal("50"),error=Decimal("2"))  ).error   == error
          assert (  " * 5 m^2" * Measure(value=Decimal("50"),error=Decimal("2"))  ).implied == False
          assert (  " * 5 m^2" * Measure(value=Decimal("50"),error=Decimal("2"))  ).units.symbols   == Unit("5 m^2").symbols
          assert (  " * 5 m^2" * Measure(value=Decimal("50"),error=Decimal("2"))  ).units.magnitude == Unit("5 m^2").magnitude
          # Value 4: Negative
          assert isinstance( (  " * 5 m^2" * Measure(value=-5,error=1)  ) , Measure )
          error = measure._sqrt_( (Decimal("5")**2 * Decimal("0")**2 + Decimal("5")**2 * Decimal("1")**2) )/Decimal("5")
          assert (  " * 5 m^2" * Measure(value=-5,error=1)  ).value   == -5
          #assert (  Unit("-5 m^2") * Measure(value=-5,error=1)  ).error   == error
          # The above won't work, do to changes on uncertain even for decimal operations (due to calculating and back-calculating in unit operations).
          assert Measure._dec_isclose_( (" * 5 m^2" * Measure(value=-5,error=1)).error , error )
          assert (  " * 5 m^2" * Measure(value=-5,error=1)  ).implied == False
          assert (  " * 5 m^2" * Measure(value=-5,error=1)  ).units.symbols   == Unit("5 m^2").symbols
          assert (  " * 5 m^2" * Measure(value=-5,error=1)  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  " * 5 m^2" * Measure(value=-5,error=1)  ) == Measure(units=Unit("5 m^2"), value=-5, error=error)
        # Convoluted Units
        if(True):
          # Value 1: Int
          assert isinstance( ( "\u00B0C" * Measure(value=300,error=2) ), Measure )
          error = measure._sqrt_( (Decimal("300")**2 * Decimal("0")**2 + Decimal("274.15")**2 * Decimal("2")**2) )
          assert ( "\u00B0C" * Measure(value=300,error=2) ).value   == Decimal("274.15")*Decimal("300") - Decimal("273.15")
          assert ( "\u00B0C" * Measure(value=300,error=2) ).error   == error
          assert ( "\u00B0C" * Measure(value=300,error=2) ).implied == False
          assert ( "\u00B0C" * Measure(value=300,error=2) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( "\u00B0C" * Measure(value=300,error=2) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( "\u00B0C" * Measure(value=300,error=2) ) == Measure(units=Unit("\u00B0C"), value= Decimal("274.15")*Decimal("300") - Decimal("273.15"), error=error)
          # Value 2: Float
          assert isinstance( ( "\u00B0C" * Measure(value=299.9,error=0.02) ), Measure )
          error = measure._sqrt_( (299.9**2 * 0**2 + 274.15**2 * 0.02**2) )
          assert math.isclose( ( "\u00B0C" * Measure(value=299.9,error=0.02) ).value  , 299.9 * 274.15 - 273.15 )
          assert math.isclose( ( "\u00B0C" * Measure(value=299.9,error=0.02) ).error  , error )
          assert ( "\u00B0C" * Measure(value=299.9,error=0.02) ).implied == False 
          assert ( "\u00B0C" * Measure(value=299.9,error=0.02) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( "\u00B0C" * Measure(value=299.9,error=0.02) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( "\u00B0C" * Measure(value=299.9,error=0.02) ) == Measure(units=Unit("\u00B0C"), value=299.9 * 274.15 - 273.15, error=error)
          # Value 3: Decimal
          assert isinstance( ( "\u00B0C" * Measure(value=Decimal("300"),error=Decimal("0.02")) ), Measure )
          error = measure._sqrt_( (Decimal("300")**2 * Decimal("0")**2 + Decimal("274.15")**2 * Decimal("0.02")**2) )
          assert ( "\u00B0C" * Measure(value=Decimal("300"),error=Decimal("0.02")) ).value   == Decimal("274.15") * Decimal("300") - Decimal("273.15") 
          assert ( "\u00B0C" * Measure(value=Decimal("300"),error=Decimal("0.02")) ).error   == error
          assert ( "\u00B0C" * Measure(value=Decimal("300"),error=Decimal("0.02")) ).implied == False
          assert ( "\u00B0C" * Measure(value=Decimal("300"),error=Decimal("0.02")) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( "\u00B0C" * Measure(value=Decimal("300"),error=Decimal("0.02")) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( "\u00B0C" * Measure(value=Decimal("300"),error=Decimal("0.02")) ) == Measure(units=Unit("\u00B0C"), value=Decimal("274.15") * Decimal("300") - Decimal("273.15"), error=error)
          # Value 4: Negative
          assert isinstance( ( "\u00B0C" * Measure(value=-300,error=2) ), Measure )
          error = measure._sqrt_( (Decimal("300")**2 * Decimal("0")**2 + Decimal("274.15")**2 * Decimal("2")**2) )
          assert ( "\u00B0C" * Measure(value=-300,error=2) ).value   == Decimal("274.15")*Decimal("-300") - Decimal("273.15")
          assert ( "\u00B0C" * Measure(value=-300,error=2) ).error   == error
          assert ( "\u00B0C" * Measure(value=-300,error=2) ).implied == False
          assert ( "\u00B0C" * Measure(value=-300,error=2) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( "\u00B0C" * Measure(value=-300,error=2) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( "\u00B0C" * Measure(value=-300,error=2) ) == Measure(units=Unit("\u00B0C"), value= Decimal("274.15")*Decimal("-300") - Decimal("273.15"), error=error)
        # Preserve Inputs
        if(True):
          a = "cm"
          b = Measure(value=3,error=2) 
          c = a*b
          c = None
          assert a == "cm"
          assert b == Measure(value=3,error=2) 
      # Unit * Measure Units
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          assert isinstance( ( "cm" * Measure(value=4,error=2,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0")**2 + Decimal(1)**2 * Decimal(2)**2) )
          assert (  "cm" * Measure(value=4,error=2,unit=Unit("cm"))  ).value   == 4
          assert (  "cm" * Measure(value=4,error=2,unit=Unit("cm"))  ).error   == error
          assert (  "cm" * Measure(value=4,error=2,unit=Unit("cm"))  ).implied == False
          assert (  "cm" * Measure(value=4,error=2,unit=Unit("cm"))  ).units.symbols   == Unit("cm^2").symbols
          assert (  "cm" * Measure(value=4,error=2,unit=Unit("cm"))  ).units.magnitude == Unit("cm^2").magnitude
          assert (  "cm" * Measure(value=4,error=2,unit=Unit("cm"))  ) == Measure(units=Unit("cm^2"), value= 4, error=error)
          # Value 2: Float
          assert isinstance( ( "cm" * Measure(value=0.4,error=0.2,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (0.4**2 * 0**2 + 1**2 * 0.2**2) )
          assert math.isclose( (  "cm" * Measure(value=0.4,error=0.2,unit=Unit("cm"))  ).value , 0.4 )
          assert math.isclose( (  "cm" * Measure(value=0.4,error=0.2,unit=Unit("cm"))  ).error , error   )
          assert (  "cm" * Measure(value=0.4,error=0.2,unit=Unit("cm"))  ).implied == False
          assert (  "cm" * Measure(value=0.4,error=0.2,unit=Unit("cm"))  ).units.symbols   == Unit("cm^2").symbols
          assert (  "cm" * Measure(value=0.4,error=0.2,unit=Unit("cm"))  ).units.magnitude == Unit("cm^2").magnitude
          assert (  "cm" * Measure(value=0.4,error=0.2,unit=Unit("cm"))  ) == Measure(units=Unit("cm^2"), value= 0.4, error=error)
          # Value 3: Decimal
          assert isinstance( (  "cm" * Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (Decimal("40")**2 * Decimal("0")**2 + Decimal("1")**2 * Decimal("20")**2) )
          assert (  "cm" * Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  ).value   == Decimal("40")
          assert (  "cm" * Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  ).error   == error
          assert (  "cm" * Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  ).implied == False
          assert (  "cm" * Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  ).units.symbols   == Unit("cm^2").symbols
          assert (  "cm" * Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  ).units.magnitude == Unit("cm^2").magnitude
          assert (  "cm" * Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  ) == Measure(units=Unit("cm^2"), value= Decimal("40"), error=error)
          # Value 4: Negative
          assert isinstance( ( "cm" * Measure(value=-4,error=2,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0")**2 + Decimal(1)**2 * Decimal(2)**2) )
          assert (  "cm" * Measure(value=-4,error=2,unit=Unit("cm"))  ).value   == -4
          assert (  "cm" * Measure(value=-4,error=2,unit=Unit("cm"))  ).error   == error
          assert (  "cm" * Measure(value=-4,error=2,unit=Unit("cm"))  ).implied == False
          assert (  "cm" * Measure(value=-4,error=2,unit=Unit("cm"))  ).units.symbols   == Unit("cm^2").symbols
          assert (  "cm" * Measure(value=-4,error=2,unit=Unit("cm"))  ).units.magnitude == Unit("cm^2").magnitude
          assert (  "cm" * Measure(value=-4,error=2,unit=Unit("cm"))  ) == Measure(units=Unit("cm^2"), value=-4, error=error)
        # Magnitude Units
        if(False):
          # FALSE:  Not sure this work around notation should be maintained.
          # PASS:   Str Magnitude Units are indistinguishable from Measures.
          pass
          # Value 1: Int
          assert isinstance( (  " * 5 m^2" * Measure(value=2,error=1,unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (Decimal(5)**2 * Decimal(5)**2 + Decimal(10)**2 * Decimal("0")**2) )/Decimal(25)
          assert (  " * 5 m^2" * Measure(value=2,error=1,unit=Unit("5 m^2"))  ).value   == 2
          assert Measure._dec_isclose_( (  " * 5 m^2" * Measure(value=2,error=1,unit=Unit("5 m^2"))  ).error   , error )
          assert (  " * 5 m^2" * Measure(value=2,error=1,unit=Unit("5 m^2"))  ).implied == False
          assert (  " * 5 m^2" * Measure(value=2,error=1,unit=Unit("5 m^2"))  ).units.symbols   == Unit("25 m^4").symbols
          assert (  " * 5 m^2" * Measure(value=2,error=1,unit=Unit("5 m^2"))  ).units.magnitude == Unit("25 m^4").magnitude
          assert (  " * 5 m^2" * Measure(value=2,error=1,unit=Unit("5 m^2"))  ) == Measure(units=Unit("25 m^4"), value=2, error=error)
          # Value 2: Float
          assert isinstance( (  " * 5 m^2" * Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (5**2 * 0.5**2 + 1.0**2 * 0**2) )/25
          assert math.isclose( (  " * 5 m^2" * Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  ).value , 0.2   )
          assert math.isclose( (  " * 5 m^2" * Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  ).error , error )
          assert (  " * 5 m^2" * Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  ).implied == False
          assert (  " * 5 m^2" * Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  ).units.symbols   == Unit("25 m^4").symbols
          assert (  " * 5 m^2" * Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  ).units.magnitude == Unit("25 m^4").magnitude
          assert (  " * 5 m^2" * Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  ) == Measure(units=Unit("25 m^4"), value=0.2, error=error)
          # Value 3: Decimal
          assert isinstance( (  " * 5 m^2" * Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (Decimal("5")**2 * Decimal("25")**2 + Decimal("100")**2 * Decimal("0")**2) )/Decimal("25")
          assert (  " * 5 m^2" * Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  ) == Measure(units=Unit("25 m^4"), value=Decimal("20"), error=error)
          assert (  " * 5 m^2" * Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  ).value   == Decimal("20")
          assert Measure._dec_isclose_( (  " * 5 m^2" * Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  ).error   , error )
          assert (  " * 5 m^2" * Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  ).implied == False
          assert (  " * 5 m^2" * Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  ).units.symbols   == Unit("25 m^4").symbols
          assert (  " * 5 m^2" * Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  ).units.magnitude == Unit("25 m^4").magnitude
          # Value 4: Negative
          assert isinstance( (  " * 5 m^2" * Measure(value=-2,error=1,unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (Decimal(5)**2 * Decimal(5)**2 + Decimal(10)**2 * Decimal("0")**2) )/Decimal(25)
          assert (  " * 5 m^2" * Measure(value=-2,error=1,unit=Unit("5 m^2"))  ) == Measure(units=Unit("25 m^4"), value=-2, error=error)
          assert (  " * 5 m^2" * Measure(value=-2,error=1,unit=Unit("5 m^2"))  ).value   == -2
          assert Measure._dec_isclose_( (  " * 5 m^2" * Measure(value=-2,error=1,unit=Unit("5 m^2"))  ).error   , error )
          assert (  " * 5 m^2" * Measure(value=-2,error=1,unit=Unit("5 m^2"))  ).implied == False
          assert (  " * 5 m^2" * Measure(value=-2,error=1,unit=Unit("5 m^2"))  ).units.symbols   == Unit("25 m^4").symbols
          assert (  " * 5 m^2" * Measure(value=-2,error=1,unit=Unit("5 m^2"))  ).units.magnitude == Unit("25 m^4").magnitude
        # Convoluted Units
        if(True):
          # Value 1: Int
          assert isinstance( ( "\u00B0C" * Measure(value=27,error=1,unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (Decimal("274.15")**2 * Decimal("1")**2 + Decimal("300.15")**2 * Decimal("0")**2) )
          assert ( "\u00B0C" * Measure(value=27,error=1,unit=Unit("\u00B0C")) ).value   == Decimal("274.15")*Decimal("300.15")
          assert ( "\u00B0C" * Measure(value=27,error=1,unit=Unit("\u00B0C")) ).error   == error
          assert ( "\u00B0C" * Measure(value=27,error=1,unit=Unit("\u00B0C")) ).implied == False
          assert ( "\u00B0C" * Measure(value=27,error=1,unit=Unit("\u00B0C")) ).units.symbols   == Unit("K^2").symbols
          assert ( "\u00B0C" * Measure(value=27,error=1,unit=Unit("\u00B0C")) ).units.magnitude == Unit("K^2").magnitude
          assert ( "\u00B0C" * Measure(value=27,error=1,unit=Unit("\u00B0C")) ) == Measure(units=Unit("K^2"), value= Decimal("274.15")*Decimal("300.15"), error=error)
          # Value 2: Float
          assert isinstance( ( "\u00B0C" * Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (274.15**2 * 0.02**2 + 300**2 * 0**2) )
          assert math.isclose( ( "\u00B0C" * Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).value   , 274.15 * 300 )
          assert math.isclose( ( "\u00B0C" * Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).error   , error )
          assert ( "\u00B0C" * Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).implied == False
          assert ( "\u00B0C" * Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).units.symbols   == Unit("K^2").symbols
          assert ( "\u00B0C" * Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).units.magnitude == Unit("K^2").magnitude
          assert ( "\u00B0C" * Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ) == Measure(units=Unit("K^2"), value= 274.15 * 300, error=error)
          # Value 3: Decimal
          assert isinstance( ( "\u00B0C" * Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (Decimal("274.15")**2 * Decimal("0.02")**2 + Decimal("300")**2 * Decimal("0")**2) )
          assert ( "\u00B0C" * Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).value   == Decimal("274.15") * Decimal("300") 
          assert ( "\u00B0C" * Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).error   == error
          assert ( "\u00B0C" * Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).implied == False
          assert ( "\u00B0C" * Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).units.symbols   == Unit("K^2").symbols
          assert ( "\u00B0C" * Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).units.magnitude == Unit("K^2").magnitude
          assert ( "\u00B0C" * Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ) == Measure(units=Unit("K^2"), value=Decimal("274.15") * Decimal("300"), error=error)
          # Value 4: Negative
          assert isinstance( ( "\u00B0C" * Measure(value=-27,error=1,unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (Decimal("274.15")**2 * Decimal("1")**2 + Decimal("246.15")**2 * Decimal("0")**2) )
          assert ( "\u00B0C" * Measure(value=-27,error=1,unit=Unit("\u00B0C")) ).value   == Decimal("274.15")*Decimal("246.15")
          assert ( "\u00B0C" * Measure(value=-27,error=1,unit=Unit("\u00B0C")) ).error   == error
          assert ( "\u00B0C" * Measure(value=-27,error=1,unit=Unit("\u00B0C")) ).implied == False
          assert ( "\u00B0C" * Measure(value=-27,error=1,unit=Unit("\u00B0C")) ).units.symbols   == Unit("K^2").symbols
          assert ( "\u00B0C" * Measure(value=-27,error=1,unit=Unit("\u00B0C")) ).units.magnitude == Unit("K^2").magnitude
          assert ( "\u00B0C" * Measure(value=-27,error=1,unit=Unit("\u00B0C")) ) == Measure(units=Unit("K^2"), value= Decimal("274.15")*Decimal("246.15"), error=error)
        # Canceling Units
        if(True):
          # Value 1: Int
          assert isinstance( ( "cm^-1" * Measure(value=4,error=2,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0")**2 + Decimal(1)**2 * Decimal(2)**2) )
          assert (  "cm^-1" * Measure(value=4,error=2,unit=Unit("cm"))  ).value   == 4
          assert (  "cm^-1" * Measure(value=4,error=2,unit=Unit("cm"))  ).error   == error
          assert (  "cm^-1" * Measure(value=4,error=2,unit=Unit("cm"))  ).implied == False
          assert (  "cm^-1" * Measure(value=4,error=2,unit=Unit("cm"))  ).units.symbols   == Unit().symbols
          assert (  "cm^-1" * Measure(value=4,error=2,unit=Unit("cm"))  ).units.magnitude == Unit().magnitude
          assert (  "cm^-1" * Measure(value=4,error=2,unit=Unit("cm"))  ) == Measure(units=Unit(), value= 4, error=error)
          # Value 2: Float
          assert isinstance( ( "cm^-1" * Measure(value=0.4,error=0.2,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (0.4**2 * 0**2 + 1**2 * 0.2**2) )
          assert math.isclose( (  "cm^-1" * Measure(value=0.4,error=0.2,unit=Unit("cm"))  ).value , 0.4 )
          assert math.isclose( (  "cm^-1" * Measure(value=0.4,error=0.2,unit=Unit("cm"))  ).error , error   )
          assert (  "cm^-1" * Measure(value=0.4,error=0.2,unit=Unit("cm"))  ).implied == False
          assert (  "cm^-1" * Measure(value=0.4,error=0.2,unit=Unit("cm"))  ).units.symbols   == Unit().symbols
          assert (  "cm^-1" * Measure(value=0.4,error=0.2,unit=Unit("cm"))  ).units.magnitude == Unit().magnitude
          assert (  "cm^-1" * Measure(value=0.4,error=0.2,unit=Unit("cm"))  ) == Measure(units=Unit(), value= 0.4, error=error)
          # Value 3: Decimal
          assert isinstance( (  "cm^-1" * Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (Decimal("40")**2 * Decimal("0")**2 + Decimal("1")**2 * Decimal("20")**2) )
          assert (  "cm^-1" * Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  ).value   == Decimal("40")
          assert (  "cm^-1" * Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  ).error   == error
          assert (  "cm^-1" * Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  ).implied == False
          assert (  "cm^-1" * Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  ).units.symbols   == Unit().symbols
          assert (  "cm^-1" * Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  ).units.magnitude == Unit().magnitude
          assert (  "cm^-1" * Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  ) == Measure(units=Unit(), value= Decimal("40"), error=error)
          # Value 4: Negative
          assert isinstance( ( "cm^-1" * Measure(value=-4,error=2,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0")**2 + Decimal(1)**2 * Decimal(2)**2) )
          assert (  "cm^-1" * Measure(value=-4,error=2,unit=Unit("cm"))  ).value   == -4
          assert (  "cm^-1" * Measure(value=-4,error=2,unit=Unit("cm"))  ).error   == error
          assert (  "cm^-1" * Measure(value=-4,error=2,unit=Unit("cm"))  ).implied == False
          assert (  "cm^-1" * Measure(value=-4,error=2,unit=Unit("cm"))  ).units.symbols   == Unit().symbols
          assert (  "cm^-1" * Measure(value=-4,error=2,unit=Unit("cm"))  ).units.magnitude == Unit().magnitude
          assert (  "cm^-1" * Measure(value=-4,error=2,unit=Unit("cm"))  ) == Measure(units=Unit(), value= -4, error=error)
        # Preserve Inputs
        if(True):
          a = "cm"
          b = Measure(value=4,error=2,unit=Unit("cm"))
          c = a*b
          c = None
          assert a == "cm"
          assert b == Measure(value=4,error=2,unit=Unit("cm"))
    # Str Unit * Measure (Implicit Error)
    if(True):
      # Unit * Measure Unitless
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          assert isinstance( (  "cm" * Measure(value=3)  ), Measure )
          error = measure._sqrt_( (Decimal(3)**2 * Decimal("0")**2 + Decimal(1)**2 * Decimal("0.5")**2) )
          assert (  "cm" * Measure(value=3)  ).value   == 3
          assert (  "cm" * Measure(value=3)  ).error   == error
          assert (  "cm" * Measure(value=3)  ).implied == True
          assert (  "cm" * Measure(value=3)  ).units.symbols   == Unit("cm").symbols
          assert (  "cm" * Measure(value=3)  ).units.magnitude == Unit("cm").magnitude
          assert (  "cm" * Measure(value=3)  ) == Measure(units=Unit("cm"), value= 3, error=error)
          # Value 2: Float
          assert isinstance( (  "cm" * Measure(value=0.3) ), Measure )
          error = measure._sqrt_( (1**2 * 0.05**2 + 0.3**2 * 0**2) )
          assert math.isclose( (  "cm" * Measure(value=0.3)  ).value , 0.3 )
          assert math.isclose( (  "cm" * Measure(value=0.3)  ).error , error   )
          assert (  "cm" * Measure(value=0.3)  ).implied == True
          assert (  "cm" * Measure(value=0.3)  ).units.symbols   == Unit("cm").symbols
          assert (  "cm" * Measure(value=0.3)  ).units.magnitude == Unit("cm").magnitude
          assert (  "cm" * Measure(value=0.3)  ) == Measure(units=Unit("cm"), value= 0.3, error=error)
          # Value 3: Decimal
          assert isinstance( (  "cm" * Measure(value=Decimal("40"))  ), Measure )
          error = measure._sqrt_( ( Decimal("40")**2 * Decimal("0")**2 + Decimal("1")**2 * Decimal("5")**2) )
          assert (  "cm" * Measure(value=Decimal("40"))  ).value   == Decimal("40")
          assert (  "cm" * Measure(value=Decimal("40"))  ).error   == error
          assert (  "cm" * Measure(value=Decimal("40"))  ).implied == True
          assert (  "cm" * Measure(value=Decimal("40"))  ).units.symbols   == Unit("cm").symbols
          assert (  "cm" * Measure(value=Decimal("40"))  ).units.magnitude == Unit("cm").magnitude
          assert (  "cm" * Measure(value=Decimal("40"))  ) == Measure(units=Unit("cm"), value= Decimal("40"), error=error)
          # Value 4: Negative
          assert isinstance( (  "cm" * Measure(value=-3)  ), Measure )
          error = measure._sqrt_( (Decimal(3)**2 * Decimal("0")**2 + Decimal(1)**2 * Decimal("0.5")**2) )
          assert (  "cm" * Measure(value=-3)  ).value   == -3
          assert (  "cm" * Measure(value=-3)  ).error   == error
          assert (  "cm" * Measure(value=-3)  ).implied == True
          assert (  "cm" * Measure(value=-3)  ).units.symbols   == Unit("cm").symbols
          assert (  "cm" * Measure(value=-3)  ).units.magnitude == Unit("cm").magnitude
          assert (  "cm" * Measure(value=-3)  ) == Measure(units=Unit("cm"), value=-3, error=error)
        # Magnitude Units
        if(False):
          # FALSE:  Not sure this work around notation should be maintained.
          # PASS:   Str Magnitude Units are indistinguishable from Measures.
          pass
          # Value 1: Int
          assert isinstance( (  " * 5 m^2" * Measure(value=5)  ) , Measure )
          error = measure._sqrt_( (Decimal("5")**2 * Decimal("0")**2 + Decimal("5")**2 * Decimal("0.5")**2) )/Decimal("5")
          assert (  " * 5 m^2" * Measure(value=5)  ) == Measure(units=Unit("5 m^2"), value=5, error=error)
          assert (  " * 5 m^2" * Measure(value=5)  ).value   == 5
          #assert (  " * 5 m^2" * Measure(value=5)  ).error   == error
          # The above won't work, do to changes on uncertain even for decimal operations (due to calculating and back-calculating in unit operations).
          assert Measure._dec_isclose_( (" * 5 m^2" * Measure(value=5)).error , error )
          assert (  " * 5 m^2" * Measure(value=5)  ).implied == True
          assert (  " * 5 m^2" * Measure(value=5)  ).units.symbols   == Unit("5 m^2").symbols
          assert (  " * 5 m^2" * Measure(value=5)  ).units.magnitude == Unit("5 m^2").magnitude
          # Value 2: Float
          assert isinstance( (  " * 5 m^2" * Measure(value=0.5)  ) , Measure )
          error = measure._sqrt_( (0.5**2 * 0**2 + 5**2 * 0.05**2) )/5
          assert (  " * 5 m^2" * Measure(value=0.5)  ) == Measure(units=Unit("5 m^2"), value=0.5, error=error)
          assert math.isclose( (  " * 5 m^2" * Measure(value=0.5)  ).value , 0.5   )
          assert math.isclose( (  " * 5 m^2" * Measure(value=0.5)  ).error , error )
          assert (  " * 5 m^2" * Measure(value=0.5)  ).implied == True
          assert (  " * 5 m^2" * Measure(value=0.5)  ).units.symbols   == Unit("5 m^2").symbols
          assert (  " * 5 m^2" * Measure(value=0.5)  ).units.magnitude == Unit("5 m^2").magnitude
          # Value 3: Decimal
          assert isinstance( (  " * 5 m^2" * Measure(value=Decimal("50"))  ) , Measure )
          error = measure._sqrt_( (Decimal("50")**2 * Decimal("0")**2 + Decimal("5")**2 * Decimal("5")**2) )/Decimal("5")
          assert (  " * 5 m^2" * Measure(value=Decimal("50"))  ) == Measure(units=Unit("5 m^2"), value=Decimal("50"), error=error)
          assert (  " * 5 m^2" * Measure(value=Decimal("50"))  ).value   == Decimal("50")
          assert (  " * 5 m^2" * Measure(value=Decimal("50"))  ).error   == error
          assert (  " * 5 m^2" * Measure(value=Decimal("50"))  ).implied == True
          assert (  " * 5 m^2" * Measure(value=Decimal("50"))  ).units.symbols   == Unit("5 m^2").symbols
          assert (  " * 5 m^2" * Measure(value=Decimal("50"))  ).units.magnitude == Unit("5 m^2").magnitude
          # Value 4: Negative
          assert isinstance( (  " * 5 m^2" * Measure(value=-5)  ) , Measure )
          error = measure._sqrt_( (Decimal("5")**2 * Decimal("0")**2 + Decimal("5")**2 * Decimal("0.5")**2) )/Decimal("5")
          assert (  " * 5 m^2" * Measure(value=-5)  ).value   == -5
          #assert (  Unit("-5 m^2") * Measure(value=-5)  ).error   == error
          # The above won't work, do to changes on uncertain even for decimal operations (due to calculating and back-calculating in unit operations).
          assert Measure._dec_isclose_( (" * 5 m^2" * Measure(value=-5)).error , error )
          assert (  " * 5 m^2" * Measure(value=-5)  ).implied == True
          assert (  " * 5 m^2" * Measure(value=-5)  ).units.symbols   == Unit("5 m^2").symbols
          assert (  " * 5 m^2" * Measure(value=-5)  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  " * 5 m^2" * Measure(value=-5)  ) == Measure(units=Unit("5 m^2"), value=-5, error=error)
        # Convoluted Units
        if(True):
          # Value 1: Int
          assert isinstance( ( "\u00B0C" * Measure(value=300) ), Measure )
          error = measure._sqrt_( (Decimal("300")**2 * Decimal("0")**2 + Decimal("274.15")**2 * Decimal("50")**2) )
          assert ( "\u00B0C" * Measure(value=300) ).value   == Decimal("274.15")*Decimal("300") - Decimal("273.15")
          assert ( "\u00B0C" * Measure(value=300) ).error   == error
          assert ( "\u00B0C" * Measure(value=300) ).implied == True
          assert ( "\u00B0C" * Measure(value=300) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( "\u00B0C" * Measure(value=300) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( "\u00B0C" * Measure(value=300) ) == Measure(units=Unit("\u00B0C"), value= Decimal("274.15")*Decimal("300") - Decimal("273.15"), error=error)
          # Value 2: Float
          assert isinstance( ( "\u00B0C" * Measure(value=299.9) ), Measure )
          error = measure._sqrt_( (299.9**2 * 0**2 + 274.15**2 * 0.05**2) )
          assert math.isclose( ( "\u00B0C" * Measure(value=299.9) ).value  , 299.9 * 274.15 - 273.15 )
          assert math.isclose( ( "\u00B0C" * Measure(value=299.9) ).error  , error )
          assert ( "\u00B0C" * Measure(value=299.9) ).implied == True 
          assert ( "\u00B0C" * Measure(value=299.9) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( "\u00B0C" * Measure(value=299.9) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( "\u00B0C" * Measure(value=299.9) ) == Measure(units=Unit("\u00B0C"), value=299.9 * 274.15 - 273.15, error=error)
          # Value 3: Decimal
          assert isinstance( ( "\u00B0C" * Measure(value=Decimal("300")) ), Measure )
          error = measure._sqrt_( (Decimal("300")**2 * Decimal("0")**2 + Decimal("274.15")**2 * Decimal("50")**2) )
          assert ( "\u00B0C" * Measure(value=Decimal("300")) ).value   == Decimal("274.15") * Decimal("300") - Decimal("273.15") 
          assert ( "\u00B0C" * Measure(value=Decimal("300")) ).error   == error
          assert ( "\u00B0C" * Measure(value=Decimal("300")) ).implied == True
          assert ( "\u00B0C" * Measure(value=Decimal("300")) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( "\u00B0C" * Measure(value=Decimal("300")) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( "\u00B0C" * Measure(value=Decimal("300")) ) == Measure(units=Unit("\u00B0C"), value=Decimal("274.15") * Decimal("300") - Decimal("273.15"), error=error)
          # Value 4: Negative
          assert isinstance( ( "\u00B0C" * Measure(value=-300) ), Measure )
          error = measure._sqrt_( (Decimal("300")**2 * Decimal("0")**2 + Decimal("274.15")**2 * Decimal("50")**2) )
          assert ( "\u00B0C" * Measure(value=-300) ).value   == Decimal("274.15")*Decimal("-300") - Decimal("273.15")
          assert ( "\u00B0C" * Measure(value=-300) ).error   == error
          assert ( "\u00B0C" * Measure(value=-300) ).implied == True
          assert ( "\u00B0C" * Measure(value=-300) ).units.symbols   == Unit("\u00B0C").symbols
          assert ( "\u00B0C" * Measure(value=-300) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( "\u00B0C" * Measure(value=-300) ) == Measure(units=Unit("\u00B0C"), value= Decimal("274.15")*Decimal("-300") - Decimal("273.15"), error=error)
        # Preserve Inputs
        if(True):
          a = "cm"
          b = Measure(value=3) 
          c = a*b
          c = None
          assert a == "cm"
          assert b == Measure(value=3) 
      # Unit * Measure Units
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          assert isinstance( ( "cm" * Measure(value=4,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0")**2 + Decimal(1)**2 * Decimal("0.5")**2) )
          assert (  "cm" * Measure(value=4,unit=Unit("cm"))  ).value   == 4
          assert (  "cm" * Measure(value=4,unit=Unit("cm"))  ).error   == error
          assert (  "cm" * Measure(value=4,unit=Unit("cm"))  ).implied == True
          assert (  "cm" * Measure(value=4,unit=Unit("cm"))  ).units.symbols   == Unit("cm^2").symbols
          assert (  "cm" * Measure(value=4,unit=Unit("cm"))  ).units.magnitude == Unit("cm^2").magnitude
          assert (  "cm" * Measure(value=4,unit=Unit("cm"))  ) == Measure(units=Unit("cm^2"), value= 4, error=error)
          # Value 2: Float
          assert isinstance( ( "cm" * Measure(value=0.4,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (0.4**2 * 0**2 + 1**2 * 0.05**2) )
          assert math.isclose( (  "cm" * Measure(value=0.4,unit=Unit("cm"))  ).value , 0.4 )
          assert math.isclose( (  "cm" * Measure(value=0.4,unit=Unit("cm"))  ).error , error   )
          assert (  "cm" * Measure(value=0.4,unit=Unit("cm"))  ).implied == True
          assert (  "cm" * Measure(value=0.4,unit=Unit("cm"))  ).units.symbols   == Unit("cm^2").symbols
          assert (  "cm" * Measure(value=0.4,unit=Unit("cm"))  ).units.magnitude == Unit("cm^2").magnitude
          assert (  "cm" * Measure(value=0.4,unit=Unit("cm"))  ) == Measure(units=Unit("cm^2"), value= 0.4, error=error)
          # Value 3: Decimal
          assert isinstance( (  "cm" * Measure(value=Decimal("40"),unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (Decimal("40")**2 * Decimal("0")**2 + Decimal("1")**2 * Decimal("5")**2) )
          assert (  "cm" * Measure(value=Decimal("40"),unit=Unit("cm"))  ).value   == Decimal("40")
          assert (  "cm" * Measure(value=Decimal("40"),unit=Unit("cm"))  ).error   == error
          assert (  "cm" * Measure(value=Decimal("40"),unit=Unit("cm"))  ).implied == True
          assert (  "cm" * Measure(value=Decimal("40"),unit=Unit("cm"))  ).units.symbols   == Unit("cm^2").symbols
          assert (  "cm" * Measure(value=Decimal("40"),unit=Unit("cm"))  ).units.magnitude == Unit("cm^2").magnitude
          assert (  "cm" * Measure(value=Decimal("40"),unit=Unit("cm"))  ) == Measure(units=Unit("cm^2"), value= Decimal("40"), error=error)
          # Value 4: Negative
          assert isinstance( ( "cm" * Measure(value=-4,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0")**2 + Decimal(1)**2 * Decimal("0.5")**2) )
          assert (  "cm" * Measure(value=-4,unit=Unit("cm"))  ).value   == -4
          assert (  "cm" * Measure(value=-4,unit=Unit("cm"))  ).error   == error
          assert (  "cm" * Measure(value=-4,unit=Unit("cm"))  ).implied == True
          assert (  "cm" * Measure(value=-4,unit=Unit("cm"))  ).units.symbols   == Unit("cm^2").symbols
          assert (  "cm" * Measure(value=-4,unit=Unit("cm"))  ).units.magnitude == Unit("cm^2").magnitude
          assert (  "cm" * Measure(value=-4,unit=Unit("cm"))  ) == Measure(units=Unit("cm^2"), value=-4, error=error)
        # Magnitude Units
        if(False):
          # FALSE:  Not sure this work around notation should be maintained.
          # PASS:   Str Magnitude Units are indistinguishable from Measures.
          pass
          # Value 1: Int
          assert isinstance( (  " * 5 m^2" * Measure(value=2,unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (Decimal(5)**2 * Decimal("2.5")**2 + Decimal(10)**2 * Decimal("0")**2) )/Decimal(25)
          assert (  " * 5 m^2" * Measure(value=2,unit=Unit("5 m^2"))  ).value   == 2
          assert Measure._dec_isclose_( (  " * 5 m^2" * Measure(value=2,unit=Unit("5 m^2"))  ).error   , error )
          assert (  " * 5 m^2" * Measure(value=2,unit=Unit("5 m^2"))  ).implied == True
          assert (  " * 5 m^2" * Measure(value=2,unit=Unit("5 m^2"))  ).units.symbols   == Unit("25 m^4").symbols
          assert (  " * 5 m^2" * Measure(value=2,unit=Unit("5 m^2"))  ).units.magnitude == Unit("25 m^4").magnitude
          assert (  " * 5 m^2" * Measure(value=2,unit=Unit("5 m^2"))  ) == Measure(units=Unit("25 m^4"), value=2, error=error)
          # Value 2: Float
          assert isinstance( (  " * 5 m^2" * Measure(value=0.2,unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (5**2 * 0.25**2 + 1.0**2 * 0**2) )/25
          assert math.isclose( (  " * 5 m^2" * Measure(value=0.2,unit=Unit("5 m^2"))  ).value , 0.2   )
          assert math.isclose( (  " * 5 m^2" * Measure(value=0.2,unit=Unit("5 m^2"))  ).error , error )
          assert (  " * 5 m^2" * Measure(value=0.2,unit=Unit("5 m^2"))  ).implied == True
          assert (  " * 5 m^2" * Measure(value=0.2,unit=Unit("5 m^2"))  ).units.symbols   == Unit("25 m^4").symbols
          assert (  " * 5 m^2" * Measure(value=0.2,unit=Unit("5 m^2"))  ).units.magnitude == Unit("25 m^4").magnitude
          assert (  " * 5 m^2" * Measure(value=0.2,unit=Unit("5 m^2"))  ) == Measure(units=Unit("25 m^4"), value=0.2, error=error)
          # Value 3: Decimal
          assert isinstance( (  " * 5 m^2" * Measure(value=Decimal("20"),unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (Decimal("5")**2 * Decimal("25")**2 + Decimal("100")**2 * Decimal("0")**2) )/Decimal("25")
          assert (  " * 5 m^2" * Measure(value=Decimal("20"),unit=Unit("5 m^2"))  ) == Measure(units=Unit("25 m^4"), value=Decimal("20"), error=error)
          assert (  " * 5 m^2" * Measure(value=Decimal("20"),unit=Unit("5 m^2"))  ).value   == Decimal("20")
          assert Measure._dec_isclose_( (  " * 5 m^2" * Measure(value=Decimal("20"),unit=Unit("5 m^2"))  ).error   , error )
          assert (  " * 5 m^2" * Measure(value=Decimal("20"),unit=Unit("5 m^2"))  ).implied == True
          assert (  " * 5 m^2" * Measure(value=Decimal("20"),unit=Unit("5 m^2"))  ).units.symbols   == Unit("25 m^4").symbols
          assert (  " * 5 m^2" * Measure(value=Decimal("20"),unit=Unit("5 m^2"))  ).units.magnitude == Unit("25 m^4").magnitude
          # Value 4: Negative
          assert isinstance( (  " * 5 m^2" * Measure(value=-2,unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (Decimal(5)**2 * Decimal("2.5")**2 + Decimal(10)**2 * Decimal("0")**2) )/Decimal(25)
          assert (  " * 5 m^2" * Measure(value=-2,unit=Unit("5 m^2"))  ) == Measure(units=Unit("25 m^4"), value=-2, error=error)
          assert (  " * 5 m^2" * Measure(value=-2,unit=Unit("5 m^2"))  ).value   == -2
          assert Measure._dec_isclose_( (  " * 5 m^2" * Measure(value=-2,unit=Unit("5 m^2"))  ).error   , error )
          assert (  " * 5 m^2" * Measure(value=-2,unit=Unit("5 m^2"))  ).implied == True
          assert (  " * 5 m^2" * Measure(value=-2,unit=Unit("5 m^2"))  ).units.symbols   == Unit("25 m^4").symbols
          assert (  " * 5 m^2" * Measure(value=-2,unit=Unit("5 m^2"))  ).units.magnitude == Unit("25 m^4").magnitude
        # Convoluted Units
        if(True):
          # Value 1: Int
          assert isinstance( ( "\u00B0C" * Measure(value=27,unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (Decimal("274.15")**2 * Decimal("0.5")**2 + Decimal("300.15")**2 * Decimal("0")**2) )
          assert ( "\u00B0C" * Measure(value=27,unit=Unit("\u00B0C")) ).value   == Decimal("274.15")*Decimal("300.15")
          assert ( "\u00B0C" * Measure(value=27,unit=Unit("\u00B0C")) ).error   == error
          assert ( "\u00B0C" * Measure(value=27,unit=Unit("\u00B0C")) ).implied == True
          assert ( "\u00B0C" * Measure(value=27,unit=Unit("\u00B0C")) ).units.symbols   == Unit("K^2").symbols
          assert ( "\u00B0C" * Measure(value=27,unit=Unit("\u00B0C")) ).units.magnitude == Unit("K^2").magnitude
          assert ( "\u00B0C" * Measure(value=27,unit=Unit("\u00B0C")) ) == Measure(units=Unit("K^2"), value= Decimal("274.15")*Decimal("300.15"), error=error)
          # Value 2: Float
          assert isinstance( ( "\u00B0C" * Measure(value=26.85,unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (274.15**2 * 0.005**2 + 300**2 * 0**2) )
          assert math.isclose( ( "\u00B0C" * Measure(value=26.85,unit=Unit("\u00B0C")) ).value   , 274.15 * 300 )
          assert math.isclose( ( "\u00B0C" * Measure(value=26.85,unit=Unit("\u00B0C")) ).error   , error )
          assert ( "\u00B0C" * Measure(value=26.85,unit=Unit("\u00B0C")) ).implied == True
          assert ( "\u00B0C" * Measure(value=26.85,unit=Unit("\u00B0C")) ).units.symbols   == Unit("K^2").symbols
          assert ( "\u00B0C" * Measure(value=26.85,unit=Unit("\u00B0C")) ).units.magnitude == Unit("K^2").magnitude
          assert ( "\u00B0C" * Measure(value=26.85,unit=Unit("\u00B0C")) ) == Measure(units=Unit("K^2"), value= 274.15 * 300, error=error)
          # Value 3: Decimal
          assert isinstance( ( "\u00B0C" * Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (Decimal("274.15")**2 * Decimal("0.005")**2 + Decimal("300")**2 * Decimal("0")**2) )
          assert ( "\u00B0C" * Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).value   == Decimal("274.15") * Decimal("300") 
          assert ( "\u00B0C" * Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).error   == error
          assert ( "\u00B0C" * Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).implied == True
          assert ( "\u00B0C" * Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).units.symbols   == Unit("K^2").symbols
          assert ( "\u00B0C" * Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).units.magnitude == Unit("K^2").magnitude
          assert ( "\u00B0C" * Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ) == Measure(units=Unit("K^2"), value=Decimal("274.15") * Decimal("300"), error=error)
          # Value 4: Negative
          assert isinstance( ( "\u00B0C" * Measure(value=-27,unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (Decimal("274.15")**2 * Decimal("0.5")**2 + Decimal("246.15")**2 * Decimal("0")**2) )
          assert ( "\u00B0C" * Measure(value=-27,unit=Unit("\u00B0C")) ).value   == Decimal("274.15")*Decimal("246.15")
          assert ( "\u00B0C" * Measure(value=-27,unit=Unit("\u00B0C")) ).error   == error
          assert ( "\u00B0C" * Measure(value=-27,unit=Unit("\u00B0C")) ).implied == True
          assert ( "\u00B0C" * Measure(value=-27,unit=Unit("\u00B0C")) ).units.symbols   == Unit("K^2").symbols
          assert ( "\u00B0C" * Measure(value=-27,unit=Unit("\u00B0C")) ).units.magnitude == Unit("K^2").magnitude
          assert ( "\u00B0C" * Measure(value=-27,unit=Unit("\u00B0C")) ) == Measure(units=Unit("K^2"), value= Decimal("274.15")*Decimal("246.15"), error=error)
        # Canceling Units
        if(True):
          # Value 1: Int
          assert isinstance( ( "cm^-1" * Measure(value=4,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0")**2 + Decimal(1)**2 * Decimal("0.5")**2) )
          assert (  "cm^-1" * Measure(value=4,unit=Unit("cm"))  ).value   == 4
          assert (  "cm^-1" * Measure(value=4,unit=Unit("cm"))  ).error   == error
          assert (  "cm^-1" * Measure(value=4,unit=Unit("cm"))  ).implied == True
          assert (  "cm^-1" * Measure(value=4,unit=Unit("cm"))  ).units.symbols   == Unit().symbols
          assert (  "cm^-1" * Measure(value=4,unit=Unit("cm"))  ).units.magnitude == Unit().magnitude
          assert (  "cm^-1" * Measure(value=4,unit=Unit("cm"))  ) == Measure(units=Unit(), value= 4, error=error)
          # Value 2: Float
          assert isinstance( ( "cm^-1" * Measure(value=0.4,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (0.4**2 * 0**2 + 1**2 * 0.05**2) )
          assert math.isclose( (  "cm^-1" * Measure(value=0.4,unit=Unit("cm"))  ).value , 0.4 )
          assert math.isclose( (  "cm^-1" * Measure(value=0.4,unit=Unit("cm"))  ).error , error   )
          assert (  "cm^-1" * Measure(value=0.4,unit=Unit("cm"))  ).implied == True
          assert (  "cm^-1" * Measure(value=0.4,unit=Unit("cm"))  ).units.symbols   == Unit().symbols
          assert (  "cm^-1" * Measure(value=0.4,unit=Unit("cm"))  ).units.magnitude == Unit().magnitude
          assert (  "cm^-1" * Measure(value=0.4,unit=Unit("cm"))  ) == Measure(units=Unit(), value= 0.4, error=error)
          # Value 3: Decimal
          assert isinstance( (  "cm^-1" * Measure(value=Decimal("40"),unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (Decimal("40")**2 * Decimal("0")**2 + Decimal("1")**2 * Decimal("5")**2) )
          assert (  "cm^-1" * Measure(value=Decimal("40"),unit=Unit("cm"))  ).value   == Decimal("40")
          assert (  "cm^-1" * Measure(value=Decimal("40"),unit=Unit("cm"))  ).error   == error
          assert (  "cm^-1" * Measure(value=Decimal("40"),unit=Unit("cm"))  ).implied == True
          assert (  "cm^-1" * Measure(value=Decimal("40"),unit=Unit("cm"))  ).units.symbols   == Unit().symbols
          assert (  "cm^-1" * Measure(value=Decimal("40"),unit=Unit("cm"))  ).units.magnitude == Unit().magnitude
          assert (  "cm^-1" * Measure(value=Decimal("40"),unit=Unit("cm"))  ) == Measure(units=Unit(), value= Decimal("40"), error=error)
          # Value 4: Negative
          assert isinstance( ( "cm^-1" * Measure(value=-4,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0")**2 + Decimal(1)**2 * Decimal("0.5")**2) )
          assert (  "cm^-1" * Measure(value=-4,unit=Unit("cm"))  ).value   == -4
          assert (  "cm^-1" * Measure(value=-4,unit=Unit("cm"))  ).error   == error
          assert (  "cm^-1" * Measure(value=-4,unit=Unit("cm"))  ).implied == True
          assert (  "cm^-1" * Measure(value=-4,unit=Unit("cm"))  ).units.symbols   == Unit().symbols
          assert (  "cm^-1" * Measure(value=-4,unit=Unit("cm"))  ).units.magnitude == Unit().magnitude
          assert (  "cm^-1" * Measure(value=-4,unit=Unit("cm"))  ) == Measure(units=Unit(), value= -4, error=error)
        # Preserve Inputs
        if(True):
          a = "cm"
          b = Measure(value=4,unit=Unit("cm"))
          c = a*b
          c = None
          assert a == "cm"
          assert b == Measure(value=4,unit=Unit("cm"))
    
  def test_measure_str_decimal_mul(self):
    # These are dependent on Measure str parser 
    
    # Measure (Explicit Error) * Str Decimal
    if(True):
      # Measure Unitless * Decimal
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          assert isinstance( (  Measure(value=3,error=2)  * "3"  ), Measure )
          error = measure._sqrt_( (Decimal(3)**2 * Decimal("0")**2 + Decimal(3)**2 * Decimal(2)**2) )
          assert (  Measure(value=3,error=2)  * "3"  ).value   == 9
          assert (  Measure(value=3,error=2)  * "3"  ).error   == error
          assert (  Measure(value=3,error=2)  * "3"  ).implied == False
          assert (  Measure(value=3,error=2)  * "3"  ).units.symbols   == Unit().symbols
          assert (  Measure(value=3,error=2)  * "3"  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=3,error=2)  * "3"  ) == Measure(units=Unit(), value= 9, error=error)
          # Value 2: Float
          assert isinstance( (  Measure(value=0.3,error=0.2)  * "3" ), Measure )
          error = measure._sqrt_( (3**2 * 0.2**2 + 0.3**2 * 0**2) )
          assert math.isclose( (  Measure(value=0.3,error=0.2)  * "3"  ).value , 0.3*3 )
          assert math.isclose( (  Measure(value=0.3,error=0.2)  * "3"  ).error , error   )
          assert (  Measure(value=0.3,error=0.2)  * "3"  ).implied == False
          assert (  Measure(value=0.3,error=0.2)  * "3"  ).units.symbols   == Unit().symbols
          assert (  Measure(value=0.3,error=0.2)  * "3"  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=0.3,error=0.2)  * "3"  ) == Measure(units=Unit(), value= 0.3*3, error=error)
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("40"),error=Decimal("20"))  * "3"  ), Measure )
          error = measure._sqrt_( ( Decimal("40")**2 * Decimal("0")**2 + Decimal("3")**2 * Decimal("20")**2) )
          assert (  Measure(value=Decimal("40"),error=Decimal("20"))  * "3"  ).value   == Decimal("40")*Decimal("3")
          assert (  Measure(value=Decimal("40"),error=Decimal("20"))  * "3"  ).error   == error
          assert (  Measure(value=Decimal("40"),error=Decimal("20"))  * "3"  ).implied == False
          assert (  Measure(value=Decimal("40"),error=Decimal("20"))  * "3"  ).units.symbols   == Unit().symbols
          assert (  Measure(value=Decimal("40"),error=Decimal("20"))  * "3"  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=Decimal("40"),error=Decimal("20"))  * "3"  ) == Measure(units=Unit(), value= Decimal("40")*Decimal("3"), error=error)
          # Value 4: Negative
          assert isinstance( (  Measure(value=-3,error=2)  * "3"  ), Measure )
          error = measure._sqrt_( (Decimal(3)**2 * Decimal("0")**2 + Decimal("3")**2 * Decimal(2)**2) )
          assert (  Measure(value=-3,error=2)  * "3"  ).value   == -3*3
          assert (  Measure(value=-3,error=2)  * "3"  ).error   == error
          assert (  Measure(value=-3,error=2)  * "3"  ).implied == False
          assert (  Measure(value=-3,error=2)  * "3"  ).units.symbols   == Unit().symbols
          assert (  Measure(value=-3,error=2)  * "3"  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=-3,error=2)  * "3"  ) == Measure(units=Unit(), value=-3*3, error=error)
        # Preserve Inputs
        if(True):
          a = Measure(value=3,error=2) 
          b = "3"
          c = a*b
          c = None
          assert a == Measure(value=3,error=2) 
          assert b == "3"
      # Measure Units * Decimal
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Measure(value=4,error=2,unit=Unit("cm"))  * "3"  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0")**2 + Decimal(3)**2 * Decimal(2)**2) )
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  * "3"  ).value   == 4*3
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  * "3"  ).error   == error
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  * "3"  ).implied == False
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  * "3"  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  * "3"  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=4,error=2,unit=Unit("cm"))  * "3"  ) == Measure(units=Unit("cm"), value= 4*3, error=error)
          # Value 2: Float
          assert isinstance( ( Measure(value=0.4,error=0.2,unit=Unit("cm"))  * "3"  ), Measure )
          error = measure._sqrt_( (0.4**2 * 0**2 + 3**2 * 0.2**2) )
          assert math.isclose( (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  * "3"  ).value , 0.4*3 )
          assert math.isclose( (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  * "3"  ).error , error   )
          assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  * "3"  ).implied == False
          assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  * "3"  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  * "3"  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=0.4,error=0.2,unit=Unit("cm"))  * "3"  ) == Measure(units=Unit("cm"), value= 0.4*3, error=error)
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  * "3"  ), Measure )
          error = measure._sqrt_( (Decimal("40")**2 * Decimal("0")**2 + Decimal("3")**2 * Decimal("20")**2) )
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  * "3"  ).value   == Decimal("40")*Decimal("3")
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  * "3"  ).error   == error
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  * "3"  ).implied == False
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  * "3"  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  * "3"  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  * "3"  ) == Measure(units=Unit("cm"), value= Decimal("40")*Decimal("3"), error=error)
          # Value 4: Negative
          assert isinstance( ( Measure(value=-4,error=2,unit=Unit("cm"))  * "3"  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0")**2 + Decimal("3")**2 * Decimal(2)**2) )
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  * "3"  ).value   == -4*Decimal("3")
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  * "3"  ).error   == error
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  * "3"  ).implied == False
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  * "3"  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  * "3"  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=-4,error=2,unit=Unit("cm"))  * "3"  ) == Measure(units=Unit("cm"), value=-4*Decimal("3"), error=error)
        # Magnitude Units
        if(True):
          # Value 1: Int
          assert isinstance( (  Measure(value=2,error=1,unit=Unit("5 m^2"))  * "3"  ) , Measure )
          error = measure._sqrt_( (Decimal("3")**2 * Decimal(5)**2 + Decimal(10)**2 * Decimal("0")**2) )/Decimal(5)
          assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  * "3"  ).value   == 2*  Decimal("3")
          assert Measure._dec_isclose_( (  Measure(value=2,error=1,unit=Unit("5 m^2"))  * "3"  ).error   , error )
          assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  * "3"  ).implied == False
          assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  * "3"  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  * "3"  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  Measure(value=2,error=1,unit=Unit("5 m^2"))  * "3"  ) == Measure(units=Unit("5 m^2"), value=2*  Decimal("3"), error=error)
          # Value 2: Float
          assert isinstance( (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  * "3"  ) , Measure )
          error = measure._sqrt_( (3**2 * 0.5**2 + 1.0**2 * 0**2) )/5
          assert math.isclose( (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  * "3"  ).value , 0.2*3   )
          assert math.isclose( (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  * "3"  ).error , error )
          assert (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  * "3"  ).implied == False
          assert (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  * "3"  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  * "3"  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  * "3"  ) == Measure(units=Unit("5 m^2"), value=0.2*3, error=error)
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  * "3"  ) , Measure )
          error = measure._sqrt_( (Decimal("3")**2 * Decimal("25")**2 + Decimal("100")**2 * Decimal("0")**2) )/Decimal("5")
          assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  * "3"  ).value   == Decimal("20")*Decimal("3")
          assert Measure._dec_isclose_( (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  * "3"  ).error   , error )
          assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  * "3"  ).implied == False
          assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  * "3"  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  * "3"  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  * "3"  ) == Measure(units=Unit("5 m^2"), value=Decimal("20")*Decimal("3"), error=error)
          # Value 4: Negative
          assert isinstance( (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  * "3"  ) , Measure )
          error = measure._sqrt_( (Decimal("3")**2 * Decimal(5)**2 + Decimal(10)**2 * Decimal("0")**2) )/Decimal(5)
          assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  * "3"  ).value   == -2*Decimal("3")
          assert Measure._dec_isclose_( (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  * "3"  ).error   , error )
          assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  * "3"  ).implied == False
          assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  * "3"  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  * "3"  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  Measure(value=-2,error=1,unit=Unit("5 m^2"))  * "3"  ) == Measure(units=Unit("5 m^2"), value=-2*Decimal("3"), error=error)
        # Convoluted Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  * "3" ), Measure )
          error = measure._sqrt_( (Decimal("3")**2 * Decimal("1")**2 + Decimal("300.15")**2 * Decimal("0")**2) )
          assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  * "3" ).value   == Decimal("3")*Decimal("300.15")-Decimal("273.15")
          assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  * "3" ).error   == error
          assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  * "3" ).implied == False
          assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  * "3" ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  * "3" ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=27,error=1,unit=Unit("\u00B0C"))  * "3" ) == Measure(units=Unit("\u00B0C"), value=Decimal("3")*Decimal("300.15")-Decimal("273.15"), error=error)
          # Value 2: Float
          assert isinstance( ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  * "3" ), Measure )
          error = measure._sqrt_( (3**2 * 0.02**2 + 300**2 * 0**2) )
          assert math.isclose( ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  * "3" ).value   , 3 * 300 - 273.15 )
          assert math.isclose( ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  * "3" ).error   , error )
          assert ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  * "3" ).implied == False
          assert ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  * "3" ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  * "3" ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=26.85,error=0.02,unit=Unit("\u00B0C"))  * "3" ) == Measure(units=Unit("\u00B0C"), value= 3 * 300 - 273.15, error=error)
          # Value 3: Decimal
          assert isinstance( ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  * "3" ), Measure )
          error = measure._sqrt_( (Decimal("3")**2 * Decimal("0.02")**2 + Decimal("300")**2 * Decimal("0")**2) )
          assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  * "3" ).value   == Decimal("3")* Decimal("300") -Decimal("273.15")
          assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  * "3" ).error   == error
          assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  * "3" ).implied == False
          assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  * "3" ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  * "3" ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C"))  * "3" ) == Measure(units=Unit("\u00B0C"), value=Decimal("3") * Decimal("300")-Decimal("273.15"), error=error)
          # Value 4: Negative
          assert isinstance( ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  * "3" ), Measure )
          error = measure._sqrt_( (Decimal("3")**2 * Decimal("1")**2 + Decimal("246.15")**2 * Decimal("0")**2) )
          assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  * "3" ).value   == Decimal("3")*Decimal("246.15")-Decimal("273.15")
          assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  * "3" ).error   == error
          assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  * "3" ).implied == False
          assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  * "3" ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  * "3" ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=-27,error=1,unit=Unit("\u00B0C"))  * "3" ) == Measure(units=Unit("\u00B0C"), value= Decimal("3")*Decimal("246.15")-Decimal("273.15"), error=error)
        # Preserve Inputs
        if(True):
          a = Measure(value=4,error=2,unit=Unit("cm"))
          b = "3"
          c = a*b
          c = None
          assert a == Measure(value=4,error=2,unit=Unit("cm"))
          assert b == "3"
    # Measure (Implicit Error) * Str Decimal
    if(True):
      # Measure Unitless * Decimal
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          assert isinstance( (  Measure(value=3)  * "3"  ), Measure )
          error = measure._sqrt_( (Decimal(3)**2 * Decimal("0")**2 + Decimal(3)**2 * Decimal("0.5")**2) )
          assert (  Measure(value=3)  * "3"  ).value   == 9
          assert (  Measure(value=3)  * "3"  ).error   == error
          assert (  Measure(value=3)  * "3"  ).implied == True
          assert (  Measure(value=3)  * "3"  ).units.symbols   == Unit().symbols
          assert (  Measure(value=3)  * "3"  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=3)  * "3"  ) == Measure(units=Unit(), value= 9, error=error)
          # Value 2: Float
          assert isinstance( (  Measure(value=0.3)  * "3" ), Measure )
          error = measure._sqrt_( (3**2 * 0.05**2 + 0.3**2 * 0**2) )
          assert math.isclose( (  Measure(value=0.3)  * "3"  ).value , 0.3*3 )
          assert math.isclose( (  Measure(value=0.3)  * "3"  ).error , error   )
          assert (  Measure(value=0.3)  * "3"  ).implied == True
          assert (  Measure(value=0.3)  * "3"  ).units.symbols   == Unit().symbols
          assert (  Measure(value=0.3)  * "3"  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=0.3)  * "3"  ) == Measure(units=Unit(), value= 0.3*3, error=error)
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("40"))  * "3"  ), Measure )
          error = measure._sqrt_( ( Decimal("40")**2 * Decimal("0")**2 + Decimal("3")**2 * Decimal("5")**2) )
          assert (  Measure(value=Decimal("40"))  * "3"  ).value   == Decimal("40")*Decimal("3")
          assert (  Measure(value=Decimal("40"))  * "3"  ).error   == error
          assert (  Measure(value=Decimal("40"))  * "3"  ).implied == True
          assert (  Measure(value=Decimal("40"))  * "3"  ).units.symbols   == Unit().symbols
          assert (  Measure(value=Decimal("40"))  * "3"  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=Decimal("40"))  * "3"  ) == Measure(units=Unit(), value= Decimal("40")*Decimal("3"), error=error)
          # Value 4: Negative
          assert isinstance( (  Measure(value=-3)  * "3"  ), Measure )
          error = measure._sqrt_( (Decimal(3)**2 * Decimal("0")**2 + Decimal("3")**2 * Decimal("0.5")**2) )
          assert (  Measure(value=-3)  * "3"  ).value   == -3*3
          assert (  Measure(value=-3)  * "3"  ).error   == error
          assert (  Measure(value=-3)  * "3"  ).implied == True
          assert (  Measure(value=-3)  * "3"  ).units.symbols   == Unit().symbols
          assert (  Measure(value=-3)  * "3"  ).units.magnitude == Unit().magnitude
          assert (  Measure(value=-3)  * "3"  ) == Measure(units=Unit(), value=-3*3, error=error)
        # Preserve Inputs
        if(True):
          a = Measure(value=3) 
          b = "3"
          c = a*b
          c = None
          assert a == Measure(value=3) 
          assert b == "3"
      # Measure Units * Decimal
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Measure(value=4,unit=Unit("cm"))  * "3"  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0")**2 + Decimal(3)**2 * Decimal("0.5")**2) )
          assert (  Measure(value=4,unit=Unit("cm"))  * "3"  ).value   == 4*3
          assert (  Measure(value=4,unit=Unit("cm"))  * "3"  ).error   == error
          assert (  Measure(value=4,unit=Unit("cm"))  * "3"  ).implied == True
          assert (  Measure(value=4,unit=Unit("cm"))  * "3"  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=4,unit=Unit("cm"))  * "3"  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=4,unit=Unit("cm"))  * "3"  ) == Measure(units=Unit("cm"), value= 4*3, error=error)
          # Value 2: Float
          assert isinstance( ( Measure(value=0.4,unit=Unit("cm"))  * "3"  ), Measure )
          error = measure._sqrt_( (0.4**2 * 0**2 + 3**2 * 0.05**2) )
          assert math.isclose( (  Measure(value=0.4,unit=Unit("cm"))  * "3"  ).value , 0.4*3 )
          assert math.isclose( (  Measure(value=0.4,unit=Unit("cm"))  * "3"  ).error , error   )
          assert (  Measure(value=0.4,unit=Unit("cm"))  * "3"  ).implied == True
          assert (  Measure(value=0.4,unit=Unit("cm"))  * "3"  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=0.4,unit=Unit("cm"))  * "3"  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=0.4,unit=Unit("cm"))  * "3"  ) == Measure(units=Unit("cm"), value= 0.4*3, error=error)
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("40"),unit=Unit("cm"))  * "3"  ), Measure )
          error = measure._sqrt_( (Decimal("40")**2 * Decimal("0")**2 + Decimal("3")**2 * Decimal("5")**2) )
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  * "3"  ).value   == Decimal("40")*Decimal("3")
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  * "3"  ).error   == error
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  * "3"  ).implied == True
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  * "3"  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  * "3"  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=Decimal("40"),unit=Unit("cm"))  * "3"  ) == Measure(units=Unit("cm"), value= Decimal("40")*Decimal("3"), error=error)
          # Value 4: Negative
          assert isinstance( ( Measure(value=-4,unit=Unit("cm"))  * "3"  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0")**2 + Decimal("3")**2 * Decimal("0.5")**2) )
          assert (  Measure(value=-4,unit=Unit("cm"))  * "3"  ).value   == -4*Decimal("3")
          assert (  Measure(value=-4,unit=Unit("cm"))  * "3"  ).error   == error
          assert (  Measure(value=-4,unit=Unit("cm"))  * "3"  ).implied == True
          assert (  Measure(value=-4,unit=Unit("cm"))  * "3"  ).units.symbols   == Unit("cm").symbols
          assert (  Measure(value=-4,unit=Unit("cm"))  * "3"  ).units.magnitude == Unit("cm").magnitude
          assert (  Measure(value=-4,unit=Unit("cm"))  * "3"  ) == Measure(units=Unit("cm"), value=-4*Decimal("3"), error=error)
        # Magnitude Units
        if(True):
          # Value 1: Int
          assert isinstance( (  Measure(value=2,unit=Unit("5 m^2"))  * "3"  ) , Measure )
          error = measure._sqrt_( (Decimal("3")**2 * Decimal("2.5")**2 + Decimal(10)**2 * Decimal("0")**2) )/Decimal(5)
          assert (  Measure(value=2,unit=Unit("5 m^2"))  * "3"  ).value   == 2*  Decimal("3")
          assert Measure._dec_isclose_( (  Measure(value=2,unit=Unit("5 m^2"))  * "3"  ).error   , error )
          assert (  Measure(value=2,unit=Unit("5 m^2"))  * "3"  ).implied == True
          assert (  Measure(value=2,unit=Unit("5 m^2"))  * "3"  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=2,unit=Unit("5 m^2"))  * "3"  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  Measure(value=2,unit=Unit("5 m^2"))  * "3"  ) == Measure(units=Unit("5 m^2"), value=2*  Decimal("3"), error=error)
          # Value 2: Float
          assert isinstance( (  Measure(value=0.2,unit=Unit("5 m^2"))  * "3"  ) , Measure )
          error = measure._sqrt_( (3**2 * 0.25**2 + 1.0**2 * 0**2) )/5
          assert math.isclose( (  Measure(value=0.2,unit=Unit("5 m^2"))  * "3"  ).value , 0.2*3   )
          assert math.isclose( (  Measure(value=0.2,unit=Unit("5 m^2"))  * "3"  ).error , error )
          assert (  Measure(value=0.2,unit=Unit("5 m^2"))  * "3"  ).implied == True
          assert (  Measure(value=0.2,unit=Unit("5 m^2"))  * "3"  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=0.2,unit=Unit("5 m^2"))  * "3"  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  Measure(value=0.2,unit=Unit("5 m^2"))  * "3"  ) == Measure(units=Unit("5 m^2"), value=0.2*3, error=error)
          # Value 3: Decimal
          assert isinstance( (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  * "3"  ) , Measure )
          error = measure._sqrt_( (Decimal("3")**2 * Decimal("25")**2 + Decimal("100")**2 * Decimal("0")**2) )/Decimal("5")
          assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  * "3"  ).value   == Decimal("20")*Decimal("3")
          assert Measure._dec_isclose_( (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  * "3"  ).error   , error )
          assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  * "3"  ).implied == True
          assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  * "3"  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  * "3"  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  Measure(value=Decimal("20"),unit=Unit("5 m^2"))  * "3"  ) == Measure(units=Unit("5 m^2"), value=Decimal("20")*Decimal("3"), error=error)
          # Value 4: Negative
          assert isinstance( (  Measure(value=-2,unit=Unit("5 m^2"))  * "3"  ) , Measure )
          error = measure._sqrt_( (Decimal("3")**2 * Decimal("2.5")**2 + Decimal(10)**2 * Decimal("0")**2) )/Decimal(5)
          assert (  Measure(value=-2,unit=Unit("5 m^2"))  * "3"  ).value   == -2*Decimal("3")
          assert Measure._dec_isclose_( (  Measure(value=-2,unit=Unit("5 m^2"))  * "3"  ).error   , error )
          assert (  Measure(value=-2,unit=Unit("5 m^2"))  * "3"  ).implied == True
          assert (  Measure(value=-2,unit=Unit("5 m^2"))  * "3"  ).units.symbols   == Unit("5 m^2").symbols
          assert (  Measure(value=-2,unit=Unit("5 m^2"))  * "3"  ).units.magnitude == Unit("5 m^2").magnitude
          assert (  Measure(value=-2,unit=Unit("5 m^2"))  * "3"  ) == Measure(units=Unit("5 m^2"), value=-2*Decimal("3"), error=error)
        # Convoluted Units
        if(True):
          # Value 1: Int
          assert isinstance( ( Measure(value=27,unit=Unit("\u00B0C"))  * "3" ), Measure )
          error = measure._sqrt_( (Decimal("3")**2 * Decimal("0.5")**2 + Decimal("300.15")**2 * Decimal("0")**2) )
          assert ( Measure(value=27,unit=Unit("\u00B0C"))  * "3" ).value   == Decimal("3")*Decimal("300.15")-Decimal("273.15")
          assert ( Measure(value=27,unit=Unit("\u00B0C"))  * "3" ).error   == error
          assert ( Measure(value=27,unit=Unit("\u00B0C"))  * "3" ).implied == True
          assert ( Measure(value=27,unit=Unit("\u00B0C"))  * "3" ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=27,unit=Unit("\u00B0C"))  * "3" ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=27,unit=Unit("\u00B0C"))  * "3" ) == Measure(units=Unit("\u00B0C"), value=Decimal("3")*Decimal("300.15")-Decimal("273.15"), error=error)
          # Value 2: Float
          assert isinstance( ( Measure(value=26.85,unit=Unit("\u00B0C"))  * "3" ), Measure )
          error = measure._sqrt_( (3**2 * 0.005**2 + 300**2 * 0**2) )
          assert math.isclose( ( Measure(value=26.85,unit=Unit("\u00B0C"))  * "3" ).value   , 3 * 300 - 273.15 )
          assert math.isclose( ( Measure(value=26.85,unit=Unit("\u00B0C"))  * "3" ).error   , error )
          assert ( Measure(value=26.85,unit=Unit("\u00B0C"))  * "3" ).implied == True
          assert ( Measure(value=26.85,unit=Unit("\u00B0C"))  * "3" ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=26.85,unit=Unit("\u00B0C"))  * "3" ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=26.85,unit=Unit("\u00B0C"))  * "3" ) == Measure(units=Unit("\u00B0C"), value= 3 * 300 - 273.15, error=error)
          # Value 3: Decimal
          assert isinstance( ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  * "3" ), Measure )
          error = measure._sqrt_( (Decimal("3")**2 * Decimal("0.005")**2 + Decimal("300")**2 * Decimal("0")**2) )
          assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  * "3" ).value   == Decimal("3")*Decimal("300") -Decimal("273.15")
          assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  * "3" ).error   == error
          assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  * "3" ).implied == True
          assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  * "3" ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  * "3" ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=Decimal("26.85"),unit=Unit("\u00B0C"))  * "3" ) == Measure(units=Unit("\u00B0C"), value=Decimal("3") * Decimal("300")-Decimal("273.15"), error=error)
          # Value 4: Negative
          assert isinstance( ( Measure(value=-27,unit=Unit("\u00B0C"))  * "3" ), Measure )
          error = measure._sqrt_( (Decimal("3")**2 * Decimal("0.5")**2 + Decimal("246.15")**2 * Decimal("0")**2) )
          assert ( Measure(value=-27,unit=Unit("\u00B0C"))  * "3" ).value   == Decimal("3")*Decimal("246.15")-Decimal("273.15")
          assert ( Measure(value=-27,unit=Unit("\u00B0C"))  * "3" ).error   == error
          assert ( Measure(value=-27,unit=Unit("\u00B0C"))  * "3" ).implied == True
          assert ( Measure(value=-27,unit=Unit("\u00B0C"))  * "3" ).units.symbols   == Unit("\u00B0C").symbols
          assert ( Measure(value=-27,unit=Unit("\u00B0C"))  * "3" ).units.magnitude == Unit("\u00B0C").magnitude
          assert ( Measure(value=-27,unit=Unit("\u00B0C"))  * "3" ) == Measure(units=Unit("\u00B0C"), value= Decimal("3")*Decimal("246.15")-Decimal("273.15"), error=error)
        # Preserve Inputs
        if(True):
          a = Measure(value=4,unit=Unit("cm"))
          b = Decimal("3")
          c = a*b
          c = None
          assert a == Measure(value=4,unit=Unit("cm"))
          assert b == Decimal("3")
    # Str Decimal * Measure (Explicit Error)
    if(True):
      # Decimal * Measure Unitless
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          assert isinstance( ( "3" * Measure(value=3,error=2)  ), Measure )
          error = measure._sqrt_( (Decimal(3)**2 * Decimal("0")**2 + Decimal(3)**2 * Decimal(2)**2) )
          assert ( "3" * Measure(value=3,error=2)  ).value   == 9
          assert ( "3" * Measure(value=3,error=2)  ).error   == error
          assert ( "3" * Measure(value=3,error=2)  ).implied == False
          assert ( "3" * Measure(value=3,error=2)  ).units.symbols   == Unit().symbols
          assert ( "3" * Measure(value=3,error=2)  ).units.magnitude == Unit().magnitude
          assert ( "3" * Measure(value=3,error=2)  ) == Measure(units=Unit(), value= 9, error=error)
          # Value 2: Float
          assert isinstance( ( "3" * Measure(value=0.3,error=0.2) ), Measure )
          error = measure._sqrt_( (3**2 * 0.2**2 + 0.3**2 * 0**2) )
          assert math.isclose( ( "3" * Measure(value=0.3,error=0.2)  ).value , 0.3*3 )
          assert math.isclose( ( "3" * Measure(value=0.3,error=0.2)  ).error , error   )
          assert ( "3" * Measure(value=0.3,error=0.2)  ).implied == False
          assert ( "3" * Measure(value=0.3,error=0.2)  ).units.symbols   == Unit().symbols
          assert ( "3" * Measure(value=0.3,error=0.2)  ).units.magnitude == Unit().magnitude
          assert ( "3" * Measure(value=0.3,error=0.2)  ) == Measure(units=Unit(), value= 0.3*3, error=error)
          # Value 3: Decimal
          assert isinstance( ( "3" * Measure(value=Decimal("40"),error=Decimal("20"))  ), Measure )
          error = measure._sqrt_( ( Decimal("40")**2 * Decimal("0")**2 + Decimal("3")**2 * Decimal("20")**2) )
          assert ( "3" * Measure(value=Decimal("40"),error=Decimal("20"))  ).value   == Decimal("40")*Decimal("3")
          assert ( "3" * Measure(value=Decimal("40"),error=Decimal("20"))  ).error   == error
          assert ( "3" * Measure(value=Decimal("40"),error=Decimal("20"))  ).implied == False
          assert ( "3" * Measure(value=Decimal("40"),error=Decimal("20"))  ).units.symbols   == Unit().symbols
          assert ( "3" * Measure(value=Decimal("40"),error=Decimal("20"))  ).units.magnitude == Unit().magnitude
          assert ( "3" * Measure(value=Decimal("40"),error=Decimal("20"))  ) == Measure(units=Unit(), value= Decimal("40")*Decimal("3"), error=error)
          # Value 4: Negative
          assert isinstance( ( "3" * Measure(value=-3,error=2)  ), Measure )
          error = measure._sqrt_( (Decimal(3)**2 * Decimal("0")**2 + Decimal("3")**2 * Decimal(2)**2) )
          assert ( "3" * Measure(value=-3,error=2)  ).value   == -3*3
          assert ( "3" * Measure(value=-3,error=2)  ).error   == error
          assert ( "3" * Measure(value=-3,error=2)  ).implied == False
          assert ( "3" * Measure(value=-3,error=2)  ).units.symbols   == Unit().symbols
          assert ( "3" * Measure(value=-3,error=2)  ).units.magnitude == Unit().magnitude
          assert ( "3" * Measure(value=-3,error=2)  ) == Measure(units=Unit(), value=-3*3, error=error)
        # Preserve Inputs
        if(True):
          a = "3"
          b = Measure(value=3,error=2) 
          c = a*b
          c = None
          assert a == "3"
          assert b == Measure(value=3,error=2) 
      # Decimal * Measure Units 
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          assert isinstance( ("3" * Measure(value=4,error=2,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0")**2 + Decimal(3)**2 * Decimal(2)**2) )
          assert ( "3" * Measure(value=4,error=2,unit=Unit("cm"))  ).value   == 4*3
          assert ( "3" * Measure(value=4,error=2,unit=Unit("cm"))  ).error   == error
          assert ( "3" * Measure(value=4,error=2,unit=Unit("cm"))  ).implied == False
          assert ( "3" * Measure(value=4,error=2,unit=Unit("cm"))  ).units.symbols   == Unit("cm").symbols
          assert ( "3" * Measure(value=4,error=2,unit=Unit("cm"))  ).units.magnitude == Unit("cm").magnitude
          assert ( "3" * Measure(value=4,error=2,unit=Unit("cm"))  ) == Measure(units=Unit("cm"), value= 4*3, error=error)
          # Value 2: Float
          assert isinstance( ("3" * Measure(value=0.4,error=0.2,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (0.4**2 * 0**2 + 3**2 * 0.2**2) )
          assert math.isclose( ( "3" * Measure(value=0.4,error=0.2,unit=Unit("cm"))  ).value , 0.4*3 )
          assert math.isclose( ( "3" * Measure(value=0.4,error=0.2,unit=Unit("cm"))  ).error , error   )
          assert ( "3" * Measure(value=0.4,error=0.2,unit=Unit("cm"))  ).implied == False
          assert ( "3" * Measure(value=0.4,error=0.2,unit=Unit("cm"))  ).units.symbols   == Unit("cm").symbols
          assert ( "3" * Measure(value=0.4,error=0.2,unit=Unit("cm"))  ).units.magnitude == Unit("cm").magnitude
          assert ( "3" * Measure(value=0.4,error=0.2,unit=Unit("cm"))  ) == Measure(units=Unit("cm"), value= 0.4*3, error=error)
          # Value 3: Decimal
          assert isinstance( ( "3" * Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (Decimal("40")**2 * Decimal("0")**2 + Decimal("3")**2 * Decimal("20")**2) )
          assert ( "3" * Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  ).value   == Decimal("40")*Decimal("3")
          assert ( "3" * Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  ).error   == error
          assert ( "3" * Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  ).implied == False
          assert ( "3" * Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  ).units.symbols   == Unit("cm").symbols
          assert ( "3" * Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  ).units.magnitude == Unit("cm").magnitude
          assert ( "3" * Measure(value=Decimal("40"),error=Decimal("20"),unit=Unit("cm"))  ) == Measure(units=Unit("cm"), value= Decimal("40")*Decimal("3"), error=error)
          # Value 4: Negative
          assert isinstance( ("3" * Measure(value=-4,error=2,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0")**2 + Decimal("3")**2 * Decimal(2)**2) )
          assert ( "3" * Measure(value=-4,error=2,unit=Unit("cm"))  ).value   == -4*Decimal("3")
          assert ( "3" * Measure(value=-4,error=2,unit=Unit("cm"))  ).error   == error
          assert ( "3" * Measure(value=-4,error=2,unit=Unit("cm"))  ).implied == False
          assert ( "3" * Measure(value=-4,error=2,unit=Unit("cm"))  ).units.symbols   == Unit("cm").symbols
          assert ( "3" * Measure(value=-4,error=2,unit=Unit("cm"))  ).units.magnitude == Unit("cm").magnitude
          assert ( "3" * Measure(value=-4,error=2,unit=Unit("cm"))  ) == Measure(units=Unit("cm"), value=-4*Decimal("3"), error=error)
        # Magnitude Units
        if(True):
          # Value 1: Int
          assert isinstance( ( "3" * Measure(value=2,error=1,unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (Decimal("3")**2 * Decimal(5)**2 + Decimal(10)**2 * Decimal("0")**2) )/Decimal(5)
          assert ( "3" * Measure(value=2,error=1,unit=Unit("5 m^2"))  ).value   == 2*  Decimal("3")
          assert Measure._dec_isclose_( ( "3" * Measure(value=2,error=1,unit=Unit("5 m^2"))  ).error   , error )
          assert ( "3" * Measure(value=2,error=1,unit=Unit("5 m^2"))  ).implied == False
          assert ( "3" * Measure(value=2,error=1,unit=Unit("5 m^2"))  ).units.symbols   == Unit("5 m^2").symbols
          assert ( "3" * Measure(value=2,error=1,unit=Unit("5 m^2"))  ).units.magnitude == Unit("5 m^2").magnitude
          assert ( "3" * Measure(value=2,error=1,unit=Unit("5 m^2"))  ) == Measure(units=Unit("5 m^2"), value=2*  Decimal("3"), error=error)
          # Value 2: Float
          assert isinstance( ( "3" * Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (3**2 * 0.5**2 + 1.0**2 * 0**2) )/5
          assert math.isclose( ( "3" * Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  ).value , 0.2*3   )
          assert math.isclose( ( "3" * Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  ).error , error )
          assert ( "3" * Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  ).implied == False
          assert ( "3" * Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  ).units.symbols   == Unit("5 m^2").symbols
          assert ( "3" * Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  ).units.magnitude == Unit("5 m^2").magnitude
          assert ( "3" * Measure(value=0.2,error=0.1,unit=Unit("5 m^2"))  ) == Measure(units=Unit("5 m^2"), value=0.2*3, error=error)
          # Value 3: Decimal
          assert isinstance( ( "3" * Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (Decimal("3")**2 * Decimal("25")**2 + Decimal("100")**2 * Decimal("0")**2) )/Decimal("5")
          assert ( "3" * Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  ).value   == Decimal("20")*Decimal("3")
          assert Measure._dec_isclose_( ( "3" * Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  ).error   , error )
          assert ( "3" * Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  ).implied == False
          assert ( "3" * Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  ).units.symbols   == Unit("5 m^2").symbols
          assert ( "3" * Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  ).units.magnitude == Unit("5 m^2").magnitude
          assert ( "3" * Measure(value=Decimal("20"),error=Decimal("5"),unit=Unit("5 m^2"))  ) == Measure(units=Unit("5 m^2"), value=Decimal("20")*Decimal("3"), error=error)
          # Value 4: Negative
          assert isinstance( ( "3" * Measure(value=-2,error=1,unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (Decimal("3")**2 * Decimal(5)**2 + Decimal(10)**2 * Decimal("0")**2) )/Decimal(5)
          assert ( "3" * Measure(value=-2,error=1,unit=Unit("5 m^2"))  ).value   == -2*Decimal("3")
          assert Measure._dec_isclose_( ( "3" * Measure(value=-2,error=1,unit=Unit("5 m^2"))  ).error   , error )
          assert ( "3" * Measure(value=-2,error=1,unit=Unit("5 m^2"))  ).implied == False
          assert ( "3" * Measure(value=-2,error=1,unit=Unit("5 m^2"))  ).units.symbols   == Unit("5 m^2").symbols
          assert ( "3" * Measure(value=-2,error=1,unit=Unit("5 m^2"))  ).units.magnitude == Unit("5 m^2").magnitude
          assert ( "3" * Measure(value=-2,error=1,unit=Unit("5 m^2"))  ) == Measure(units=Unit("5 m^2"), value=-2*Decimal("3"), error=error)
        # Convoluted Units
        if(True):
          # Value 1: Int
          assert isinstance( ("3" * Measure(value=27,error=1,unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (Decimal("3")**2 * Decimal("1")**2 + Decimal("300.15")**2 * Decimal("0")**2) )
          assert ("3" * Measure(value=27,error=1,unit=Unit("\u00B0C")) ).value   == Decimal("3")*Decimal("300.15")-Decimal("273.15")
          assert ("3" * Measure(value=27,error=1,unit=Unit("\u00B0C")) ).error   == error
          assert ("3" * Measure(value=27,error=1,unit=Unit("\u00B0C")) ).implied == False
          assert ("3" * Measure(value=27,error=1,unit=Unit("\u00B0C")) ).units.symbols   == Unit("\u00B0C").symbols
          assert ("3" * Measure(value=27,error=1,unit=Unit("\u00B0C")) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ("3" * Measure(value=27,error=1,unit=Unit("\u00B0C")) ) == Measure(units=Unit("\u00B0C"), value=Decimal("3")*Decimal("300.15")-Decimal("273.15"), error=error)
          # Value 2: Float
          assert isinstance( ("3" * Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (3**2 * 0.02**2 + 300**2 * 0**2) )
          assert math.isclose( ("3" * Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).value   , 3 * 300 - 273.15 )
          assert math.isclose( ("3" * Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).error   , error )
          assert ("3" * Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).implied == False
          assert ("3" * Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).units.symbols   == Unit("\u00B0C").symbols
          assert ("3" * Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ("3" * Measure(value=26.85,error=0.02,unit=Unit("\u00B0C")) ) == Measure(units=Unit("\u00B0C"), value= 3 * 300 - 273.15, error=error)
          # Value 3: Decimal
          assert isinstance( ("3" * Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (Decimal("3")**2 * Decimal("0.02")**2 + Decimal("300")**2 * Decimal("0")**2) )
          assert ("3" * Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).value   == Decimal("3")* Decimal("300") -Decimal("273.15")
          assert ("3" * Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).error   == error
          assert ("3" * Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).implied == False
          assert ("3" * Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).units.symbols   == Unit("\u00B0C").symbols
          assert ("3" * Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ("3" * Measure(value=Decimal("26.85"),error=Decimal("0.02"),unit=Unit("\u00B0C")) ) == Measure(units=Unit("\u00B0C"), value=Decimal("3") * Decimal("300")-Decimal("273.15"), error=error)
          # Value 4: Negative
          assert isinstance( ("3" * Measure(value=-27,error=1,unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (Decimal("3")**2 * Decimal("1")**2 + Decimal("246.15")**2 * Decimal("0")**2) )
          assert ("3" * Measure(value=-27,error=1,unit=Unit("\u00B0C")) ).value   == Decimal("3")*Decimal("246.15")-Decimal("273.15")
          assert ("3" * Measure(value=-27,error=1,unit=Unit("\u00B0C")) ).error   == error
          assert ("3" * Measure(value=-27,error=1,unit=Unit("\u00B0C")) ).implied == False
          assert ("3" * Measure(value=-27,error=1,unit=Unit("\u00B0C")) ).units.symbols   == Unit("\u00B0C").symbols
          assert ("3" * Measure(value=-27,error=1,unit=Unit("\u00B0C")) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ("3" * Measure(value=-27,error=1,unit=Unit("\u00B0C")) ) == Measure(units=Unit("\u00B0C"), value= Decimal("3")*Decimal("246.15")-Decimal("273.15"), error=error)
        # Preserve Inputs
        if(True):
          a = "3"
          b = Measure(value=4,error=2,unit=Unit("cm"))
          c = a*b
          c = None
          assert a == "3"
          assert b == Measure(value=4,error=2,unit=Unit("cm"))
    # Str Decimal * Measure (Implicit Error)
    if(True):
      # Decimal * Measure Unitless
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          assert isinstance( ( "3" * Measure(value=3)  ), Measure )
          error = measure._sqrt_( (Decimal(3)**2 * Decimal("0")**2 + Decimal(3)**2 * Decimal("0.5")**2) )
          assert ( "3" * Measure(value=3)  ).value   == 9
          assert ( "3" * Measure(value=3)  ).error   == error
          assert ( "3" * Measure(value=3)  ).implied == True
          assert ( "3" * Measure(value=3)  ).units.symbols   == Unit().symbols
          assert ( "3" * Measure(value=3)  ).units.magnitude == Unit().magnitude
          assert ( "3" * Measure(value=3)  ) == Measure(units=Unit(), value= 9, error=error)
          # Value 2: Float
          assert isinstance( ( "3" * Measure(value=0.3) ), Measure )
          error = measure._sqrt_( (3**2 * 0.05**2 + 0.3**2 * 0**2) )
          assert math.isclose( ( "3" * Measure(value=0.3)  ).value , 0.3*3 )
          assert math.isclose( ( "3" * Measure(value=0.3)  ).error , error   )
          assert ( "3" * Measure(value=0.3)  ).implied == True
          assert ( "3" * Measure(value=0.3)  ).units.symbols   == Unit().symbols
          assert ( "3" * Measure(value=0.3)  ).units.magnitude == Unit().magnitude
          assert ( "3" * Measure(value=0.3)  ) == Measure(units=Unit(), value= 0.3*3, error=error)
          # Value 3: Decimal
          assert isinstance( ( "3" * Measure(value=Decimal("40"))  ), Measure )
          error = measure._sqrt_( ( Decimal("40")**2 * Decimal("0")**2 + Decimal("3")**2 * Decimal("5")**2) )
          assert ( "3" * Measure(value=Decimal("40"))  ).value   == Decimal("40")*Decimal("3")
          assert ( "3" * Measure(value=Decimal("40"))  ).error   == error
          assert ( "3" * Measure(value=Decimal("40"))  ).implied == True
          assert ( "3" * Measure(value=Decimal("40"))  ).units.symbols   == Unit().symbols
          assert ( "3" * Measure(value=Decimal("40"))  ).units.magnitude == Unit().magnitude
          assert ( "3" * Measure(value=Decimal("40"))  ) == Measure(units=Unit(), value= Decimal("40")*Decimal("3"), error=error)
          # Value 4: Negative
          assert isinstance( ( "3" * Measure(value=-3)  ), Measure )
          error = measure._sqrt_( (Decimal(3)**2 * Decimal("0")**2 + Decimal("3")**2 * Decimal("0.5")**2) )
          assert ( "3" * Measure(value=-3)  ).value   == -3*3
          assert ( "3" * Measure(value=-3)  ).error   == error
          assert ( "3" * Measure(value=-3)  ).implied == True
          assert ( "3" * Measure(value=-3)  ).units.symbols   == Unit().symbols
          assert ( "3" * Measure(value=-3)  ).units.magnitude == Unit().magnitude
          assert ( "3" * Measure(value=-3)  ) == Measure(units=Unit(), value=-3*3, error=error)
        # Preserve Inputs
        if(True):
          a = "3"
          b = Measure(value=3) 
          c = a*b
          c = None
          assert a =="3" 
          assert b == Measure(value=3) 
      # Decimal * Measure Units
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          assert isinstance( ("3" * Measure(value=4,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0")**2 + Decimal(3)**2 * Decimal("0.5")**2) )
          assert ( "3" * Measure(value=4,unit=Unit("cm"))  ).value   == 4*3
          assert ( "3" * Measure(value=4,unit=Unit("cm"))  ).error   == error
          assert ( "3" * Measure(value=4,unit=Unit("cm"))  ).implied == True
          assert ( "3" * Measure(value=4,unit=Unit("cm"))  ).units.symbols   == Unit("cm").symbols
          assert ( "3" * Measure(value=4,unit=Unit("cm"))  ).units.magnitude == Unit("cm").magnitude
          assert ( "3" * Measure(value=4,unit=Unit("cm"))  ) == Measure(units=Unit("cm"), value= 4*3, error=error)
          # Value 2: Float
          assert isinstance( ("3" * Measure(value=0.4,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (0.4**2 * 0**2 + 3**2 * 0.05**2) )
          assert math.isclose( ( "3" * Measure(value=0.4,unit=Unit("cm"))  ).value , 0.4*3 )
          assert math.isclose( ( "3" * Measure(value=0.4,unit=Unit("cm"))  ).error , error   )
          assert ( "3" * Measure(value=0.4,unit=Unit("cm"))  ).implied == True
          assert ( "3" * Measure(value=0.4,unit=Unit("cm"))  ).units.symbols   == Unit("cm").symbols
          assert ( "3" * Measure(value=0.4,unit=Unit("cm"))  ).units.magnitude == Unit("cm").magnitude
          assert ( "3" * Measure(value=0.4,unit=Unit("cm"))  ) == Measure(units=Unit("cm"), value= 0.4*3, error=error)
          # Value 3: Decimal
          assert isinstance( ( "3" * Measure(value=Decimal("40"),unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (Decimal("40")**2 * Decimal("0")**2 + Decimal("3")**2 * Decimal("5")**2) )
          assert ( "3" * Measure(value=Decimal("40"),unit=Unit("cm"))  ).value   == Decimal("40")*Decimal("3")
          assert ( "3" * Measure(value=Decimal("40"),unit=Unit("cm"))  ).error   == error
          assert ( "3" * Measure(value=Decimal("40"),unit=Unit("cm"))  ).implied == True
          assert ( "3" * Measure(value=Decimal("40"),unit=Unit("cm"))  ).units.symbols   == Unit("cm").symbols
          assert ( "3" * Measure(value=Decimal("40"),unit=Unit("cm"))  ).units.magnitude == Unit("cm").magnitude
          assert ( "3" * Measure(value=Decimal("40"),unit=Unit("cm"))  ) == Measure(units=Unit("cm"), value= Decimal("40")*Decimal("3"), error=error)
          # Value 4: Negative
          assert isinstance( ("3" * Measure(value=-4,unit=Unit("cm"))  ), Measure )
          error = measure._sqrt_( (Decimal(4)**2 * Decimal("0")**2 + Decimal("3")**2 * Decimal("0.5")**2) )
          assert ( "3" * Measure(value=-4,unit=Unit("cm"))  ).value   == -4*Decimal("3")
          assert ( "3" * Measure(value=-4,unit=Unit("cm"))  ).error   == error
          assert ( "3" * Measure(value=-4,unit=Unit("cm"))  ).implied == True
          assert ( "3" * Measure(value=-4,unit=Unit("cm"))  ).units.symbols   == Unit("cm").symbols
          assert ( "3" * Measure(value=-4,unit=Unit("cm"))  ).units.magnitude == Unit("cm").magnitude
          assert ( "3" * Measure(value=-4,unit=Unit("cm"))  ) == Measure(units=Unit("cm"), value=-4*Decimal("3"), error=error)
        # Magnitude Units
        if(True):
          # Value 1: Int
          assert isinstance( ( "3" * Measure(value=2,unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (Decimal("3")**2 * Decimal("2.5")**2 + Decimal(10)**2 * Decimal("0")**2) )/Decimal(5)
          assert ( "3" * Measure(value=2,unit=Unit("5 m^2"))  ).value   == 2*  Decimal("3")
          assert Measure._dec_isclose_( ( "3" * Measure(value=2,unit=Unit("5 m^2"))  ).error   , error )
          assert ( "3" * Measure(value=2,unit=Unit("5 m^2"))  ).implied == True
          assert ( "3" * Measure(value=2,unit=Unit("5 m^2"))  ).units.symbols   == Unit("5 m^2").symbols
          assert ( "3" * Measure(value=2,unit=Unit("5 m^2"))  ).units.magnitude == Unit("5 m^2").magnitude
          assert ( "3" * Measure(value=2,unit=Unit("5 m^2"))  ) == Measure(units=Unit("5 m^2"), value=2*  Decimal("3"), error=error)
          # Value 2: Float
          assert isinstance( ( "3" * Measure(value=0.2,unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (3**2 * 0.25**2 + 1.0**2 * 0**2) )/5
          assert math.isclose( ( "3" * Measure(value=0.2,unit=Unit("5 m^2"))  ).value , 0.2*3   )
          assert math.isclose( ( "3" * Measure(value=0.2,unit=Unit("5 m^2"))  ).error , error )
          assert ( "3" * Measure(value=0.2,unit=Unit("5 m^2"))  ).implied == True
          assert ( "3" * Measure(value=0.2,unit=Unit("5 m^2"))  ).units.symbols   == Unit("5 m^2").symbols
          assert ( "3" * Measure(value=0.2,unit=Unit("5 m^2"))  ).units.magnitude == Unit("5 m^2").magnitude
          assert ( "3" * Measure(value=0.2,unit=Unit("5 m^2"))  ) == Measure(units=Unit("5 m^2"), value=0.2*3, error=error)
          # Value 3: Decimal
          assert isinstance( ( "3" * Measure(value=Decimal("20"),unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (Decimal("3")**2 * Decimal("25")**2 + Decimal("100")**2 * Decimal("0")**2) )/Decimal("5")
          assert ( "3" * Measure(value=Decimal("20"),unit=Unit("5 m^2"))  ).value   == Decimal("20")*Decimal("3")
          assert Measure._dec_isclose_( ( "3" * Measure(value=Decimal("20"),unit=Unit("5 m^2"))  ).error   , error )
          assert ( "3" * Measure(value=Decimal("20"),unit=Unit("5 m^2"))  ).implied == True
          assert ( "3" * Measure(value=Decimal("20"),unit=Unit("5 m^2"))  ).units.symbols   == Unit("5 m^2").symbols
          assert ( "3" * Measure(value=Decimal("20"),unit=Unit("5 m^2"))  ).units.magnitude == Unit("5 m^2").magnitude
          assert ( "3" * Measure(value=Decimal("20"),unit=Unit("5 m^2"))  ) == Measure(units=Unit("5 m^2"), value=Decimal("20")*Decimal("3"), error=error)
          # Value 4: Negative
          assert isinstance( ( "3" * Measure(value=-2,unit=Unit("5 m^2"))  ) , Measure )
          error = measure._sqrt_( (Decimal("3")**2 * Decimal("2.5")**2 + Decimal(10)**2 * Decimal("0")**2) )/Decimal(5)
          assert ( "3" * Measure(value=-2,unit=Unit("5 m^2"))  ).value   == -2*Decimal("3")
          assert Measure._dec_isclose_( ( "3" * Measure(value=-2,unit=Unit("5 m^2"))  ).error   , error )
          assert ( "3" * Measure(value=-2,unit=Unit("5 m^2"))  ).implied == True
          assert ( "3" * Measure(value=-2,unit=Unit("5 m^2"))  ).units.symbols   == Unit("5 m^2").symbols
          assert ( "3" * Measure(value=-2,unit=Unit("5 m^2"))  ).units.magnitude == Unit("5 m^2").magnitude
          assert ( "3" * Measure(value=-2,unit=Unit("5 m^2"))  ) == Measure(units=Unit("5 m^2"), value=-2*Decimal("3"), error=error)
        # Convoluted Units
        if(True):
          # Value 1: Int
          assert isinstance( ("3" * Measure(value=27,unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (Decimal("3")**2 * Decimal("0.5")**2 + Decimal("300.15")**2 * Decimal("0")**2) )
          assert ("3" * Measure(value=27,unit=Unit("\u00B0C")) ).value   == Decimal("3")*Decimal("300.15")-Decimal("273.15")
          assert ("3" * Measure(value=27,unit=Unit("\u00B0C")) ).error   == error
          assert ("3" * Measure(value=27,unit=Unit("\u00B0C")) ).implied == True
          assert ("3" * Measure(value=27,unit=Unit("\u00B0C")) ).units.symbols   == Unit("\u00B0C").symbols
          assert ("3" * Measure(value=27,unit=Unit("\u00B0C")) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ("3" * Measure(value=27,unit=Unit("\u00B0C")) ) == Measure(units=Unit("\u00B0C"), value=Decimal("3")*Decimal("300.15")-Decimal("273.15"), error=error)
          # Value 2: Float
          assert isinstance( ("3" * Measure(value=26.85,unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (3**2 * 0.005**2 + 300**2 * 0**2) )
          assert math.isclose( ("3" * Measure(value=26.85,unit=Unit("\u00B0C")) ).value   , 3 * 300 - 273.15 )
          assert math.isclose( ("3" * Measure(value=26.85,unit=Unit("\u00B0C")) ).error   , error )
          assert ("3" * Measure(value=26.85,unit=Unit("\u00B0C")) ).implied == True
          assert ("3" * Measure(value=26.85,unit=Unit("\u00B0C")) ).units.symbols   == Unit("\u00B0C").symbols
          assert ("3" * Measure(value=26.85,unit=Unit("\u00B0C")) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ("3" * Measure(value=26.85,unit=Unit("\u00B0C")) ) == Measure(units=Unit("\u00B0C"), value= 3 * 300 - 273.15, error=error)
          # Value 3: Decimal
          assert isinstance( ("3" * Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (Decimal("3")**2 * Decimal("0.005")**2 + Decimal("300")**2 * Decimal("0")**2) )
          assert ("3" * Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).value   == Decimal("3")* Decimal("300") -Decimal("273.15")
          assert ("3" * Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).error   == error
          assert ("3" * Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).implied == True
          assert ("3" * Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).units.symbols   == Unit("\u00B0C").symbols
          assert ("3" * Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ("3" * Measure(value=Decimal("26.85"),unit=Unit("\u00B0C")) ) == Measure(units=Unit("\u00B0C"), value=Decimal("3") * Decimal("300")-Decimal("273.15"), error=error)
          # Value 4: Negative
          assert isinstance( ("3" * Measure(value=-27,unit=Unit("\u00B0C")) ), Measure )
          error = measure._sqrt_( (Decimal("3")**2 * Decimal("0.5")**2 + Decimal("246.15")**2 * Decimal("0")**2) )
          assert ("3" * Measure(value=-27,unit=Unit("\u00B0C")) ).value   == Decimal("3")*Decimal("246.15")-Decimal("273.15")
          assert ("3" * Measure(value=-27,unit=Unit("\u00B0C")) ).error   == error
          assert ("3" * Measure(value=-27,unit=Unit("\u00B0C")) ).implied == True
          assert ("3" * Measure(value=-27,unit=Unit("\u00B0C")) ).units.symbols   == Unit("\u00B0C").symbols
          assert ("3" * Measure(value=-27,unit=Unit("\u00B0C")) ).units.magnitude == Unit("\u00B0C").magnitude
          assert ("3" * Measure(value=-27,unit=Unit("\u00B0C")) ) == Measure(units=Unit("\u00B0C"), value= Decimal("3")*Decimal("246.15")-Decimal("273.15"), error=error)
        # Preserve Inputs
        if(True):
          a ="3" 
          b = Measure(value=4,unit=Unit("cm"))
          c = a*b
          c = None
          assert a =="3" 
          assert b == Measure(value=4,unit=Unit("cm"))
    
    #
  
class TestMeasureOperatorsDiv:
  # Error Formula
  # sig**2 = d/dx(x/y)**2 dx**2 + d/dy(x/y)**2 dy **2
  # sig**2 = (1/y)**2 dx**2 +  (-x / y**-2 )**2 dy **2
  # 
  # sig = measure._sqrt_( (1/y)**2 * dx**2 + (-1* y**-2 *x)**2 * dy**2)
  
  def test_measure_measure_div(self):
    
    def meas_meas_div(
        x=None,dx=None,xu=None, 
        y=None,dy=None,yu=None, 
        u=None,du=None,mu=None,
        v=None,dv=None,mv=None,
        value = None, error=None, unit=None,
        implied=None):
      log.warning(f"x={x} , dx={dx} , xu={xu} , y={y} , dy={dy} , yu={yu}")
      floats = all([isinstance(i,float) or i==None for i in [x,dx,y,dy]])
      
      if(floats):
        # Context Settings
        if( u==None):  u = float( x)           # If  x==None, give value
        if(du==None): du = float(dx)           # If dx==None, give value
        if(mu==None): mu = float(xu.magnitude) # If xu==None, give value
        
        if( v==None):  v = float( y)           # If  y==None, give value
        if(dv==None): dv = float(dy)           # If dy==None, give value
        if(mv==None): mv = float(yu.magnitude) # If yu==None, give value
        
        # Standard Div Values
        if(value == None): value = u/v
        if(unit  == None): unit  = xu/yu
        n  = float( (xu/yu).magnitude )
        if(error == None):  error = measure._sqrt_( (1/(v*mv))**2 * (du*mu)**2 + (-1 * (v*mv) **-2 * (u*mu) )**2 * (dv*mv) **2) / n
        # Standard Div Assertions
        assert isinstance( ( Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)  ), Measure )
        assert math.isclose( (  Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)  ).value , value )
        assert math.isclose( (  Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)  ).error , error )
        assert (  Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)  ).implied == implied
        assert (  Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)  ).units.symbols   == unit.symbols
        assert (  Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)  ).units.magnitude == unit.magnitude
        assert (  Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)  ) == Measure(units=unit, value= value, error=error)
      else:
        # Context Settings
        if( u==None):  u = Decimal( x)  # If  x==None, give value
        if(du==None): du = Decimal(dx)  # If dx==None, give value
        if(mu==None): mu = xu.magnitude # If xu==None, give value
        
        if( v==None):  v = Decimal( y)  # If  y==None, give value
        if(dv==None): dv = Decimal(dy)  # If dy==None, give value
        if(mv==None): mv = yu.magnitude # If yu==None, give value
        
        # Standard Div Values
        if(value == None): value = u/v
        if(unit  == None): unit  = xu/yu
        n  = (xu/yu).magnitude
        if(error == None): error = measure._sqrt_( (1/(v*mv))**2 * (du*mu)**2 + (-1 * (v*mv) **-2 * (u*mu) )**2 * (dv*mv) **2) / n
        # Standard Div Assertions
        assert isinstance( ( Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)  ), Measure )
        assert Measure._dec_isclose_( (  Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)  ).value , value )
        assert Measure._dec_isclose_( (  Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)  ).error , error )
        assert (  Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)  ).implied == implied
        assert (  Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)  ).units.symbols   == unit.symbols
        assert (  Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)  ).units.magnitude == unit.magnitude
        assert (  Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)  ) == Measure(units=unit, value= value, error=error)
    
    # Measure (Explicit Error) / Measure (Explicit Error) = Measure (Explicit Error)
    if(True):
      # Unitless / Unitless
      if(True):
        # Value 1: Int
        meas_meas_div(
          x=4     , dx=2              , xu=Unit(), 
          y=3     , dy=1              , yu=Unit(), 
          u=None  , du=None           , mu=None,
          v=None  , dv=None           , mv=None,
          implied=False)
        # Value 2: Float
        meas_meas_div(
          x=0.4   , dx=0.2            , xu=Unit(), 
          y=0.3   , dy=0.1            , yu=Unit(), 
          u=None  , du=None           , mu=None,
          v=None  , dv=None           , mv=None,
          implied=False)
        # Value 3: Decimal
        meas_meas_div(
          x=Decimal("40") , dx=Decimal("20")  , xu=Unit(), 
          y=Decimal("30") , dy=Decimal("10")  , yu=Unit(), 
          u=None          , du=None           , mu=None,
          v=None          , dv=None           , mv=None,
          implied=False)
        # Value 4: Negative
        meas_meas_div(
          x=-4    , dx=2              , xu=Unit(), 
          y=-3    , dy=1              , yu=Unit(),
          u=None  , du=None           , mu=None,
          v=None  , dv=None           , mv=None,
          implied=False)
        # Value 5: Zero
        if(True):
          # Int
          with pytest.raises(Exception):
            # Context Values
            x,dx,xu = 4,2,Unit()
            y,dy,yu = 0,1,Unit()
            # Error Out
            Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)
          # Float
          with pytest.raises(Exception):
            # Context Values
            x,dx,xu = 0.4,0.2,Unit()
            y,dy,yu = 0.0,0.1,Unit()
            # Error Out
            Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)
          # Decimal 
          with pytest.raises(Exception):
            # Context Values
            x,dx,xu = Decimal("0.4"),Decimal("0.2"),Unit()
            y,dy,yu = Decimal("0.0"),Decimal("0.1"),Unit()
            # Error Out
            Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)
        # Preserve Inputs
        if(True):
          a = Measure(value=4,error=2) 
          b = Measure(value=3,error=2)
          c = a/b
          c = None
          assert a == Measure(value=4,error=2) 
          assert b == Measure(value=3,error=2)
      # Unitless / Unit
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          meas_meas_div(
            x=4     , dx=2              , xu=Unit(), 
            y=3     , dy=1              , yu=Unit("cm"), 
            u=None  , du=None           , mu=None,
            v=None  , dv=None           , mv=None,
            implied=False)
          # Value 2: Float
          meas_meas_div(
            x=0.4   , dx=0.2            , xu=Unit(), 
            y=0.3   , dy=0.1            , yu=Unit("cm"), 
            u=None  , du=None           , mu=None,
            v=None  , dv=None           , mv=None,
            implied=False)
          # Value 3: Decimal
          meas_meas_div(
            x=Decimal("40") , dx=Decimal("20")  , xu=Unit(), 
            y=Decimal("30") , dy=Decimal("10")  , yu=Unit("cm"), 
            u=None          , du=None           , mu=None,
            v=None          , dv=None           , mv=None,
            implied=False)
          # Value 4: Negative
          meas_meas_div(
            x=-4    , dx=2              , xu=Unit(), 
            y=-3    , dy=1              , yu=Unit("cm"), 
            u=None  , du=None           , mu=None,
            v=None  , dv=None           , mv=None,
            implied=False)
          # Value 5: Zero
          if(True):
            # Int
            with pytest.raises(Exception):
              # Context Values
              x,dx,xu = 4,2,Unit()
              y,dy,yu = 0,1,Unit("cm")
              # Error Out
              Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)
            # Float
            with pytest.raises(Exception):
              # Context Values
              x,dx,xu = 0.4,0.2,Unit()
              y,dy,yu = 0.0,0.1,Unit("cm")
              # Error Out
              Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)
            # Decimal 
            with pytest.raises(Exception):
              # Context Values
              x,dx,xu = Decimal("0.4"),Decimal("0.2"),Unit()
              y,dy,yu = Decimal("0.0"),Decimal("0.1"),Unit("cm")
              # Error Out
              Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)
        # Magnitude Units
        if(True):
          # Value 1: Int
          meas_meas_div(
            x=4     , dx=2              , xu=Unit(), 
            y=3     , dy=1              , yu=Unit("5 m^2"), 
            u=None  , du=None           , mu=None,
            v=None  , dv=None           , mv=None,
            implied=False)
          # Value 2: Float
          meas_meas_div(
            x=0.4   , dx=0.2            , xu=Unit(), 
            y=0.3   , dy=0.1            , yu=Unit("5 m^2"), 
            u=None  , du=None           , mu=None,
            v=None  , dv=None           , mv=None,
            implied=False)
          # Value 3: Decimal
          meas_meas_div(
            x=Decimal("40") , dx=Decimal("20")  , xu=Unit(), 
            y=Decimal("30") , dy=Decimal("10")  , yu=Unit("5 m^2"), 
            u=None          , du=None           , mu=None,
            v=None          , dv=None           , mv=None,
            implied=False)
          # Value 4: Negative
          meas_meas_div(
            x=-4    , dx=2              , xu=Unit(), 
            y=-3    , dy=1              , yu=Unit("5 m^2"), 
            u=None  , du=None           , mu=None,
            v=None  , dv=None           , mv=None,
            implied=False)
          # Value 5: Zero
          if(True):
            # Int
            with pytest.raises(Exception):
              # Context Values
              x,dx,xu = 4,2,Unit()
              y,dy,yu = 0,1,Unit("5 m^2")
              # Error Out
              Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)
            # Float
            with pytest.raises(Exception):
              # Context Values
              x,dx,xu = 0.4,0.2,Unit()
              y,dy,yu = 0.0,0.1,Unit("5 m^2")
              # Error Out
              Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)
            # Decimal 
            with pytest.raises(Exception):
              # Context Values
              x,dx,xu = Decimal("0.4"),Decimal("0.2"),Unit()
              y,dy,yu = Decimal("0.0"),Decimal("0.1"),Unit("5 m^2")
              # Error Out
              Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)
        # Convoluted Units
        if(True):
          # Value 1: Int
          meas_meas_div(
            x=300               , dx=2    , xu=Unit(), 
            y=27                , dy=1    , yu=Unit("\u00B0C"), 
            u=None              , du=None , mu=None,
            v=Decimal("300.15") , dv=None , mv=None,
            implied=False)
          # Value 2: Float
          meas_meas_div(
            x=299.9 , dx=0.02 , xu=Unit(), 
            y=26.85 , dy=0.01 , yu=Unit("\u00B0C"), 
            u=None  , du=None , mu=None,
            v=300.0 , dv=None , mv=None,
            implied=False)
          # Value 3: Decimal
          meas_meas_div(
            x=Decimal("300")    , dx=Decimal("0.02")  , xu=Unit(), 
            y=Decimal("26.85")  , dy=Decimal("0.01")  , yu=Unit("\u00B0C"), 
            u=None              , du=None             , mu=None,
            v=Decimal("300")    , dv=None             , mv=None,
            implied=False)
          # Value 4: Negative
          meas_meas_div(
            x=300               , dx=2    , xu=Unit(), 
            y=-27               , dy=1    , yu=Unit("\u00B0C"), 
            u=None              , du=None , mu=None,
            v=Decimal("246.15") , dv=None , mv=None,
            implied=False)
          # Value 5: Zero
          if(True):
            # Int
            meas_meas_div(
              x=300               , dx=2    , xu=Unit(), 
              y=0                 , dy=1    , yu=Unit("\u00B0C"), 
              u=None              , du=None , mu=None,
              v=Decimal("273.15") , dv=None , mv=None,
              implied=False)
            # Float
            meas_meas_div(
              x=300.0   , dx=0.02 , xu=Unit(), 
              y=0.0     , dy=0.01 , yu=Unit("\u00B0C"), 
              u=None    , du=None , mu=None,
              v=273.15  , dv=None , mv=None,
              implied=False)
            # Decimal
            meas_meas_div(
              x=Decimal("300")    , dx=Decimal("0.02")  , xu=Unit(), 
              y=Decimal("0")      , dy=Decimal("0.01")  , yu=Unit("\u00B0C"), 
              u=None              , du=None             , mu=None,
              v=Decimal("273.15") , dv=None             , mv=None,
              implied=False)
        # Preserve Inputs
        if(True):
          a = Measure(value=4,error=2) 
          b = Measure(value=3,error=2,unit=Unit("cm"))
          c = a/b
          c = None
          assert a == Measure(value=4,error=2) 
          assert b == Measure(value=3,error=2,unit=Unit("cm"))
      # Unit / Unitless
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          meas_meas_div(
            x=4     , dx=2              , xu=Unit("cm"), 
            y=3     , dy=1              , yu=Unit(), 
            u=None  , du=None           , mu=None,
            v=None  , dv=None           , mv=None,
            implied=False)
          # Value 2: Float
          meas_meas_div(
            x=0.4   , dx=0.2            , xu=Unit("cm"), 
            y=0.3   , dy=0.1            , yu=Unit(), 
            u=None  , du=None           , mu=None,
            v=None  , dv=None           , mv=None,
            implied=False)
          # Value 3: Decimal
          meas_meas_div(
            x=Decimal("40") , dx=Decimal("20")  , xu=Unit("cm"), 
            y=Decimal("30") , dy=Decimal("10")  , yu=Unit(), 
            u=None          , du=None           , mu=None,
            v=None          , dv=None           , mv=None,
            implied=False)
          # Value 4: Negative
          meas_meas_div(
            x=-4    , dx=2              , xu=Unit("cm"), 
            y=-3    , dy=1              , yu=Unit(), 
            u=None  , du=None           , mu=None,
            v=None  , dv=None           , mv=None,
            implied=False)
          # Value 5: Zero
          if(True):
            # Int
            with pytest.raises(Exception):
              # Context Values
              x,dx,xu = 4,2,Unit("cm")
              y,dy,yu = 0,1,Unit()
              # Error Out
              Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)
            # Float
            with pytest.raises(Exception):
              # Context Values
              x,dx,xu = 0.4,0.2,Unit("cm")
              y,dy,yu = 0.0,0.1,Unit()
              # Error Out
              Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)
            # Decimal 
            with pytest.raises(Exception):
              # Context Values
              x,dx,xu = Decimal("0.4"),Decimal("0.2"),Unit("cm")
              y,dy,yu = Decimal("0.0"),Decimal("0.1"),Unit()
              # Error Out
              Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)
        # Magnitude Units
        if(True):
          # Value 1: Int
          meas_meas_div(
            x=4     , dx=2              , xu=Unit("5 m^2"), 
            y=3     , dy=1              , yu=Unit(), 
            u=None  , du=None           , mu=None,
            v=None  , dv=None           , mv=None,
            implied=False)
          # Value 2: Float
          meas_meas_div(
            x=0.4   , dx=0.2            , xu=Unit("5 m^2"), 
            y=0.3   , dy=0.1            , yu=Unit(), 
            u=None  , du=None           , mu=None,
            v=None  , dv=None           , mv=None,
            implied=False)
          # Value 3: Decimal
          meas_meas_div(
            x=Decimal("40") , dx=Decimal("20")  , xu=Unit("5 m^2"), 
            y=Decimal("30") , dy=Decimal("10")  , yu=Unit(), 
            u=None          , du=None           , mu=None,
            v=None          , dv=None           , mv=None,
            implied=False)
          # Value 4: Negative
          meas_meas_div(
            x=-4    , dx=2              , xu=Unit("5 m^2"), 
            y=-3    , dy=1              , yu=Unit(), 
            u=None  , du=None           , mu=None,
            v=None  , dv=None           , mv=None,
            implied=False)
          # Value 5: Zero
          if(True):
            # Int
            with pytest.raises(Exception):
              # Context Values
              x,dx,xu = 4,2,Unit("5 m^2")
              y,dy,yu = 0,1,Unit()
              # Error Out
              Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)
            # Float
            with pytest.raises(Exception):
              # Context Values
              x,dx,xu = 0.4,0.2,Unit("5 m^2")
              y,dy,yu = 0.0,0.1,Unit()
              # Error Out
              Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)
            # Decimal 
            with pytest.raises(Exception):
              # Context Values
              x,dx,xu = Decimal("0.4"),Decimal("0.2"),Unit("5 m^2")
              y,dy,yu = Decimal("0.0"),Decimal("0.1"),Unit()
              # Error Out
              Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)
        # Convoluted Units
        if(True):
          # Value 1: Int
          meas_meas_div(
            x=27                , dx=1    , xu=Unit("\u00B0C"), 
            y=300               , dy=2    , yu=Unit(), 
            u=Decimal("300.15") , du=None , mu=None,
            v=None              , dv=None , mv=None,
            value = Decimal("300.15")/Decimal("300") - Decimal("273.15"),
            implied=False)
          # Value 2: Float
          meas_meas_div(
            x=26.85 , dx=0.01 , xu=Unit("\u00B0C"), 
            y=299.9 , dy=0.02 , yu=Unit(), 
            u=300.0 , du=None , mu=None,
            v=None  , dv=None , mv=None,
            value  = 300.0/299.9-273.15,
            implied=False)
          # Value 3: Decimal
          meas_meas_div(
            x=Decimal("26.85")  , dx=Decimal("0.01")  , xu=Unit("\u00B0C"), 
            y=Decimal("300")    , dy=Decimal("0.02")  , yu=Unit(), 
            u=Decimal("300")    , du=None             , mu=None,
            v=None              , dv=None             , mv=None,
            value = 1+Decimal("-273.15"),
            implied=False)
          # Value 4: Negative
          meas_meas_div(
            x=-27               , dx=1    , xu=Unit("\u00B0C"), 
            y=300               , dy=2    , yu=Unit(), 
            u=Decimal("246.15") , du=None , mu=None,
            v=None              , dv=None , mv=None,
            value = Decimal("246.15")/Decimal("300") - Decimal("273.15"),
            implied=False)
          # Value 5: Zero
          if(True):
            # Int
            with pytest.raises(Exception):
              # Context Values
              x,dx,xu = 27,2,Unit("\u00B0C")
              y,dy,yu = 0,1,Unit()
              # Error Out
              Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)
            # Float
            with pytest.raises(Exception):
              # Context Values
              x,dx,xu = 26.15,0.02,Unit("\u00B0C")
              y,dy,yu = 0.0,0.01,Unit()
              # Error Out
              Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)
            # Decimal 
            with pytest.raises(Exception):
              # Context Values
              x,dx,xu = Decimal("26.15"),Decimal("0.02"),Unit("\u00B0C")
              y,dy,yu = Decimal(0),Decimal("0.01"),Unit()
              # Error Out
              Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)
        # Preserve Inputs
        if(True):
          a = Measure(value=4,error=2,unit=Unit("cm")) 
          b = Measure(value=3,error=2)
          c = a/b
          c = None
          assert a == Measure(value=4,error=2,unit=Unit("cm")) 
          assert b == Measure(value=3,error=2)
      # Unit / Unit
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          meas_meas_div(
            x=4     , dx=2              , xu=Unit("s"), 
            y=3     , dy=1              , yu=Unit("cm"), 
            u=None  , du=None           , mu=None,
            v=None  , dv=None           , mv=None,
            implied=False)
          # Value 2: Float
          meas_meas_div(
            x=0.4   , dx=0.2            , xu=Unit("s"), 
            y=0.3   , dy=0.1            , yu=Unit("cm"), 
            u=None  , du=None           , mu=None,
            v=None  , dv=None           , mv=None,
            implied=False)
          # Value 3: Decimal
          meas_meas_div(
            x=Decimal("40") , dx=Decimal("20")  , xu=Unit("s"), 
            y=Decimal("30") , dy=Decimal("10")  , yu=Unit("cm"), 
            u=None          , du=None           , mu=None,
            v=None          , dv=None           , mv=None,
            implied=False)
          # Value 4: Negative
          meas_meas_div(
            x=-4    , dx=2              , xu=Unit("s"), 
            y=-3    , dy=1              , yu=Unit("cm"), 
            u=None  , du=None           , mu=None,
            v=None  , dv=None           , mv=None,
            implied=False)
          # Value 5: Zero
          if(True):
            # Int
            with pytest.raises(Exception):
              # Context Values
              x,dx,xu = 4,2,Unit("s")
              y,dy,yu = 0,1,Unit("cm")
              # Error Out
              Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)
            # Float
            with pytest.raises(Exception):
              # Context Values
              x,dx,xu = 0.4,0.2,Unit("s")
              y,dy,yu = 0.0,0.1,Unit("cm")
              # Error Out
              Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)
            # Decimal 
            with pytest.raises(Exception):
              # Context Values
              x,dx,xu = Decimal("0.4"),Decimal("0.2"),Unit("s")
              y,dy,yu = Decimal("0.0"),Decimal("0.1"),Unit("cm")
              # Error Out
              Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)
        # Magnitude Units
        if(True):
          # Value 1: Int
          meas_meas_div(
            x=4     , dx=2              , xu=Unit("2 s"), 
            y=3     , dy=1              , yu=Unit("5 m^2"), 
            u=None  , du=None           , mu=None,
            v=None  , dv=None           , mv=None,
            implied=False)
          # Value 2: Float
          meas_meas_div(
            x=0.4   , dx=0.2            , xu=Unit("2 s"), 
            y=0.3   , dy=0.1            , yu=Unit("5 m^2"), 
            u=None  , du=None           , mu=None,
            v=None  , dv=None           , mv=None,
            implied=False)
          # Value 3: Decimal
          meas_meas_div(
            x=Decimal("40") , dx=Decimal("20")  , xu=Unit("2 s"), 
            y=Decimal("30") , dy=Decimal("10")  , yu=Unit("5 m^2"), 
            u=None          , du=None           , mu=None,
            v=None          , dv=None           , mv=None,
            implied=False)
          # Value 4: Negative
          meas_meas_div(
            x=-4    , dx=2              , xu=Unit("2 s"), 
            y=-3    , dy=1              , yu=Unit("5 m^2"), 
            u=None  , du=None           , mu=None,
            v=None  , dv=None           , mv=None,
            implied=False)
          # Value 5: Zero
          if(True):
            # Int
            with pytest.raises(Exception):
              # Context Values
              x,dx,xu = 4,2,Unit("2 s")
              y,dy,yu = 0,1,Unit("5 m^2")
              # Error Out
              Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)
            # Float
            with pytest.raises(Exception):
              # Context Values
              x,dx,xu = 0.4,0.2,Unit("2 s")
              y,dy,yu = 0.0,0.1,Unit("5 m^2")
              # Error Out
              Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)
            # Decimal 
            with pytest.raises(Exception):
              # Context Values
              x,dx,xu = Decimal("0.4"),Decimal("0.2"),Unit("2 s")
              y,dy,yu = Decimal("0.0"),Decimal("0.1"),Unit("5 m^2")
              # Error Out
              Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)
        # Convoluted Units
        if(True):
          # Value 1: Int
          meas_meas_div(
            x=300               , dx=2    , xu=Unit("s"), 
            y=27                , dy=1    , yu=Unit("\u00B0C"), 
            u=Decimal("300")    , du=None , mu=None,
            v=Decimal("300.15") , dv=None , mv=None,
            implied=False)
          # Value 2: Float
          meas_meas_div(
            x=300.0 , dx=0.02 , xu=Unit("s"), 
            y=26.85 , dy=0.01 , yu=Unit("\u00B0C"), 
            u=300.0 , du=None , mu=None,
            v=300.0 , dv=None , mv=None,
            implied=False)
          # Value 3: Decimal
          meas_meas_div(
            x=Decimal("300")    , dx=Decimal("0.02")  , xu=Unit("s"), 
            y=Decimal("26.85")  , dy=Decimal("0.01")  , yu=Unit("\u00B0C"), 
            u=Decimal("300")    , du=None             , mu=None,
            v=Decimal("300")    , dv=None             , mv=None,
            implied=False)
          # Value 4: Negative
          meas_meas_div(
            x=-31               , dx=2    , xu=Unit("m"), 
            y=-27               , dy=1    , yu=Unit("\u00B0C"), 
            u=Decimal("-31")    , du=None , mu=None,
            v=Decimal("246.15") , dv=None , mv=None,
            implied=False)
          # Value 5: Zero
          if(True):
            # Int
            meas_meas_div(
              x=27                , dx=2    , xu=Unit("\u00B0C"), 
              y=0                 , dy=1    , yu=Unit("\u00B0C"), 
              u=Decimal("300.15") , du=None , mu=None,
              v=Decimal("273.15") , dv=None , mv=None,
              implied=False)
            # Float
            meas_meas_div(
              x=26.85   , dx=0.02 , xu=Unit("\u00B0C"), 
              y= 0.0    , dy=0.01 , yu=Unit("\u00B0C"), 
              u=300.0   , du=None , mu=None,
              v=273.15  , dv=None , mv=None,
              implied=False)
            # Decimal
            meas_meas_div(
              x=Decimal("26.85")  , dx=Decimal("0.02"), xu=Unit("\u00B0C"), 
              y=Decimal("0")      , dy=Decimal("0.01"), yu=Unit("\u00B0C"), 
              u=Decimal("300")    , du=None           , mu=None,
              v=Decimal("273.15") , dv=None           , mv=None,
              implied=False)
        # Canceling Units
        if(True):
          # Value 1: Int
          meas_meas_div(
            x=4     , dx=2              , xu=Unit("cm"), 
            y=3     , dy=1              , yu=Unit("cm"),
            u=None  , du=None           , mu=None,
            v=None  , dv=None           , mv=None, 
            implied=False)
          # Value 2: Float
          meas_meas_div(
            x=0.4   , dx=0.2            , xu=Unit("cm"), 
            y=0.3   , dy=0.1            , yu=Unit("cm"), 
            u=None  , du=None           , mu=None,
            v=None  , dv=None           , mv=None,
            implied=False)
          # Value 3: Decimal
          meas_meas_div(
            x=Decimal("40") , dx=Decimal("20")  , xu=Unit("cm"), 
            y=Decimal("30") , dy=Decimal("10")  , yu=Unit("cm"), 
            u=None          , du=None           , mu=None,
            v=None          , dv=None           , mv=None,
            implied=False)
          # Value 4: Negative
          meas_meas_div(
            x=-4    , dx=2              , xu=Unit("cm"), 
            y=-3    , dy=1              , yu=Unit("cm"), 
            u=None  , du=None           , mu=None,
            v=None  , dv=None           , mv=None,
            implied=False)
          # Value 5: Zero
          if(True):
            # Int
            with pytest.raises(Exception):
              # Context Values
              x,dx,xu = 4,2,Unit("cm")
              y,dy,yu = 0,1,Unit("cm")
              # Error Out
              Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)
            # Float
            with pytest.raises(Exception):
              # Context Values
              x,dx,xu = 0.4,0.2,Unit("cm")
              y,dy,yu = 0.0,0.1,Unit("cm")
              # Error Out
              Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)
            # Decimal 
            with pytest.raises(Exception):
              # Context Values
              x,dx,xu = Decimal("0.4"),Decimal("0.2"),Unit("cm")
              y,dy,yu = Decimal("0.0"),Decimal("0.1"),Unit("cm")
              # Error Out
              Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)
    # Measure (Explicit Error) / Measure (Implicit Error) = Measure (Implicit Error)
    if(True):
      # Unitless / Unitless
      if(True):
        # Value 1: Int
        meas_meas_div(
          x=4    , dx=2              , xu=Unit(), 
          y=3    , dy=None           , yu=Unit(), 
          u=None , du=None           , mu=None,
          v=None , dv=Decimal('0.5') , mv=None,
          implied=True)
        # Value 2: Float
        meas_meas_div(
          x=0.4  , dx=0.2  , xu=Unit(), 
          y=0.3  , dy=None , yu=Unit(), 
          u=None , du=None , mu=None,
          v=None , dv=0.05 , mv=None,
          implied=True)
        # Value 3: Decimal
        meas_meas_div(
          x=Decimal("40") , dx=Decimal("20")  , xu=Unit(), 
          y=Decimal("30") , dy=None           , yu=Unit(), 
          u=None          , du=None           , mu=None,
          v=None          , dv=Decimal('5')   , mv=None,
          implied=True)
        # Value 4: Negative
        meas_meas_div(
          x=-4            , dx=2              , xu=Unit(), 
          y=-3            , dy=None           , yu=Unit(), 
          u=None          , du=None           , mu=None,
          v=None          , dv=Decimal('0.5') , mv=None,
          implied=True)
        # Value 5: Zero
        if(True):
          # Int
          with pytest.raises(Exception):
            # Context Values
            x,dx,xu = 4,2,Unit()
            y,dy,yu = 0,None,Unit()
            # Error Out
            Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)
          # Float
          with pytest.raises(Exception):
            # Context Values
            x,dx,xu = 0.4,0.2,Unit()
            y,dy,yu = 0.0,None,Unit()
            # Error Out
            Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)
          # Decimal 
          with pytest.raises(Exception):
            # Context Values
            x,dx,xu = Decimal("0.4"),Decimal("0.2"),Unit()
            y,dy,yu = Decimal("0.0"),None,Unit()
            # Error Out
            Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)
        # Preserve Inputs
        if(True):
          a = Measure(value=4,error=2) 
          b = Measure(value=3,error=None)
          c = a/b
          c = None
          assert a == Measure(value=4,error=2) 
          assert b == Measure(value=3,error=None)
      # Unitless / Unit
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          meas_meas_div(
            x=4             , dx=2              , xu=Unit(), 
            y=3             , dy=None           , yu=Unit("cm"), 
            u=None          , du=None           , mu=None,
            v=None          , dv=Decimal('0.5') , mv=None,
            implied=True)
          # Value 2: Float
          meas_meas_div(
            x=0.4           , dx=0.2            , xu=Unit(), 
            y=0.3           , dy=None           , yu=Unit("cm"), 
            u=None          , du=None           , mu=None,
            v=None          , dv=0.05           , mv=None,
            implied=True)
          # Value 3: Decimal
          meas_meas_div(
            x=Decimal("40") , dx=Decimal("20")  , xu=Unit(), 
            y=Decimal("30") , dy=None           , yu=Unit("cm"), 
            u=None          , du=None           , mu=None,
            v=None          , dv=Decimal('5')   , mv=None,
            implied=True)
          # Value 4: Negative
          meas_meas_div(
            x=-4            , dx=2              , xu=Unit(), 
            y=-3            , dy=None           , yu=Unit("cm"), 
            u=None          , du=None           , mu=None,
            v=None          , dv=Decimal('0.5') , mv=None,
            implied=True)
          # Value 5: Zero
          if(True):
            # Int
            with pytest.raises(Exception):
              # Context Values
              x,dx,xu = 4,2,Unit()
              y,dy,yu = 0,None,Unit("cm")
              # Error Out
              Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)
            # Float
            with pytest.raises(Exception):
              # Context Values
              x,dx,xu = 0.4,0.2,Unit()
              y,dy,yu = 0.0,None,Unit("cm")
              # Error Out
              Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)
            # Decimal 
            with pytest.raises(Exception):
              # Context Values
              x,dx,xu = Decimal("0.4"),Decimal("0.2"),Unit()
              y,dy,yu = Decimal("0.0"),None,Unit("cm")
              # Error Out
              Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)
        # Magnitude Units
        if(True):
          # Value 1: Int
          meas_meas_div(
            x=4             , dx=2              , xu=Unit(), 
            y=3             , dy=None           , yu=Unit("5 m^2"), 
            u=None          , du=None           , mu=None,
            v=None          , dv=Decimal('0.5') , mv=None,
            implied=True)
          # Value 2: Float
          meas_meas_div(
            x=0.4           , dx=0.2            , xu=Unit(), 
            y=0.3           , dy=None           , yu=Unit("5 m^2"), 
            u=None          , du=None           , mu=None,
            v=None          , dv=0.05           , mv=None,
            implied=True)
          # Value 3: Decimal
          meas_meas_div(
            x=Decimal("40") , dx=Decimal("20")  , xu=Unit(), 
            y=Decimal("30") , dy=None           , yu=Unit("5 m^2"), 
            u=None          , du=None           , mu=None,
            v=None          , dv=Decimal('5')   , mv=None,
            implied=True)
          # Value 4: Negative
          meas_meas_div(
            x=-4            , dx=2              , xu=Unit(), 
            y=-3            , dy=None           , yu=Unit("5 m^2"), 
            u=None          , du=None           , mu=None,
            v=None          , dv=Decimal('0.5')   , mv=None,
            implied=True)
          # Value 5: Zero
          if(True):
            # Int
            with pytest.raises(Exception):
              # Context Values
              x,dx,xu = 4,2,Unit()
              y,dy,yu = 0,None,Unit("5 m^2")
              # Error Out
              Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)
            # Float
            with pytest.raises(Exception):
              # Context Values
              x,dx,xu = 0.4,0.2,Unit()
              y,dy,yu = 0.0,None,Unit("5 m^2")
              # Error Out
              Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)
            # Decimal 
            with pytest.raises(Exception):
              # Context Values
              x,dx,xu = Decimal("0.4"),Decimal("0.2"),Unit()
              y,dy,yu = Decimal("0.0"),None,Unit("5 m^2")
              # Error Out
              Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)
        # Convoluted Units
        if(True):
          # Value 1: Int
          meas_meas_div(
            x=300               , dx=2              , xu=Unit(), 
            y=27                , dy=None           , yu=Unit("\u00B0C"), 
            u=None              , du=None           , mu=None,
            v=Decimal("300.15") , dv=Decimal('0.5') , mv=None,
            implied=True)
          # Value 2: Float
          meas_meas_div(
            x=299.9             , dx=0.02           , xu=Unit(), 
            y=26.85             , dy=None           , yu=Unit("\u00B0C"), 
            u=None              , du=None           , mu=None,
            v=300.0             , dv=0.005          , mv=None,
            implied=True)
          # Value 3: Decimal
          meas_meas_div(
            x=Decimal("300")    , dx=Decimal("0.02")  , xu=Unit(), 
            y=Decimal("26.85")  , dy=None             , yu=Unit("\u00B0C"), 
            u=None              , du=None             , mu=None,
            v=Decimal("300")    , dv=Decimal('0.005') , mv=None,
            implied=True)
          # Value 4: Negative
          meas_meas_div(
            x=300               , dx=2              , xu=Unit(), 
            y=-27               , dy=None           , yu=Unit("\u00B0C"), 
            u=None              , du=None           , mu=None,
            v=Decimal("246.15") , dv=Decimal('0.5') , mv=None,
            implied=True)
          # Value 5: Zero
          if(True):
            # Int
            meas_meas_div(
              x=300               , dx=2              , xu=Unit(), 
              y=0                 , dy=None           , yu=Unit("\u00B0C"), 
              u=None              , du=None           , mu=None,
              v=Decimal("273.15") , dv=Decimal('0.5') , mv=None,
              implied=True)
            # Float
            meas_meas_div(
              x=300.0             , dx=0.02           , xu=Unit(), 
              y=0.0               , dy=None           , yu=Unit("\u00B0C"), 
              u=None              , du=None           , mu=None,
              v=273.15            , dv=0.05            , mv=None,
              implied=True)
            # Decimal
            meas_meas_div(
              x=Decimal("300")    , dx=Decimal("0.02"), xu=Unit(), 
              y=Decimal("0")      , dy=None           , yu=Unit("\u00B0C"), 
              u=None              , du=None           , mu=None,
              v=Decimal("273.15") , dv=Decimal('0.5') , mv=None,
              implied=True)
        # Preserve Inputs
        if(True):
          a = Measure(value=4,error=2) 
          b = Measure(value=3,error=None,unit=Unit("cm"))
          c = a/b
          c = None
          assert a == Measure(value=4,error=2) 
          assert b == Measure(value=3,error=None,unit=Unit("cm"))
      # Unit / Unitless
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          meas_meas_div(
            x=4             , dx=2              , xu=Unit("cm"), 
            y=3             , dy=None           , yu=Unit(), 
            u=None          , du=None           , mu=None,
            v=None          , dv=Decimal('0.5') , mv=None,
            implied=True)
          # Value 2: Float
          meas_meas_div(
            x=0.4           , dx=0.2            , xu=Unit("cm"), 
            y=0.3           , dy=None           , yu=Unit(),
            u=None          , du=None           , mu=None,
            v=None          , dv=0.05           , mv=None,
            implied=True)
          # Value 3: Decimal
          meas_meas_div(
            x=Decimal("40") , dx=Decimal("20")  , xu=Unit("cm"), 
            y=Decimal("30") , dy=None           , yu=Unit(), 
            u=None          , du=None           , mu=None,
            v=None          , dv=Decimal('5')   , mv=None,
            implied=True)
          # Value 4: Negative
          meas_meas_div(
            x=-4            , dx=2              , xu=Unit("cm"), 
            y=-3            , dy=None           , yu=Unit(), 
            u=None          , du=None           , mu=None,
            v=None          , dv=Decimal('0.5') , mv=None,
            implied=True)
          # Value 5: Zero
          if(True):
            # Int
            with pytest.raises(Exception):
              # Context Values
              x,dx,xu = 4,2,Unit("cm")
              y,dy,yu = 0,None,Unit()
              # Error Out
              Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)
            # Float
            with pytest.raises(Exception):
              # Context Values
              x,dx,xu = 0.4,0.2,Unit("cm")
              y,dy,yu = 0.0,None,Unit()
              # Error Out
              Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)
            # Decimal 
            with pytest.raises(Exception):
              # Context Values
              x,dx,xu = Decimal("0.4"),Decimal("0.2"),Unit("cm")
              y,dy,yu = Decimal("0.0"),None,Unit()
              # Error Out
              Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)
        # Magnitude Units
        if(True):
          # Value 1: Int
          meas_meas_div(
            x=4             , dx=2              , xu=Unit("5 m^2"), 
            y=3             , dy=None           , yu=Unit(), 
            u=None          , du=None           , mu=None,
            v=None          , dv=Decimal('0.5') , mv=None,
            implied=True)
          # Value 2: Float
          meas_meas_div(
            x=0.4           , dx=0.2            , xu=Unit("5 m^2"), 
            y=0.3           , dy=None           , yu=Unit(), 
            u=None          , du=None           , mu=None,
            v=None          , dv=0.05           , mv=None,
            implied=True)
          # Value 3: Decimal
          meas_meas_div(
            x=Decimal("40") , dx=Decimal("20")  , xu=Unit("5 m^2"), 
            y=Decimal("30") , dy=None           , yu=Unit(), 
            u=None          , du=None           , mu=None,
            v=None          , dv=Decimal('5')   , mv=None,
            implied=True)
          # Value 4: Negative
          meas_meas_div(
            x=-4            , dx=2              , xu=Unit("5 m^2"), 
            y=-3            , dy=None           , yu=Unit(), 
            u=None          , du=None           , mu=None,
            v=None          , dv=Decimal('0.5') , mv=None,
            implied=True)
          # Value 5: Zero
          if(True):
            # Int
            with pytest.raises(Exception):
              # Context Values
              x,dx,xu = 4,2,Unit("5 m^2")
              y,dy,yu = 0,None,Unit()
              # Error Out
              Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)
            # Float
            with pytest.raises(Exception):
              # Context Values
              x,dx,xu = 0.4,0.2,Unit("5 m^2")
              y,dy,yu = 0.0,None,Unit()
              # Error Out
              Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)
            # Decimal 
            with pytest.raises(Exception):
              # Context Values
              x,dx,xu = Decimal("0.4"),Decimal("0.2"),Unit("5 m^2")
              y,dy,yu = Decimal("0.0"),None,Unit()
              # Error Out
              Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)
        # Convoluted Units
        if(True):
          # Value 1: Int
          meas_meas_div(
            x=27                , dx=1               , xu=Unit("\u00B0C"), 
            y=300               , dy=None            , yu=Unit(), 
            u=Decimal("300.15") , du=None            , mu=None,
            v=None              , dv=Decimal('50')   , mv=None,
            value = Decimal("300.15")/Decimal("300") - Decimal("273.15"),
            implied=True)
          # Value 2: Float
          meas_meas_div(
            x=26.85         , dx=0.01           , xu=Unit("\u00B0C"), 
            y=299.9         , dy=None           , yu=Unit(), 
            u=300.0         , du=None           , mu=None,
            v=None          , dv=0.05           , mv=None,
            value  = 300.0/299.9-273.15,
            implied=True)
          # Value 3: Decimal
          meas_meas_div(
            x=Decimal("26.85"), dx=Decimal("0.01"), xu=Unit("\u00B0C"), 
            y=Decimal("300")  , dy=None           , yu=Unit(), 
            u=Decimal("300")  , du=None           , mu=None,
            v=None            , dv=Decimal('50')  , mv=None,
            value = 1+ Decimal("-273.15"),
            implied=True)
          # Value 4: Negative
          meas_meas_div(
            x=-27               , dx=1              , xu=Unit("\u00B0C"), 
            y=300               , dy=None           , yu=Unit(), 
            u=Decimal("246.15") , du=None           , mu=None,
            v=None              , dv=Decimal('50')  , mv=None,
            value = Decimal("246.15")/Decimal("300") - Decimal("273.15"),
            implied=True)
          # Value 5: Zero
          if(True):
            # Int
            with pytest.raises(Exception):
              # Context Values
              x,dx,xu = 27,2,Unit("\u00B0C")
              y,dy,yu = 0,None,Unit()
              # Error Out
              Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)
            # Float
            with pytest.raises(Exception):
              # Context Values
              x,dx,xu = 26.15,0.02,Unit("\u00B0C")
              y,dy,yu = 0.0,None,Unit()
              # Error Out
              Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)
            # Decimal 
            with pytest.raises(Exception):
              # Context Values
              x,dx,xu = Decimal("26.15"),Decimal("0.02"),Unit("\u00B0C")
              y,dy,yu = Decimal(0),None,Unit()
              # Error Out
              Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)
        # Preserve Inputs
        if(True):
          a = Measure(value=4,error=2,unit=Unit("cm")) 
          b = Measure(value=3,error=None)
          c = a/b
          c = None
          assert a == Measure(value=4,error=2,unit=Unit("cm")) 
          assert b == Measure(value=3,error=None)
      # Unit / Unit
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          meas_meas_div(
            x=4             , dx=2              , xu=Unit("s"), 
            y=3             , dy=None           , yu=Unit("cm"), 
            u=None          , du=None           , mu=None,
            v=None          , dv=Decimal('0.5') , mv=None,
            implied=True)
          # Value 2: Float
          meas_meas_div(
            x=0.4           , dx=0.2            , xu=Unit("s"), 
            y=0.3           , dy=None           , yu=Unit("cm"), 
            u=None          , du=None           , mu=None,
            v=None          , dv=0.05           , mv=None,
            implied=True)
          # Value 3: Decimal
          meas_meas_div(
            x=Decimal("40") , dx=Decimal("20")  , xu=Unit("s"), 
            y=Decimal("30") , dy=None           , yu=Unit("cm"), 
            u=None          , du=None           , mu=None,
            v=None          , dv=Decimal('5')   , mv=None,
            implied=True)
          # Value 4: Negative
          meas_meas_div(
            x=-4            , dx=2              , xu=Unit("s"), 
            y=-3            , dy=None           , yu=Unit("cm"), 
            u=None          , du=None           , mu=None,
            v=None          , dv=Decimal('0.5') , mv=None,
            implied=True)
          # Value 5: Zero
          if(True):
            # Int
            with pytest.raises(Exception):
              # Context Values
              x,dx,xu = 4,2,Unit("s")
              y,dy,yu = 0,None,Unit("cm")
              # Error Out
              Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)
            # Float
            with pytest.raises(Exception):
              # Context Values
              x,dx,xu = 0.4,0.2,Unit("s")
              y,dy,yu = 0.0,None,Unit("cm")
              # Error Out
              Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)
            # Decimal 
            with pytest.raises(Exception):
              # Context Values
              x,dx,xu = Decimal("0.4"),Decimal("0.2"),Unit("s")
              y,dy,yu = Decimal("0.0"),None,Unit("cm")
              # Error Out
              Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)
        # Magnitude Units
        if(True):
          # Value 1: Int
          meas_meas_div(
            x=4             , dx=2              , xu=Unit("2 s"), 
            y=3             , dy=None           , yu=Unit("5 m^2"), 
            u=None          , du=None           , mu=None,
            v=None          , dv=Decimal('0.5') , mv=None,
            implied=True)
          # Value 2: Float
          meas_meas_div(
            x=0.4           , dx=0.2            , xu=Unit("2 s"), 
            y=0.3           , dy=None           , yu=Unit("5 m^2"), 
            u=None          , du=None           , mu=None,
            v=None          , dv=0.05           , mv=None,
            implied=True)
          # Value 3: Decimal
          meas_meas_div(
            x=Decimal("40") , dx=Decimal("20")  , xu=Unit("2 s"), 
            y=Decimal("30") , dy=None           , yu=Unit("5 m^2"), 
            u=None          , du=None           , mu=None,
            v=None          , dv=Decimal('5')   , mv=None,
            implied=True)
          # Value 4: Negative
          meas_meas_div(
            x=-4            , dx=2              , xu=Unit("2 s"), 
            y=-3            , dy=None           , yu=Unit("5 m^2"), 
            u=None          , du=None           , mu=None,
            v=None          , dv=Decimal('0.5') , mv=None,
            implied=True)
          # Value 5: Zero
          if(True):
            # Int
            with pytest.raises(Exception):
              # Context Values
              x,dx,xu = 4,2,Unit("2 s")
              y,dy,yu = 0,None,Unit("5 m^2")
              # Error Out
              Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)
            # Float
            with pytest.raises(Exception):
              # Context Values
              x,dx,xu = 0.4,0.2,Unit("2 s")
              y,dy,yu = 0.0,None,Unit("5 m^2")
              # Error Out
              Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)
            # Decimal 
            with pytest.raises(Exception):
              # Context Values
              x,dx,xu = Decimal("0.4"),Decimal("0.2"),Unit("2 s")
              y,dy,yu = Decimal("0.0"),None,Unit("5 m^2")
              # Error Out
              Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)
        # Convoluted Units
        if(True):
          # Value 1: Int
          meas_meas_div(
            x=300               , dx=2              , xu=Unit("s"), 
            y=27                , dy=None           , yu=Unit("\u00B0C"), 
            u=Decimal("300")    , du=None           , mu=None,
            v=Decimal("300.15") , dv=Decimal('0.5') , mv=None,
            implied=True)
          # Value 2: Float
          meas_meas_div(
            x=300.0 , dx=0.02   , xu=Unit("s"), 
            y=26.85 , dy=None   , yu=Unit("\u00B0C"), 
            u=300.0 , du=None   , mu=None,
            v=300.0 , dv=0.005  , mv=None,
            implied=True)
          # Value 3: Decimal
          meas_meas_div(
            x=Decimal("300")    , dx=Decimal("0.02")  , xu=Unit("s"), 
            y=Decimal("26.85")  , dy=None             , yu=Unit("\u00B0C"), 
            u=Decimal("300")    , du=None             , mu=None,
            v=Decimal("300")    , dv=Decimal('0.005') , mv=None,
            implied=True)
          # Value 4: Negative
          meas_meas_div(
            x=-31               , dx=2              , xu=Unit("m"), 
            y=-27               , dy=None           , yu=Unit("\u00B0C"), 
            u=Decimal("-31")    , du=None           , mu=None,
            v=Decimal("246.15") , dv=Decimal('0.5') , mv=None,
            implied=True)
          # Value 5: Zero
          if(True):
            # Int
            meas_meas_div(
              x=27                , dx=2              , xu=Unit("\u00B0C"), 
              y=0                 , dy=None           , yu=Unit("\u00B0C"), 
              u=Decimal("300.15") , du=None           , mu=None,
              v=Decimal("273.15") , dv=Decimal('0.5') , mv=None,
              implied=True)
            # Float
            meas_meas_div(
              x=26.85   , dx=0.02 , xu=Unit("\u00B0C"), 
              y= 0.0    , dy=None , yu=Unit("\u00B0C"), 
              u=300.0   , du=None , mu=None,
              v=273.15  , dv=0.05 , mv=None,
              implied=True)
            # Decimal
            meas_meas_div(
              x=Decimal("26.85")  , dx=Decimal("0.02")  , xu=Unit("\u00B0C"), 
              y=Decimal("0")      , dy=None             , yu=Unit("\u00B0C"), 
              u=Decimal("300")    , du=None             , mu=None,
              v=Decimal("273.15") , dv=Decimal('0.5')   , mv=None,
              implied=True)
        # Canceling Units
        if(True):
          # Value 1: Int
          meas_meas_div(
            x=4             , dx=2              , xu=Unit("cm"), 
            y=3             , dy=None           , yu=Unit("cm"), 
            u=None          , du=None           , mu=None,
            v=None          , dv=Decimal('0.5') , mv=None,
            implied=True)
          # Value 2: Float
          meas_meas_div(
            x=0.4           , dx=0.2            , xu=Unit("cm"), 
            y=0.3           , dy=None           , yu=Unit("cm"), 
            u=None          , du=None           , mu=None,
            v=None          , dv=0.05           , mv=None,
            implied=True)
          # Value 3: Decimal
          meas_meas_div(
            x=Decimal("40") , dx=Decimal("20")  , xu=Unit("cm"), 
            y=Decimal("30") , dy=None           , yu=Unit("cm"), 
            u=None          , du=None           , mu=None,
            v=None          , dv=Decimal('5')   , mv=None,
            implied=True)
          # Value 4: Negative
          meas_meas_div(
            x=-4            , dx=2              , xu=Unit("cm"), 
            y=-3            , dy=None           , yu=Unit("cm"), 
            u=None          , du=None           , mu=None,
            v=None          , dv=Decimal('0.5') , mv=None,
            implied=True)
          # Value 5: Zero
          if(True):
            # Int
            with pytest.raises(Exception):
              # Context Values
              x,dx,xu = 4,2,Unit("cm")
              y,dy,yu = 0,None,Unit("cm")
              # Error Out
              Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)
            # Float
            with pytest.raises(Exception):
              # Context Values
              x,dx,xu = 0.4,0.2,Unit("cm")
              y,dy,yu = 0.0,None,Unit("cm")
              # Error Out
              Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)
            # Decimal 
            with pytest.raises(Exception):
              # Context Values
              x,dx,xu = Decimal("0.4"),Decimal("0.2"),Unit("cm")
              y,dy,yu = Decimal("0.0"),None,Unit("cm")
              # Error Out
              Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)
    # Measure (Implicit Error) / Measure (Explicit Error) = Measure (Implicit Error)
    if(True):
      # Unitless / Unitless
      if(True):
        # Value 1: Int
        meas_meas_div(
          x=4     , dx=None              , xu=Unit(), 
          y=3     , dy=1              , yu=Unit(), 
          u=None  , du=Decimal("0.5") , mu=None,
          v=None  , dv=None           , mv=None,
          implied=True)
        # Value 2: Float
        meas_meas_div(
          x=0.4   , dx=None           , xu=Unit(), 
          y=0.3   , dy=0.1            , yu=Unit(), 
          u=None  , du=0.05           , mu=None,
          v=None  , dv=None           , mv=None,
          implied=True)
        # Value 3: Decimal
        meas_meas_div(
          x=Decimal("40") , dx=None           , xu=Unit(), 
          y=Decimal("30") , dy=Decimal("10")  , yu=Unit(), 
          u=None          , du=Decimal("5")   , mu=None,
          v=None          , dv=None           , mv=None,
          implied=True)
        # Value 4: Negative
        meas_meas_div(
          x=-4    , dx=None           , xu=Unit(), 
          y=-3    , dy=1              , yu=Unit(),
          u=None  , du=Decimal("0.5") , mu=None,
          v=None  , dv=None           , mv=None,
          implied=True)
        # Value 5: Zero
        if(True):
          # Int
          with pytest.raises(Exception):
            # Context Values
            x,dx,xu = 4,None,Unit()
            y,dy,yu = 0,1,Unit()
            # Error Out
            Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)
          # Float
          with pytest.raises(Exception):
            # Context Values
            x,dx,xu = 0.4,None,Unit()
            y,dy,yu = 0.0,0.1,Unit()
            # Error Out
            Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)
          # Decimal 
          with pytest.raises(Exception):
            # Context Values
            x,dx,xu = Decimal("0.4"),None,Unit()
            y,dy,yu = Decimal("0.0"),Decimal("0.1"),Unit()
            # Error Out
            Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)
        # Preserve Inputs
        if(True):
          a = Measure(value=4,error=None) 
          b = Measure(value=3,error=2)
          c = a/b
          c = None
          assert a == Measure(value=4,error=None) 
          assert b == Measure(value=3,error=2)
      # Unitless / Unit
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          meas_meas_div(
            x=4     , dx=None              , xu=Unit(), 
            y=3     , dy=1              , yu=Unit("cm"), 
            u=None  , du=Decimal("0.5") , mu=None,
            v=None  , dv=None           , mv=None,
            implied=True)
          # Value 2: Float
          meas_meas_div(
            x=0.4   , dx=None           , xu=Unit(), 
            y=0.3   , dy=0.1            , yu=Unit("cm"), 
            u=None  , du=0.05           , mu=None,
            v=None  , dv=None           , mv=None,
            implied=True)
          # Value 3: Decimal
          meas_meas_div(
            x=Decimal("40") , dx=None           , xu=Unit(), 
            y=Decimal("30") , dy=Decimal("10")  , yu=Unit("cm"), 
            u=None          , du=Decimal("5")   , mu=None,
            v=None          , dv=None           , mv=None,
            implied=True)
          # Value 4: Negative
          meas_meas_div(
            x=-4    , dx=None           , xu=Unit(), 
            y=-3    , dy=1              , yu=Unit("cm"), 
            u=None  , du=Decimal("0.5") , mu=None,
            v=None  , dv=None           , mv=None,
            implied=True)
          # Value 5: Zero
          if(True):
            # Int
            with pytest.raises(Exception):
              # Context Values
              x,dx,xu = 4,None,Unit()
              y,dy,yu = 0,1,Unit("cm")
              # Error Out
              Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)
            # Float
            with pytest.raises(Exception):
              # Context Values
              x,dx,xu = 0.4,None,Unit()
              y,dy,yu = 0.0,0.1,Unit("cm")
              # Error Out
              Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)
            # Decimal 
            with pytest.raises(Exception):
              # Context Values
              x,dx,xu = Decimal("0.4"),None,Unit()
              y,dy,yu = Decimal("0.0"),Decimal("0.1"),Unit("cm")
              # Error Out
              Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)
        # Magnitude Units
        if(True):
          # Value 1: Int
          meas_meas_div(
            x=4     , dx=None           , xu=Unit(), 
            y=3     , dy=1              , yu=Unit("5 m^2"), 
            u=None  , du=Decimal("0.5") , mu=None,
            v=None  , dv=None           , mv=None,
            implied=True)
          # Value 2: Float
          meas_meas_div(
            x=0.4   , dx=None           , xu=Unit(), 
            y=0.3   , dy=0.1            , yu=Unit("5 m^2"), 
            u=None  , du=0.05           , mu=None,
            v=None  , dv=None           , mv=None,
            implied=True)
          # Value 3: Decimal
          meas_meas_div(
            x=Decimal("40") , dx=None           , xu=Unit(), 
            y=Decimal("30") , dy=Decimal("10")  , yu=Unit("5 m^2"), 
            u=None          , du=Decimal("5")   , mu=None,
            v=None          , dv=None           , mv=None,
            implied=True)
          # Value 4: Negative
          meas_meas_div(
            x=-4    , dx=None           , xu=Unit(), 
            y=-3    , dy=1              , yu=Unit("5 m^2"), 
            u=None  , du=Decimal("0.5") , mu=None,
            v=None  , dv=None           , mv=None,
            implied=True)
          # Value 5: Zero
          if(True):
            # Int
            with pytest.raises(Exception):
              # Context Values
              x,dx,xu = 4,None,Unit()
              y,dy,yu = 0,1,Unit("5 m^2")
              # Error Out
              Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)
            # Float
            with pytest.raises(Exception):
              # Context Values
              x,dx,xu = 0.4,None,Unit()
              y,dy,yu = 0.0,0.1,Unit("5 m^2")
              # Error Out
              Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)
            # Decimal 
            with pytest.raises(Exception):
              # Context Values
              x,dx,xu = Decimal("0.4"),None,Unit()
              y,dy,yu = Decimal("0.0"),Decimal("0.1"),Unit("5 m^2")
              # Error Out
              Measure(value=x,error=dx,unit=xu)  /  Measure(value=y,error=dy,unit=yu)
        # Convoluted Units
        if(True):
          # Value 1: Int
          meas_meas_div(
            x=300               , dx=None           , xu=Unit(), 
            y=27                , dy=1              , yu=Unit("\u00B0C"), 
            u=None              , du=Decimal("50") , mu=None,
            v=Decimal("300.15") , dv=None           , mv=None,
            implied=True)
          # Value 2: Float
          meas_meas_div(
            x=299.9 , dx=None , xu=Unit(), 
            y=26.85 , dy=0.01 , yu=Unit("\u00B0C"), 
            u=None  , du=0.05 , mu=None,
            v=300.0 , dv=None , mv=None,
            implied=True)
          # Value 3: Decimal
          meas_meas_div(
            x=Decimal("300")    , dx=None             , xu=Unit(), 
            y=Decimal("26.85")  , dy=Decimal("0.01")  , yu=Unit("\u00B0C"), 
            u=None              , du=Decimal("50")    , mu=None,
            v=Decimal("300")    , dv=None             , mv=None,
            implied=True)
          # Value 4: Negative
          meas_meas_div(
            x=300               , dx=None           , xu=Unit(), 
            y=-27               , dy=1              , yu=Unit("\u00B0C"), 
            u=None              , du=Decimal("50")  , mu=None,
            v=Decimal("246.15") , dv=None           , mv=None,
            implied=True)
          # Value 5: Zero
          if(True):
            # Int
            meas_meas_div(
              x=300               , dx=None           , xu=Unit(), 
              y=0                 , dy=1              , yu=Unit("\u00B0C"), 
              u=None              , du=Decimal("50")  , mu=None,
              v=Decimal("273.15") , dv=None           , mv=None,
              implied=True)
            # Float
            meas_meas_div(
              x=300.0   , dx=None , xu=Unit(), 
              y=0.0     , dy=0.01 , yu=Unit("\u00B0C"), 
              u=None    , du=0.05 , mu=None,
              v=273.15  , dv=None , mv=None,
              implied=True)
            # Decimal
            meas_meas_div(
              x=Decimal("300")    , dx=None             , xu=Unit(), 
              y=Decimal("0")      , dy=Decimal("0.01")  , yu=Unit("\u00B0C"), 
              u=None              , du=Decimal("50")    , mu=None,
              v=Decimal("273.15") , dv=None             , mv=None,
              implied=True)
        # Preserve Inputs
        if(True):
          a = Measure(value=4,error=None) 
          b = Measure(value=3,error=2,unit=Unit("cm"))
          c = a/b
          c = None
          assert a == Measure(value=4,error=None) 
          assert b == Measure(value=3,error=2,unit=Unit("cm"))
      # Unit / Unitless
      if(True):
        # Normal Units
        if(True):
          # Value 1: Int
          meas_meas_div(
            x=4     , dx=None              , xu=Unit("cm"), 
            y=3     , dy=1              , yu=Unit(), 
            u=None  , du=Decimal("0.5") , mu=None,
            v=None  , dv=None           , mv=None,
            implied=True)
          # Value 2: Float
          meas_meas_div(
            x=0.4   , dx=None           , xu=Unit("cm"), 
            y=0.3   , dy=0.1            , yu=Unit(), 
            u=None  , du=0.05           , mu=None,
            v=None  , dv=None           , mv=None,
            implied=True)
          # Value 3: Decimal
          meas_meas_div(
            x=Decimal("40") , dx=None           , xu=Unit("cm"), 
            y=Decimal("30") , dy=Decimal("10")  , yu=Unit(), 
            u=None          , du=Decimal("5")   , mu=None,
            v=None          , dv=None           , mv=None,
            implied=True)
     