"""
    Turing Minimal Openapi Spec for SDK

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from turing.generated.api_client import ApiClient, Endpoint as _Endpoint
from turing.generated.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from turing.generated.model.ensembler import Ensembler
from turing.generated.model.ensembler_type import EnsemblerType
from turing.generated.model.ensemblers_paginated_results import EnsemblersPaginatedResults


class EnsemblerApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __create_ensembler(
            self,
            project_id,
            ensembler,
            **kwargs
        ):
            """Saves a user-defined ensembler into the project  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_ensembler(project_id, ensembler, async_req=True)
            >>> result = thread.get()

            Args:
                project_id (int):
                ensembler (Ensembler): A JSON object containing information about the ensembler

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Ensembler
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['project_id'] = \
                project_id
            kwargs['ensembler'] = \
                ensembler
            return self.call_with_http_info(**kwargs)

        self.create_ensembler = _Endpoint(
            settings={
                'response_type': (Ensembler,),
                'auth': [],
                'endpoint_path': '/projects/{project_id}/ensemblers',
                'operation_id': 'create_ensembler',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'project_id',
                    'ensembler',
                ],
                'required': [
                    'project_id',
                    'ensembler',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'project_id':
                        (int,),
                    'ensembler':
                        (Ensembler,),
                },
                'attribute_map': {
                    'project_id': 'project_id',
                },
                'location_map': {
                    'project_id': 'path',
                    'ensembler': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_ensembler
        )

        def __get_ensembler_details(
            self,
            project_id,
            ensembler_id,
            **kwargs
        ):
            """Returns Ensembler's details by its ID  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_ensembler_details(project_id, ensembler_id, async_req=True)
            >>> result = thread.get()

            Args:
                project_id (int):
                ensembler_id (int):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Ensembler
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['project_id'] = \
                project_id
            kwargs['ensembler_id'] = \
                ensembler_id
            return self.call_with_http_info(**kwargs)

        self.get_ensembler_details = _Endpoint(
            settings={
                'response_type': (Ensembler,),
                'auth': [],
                'endpoint_path': '/projects/{project_id}/ensemblers/{ensembler_id}',
                'operation_id': 'get_ensembler_details',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'project_id',
                    'ensembler_id',
                ],
                'required': [
                    'project_id',
                    'ensembler_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'project_id':
                        (int,),
                    'ensembler_id':
                        (int,),
                },
                'attribute_map': {
                    'project_id': 'project_id',
                    'ensembler_id': 'ensembler_id',
                },
                'location_map': {
                    'project_id': 'path',
                    'ensembler_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_ensembler_details
        )

        def __list_ensemblers(
            self,
            project_id,
            **kwargs
        ):
            """Returns a list of ensemblers that belong to the project  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_ensemblers(project_id, async_req=True)
            >>> result = thread.get()

            Args:
                project_id (int):

            Keyword Args:
                page (int): [optional] if omitted the server will use the default value of 1
                page_size (int): [optional] if omitted the server will use the default value of 10
                search (str): Searches ensembler name for a partial match of the search text. [optional]
                type (EnsemblerType): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                EnsemblersPaginatedResults
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['project_id'] = \
                project_id
            return self.call_with_http_info(**kwargs)

        self.list_ensemblers = _Endpoint(
            settings={
                'response_type': (EnsemblersPaginatedResults,),
                'auth': [],
                'endpoint_path': '/projects/{project_id}/ensemblers',
                'operation_id': 'list_ensemblers',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'project_id',
                    'page',
                    'page_size',
                    'search',
                    'type',
                ],
                'required': [
                    'project_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'project_id':
                        (int,),
                    'page':
                        (int,),
                    'page_size':
                        (int,),
                    'search':
                        (str,),
                    'type':
                        (EnsemblerType,),
                },
                'attribute_map': {
                    'project_id': 'project_id',
                    'page': 'page',
                    'page_size': 'page_size',
                    'search': 'search',
                    'type': 'type',
                },
                'location_map': {
                    'project_id': 'path',
                    'page': 'query',
                    'page_size': 'query',
                    'search': 'query',
                    'type': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_ensemblers
        )

        def __update_ensembler(
            self,
            project_id,
            ensembler_id,
            ensembler,
            **kwargs
        ):
            """Updates existing Ensembler with the data provided in the payload  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_ensembler(project_id, ensembler_id, ensembler, async_req=True)
            >>> result = thread.get()

            Args:
                project_id (int):
                ensembler_id (int):
                ensembler (Ensembler): A JSON object, representing an update to the ensembler

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Ensembler
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['project_id'] = \
                project_id
            kwargs['ensembler_id'] = \
                ensembler_id
            kwargs['ensembler'] = \
                ensembler
            return self.call_with_http_info(**kwargs)

        self.update_ensembler = _Endpoint(
            settings={
                'response_type': (Ensembler,),
                'auth': [],
                'endpoint_path': '/projects/{project_id}/ensemblers/{ensembler_id}',
                'operation_id': 'update_ensembler',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'project_id',
                    'ensembler_id',
                    'ensembler',
                ],
                'required': [
                    'project_id',
                    'ensembler_id',
                    'ensembler',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'project_id':
                        (int,),
                    'ensembler_id':
                        (int,),
                    'ensembler':
                        (Ensembler,),
                },
                'attribute_map': {
                    'project_id': 'project_id',
                    'ensembler_id': 'ensembler_id',
                },
                'location_map': {
                    'project_id': 'path',
                    'ensembler_id': 'path',
                    'ensembler': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_ensembler
        )
