"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InputValidator = void 0;
const cdk = require("@aws-cdk/core");
/**
 * Class to validate that inputs match requirements.
 */
class InputValidator {
    /**
     * Validates length is between allowed min and max lengths.
     */
    static validateLength(resourceName, inputName, minLength, maxLength, inputString) {
        if (!cdk.Token.isUnresolved(inputString) && inputString !== undefined && (inputString.length < minLength || inputString.length > maxLength)) {
            throw new Error(`Invalid ${inputName} for resource ${resourceName}, must have length between ${minLength} and ${maxLength}, got: '${this.truncateString(inputString, 100)}'`);
        }
    }
    /**
     * Validates a regex.
     */
    static validateRegex(resourceName, inputName, regex, inputString) {
        if (!cdk.Token.isUnresolved(inputString) && inputString !== undefined && !regex.test(inputString)) {
            throw new Error(`Invalid ${inputName} for resource ${resourceName}, must match regex pattern ${regex}, got: '${this.truncateString(inputString, 100)}'`);
        }
    }
    static truncateString(string, maxLength) {
        if (string.length > maxLength) {
            return string.substring(0, maxLength) + '[truncated]';
        }
        return string;
    }
}
exports.InputValidator = InputValidator;
//# sourceMappingURL=data:application/json;base64,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