# coding: utf-8

"""
Esper APIs

OpenAPI spec version: 1.0.0
Contact: developer@esper.io
---------------------------------------------------------

Copyright 2019 Shoonya Enterprises Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""



import pprint
import re

import six

from esperclient.models.v0_command_status_update_details import V0CommandStatusUpdateDetails


class V0CommandStatusUpdate(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'reason': 'str',
        'details': 'V0CommandStatusUpdateDetails'
    }

    attribute_map = {
        'reason': 'reason',
        'details': 'details'
    }

    def __init__(self, reason=None, details=None):
        """V0CommandStatusUpdate - a model defined in Swagger"""

        self._reason = None
        self._details = None
        self.discriminator = None

        if reason is not None:
            self.reason = reason
        if details is not None:
            self.details = details

    @property
    def reason(self):
        """Gets the reason of this V0CommandStatusUpdate.

        details briefing the reason for current command state

        :return: The reason of this V0CommandStatusUpdate.
        :rtype: str
        """
        return self._reason

    @reason.setter
    def reason(self, reason):
        """Sets the reason of this V0CommandStatusUpdate.

        details briefing the reason for current command state

        :param reason: The reason of this V0CommandStatusUpdate.
        :type: str
        """

        self._reason = reason

    @property
    def details(self):
        """Gets the details of this V0CommandStatusUpdate.


        :return: The details of this V0CommandStatusUpdate.
        :rtype: V0CommandStatusUpdateDetails
        """
        return self._details

    @details.setter
    def details(self, details):
        """Sets the details of this V0CommandStatusUpdate.


        :param details: The details of this V0CommandStatusUpdate.
        :type: V0CommandStatusUpdateDetails
        """

        self._details = details

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(V0CommandStatusUpdate, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, V0CommandStatusUpdate):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
