# coding: utf-8

"""
Esper APIs

OpenAPI spec version: 1.0.0
Contact: developer@esper.io
---------------------------------------------------------

Copyright 2019 Shoonya Enterprises Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""



import pprint
import re

import six


class V0CommandArgs(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'device_alias_name': 'str',
        'custom_settings_config': 'object'
    }

    attribute_map = {
        'device_alias_name': 'device_alias_name',
        'custom_settings_config': 'custom_settings_config'
    }

    def __init__(self, device_alias_name=None, custom_settings_config=None):
        """V0CommandArgs - a model defined in Swagger"""

        self._device_alias_name = None
        self._custom_settings_config = None
        self.discriminator = None

        if device_alias_name is not None:
            self.device_alias_name = device_alias_name
        if custom_settings_config is not None:
            self.custom_settings_config = custom_settings_config

    @property
    def device_alias_name(self):
        """Gets the device_alias_name of this V0CommandArgs.

        Alternate human-readable name for your Device

        :return: The device_alias_name of this V0CommandArgs.
        :rtype: str
        """
        return self._device_alias_name

    @device_alias_name.setter
    def device_alias_name(self, device_alias_name):
        """Sets the device_alias_name of this V0CommandArgs.

        Alternate human-readable name for your Device

        :param device_alias_name: The device_alias_name of this V0CommandArgs.
        :type: str
        """

        self._device_alias_name = device_alias_name

    @property
    def custom_settings_config(self):
        """Gets the custom_settings_config of this V0CommandArgs.

        Managed configurations for your device (passed as JSON object)

        :return: The custom_settings_config of this V0CommandArgs.
        :rtype: object
        """
        return self._custom_settings_config

    @custom_settings_config.setter
    def custom_settings_config(self, custom_settings_config):
        """Sets the custom_settings_config of this V0CommandArgs.

        Managed configurations for your device (passed as JSON object)

        :param custom_settings_config: The custom_settings_config of this V0CommandArgs.
        :type: object
        """

        self._custom_settings_config = custom_settings_config

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(V0CommandArgs, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, V0CommandArgs):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
