# coding: utf-8

"""
Esper APIs

OpenAPI spec version: 1.0.0
Contact: developer@esper.io
---------------------------------------------------------

Copyright 2019 Shoonya Enterprises Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""



import pprint
import re

import six


class ApplicationVersion(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'version_code': 'str',
        'build_number': 'str',
        'hash_string': 'str',
        'min_sdk_version': 'str',
        'target_sdk_version': 'str',
        'download_url': 'str'
    }

    attribute_map = {
        'id': 'id',
        'version_code': 'version_code',
        'build_number': 'build_number',
        'hash_string': 'hash_string',
        'min_sdk_version': 'min_sdk_version',
        'target_sdk_version': 'target_sdk_version',
        'download_url': 'download_url'
    }

    def __init__(self, id=None, version_code=None, build_number=None, hash_string=None, min_sdk_version=None, target_sdk_version=None, download_url=None):
        """ApplicationVersion - a model defined in Swagger"""

        self._id = None
        self._version_code = None
        self._build_number = None
        self._hash_string = None
        self._min_sdk_version = None
        self._target_sdk_version = None
        self._download_url = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if version_code is not None:
            self.version_code = version_code
        if build_number is not None:
            self.build_number = build_number
        if hash_string is not None:
            self.hash_string = hash_string
        if min_sdk_version is not None:
            self.min_sdk_version = min_sdk_version
        if target_sdk_version is not None:
            self.target_sdk_version = target_sdk_version
        if download_url is not None:
            self.download_url = download_url

    @property
    def id(self):
        """Gets the id of this ApplicationVersion.


        :return: The id of this ApplicationVersion.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ApplicationVersion.


        :param id: The id of this ApplicationVersion.
        :type: str
        """

        self._id = id

    @property
    def version_code(self):
        """Gets the version_code of this ApplicationVersion.


        :return: The version_code of this ApplicationVersion.
        :rtype: str
        """
        return self._version_code

    @version_code.setter
    def version_code(self, version_code):
        """Sets the version_code of this ApplicationVersion.


        :param version_code: The version_code of this ApplicationVersion.
        :type: str
        """
        if version_code is not None and len(version_code) > 50:
            raise ValueError("Invalid value for `version_code`, length must be less than or equal to `50`")
        if version_code is not None and len(version_code) < 1:
            raise ValueError("Invalid value for `version_code`, length must be greater than or equal to `1`")

        self._version_code = version_code

    @property
    def build_number(self):
        """Gets the build_number of this ApplicationVersion.


        :return: The build_number of this ApplicationVersion.
        :rtype: str
        """
        return self._build_number

    @build_number.setter
    def build_number(self, build_number):
        """Sets the build_number of this ApplicationVersion.


        :param build_number: The build_number of this ApplicationVersion.
        :type: str
        """
        if build_number is not None and len(build_number) > 100:
            raise ValueError("Invalid value for `build_number`, length must be less than or equal to `100`")
        if build_number is not None and len(build_number) < 1:
            raise ValueError("Invalid value for `build_number`, length must be greater than or equal to `1`")

        self._build_number = build_number

    @property
    def hash_string(self):
        """Gets the hash_string of this ApplicationVersion.


        :return: The hash_string of this ApplicationVersion.
        :rtype: str
        """
        return self._hash_string

    @hash_string.setter
    def hash_string(self, hash_string):
        """Sets the hash_string of this ApplicationVersion.


        :param hash_string: The hash_string of this ApplicationVersion.
        :type: str
        """

        self._hash_string = hash_string

    @property
    def min_sdk_version(self):
        """Gets the min_sdk_version of this ApplicationVersion.


        :return: The min_sdk_version of this ApplicationVersion.
        :rtype: str
        """
        return self._min_sdk_version

    @min_sdk_version.setter
    def min_sdk_version(self, min_sdk_version):
        """Sets the min_sdk_version of this ApplicationVersion.


        :param min_sdk_version: The min_sdk_version of this ApplicationVersion.
        :type: str
        """
        if min_sdk_version is not None and len(min_sdk_version) > 10:
            raise ValueError("Invalid value for `min_sdk_version`, length must be less than or equal to `10`")
        if min_sdk_version is not None and len(min_sdk_version) < 1:
            raise ValueError("Invalid value for `min_sdk_version`, length must be greater than or equal to `1`")

        self._min_sdk_version = min_sdk_version

    @property
    def target_sdk_version(self):
        """Gets the target_sdk_version of this ApplicationVersion.


        :return: The target_sdk_version of this ApplicationVersion.
        :rtype: str
        """
        return self._target_sdk_version

    @target_sdk_version.setter
    def target_sdk_version(self, target_sdk_version):
        """Sets the target_sdk_version of this ApplicationVersion.


        :param target_sdk_version: The target_sdk_version of this ApplicationVersion.
        :type: str
        """
        if target_sdk_version is not None and len(target_sdk_version) > 10:
            raise ValueError("Invalid value for `target_sdk_version`, length must be less than or equal to `10`")
        if target_sdk_version is not None and len(target_sdk_version) < 1:
            raise ValueError("Invalid value for `target_sdk_version`, length must be greater than or equal to `1`")

        self._target_sdk_version = target_sdk_version

    @property
    def download_url(self):
        """Gets the download_url of this ApplicationVersion.


        :return: The download_url of this ApplicationVersion.
        :rtype: str
        """
        return self._download_url

    @download_url.setter
    def download_url(self, download_url):
        """Sets the download_url of this ApplicationVersion.


        :param download_url: The download_url of this ApplicationVersion.
        :type: str
        """

        self._download_url = download_url

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ApplicationVersion, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ApplicationVersion):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
