/*
djot.js LICENSE file, retrieved from
https://github.com/jgm/djot.js/blob/baa4d3e62bccaebe0680adea1b185adbd211fd8a/LICENSE

Copyright (C) 2022 John MacFarlane

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/
!function(t,e){"object"==typeof exports&&"object"==typeof module?module.exports=e():"function"==typeof define&&define.amd?define([],e):"object"==typeof exports?exports.djot=e():t.djot=e()}(this,(()=>(()=>{"use strict";var t={60:(t,e)=>{Object.defineProperty(e,"__esModule",{value:!0}),e.isCaption=e.isRow=e.isBlock=e.isInline=void 0;const s={para:!0,heading:!0,block_quote:!0,thematic_break:!0,section:!0,div:!0,code_block:!0,raw_block:!0,bullet_list:!0,ordered_list:!0,task_list:!0,definition_list:!0,table:!0,reference:!0,footnote:!0};e.isBlock=function(t){return s[t.tag]||!1};const n={str:!0,soft_break:!0,hard_break:!0,non_breaking_space:!0,symb:!0,verbatim:!0,raw_inline:!0,inline_math:!0,display_math:!0,url:!0,email:!0,footnote_reference:!0,smart_punctuation:!0,emph:!0,strong:!0,link:!0,image:!0,span:!0,mark:!0,superscript:!0,subscript:!0,insert:!0,delete:!0,double_quoted:!0,single_quoted:!0};e.isInline=function(t){return n[t.tag]||!1},e.isRow=function(t){return"head"in t},e.isCaption=function(t){return!("head"in t)}},722:(t,e)=>{var s;Object.defineProperty(e,"__esModule",{value:!0}),e.AttributeParser=void 0,function(t){t[t.SCANNING=0]="SCANNING",t[t.SCANNING_ID=1]="SCANNING_ID",t[t.SCANNING_CLASS=2]="SCANNING_CLASS",t[t.SCANNING_KEY=3]="SCANNING_KEY",t[t.SCANNING_VALUE=4]="SCANNING_VALUE",t[t.SCANNING_BARE_VALUE=5]="SCANNING_BARE_VALUE",t[t.SCANNING_QUOTED_VALUE=6]="SCANNING_QUOTED_VALUE",t[t.SCANNING_QUOTED_VALUE_CONTINUATION=7]="SCANNING_QUOTED_VALUE_CONTINUATION",t[t.SCANNING_ESCAPED=8]="SCANNING_ESCAPED",t[t.SCANNING_ESCAPED_IN_CONTINUATION=9]="SCANNING_ESCAPED_IN_CONTINUATION",t[t.SCANNING_COMMENT=10]="SCANNING_COMMENT",t[t.FAIL=11]="FAIL",t[t.DONE=12]="DONE",t[t.START=13]="START"}(s||(s={}));const n=/^[a-zA-Z0-9_:-]/,i=[];i[s.START]=function(t,e){return"{"===t.subject.charAt(e)?s.SCANNING:s.FAIL},i[s.FAIL]=function(t,e){return s.FAIL},i[s.DONE]=function(t,e){return s.DONE},i[s.SCANNING]=function(t,e){const i=t.subject.charAt(e);return" "===i||"\t"===i||"\n"===i||"\r"===i?s.SCANNING:"}"===i?s.DONE:"#"===i?(t.begin=e,s.SCANNING_ID):"%"===i?(t.begin=e,s.SCANNING_COMMENT):"."===i?(t.begin=e,s.SCANNING_CLASS):function(t){return null!==n.exec(t)}(i)?(t.begin=e,s.SCANNING_KEY):s.FAIL},i[s.SCANNING_COMMENT]=function(t,e){return"%"===t.subject.charAt(e)?s.SCANNING:s.SCANNING_COMMENT},i[s.SCANNING_ID]=function(t,e){const n=t.subject.substr(e,1);return null!==/^\w/.exec(n)||"_"===n||"-"===n||":"===n?s.SCANNING_ID:"}"===n?(t.begin&&t.lastpos&&t.lastpos>t.begin&&t.addEvent(t.begin+1,t.lastpos,"id"),t.begin=null,s.DONE):null!==/^\s/.exec(n)?(t.begin&&t.lastpos&&t.lastpos>t.begin&&t.addEvent(t.begin+1,t.lastpos,"id"),t.begin=null,s.SCANNING):s.FAIL},i[s.SCANNING_CLASS]=function(t,e){const n=t.subject.substr(e,1);return null!==/^\w/.exec(n)||"_"===n||"-"===n||":"===n?s.SCANNING_CLASS:"}"===n?(t.begin&&t.lastpos&&t.lastpos>t.begin&&t.addEvent(t.begin+1,t.lastpos,"class"),t.begin=null,s.DONE):null!==/^\s/.exec(n)?(t.begin&&t.lastpos&&t.lastpos>t.begin&&t.addEvent(t.begin+1,t.lastpos,"class"),t.begin=null,s.SCANNING):s.FAIL},i[s.SCANNING_KEY]=function(t,e){const n=t.subject.substr(e,1);return"="===n&&t.begin&&t.lastpos?(t.addEvent(t.begin,t.lastpos,"key"),t.begin=null,s.SCANNING_VALUE):null!==/^[a-zA-Z0-9_:-]/.exec(n)?s.SCANNING_KEY:s.FAIL},i[s.SCANNING_VALUE]=function(t,e){const n=t.subject.charAt(e);return'"'===n?(t.begin=e,s.SCANNING_QUOTED_VALUE):null!==/^[a-zA-Z0-9_:-]/.exec(n)?(t.begin=e,s.SCANNING_BARE_VALUE):s.FAIL},i[s.SCANNING_BARE_VALUE]=function(t,e){const n=t.subject.charAt(e);return null!==/^[a-zA-Z0-9_:-]/.exec(n)?s.SCANNING_BARE_VALUE:"}"===n&&t.begin&&t.lastpos?(t.addEvent(t.begin,t.lastpos,"value"),t.begin=null,s.DONE):/^\s/.exec(n)&&t.begin&&t.lastpos?(t.addEvent(t.begin,t.lastpos,"value"),t.begin=null,s.SCANNING):s.FAIL},i[s.SCANNING_ESCAPED]=function(t,e){return s.SCANNING_QUOTED_VALUE},i[s.SCANNING_ESCAPED_IN_CONTINUATION]=function(t,e){return s.SCANNING_QUOTED_VALUE_CONTINUATION},i[s.SCANNING_QUOTED_VALUE]=function(t,e){const n=t.subject.charAt(e);return'"'===n&&t.begin&&t.lastpos?(t.addEvent(t.begin+1,t.lastpos,"value"),t.begin=null,s.SCANNING):"\n"===n&&t.begin&&t.lastpos?(t.addEvent(t.begin+1,e,"value"),t.begin=null,s.SCANNING_QUOTED_VALUE_CONTINUATION):"\\"===n?s.SCANNING_ESCAPED:s.SCANNING_QUOTED_VALUE},i[s.SCANNING_QUOTED_VALUE_CONTINUATION]=function(t,e){const n=t.subject.charAt(e);return null===t.begin&&(t.begin=e),'"'===n&&t.begin&&t.lastpos?(t.addEvent(t.begin,t.lastpos,"value"),t.begin=null,s.SCANNING):"\n"===n&&t.begin&&t.lastpos?(t.addEvent(t.begin,e,"value"),t.begin=null,s.SCANNING_QUOTED_VALUE_CONTINUATION):"\\"===n?s.SCANNING_ESCAPED_IN_CONTINUATION:s.SCANNING_QUOTED_VALUE_CONTINUATION},e.AttributeParser=class{constructor(t){this.subject=t,this.state=s.START,this.begin=null,this.lastpos=null,this.matches=[]}addEvent(t,e,s){this.matches.push({startpos:t,endpos:e,annot:s})}feed(t,e){let n=t;for(;n<=e;){if(this.state=i[this.state](this,n),this.state===s.DONE)return{status:"done",position:n};if(this.state===s.FAIL)return this.lastpos=n,{status:"fail",position:n};this.lastpos=n,n+=1}return{status:"continue",position:e}}}},155:(t,e,s)=>{Object.defineProperty(e,"__esModule",{value:!0}),e.parseEvents=void 0;const n=s(380),i=s(722),r=s(481),a=s(418),o=function(t){return"+"===t||"-"===t||"*"===t||":"===t?[t]:/^[+*-] \[[Xx ]\]/.exec(t)?["X"]:/^[(]?[0-9]+[).]/.exec(t)?[t.replace(/[0-9]+/,"1")]:/^[(]?[ivxlcdm][).]/.exec(t)?[t.replace(/[a-z]+/,"i"),t.replace(/[a-z]+/,"a")]:/^[(]?[IVXLCDM][).]/.exec(t)?[t.replace(/[A-Z]+/,"I"),t.replace(/[A-Z]+/,"A")]:/^[(]?[ivxlcdm]+[).]/.exec(t)?[t.replace(/[a-z]+/,"i")]:/^[(]?[IVXLCDM]+[).]/.exec(t)?[t.replace(/[A-Z]+/,"I")]:/^[(]?[a-z][).]/.exec(t)?[t.replace(/[a-z]/,"a")]:/^[(]?[A-Z][).]/.exec(t)?[t.replace(/[A-Z]/,"A")]:[]},c=(0,r.pattern)("[ \\t]*\\r?\\n"),l=(0,r.pattern)("^\\w+\\s"),h=(0,r.pattern)("[ \\t\\r\\n]"),d=(0,r.pattern)("[^ \\t\\r\\n]+"),u=(0,r.pattern)("[>][ \\t\\r\\n]"),p=(0,r.pattern)("#+"),f=(0,r.pattern)("(~~~~*|````*)([ \\t]*)([^ \\t\\r\\n`]*)[ \\t]*\\r?\\n"),b=(0,r.pattern)("(:?)--*(:?)([ \\t]*\\|[ \\t]*)"),g=(0,r.pattern)("[^`|\\r\\n]*(?:[|]|`+)"),m=(0,r.pattern)("\\^[ \\t]+"),_=(0,r.pattern)("\\[\\^([^\\]]+)\\]:[ \\t\\r\\n]"),k=(0,r.pattern)("[-*][ \t]*[-*][ \\t]*[-*][-* \\t]*\\r?\\n"),N=(0,r.pattern)("(::::*)[ \\t]*\\r?\\n"),x=(0,r.pattern)("(::::*)[ \\t]*"),C=(0,r.pattern)("([\\w_-]*)[ \\t]*\\r?\\n"),A=(0,r.pattern)("\\[([^\\]\\r\\n]*)\\]:[ \\t]*([^ \\t\\r\\n]*)[\\r\\n]"),P=(0,r.pattern)("(\\|[^\\r\\n]*\\|)[ \\t]*\\r?\\n"),I=(0,r.pattern)("(:?[-*+:]|\\([0-9]+\\)|[0-9]+[.)]|[ivxlcdmIVXLCDM]+[.)]|\\([ivxlcdmIVXLCDM]+\\)|[a-zA-Z][.)]|\\([a-zA-Z]\\))[ \\t\\r\\n]"),M=(0,r.pattern)("[*+-] \\[[Xx ]\\][ \\t\\r\\n]");var w;!function(t){t[t.None=0]="None",t[t.Inline=1]="Inline",t[t.Block=2]="Block",t[t.Text=3]="Text",t[t.Cells=4]="Cells",t[t.Attributes=5]="Attributes",t[t.ListItem=6]="ListItem"}(w||(w={}));class v{constructor(t,e){this.name=t.name,this.type=t.type,this.content=t.content,this.continue=t.continue,this.close=t.close,this.indent=0,this.inlineParser=null,this.attributeParser=null,this.extra=e}}class S{constructor(t,e={}){"\n"!==t.charAt(t.length-1)&&(t+="\n"),this.subject=t,this.maxoffset=t.length-1,this.options=e,this.warn=e.warn||(()=>{}),this.indent=0,this.startline=0,this.starteol=0,this.endeol=0,this.matches=[],this.containers=[],this.pos=0,this.lastMatchedContainer=0,this.finishedLine=!1,this.returned=0,this.paraSpec={name:"para",type:w.Block,content:w.Inline,continue:t=>null===this.find(h),open:t=>(this.addContainer(new v(t,{})),this.addMatch(this.pos,this.pos,"+para"),!0),close:()=>{this.getInlineMatches(),this.containers.pop();const t=this.matches[this.matches.length-1],e=t&&t.endpos+1||this.pos;this.addMatch(e,e,"-para")}},this.specs=[{name:"block_quote",type:w.Block,content:w.Block,continue:t=>null!==this.find(u)&&(this.pos=this.pos+1,!0),open:t=>null!==this.find(u)&&(this.addContainer(new v(t,{})),this.addMatch(this.pos,this.pos,"+block_quote"),this.pos=this.pos+1,!0),close:()=>{this.containers.pop(),this.addMatch(this.pos,this.pos,"-block_quote")}},{name:"heading",type:w.Block,content:w.Inline,continue:t=>{const e=this.find(p);return!(!e||t.extra.level!==e.endpos-e.startpos+1||!(0,r.find)(this.subject,h,e.endpos+1)||(this.pos=e.endpos+1,0))},open:t=>{const e=this.find(p);if(e&&(0,r.find)(this.subject,h,e.endpos+1)){const s=e.endpos-e.startpos+1;return this.addContainer(new v(t,{level:s})),this.addMatch(e.startpos,e.endpos,"+heading"),this.pos=e.endpos+1,!0}return!1},close:()=>{this.getInlineMatches(),this.containers.pop();const t=this.matches[this.matches.length-1],e=t&&t.endpos+1||this.pos;this.addMatch(e,e,"-heading")}},{name:"caption",type:w.Block,content:w.Inline,continue:t=>null===(0,r.find)(this.subject,h,this.pos),open:t=>{const e=this.find(m);return!!e&&(this.pos=e.endpos+1,this.addContainer(new v(t,{})),this.addMatch(this.pos,this.pos,"+caption"),!0)},close:()=>{this.getInlineMatches(),this.containers.pop(),this.addMatch(this.pos-1,this.pos-1,"-caption")}},{name:"footnote",type:w.Block,content:w.Block,continue:t=>this.indent>(t.extra.indent||0)||this.pos===this.starteol,open:t=>{const e=this.find(_);if(e){const s=e.startpos,n=e.endpos,i=e.captures[0];return this.addContainer(new v(t,{note_label:i,indent:this.indent})),this.addMatch(s,s,"+footnote"),this.addMatch(s+2,n-3,"note_label"),this.pos=n,!0}return!1},close:()=>{this.containers.pop(),this.addMatch(this.pos,this.pos,"-footnote")}},{name:"reference_definition",type:w.Block,content:w.None,continue:t=>{if(t.extra.indent>=this.indent)return!1;const e=this.find(d);return!!(this.pos<this.starteol&&e&&e.endpos===this.starteol-1)&&(this.addMatch(this.pos,this.starteol-1,"reference_value"),this.pos=this.starteol,!0)},open:t=>{const e=this.find(A);if(e){const s=e.captures[0],n=e.captures[1];return this.addContainer(new v(t,{key:s,indent:this.indent})),this.addMatch(e.startpos,e.startpos,"+reference_definition"),this.addMatch(e.startpos,e.startpos+s.length+1,"reference_key"),n.length>0&&this.addMatch(this.starteol-n.length,this.starteol-1,"reference_value"),this.pos=this.starteol-1,!0}return!1},close:()=>{this.containers.pop(),this.addMatch(this.pos,this.pos,"-reference_definition")}},{name:"thematic_break",type:w.Block,content:w.None,continue:t=>!1,open:t=>{const e=this.find(k);return!!e&&(this.addContainer(new v(t,{})),this.addMatch(e.startpos,e.endpos,"thematic_break"),this.pos=e.endpos,!0)},close:()=>{this.containers.pop()}},{name:"list",type:w.Block,content:w.ListItem,continue:t=>{if(this.indent>t.extra.indent||this.pos===this.starteol)return!0;{const e=this.find(I);if(null===e)return!1;let s=this.subject.substring(e.startpos,e.endpos);const n=this.find(M);null!==n&&(s=this.subject.substring(n.startpos,n.startpos+5));const i=o(s),r=[];for(const e of t.extra.styles)i.includes(e)&&r.push(e);if(r.length>0)return t.extra.styles=r,!0}return!1},open:t=>{const e=this.find(I);if(null===e)return!1;const s=e.startpos,n=e.endpos;let i=this.subject.substring(s,n);const r=this.find(M);null!==r&&(i=this.subject.substring(r.startpos,r.startpos+5));const a=o(i);if(0===a.length)return!1;const c={styles:a,indent:this.indent};this.addContainer(new v(t,c));let l="+list";for(const t of a)l=l+"|"+t;return this.addMatch(s,n-1,l),!0},close:()=>{this.containers.pop(),this.addMatch(this.pos,this.pos,"-list")}},{name:"list_item",type:w.ListItem,content:w.Block,continue:t=>this.indent>t.extra.indent||this.pos===this.starteol,open:t=>{const e=this.find(I);if(null===e)return!1;const s=e.startpos,n=e.endpos;let i=this.subject.substring(s,n),r=null;const a=this.find(M);null!==a&&(i=this.subject.substring(a.startpos,a.startpos+5),r=this.subject.substring(a.startpos+3,a.startpos+4));const c=o(i);if(0===c.length)return!1;const l={styles:c,indent:this.indent};this.addContainer(new v(t,l));let h="+list_item";for(const t of c)h=h+"|"+t;return this.addMatch(s,n-1,h),this.pos=n,r&&(" "===r?this.addMatch(s+2,s+4,"checkbox_unchecked"):this.addMatch(s+2,s+4,"checkbox_checked"),this.pos=s+5),!0},close:()=>{this.containers.pop(),this.addMatch(this.pos,this.pos,"-list_item")}},{name:"table",type:w.Block,content:w.Cells,continue:t=>{const e=this.find(P);if(e){const t=e.captures[0];return this.parseTableRow(e.startpos,e.startpos+t.length-1)}return!1},open:t=>{const e=this.find(P);if(e){this.addContainer(new v(t,{columns:0}));const s=e.captures[0];return this.addMatch(e.startpos,e.startpos,"+table"),!!this.parseTableRow(e.startpos,e.startpos+s.length-1)||(this.matches.pop(),this.containers.pop(),!1)}return!1},close:()=>{this.containers.pop(),this.addMatch(this.pos,this.pos,"-table")}},{name:"attributes",type:w.Block,content:w.Attributes,open:t=>{if(123===this.subject.codePointAt(this.pos)){const e=new i.AttributeParser(this.subject),s=e.feed(this.pos,this.starteol);if("fail"===s.status)return!1;if("done"===s.status&&null===(0,r.find)(this.subject,c,s.position+1))return!1;{const n=this.addContainer(new v(t,{status:s.status,indent:this.indent,startpos:this.pos,slices:[]}));return n.attributeParser=e,n.extra.slices=[{startpos:this.pos,endpos:this.starteol}],this.pos=this.starteol,!0}}return!1},continue:t=>{if("done"===t.extra.status)return!1;if(t.attributeParser&&this.indent>t.extra.indent){t.extra.slices.push({startpos:this.pos,endpos:this.starteol});const e=t.attributeParser.feed(this.pos,this.endeol);if(t.extra.status=e.status,"fail"!==e.status||!(0,r.find)(this.subject,c,e.position+1))return this.pos=this.starteol,!0}this.addMatch(t.extra.startpos,t.extra.startpos,"+para");const e=this.containers.pop(),s=this.addContainer(new v(this.paraSpec,{}));if(!s.inlineParser||!e)throw new Error("Missing inlineParser or attrContainer");return s.inlineParser.attributeSlices=e.extra.slices,s.inlineParser.reparseAttributes(),this.pos=s.inlineParser.lastpos+1,!0},close:()=>{const t=this.containers.pop();if(t)if("continue"===t.extra.status){this.addMatch(t.extra.startpos,t.extra.startpos,"+para");const e=this.addContainer(new v(this.paraSpec,{}),!0);if(!e||!e.inlineParser)throw new Error("Could not add paragraph");e.inlineParser.attributeSlices=t.extra.slices,e.inlineParser.reparseAttributes(),e.close()}else{if(this.addMatch(t.extra.startpos,t.extra.startpos,"+block_attributes"),t.attributeParser){const e=t.attributeParser.matches;for(const t of e)this.matches.push(t)}this.addMatch(this.pos,this.pos,"-block_attributes")}}},{name:"fenced_div",type:w.Block,content:w.Block,continue:t=>{const e=this.tip();if(e&&"code_block"===e.name)return!0;const s=this.find(N);if(s&&t.extra.colons){const e=s.captures[0];if(e.length>=t.extra.colons)return t.extra.endFenceStartpos=s.startpos,t.extra.endFenceEndpos=s.startpos+e.length-1,this.pos=s.endpos,!1}return!0},open:t=>{const e=this.find(x);if(!e)return!1;const s=e.captures[0],n=(0,r.find)(this.subject,C,e.endpos+1);if(!n)return!1;const i=n.startpos,a=n.captures[0];return this.addContainer(new v(t,{colons:s.length})),this.addMatch(e.startpos,e.endpos,"+div"),a.length>0&&this.addMatch(i,i+a.length-1,"class"),this.pos=n.endpos+1,this.finishedLine=!0,!0},close:()=>{const t=this.containers.pop();if(!t)return;const e=t.extra.endFenceStartpos||this.pos,s=t.extra.endFenceEndpos||this.pos;this.addMatch(e,s,"-div"),e===s&&this.warn(new n.Warning("Unclosed div",this.pos))}},{name:"code_block",type:w.Block,content:w.Text,continue:t=>{const e=this.find(t.extra.closePattern);return!e||(t.extra.endFenceStartpos=e.startpos,t.extra.endFenceEndpos=e.startpos+e.captures[0].length-1,this.pos=e.endpos,this.finishedLine=!0,!1)},open:t=>{const e=this.find(f);if(e){const[s,n,i]=e.captures,a="="===i.charAt(0),o=(0,r.pattern)("("+s+s.substring(0,1)+"*)[ \\t]*[\\r\\n]");if(this.addContainer(new v(t,{closePattern:o})).indent=this.indent,this.addMatch(e.startpos,e.startpos+s.length-1,"+code_block"),i.length>0){const t=e.startpos+s.length+n.length;a?this.addMatch(t,t+i.length-1,"raw_format"):this.addMatch(t,t+i.length-1,"code_language")}return this.pos=e.endpos,this.finishedLine=!0,!0}return!1},close:()=>{const t=this.containers.pop();if(!t)return;const e=t.extra.endFenceStartpos||this.pos,s=t.extra.endFenceEndpos||this.pos;this.addMatch(e,s,"-code_block"),e===s&&this.warn(new n.Warning("Unclosed code block",this.pos))}}]}find(t){return(0,r.find)(this.subject,t,this.pos)}tip(){return this.containers.length>=1?this.containers[this.containers.length-1]:null}addMatch(t,e,s){this.matches.push({startpos:Math.min(t,this.maxoffset),endpos:Math.min(e,this.maxoffset),annot:s})}getInlineMatches(){var t;const e=null===(t=this.tip())||void 0===t?void 0:t.inlineParser;if(e){let t;for(const s of e.getMatches())t&&"str"===t.annot&&"str"===s.annot&&s.startpos===t.endpos+1?this.matches[this.matches.length-1].endpos=s.endpos:this.matches.push(s),t=s}}closeUnmatchedContainers(){const t=this.lastMatchedContainer;let e=this.tip();for(;e&&this.containers.length-1>t;)e.close(),e=this.tip()}addContainer(t,e){e||this.closeUnmatchedContainers();let s=this.tip();for(;s&&s.content!==t.type;)s.close(),s=this.tip();return t.content===w.Inline&&(t.inlineParser=new a.InlineParser(this.subject,{warn:this.warn})),this.containers.push(t),t}skipSpace(){const t=this.subject;let e=this.pos;for(;32===(s=t.codePointAt(e))||9===s;)e++;var s;this.indent=e-this.startline,this.pos=e}getEol(){const t=this.subject;let e=this.pos;for(;10!==(s=t.codePointAt(e))&&13!==s;)e++;var s;this.starteol=e,13===t.codePointAt(e)&&10===t.codePointAt(e+1)?this.endeol=e+1:this.endeol=e}parseTableCell(){const t=new a.InlineParser(this.subject,{warn:this.warn});let e=!1;const s=this.pos-1;let n=s;for(this.skipSpace();!e;){const s=this.find(g);if(null===s){e=!1;break}{const i=s.endpos;"`"===this.subject.charAt(i)||t.inVerbatim()||"\\"===this.subject.charAt(i-1)?t.feed(this.pos,i):(t.feed(this.pos,i-1),n=i,e=!0),this.pos=i+1}}return e?{startpos:s,endpos:n,matches:t.getMatches()}:null}parseTableRow(t,e){const s=this.matches.length,n=this.pos;this.addMatch(t,t,"+row"),this.pos++;const i=[];let a=this.pos,o=!1;for(;!o;){const t=(0,r.find)(this.subject,b,a);if(null===t)break;{const[e,s,n]=t.captures;let r="separator_default";if(e.length>0&&s.length>0?r="separator_center":s.length>0?r="separator_right":e.length>0&&(r="separator_left"),i.push({startpos:t.startpos,endpos:t.endpos-n.length,annot:r}),a=t.endpos+1,a===this.starteol){o=!0;break}}}if(o){for(const t of i)this.addMatch(t.startpos,t.endpos,t.annot);return this.addMatch(this.starteol-1,this.starteol-1,"-row"),this.pos=this.starteol,this.finishedLine=!0,!0}for(;this.pos<=e;){const t=this.parseTableCell();if(null===t){for(this.pos=n;this.matches.length>s;)this.matches.pop();return!1}{this.addMatch(t.startpos,t.startpos,"+cell");const e=t.matches;e.forEach(((t,s)=>{const n=t.startpos;let i=t.endpos;if(s===e.length-1&&"str"===t.annot)for(;32===this.subject.codePointAt(i)&&i>=n;)i-=1;this.addMatch(n,i,t.annot)})),this.addMatch(t.endpos,t.endpos,"-cell")}}return this.addMatch(this.pos,this.pos,"-row"),this.pos=this.starteol,this.finishedLine=!0,!0}[Symbol.iterator](){const t=this.specs,e=this.subject.length;this.returned=0;const s=this;return{next(){for(;s.pos<e;){if(s.matches.length>0&&s.returned<s.matches.length)return s.returned=s.returned+1,{value:s.matches[s.returned-1],done:!1};s.indent=0,s.startline=s.pos,s.finishedLine=!1,s.getEol(),s.lastMatchedContainer=-1;let e=0;for(;e<s.containers.length;){const t=s.containers[e];if(s.skipSpace(),!t.continue(t))break;s.lastMatchedContainer=e,e+=1}if(s.finishedLine)for(;s.containers.length>0&&s.lastMatchedContainer<s.containers.length-1;){const t=s.tip();t&&t.close()}if(!s.finishedLine){s.skipSpace();let e=s.pos===s.starteol,n=!1,i=s.containers[s.lastMatchedContainer],r=!(e||i&&i.content!==w.Block&&i.content!==w.ListItem||s.find(l));for(;r;){r=!1;for(const e of t)if((!i&&e.type===w.Block||i&&i.content===e.type)&&e.open(e)){if(!s.tip())throw new Error("No tip after opening container");s.lastMatchedContainer=s.containers.length-1,i=s.containers[s.lastMatchedContainer],s.finishedLine?r=!1:(s.skipSpace(),n=!0,r=e.content===w.Block||e.content===w.ListItem);break}}if(!s.finishedLine){s.skipSpace(),e=s.pos===s.starteol;let t=s.tip();if(!e&&!n&&s.lastMatchedContainer<s.containers.length-1&&t&&t.content===w.Inline||s.closeUnmatchedContainers(),t=s.tip(),t&&t.content!==w.Block||(e?n||s.addMatch(s.pos,s.endeol,"blankline"):(s.paraSpec.open(s.paraSpec),t=s.tip(),t&&(t.inlineParser=new a.InlineParser(s.subject,s.options)))),t&&t.content===w.Text){let e=s.pos;null!==t.indent&&s.indent>t.indent&&(e-=s.indent-t.indent),s.addMatch(e,s.endeol,"str")}else t&&t.content===w.Inline&&!e&&t.inlineParser&&t.inlineParser.feed(s.pos,s.endeol)}}s.pos=(s.endeol||s.pos)+1}return s.lastMatchedContainer=-1,s.closeUnmatchedContainers(),s.matches.length>0&&s.returned<s.matches.length?(s.returned=s.returned+1,{value:s.matches[s.returned-1],done:!1}):{value:{startpos:s.pos,endpos:s.pos,annot:""},done:!0}}}}}e.parseEvents=function(t,e={}){return new S(t,e)}},423:(t,e,s)=>{Object.defineProperty(e,"__esModule",{value:!0}),e.renderDjot=void 0;const n=s(60),i=s(306),r=function(t){const e=t.tag;return"space"===e||"soft_break"===e||"hard_break"===e},a=function(t,e){const s=t.text.match(/(`+)/g),n={};if(s)for(const t in s)n[s[t].length]=!0;let i=e;for(;n[i];)i++;return"`".repeat(i)},o=function(t){if(t<0||t>=4e3)return"?";let e="";for(;t>0;)if(t>=1e3)e+="M",t-=1e3;else if(t>=900)e+="CM",t-=900;else if(t>=500)e+="D",t-=500;else if(t>=400)e+="CD",t-=400;else if(t>=100)e+="C",t-=100;else if(t>=90)e+="XC",t-=90;else if(t>=50)e+="L",t-=50;else if(t>=40)e+="XL",t-=40;else if(t>=10)e+="X",t-=10;else if(9==t)e+="IX",t-=9;else if(t>=5)e+="V",t-=5;else if(4==t)e+="IV",t-=4;else{if(!(t>=1))throw new Error("toRoman encountered x = "+t);e+="I",t-=1}return e},c=function(t,e){const s=e.replace(/[a-zA-Z0-9]+/g,"$");let n;switch(e.replace(/[.()]/g,"")){case"1":n=t.toString();break;case"a":n=String.fromCodePoint(96+t%26);break;case"A":n=String.fromCodePoint(64+t%26);break;case"i":n=o(t).toLowerCase();break;case"I":n=o(t);break;default:throw new Error("formatNumber encountered unknown style "+e)}return s.replace("$",n)};class l{constructor(t,e={}){this.prefixes=[],this.buffer=[],this.startOfLine=!0,this.endOfPrefix=0,this.column=0,this.needsBlankLine=!1,this.handlers={doc:t=>{this.renderChildren(t.children),this.prefixes=[],this.cr(),Object.keys(t.references).length>0&&(this.cr(),this.newline());for(const e in t.references)this.renderNode(t.references[e]);Object.keys(t.footnotes).length;for(const e in t.footnotes)this.renderNode(t.footnotes[e]);this.prefixes=[],this.cr()},footnote:t=>{this.lit("[^"+t.label+"]:"),this.space(),this.needsBlankLine=!1,this.prefixes.push("  "),this.renderChildren(t.children),this.prefixes.pop(),this.blankline()},reference:t=>{this.lit("["),this.lit(t.label),this.lit("]:"),this.prefixes.push("  "),this.space(),this.lit(t.destination),this.wrap(),this.prefixes.pop(),this.blankline()},para:t=>{this.renderChildren(t.children),this.blankline()},thematic_break:()=>{this.lit("* * * * *"),this.blankline()},div:t=>{this.lit(":::"),this.cr(),this.renderChildren(t.children),this.cr(),this.lit(":::"),this.blankline()},heading:t=>{const e="#".repeat(t.level);this.lit(e+" "),this.prefixes.push(e+" "),this.renderChildren(t.children),this.prefixes.pop(),this.blankline()},block_quote:t=>{this.prefixes.push("> "),this.lit("> "),this.renderChildren(t.children),this.prefixes.pop(),this.blankline()},section:t=>{this.renderChildren(t.children)},code_block:t=>{const e=a(t,3);this.lit(e),t.lang&&this.lit(" "+t.lang),this.cr(),this.litlines(t.text),this.cr(),this.lit(e),this.blankline()},raw_block:t=>{const e=a(t,3);this.lit(e),this.lit(" ="+t.format),this.cr(),this.litlines(t.text),this.cr(),this.lit(e),this.blankline()},definition_list:t=>{const e=t.children;for(let t=0;t<e.length;t++){const s=e[t];t>0&&this.newline(),this.lit(":"),this.needsBlankLine=!1,this.space(),this.prefixes.push(" ".repeat(2)),this.renderChildren(s.children),this.prefixes.pop()}},ordered_list:t=>{const e=t.style,s=t.start||1,n=t.children,i=t.tight;for(let t=0;t<n.length;t++){const r=n[t];t>0&&(this.cr(),i||this.newline());const a=c(s+t,e);this.lit(a),this.needsBlankLine=!1,this.space(),this.prefixes.push(" ".repeat(a.length+1)),this.renderChildren(r.children),this.prefixes.pop()}i&&this.blankline()},bullet_list:t=>{const e=t.children,s=t.tight;for(let n=0;n<e.length;n++){const i=e[n];n>0&&(this.cr(),s||this.newline());const r=t.style;this.lit(r),this.needsBlankLine=!1,this.space(),this.prefixes.push(" ".repeat(r.length+1)),this.renderChildren(i.children),this.prefixes.pop()}s&&this.blankline()},task_list:t=>{const e=t.children,s=t.tight;for(let t=0;t<e.length;t++){const n=e[t];t>0&&(this.cr(),s||this.newline()),this.needsBlankLine=!1,this.lit(`- [${"checked"===n.checkbox?"X":" "}]`),this.space(),this.prefixes.push(" ".repeat(2)),this.renderChildren(n.children),this.prefixes.pop()}s&&this.blankline()},term:t=>{this.renderChildren(t.children),this.blankline()},definition:t=>{this.renderChildren(t.children)},table:t=>{const e=t.children.filter(n.isCaption),s=t.children.filter(n.isRow);for(let t=0;t<s.length;t++){const e=s[t];if("head"in e&&!e.head&&t>0&&s[t-1].head){const e=s[t-1];for(let t=0;t<e.children.length;t++){switch(0===t&&this.lit("|"),e&&e.children[t].align){case"left":this.lit(":--");break;case"right":this.lit("--:");break;case"center":this.lit(":-:");break;default:this.lit("---")}this.lit("|")}this.cr()}for(let t=0;t<e.children.length;t++){const s=e.children[t];0===t&&this.lit("|"),this.noWrap((()=>{"cell"===s.tag&&this.renderChildren(s.children)})),this.lit("|")}this.cr()}e.length>0&&e[0].children.length>0&&(this.newline(),this.lit("^ "),this.needsBlankLine=!1,this.prefixes.push("  "),this.renderChildren(e[0].children),this.prefixes.pop(),this.blankline()),this.blankline()},str:t=>{t.text.split(/  */).forEach(((t,e)=>{e>0&&this.space(),this.out(t)}))},space:()=>{this.space()},soft_break:()=>{this.soft_break()},smart_punctuation:t=>{this.lit(t.text)},non_breaking_space:()=>{this.lit("\\ ")},single_quoted:this.inlineContainer("'"),double_quoted:this.inlineContainer('"'),emph:this.inlineContainer("_"),strong:this.inlineContainer("*"),superscript:this.inlineContainer("^"),subscript:this.inlineContainer("~"),mark:this.inlineContainer("=",!0),delete:this.inlineContainer("-",!0),insert:this.inlineContainer("+",!0),footnote_reference:t=>{this.lit("[^"+t.text+"]")},symb:t=>{this.lit(":"+t.alias+":")},email:t=>{this.lit("<"+t.text+">")},url:t=>{this.lit("<"+t.text+">")},link:t=>{this.lit("["),this.renderChildren(t.children),this.lit("]"),t.reference?(this.lit("["),t.reference!==(0,i.getStringContent)(t)&&this.lit(t.reference),this.lit("]")):t.destination?(this.lit("("),this.lit(t.destination),this.lit(")")):this.lit("()")},image:t=>{this.lit("!["),this.renderChildren(t.children),this.lit("]"),t.reference?(this.lit("["),t.reference!==(0,i.getStringContent)(t)&&this.lit(t.reference),this.lit("]")):t.destination?(this.lit("("),this.lit(t.destination),this.lit(")")):this.lit("()")},raw_inline:t=>{this.verbatimNode(t),this.lit("{="+t.format+"}")},verbatim:t=>{this.verbatimNode(t)},inline_math:t=>{this.lit("$"),this.verbatimNode(t)},display_math:t=>{this.lit("$$"),this.verbatimNode(t)}},this.doc=t,this.wrapWidth=(null==e?void 0:e.wrapWidth)||0}escape(t){return t=t.replace(/([~`'"${}[\]^<>\\*_]|-(?=-)|!(=\[)|\.(?=\.))/g,"\\$1"),0!==this.column&&this.column!==this.endOfPrefix||(t=t.replace(/^#/,"\\#")),t}out(t){this.lit(this.escape(t))}doBlankLines(){this.needsBlankLine&&(this.cr(),this.newline(),this.needsBlankLine=!1)}lit(t){this.buffer.push(t),this.column+=t.length,this.startOfLine=!1}blankline(){this.needsBlankLine=!0}newline(){if(this.endOfPrefix===this.column)for(;/  *$|^$/.test(this.buffer[this.buffer.length-1]);)this.buffer[this.buffer.length-1]=this.buffer[this.buffer.length-1].replace(/  *$/,""),""===this.buffer[this.buffer.length-1]&&this.buffer.pop();if(this.endOfPrefix=0,this.column=0,this.buffer.push("\n"),this.prefixes.length>0){for(let t=0,e=this.prefixes.length;t<e;t++)this.buffer.push(this.prefixes[t]),this.column+=this.prefixes[t].length;this.endOfPrefix=this.column}this.startOfLine=!0}cr(){this.startOfLine||this.newline()}wrap(){if(this.wrapWidth<=0)return;let t=this.buffer.length-1;if(!this.startOfLine&&this.buffer.length>0&&this.column>this.wrapWidth){let e;for(;t>=0&&(e=this.buffer[t]," "!==e);){if(/^[ \r\n]+$/.test(e))return;t--}}if(t<this.buffer.length-1){const e=this.buffer.splice(t+1);" "===this.buffer[this.buffer.length-1]&&this.buffer.pop(),this.newline(),this.startOfLine=!0;for(let t=0;t<e.length;t++)this.buffer.push(e[t]),this.column+=e[t].length,this.startOfLine=!1}}space(){this.wrap(),this.lit(" ")}soft_break(){0===this.wrapWidth?this.newline():this.space()}needsBraces(t){return function(t){return t.children[0]&&r(t.children[0])}(t)||function(t){return t.children[0]&&r(t.children[t.children.length-1])}(t)||this.buffer.length>0&&/\w$/.test(this.buffer[this.buffer.length-1])}noWrap(t){const e=this.wrapWidth;this.wrapWidth=-1,t(),this.wrapWidth=e}inlineContainer(t,e){const s=this;return function(n){(e=e||s.needsBraces(n))&&s.lit("{"),s.lit(t),s.renderChildren(n.children),s.lit(t),e&&s.lit("}")}}litlines(t){const e=t.split(/\r?\n/);""===e[e.length-1]&&e.pop();for(const t of e)this.lit(t),this.cr()}verbatimNode(t){const e=a(t,1);this.lit(e),/^`/.test(t.text)&&this.lit(" "),this.lit(t.text),/`$/.test(t.text)&&this.lit(" "),this.lit(e)}renderChildren(t){for(let e=0,s=t.length;e<s;e++)this.renderNode(t[e]);t[0]&&!(0,n.isBlock)(t[0])&&this.wrap()}renderNode(t){this.doBlankLines();const e=this.handlers[t.tag];if(!e)throw new Error("No renderer defined for node type "+t.tag);"attributes"in t&&(0,n.isBlock)(t)&&(this.renderAttributes(t),this.cr()),e(t),"attributes"in t&&(0,n.isInline)(t)&&this.renderAttributes(t)}renderAttributes(t){if(!t.attributes||0===Object.keys(t.attributes).length)return;const e=t.attributes;this.lit("{");let s=!0;(0,n.isBlock)(t)&&this.prefixes.push(" ");for(const t in e){if(s||this.space(),"id"===t)this.lit("#"),this.lit(e[t]);else if("class"===t){const s=e[t].split(/  */);for(let t=0;t<s.length;t++)t>0&&this.space(),this.lit("."),this.lit(s[t])}else this.lit(t),this.lit('="'),this.out(e[t]),this.lit('"');s=!1}(0,n.isBlock)(t)&&this.prefixes.pop(),this.lit("}")}render(){return this.renderNode(this.doc),this.buffer.join("")}}e.renderDjot=function(t,e={}){return new l(t,e).render()}},322:(t,e)=>{Object.defineProperty(e,"__esModule",{value:!0}),e.applyFilter=void 0;class s{constructor(t){this.finished=!1,this.stack=[],this.enter=!0,this.top=t,this.current=t}walk(t){for(;!this.finished;){t(this);const e=this.stack&&this.stack[this.stack.length-1];if(this.enter=this.enter&&"children"in this.current,this.enter)"children"in this.current&&this.current.children.length>0?(this.stack.push({node:this.current,childIndex:0}),this.current=this.current.children[0],this.enter=!0):this.enter=!1;else if(e){e.childIndex++;const t=e.node.children[e.childIndex];t?(this.current=t,this.enter=!0):(this.stack.pop(),this.current=e.node,this.enter=!1)}else this.finished=!0}}}const n=function(t,e){return new s(t).walk((t=>{let s=function(t,e,s){if(!t||!t.tag)throw new Error("Filter called on a non-node.");const n=s[t.tag];if(!n)return!1;if(e&&"enter"in n){const e=n.enter;return!!e&&e(t)}{let e;if(e="exit"in n&&n.exit?n.exit:"enter"in n&&n.enter?n.enter:n,"function"==typeof e)return e(t)}}(t.current,t.enter,e);const n=t.stack[t.stack.length-1];if("object"==typeof s&&"stop"in s&&s.stop&&(s=s.stop,t.enter=!1),s)if(Array.isArray(s)){if(!n)throw Error("Cannot replace top node with multiple nodes");n.node.children.splice(n.childIndex,1,...s),t.current=n.node.children[n.childIndex],s.length>1&&(n.childIndex+=s.length-1)}else if("object"==typeof s&&"tag"in s&&s.tag){if(!n)return s;n.node.children[n.childIndex]=s}})),t};e.applyFilter=function(t,e){const s=e();let i;i=Array.isArray(s)?s:[s];for(const e of i){n(t,e);for(const s in t.footnotes)n(t.footnotes[s],e);for(const s in t.references)n(t.references[s],e)}}},481:(t,e)=>{Object.defineProperty(e,"__esModule",{value:!0}),e.find=e.pattern=void 0,e.pattern=function(t){return new RegExp(t,"yd")},e.find=function(t,e,s,n){let i;e.lastIndex=s,i=void 0!==n?t.substring(0,n+1):t;const r=e.exec(i);if(null!==r){const t=[];if(r.indices.length>1)for(let e=1;e<r.indices.length;e++){const[s,n]=r.indices[e];t.push(i.substring(s,n))}return{startpos:r.indices[0][0],endpos:r.indices[0][1]-1,captures:t}}return null}},240:(t,e,s)=>{Object.defineProperty(e,"__esModule",{value:!0}),e.HTMLRenderer=e.renderHTML=void 0;const n=s(306),i=s(380),r=/[&<>]/,a=/[&<>"]/;class o{constructor(t){this.smartPunctuationMap={right_single_quote:"’",left_single_quote:"‘",right_double_quote:"”",left_double_quote:"“",ellipses:"…",em_dash:"—",en_dash:"–"},this.warn=t.warn||(()=>{}),this.options=t||{},this.tight=!1,this.footnoteIndex={},this.nextFootnoteIndex=1,this.references={}}escape(t){return r.test(t)?t.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;"):t}escapeAttribute(t){return a.test(t)?t.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;"):t}renderAttributes(t,e){let s="";if(e)for(const n in e)if("class"===n){let i=e[n];t.attributes&&t.attributes.class&&(i=`${i} ${t.attributes.class}`),s+=` ${n}="${this.escapeAttribute(i)}"`}else s+=` ${n}="${this.escapeAttribute(e[n])}"`;if(t.attributes)for(const n in t.attributes){const i=t.attributes[n];"class"===n&&e&&e.class||(s+=` ${n}="${this.escapeAttribute(i)}"`)}if(t.pos){const e=t.pos.start,n=t.pos.end;s+=` data-startpos="${e.line}:${e.col}:${e.offset}" data-endpos="${n.line}:${n.col}:${n.offset}"`}return s}renderTag(t,e,s){let n="";return("attributes"in e||s||e.pos)&&(n=this.renderAttributes(e,s)),`<${t}${n}>`}renderCloseTag(t){return`</${t}>`}inTags(t,e,s,n){const i=s>=2?"\n":"",r=s>=1?"\n":"";return`${this.renderTag(t,e,n)}${i}${this.renderChildren(e)}</${t}>${r}`}addBacklink(t,e){const s=`<a href="#fnref${e}" role="doc-backlink">↩︎︎</a>`;return/\<\/p\>[\r\n]*$/.test(t)?t.replace(/\<\/p\>([\r\n]*)$/,s+"</p>$1"):t+`<p>${s}</p>\n`}renderChildren(t){let e="";const s=this.tight;"tight"in t&&(this.tight=!!t.tight);for(const s of t.children)e+=this.renderAstNode(s);return"tight"in t&&(this.tight=s),e}renderAstNode(t){var e;const s=null===(e=this.options.overrides)||void 0===e?void 0:e[t.tag];return s?s(t,this):this.renderAstNodeDefault(t)}renderNotes(t){let e="";const s=[],n={};for(const e in t)n[e]=this.renderChildren(t[e]);for(const t in this.footnoteIndex){const e=this.footnoteIndex[t];e&&(s[e]=n[t])}e+='<section role="doc-endnotes">\n<hr>\n<ol>\n';for(let t=1;t<s.length;t++){const n=s[t]||"";e+=`<li id="fn${t}">\n`,e+=this.addBacklink(n,t),e+="</li>\n"}return e+="</ol>\n</section>\n",e}renderAstNodeDefault(t){var e;switch(t.tag){case"doc":{let e="";return e+=this.renderChildren(t),this.nextFootnoteIndex>1&&(e+=this.renderNotes(t.footnotes)),e}case"para":return this.tight?`${this.renderChildren(t)}\n`:this.inTags("p",t,1);case"block_quote":return this.inTags("blockquote",t,2);case"div":return this.inTags("div",t,2);case"section":return this.inTags("section",t,2);case"list_item":return this.inTags("li",t,2);case"task_list_item":return this.inTags("li",t,2,{class:"checked"===t.checkbox?"checked":"unchecked"});case"definition_list_item":return this.renderChildren(t);case"definition":return this.inTags("dd",t,2);case"term":return this.inTags("dt",t,1);case"definition_list":return this.inTags("dl",t,2);case"bullet_list":return this.inTags("ul",t,2);case"task_list":return this.inTags("ul",t,2,{class:"task-list"});case"ordered_list":{const e={};return t.start&&1!==t.start&&(e.start=t.start.toString()),t.style&&!/1/.test(t.style)&&(e.type=t.style.replace(/[().]/g,"")),this.inTags("ol",t,2,e)}case"heading":return this.inTags(`h${t.level}`,t,1);case"footnote_reference":{let e="";const s=t.text;let n=this.footnoteIndex[s];return n||(n=this.nextFootnoteIndex,this.footnoteIndex[s]=n,this.nextFootnoteIndex++),e+=this.renderTag("a",t,{id:"fnref"+n,href:"#fn"+n,role:"doc-noteref"}),e+="<sup>",e+=this.escape(n.toString()),e+="</sup></a>",e}case"table":return this.inTags("table",t,2);case"caption":{let e="";return t.children.length>0&&(e+=this.inTags("caption",t,1)),e}case"row":return this.inTags("tr",t,2);case"cell":{const e={};return t.align&&"default"!==t.align&&(e.style=`text-align: ${t.align};`),this.inTags(t.head?"th":"td",t,1,e)}case"thematic_break":{let e="";return e+=this.renderTag("hr",t),e+="\n",e}case"code_block":{let e="";return e+=this.renderTag("pre",t),e+="<code",t.lang&&(e+=` class="language-${this.escapeAttribute(t.lang)}"`),e+=">",e+=this.escape(t.text),e+=this.renderCloseTag("code"),e+=this.renderCloseTag("pre"),e+="\n",e}case"raw_block":{let e="";return"html"===t.format&&(e+=t.text),e}case"str":return t.attributes?`${this.renderTag("span",t)}${this.escape(t.text)}</span>`:this.escape(t.text);case"smart_punctuation":return this.smartPunctuationMap[t.type]||t.text;case"double_quoted":{let e="";return e+=this.smartPunctuationMap.left_double_quote||'"',e+=this.renderChildren(t),e+=this.smartPunctuationMap.right_double_quote||'"',e}case"single_quoted":{let e="";return e+=this.smartPunctuationMap.left_single_quote||"'",e+=this.renderChildren(t),e+=this.smartPunctuationMap.right_single_quote||"'",e}case"symb":return this.escape(`:${t.alias}:`);case"inline_math":{let e="";return e+=this.renderTag("span",t,{class:"math inline"}),e+=`\\(${this.escape(t.text)}\\)`,e+=this.renderCloseTag("span"),e}case"display_math":{let e="";return e+=this.renderTag("span",t,{class:"math display"}),e+=`\\[${this.escape(t.text)}\\]`,e+=this.renderCloseTag("span"),e}case"verbatim":{let e="";return e+=this.renderTag("code",t),e+=this.escape(t.text),e+=this.renderCloseTag("code"),e}case"raw_inline":{let e="";return"html"===t.format&&(e+=t.text),e}case"soft_break":return"\n";case"hard_break":return"<br>\n";case"non_breaking_space":return"&nbsp;";case"link":case"image":{const s={};let r=t.destination;if(t.reference){const a=this.references[t.reference];if(a){if(r=a.destination,"image"===t.tag?(s.alt=(0,n.getStringContent)(t),s.src=r):s.href=r,a.attributes)for(const e in a.attributes)t.attributes&&t.attributes[e]||(s[e]=a.attributes[e])}else this.warn(new i.Warning(`Reference ${JSON.stringify(t.reference)} not found`,null===(e=null==t?void 0:t.pos)||void 0===e?void 0:e.end))}else"image"===t.tag?(s.alt=(0,n.getStringContent)(t),void 0!==r&&(s.src=r)):void 0!==r&&(s.href=r);return"image"===t.tag?this.renderTag("img",t,s):this.inTags("a",t,0,s)}case"url":case"email":{let e="";const s={};return"email"===t.tag?s.href="mailto:"+t.text:s.href=t.text,e+=this.renderTag("a",t,s),e+=this.escape(t.text),e+=this.renderCloseTag("a"),e}case"strong":return this.inTags("strong",t,0);case"emph":return this.inTags("em",t,0);case"span":return this.inTags("span",t,0);case"mark":return this.inTags("mark",t,0);case"insert":return this.inTags("ins",t,0);case"delete":return this.inTags("del",t,0);case"superscript":return this.inTags("sup",t,0);case"subscript":return this.inTags("sub",t,0);default:return""}}render(t){return this.references=t.references,this.renderAstNode(t)}}e.HTMLRenderer=o,e.renderHTML=function(t,e={}){return new o(e).render(t)}},418:(t,e,s)=>{Object.defineProperty(e,"__esModule",{value:!0}),e.InlineParser=void 0;const n=s(722),i=s(380),r=s(481),a=123,o=125,c=/[\r\n"'()*+.:<=[\\\]^_`${}~-]/g,l=function(t,e,s){c.lastIndex=e;const n=c.exec(t);return n&&n.index<=s?n.index:null},h=(0,r.pattern)("[^ \t\r\n]"),d=(0,r.pattern)("[ \\t]*\\r?\\n"),u=(0,r.pattern)("['!\"#$%&\\\\'()\\*+,\\-\\.\\/:;<=>?@\\[\\]\\^_`{|}~']"),p=(0,r.pattern)("\\<([^<>\\s]+)\\>"),f=(0,r.pattern)("[_*~^+='\"-]"),b=(0,r.pattern)(":[\\w_+-]+:"),g=(0,r.pattern)("\\.\\."),m=(0,r.pattern)("`*"),_=(0,r.pattern)("`+"),k=(0,r.pattern)("\\$\\$"),N=(0,r.pattern)("\\$"),x=(0,r.pattern)("\\\\"),C=(0,r.pattern)("\\{=[^\\s{}`]+\\}"),A=(0,r.pattern)("\\^([^\\]]+)\\]"),P=function(t,e){return e>0&&t.subject.codePointAt(e-1)===a||t.subject.codePointAt(e+1)===o},I=function(){return!0},M=function(t,e,s,n){return function(i,a,c){const l=i.subject;let d=null!==(0,r.find)(l,h,a+1)&&n(i,a),u=null!==(0,r.find)(l,h,a-1);const p=i.matches[i.matches.length-1],f=p&&"open_marker"===p.annot,b=a+1<=c&&l.codePointAt(a+1)===o;let g=a,m=a;f&&(d=!0,u=!1,m=a-1),!f&&b&&(u=!0,d=!1,g=a+1),f&&s.match(/^right/)?s=s.replace(/^right/,"left"):b&&s.match(/^left/)&&(s=s.replace(/^left/,"right"));let _=t;b&&(_="{"+_);const k=i.openers[_];if(u&&k&&k.length>0){const t=k[k.length-1];if(t.endpos!==a-1)return i.clearOpeners(t.startpos,a),i.addMatch(t.startpos,t.endpos,"+"+e,t.matchIndex),i.addMatch(a,g,"-"+e),g+1}if(d){let e=t;return f&&(e="{"+e),i.addOpener(e,m,a,s),a+1}return i.addMatch(a,g,s),g+1}},w={96:function(t,e,s){const n=t.subject,i=(0,r.find)(n,m,e,s);if(null===i)return null;const a=i.endpos;return(0,r.find)(n,k,e-2)&&!(0,r.find)(n,x,e-3)?(t.matches.pop(),t.matches.pop(),t.addMatch(e-2,a,"+display_math"),t.verbatimType="display_math"):(0,r.find)(n,N,e-1)?(t.matches.pop(),t.addMatch(e-1,a,"+inline_math"),t.verbatimType="inline_math"):(t.addMatch(e,a,"+verbatim"),t.verbatimType="verbatim"),t.verbatim=a-e+1,a+1},92:function(t,e,s){const n=t.subject,i=(0,r.find)(n,d,e+1,s);if(null!==i){if(t.matches.length>0){const e=t.matches[t.matches.length-1];if("str"===e.annot){let s=e.endpos;const i=e.startpos;for(;s>=i&&(32===n.codePointAt(s)||9===n.codePointAt(s));)s-=1;s<i?t.matches.pop():e.endpos=s}}return t.addMatch(e,e,"escape"),t.addMatch(e+1,i.endpos,"hard_break"),i.endpos+1}{const i=(0,r.find)(n,u,e+1,s);return null!==i?(t.addMatch(e,e,"escape"),t.addMatch(i.startpos,i.endpos,"str"),i.endpos+1):e+1<=s&&32===n.codePointAt(e+1)?(t.addMatch(e,e,"escape"),t.addMatch(e+1,e+1,"non_breaking_space"),e+2):(t.addMatch(e,e,"str"),e+1)}},60:function(t,e,s){const n=t.subject,i=(0,r.find)(n,p,e,s);if(null===i)return null;const a=i.endpos,o=i.startpos,c=i.captures[0];return c.match(/[^:]@/)?(t.addMatch(o,o,"+email"),t.addMatch(o+1,a-1,"str"),t.addMatch(a,a,"-email"),a+1):c.match(/[a-zA-Z]:/)?(t.addMatch(o,o,"+url"),t.addMatch(o+1,a-1,"str"),t.addMatch(a,a,"-url"),a+1):null},126:M("~","subscript","str",I),94:M("^","superscript","str",I),95:M("_","emph","str",I),42:M("*","strong","str",I),43:M("+","insert","str",P),61:M("=","mark","str",P),39:M("'","single_quoted","right_single_quote",(function(t,e){if(0===e)return!0;{const s=t.subject.codePointAt(e-1);return 32===s||9===s||13===s||10===s||34===s||39===s||45===s||40===s||91===s}})),34:M('"',"double_quoted","left_double_quote",I),[a]:function(t,e,s){return(0,r.find)(t.subject,f,e+1,s)?(t.addMatch(e,e,"open_marker"),e+1):t.allowAttributes?(t.attributeParser=new n.AttributeParser(t.subject),t.attributeStart=e,t.attributeSlices=[],e):(t.addMatch(e,e,"str"),e+1)},58:function(t,e,s){const n=(0,r.find)(t.subject,b,e,s);return n?(t.addMatch(n.startpos,n.endpos,"symb"),n.endpos+1):(t.addMatch(e,e,"str"),e+1)},46:function(t,e,s){return(0,r.find)(t.subject,g,e+1,s)?(t.addMatch(e,e+2,"ellipses"),e+3):null},91:function(t,e,s){const n=(0,r.find)(t.subject,A,e+1,s);return n?(t.addMatch(e,n.endpos,"footnote_reference"),n.endpos+1):(t.addOpener("[",e,e,"str"),e+1)},93:function(t,e,s){const n=t.openers["["],i=t.subject;if(n&&n.length>0){const r=n[n.length-1];if("reference_link"===r.annot)return t.strMatches((r.subendpos||r.endpos)+1,e-1),33===i.codePointAt(r.startpos-1)&&92!==i.codePointAt(r.startpos-2)?(t.addMatch(r.startpos-1,r.startpos-1,"image_marker",r.matchIndex-1),t.addMatch(r.startpos,r.endpos,"+imagetext",r.matchIndex),t.addMatch(r.substartpos||r.startpos,r.substartpos||r.startpos,"-imagetext",r.subMatchIndex)):(t.addMatch(r.startpos,r.endpos,"+linktext",r.matchIndex),t.addMatch(r.substartpos||r.startpos,r.substartpos||r.startpos,"-linktext",r.subMatchIndex)),t.addMatch(r.subendpos||r.endpos,r.subendpos||r.endpos,"+reference",r.subMatchIndex+1),t.addMatch(e,e,"-reference"),t.clearOpeners(r.startpos,e),e+1;if(e+1<=s&&91===i.codePointAt(e+1))return r.annot="reference_link",t.addMatch(e,e,"str"),r.subMatchIndex=t.matches.length-1,t.addMatch(e+1,e+1,"str"),r.substartpos=e,r.subendpos=e+1,t.clearOpeners(r.startpos+1,e-1),e+2;if(e+1<=s&&40===i.codePointAt(e+1))return t.openers["("]=[],r.annot="explicit_link",t.addMatch(e,e,"str"),r.subMatchIndex=t.matches.length-1,t.addMatch(e+1,e+1,"str"),r.substartpos=e,r.subendpos=e+1,t.destination=!0,t.clearOpeners(r.startpos+1,e-1),e+2;if(e+1<=s&&i.codePointAt(e+1)===a)return t.addMatch(r.startpos,r.endpos,"+span",r.matchIndex),t.addMatch(e,e,"-span"),t.clearOpeners(r.startpos,e),e+1}return null},40:function(t,e,s){return t.destination?(t.addOpener("(",e,e,"str"),e+1):null},41:function(t,e,s){if(!t.destination)return null;const n=t.openers["("];if(n&&n.length>0)return n.pop(),t.addMatch(e,e,"str"),e+1;{const s=t.subject,n=t.openers["["],i=n[n.length-1];if(n&&n.length>0&&"explicit_link"===i.annot)return t.strMatches((i.subendpos||i.endpos)+1,e-1),33===s.codePointAt(i.startpos-1)&&92!==s.codePointAt(i.startpos-2)?(t.addMatch(i.startpos-1,i.startpos-1,"image_marker",i.matchIndex-1),t.addMatch(i.startpos,i.endpos,"+imagetext",i.matchIndex),t.addMatch(i.substartpos||i.startpos,i.substartpos||i.startpos,"-imagetext",i.subMatchIndex)):(t.addMatch(i.startpos,i.endpos,"+linktext",i.matchIndex),t.addMatch(i.substartpos||i.startpos,i.substartpos||i.startpos,"-linktext",i.subMatchIndex)),t.addMatch(i.subendpos||i.endpos,i.subendpos||i.endpos,"+destination",i.subMatchIndex+1),t.addMatch(e,e,"-destination"),t.destination=!1,t.clearOpeners(i.startpos,e),e+1}return null},45:function(t,e,s){const n=t.subject;if(n.codePointAt(e-1)===a||n.codePointAt(e+1)===o){const n=M("-","delete","str",P)(t,e,s);if(n)return n}let i=e,r=0;for(;i<=s&&45===n.codePointAt(i);)i++,r++;if(n.codePointAt(i)===o&&r--,0===r)return t.addMatch(e,e+1,"str"),e+2;const c=r%3==0,l=r%2==0;for(;r>0;)c?(t.addMatch(e,e+2,"em_dash"),e+=3,r-=3):l?(t.addMatch(e,e+1,"en_dash"),e+=2,r-=2):r>=3&&(r%2!=0||r>4)?(t.addMatch(e,e+2,"em_dash"),e+=3,r-=3):r>=2?(t.addMatch(e,e+1,"en_dash"),e+=2,r-=2):(t.addMatch(e,e,"str"),e+=1,r-=1);return e}};e.InlineParser=class{constructor(t,e={}){this.options=e,this.warn=e.warn||(()=>{}),this.subject=t,this.matches=[],this.openers={},this.verbatim=0,this.verbatimType="",this.destination=!1,this.firstpos=-1,this.lastpos=0,this.allowAttributes=!0,this.attributeParser=null,this.attributeStart=null,this.attributeSlices=null,this.matchers=w}addMatch(t,e,s,n){const i={startpos:t,endpos:e,annot:s};void 0!==n?this.matches.splice(n,1,i):this.matches.push(i)}inVerbatim(){return this.verbatim>0}singleChar(t){return this.addMatch(t,t,"str"),t+1}reparseAttributes(){const t=this.attributeSlices;if(null!==t){if(this.allowAttributes=!1,this.attributeParser=null,this.attributeStart=null,null!==t)for(const e of t)this.feed(e.startpos,e.endpos);this.allowAttributes=!0,this.attributeSlices=null}}getMatches(){const t=this.subject;this.attributeParser&&this.reparseAttributes();let e=this.matches.length-1;if(this.matches[e]&&"soft_break"===this.matches[e].annot){this.matches.pop();const e=this.matches[this.matches.length-1];if(e&&"str"===e.annot&&32===t.codePointAt(e.endpos)){for(;e.endpos>=e.startpos&&32===t.codePointAt(e.endpos);)e.endpos=e.endpos-1;e.endpos<e.startpos&&this.matches.pop()}}if(this.matches.length>0&&this.verbatim>0){const t=this.matches[this.matches.length-1];this.warn(new i.Warning("Unclosed verbatim",t.endpos)),this.matches.push({startpos:t.endpos,endpos:t.endpos,annot:"-"+this.verbatimType})}return this.matches}addOpener(t,e,s,n){this.openers[t]||(this.openers[t]=[]),this.openers[t].push({matchIndex:this.matches.length,startpos:e,endpos:s,annot:null,subMatchIndex:this.matches.length,substartpos:null,subendpos:null}),this.addMatch(e,s,n)}clearOpeners(t,e){for(const s in this.openers){const n=this.openers[s];let i=n.length-1;for(;n[i];){const s=n[i];if(s.startpos>=t&&s.endpos<=e)n.splice(i,1);else{if(!(s.substartpos&&s.substartpos>=t&&s.subendpos&&s.subendpos<=e))break;n[i].substartpos=null,n[i].subendpos=null,n[i].annot=null}i--}}}strMatches(t,e){let s=this.matches.length-1;for(;s>0&&this.matches[s].startpos>=t;)s--;for(this.matches[s].startpos<t&&s++;this.matches[s]&&this.matches[s].endpos<=e;){const t=this.matches[s];"escape"!==t.annot&&"str"!==t.annot&&(t.annot="str"),s++}}feed(t,e){const s=this.subject;(-1===this.firstpos||t<this.firstpos)&&(this.firstpos=t),(0===this.lastpos||e>this.lastpos)&&(this.lastpos=e);let n=t;for(;n<=e;)if(null!==this.attributeParser){const t=n,i=l(s,n,e);let r;r=null===i?e:i;const a=this.attributeParser.feed(t,r),o=a.position;if("done"===a.status){const t=this.attributeStart;null!==t&&this.addMatch(t,t,"+attributes");const e=this.attributeParser.matches;for(const t of e)this.addMatch(t.startpos,t.endpos,t.annot);this.addMatch(o,o,"-attributes"),this.attributeParser=null,this.attributeStart=null,this.attributeSlices=null,n=o+1}else"fail"===a.status?(this.reparseAttributes(),n=t):"continue"===a.status&&(null===this.attributeSlices&&(this.attributeSlices=[]),this.attributeSlices.push({startpos:t,endpos:o}),n=o+1)}else{const t=l(s,n,e);let i;if(i=null===t?e+1:t,i>n&&(this.addMatch(n,i-1,"str"),n=i,n>e))break;const a=s.codePointAt(n);if(void 0===a)throw new Error("Code point at "+n+" is undefined.");if(13===a||10===a)13===a&&10===s.codePointAt(n+1)&&n+1<=e?(this.addMatch(n,n+1,"soft_break"),n+=2):(this.addMatch(n,n,"soft_break"),n+=1);else if(this.verbatim>0)if(96===a){const t=(0,r.find)(s,_,n,e);if(t){const i=t.endpos;if(t.endpos-n+1===this.verbatim){const t=(0,r.find)(s,C,i+1,e);t&&"verbatim"===this.verbatimType?(this.addMatch(n,i,"-"+this.verbatimType),this.addMatch(t.startpos,t.endpos,"raw_format"),n=t.endpos+1):(this.addMatch(n,i,"-"+this.verbatimType),n=i+1),this.verbatim=0,this.verbatimType="verbatim"}else this.addMatch(n,i,"str"),n=i+1}else this.addMatch(n,e,"str"),n=e+1}else this.addMatch(n,n,"str"),n+=1;else{const t=this.matchers[a];if(t){const s=t(this,n,e);n=null===s?this.singleChar(n):s}else n=this.singleChar(n)}}}}},380:(t,e)=>{Object.defineProperty(e,"__esModule",{value:!0}),e.Warning=void 0,e.Warning=class{constructor(t,e){this.message=t,"number"==typeof e?this.offset=e:e&&"line"in e&&(this.sourceLoc=e,this.offset=e.offset)}render(){let t=this.message;return this.sourceLoc?t+=` at line ${this.sourceLoc.line}, col ${this.sourceLoc.col}`:this.offset&&(t+=` at offset ${this.offset}`),t}}},56:(t,e,s)=>{Object.defineProperty(e,"__esModule",{value:!0}),e.fromPandoc=e.toPandoc=void 0;const n=s(380),i={Decimal:{Period:"1.",OneParen:"1)",TwoParens:"(1)"},LowerAlpha:{Period:"a.",OneParen:"a)",TwoParens:"(a)"},UpperAlpha:{Period:"A.",OneParen:"A)",TwoParens:"(A)"},LowerRoman:{Period:"i.",OneParen:"i)",TwoParens:"(i)"},UpperRoman:{Period:"I.",OneParen:"I)",TwoParens:"(I)"}},r={};for(const t in i)for(const e in i[t])r[i[t][e]]=[t,e];const a=function(t){return"Para"===t.t&&(t.t="Plain"),t},o=function(t){if("attributes"in t&&t.attributes){const e=t.attributes.id||"",s=t.attributes.class&&t.attributes.class.split(" ")||[],n=[];for(const s in t.attributes)s!==e&&"class"!==s&&n.push([s,t.attributes[s]]);return[e,s,n]}return["",[],[]]};class c{constructor(t={}){this.references={},this.footnotes={},this.options=t,this.smartPunctuationMap=this.options.smartPunctuationMap||{non_breaking_space:" ",ellipses:"⋯",em_dash:"-",en_dash:"-",left_single_quote:"‘",right_single_quote:"’",left_double_quote:"“",right_double_quote:"”"},this.warn||(this.warn=()=>{})}toPandocChildren(t){if("children"in t){const e=[];return t.children.forEach((t=>{this.addToPandocElts(e,t)})),e}return[]}toPandocDefinitionListItem(t){const e=this;return function(t){if(!("children"in t))return[];const[s,n]=t.children;return[e.toPandocChildren(s),[e.toPandocChildren(n)]]}}toPandocListItem(t){const e=this;return function(s){let n=e.toPandocChildren(s);return"checkbox"in s&&s.checkbox&&"Para"===n[0].t&&("checked"===s.checkbox?n[0].c.unshift({t:"Str",c:"☒"},{t:"Space"}):n[0].c.unshift({t:"Str",c:"☐"},{t:"Space"})),"tight"in t&&t.tight&&(n=n.map(a)),n}}addToPandocElts(t,e){switch(e.tag){case"section":case"div":{const s=o(e);"section"===e.tag&&s[1].unshift("section"),t.push({t:"Div",c:[s,this.toPandocChildren(e)]});break}case"block_quote":t.push({t:"BlockQuote",c:this.toPandocChildren(e)});break;case"definition_list":{const s=e.children.map(this.toPandocDefinitionListItem(e));t.push({t:"DefinitionList",c:s});break}case"task_list":case"ordered_list":case"bullet_list":{let s;if(e.style&&"-"===e.style||"+"===e.style||"*"===e.style||"X"===e.style)s=e.children.map(this.toPandocListItem(e)),t.push({t:"BulletList",c:s});else{s=e.children.map(this.toPandocListItem(e));const[n,i]=r[e.style],a=e.start||1;t.push({t:"OrderedList",c:[[a,{t:n},{t:i}],s]})}break}case"task_list_item":case"list_item":break;case"para":t.push({t:"Para",c:this.toPandocChildren(e)});break;case"heading":t.push({t:"Header",c:[e.level,o(e),this.toPandocChildren(e)]});break;case"code_block":{const s=o(e);e.lang&&s[1].unshift(e.lang),t.push({t:"CodeBlock",c:[s,e.text]});break}case"raw_block":t.push({t:"RawBlock",c:[e.format,e.text]});break;case"thematic_break":t.push({t:"HorizontalRule"});break;case"table":{const s=o(e),n=["",[],[]];let i=[],r=[],a=[];const c=[],l=[n,[]];let h=[],d=[];const u={left:"AlignLeft",right:"AlignRight",center:"AlignCenter",default:"AlignDefault"},p=function(t){return[{t:u[t.align]||"AlignDefault"},{t:"ColWidthDefault"}]},f=this,b=function(t){if("children"in t)return[o(t),{t:"align"in t&&u[t.align]||"AlignDefault"},1,1,[{t:"Plain",c:f.toPandocChildren(t)}]]},g=function(t){if("children"in t)return[o(t),t.children.map(b)]};for(let t=0;t<e.children.length;t++){const s=e.children[t];if(!("children"in s))break;0===r.length&&(r=s.children.map(p)),"caption"===s.tag?s.children.length&&(i=this.toPandocChildren(s)):s.head?0===d.length?h.push(g(s)):(c.push([n,0,h,d]),d=[],h=[g(s)]):(0===c.length&&0===d.length&&(a=h,h=[]),d.push(g(s)))}(h.length>0||d.length>0)&&c.push([n,0,h,d]),t.push({t:"Table",c:[s,[null,[{t:"Plain",c:i}]],r,[n,a],c,l]});break}case"raw_inline":t.push({t:"RawInline",c:[e.format,e.text]});break;case"soft_break":t.push({t:"SoftBreak"});break;case"hard_break":t.push({t:"LineBreak"});break;case"str":e.text.split(/ +/).forEach(((e,s)=>{s>0&&t.push({t:"Space"}),e.length>0&&t.push({t:"Str",c:e})}));break;case"verbatim":t.push({t:"Code",c:[o(e),e.text]});break;case"inline_math":t.push({t:"Math",c:[{t:"InlineMath"},e.text]});break;case"display_math":t.push({t:"Math",c:[{t:"DisplayMath"},e.text]});break;case"non_breaking_space":t.push({t:"Str",c:" "});break;case"smart_punctuation":t.push({t:"Str",c:this.smartPunctuationMap[e.type]||e.text});break;case"symb":t.push({t:"Span",c:[["",["symbol"],[["alias",e.alias]]],[{t:"Str",c:":"+e.alias+":"}]]});break;case"single_quoted":case"double_quoted":{const s={t:"single_quoted"===e.tag?"SingleQuote":"DoubleQuote"};t.push({t:"Quoted",c:[s,this.toPandocChildren(e)]});break}case"email":case"url":{let s=e.text;"email"===e.tag&&(s="mailto:"+s);const n=o(e);n[1].unshift("email"===e.tag?"email":"uri"),t.push({t:"Link",c:[n,[{t:"Str",c:e.text}],[s,""]]});break}case"image":case"link":{let s=e.destination||"";const i={};if(e.reference){const t=this.references[e.reference];if(t){if(s=t.destination||"",t.attributes)for(const e in t.attributes)i[e]=t.attributes[e]}else this.warn(new n.Warning("Reference "+e.reference+" not found."))}if(e.attributes)for(const t in e.attributes)i[t]&&"class"===t?i[t]+=" "+e.attributes[t]:i[t]||(i[t]=e.attributes[t]);const r=o({tag:"link",attributes:i,children:[]}),a=s||"",c=e.attributes&&e.attributes.title||"";c&&(r[2]=r[2].filter((([t,e])=>"title"!==t))),t.push({t:"link"===e.tag?"Link":"Image",c:[r,this.toPandocChildren(e),[a,c]]});break}case"emph":t.push({t:"Emph",c:this.toPandocChildren(e)});break;case"strong":t.push({t:"Strong",c:this.toPandocChildren(e)});break;case"superscript":t.push({t:"Superscript",c:this.toPandocChildren(e)});break;case"subscript":t.push({t:"Subscript",c:this.toPandocChildren(e)});break;case"span":t.push({t:"Span",c:[o(e),this.toPandocChildren(e)]});break;case"mark":t.push({t:"Span",c:[["",["mark"],[]],this.toPandocChildren(e)]});break;case"insert":t.push({t:"Underline",c:this.toPandocChildren(e)});break;case"delete":t.push({t:"Strikeout",c:this.toPandocChildren(e)});break;case"footnote_reference":{const s=this.footnotes[e.text];s?t.push({t:"Note",c:this.toPandocChildren(s)}):t.push({t:"Superscript",c:[{t:"Str",c:e.text}]});break}default:this.warn(new n.Warning("Skipping unhandled node "+e.tag))}}toPandoc(t){return this.references=t.references,this.footnotes=t.footnotes,{"pandoc-api-version":[1,22,2,1],meta:{},blocks:this.toPandocChildren(t)}}}const l=function(t){const e={};t[0]&&(e.id=t[0]),t[1].length>0&&(e.class=t[1].join(" "));for(let s=0;s<t[2].length;s++)e[t[2][s][0].toString()]=t[2][s][1];return 0===Object.keys(e).length?null:e},h=function(t){return"Plain"===t.t||"Para"===t.t},d=function(t){if(!t[0])return null;const e=t[0];return h(e)&&e.c.length>=2&&"Str"===e.c[0].t&&"Space"===e.c[1].t?"☒"===e.c[0].c?(e.c.shift(),e.c.shift(),"checked"):"☐"===e.c[0].c?(e.c.shift(),e.c.shift(),"unchecked"):null:null};class u{constructor(t={}){this.footnotes={},this.footnoteIndex=0,this.options=t,this.warn=t.warn||(()=>{})}fromPandocInlines(t){let e=[];const s=[];for(let n=0;n<t.length;n++){const i=t[n];if("Str"===i.t)e.push(i.c);else if("Space"===i.t)e.push(" ");else switch(e.length>0&&(s.push({tag:"str",text:e.join("")}),e=[]),i.t){case"SoftBreak":s.push({tag:"soft_break"});break;case"LineBreak":s.push({tag:"hard_break"});break;case"Emph":s.push({tag:"emph",children:this.fromPandocInlines(i.c)});break;case"Strong":s.push({tag:"strong",children:this.fromPandocInlines(i.c)});break;case"Superscript":s.push({tag:"superscript",children:this.fromPandocInlines(i.c)});break;case"Subscript":s.push({tag:"subscript",children:this.fromPandocInlines(i.c)});break;case"Strikeout":s.push({tag:"delete",children:this.fromPandocInlines(i.c)});break;case"Span":{const t={tag:"span",children:this.fromPandocInlines(i.c[1])},e=l(i.c[0]);e&&(t.attributes=e),s.push(t);break}case"Underline":s.push({tag:"span",attributes:{class:"underline"},children:this.fromPandocInlines(i.c)});break;case"SmallCaps":s.push({tag:"span",attributes:{class:"smallcaps"},children:this.fromPandocInlines(i.c)});break;case"Math":s.push({tag:"DisplayMath"===i.c[0].t?"display_math":"inline_math",text:i.c[1]});break;case"Quoted":"SingleQuote"===i.c[0].t?s.push({tag:"single_quoted",children:this.fromPandocInlines(i.c[1])}):s.push({tag:"double_quoted",children:this.fromPandocInlines(i.c[1])});break;case"RawInline":s.push({tag:"raw_inline",format:i.c[0],text:i.c[1]});break;case"Code":{const t=l(i.c[0]),e={tag:"verbatim",text:i.c[1]};t&&(e.attributes=t),s.push(e);break}case"Image":case"Link":{let t=l(i.c[0]);i.c[2][1]&&(t=t||{},t.title=i.c[2][1]);const e=i.c[2][0],n=this.fromPandocInlines(i.c[1]);if("Image"===i.t){const i={tag:"image",destination:e,children:n};t&&(i.attributes=t),s.push(i)}else{const i={tag:"link",destination:e,children:n};t&&(i.attributes=t),s.push(i)}break}case"Cite":s.push({tag:"span",attributes:{class:"cite"},children:this.fromPandocInlines(i.c[1])});break;case"Note":{this.footnoteIndex++;const t=this.footnoteIndex.toString(),e=i.c.map((t=>this.fromPandocBlock(t)));this.footnotes[this.footnoteIndex.toString()]={tag:"footnote",label:t,children:e},s.push({tag:"footnote_reference",text:t});break}}}return e.length>0&&s.push({tag:"str",text:e.join("")}),s}fromPandocBlock(t){switch(t.t){case"Plain":case"Para":return{tag:"para",children:this.fromPandocInlines(t.c)};case"BlockQuote":return{tag:"block_quote",children:t.c.map((t=>this.fromPandocBlock(t)))};case"Div":{let e=l(t.c[0]);const s=/\bsection\b/.test(e&&e.class||"")?"section":"div",n=t.c[1].map((t=>this.fromPandocBlock(t)));if("section"===s)return e=e||{},e.class=e.class.replace(/section */,""),e.class||delete e.class,{tag:"section",attributes:e,children:n};{const t={tag:"div",children:n};return e&&(t.attributes=e),t}}case"Header":{const e=l(t.c[1]),s={tag:"heading",level:t.c[0],children:this.fromPandocInlines(t.c[2])};return e&&(s.attributes=e),s}case"HorizontalRule":return{tag:"thematic_break"};case"RawBlock":return{tag:"raw_block",format:t.c[0],text:t.c[1]};case"CodeBlock":{const e=l(t.c[0]);let s;if(e&&e.class){const t=e.class.split(/  */);s=t[0],t.shift(),t.length>0?e.class=t.join(" "):delete e.class}const n={tag:"code_block",lang:s,text:t.c[1]};return e&&(n.attributes=e),s||delete n.lang,n}case"DefinitionList":{const e=[];for(let s=0;s<t.c.length;s++){const n=t.c[s][0],i=t.c[s][1],r=this.fromPandocInlines(n),a=[];for(let t=0;t<i.length;t++)i[t].map((t=>{a.push(this.fromPandocBlock(t))}));e.push({tag:"definition_list_item",children:[{tag:"term",children:r},{tag:"definition",children:a}]})}return{tag:"definition_list",children:e}}case"OrderedList":case"BulletList":{const e=[],s=[];let n,r=!1;n="BulletList"===t.t?t.c:t.c[1];for(let t=0;t<n.length;t++){const i=d(n[t]),a=n[t].map((t=>("Plain"===t.t?r=!0:"Para"===t.t&&(r=!1),this.fromPandocBlock(t))));null!==i?s.push({tag:"task_list_item",checkbox:i,children:a}):e.push({tag:"list_item",children:a})}if("BulletList"===t.t)return s.length>0?{tag:"task_list",tight:r,children:s}:{tag:"bullet_list",style:"-",tight:r,children:e};if("OrderedList"===t.t){const s=t.c[0][0];let n=t.c[0][1].t;"DefaultStyle"===n&&(n="Decimal");let a=t.c[0][2].t;return"DefaultDelim"===a&&(a="Period"),{tag:"ordered_list",style:i[n][a],start:s,tight:r,children:e}}}case"Table":{const e=l(t.c[0]),s=t.c[1][1],i={tag:"caption",children:[]};s.length>1||1===s.length&&!h(s[0])?this.warn(new n.Warning("Skipping block-level content in table caption.")):s[0]&&"c"in s[0]&&(i.children=this.fromPandocInlines(s[0].c));const r=t.c[2],a=[];for(const t in r)a.push(r[t][0].t.slice(5).toLowerCase());const o=[],c=t.c[3][1];for(const t in c)o.push(this.fromPandocRow(c[t],!0,0,a));const d=t.c[4];for(const t in d){const e=d[t][1],s=d[t][2];for(const t in s)o.push(this.fromPandocRow(s[t],!0,e,a));const n=d[t][3];for(const t in n)o.push(this.fromPandocRow(n[t],!1,e,a))}const u=t.c[5][1];for(const t in u)o.push(this.fromPandocRow(u[t],!1,0,a));const p={tag:"table",children:[i,...o]};return e&&(p.attributes=e),p}case"LineBlock":{const e=[];for(let s=0;s<t.c.length;s++)s>0&&e.push({tag:"hard_break"}),e.push(...this.fromPandocInlines(t.c[s]));return{tag:"para",children:e}}case"Null":return{tag:"raw_block",format:"none",text:""}}return{tag:"raw_block",format:"error",text:"Could not convert "+t.t}}fromPandocRow(t,e,s,n){const i=l(t[0]),r=t[1],a=[];for(let t=0;t<r.length;t++)a.push(this.fromPandocCell(r[t],e||t<s,n[t]));const o={tag:"row",head:e,children:a};return i&&(o.attributes=i),o}fromPandocCell(t,e,s){let i=[];const r=l(t[0]);let a=t[1].t.slice(5).toLowerCase();"default"===a&&(a=s);const o=t[4];o.length>1||1===o.length&&!h(o[0])?(this.warn(new n.Warning("Skipping table cell with block-level content.")),i=[{tag:"str",text:"((content omitted))"}]):o[0]&&(i=this.fromPandocInlines(o[0].c));const c={tag:"cell",head:e,align:a,children:i};return r&&(c.attributes=r),c}fromPandoc(t){if("object"!=typeof t)throw Error("Pandoc document must be an object");if(!t["pandoc-api-version"])throw Error("Pandoc document lacks pandoc-api-version");if(!t.blocks)throw Error("Pandoc document lacks blocks");if(!t.meta)throw Error("Pandoc document lacks meta");return{tag:"doc",children:t.blocks.map((t=>this.fromPandocBlock(t))),footnotes:this.footnotes,references:{}}}}e.toPandoc=function(t,e){return new c(e).toPandoc(t)},e.fromPandoc=function(t,e){return new u(e).fromPandoc(t)}},306:(t,e,s)=>{Object.defineProperty(e,"__esModule",{value:!0}),e.isInline=e.isCaption=e.isRow=e.isBlock=e.getStringContent=e.renderAST=e.parse=void 0;const n=s(155),i=s(380),r=s(60);Object.defineProperty(e,"isRow",{enumerable:!0,get:function(){return r.isRow}}),Object.defineProperty(e,"isBlock",{enumerable:!0,get:function(){return r.isBlock}}),Object.defineProperty(e,"isCaption",{enumerable:!0,get:function(){return r.isCaption}}),Object.defineProperty(e,"isInline",{enumerable:!0,get:function(){return r.isInline}});const a=function(t){const e=[];return o(t,e),e.join("")};e.getStringContent=a;const o=function(t,e){if("text"in t)e.push(t.text);else if(!("tag"in t)||"soft_break"!==t.tag&&"hard_break"!==t.tag){if("children"in t)for(const s of t.children)o(s,e)}else e.push("\n")},c=function(t){return t.replace(/^ `/,"`").replace(/` $/,"`")},l={i:1,v:5,x:10,l:50,c:100,d:500,m:1e3,I:1,V:5,X:10,L:50,C:100,D:500,M:1e3};var h;!function(t){t[t.Normal=0]="Normal",t[t.Verbatim=1]="Verbatim",t[t.Literal=2]="Literal"}(h||(h={})),e.parse=function(t,e={}){const s=[-1];if(e.sourcePositions)for(let e=0;e<t.length;e++)"\n"===t[e]&&s.push(e);const r=function(t){let e=0,n=s.length-1,i=0,r=0;for(;!i;){const a=e+~~((n-e)/2);s[a]>t?n=a:s[a]<=t&&(a===n||s[a+1]>t?(i=a+1,r=t-s[a]):e=e===a&&e<n?a+1:a)}return{line:i,col:r,offset:t}};let o=h.Normal,d="";const u={},p={},f={},b={};let g=0;const m=(0,n.parseEvents)(t,e),_=e.warn||(()=>{}),k=function(t){if(Object.keys(b).length>0){t.attributes=t.attributes||{};for(const e in b)t.attributes[e]=b[e],delete b[e]}},N=function(t){const e={children:[],data:{},pos:t,attributes:void 0};k(e),w.push(e)},x=function(t){const e=w.pop();if(!e)throw new Error("Container stack is empty (popContainer)");return t&&e.pos&&(e.pos.end=t.end),e},C=function(){if(w.length>0)return w[w.length-1];throw new Error("Container stack is empty (topContainer)")},A=function(){const t=C();return t.children.length>0?t.children[t.children.length-1]:t},P=function(t){w.length>0&&w[w.length-1].children.push(t)},I={str:(e,s,n,i)=>{const r=t.substring(s,n+1);o===h.Normal?P({tag:"str",text:r,pos:i}):d+=r},soft_break:(t,e,s,n)=>{o===h.Normal?P({tag:"soft_break",pos:n}):d+="\n"},escape:(t,e,s,n)=>{o===h.Verbatim&&(d+="\\")},hard_break:(t,e,s,n)=>{o===h.Normal?P({tag:"hard_break",pos:n}):d+="\n"},non_breaking_space:(t,e,s,n)=>{o===h.Verbatim?d+="\\ ":P({tag:"non_breaking_space",pos:n})},symb:(e,s,n,i)=>{if(o===h.Normal){const e=t.substring(s+1,n);P({tag:"symb",alias:e,pos:i})}else{const e=t.substring(s,n+1);d+=e}},footnote_reference:(e,s,n,i)=>{const r=t.substring(s+2,n);P({tag:"footnote_reference",text:r,pos:i})},"+reference_definition":(t,e,s,n)=>{N(n)},"-reference_definition":(t,e,s,n)=>{const i=x(n),r={tag:"reference",label:i.data.key,destination:i.data.value||"",attributes:i.attributes};i.data.key&&(u[i.data.key]=r)},reference_key:(e,s,n,i)=>{C().data.key=t.substring(s+1,n),C().data.value=""},reference_value:(e,s,n,i)=>{C().data.value=C().data.value+t.substring(s,n+1)},"+emph":(t,e,s,n)=>{N(n)},"-emph":(t,e,s,n)=>{const i=x(n);P({tag:"emph",children:i.children,pos:i.pos})},"+strong":(t,e,s,n)=>{N(n)},"-strong":(t,e,s,n)=>{const i=x(n);P({tag:"strong",children:i.children,pos:i.pos})},"+span":(t,e,s,n)=>{N(n)},"-span":(t,e,s,n)=>{const i=x(n);P({tag:"span",children:i.children,pos:i.pos})},"+mark":(t,e,s,n)=>{N(n)},"-mark":(t,e,s,n)=>{const i=x(n);P({tag:"mark",children:i.children,pos:i.pos})},"+superscript":(t,e,s,n)=>{N(n)},"-superscript":(t,e,s,n)=>{const i=x(n);P({tag:"superscript",children:i.children,pos:i.pos})},"+subscript":(t,e,s,n)=>{N(n)},"-subscript":(t,e,s,n)=>{const i=x(n);P({tag:"subscript",children:i.children,pos:i.pos})},"+delete":(t,e,s,n)=>{N(n)},"-delete":(t,e,s,n)=>{const i=x(n);P({tag:"delete",children:i.children,pos:i.pos})},"+insert":(t,e,s,n)=>{N(n)},"-insert":(t,e,s,n)=>{const i=x(n);P({tag:"insert",children:i.children,pos:i.pos})},"+double_quoted":(t,e,s,n)=>{N(n)},"-double_quoted":(t,e,s,n)=>{const i=x(n);P({tag:"double_quoted",children:i.children,pos:i.pos})},"+single_quoted":(t,e,s,n)=>{N(n)},"-single_quoted":(t,e,s,n)=>{const i=x(n);P({tag:"single_quoted",children:i.children,pos:i.pos})},"+attributes":(t,e,s,n)=>{N(n)},"-attributes":(t,s,n,a)=>{const o=x(a);if(o.attributes&&w.length>0){o.attributes.id&&(f[o.attributes.id]=!0);let t=A();if(t===C())return;let n=!1;if("tag"in t&&"str"===t.tag){const e=t.text.match(/[^\s]+$/);if(e&&e.index&&e.index>0){let s;if(t.pos){const n=t.pos.end;t.pos.end={line:n.line,col:n.col-e[0].length,offset:n.offset-e[0].length},s={start:{line:n.line,col:n.col-e[0].length+1,offset:n.offset-e[0].length+1},end:n}}t.text=t.text.substring(0,e.index),P({tag:"str",text:e[0],pos:s})}else e||(n=!0)}if(t=A(),n)return void _(new i.Warning("Ignoring unattached attribute",e.sourcePositions?r(s):s));t.attributes||(t.attributes={});for(const e in o.attributes)"class"===e&&t.attributes[e]?t.attributes[e]=t.attributes[e]+" "+o.attributes[e]:t.attributes[e]=o.attributes[e]}},"+block_attributes":(t,e,s,n)=>{N(n)},"-block_attributes":(t,e,s,n)=>{const i=x(n);if(i.attributes&&w.length>0){i.attributes.id&&(f[i.attributes.id]=!0);for(const t in i.attributes)"class"===t&&b[t]?b[t]=b[t]+" "+i.attributes[t]:b[t]=i.attributes[t]}},class:(e,s,n,i)=>{const r=C(),a=t.substring(s,n+1);r.attributes||(r.attributes={}),r.attributes.class?r.attributes.class=r.attributes.class+" "+a:r.attributes.class=a},id:(e,s,n,i)=>{const r=C(),a=t.substring(s,n+1);r.attributes?r.attributes.id=a:r.attributes={id:a}},key:(e,s,n,i)=>{const r=C(),a=t.substring(s,n+1);r.data.key=a,r.attributes||(r.attributes={}),r.attributes[r.data.key]=""},value:(e,s,n,i)=>{const r=C(),a=t.substring(s,n+1).replace(/[ \r\n]+/g," ").replace(/\\([.,\\/#!$%^&*;:{}=\-_`~+[\]()'"?|])/g,"$1");if(r.attributes||(r.attributes={}),!r.data.key)throw new Error("Encountered value without key");r.attributes[r.data.key]=r.attributes[r.data.key]+a},"+linktext":(t,e,s,n)=>{N(n),C().data.isimage=!1},"-linktext":(t,e,s,n)=>{},"+imagetext":(t,e,s,n)=>{N(n),C().data.isimage=!0},"-imagetext":(t,e,s,n)=>{},"+destination":(t,e,s,n)=>{o=h.Literal},"-destination":(t,e,s,n)=>{const i=x(n);P({tag:i.data.isimage?"image":"link",destination:d.replace(/[\r\n]/g,""),children:i.children,pos:i.pos}),o=h.Normal,d=""},"+reference":(t,e,s,n)=>{o=h.Literal},"-reference":(t,e,s,n)=>{const i=x(n);let r=d.replace(/\r?\n/g," ");0===r.length&&(r=a(i)),P({tag:i.data.isimage?"image":"link",reference:r,children:i.children,pos:i.pos}),o=h.Normal,d=""},"+verbatim":(t,e,s,n)=>{o=h.Verbatim,N(n)},"-verbatim":(t,e,s,n)=>{const i=x(n);P({tag:"verbatim",text:c(d),pos:i.pos}),o=h.Normal,d=""},raw_format:(e,s,n,i)=>{const r=t.substring(s,n+1).replace(/^\{?=/,"").replace(/\}$/,""),a=C();if(o===h.Verbatim)a.data.format=r;else{const t=a.children[a.children.length-1];if(!t||!("tag"in t)||"verbatim"!==t.tag)throw new Error("raw_format is not after verbatim or code_block.");t.tag="raw_inline",t.format=r}},"+display_math":(t,e,s,n)=>{o=h.Verbatim,N(n)},"+inline_math":(t,e,s,n)=>{o=h.Verbatim,N(n)},"-display_math":(t,e,s,n)=>{const i=x(n);P({tag:"display_math",text:c(d),pos:i.pos}),o=h.Normal,d=""},"-inline_math":(t,e,s,n)=>{const i=x(n);P({tag:"inline_math",text:c(d),pos:i.pos}),o=h.Normal,d=""},"+url":(t,e,s,n)=>{o=h.Literal,N(n)},"-url":(t,e,s,n)=>{const i=x(n);P({tag:"url",text:d.replace(/[\r\n]/g,""),pos:i.pos}),o=h.Normal,d=""},"+email":(t,e,s,n)=>{o=h.Literal,N(n)},"-email":(t,e,s,n)=>{const i=x(n);P({tag:"email",text:d.replace(/[\r\n]/g,""),pos:i.pos}),o=h.Normal,d=""},"+para":(t,e,s,n)=>{N(n)},"-para":(t,e,s,n)=>{const i=x(n);P({tag:"para",children:i.children,attributes:i.attributes,pos:i.pos})},"+heading":(t,e,s,n)=>{N(n),C().data.level=1+s-e},"-heading":(t,e,s,n)=>{const i=x(n);i.attributes||(i.attributes={});const r=a(i).trim();i.attributes.id||(i.attributes.id=function(t){const e=t.trim().replace(/[\W\s.]+/g,"-").replace(/-$/,"").replace(/^-/,"");let s=0,n=e;for(;!n||f[n];)s+=1,n=(e||"s")+"-"+s;return n}(r),f[i.attributes.id]=!0),u[r]||(u[r]={tag:"reference",label:r,destination:"#"+i.attributes.id});let o=C();if(void 0!==o.data.headinglevel){for(;o&&void 0!==o.data.headinglevel&&o.data.headinglevel>=i.data.level;)o=x(n),P({tag:"section",children:o.children,attributes:o.attributes,pos:o.pos}),o=C();N(n),C().data.headinglevel=i.data.level,i.attributes&&i.attributes.id&&(C().attributes=i.attributes,delete i.attributes)}P({tag:"heading",level:i.data.level,children:i.children,attributes:i.attributes,pos:i.pos})},"+list":(t,e,s,n)=>{N(n),C().data.styles=t,C().data.blanklines=!1,C().data.tight=!0,g++},"-list":(t,e,s,n)=>{const i=x(n),r=i.data.styles[0];if(!r)throw new Error("No style defined for list");const a=function(t,e){const s=e.replace(/[().]/g,""),n=t.replace(/[().]/g,"");switch(s){case"1":return parseInt(n,10);case"A":return(n.codePointAt(0)||65)-65+1;case"a":return(n.codePointAt(0)||97)-97+1;case"I":case"i":return function(t){let e=0,s=0,n=t.length-1;for(;n>=0;){const i=t.charAt(n),r=l[i];if(!r)throw new Error("Encountered bad character in roman numeral "+t);r<s?e-=r:e+=r,s=r,n-=1}return e}(n)}}(i.data.firstMarker,r);P(":"===r?{tag:"definition_list",children:i.children,attributes:i.attributes,pos:i.pos}:"X"===r?{tag:"task_list",tight:i.data.tight,children:i.children,attributes:i.attributes,pos:i.pos}:"+"===r||"*"===r||"-"===r?{tag:"bullet_list",tight:i.data.tight,style:r,children:i.children,attributes:i.attributes,pos:i.pos}:{tag:"ordered_list",style:r,children:i.children,start:a,tight:i.data.tight,attributes:i.attributes,pos:i.pos}),g--},"+list_item":(e,s,n,i)=>{e.length<C().data.styles.length&&(C().data.styles=e),C().data.firstMarker||(C().data.firstMarker=t.substring(s,n+1)),N(i),1===e.length&&":"===e[0]&&(C().data.definitionList=!0)},"-list_item":(t,e,s,n)=>{const i=x(n);if(i.data.definitionList)if(i.children[0]&&"para"===i.children[0].tag){const t={tag:"term",children:i.children[0].children};i.children.shift();const e={tag:"definition",children:i.children};P({tag:"definition_list_item",children:[t,e],attributes:i.attributes,pos:i.pos})}else{const t={tag:"term",children:[]},e={tag:"definition",children:i.children};P({tag:"definition_list_item",children:[t,e],attributes:i.attributes,pos:i.pos})}else i.data.checkbox?P({tag:"task_list_item",children:i.children,attributes:i.attributes,checkbox:i.data.checkbox,pos:i.pos}):P({tag:"list_item",children:i.children,attributes:i.attributes,pos:i.pos})},checkbox_checked:(t,e,s,n)=>{C().data.checkbox="checked"},checkbox_unchecked:(t,e,s,n)=>{C().data.checkbox="unchecked"},"+block_quote":(t,e,s,n)=>{N(n)},"-block_quote":(t,e,s,n)=>{const i=x(n);P({tag:"block_quote",children:i.children,attributes:i.attributes,pos:i.pos})},"+table":(t,e,s,n)=>{N(n),C().data.aligns=[]},"-table":(t,e,s,n)=>{var i;const r=x(n),a=r.children;let o={tag:"caption",children:[]};"caption"===(null===(i=a[0])||void 0===i?void 0:i.tag)&&(o=a.shift()),P({tag:"table",children:[o,...a],attributes:r.attributes,pos:r.pos})},"+row":(t,e,s,n)=>{N(n),C().data.aligns=[]},"-row":(t,e,s,n)=>{const i=x(n);if(0===i.children.length){C().data.aligns=i.data.aligns;const t=A();if(t&&"tag"in t&&"row"===t.tag){t.head=!0;for(let e=0;e<t.children.length;e++)t.children[e].head=!0,t.children[e].align=i.data.aligns[e]||"default"}}else{i.data.aligns=[];for(let t=0;t<i.children.length;t++)i.children[t].align=C().data.aligns[t]||"default";P({tag:"row",children:i.children,head:!1,attributes:i.attributes,pos:i.pos})}},separator_default:(t,e,s,n)=>{C().data.aligns.push("default")},separator_left:(t,e,s,n)=>{C().data.aligns.push("left")},separator_right:(t,e,s,n)=>{C().data.aligns.push("right")},separator_center:(t,e,s,n)=>{C().data.aligns.push("center")},"+cell":(t,e,s,n)=>{N(n)},"-cell":(t,e,s,n)=>{const i=x(n);P({tag:"cell",children:i.children,head:!1,align:"default",attributes:i.attributes,pos:i.pos})},"+caption":(t,e,s,n)=>{N(n)},"-caption":(t,e,s,n)=>{const i=x(n),r=A();!r||"tag"in r&&"table"!==r.tag||r.children.unshift({tag:"caption",children:i.children,attributes:i.attributes,pos:i.pos})},"+footnote":(t,e,s,n)=>{N(n)},"-footnote":(t,s,n,a)=>{const o=x(a);o.data.label?p[o.data.label]={tag:"footnote",label:o.data.label||"",children:o.children,attributes:o.attributes,pos:o.pos}:_(new i.Warning("Ignoring footnote without a label.",e.sourcePositions?r(n):n))},note_label:(e,s,n,i)=>{C().data.label=t.substring(s,n+1)},"+code_block":(t,e,s,n)=>{N(n),o=h.Verbatim},"-code_block":(t,e,s,n)=>{const i=x(n);i.data.format?P({tag:"raw_block",format:i.data.format,text:d,attributes:i.attributes,pos:i.pos}):P({tag:"code_block",text:d,lang:i.data.lang,attributes:i.attributes,pos:i.pos}),o=h.Normal,d=""},code_language:(e,s,n,i)=>{C().data.lang=t.substring(s,n+1)},"+div":(t,e,s,n)=>{N(n)},"-div":(t,e,s,n)=>{const i=x(n);P({tag:"div",children:i.children,attributes:i.attributes,pos:i.pos})},thematic_break:(t,e,s,n)=>{const i={tag:"thematic_break",pos:n};k(i),P(i)},left_single_quote:(t,e,s,n)=>{P({tag:"smart_punctuation",type:"left_single_quote",text:"'",pos:n})},right_single_quote:(t,e,s,n)=>{P({tag:"smart_punctuation",type:"right_single_quote",text:"'",pos:n})},left_double_quote:(t,e,s,n)=>{P({tag:"smart_punctuation",type:"left_double_quote",text:'"',pos:n})},right_double_quote:(t,e,s,n)=>{P({tag:"smart_punctuation",type:"right_double_quote",text:'"',pos:n})},ellipses:(t,e,s,n)=>{P({tag:"smart_punctuation",type:"ellipses",text:"...",pos:n})},en_dash:(t,e,s,n)=>{P({tag:"smart_punctuation",type:"en_dash",text:"--",pos:n})},em_dash:(t,e,s,n)=>{P({tag:"smart_punctuation",type:"em_dash",text:"---",pos:n})},blankline:(t,e,s,n)=>{let i;"tight"in C().data?i=C():w.length>=2&&"tight"in w[w.length-2].data&&(i=w[w.length-2]),i&&(i.data.blanklines=!0)}},M=function(t,s){let n,i,a;e.sourcePositions&&(n=r(s.startpos),i=r(s.endpos),a={start:n,end:i});let o=s.annot,c=[];if(s.annot.includes("|")){const t=s.annot.split("|");o=t[0],c=t.slice(1)}if(g>0&&"blankline"!==o){let e;const s=C();s&&(s.data&&"tight"in s.data?e=s:t.length>=2&&"tight"in t[t.length-2].data&&(e=t[t.length-2])),e&&(!/^[+-]list/.test(o)&&e.data.blanklines&&(e.data.tight=!1),/^[-+]list_item$/.test(o)||(e.data.blanklines=!1))}const l=I[o];l&&l(c,s.startpos,s.endpos,a)},w=[{children:[],data:{headinglevel:0},pos:{start:{line:0,col:0,offset:0},end:{line:0,col:0,offset:0}}}];let v,S=0;for(const t of m)M(w,t),S=t.endpos;e.sourcePositions&&(v=r(S));let y=C();for(;y&&y.data.headinglevel>0;)x(v&&{start:v,end:v}),P({tag:"section",children:y.children,attributes:y.attributes,pos:y.pos}),y=C();const T={tag:"doc",references:u,footnotes:p,children:w[0].children};return w[0].attributes&&(T.attributes=w[0].attributes),T};const d={children:!0,tag:!0,pos:!0,attributes:!0,references:!0,footnotes:!0},u=function(t){return JSON.stringify(t).replace(/\\\n/g,"\\n")},p=function(t,e,s){if(e.push(" ".repeat(s)),s>128)e.push("(((DEEPLY NESTED CONTENT OMITTED)))\n");else{e.push(t.tag),t.pos&&e.push(` (${t.pos.start.line}:${t.pos.start.col}:${t.pos.start.offset}-${t.pos.end.line}:${t.pos.end.col}:${t.pos.end.offset})`);for(const s in t)if(!d[s]){const n=t[s];null!=n&&e.push(` ${s}=${u(n)}`)}if(t.attributes)for(const s in t.attributes)e.push(` ${s}=${u(t.attributes[s])}`);if(e.push("\n"),t.children)for(const n of t.children)p(n,e,s+2)}};e.renderAST=function(t){const e=[];if(p(t,e,0),Object.keys(t.references).length>0){e.push("references\n");for(const s in t.references)e.push(`  [${u(s)}] =\n`),p(t.references[s],e,4)}if(Object.keys(t.footnotes).length>0){e.push("footnotes\n");for(const s in t.footnotes)e.push(`  [${u(s)}] =\n`),p(t.footnotes[s],e,4)}return e.join("")}},412:(t,e)=>{Object.defineProperty(e,"__esModule",{value:!0}),e.version=void 0,e.version="0.2.1"}},e={};function s(n){var i=e[n];if(void 0!==i)return i.exports;var r=e[n]={exports:{}};return t[n](r,r.exports,s),r.exports}var n={};return(()=>{var t=n;Object.defineProperty(t,"__esModule",{value:!0}),t.version=t.renderDjot=t.toPandoc=t.fromPandoc=t.applyFilter=t.HTMLRenderer=t.renderHTML=t.parseEvents=t.renderAST=t.parse=void 0;var e=s(306);Object.defineProperty(t,"parse",{enumerable:!0,get:function(){return e.parse}}),Object.defineProperty(t,"renderAST",{enumerable:!0,get:function(){return e.renderAST}});var i=s(155);Object.defineProperty(t,"parseEvents",{enumerable:!0,get:function(){return i.parseEvents}});var r=s(240);Object.defineProperty(t,"renderHTML",{enumerable:!0,get:function(){return r.renderHTML}}),Object.defineProperty(t,"HTMLRenderer",{enumerable:!0,get:function(){return r.HTMLRenderer}});var a=s(322);Object.defineProperty(t,"applyFilter",{enumerable:!0,get:function(){return a.applyFilter}});var o=s(56);Object.defineProperty(t,"fromPandoc",{enumerable:!0,get:function(){return o.fromPandoc}}),Object.defineProperty(t,"toPandoc",{enumerable:!0,get:function(){return o.toPandoc}});var c=s(423);Object.defineProperty(t,"renderDjot",{enumerable:!0,get:function(){return c.renderDjot}});var l=s(412);Object.defineProperty(t,"version",{enumerable:!0,get:function(){return l.version}})})(),n})()));// Assumes this script is prepended with the djot.js dist file.
// See Makefile for details.
const djot = module.exports;
let buffer = new Uint8Array();
const MSG_DELIMITER = 255; // 0xFF which doesn't appear in valid UTF-8
const END = new Uint8Array([MSG_DELIMITER]);

process.stdin.on("data", (chunk) => {
  buffer = concatTypedArray(buffer, chunk);

  // Loop here to handle case where multiple messages come in 1 chunk
  while (true) {
    const endIndex = buffer.indexOf(MSG_DELIMITER);

    if (endIndex === -1) {
      return;
    }

    const msg = buffer.subarray(0, endIndex);
    buffer = buffer.subarray(endIndex + 1);
    handleMessage(msg);
  }
});

function concatTypedArray(former, latter) {
  const result = new Uint8Array(former.length + latter.length);
  result.set(former);
  result.set(latter, former.length);
  return result;
}

function handleMessage(msg) {
  const input = new TextDecoder().decode(msg);
  const output = djot.renderHTML(djot.parse(input));
  const outputBytes = new TextEncoder().encode(output);
  process.stdout.write(outputBytes);
  process.stdout.write(END);
}
