"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.hasMessage = exports.findMessage = void 0;
const section_1 = require("./section");
function findMessage(messages, logicalId, props = {}) {
    const section = messages;
    const result = section_1.matchSection(section_1.filterLogicalId(section, logicalId), props);
    if (!result.match) {
        return {};
    }
    return result.matches;
}
exports.findMessage = findMessage;
function hasMessage(messages, logicalId, props) {
    const section = messages;
    const result = section_1.matchSection(section_1.filterLogicalId(section, logicalId), props);
    if (result.match) {
        return;
    }
    if (result.closestResult === undefined) {
        return 'No messages found in the stack';
    }
    return [
        `Stack has ${result.analyzedCount} messages, but none match as expected.`,
        section_1.formatFailure(formatMessage(result.closestResult)),
    ].join('\n');
}
exports.hasMessage = hasMessage;
// We redact the stack trace by default because it is unnecessarily long and unintelligible.
// If there is a use case for rendering the trace, we can add it later.
function formatMessage(match, renderTrace = false) {
    if (!renderTrace) {
        match.target.entry.trace = 'redacted';
    }
    return match;
}
//# sourceMappingURL=data:application/json;base64,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