"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Laravel = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("@aws-cdk/aws-ec2");
const ecs = require("@aws-cdk/aws-ecs");
const efs = require("@aws-cdk/aws-efs");
const logs = require("@aws-cdk/aws-logs");
const cdk = require("@aws-cdk/core");
const _1 = require("./");
const common_functions_1 = require("./common/common-functions");
/**
 * Represents the Laravel service.
 *
 * @stability stable
 */
class Laravel extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b, _c, _d;
        super(scope, id);
        this.vpc = (_b = props.vpc) !== null && _b !== void 0 ? _b : common_functions_1.getOrCreateVpc(this);
        this.db = this.addDatabase({
            vpc: this.vpc,
            databaseSubnets: props.databaseSubnets,
            instanceType: props.databaseInstanceType,
            instanceEngine: props.instanceEngine,
            clusterEngine: props.clusterEngine,
            auroraServerless: props.auroraServerless,
            singleDbInstance: props.singleDbInstance,
            backupRetention: props.backupRetention,
            defaultDatabaseName: props.defaultDatabaseName,
        });
        const logGroup = new logs.LogGroup(this, 'LogGroup', {
            retention: logs.RetentionDays.ONE_MONTH,
            removalPolicy: cdk.RemovalPolicy.DESTROY,
        });
        const task = new ecs.FargateTaskDefinition(this, 'Task', {
            cpu: 256,
            memoryLimitMiB: 512,
        });
        task.addContainer('Laravel', {
            image: ecs.ContainerImage.fromAsset(props.code),
            portMappings: [{ containerPort: (_c = props.containerPort) !== null && _c !== void 0 ? _c : 80 }],
            environment: {
                Laravel_DB_NAME: 'Laravel',
            },
            logging: new ecs.AwsLogDriver({
                streamPrefix: 'Laravel-fargate',
                logGroup,
            }),
            secrets: {
                LARAVEL_DB_HOST: ecs.Secret.fromSecretsManager(this.db.secret, 'host'),
                LARAVEL_DB_USER: ecs.Secret.fromSecretsManager(this.db.secret, 'username'),
                LARAVEL_DB_PASSWORD: ecs.Secret.fromSecretsManager(this.db.secret, 'password'),
            },
        });
        const healthCheck = {
            path: '/',
            interval: cdk.Duration.minutes(1),
        };
        this.svc = new _1.DualAlbFargateService(this, 'ALBFargateService', {
            vpc: this.vpc,
            spot: props.spot,
            enableExecuteCommand: props.enableExecuteCommand,
            tasks: props.serviceProps ? [props.serviceProps] : [
                {
                    external: props.loadbalancer,
                    task,
                    healthCheck,
                },
            ],
            route53Ops: { enableLoadBalancerAlias: false },
        });
        if (props.efsFileSystem) {
            // EFS volume
            const filesystem = new efs.FileSystem(this, 'FileSystem', props.efsFileSystem);
            const volumeName = 'efs';
            this.svc.service[0].taskDefinition.addVolume({
                name: volumeName,
                efsVolumeConfiguration: {
                    fileSystemId: filesystem.fileSystemId,
                },
            });
            // fix me - tentatively mount to /efsmount
            (_d = this.svc.service[0].taskDefinition.defaultContainer) === null || _d === void 0 ? void 0 : _d.addMountPoints({
                containerPath: '/efsmount',
                readOnly: false,
                sourceVolume: volumeName,
            });
            filesystem.connections.allowFrom(new ec2.Connections({ securityGroups: this.svc.service[0].connections.securityGroups }), ec2.Port.tcp(2049), 'allow Laravel to connect to efs filesystem');
        }
        this.db.connections.allowFrom(this.svc.service[0], this.db.connections.defaultPort, `allow ${this.svc.service[0].serviceName} to connect to database`);
    }
    addDatabase(props) {
        return new _1.Database(this, 'Database', {
            ...props,
        });
    }
}
exports.Laravel = Laravel;
_a = JSII_RTTI_SYMBOL_1;
Laravel[_a] = { fqn: "cdk-fargate-patterns.Laravel", version: "0.2.27" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibGFyYXZlbC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9sYXJhdmVsLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsd0NBQXdDO0FBQ3hDLHdDQUF3QztBQUN4Qyx3Q0FBd0M7QUFDeEMsMENBQTBDO0FBRTFDLHFDQUFxQztBQUNyQyx5QkFBaUg7QUFDakgsZ0VBQTJEOzs7Ozs7QUF3QzNELE1BQWEsT0FBUSxTQUFRLEdBQUcsQ0FBQyxTQUFTOzs7O0lBSXhDLFlBQVksS0FBb0IsRUFBRSxFQUFVLEVBQUUsS0FBbUI7O1FBQy9ELEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFFakIsSUFBSSxDQUFDLEdBQUcsU0FBRyxLQUFLLENBQUMsR0FBRyxtQ0FBSSxpQ0FBYyxDQUFDLElBQUksQ0FBQyxDQUFDO1FBQzdDLElBQUksQ0FBQyxFQUFFLEdBQUcsSUFBSSxDQUFDLFdBQVcsQ0FBQztZQUN6QixHQUFHLEVBQUUsSUFBSSxDQUFDLEdBQUc7WUFDYixlQUFlLEVBQUUsS0FBSyxDQUFDLGVBQWU7WUFDdEMsWUFBWSxFQUFFLEtBQUssQ0FBQyxvQkFBb0I7WUFDeEMsY0FBYyxFQUFFLEtBQUssQ0FBQyxjQUFjO1lBQ3BDLGFBQWEsRUFBRSxLQUFLLENBQUMsYUFBYTtZQUNsQyxnQkFBZ0IsRUFBRSxLQUFLLENBQUMsZ0JBQWdCO1lBQ3hDLGdCQUFnQixFQUFFLEtBQUssQ0FBQyxnQkFBZ0I7WUFDeEMsZUFBZSxFQUFFLEtBQUssQ0FBQyxlQUFlO1lBQ3RDLG1CQUFtQixFQUFFLEtBQUssQ0FBQyxtQkFBbUI7U0FDL0MsQ0FBQyxDQUFDO1FBRUgsTUFBTSxRQUFRLEdBQUcsSUFBSSxJQUFJLENBQUMsUUFBUSxDQUFDLElBQUksRUFBRSxVQUFVLEVBQUU7WUFDbkQsU0FBUyxFQUFFLElBQUksQ0FBQyxhQUFhLENBQUMsU0FBUztZQUN2QyxhQUFhLEVBQUUsR0FBRyxDQUFDLGFBQWEsQ0FBQyxPQUFPO1NBQ3pDLENBQUMsQ0FBQztRQUVILE1BQU0sSUFBSSxHQUFHLElBQUksR0FBRyxDQUFDLHFCQUFxQixDQUFDLElBQUksRUFBRSxNQUFNLEVBQUU7WUFDdkQsR0FBRyxFQUFFLEdBQUc7WUFDUixjQUFjLEVBQUUsR0FBRztTQUNwQixDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsWUFBWSxDQUFDLFNBQVMsRUFBRTtZQUMzQixLQUFLLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxTQUFTLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQztZQUMvQyxZQUFZLEVBQUUsQ0FBQyxFQUFFLGFBQWEsUUFBRSxLQUFLLENBQUMsYUFBYSxtQ0FBSSxFQUFFLEVBQUUsQ0FBQztZQUM1RCxXQUFXLEVBQUU7Z0JBQ1gsZUFBZSxFQUFFLFNBQVM7YUFDM0I7WUFDRCxPQUFPLEVBQUUsSUFBSSxHQUFHLENBQUMsWUFBWSxDQUFDO2dCQUM1QixZQUFZLEVBQUUsaUJBQWlCO2dCQUMvQixRQUFRO2FBQ1QsQ0FBQztZQUNGLE9BQU8sRUFBRTtnQkFDUCxlQUFlLEVBQUUsR0FBRyxDQUFDLE1BQU0sQ0FBQyxrQkFBa0IsQ0FDNUMsSUFBSSxDQUFDLEVBQUUsQ0FBQyxNQUFNLEVBQ2QsTUFBTSxDQUNQO2dCQUNELGVBQWUsRUFBRSxHQUFHLENBQUMsTUFBTSxDQUFDLGtCQUFrQixDQUM1QyxJQUFJLENBQUMsRUFBRSxDQUFDLE1BQU0sRUFDZCxVQUFVLENBQ1g7Z0JBQ0QsbUJBQW1CLEVBQUUsR0FBRyxDQUFDLE1BQU0sQ0FBQyxrQkFBa0IsQ0FDaEQsSUFBSSxDQUFDLEVBQUUsQ0FBQyxNQUFNLEVBQ2QsVUFBVSxDQUNYO2FBQ0Y7U0FDRixDQUFDLENBQUM7UUFFSCxNQUFNLFdBQVcsR0FBRztZQUNsQixJQUFJLEVBQUUsR0FBRztZQUNULFFBQVEsRUFBRSxHQUFHLENBQUMsUUFBUSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUM7U0FDbEMsQ0FBQztRQUVGLElBQUksQ0FBQyxHQUFHLEdBQUcsSUFBSSx3QkFBcUIsQ0FBQyxJQUFJLEVBQUUsbUJBQW1CLEVBQUU7WUFDOUQsR0FBRyxFQUFFLElBQUksQ0FBQyxHQUFHO1lBQ2IsSUFBSSxFQUFFLEtBQUssQ0FBQyxJQUFJO1lBQ2hCLG9CQUFvQixFQUFFLEtBQUssQ0FBQyxvQkFBb0I7WUFDaEQsS0FBSyxFQUFFLEtBQUssQ0FBQyxZQUFZLENBQUMsQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDLFlBQVksQ0FBQyxDQUFDLENBQUMsQ0FBQztnQkFDakQ7b0JBQ0UsUUFBUSxFQUFFLEtBQUssQ0FBQyxZQUFZO29CQUM1QixJQUFJO29CQUNKLFdBQVc7aUJBQ1o7YUFDRjtZQUNELFVBQVUsRUFBRSxFQUFFLHVCQUF1QixFQUFFLEtBQUssRUFBRTtTQUMvQyxDQUFDLENBQUM7UUFFSCxJQUFJLEtBQUssQ0FBQyxhQUFhLEVBQUU7WUFDdkIsYUFBYTtZQUNiLE1BQU0sVUFBVSxHQUFHLElBQUksR0FBRyxDQUFDLFVBQVUsQ0FBQyxJQUFJLEVBQUUsWUFBWSxFQUFFLEtBQUssQ0FBQyxhQUFhLENBQUMsQ0FBQztZQUUvRSxNQUFNLFVBQVUsR0FBRyxLQUFLLENBQUM7WUFDekIsSUFBSSxDQUFDLEdBQUcsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLENBQUMsY0FBYyxDQUFDLFNBQVMsQ0FBQztnQkFDM0MsSUFBSSxFQUFFLFVBQVU7Z0JBQ2hCLHNCQUFzQixFQUFFO29CQUN0QixZQUFZLEVBQUUsVUFBVSxDQUFDLFlBQVk7aUJBQ3RDO2FBQ0YsQ0FBQyxDQUFDO1lBRUgsMENBQTBDO1lBQzFDLE1BQUEsSUFBSSxDQUFDLEdBQUcsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLENBQUMsY0FBYyxDQUFDLGdCQUFnQiwwQ0FBRSxjQUFjLENBQUM7Z0JBQ2xFLGFBQWEsRUFBRSxXQUFXO2dCQUMxQixRQUFRLEVBQUUsS0FBSztnQkFDZixZQUFZLEVBQUUsVUFBVTthQUN6QixFQUFFO1lBRUgsVUFBVSxDQUFDLFdBQVcsQ0FBQyxTQUFTLENBQUMsSUFBSSxHQUFHLENBQUMsV0FBVyxDQUFDLEVBQUUsY0FBYyxFQUFFLElBQUksQ0FBQyxHQUFHLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxDQUFDLFdBQVcsQ0FBQyxjQUFjLEVBQUUsQ0FBQyxFQUFFLEdBQUcsQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxFQUFFLDRDQUE0QyxDQUFDLENBQUM7U0FDN0w7UUFHRCxJQUFJLENBQUMsRUFBRSxDQUFDLFdBQVcsQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLEVBQUUsSUFBSSxDQUFDLEVBQUUsQ0FBQyxXQUFXLENBQUMsV0FBWSxFQUFFLFNBQVMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLENBQUMsV0FBVyx5QkFBeUIsQ0FBQyxDQUFDO0lBRTFKLENBQUM7SUFDTyxXQUFXLENBQUMsS0FBb0I7UUFDdEMsT0FBTyxJQUFJLFdBQVEsQ0FBQyxJQUFJLEVBQUUsVUFBVSxFQUFFO1lBQ3BDLEdBQUcsS0FBSztTQUNULENBQUMsQ0FBQztJQUNMLENBQUM7O0FBekdILDBCQTBHQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGVjMiBmcm9tICdAYXdzLWNkay9hd3MtZWMyJztcbmltcG9ydCAqIGFzIGVjcyBmcm9tICdAYXdzLWNkay9hd3MtZWNzJztcbmltcG9ydCAqIGFzIGVmcyBmcm9tICdAYXdzLWNkay9hd3MtZWZzJztcbmltcG9ydCAqIGFzIGxvZ3MgZnJvbSAnQGF3cy1jZGsvYXdzLWxvZ3MnO1xuaW1wb3J0ICogYXMgcmRzIGZyb20gJ0Bhd3MtY2RrL2F3cy1yZHMnO1xuaW1wb3J0ICogYXMgY2RrIGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0IHsgRHVhbEFsYkZhcmdhdGVTZXJ2aWNlLCBGYXJnYXRlVGFza1Byb3BzLCBEYXRhYmFzZSwgRGF0YWJhc2VQcm9wcywgTG9hZEJhbGFuY2VyQWNjZXNzaWJpbGl0eSB9IGZyb20gJy4vJztcbmltcG9ydCB7IGdldE9yQ3JlYXRlVnBjIH0gZnJvbSAnLi9jb21tb24vY29tbW9uLWZ1bmN0aW9ucyc7XG5cbmV4cG9ydCBpbnRlcmZhY2UgTGFyYXZlbFByb3BzIHtcbiAgcmVhZG9ubHkgdnBjPzogZWMyLklWcGM7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBkYXRhYmFzZVN1Ym5ldHM/OiBlYzIuU3VibmV0U2VsZWN0aW9uO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBkYXRhYmFzZUluc3RhbmNlVHlwZT86IGVjMi5JbnN0YW5jZVR5cGU7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGluc3RhbmNlRW5naW5lPzogcmRzLklJbnN0YW5jZUVuZ2luZTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgY2x1c3RlckVuZ2luZT86IHJkcy5JQ2x1c3RlckVuZ2luZTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgYXVyb3JhU2VydmVybGVzcz86IGJvb2xlYW47XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHNpbmdsZURiSW5zdGFuY2U/OiBib29sZWFuO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBiYWNrdXBSZXRlbnRpb24/OiBjZGsuRHVyYXRpb247XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgc2VydmljZVByb3BzPzogRmFyZ2F0ZVRhc2tQcm9wcztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBzcG90PzogYm9vbGVhbjtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGVuYWJsZUV4ZWN1dGVDb21tYW5kPzogYm9vbGVhbjtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBjb2RlOiBzdHJpbmc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgY29udGFpbmVyUG9ydD86IG51bWJlcjtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgbG9hZGJhbGFuY2VyOiBMb2FkQmFsYW5jZXJBY2Nlc3NpYmlsaXR5O1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgZGVmYXVsdERhdGFiYXNlTmFtZT86IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgZWZzRmlsZVN5c3RlbT86IGVmcy5GaWxlU3lzdGVtUHJvcHM7XG5cbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBjbGFzcyBMYXJhdmVsIGV4dGVuZHMgY2RrLkNvbnN0cnVjdCB7XG4gIHJlYWRvbmx5IHZwYzogZWMyLklWcGM7XG4gIHJlYWRvbmx5IGRiPzogRGF0YWJhc2U7XG4gIHJlYWRvbmx5IHN2YzogRHVhbEFsYkZhcmdhdGVTZXJ2aWNlO1xuICBjb25zdHJ1Y3RvcihzY29wZTogY2RrLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IExhcmF2ZWxQcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICB0aGlzLnZwYyA9IHByb3BzLnZwYyA/PyBnZXRPckNyZWF0ZVZwYyh0aGlzKTtcbiAgICB0aGlzLmRiID0gdGhpcy5hZGREYXRhYmFzZSh7XG4gICAgICB2cGM6IHRoaXMudnBjLFxuICAgICAgZGF0YWJhc2VTdWJuZXRzOiBwcm9wcy5kYXRhYmFzZVN1Ym5ldHMsXG4gICAgICBpbnN0YW5jZVR5cGU6IHByb3BzLmRhdGFiYXNlSW5zdGFuY2VUeXBlLFxuICAgICAgaW5zdGFuY2VFbmdpbmU6IHByb3BzLmluc3RhbmNlRW5naW5lLFxuICAgICAgY2x1c3RlckVuZ2luZTogcHJvcHMuY2x1c3RlckVuZ2luZSxcbiAgICAgIGF1cm9yYVNlcnZlcmxlc3M6IHByb3BzLmF1cm9yYVNlcnZlcmxlc3MsXG4gICAgICBzaW5nbGVEYkluc3RhbmNlOiBwcm9wcy5zaW5nbGVEYkluc3RhbmNlLFxuICAgICAgYmFja3VwUmV0ZW50aW9uOiBwcm9wcy5iYWNrdXBSZXRlbnRpb24sXG4gICAgICBkZWZhdWx0RGF0YWJhc2VOYW1lOiBwcm9wcy5kZWZhdWx0RGF0YWJhc2VOYW1lLFxuICAgIH0pO1xuXG4gICAgY29uc3QgbG9nR3JvdXAgPSBuZXcgbG9ncy5Mb2dHcm91cCh0aGlzLCAnTG9nR3JvdXAnLCB7XG4gICAgICByZXRlbnRpb246IGxvZ3MuUmV0ZW50aW9uRGF5cy5PTkVfTU9OVEgsXG4gICAgICByZW1vdmFsUG9saWN5OiBjZGsuUmVtb3ZhbFBvbGljeS5ERVNUUk9ZLFxuICAgIH0pO1xuXG4gICAgY29uc3QgdGFzayA9IG5ldyBlY3MuRmFyZ2F0ZVRhc2tEZWZpbml0aW9uKHRoaXMsICdUYXNrJywge1xuICAgICAgY3B1OiAyNTYsXG4gICAgICBtZW1vcnlMaW1pdE1pQjogNTEyLFxuICAgIH0pO1xuXG4gICAgdGFzay5hZGRDb250YWluZXIoJ0xhcmF2ZWwnLCB7XG4gICAgICBpbWFnZTogZWNzLkNvbnRhaW5lckltYWdlLmZyb21Bc3NldChwcm9wcy5jb2RlKSxcbiAgICAgIHBvcnRNYXBwaW5nczogW3sgY29udGFpbmVyUG9ydDogcHJvcHMuY29udGFpbmVyUG9ydCA/PyA4MCB9XSxcbiAgICAgIGVudmlyb25tZW50OiB7XG4gICAgICAgIExhcmF2ZWxfREJfTkFNRTogJ0xhcmF2ZWwnLFxuICAgICAgfSxcbiAgICAgIGxvZ2dpbmc6IG5ldyBlY3MuQXdzTG9nRHJpdmVyKHtcbiAgICAgICAgc3RyZWFtUHJlZml4OiAnTGFyYXZlbC1mYXJnYXRlJyxcbiAgICAgICAgbG9nR3JvdXAsXG4gICAgICB9KSxcbiAgICAgIHNlY3JldHM6IHtcbiAgICAgICAgTEFSQVZFTF9EQl9IT1NUOiBlY3MuU2VjcmV0LmZyb21TZWNyZXRzTWFuYWdlcihcbiAgICAgICAgICB0aGlzLmRiLnNlY3JldCxcbiAgICAgICAgICAnaG9zdCcsXG4gICAgICAgICksXG4gICAgICAgIExBUkFWRUxfREJfVVNFUjogZWNzLlNlY3JldC5mcm9tU2VjcmV0c01hbmFnZXIoXG4gICAgICAgICAgdGhpcy5kYi5zZWNyZXQsXG4gICAgICAgICAgJ3VzZXJuYW1lJyxcbiAgICAgICAgKSxcbiAgICAgICAgTEFSQVZFTF9EQl9QQVNTV09SRDogZWNzLlNlY3JldC5mcm9tU2VjcmV0c01hbmFnZXIoXG4gICAgICAgICAgdGhpcy5kYi5zZWNyZXQsXG4gICAgICAgICAgJ3Bhc3N3b3JkJyxcbiAgICAgICAgKSxcbiAgICAgIH0sXG4gICAgfSk7XG5cbiAgICBjb25zdCBoZWFsdGhDaGVjayA9IHtcbiAgICAgIHBhdGg6ICcvJyxcbiAgICAgIGludGVydmFsOiBjZGsuRHVyYXRpb24ubWludXRlcygxKSxcbiAgICB9O1xuXG4gICAgdGhpcy5zdmMgPSBuZXcgRHVhbEFsYkZhcmdhdGVTZXJ2aWNlKHRoaXMsICdBTEJGYXJnYXRlU2VydmljZScsIHtcbiAgICAgIHZwYzogdGhpcy52cGMsXG4gICAgICBzcG90OiBwcm9wcy5zcG90LFxuICAgICAgZW5hYmxlRXhlY3V0ZUNvbW1hbmQ6IHByb3BzLmVuYWJsZUV4ZWN1dGVDb21tYW5kLFxuICAgICAgdGFza3M6IHByb3BzLnNlcnZpY2VQcm9wcyA/IFtwcm9wcy5zZXJ2aWNlUHJvcHNdIDogW1xuICAgICAgICB7XG4gICAgICAgICAgZXh0ZXJuYWw6IHByb3BzLmxvYWRiYWxhbmNlcixcbiAgICAgICAgICB0YXNrLFxuICAgICAgICAgIGhlYWx0aENoZWNrLFxuICAgICAgICB9LFxuICAgICAgXSxcbiAgICAgIHJvdXRlNTNPcHM6IHsgZW5hYmxlTG9hZEJhbGFuY2VyQWxpYXM6IGZhbHNlIH0sXG4gICAgfSk7XG5cbiAgICBpZiAocHJvcHMuZWZzRmlsZVN5c3RlbSkge1xuICAgICAgLy8gRUZTIHZvbHVtZVxuICAgICAgY29uc3QgZmlsZXN5c3RlbSA9IG5ldyBlZnMuRmlsZVN5c3RlbSh0aGlzLCAnRmlsZVN5c3RlbScsIHByb3BzLmVmc0ZpbGVTeXN0ZW0pO1xuXG4gICAgICBjb25zdCB2b2x1bWVOYW1lID0gJ2Vmcyc7XG4gICAgICB0aGlzLnN2Yy5zZXJ2aWNlWzBdLnRhc2tEZWZpbml0aW9uLmFkZFZvbHVtZSh7XG4gICAgICAgIG5hbWU6IHZvbHVtZU5hbWUsXG4gICAgICAgIGVmc1ZvbHVtZUNvbmZpZ3VyYXRpb246IHtcbiAgICAgICAgICBmaWxlU3lzdGVtSWQ6IGZpbGVzeXN0ZW0uZmlsZVN5c3RlbUlkLFxuICAgICAgICB9LFxuICAgICAgfSk7XG5cbiAgICAgIC8vIGZpeCBtZSAtIHRlbnRhdGl2ZWx5IG1vdW50IHRvIC9lZnNtb3VudFxuICAgICAgdGhpcy5zdmMuc2VydmljZVswXS50YXNrRGVmaW5pdGlvbi5kZWZhdWx0Q29udGFpbmVyPy5hZGRNb3VudFBvaW50cyh7XG4gICAgICAgIGNvbnRhaW5lclBhdGg6ICcvZWZzbW91bnQnLFxuICAgICAgICByZWFkT25seTogZmFsc2UsXG4gICAgICAgIHNvdXJjZVZvbHVtZTogdm9sdW1lTmFtZSxcbiAgICAgIH0pO1xuXG4gICAgICBmaWxlc3lzdGVtLmNvbm5lY3Rpb25zLmFsbG93RnJvbShuZXcgZWMyLkNvbm5lY3Rpb25zKHsgc2VjdXJpdHlHcm91cHM6IHRoaXMuc3ZjLnNlcnZpY2VbMF0uY29ubmVjdGlvbnMuc2VjdXJpdHlHcm91cHMgfSksIGVjMi5Qb3J0LnRjcCgyMDQ5KSwgJ2FsbG93IExhcmF2ZWwgdG8gY29ubmVjdCB0byBlZnMgZmlsZXN5c3RlbScpO1xuICAgIH1cblxuXG4gICAgdGhpcy5kYi5jb25uZWN0aW9ucy5hbGxvd0Zyb20odGhpcy5zdmMuc2VydmljZVswXSwgdGhpcy5kYi5jb25uZWN0aW9ucy5kZWZhdWx0UG9ydCEsIGBhbGxvdyAke3RoaXMuc3ZjLnNlcnZpY2VbMF0uc2VydmljZU5hbWV9IHRvIGNvbm5lY3QgdG8gZGF0YWJhc2VgKTtcblxuICB9XG4gIHByaXZhdGUgYWRkRGF0YWJhc2UocHJvcHM6IERhdGFiYXNlUHJvcHMpOiBEYXRhYmFzZSB7XG4gICAgcmV0dXJuIG5ldyBEYXRhYmFzZSh0aGlzLCAnRGF0YWJhc2UnLCB7XG4gICAgICAuLi5wcm9wcyxcbiAgICB9KTtcbiAgfVxufSJdfQ==