import { IRole } from 'aws-cdk-lib/aws-iam';
import { Construct } from 'constructs';
import { AccountAccessType, AuthenticationProviders, IWorkspace, NetworkAccessControl, NotificationDestinations, PermissionTypes, SamlConfiguration, SamlConfigurationStatuses, Status, VpcConfiguration, WorkspaceBase } from './workspace-base';
/**
 * Properties for creating an Amazon Managed Grafana workspace.
 */
export interface WorkspaceProps {
    /**
     * Specifies whether the workspace can access AWS resources in this AWS account only, or whether
     * it can also access AWS resources in other accounts in the same organization. If this is
     * ORGANIZATION, the OrganizationalUnits parameter specifies which organizational units the
     * workspace can access.
     *
     * Required field.
     */
    readonly accountAccessType: AccountAccessType;
    /**
     * Specifies whether this workspace uses SAML 2.0, AWS IAM Identity Center, or both to
     * authenticate users for using the Grafana console within a workspace.
     *
     * Required field.
     */
    readonly authenticationProviders: AuthenticationProviders[];
    /**
     * A unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
     *
     * Must be 1-64 characters long and contain only printable ASCII characters.
     */
    readonly clientToken?: string;
    /**
     * Specifies the AWS data sources that have been configured to have IAM roles and permissions
     * created to allow Amazon Managed Grafana to read data from these sources.
     * This list is only used when the workspace was created through the AWS console, and the
     * permissionType is SERVICE_MANAGED.
     */
    readonly dataSources?: string[];
    /**
     * The user-defined description of the workspace.
     *
     * Maximum length of 2048 characters.
     */
    readonly description?: string;
    /**
     * Specifies the version of Grafana to support in the workspace. Defaults to the latest version
     * on create (for example, 9.4), or the current version of the workspace on update.
     * Can only be used to upgrade (for example, from 8.4 to 9.4), not downgrade (for example, from
     * 9.4 to 8.4).
     *
     * Must be 1-255 characters long.
     */
    readonly grafanaVersion?: string;
    /**
     * The name of the workspace.
     *
     * Must be 1-255 characters long and contain only alphanumeric characters, hyphens, dots,
     * underscores, and tildes.
     */
    readonly name?: string;
    /**
     * The configuration settings for network access to your workspace.
     */
    readonly networkAccessControl?: NetworkAccessControl;
    /**
     * The AWS notification channels that Amazon Managed Grafana can automatically create IAM roles
     * and permissions for, to allow Amazon Managed Grafana to use these channels.
     */
    readonly notificationDestinations?: NotificationDestinations[];
    /**
     * Specifies the organizational units that this workspace is allowed to use data sources from, if
     * this workspace is in an account that is part of an organization.
     */
    readonly organizationalUnits?: string[];
    /**
     * Name of the IAM role to use for the organization.
     * Maximum length of 2048 characters.
     */
    readonly organizationRoleName?: string;
    /**
     * If this is SERVICE_MANAGED, and the workplace was created through the Amazon Managed Grafana
     * console, then Amazon Managed Grafana automatically creates the IAM roles and provisions the
     * permissions that the workspace needs to use AWS data sources and notification channels.
     *
     * If this is CUSTOMER_MANAGED, you must manage those roles and permissions yourself.
     *
     * If you are working with a workspace in a member account of an organization and that account is
     * not a delegated administrator account, and you want the workspace to access data sources in
     * other AWS accounts in the organization, this parameter must be set to CUSTOMER_MANAGED.
     *
     * Required field.
     */
    readonly permissionType: PermissionTypes;
    /**
     * Whether plugin administration is enabled in the workspace. Setting to true allows workspace
     * admins to install, uninstall, and update plugins from within the Grafana workspace.
     *
     * This option is only valid for workspaces that support Grafana version 9 or newer.
     *
     * Default: false
     */
    readonly pluginAdminEnabled?: boolean;
    /**
     * The IAM role that grants permissions to the AWS resources that the workspace will view data
     * from.
     */
    readonly role?: IRole;
    /**
     * If the workspace uses SAML, use this structure to map SAML assertion attributes to workspace
     * user information and define which groups in the assertion attribute are to have the Admin and
     * Editor roles in the workspace.
     */
    readonly samlConfiguration?: SamlConfiguration;
    /**
     * The name of the AWS CloudFormation stack set that is used to generate IAM roles to be used for
     * this workspace.
     */
    readonly stackSetName?: string;
    /**
     * The configuration settings for an Amazon VPC that contains data sources for your Grafana
     * workspace to connect to.
     */
    readonly vpcConfiguration?: VpcConfiguration;
}
export interface WorkspaceAttributes {
    /**
     * Specifies whether the workspace can access AWS resources in this AWS account only, or whether
     * it can also access AWS resources in other accounts in the same organization. If this is
     * ORGANIZATION, the OrganizationalUnits parameter specifies which organizational units the
     * workspace can access.
     *
     * Required field.
     */
    readonly accountAccessType: AccountAccessType;
    /**
     * Specifies whether this workspace uses SAML 2.0, AWS IAM Identity Center, or both to
     * authenticate users for using the Grafana console within a workspace.
     *
     * Required field.
     */
    readonly authenticationProviders: AuthenticationProviders[];
    /**
     * A unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
     *
     * Must be 1-64 characters long and contain only printable ASCII characters.
     */
    readonly clientToken?: string;
    /**
     * Specifies the AWS data sources that have been configured to have IAM roles and permissions
     * created to allow Amazon Managed Grafana to read data from these sources.
     * This list is only used when the workspace was created through the AWS console, and the
     * permissionType is SERVICE_MANAGED.
     */
    readonly dataSources?: string[];
    /**
     * The user-defined description of the workspace.
     *
     * Maximum length of 2048 characters.
     */
    readonly description?: string;
    /**
     * The name of the workspace.
     *
     * Must be 1-255 characters long and contain only alphanumeric characters, hyphens, dots,
     * underscores, and tildes.
     */
    readonly name?: string;
    /**
     * The configuration settings for network access to your workspace.
     */
    readonly networkAccessControl?: NetworkAccessControl;
    /**
     * The AWS notification channels that Amazon Managed Grafana can automatically create IAM roles
     * and permissions for, to allow Amazon Managed Grafana to use these channels.
     */
    readonly notificationDestinations?: NotificationDestinations[];
    /**
     * Specifies the organizational units that this workspace is allowed to use data sources from, if
     * this workspace is in an account that is part of an organization.
     */
    readonly organizationalUnits?: string[];
    /**
     * Name of the IAM role to use for the organization.
     * Maximum length of 2048 characters.
     */
    readonly organizationRoleName?: string;
    /**
     * If this is SERVICE_MANAGED, and the workplace was created through the Amazon Managed Grafana
     * console, then Amazon Managed Grafana automatically creates the IAM roles and provisions the
     * permissions that the workspace needs to use AWS data sources and notification channels.
     *
     * If this is CUSTOMER_MANAGED, you must manage those roles and permissions yourself.
     *
     * If you are working with a workspace in a member account of an organization and that account is
     * not a delegated administrator account, and you want the workspace to access data sources in
     * other AWS accounts in the organization, this parameter must be set to CUSTOMER_MANAGED.
     *
     * Required field.
     */
    readonly permissionType: PermissionTypes;
    /**
     * Whether plugin administration is enabled in the workspace. Setting to true allows workspace
     * admins to install, uninstall, and update plugins from within the Grafana workspace.
     *
     * This option is only valid for workspaces that support Grafana version 9 or newer.
     *
     * Default: false
     */
    readonly pluginAdminEnabled?: boolean;
    /**
     * The IAM role that grants permissions to the AWS resources that the workspace will view data
     * from.
     */
    readonly role?: IRole;
    /**
     * If the workspace uses SAML, use this structure to map SAML assertion attributes to workspace
     * user information and define which groups in the assertion attribute are to have the Admin and
     * Editor roles in the workspace.
     */
    readonly samlConfiguration?: SamlConfiguration;
    /**
     * The name of the AWS CloudFormation stack set that is used to generate IAM roles to be used for
     * this workspace.
     */
    readonly stackSetName?: string;
    /**
     * The configuration settings for an Amazon VPC that contains data sources for your Grafana
     * workspace to connect to.
     */
    readonly vpcConfiguration?: VpcConfiguration;
    /**
     * The arn of this workspace.
     */
    readonly workspaceArn: string;
}
/**
 * Specifies a workspace. In a workspace, you can create Grafana dashboards and visualizations to
 * analyze your metrics, logs, and traces. You don't have to build, package, or deploy any hardware
 * to run the Grafana server.
 */
export declare class Workspace extends WorkspaceBase {
    static fromWorkspaceAttributes(scope: Construct, id: string, attrs: WorkspaceAttributes): IWorkspace;
    /**
     * Validates the clientToken property.
     *
     * @param token - The client token to validate
     * @returns An array of error messages if validation fails, or an empty array if valid
     *
     * Validation rules:
     * - Must be a string
     * - Must be between 1 and 64 characters long
     * - Must contain only printable ASCII characters
     */
    private static validateClientToken;
    /**
     * Validates the description property.
     *
     * @param description - The description to validate
     * @returns An array of error messages if validation fails, or an empty array if valid
     *
     * Validation rules:
     * - Must be a string
     * - Maximum length of 2048 characters
     */
    private static validateDescription;
    /**
     * Validates the grafanaVersion property.
     *
     * @param version - The Grafana version to validate
     * @returns An array of error messages if validation fails, or an empty array if valid
     *
     * Validation rules:
     * - Must be a string
     * - Must be between 1 and 255 characters long
     */
    private static validateGrafanaVersion;
    /**
     * Validates the name property.
     *
     * @param name - The workspace name to validate
     * @returns An array of error messages if validation fails, or an empty array if valid
     *
     * Validation rules:
     * - Must be a string
     * - Must be between 1 and 255 characters long
     * - Can only contain alphanumeric characters, hyphens, dots, underscores, and tildes
     */
    private static validateName;
    /**
     * Validates the networkAccessControl property.
     *
     * @param nac - The network access control configuration to validate
     * @returns An array of error messages if validation fails, or an empty array if valid
     *
     * Validation rules:
     * - Must be an object
     * - prefixLists (if present) must be an array with at most 5 items
     * - vpcEndpoints (if present) must be an array with at most 5 items
     */
    private static validateNetworkAccessControl;
    /**
     * Validates the organizationRoleName property.
     *
     * @param roleName - The organization role name to validate
     * @returns An array of error messages if validation fails, or an empty array if valid
     *
     * Validation rules:
     * - Must be a string
     * - Must be between 1 and 2048 characters long
     */
    private static validateOrganizationRoleName;
    /**
     * Validates the SAML assertion attributes.
     *
     * @param obj - The SAML assertion attributes to validate
     * @returns An array of error messages if validation fails, or an empty array if valid
     *
     * Validation rules:
     * - Must be an object
     * - Each attribute must be a string
     * - Each attribute must be between 1 and 256 characters long
     * - Valid attribute keys are: 'email', 'groups', 'login', 'name', 'org', 'role'
     */
    private static validateSamlAssertionAttributes;
    /**
     * Validates the SAML IdP metadata.
     *
     * @param obj - The SAML IdP metadata to validate
     * @returns An array of error messages if validation fails, or an empty array if valid
     *
     * Validation rules:
     * - Must be an object
     * - url (if present) must be a string between 1 and 2048 characters long
     * - xml (if present) must be a string
     */
    private static validateSamlIdpMetadata;
    /**
     * Validates the SAML configuration.
     *
     * @param config - The SAML configuration to validate
     * @returns An array of error messages if validation fails, or an empty array if valid
     *
     * Validation rules:
     * - Must be an object
     * - idpMetadata is required and must be valid
     * - assertionAtrributes (if present) must be valid
     * - allowedOrganizations (if present) must be an array of strings with 1-256 elements
     * - loginValidityDuration (if present) must be a positive number
     * - roleValues (if present) must be an object with valid admin and editor arrays
     */
    private static validateSamlConfiguration;
    /**
     * Validates the vpcConfiguration property.
     *
     * @param config - The VPC configuration to validate
     * @returns An array of error messages if validation fails, or an empty array if valid
     *
     * Validation rules:
     * - Must be an object
     * - securityGroups is required and must be an array with 1-5 items
     * - subnets is required and must be an array with 2-6 items
     */
    private static validateVpcConfiguration;
    /**
     * Validates all workspace properties.
     *
     * @param props - The workspace properties to validate
     * @returns An array of error messages if validation fails, or an empty array if valid
     *
     * This method aggregates validation results from all individual property validators.
     * It throws an error if props is not an object.
     */
    private static validateProps;
    /**
     * Specifies whether the workspace can access AWS resources in this AWS account only, or whether
     * it can also access AWS resources in other accounts in the same organization. If this is
     * ORGANIZATION, the OrganizationalUnits parameter specifies which organizational units the
     * workspace can access.
     */
    readonly accountAccessType: AccountAccessType;
    /**
     * Specifies whether this workspace uses SAML 2.0, AWS IAM Identity Center, or both to
     * authenticate users for using the Grafana console within a workspace.
     */
    readonly authenticationProviders: AuthenticationProviders[];
    /**
     * A unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
     */
    readonly clientToken?: string;
    /**
     * Specifies the AWS data sources that have been configured to have IAM roles and permissions
     * created to allow Amazon Managed Grafana to read data from these sources.
     *
     * This list is only used when the workspace was created through the AWS console, and the
     * permissionType is SERVICE_MANAGED.
     */
    readonly dataSources?: string[];
    /**
     * The user-defined description of the workspace.
     */
    readonly description?: string;
    /**
     * The name of the workspace.
     */
    readonly name?: string;
    /**
     * The configuration settings for network access to your workspace.
     */
    readonly networkAccessControl?: NetworkAccessControl;
    /**
     * The AWS notification channels that Amazon Managed Grafana can automatically create IAM roles
     * and permissions for, to allow Amazon Managed Grafana to use these channels.
     */
    readonly notificationDestinations?: NotificationDestinations[];
    /**
     * Specifies the organizational units that this workspace is allowed to use data sources from, if
     * this workspace is in an account that is part of an organization.
     */
    readonly organizationalUnits?: string[];
    /**
     * The name of the IAM role that is used to access resources through Organizations.
     */
    readonly organizationRoleName?: string;
    /**
     * If this is SERVICE_MANAGED, and the workplace was created through the Amazon Managed Grafana
     * console, then Amazon Managed Grafana automatically creates the IAM roles and provisions the
     * permissions that the workspace needs to use AWS data sources and notification channels.
     *
     * If this is CUSTOMER_MANAGED, you must manage those roles and permissions yourself.
     *
     * If you are working with a workspace in a member account of an organization and that account is
     * not a delegated administrator account, and you want the workspace to access data sources in
     * other AWS accounts in the organization, this parameter must be set to CUSTOMER_MANAGED.
     */
    readonly permissionType: PermissionTypes;
    /**
     * Whether plugin administration is enabled in the workspace. Setting to true allows workspace
     * admins to install, uninstall, and update plugins from within the Grafana workspace.
     *
     * This option is only valid for workspaces that support Grafana version 9 or newer.
     */
    readonly pluginAdminEnabled?: boolean;
    /**
     * The IAM role that grants permissions to the AWS resources that the workspace will view data
     * from.
     */
    readonly role?: IRole;
    /**
     * If the workspace uses SAML, use this structure to map SAML assertion attributes to workspace
     * user information and define which groups in the assertion attribute are to have the Admin and
     * Editor roles in the workspace.
     */
    readonly samlConfiguration?: SamlConfiguration;
    /**
     * The name of the AWS CloudFormation stack set that is used to generate IAM roles to be used for
     * this workspace.
     */
    readonly stackSetName?: string;
    /**
     * The configuration settings for an Amazon VPC that contains data sources for your Grafana
     * workspace to connect to.
     */
    readonly vpcConfiguration?: VpcConfiguration;
    /**
     * The underlying CloudFormation resource.
     */
    private readonly workspace;
    /**
     * The date that the workspace was created.
     */
    readonly creationTimestamp: string;
    /**
     * The URL that users can use to access the Grafana console in the workspace.
     */
    readonly endpoint: string;
    /**
     * Specifies the version of Grafana supported by this workspace.
     */
    readonly grafanaVersion: string;
    /**
     * The unique ID of this workspace.
     */
    readonly workspaceId: string;
    /**
     * The most recent date that the workspace was modified.
     */
    readonly modificationTimestamp: string;
    /**
     * Specifies whether the workspace's SAML configuration is complete.
     */
    readonly samlConfigurationStatus: SamlConfigurationStatuses;
    /**
     * The ID of the IAM Identity Center-managed application that is created by Amazon Managed
     * Grafana.
     */
    readonly ssoClientId: string;
    /**
     * The current status of the workspace.
     */
    readonly status: Status;
    /**
     * The arn of this workspace.
     */
    readonly workspaceArn: string;
    constructor(scope: Construct, id: string, props: WorkspaceProps);
}
