# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['openapi_schema_validator']

package_data = \
{'': ['*']}

install_requires = \
['attrs>=19.2.0', 'jsonschema>=4.0.0,<5.0.0']

extras_require = \
{'isodate': ['isodate'],
 'rfc3339-validator': ['rfc3339-validator'],
 'strict-rfc3339': ['strict-rfc3339']}

setup_kwargs = {
    'name': 'openapi-schema-validator',
    'version': '0.3.3',
    'description': 'OpenAPI schema validation for Python',
    'long_description': '************************\nopenapi-schema-validator\n************************\n\n.. image:: https://img.shields.io/pypi/v/openapi-schema-validator.svg\n     :target: https://pypi.python.org/pypi/openapi-schema-validator\n.. image:: https://travis-ci.org/p1c2u/openapi-schema-validator.svg?branch=master\n     :target: https://travis-ci.org/p1c2u/openapi-schema-validator\n.. image:: https://img.shields.io/codecov/c/github/p1c2u/openapi-schema-validator/master.svg?style=flat\n     :target: https://codecov.io/github/p1c2u/openapi-schema-validator?branch=master\n.. image:: https://img.shields.io/pypi/pyversions/openapi-schema-validator.svg\n     :target: https://pypi.python.org/pypi/openapi-schema-validator\n.. image:: https://img.shields.io/pypi/format/openapi-schema-validator.svg\n     :target: https://pypi.python.org/pypi/openapi-schema-validator\n.. image:: https://img.shields.io/pypi/status/openapi-schema-validator.svg\n     :target: https://pypi.python.org/pypi/openapi-schema-validator\n\nAbout\n#####\n\nOpenapi-schema-validator is a Python library that validates schema against:\n\n* `OpenAPI Schema Specification v3.0 <https://github.com/OAI/OpenAPI-Specification/blob/master/versions/3.0.0.md#schemaObject>`__ which is an extended subset of the `JSON Schema Specification Wright Draft 00 <http://json-schema.org/>`__.\n* `OpenAPI Schema Specification v3.1 <https://github.com/OAI/OpenAPI-Specification/blob/master/versions/3.1.0.md#schemaObject>`__ which is an extended superset of the `JSON Schema Specification Draft 2020-12 <http://json-schema.org/>`__.\n\nInstallation\n############\n\nRecommended way (via pip):\n\n::\n\n    $ pip install openapi-schema-validator\n\nAlternatively you can download the code and install from the repository:\n\n.. code-block:: bash\n\n   $ pip install -e git+https://github.com/p1c2u/openapi-schema-validator.git#egg=openapi_schema_validator\n\n\nUsage\n#####\n\nBy default, the latest OpenAPI schema syntax is expected.\n\nTo validate an OpenAPI v3.1 schema:\n\n.. code-block:: python\n\n   from openapi_schema_validator import validate\n\n   # A sample schema\n   schema = {\n       "type": "object",\n       "required": [\n          "name"\n       ],\n       "properties": {\n           "name": {\n               "type": "string"\n           },\n           "age": {\n               "type": ["integer", "null"],\n               "format": "int32",\n               "minimum": 0,\n           },\n           "birth-date": {\n               "type": "string",\n               "format": "date",\n           },\n           "address": {\n                "type": \'array\',\n                "prefixItems": [\n                    { "type": "number" },\n                    { "type": "string" },\n                    { "enum": ["Street", "Avenue", "Boulevard"] },\n                    { "enum": ["NW", "NE", "SW", "SE"] }\n                ],\n                "items": False,\n            }\n       },\n       "additionalProperties": False,\n   }\n\n   # If no exception is raised by validate(), the instance is valid.\n   validate({"name": "John", "age": 23, "address": [1600, "Pennsylvania", "Avenue"]}, schema)\n\n   validate({"name": "John", "city": "London"}, schema)\n\n   Traceback (most recent call last):\n       ...\n   ValidationError: Additional properties are not allowed (\'city\' was unexpected)\n\nif you want to disambiguate the expected schema version, import and use ``OAS31Validator``:\n\n.. code-block:: python\n\n   from openapi_schema_validator import OAS31Validator\n\n   validate({"name": "John", "age": 23}, schema, cls=OAS31Validator)\n\nIn order to validate OpenAPI 3.0 schema, import and use ``OAS30Validator`` instead of ``OAS31Validator``.\n\n.. code-block:: python\n\n   from openapi_schema_validator import OAS30Validator\n\n   # A sample schema\n   schema = {\n       "type": "object",\n       "required": [\n          "name"\n       ],\n       "properties": {\n           "name": {\n               "type": "string"\n           },\n           "age": {\n               "type": "integer",\n               "format": "int32",\n               "minimum": 0,\n               "nullable": True,\n           },\n           "birth-date": {\n               "type": "string",\n               "format": "date",\n           }\n       },\n       "additionalProperties": False,\n   }\n\n   validate({"name": "John", "age": 23}, schema, cls=OAS30Validator)\n\nFormat check\n************\n\nYou can also check format for primitive types\n\n.. code-block:: python\n\n   from openapi_schema_validator import oas31_format_checker\n\n   validate({"name": "John", "birth-date": "-12"}, schema, format_checker=oas31_format_checker)\n\n   Traceback (most recent call last):\n       ...\n   ValidationError: \'-12\' is not a \'date\'\n\nReferences\n**********\n\nYou can resolve JOSN references by passing custon reference resolver\n\n.. code-block:: python\n\n   from jsonschema.validators import RefResolver\n\n   # A schema with reference\n   schema = {\n       "type" : "object",\n       "required": [\n          "name"\n       ],\n       "properties": {\n           "name": {\n               "$ref": "#/components/schemas/Name"\n           },\n           "age": {\n               "$ref": "#/components/schemas/Age"\n           },\n           "birth-date": {\n               "$ref": "#/components/schemas/BirthDate"\n           }\n       },\n       "additionalProperties": False,\n   }\n   # Referenced schemas\n   schemas = {\n       "components": {\n           "schemas": {\n               "Name": {\n                   "type": "string"\n               },\n               "Age": {\n                   "type": "integer",\n                   "format": "int32",\n                   "minimum": 0,\n                   "nullable": True,\n               },\n               "BirthDate": {\n                   "type": "string",\n                   "format": "date",\n               }\n           },\n       },\n   }\n\n   ref_resolver = RefResolver.from_schema(schemas)\n\n   validate({"name": "John", "age": 23}, schema, resolver=ref_resolver)\n\nFor more information about reference resolver see `Resolving JSON References <https://python-jsonschema.readthedocs.io/en/stable/references/>`__\n\nRelated projects\n################\n* `openapi-core <https://github.com/p1c2u/openapi-core>`__\n   Python library that adds client-side and server-side support for the OpenAPI.\n* `openapi-spec-validator <https://github.com/p1c2u/openapi-spec-validator>`__\n   Python library that validates OpenAPI Specs against the OpenAPI 2.0 (aka Swagger) and OpenAPI 3.0 specification\n',
    'author': 'Artur Maciag',
    'author_email': 'maciag.artur@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/p1c2u/openapi-schema-validator',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.7.0,<4.0.0',
}


setup(**setup_kwargs)
