# ----------------------------------
# Status
# ----------------------------------
UNDEFINED_STATUS = "?"

# ----------------------------------
# Monitors
# ----------------------------------
_MONITOR_STATUS_SUCCESS = "OK"
_MONITOR_STATUS_FAILURE = "FAIL"
_MONITOR_STATUS_SKIPPED = "SKIPPED"
_MONITOR_STATUS_ERROR = "ERROR"
_MONITOR_STATUS_EXPECTED_FAILURE = "EXPECTED FAILURE"
_MONITOR_STATUS_UNEXPECTED_SUCCESS = "UNEXPECTED SUCCESS"

_MONITOR_LEVEL_HIGH = "HIGH"
_MONITOR_LEVEL_NORMAL = "NORMAL"
_MONITOR_LEVEL_LOW = "LOW"


class MONITOR:
    class STATUS:
        SUCCESS = _MONITOR_STATUS_SUCCESS
        FAILURE = _MONITOR_STATUS_FAILURE
        SKIPPED = _MONITOR_STATUS_SKIPPED
        ERROR = _MONITOR_STATUS_ERROR
        EXPECTED_FAILURE = _MONITOR_STATUS_EXPECTED_FAILURE
        UNEXPECTED_SUCCESS = _MONITOR_STATUS_UNEXPECTED_SUCCESS

    class STATUSES(object):
        ALL = (
            _MONITOR_STATUS_SUCCESS,
            _MONITOR_STATUS_FAILURE,
            _MONITOR_STATUS_SKIPPED,
            _MONITOR_STATUS_ERROR,
            _MONITOR_STATUS_EXPECTED_FAILURE,
            _MONITOR_STATUS_UNEXPECTED_SUCCESS,
        )
        SUCCESSFUL = (
            _MONITOR_STATUS_SUCCESS,
            _MONITOR_STATUS_SKIPPED,
            _MONITOR_STATUS_EXPECTED_FAILURE,
            _MONITOR_STATUS_UNEXPECTED_SUCCESS,
        )
        ERROR = (_MONITOR_STATUS_FAILURE, _MONITOR_STATUS_ERROR)
        DEFAULT = UNDEFINED_STATUS

    class LEVEL:
        HIGH = _MONITOR_LEVEL_HIGH
        NORMAL = _MONITOR_LEVEL_NORMAL
        LOW = _MONITOR_LEVEL_LOW

    class LEVELS:
        ALL = (_MONITOR_LEVEL_HIGH, _MONITOR_LEVEL_NORMAL, _MONITOR_LEVEL_LOW)
        DEFAULT = _MONITOR_LEVEL_NORMAL

    DEFAULT_NAME = None
    DEFAULT_DESCRIPTION = ""
    DEFAULT_ORDER = 1


# ----------------------------------
# Actions
# ----------------------------------
_ACTION_STATUS_SUCCESS = "OK"
_ACTION_STATUS_ERROR = "ERROR"
_ACTION_STATUS_SKIPPED = "SKIPPED"


class ACTION:
    class STATUS:
        SUCCESS = _ACTION_STATUS_SUCCESS
        ERROR = _ACTION_STATUS_ERROR
        SKIPPED = _ACTION_STATUS_SKIPPED

    class STATUSES(object):
        ALL = (_ACTION_STATUS_SUCCESS, _ACTION_STATUS_ERROR, _ACTION_STATUS_SKIPPED)
        SUCCESSFUL = (_ACTION_STATUS_SUCCESS, _ACTION_STATUS_SKIPPED)
        ERROR = (_ACTION_STATUS_ERROR,)
        DEFAULT = UNDEFINED_STATUS

    DEFAULT_DESCRIPTION = ""


# ----------------------------------
# Steps
# ----------------------------------
_STEP_MONITORS = "MONITORS"
_STEP_MONITORS_FINISHED = "FINISHED ACTIONS"
_STEP_MONITORS_PASSED = "PASSED ACTIONS"
_STEP_MONITORS_FAILED = "FAILED ACTIONS"


class STEPS:
    MONITORS = _STEP_MONITORS
    MONITORS_FINISHED = _STEP_MONITORS_FINISHED
    MONITORS_PASSED = _STEP_MONITORS_PASSED
    MONITORS_FAILED = _STEP_MONITORS_FAILED
    ALL = (
        _STEP_MONITORS,
        _STEP_MONITORS_FINISHED,
        _STEP_MONITORS_PASSED,
        _STEP_MONITORS_FAILED,
    )
    MONITOR_RELATED = (_STEP_MONITORS,)
    ACTION_RELATED = (
        _STEP_MONITORS_FINISHED,
        _STEP_MONITORS_PASSED,
        _STEP_MONITORS_FAILED,
    )
