"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BootstrapPgStac = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
function hasVpc(instance) {
    return instance.vpc !== undefined;
}
const DEFAULT_PGSTAC_VERSION = "0.6.8";
/**
 * Bootstraps a database instance, installing pgSTAC onto the database.
 */
class BootstrapPgStac extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const { pgstacVersion = DEFAULT_PGSTAC_VERSION } = props;
        const handler = new aws_cdk_lib_1.aws_lambda.Function(this, "lambda", {
            handler: "handler.handler",
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_8,
            code: aws_cdk_lib_1.aws_lambda.Code.fromDockerBuild(__dirname, {
                file: "runtime/Dockerfile",
                buildArgs: { PGSTAC_VERSION: pgstacVersion },
            }),
            timeout: aws_cdk_lib_1.Duration.minutes(2),
            vpc: hasVpc(props.database) ? props.database.vpc : props.vpc,
            logRetention: aws_cdk_lib_1.aws_logs.RetentionDays.ONE_WEEK,
        });
        this.secret = new aws_cdk_lib_1.aws_secretsmanager.Secret(this, "secret", {
            secretName: [
                props.secretsPrefix || "pgstac",
                id,
                this.node.addr.slice(-8),
            ].join("/"),
            generateSecretString: {
                secretStringTemplate: JSON.stringify({
                    dbname: props.pgstacDbName || "pgstac",
                    engine: "postgres",
                    port: 5432,
                    host: props.database.instanceEndpoint.hostname,
                    username: props.pgstacUsername || "pgstac_user",
                }),
                generateStringKey: "password",
                excludePunctuation: true,
            },
            description: `PgSTAC database bootstrapped by ${aws_cdk_lib_1.Stack.of(this).stackName}`,
        });
        // Allow lambda to...
        // read new user secret
        this.secret.grantRead(handler);
        // read database secret
        props.dbSecret.grantRead(handler);
        // connect to database
        props.database.connections.allowFrom(handler, aws_cdk_lib_1.aws_ec2.Port.tcp(5432));
        // this.connections = props.database.connections;
        new aws_cdk_lib_1.CustomResource(this, "bootstrapper", {
            serviceToken: handler.functionArn,
            properties: {
                // By setting pgstac_version in the properties assures
                // that Create/Update events will be passed to the service token
                pgstac_version: pgstacVersion,
                conn_secret_arn: props.dbSecret.secretArn,
                new_user_secret_arn: this.secret.secretArn,
            },
            removalPolicy: aws_cdk_lib_1.RemovalPolicy.RETAIN,
        });
    }
}
exports.BootstrapPgStac = BootstrapPgStac;
_a = JSII_RTTI_SYMBOL_1;
BootstrapPgStac[_a] = { fqn: "cdk-pgstac.BootstrapPgStac", version: "2.2.1" };
//# sourceMappingURL=data:application/json;base64,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