# bmmltools

Current version 0.2.8

Last update 26/10/2022

PyPI: https://pypi.org/project/bmmltools/

Documentation: https://bmmltools.readthedocs.io/en/latest/

Author: Curcuraci L.

Contacts: Luca.Curcuraci@mpikg.mpg.de


This is a python library for 3d binary image segmentation developed at Max-Plank-Institute fuer Kolloid-und 
Grenzflaechenforschung. This library contains a series of tools which can be useful to segment 3d binary images
based on their structural/texture properties and extract information from the various regions identified,

### Installation

To install bmmltools use the Anaconda propt. In the propt, copy the lines below

```
(base) > conda create -n new_env python=3.8
(base) > conda activate new_env
(new_env) > conda install pytables=3.6.1
(new_env) > conda install hdbscan
(new_env) > pip install bmmltools
```

> **Possible import errors:**
> 
> If other packages are installed togheter with bmmltools, the following import error may appear some case:
> 
> 1. *hdbscan related import error*: typically this error is related to the "cachedir" variable and happens as soon one
>    imports the ```HDBSCAN()``` class. This is not an error of hdbscan, but it is related to the *joblib* package, which
>    has been recently (september 2022) updated to the 1.2.0 version in which the "cachedir" variables has been renamed.
>    The hdbscan module needs the version 1.10 of joblib to work without problems (maybe the 1.1.1 version is fine to),
>    therefore if you experience an import error of this kind, check if joblib is present in the correct version. If is 
>    not, uninstall it and install the correct version. This import error should disappear.

### Result visualization: bmmlboard

To inspect the intermediate results, a series of standard visualization tools has been developed. They are collected
in the **bmmlboard**, a web-browser based a graphical interface made using streamlit, which can be used to visualize 
the intermediate  results of bmmltools. To run the bmmlboard, write in the anaconda prompt

```
(base) > conda activate new_env
(new_env) > python -m bmmltools.run_bmmlboard
```

assuming that bmmltools is installed in the "new_env" environment.

> **Possible streamlit errors**:
> 
> Sometimes streamlit does not work on some computer. This may not be a streamlit related issue, rather an issue related
> to the permit to write certain environmental variables on the computer during the installation process. Clearly one
> can solve this problem by reinstalling everything with suitable flags, but an simpler and effective solution can be 
> the following:
> 
> 1. Download on the computer the content of the folder ``board``, which can be found in the folder ``src/bmmltools`` of
>    this repository.
> 
> 2. Run in the same python environment where the bmmltools has been installed the file ``home.py`` inside the 
>    downloaded folder with streamlit, namely write in an Anaconda prompt 
> 
>   ```
>   (new_env) > conda activate new_env
>   (new_env) > cd [PATH TO THE board FOLDER]
>   (new_env) [PATH TO THE board FOLDER] > streamlit run home.py
>   ```

## Example usage

A series of example scripts are available in the 'example folder' of this repository. A detailed explanation of what
they do can be founs in the "Miscellaneous" section of the bmmmltools documentation.