from __future__ import annotations

from typing import Any, Optional

class LayerHelperBase:
    def __init__(self, name: Any, layer_type: Any) -> None: ...
    @property
    def name(self): ...
    @property
    def layer_type(self): ...
    @property
    def main_program(self): ...
    @property
    def startup_program(self): ...
    @classmethod
    def set_default_dtype(cls, dtype: Any) -> None: ...
    @classmethod
    def get_default_dtype(cls): ...
    def to_variable(self, value: Any, name: Optional[str] = ...): ...
    def create_parameter(
        self,
        attr: Any,
        shape: Any,
        dtype: Optional[Any] = ...,
        is_bias: bool = ...,
        default_initializer: Optional[Any] = ...,
        stop_gradient: bool = ...,
        type: Any = ...,
    ): ...
    def create_variable_for_type_inference(self, dtype: Any, stop_gradient: bool = ..., shape: Optional[Any] = ...): ...
    def create_variable(self, *args: Any, **kwargs: Any): ...
    def create_global_variable(self, persistable: bool = ..., *args: Any, **kwargs: Any): ...
    def create_or_get_global_variable(self, name: Any, *args: Any, **kwargs: Any): ...
    def set_variable_initializer(self, var: Any, initializer: Any) -> None: ...
