from __future__ import annotations

from typing import Any, Optional

class Sampler:
    data_source: Any = ...
    def __init__(self, data_source: Optional[Any] = ...) -> None: ...
    def __iter__(self) -> Any: ...

class SequenceSampler(Sampler):
    data_source: Any = ...
    def __init__(self, data_source: Any) -> None: ...
    def __iter__(self) -> Any: ...
    def __len__(self): ...

class RandomSampler(Sampler):
    data_source: Any = ...
    replacement: Any = ...
    generator: Any = ...
    def __init__(
        self,
        data_source: Any,
        replacement: bool = ...,
        num_samples: Optional[Any] = ...,
        generator: Optional[Any] = ...,
    ) -> None: ...
    @property
    def num_samples(self): ...
    def __iter__(self) -> Any: ...
    def __len__(self): ...

class WeightedRandomSampler(Sampler):
    weights: Any = ...
    num_samples: Any = ...
    replacement: Any = ...
    def __init__(self, weights: Any, num_samples: Any, replacement: bool = ...) -> None: ...
    def __iter__(self) -> Any: ...
    def __len__(self): ...
