from __future__ import annotations

import abc
from abc import ABC
from typing import Any, Optional

from paddle.fluid.framework import program_guard as program_guard

class PassContext:
    def __init__(self) -> None: ...
    def set_attr(self, key: Any, value: Any) -> None: ...
    def get_attr(self, key: Any, default: Optional[Any] = ...): ...
    @property
    def passes(self): ...

class PassType:
    UNKNOWN: int = ...
    COMM_OPT: int = ...
    CALC_OPT: int = ...
    PARALLEL_OPT: int = ...
    FUSION_OPT: int = ...

class PassBase(ABC, metaclass=abc.ABCMeta):
    name: Any = ...
    def __init__(self) -> None: ...
    def set_attr(self, key: Any, value: Any): ...
    def get_attr(self, key: Any, default: Optional[Any] = ...): ...
    def apply(self, main_programs: Any, startup_programs: Any, context: Optional[Any] = ...): ...

def register_pass(name: Any): ...
def new_pass(name: Any, pass_attrs: Any = ...): ...

class CPPPassWrapper(PassBase):
    def __init__(self) -> None: ...
    @property
    def cpp_name(self) -> None: ...
    @property
    def cpp_attr_types(self): ...

class PassManager:
    def __init__(self, passes: Any, context: Optional[Any] = ..., auto_solve_conflict: bool = ...) -> None: ...
    def apply(self, main_programs: Any, startup_programs: Any): ...
    @property
    def context(self): ...
    @property
    def names(self): ...
    @property
    def passes(self): ...
