from __future__ import annotations

import abc
from datetime import datetime as datetime
from typing import Any, Optional

class ExecuteError(Exception): ...
class FSFileExistsError(Exception): ...
class FSFileNotExistsError(Exception): ...
class FSTimeOut(Exception): ...
class FSShellCmdAborted(ExecuteError): ...

class FS(metaclass=abc.ABCMeta):
    @abc.abstractmethod
    def ls_dir(self, fs_path: Any) -> Any: ...
    @abc.abstractmethod
    def is_file(self, fs_path: Any) -> Any: ...
    @abc.abstractmethod
    def is_dir(self, fs_path: Any) -> Any: ...
    @abc.abstractmethod
    def is_exist(self, fs_path: Any) -> Any: ...
    @abc.abstractmethod
    def upload(self, local_path: Any, fs_path: Any) -> Any: ...
    @abc.abstractmethod
    def download(self, fs_path: Any, local_path: Any) -> Any: ...
    @abc.abstractmethod
    def mkdirs(self, fs_path: Any) -> Any: ...
    @abc.abstractmethod
    def delete(self, fs_path: Any) -> Any: ...
    @abc.abstractmethod
    def need_upload_download(self) -> Any: ...
    @abc.abstractmethod
    def rename(self, fs_src_path: Any, fs_dst_path: Any) -> Any: ...
    @abc.abstractmethod
    def mv(self, fs_src_path: Any, fs_dst_path: Any, overwrite: bool = ..., test_exists: bool = ...) -> Any: ...
    @abc.abstractmethod
    def upload_dir(self, local_dir: Any, dest_dir: Any) -> Any: ...
    @abc.abstractmethod
    def list_dirs(self, fs_path: Any) -> Any: ...
    @abc.abstractmethod
    def touch(self, fs_path: Any, exist_ok: bool = ...) -> Any: ...
    @abc.abstractmethod
    def cat(self, fs_path: Optional[Any] = ...) -> Any: ...

class LocalFS(FS, metaclass=abc.ABCMeta):
    def ls_dir(self, fs_path: Any): ...
    def mkdirs(self, fs_path: Any) -> None: ...
    def rename(self, fs_src_path: Any, fs_dst_path: Any) -> None: ...
    def delete(self, fs_path: Any): ...
    def need_upload_download(self): ...
    def is_file(self, fs_path: Any): ...
    def is_dir(self, fs_path: Any): ...
    def is_exist(self, fs_path: Any): ...
    def touch(self, fs_path: Any, exist_ok: bool = ...) -> None: ...
    def mv(self, src_path: Any, dst_path: Any, overwrite: bool = ..., test_exists: bool = ...): ...
    def list_dirs(self, fs_path: Any): ...

class HDFSClient(FS, metaclass=abc.ABCMeta):
    pre_commands: Any = ...
    def __init__(self, hadoop_home: Any, configs: Any, time_out: Any = ..., sleep_inter: int = ...) -> None: ...
    def list_dirs(self, fs_path: Any): ...
    def ls_dir(self, fs_path: Any): ...
    def is_dir(self, fs_path: Any): ...
    def is_file(self, fs_path: Any): ...
    def is_exist(self, fs_path: Any): ...
    def upload_dir(self, local_dir: Any, dest_dir: Any, overwrite: bool = ...) -> None: ...
    def upload(self, local_path: Any, fs_path: Any, multi_processes: int = ..., overwrite: bool = ...): ...
    def download(self, fs_path: Any, local_path: Any, multi_processes: int = ..., overwrite: bool = ...): ...
    def mkdirs(self, fs_path: Any) -> None: ...
    def mv(self, fs_src_path: Any, fs_dst_path: Any, overwrite: bool = ..., test_exists: bool = ...): ...
    def delete(self, fs_path: Any): ...
    def touch(self, fs_path: Any, exist_ok: bool = ...): ...
    def need_upload_download(self): ...
    def cat(self, fs_path: Optional[Any] = ...): ...
    def list_files_info(self, path_list: Any): ...
