# coding: utf-8

"""
    Conekta API

    Conekta sdk

    The version of the OpenAPI document: 2.2.0
    Contact: engineering@conekta.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class TokenResponseCheckout(BaseModel):
    """
    TokenResponseCheckout
    """ # noqa: E501
    allowed_payment_methods: Optional[List[StrictStr]] = None
    can_not_expire: Optional[StrictBool] = Field(default=None, description="Indicates if the checkout can not expire.")
    emails_sent: Optional[StrictInt] = None
    exclude_card_networks: Optional[List[StrictStr]] = None
    expires_at: Optional[StrictInt] = Field(default=None, description="Date and time when the checkout expires.")
    failure_url: Optional[StrictStr] = Field(default=None, description="URL to redirect the customer to if the payment process fails.")
    force_3ds_flow: Optional[StrictBool] = Field(default=None, description="Indicates if the checkout forces the 3DS flow.")
    id: Optional[StrictStr] = None
    livemode: Optional[StrictBool] = None
    metadata: Optional[Dict[str, Any]] = None
    monthly_installments_enabled: Optional[StrictBool] = Field(default=None, description="Indicates if the checkout allows monthly installments.")
    monthly_installments_options: Optional[List[StrictInt]] = Field(default=None, description="List of monthly installments options.")
    name: Optional[StrictStr] = None
    needs_shipping_contact: Optional[StrictBool] = None
    object: Optional[StrictStr] = Field(default=None, description="Indicates the type of object, in this case checkout.")
    on_demand_enabled: Optional[StrictBool] = Field(default=None, description="Indicates if the checkout allows on demand payments.")
    paid_payments_count: Optional[StrictInt] = Field(default=None, description="Number of payments that have been paid.")
    recurrent: Optional[StrictBool] = Field(default=None, description="Indicates if the checkout is recurrent.")
    sms_sent: Optional[StrictInt] = None
    starts_at: Optional[StrictInt] = Field(default=None, description="Date and time when the checkout starts.")
    status: Optional[StrictStr] = Field(default=None, description="Status of the checkout.")
    success_url: Optional[StrictStr] = Field(default=None, description="URL to redirect the customer to after the payment process is completed.")
    type: Optional[StrictStr] = Field(default=None, description="Type of checkout.")
    __properties: ClassVar[List[str]] = ["allowed_payment_methods", "can_not_expire", "emails_sent", "exclude_card_networks", "expires_at", "failure_url", "force_3ds_flow", "id", "livemode", "metadata", "monthly_installments_enabled", "monthly_installments_options", "name", "needs_shipping_contact", "object", "on_demand_enabled", "paid_payments_count", "recurrent", "sms_sent", "starts_at", "status", "success_url", "type"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TokenResponseCheckout from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TokenResponseCheckout from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "allowed_payment_methods": obj.get("allowed_payment_methods"),
            "can_not_expire": obj.get("can_not_expire"),
            "emails_sent": obj.get("emails_sent"),
            "exclude_card_networks": obj.get("exclude_card_networks"),
            "expires_at": obj.get("expires_at"),
            "failure_url": obj.get("failure_url"),
            "force_3ds_flow": obj.get("force_3ds_flow"),
            "id": obj.get("id"),
            "livemode": obj.get("livemode"),
            "metadata": obj.get("metadata"),
            "monthly_installments_enabled": obj.get("monthly_installments_enabled"),
            "monthly_installments_options": obj.get("monthly_installments_options"),
            "name": obj.get("name"),
            "needs_shipping_contact": obj.get("needs_shipping_contact"),
            "object": obj.get("object"),
            "on_demand_enabled": obj.get("on_demand_enabled"),
            "paid_payments_count": obj.get("paid_payments_count"),
            "recurrent": obj.get("recurrent"),
            "sms_sent": obj.get("sms_sent"),
            "starts_at": obj.get("starts_at"),
            "status": obj.get("status"),
            "success_url": obj.get("success_url"),
            "type": obj.get("type")
        })
        return _obj


