# coding: utf-8

"""
    Conekta API

    Conekta sdk

    The version of the OpenAPI document: 2.2.0
    Contact: engineering@conekta.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class PlanRequest(BaseModel):
    """
    a plan
    """ # noqa: E501
    amount: Annotated[int, Field(strict=True, ge=1)] = Field(description="The amount in cents that will be charged on the interval specified.")
    currency: Optional[Annotated[str, Field(strict=True, max_length=3)]] = Field(default=None, description="ISO 4217 for currencies, for the Mexican peso it is MXN/USD")
    expiry_count: Optional[StrictInt] = Field(default=None, description="Number of repetitions of the frequency NUMBER OF CHARGES TO BE MADE, considering the interval and frequency, this evolves over time, but is subject to the expiration count.")
    frequency: Annotated[int, Field(strict=True, ge=1)] = Field(description="Frequency of the charge, which together with the interval, can be every 3 weeks, every 4 months, every 2 years, every 5 fortnights")
    id: Optional[StrictStr] = Field(default=None, description="internal reference id")
    interval: StrictStr = Field(description="The interval of time between each charge.")
    name: StrictStr = Field(description="The name of the plan.")
    trial_period_days: Optional[StrictInt] = Field(default=None, description="The number of days the customer will have a free trial.")
    max_retries: Optional[Annotated[int, Field(strict=True, ge=3)]] = Field(default=None, description="(optional) Specifies the maximum number of retry attempts for a subscription payment before it is canceled.")
    retry_delay_hours: Optional[Annotated[int, Field(strict=True, ge=48)]] = Field(default=None, description="(optional)  Defines the number of hours between subscription payment retry attempts.")
    __properties: ClassVar[List[str]] = ["amount", "currency", "expiry_count", "frequency", "id", "interval", "name", "trial_period_days", "max_retries", "retry_delay_hours"]

    @field_validator('interval')
    def interval_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['week', 'half_month', 'month', 'year']):
            raise ValueError("must be one of enum values ('week', 'half_month', 'month', 'year')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PlanRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PlanRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "amount": obj.get("amount"),
            "currency": obj.get("currency"),
            "expiry_count": obj.get("expiry_count"),
            "frequency": obj.get("frequency"),
            "id": obj.get("id"),
            "interval": obj.get("interval"),
            "name": obj.get("name"),
            "trial_period_days": obj.get("trial_period_days"),
            "max_retries": obj.get("max_retries"),
            "retry_delay_hours": obj.get("retry_delay_hours")
        })
        return _obj


