# coding: utf-8

"""
    Conekta API

    Conekta sdk

    The version of the OpenAPI document: 2.2.0
    Contact: engineering@conekta.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class LogsResponseData(BaseModel):
    """
    LogsResponseData
    """ # noqa: E501
    created_at: Optional[StrictInt] = None
    id: Optional[StrictStr] = None
    ip_address: Optional[StrictStr] = None
    livemode: Optional[StrictBool] = None
    loggable_id: Optional[StrictStr] = None
    loggable_type: Optional[StrictStr] = None
    method: Optional[StrictStr] = None
    oauth_token_id: Optional[StrictStr] = None
    query_string: Optional[Dict[str, Any]] = None
    related: Optional[StrictStr] = None
    request_body: Optional[Dict[str, Any]] = None
    request_headers: Optional[Dict[str, StrictStr]] = None
    response_body: Optional[Dict[str, Any]] = None
    response_headers: Optional[Dict[str, StrictStr]] = None
    searchable_tags: Optional[List[StrictStr]] = None
    status: Optional[StrictStr] = None
    updated_at: Optional[StrictStr] = None
    url: Optional[StrictStr] = None
    user_account_id: Optional[StrictStr] = None
    version: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["created_at", "id", "ip_address", "livemode", "loggable_id", "loggable_type", "method", "oauth_token_id", "query_string", "related", "request_body", "request_headers", "response_body", "response_headers", "searchable_tags", "status", "updated_at", "url", "user_account_id", "version"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of LogsResponseData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if loggable_id (nullable) is None
        # and model_fields_set contains the field
        if self.loggable_id is None and "loggable_id" in self.model_fields_set:
            _dict['loggable_id'] = None

        # set to None if loggable_type (nullable) is None
        # and model_fields_set contains the field
        if self.loggable_type is None and "loggable_type" in self.model_fields_set:
            _dict['loggable_type'] = None

        # set to None if oauth_token_id (nullable) is None
        # and model_fields_set contains the field
        if self.oauth_token_id is None and "oauth_token_id" in self.model_fields_set:
            _dict['oauth_token_id'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of LogsResponseData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "created_at": obj.get("created_at"),
            "id": obj.get("id"),
            "ip_address": obj.get("ip_address"),
            "livemode": obj.get("livemode"),
            "loggable_id": obj.get("loggable_id"),
            "loggable_type": obj.get("loggable_type"),
            "method": obj.get("method"),
            "oauth_token_id": obj.get("oauth_token_id"),
            "query_string": obj.get("query_string"),
            "related": obj.get("related"),
            "request_body": obj.get("request_body"),
            "request_headers": obj.get("request_headers"),
            "response_body": obj.get("response_body"),
            "response_headers": obj.get("response_headers"),
            "searchable_tags": obj.get("searchable_tags"),
            "status": obj.get("status"),
            "updated_at": obj.get("updated_at"),
            "url": obj.get("url"),
            "user_account_id": obj.get("user_account_id"),
            "version": obj.get("version")
        })
        return _obj


