# coding: utf-8

"""
    Conekta API

    Conekta sdk

    The version of the OpenAPI document: 2.2.0
    Contact: engineering@conekta.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from conekta.models.create_company_request_bank_account_info import CreateCompanyRequestBankAccountInfo
from conekta.models.create_company_request_comercial_info import CreateCompanyRequestComercialInfo
from conekta.models.create_company_request_fiscal_info import CreateCompanyRequestFiscalInfo
from typing import Optional, Set
from typing_extensions import Self

class CreateCompanyRequest(BaseModel):
    """
    CreateCompanyRequest
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="The name of the company.")
    type_company: Optional[StrictStr] = Field(default=None, description="The type of company, 'owner'")
    comercial_info: Optional[CreateCompanyRequestComercialInfo] = None
    fiscal_info: Optional[CreateCompanyRequestFiscalInfo] = None
    bank_account_info: Optional[CreateCompanyRequestBankAccountInfo] = None
    __properties: ClassVar[List[str]] = ["name", "type_company", "comercial_info", "fiscal_info", "bank_account_info"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateCompanyRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of comercial_info
        if self.comercial_info:
            _dict['comercial_info'] = self.comercial_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of fiscal_info
        if self.fiscal_info:
            _dict['fiscal_info'] = self.fiscal_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of bank_account_info
        if self.bank_account_info:
            _dict['bank_account_info'] = self.bank_account_info.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateCompanyRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "type_company": obj.get("type_company"),
            "comercial_info": CreateCompanyRequestComercialInfo.from_dict(obj["comercial_info"]) if obj.get("comercial_info") is not None else None,
            "fiscal_info": CreateCompanyRequestFiscalInfo.from_dict(obj["fiscal_info"]) if obj.get("fiscal_info") is not None else None,
            "bank_account_info": CreateCompanyRequestBankAccountInfo.from_dict(obj["bank_account_info"]) if obj.get("bank_account_info") is not None else None
        })
        return _obj


