#####packages needed
from os import walk,path,mkdir,listdir,remove,rmdir,makedirs
from pandas import read_csv, DataFrame,concat
from numpy import array, arange, log, sqrt,meshgrid, rot90,linspace,sort
from scipy import interpolate
from sklearn.linear_model import LinearRegression
from scipy.signal import savgol_filter
import matplotlib
import matplotlib.pyplot as plt
from matplotlib.colors import TwoSlopeNorm
import ipywidgets as widgets
from tkinter import *
from tkinter import ttk
from tkinter import filedialog
from tkinter.messagebox import showinfo
from PIL import Image, ImageTk
from urllib.request import urlopen
import igor
import warnings
import numpy as np
from ipywidgets import Output, VBox, HBox, FloatSlider, Dropdown, Checkbox, Button, Layout,interact
from scipy.ndimage import gaussian_filter1d
from IPython.display import display  # Correct import for display function

# Get the path to the igor module
igor_path = path.dirname(igor.__file__)

#print(f"The igor package is located at: {igor_path}")
file_to_edit = path.join(igor_path, "binarywave.py")

# Read the content of the file and replace the deprecated usage
with open(file_to_edit, 'r', encoding='utf-8') as file:
    content = file.read()

# Replace 'np.complex' with 'np.complex128'
content = content.replace('_numpy.complex,', 'complex,')
# Write the modified content back to the file
with open(file_to_edit, 'w', encoding='utf-8') as file:
    file.write(content)
warnings.filterwarnings('ignore')
from igor.binarywave import load as load_ibw

#global var
global folder
global filenames
global files_data
folder = None  # Declare global variable first
filenames = None
global hist_path
hist_path = 'not_path'
global hist_path_metal
hist_path_metal = 'not_path'
global hist_path_molecula
hist_path_molecula = 'not_path'
global curve_glob
global smooth_glob
global delta_glob
global selec 
curve_glob = 0; smooth_glob = 0; delta_glob = 0
global save_var
global stm
global grid_files 
grid_files = False
save_var = True
selec = {}

global save_path
global hist_path_forwad
global hist_path_metal_forwad
global hist_path_molecula_forwad
global hist_path_backward
global hist_path_metal_backward
global hist_path_molecula_backward

###auxiliary funcions
def open_file(name):
    file = open(name, 'r', encoding='utf-8',
                errors='ignore')  # open the file.
    # creat a list that will be full filed with the file with a line as a list element.
    file_list = []
    for line in file:  # open a loop that cover the file.
        line = line.strip('\n')  # drop out all '\n' contained in every line.
        # change the spaces for a element of a list, ex: 'the energy is' --> ['the','energy','is'].
        line = line.split()
        file_list.append(line)  # add the line in the list file_list.
    file.close()  # close de file.
    return file_list

def ramp(file):
    for line in file:
        if len(line)>1:
            if line[0] == '#' and line[1] == 'Ramp':
                if line[2] == 'start':
                    v_start = float(line[len(line)-2] )
                elif line[2] == 'end':
                    v_end = float(line[len(line)-2] )
            elif ('Automatic' in line)== True and ('reversal' in line)==True:
                volta = line[len(line)-1]
    return [v_start,v_end,volta]

def txt_to_datafram(file):
    X = [];Y = []
    for line in file:
        if len(line)>=1:
            if line[0]!='#':
                try:
                    x,y = list(map(lambda x:float(x),line))   
                    X.append(x);Y.append(y)
                except ValueError:
                    pass
    return DataFrame({'V':X,'I':Y})

def get_curve_number(path):
    for i in range(len(path)):
        n =len(path)-2-i
        if path[n]=='y' and path[n+1]=='-':
            ct = n+3
            break
    for i in range(ct,len(path)):
        if path[i]=='-':
            ct2 = i
            break
    return path[ct:ct2]


def load_file(path,which='Nanosurf',grid =False):
    if which == 'Nanosurf':
        try:
            df = read_csv ( path, sep= ';', names= ['x','y','z'])
            first_value = df[df.columns[0]].iloc[0] 
            V = []
            for i in range(1,len(df)):
                if df[df.columns[0]].iloc[i]  == first_value:
                    count = i
                    #V.append(df[df.columns[0]].iloc[i])
                    break
                else:
                    V.append(df[df.columns[0]].iloc[i])

            n = int(len(df)/count)

            dataframes = []
            names = []
            Vmin = min(V)
            Vmax = max(V)
            for j in range(n):
                sts=[]
                volta =[]

                for i in range(len(df)):
                    if i<count :
                        filtro_alto = 18*pow(10,-9)
                        filtro_baixo = -filtro_alto
                        voltagem = df[df.columns[0]].iloc[i]
                        corrente = df[df.columns[2]].iloc[i+j*count]
                        if corrente>filtro_baixo and corrente < filtro_alto:
                            volta.append(voltagem)
                            sts.append(corrente)
                        else:
                            pass
                    else:
                        break

                V_new = volta
                try:
                    if min(V_new)>Vmin:
                        Vmin = min(V_new)
                    if max(V_new)<Vmax:
                        Vmax = max(V_new)
                    if max(V_new)>0 and min(V_new)<0:
                        df_new = DataFrame(V_new,columns = ['V'])
                        df_new['I'+str(j)] = sts
                        names.append(str(j) )
                        dataframes.append(df_new)
                except ValueError:
                    print('File %s with bad data.'%path)

            return {'ixv':[dataframes,names,[Vmin,Vmax]],'ixv_idaevolta':[[],[],[]]}
        except:
            df = read_csv ( path, sep= ';', names= ['x','y'])
            for i in range(len(path)):
                if path[i]=='/':
                    ct = i
                    break
            first_value = df[df.columns[0]].iloc[0] 
            V = array(df['x'])
            dataframes = []
            names = []
            Vmin = min(V)
            Vmax = max(V)
            for j in range(1):
                sts=[]
                volta =[]
                for i in range(len(df)):
                        filtro_alto = 18*pow(10,-9)
                        filtro_baixo = -filtro_alto
                        voltagem = df[df.columns[0]].iloc[i]
                        corrente = df[df.columns[1]].iloc[i]
                        if corrente>filtro_baixo and corrente < filtro_alto:
                            volta.append(voltagem)
                            sts.append(corrente)
                        else:
                            pass

                V_new = volta
                try:
                    
                    if min(V_new)>Vmin:
                        Vmin = min(V_new)
                    if max(V_new)<Vmax:
                        Vmax = max(V_new)
                    df_new = DataFrame(V_new,columns = ['V'])
                    df_new['I'] = sts
                    names.append( path[ct+1:-4])
                    dataframes.append(df_new)
                except ValueError:
                    print('File %s with bad data.'%path)

            return {'ixv':[dataframes,names,[Vmin,Vmax]],'ixv_idaevolta':[[],[],[]]}
    elif which == 'Omicron':
        #grid = path.endswith('.asc')
        if grid:
            if path.endswith('.asc'):
                pass
            elif path.endswith('.ibw'):
                mapa = get_mapa_from_ibw(path)
                return mapa

        else:
            stm_files = open_file(path)
            v_start,v_end,volta =  ramp(stm_files)
            if volta == 'No':
                df = txt_to_datafram(stm_files)
                name = get_curve_number(path)
                if v_start<v_end:
                    vmin = v_start;vmax = v_end
                else:
                    vmin = v_end;vmax = v_start
                return {'ixv':[[df],[name],[vmin,vmax]],'ixv_idaevolta':[[],[],[]]}
            elif volta == 'Yes':
                df = txt_to_datafram(stm_files)
                for i in range(1,len(df)):
                    if df.iloc[i][0]==v_end:
                        ct = i+1
                        break
                df_ida = df.iloc[0:ct]
                df_volta = df.iloc[ct:]
                df_volta = df_volta.sort_values('V')
                df_volta=df_volta.reset_index(drop=True)
                name = get_curve_number(path)
                if v_start<v_end:
                    vmin = v_start;vmax = v_end
                else:
                    vmin = v_end;vmax = v_start
                return {'ixv':[[df_ida],[name],[vmin,vmax]],'ixv_idaevolta':[[df_volta],[name],[vmin,vmax]]}    
            else:
                print('erro to upload file: '+path)   

def printProgressBar(iteration, total, prefix = '', suffix = '', decimals = 1, length = 80, fill = '█',init =0, final =100):
    """
    Call in a loop to create terminal progress bar
    Courtesy of S.O. user Greenstick, https://stackoverflow.com/questions/3173320/text-progress-bar-in-the-console
    """
    
    percent = ("{0:." + str(decimals) + "f}").format(final * (iteration / float(total)))
    filledLength = int(length * iteration // total)
    bar = fill * filledLength + '-' * (length - filledLength)
    print('\r%s |%s| %s%% %s' % (prefix, bar, percent, suffix), end = '\r')
    # Print New Line on Complete
    if iteration == total: 
    	print()

def regression(x,y):
    x = array(x).reshape((-1, 1))
    model = LinearRegression().fit(x, y)
    b = model.intercept_
    a = model.coef_
    return [a[0],b]

def cut(x,y,xmin,xmax):
    x = array(x);y=array(y)
    xnew = [];ynew = []
    if x[0]>0:
        df = DataFrame({'x':x,'y':y})
        df = df.sort_values(by = 'x')
        x = array(df['x']);y = array(df['y'])
    for i in range(len(x)):
        if x[i]>=xmin and x[i]<=xmax:
            xnew.append(x[i])
            ynew.append(y[i])
    return [array(xnew),array(ynew)]

def integral(x,y):
    h = x[1]-x[0]
    I = (y[0]+y[len(y)-1])/2
    for i in range(1,len(y)-1):
        I+=y[i]
    I=h*I
    return I

def didv(x,y):
    h = x[1]-x[0]
    deri_y = []; deri_x =[]
    for i in range(1,len(x)-1):
        d = (y[i+1]-y[i-1])/(2*h)
        deri_x.append(x[i])
        deri_y.append(d)
    deri_y=array(deri_y)
    return [array(deri_x),deri_y/deri_y.max()]

def i_V(x,y):
  I =[]; V= []
  for i in range(1,len(x)-1):
    V.append(x[i])
    I.append(y[i])
  return [array(V),array(I)]

def gap_type(dx,dy,delta):
    f = interpolate.interp1d(dx, dy)
    marker1 = False; marker2 = False

    for i in range(len(dx)-1):
        if dx[0]<0:
            if dx[i]<=0 and dx[i+1]>=0:
               indice_x0 = i
               break
    marker1 = False; marker2 = False

    for i in range(len(dx)):
        if dx[0]<0:
          if i <= indice_x0:
            j= indice_x0-i
            if f(dx[j])<= delta and marker1 == False:
                xmin = dx[j]
            else:
               marker1 = True

          elif i > indice_x0:
            j= i 
            if f(dx[j])<= delta and marker2 == False:
                xmax = dx[j]
            else:
               marker2 = True
               
    try:
        gap = xmax-xmin
    except UnboundLocalError:
        xmin = 0
        xmax = 0
        gap = 0
    typ = abs(xmax) - abs(xmin)
    return [round(gap,2),round(typ,2),xmin,xmax]

def inter_x(x,y,z,dx = 100, dy= 100):

    interp = interpolate.RegularGridInterpolator((x,y),z)
    xnew = linspace(x.min(),x.max(),dx)
    ynew = linspace(y.min(),y.max(),dy)
    
    M_int = []
    for i in range(len(xnew)):
        pts = []
        for j in range(len(ynew)):
            pts.append([xnew[i],ynew[j]])
        pts = array(pts)
        col = interp(pts)
        M_int.append(array(col))
    
    return [xnew,ynew,array(M_int)]

def to_table(path_files,files_df,name = '',save_df_todos = False,save_df_limi = False):
    if True:
        #files = listdir(path_files)
        if save_df_todos:
            arq_I = open(path_files+name+'Dataframe_I_complete.csv','w')
            arq_didv = open(path_files+name+'Dataframe_dIdv_complete.csv','w')
        lines_I = []
        lines_didv = []
        marker=False
        
        for k in range(len(files_df)):
        #for item in files:
        #    if '.txt' in item:
                #df = read_csv(path_files+item)
                #number = ''
                #for car in item:
                #    if car=='_':
                #        break
                #    number+=car
                #col = df.columns
                df = files_df[k]
                number = str(k)
                col = df.columns
                x=df[col[0]];y=df[col[1]];dy=df[col[2]]
                x = array(list(map(lambda x: round(x,4),x)))
                dy=dy/dy.max()
                if len(x)>0:
                    if marker == False:
                        tam = len(x)
                        xlimmin = x.min()
                        xlimmax = x.max()
                        if save_df_todos:
                            lines_I.append([col[0]+'_'+number,',',col[1]+'_'+number])
                            lines_didv.append([col[0]+'_'+number,',',col[2]+'_'+number])
                            
                            for j in range(len(x)):
                                lines_I.append([x[j],',',y[j]])
                                lines_didv.append([x[j],',',dy[j]])
                        marker = True
                    else:
                        if x.min()>=xlimmin:
                            xlimmin=x.min()
                        if x.max()<=xlimmax:
                            xlimmax=x.max()
                        if save_df_todos:
                            lines_I[0] = lines_I[0]+ [',',col[0]+'_'+number,',',col[1]+'_'+number]
                            lines_didv[0] = lines_didv[0]+ [',',col[0]+'_'+number,',',col[2]+'_'+number]

                            if len(x)<=tam:
                                for k in range(len(x)):
                                    lines_I[k+1] = lines_I[k+1]+ [',',x[k],',',y[k]]
                                    lines_didv[k+1] = lines_didv[k+1]+ [',',x[k],',',dy[k]]
                            else:
                                for k in range(len(x)):
                                    if k <tam:
                                        lines_I[k+1] = lines_I[k+1]+ [',',x[k],',',y[k]]
                                        lines_didv[k+1] = lines_didv[k+1]+ [',',x[k],',',dy[k]]
                                    else:
                                        lines_I.append([x[j],',',y[j]])
                                        lines_didv.append([x[j],',',y[j]])
                                tam=len(x)
        if save_df_todos:
            for line in lines_I:
                line = list(map(lambda x:str(x),line))
                l = ''
                for c in line:
                    l+=c 
                arq_I.writelines(l+'\n')
            arq_I.close()
            for line in lines_didv:
                line = list(map(lambda x:str(x),line))
                l = ''
                for c in line:
                    l+=c 
                arq_didv.writelines(l+'\n')
            arq_didv.close()
    if save_df_limi:
        marker2 = True
        for k in range(len(files_df)):
        #for item in files_df:
            #if '.txt' in item:
                #df = read_csv(path_files+item)
                
                #number = ''
                #for car in item:
                #    if car=='_':
                #        break
                #    number+=car
                df = files_df[k]
                number = str(k)
                col = df.columns
                x=df[col[0]];y=df[col[1]];dy=df[col[2]]
                dy=dy/dy.max()
                if marker2:
                    xnew  = arange(xlimmin+0.01,xlimmax-0.01,0.01)
                    xnew = array(list(map(lambda x: round(x,4),xnew)))
                    f = interpolate.interp1d(x,y)
                    g = interpolate.interp1d(x,dy)
                    df2 = DataFrame({'V':xnew,'I_'+number:f(xnew)})
                    df3 = DataFrame({'V':xnew,'didv_'+number:g(xnew)})
                    marker2=False
                else:
                    f = interpolate.interp1d(x,y)
                    g = interpolate.interp1d(x,dy)
                    df2['I_'+number]=f(xnew)
                    df3['didv_'+number]=g(xnew)
                printProgressBar(k,len(files_df[0])-1)
        df2 = df2.set_index('V')
        df3 = df3.set_index('V')
        df2.to_csv(path_files+name+'Dataframe_I_limited_by_V.csv')
        df3.to_csv(path_files+name+'Dataframe_didv_limited_by_V.csv')


def select_sts(path_file, file,n = [],smooth = 5,delta = 10,resolution = 0.01,save_um_file = False,metal = False,molecula = False,xmin_hist=-1,xmax_hist=1,name_table='',save_df_todos = False,save_df_limi = False):
            global hist_path
            global hist_path_metal
            global hist_path_molecula
            global save_path
            #file = load_file(path_file)
            
            folder_save = 'sts_saves'
            for i in range(1,len(path_file[:-4])):
                if path_file[len(path_file[:-4]) -i] == '/':
                    ct = len(path_file[:-4]) -i
                    break
            try:
                #folder_name = path.join(folder_save,path_file[:-4][ct:])
                folder_name= folder_save+path_file[:-4][ct:]
            except UnboundLocalError:
                ct = 0
                #folder_name = path.join(folder_save,path_file[ct:-4])
                folder_name= folder_save+'/'+ path_file[:-4][ct:]
            try: 
                mkdir(folder_save )
            except FileExistsError:
                pass
                
            paste =folder_name
            save_path = paste
            try:
                mkdir(paste)
            except FileExistsError:
                for root, dirs, files_list in walk(paste):
                    for f in files_list:
                        #if file.endswith('.txt'):
                        remove(path.join(root, f))
                          
            hist ={'Curve':[],'Gap(V)':[] , 'Dop(Type)':[],'Dop(Value)':[]}
            files_df = []
            for i in range(len(file[0])):
                if (i in n) == False:
                        name = path.join(paste,file[1][i])
                        x= file[0][i][file[0][i].columns[0]];y = file[0][i][file[0][i].columns[1]]*pow(10,9)
                        p = int(smooth*len(y)/100)
                        if p>1:
                            if p%2==0:
                                p+=1
                                y = savgol_filter(y,p,1)
                            elif p==0:
                                pass
                            else:
                                y = savgol_filter(y,p,1)
                        dx,dy = didv(x,y)
                        gap,typ,xmin,xmax = gap_type(dx,dy,delta/100)
                        hist['Curve'].append(i)
                        hist['Gap(V)'].append(round(gap,3))
                        hist['Dop(Value)'].append(round(typ,3))
                        if abs(round(typ,3))<=resolution:
                            tipo = 'neutro'
                        elif typ<-resolution:
                            tipo = 'n'
                        else:
                            tipo = 'p'
                        hist['Dop(Type)'].append(tipo)
                        f = interpolate.interp1d( file[0][i][file[0][i].columns[0]],file[0][i][file[0][i].columns[1]])
                        g = interpolate.interp1d(dx,dy)
                        xnew = arange(dx.min(),dx.max()-0.01,0.01)
                        df_new = DataFrame({'V':xnew,'I(nA)':f(xnew),'didv':g(xnew),'gap': str(gap),'tipo':str(tipo)}   )
                        files_df.append(df_new)
                        df_new = df_new.set_index('V')
                        if save_um_file:
                            if ct ==0:
                                df_new.to_csv(name +'_'+path_file[:-4][ct:]+'.txt') 
                            else:
                                df_new.to_csv(name +'_'+path_file[:-4][ct+1:]+'.txt')
            df_hist = DataFrame(hist)
            df_hist = df_hist.set_index('Curve')
            df_hist.to_csv(paste+'/'+'histogram.csv')
            hist_path = paste+'/'+'histogram.csv'
            if metal:
                    
                hist_metal = {'a':[],'a_neg':[],'a_pos':[]}
                dfs = file[0]
                for i in range(len(file[0])):                        
                        columns = dfs[i].columns
                        x = dfs[i][columns[0]];y = dfs[i][columns[1]]*pow(10,9)
                        if p>1:
                            if p%2==0:
                                p+=1
                                y = savgol_filter(y,p,1)
                            elif p==0:
                                pass
                            else:
                                y = savgol_filter(y,p,1)
                        x_cut,y_cut = cut(x,y,xmin_hist,xmax_hist )
                        a,b = regression(x_cut,y_cut)
                        a = round(a,3); b = round(b,3)
                        hist_metal['a'].append(a)
                        dx,dy = didv(x,y)
                        x_cut_neg,y_cut_neg = cut(dx,dy,xmin_hist,0-resolution )
                        a_neg,b_neg = regression(x_cut_neg,y_cut_neg)
                        a_neg = round(a_neg,3); b_neg = round(b_neg,3)
                        x_cut_pos,y_cut_pos = cut(dx,dy,0+resolution,xmax_hist )
                        a_pos,b_pos = regression(x_cut_pos,y_cut_pos)
                        a_pos = round(a_pos,3); b_pos = round(b_pos,3)    
                        hist_metal['a_neg'].append(a_neg)
                        hist_metal['a_pos'].append(a_pos)
                df = DataFrame(hist_metal)
                df = df.to_csv(paste+'/'+'histogram_alphas.csv')
                hist_path_metal = paste+'/'+'histogram_alphas.csv'
            if molecula:
                his_mole = {'I_pos':[],'I_neg':[]}
                dfs = file[0]
                for i in range(len(file[0])):   
                    columns = dfs[i].columns
                    x = dfs[i][columns[0]];y = dfs[i][columns[1]]*pow(10,9)
                    p = int(smooth*len(y)/100)
                    if p>1:
                        if p%2==0:
                            p+=1
                            y = savgol_filter(y,p,1)
                        elif p==0:
                            pass
                        else:
                            y = savgol_filter(y,p,1)
                    x_cut,y_cut = cut(x,y,xmin_hist ,xmax_hist  )
                    dx,dy = didv(x,y)
                    #I = round(integral(x_cut,y_cut),4)
                    x_cut_neg,y_cut_neg = cut(dx,dy,xmin_hist ,0-resolution )
                    I_neg = round(integral(x_cut_neg,y_cut_neg),3)
                    x_cut_pos,y_cut_pos = cut(dx,dy,0+resolution,xmax_hist  )           
                    I_pos = round(integral(x_cut_pos,y_cut_pos),3)
                    his_mole['I_pos'].append(I_pos)
                    his_mole['I_neg'].append(I_neg)
                df = DataFrame(his_mole)
                df = df.to_csv(paste+'/'+'histogram_molecule.csv')
                hist_path_molecula = paste+'/'+'histogram_molecule.csv'
            to_table(paste+'/',files_df,name=name_table,save_df_todos = save_df_todos,save_df_limi = save_df_limi)
            print("arquivos salvos na pasta "+ paste)

def select_sts_ida(path_file, file,n = [],smooth = 5,delta = 10,resolution = 0.01,save_um_file = False,metal = False,molecula = False,xmin_hist=-1,xmax_hist=1,name_table='',save_df_todos = False,save_df_limi = False):
            global hist_path
            global hist_path_forwad
            global hist_path_metal_forwad
            global hist_path_molecula_forwad
            global save_path
            #file = load_file(path_file)

            folder_save = 'sts_saves'
            for i in range(1,len(path_file[:-4])):
                if path_file[len(path_file[:-4]) -i] == '/':
                    ct = len(path_file[:-4]) -i
                    break
            try:
                #folder_name = path.join(folder_save,path_file[:-4][ct:])
                folder_name= folder_save+path_file[:-4][ct:]
            except UnboundLocalError:
                ct = 0
                #folder_name = path.join(folder_save,path_file[ct:-4])
                folder_name= folder_save+'/'+ path_file[:-4][ct:]
            try: 
                mkdir(folder_save )
            except FileExistsError:
                pass
                
            paste =folder_name
            save_path = paste
            try:
                mkdir(paste)
            except FileExistsError:
                for root, dirs, files_list in walk(paste):
                    for f in files_list:
                        #if file.endswith('.txt'):
                        remove(path.join(root, f))
                          
            hist ={'Curve':[],'Gap(V)':[] , 'Dop(Type)':[],'Dop(Value)':[]}
            files_df = []
            for i in range(len(file[0])):
                if (i in n) == False:
                        name = path.join(paste,file[1][i])
                        x= file[0][i][file[0][i].columns[0]];y = file[0][i][file[0][i].columns[1]]*pow(10,9)
                        p = int(smooth*len(y)/100)
                        if p%2==0:
                            p+=1
                            y = savgol_filter(y,p,1)
                        elif p==0:
                            pass
                        else:
                            y = savgol_filter(y,p,1)
                        dx,dy = didv(x,y)
                        gap,typ,xmin,xmax = gap_type(dx,dy,delta/100)
                        hist['Curve'].append(i)
                        hist['Gap(V)'].append(round(gap,3))
                        hist['Dop(Value)'].append(round(typ,3))
                        if abs(round(typ,3))<=resolution:
                            tipo = 'neutro'
                        elif typ<-resolution:
                            tipo = 'n'
                        else:
                            tipo = 'p'
                        hist['Dop(Type)'].append(tipo)
                        f = interpolate.interp1d( file[0][i][file[0][i].columns[0]],file[0][i][file[0][i].columns[1]])
                        g = interpolate.interp1d(dx,dy)
                        xnew = arange(dx.min(),dx.max()-0.01,0.01)
                        df_new = DataFrame({'V':xnew,'I(nA)':f(xnew),'didv':g(xnew),'gap': str(gap),'tipo':str(tipo)}   )
                        files_df.append(df_new)
                        df_new = df_new.set_index('V')
                        if save_um_file:
                            if ct ==0:
                                df_new.to_csv(name +'_'+'F_'+path_file[:-4][ct:]+'.txt') 
                            else:
                                df_new.to_csv(name +'_'+'F_'+path_file[:-4][ct+1:]+'.txt')
            df_hist = DataFrame(hist)
            df_hist = df_hist.set_index('Curve')
            df_hist.to_csv(paste+'/'+'histogram_forward.csv')
            hist_path_forwad = paste+'/'+'histogram_forward.csv'
            if metal:
                    
                hist_metal = {'a':[],'a_neg':[],'a_pos':[]}
                dfs = file[0]
                for i in range(len(file[0])):                        
                        columns = dfs[i].columns
                        x = dfs[i][columns[0]];y = dfs[i][columns[1]]*pow(10,9)
                        if p>1:
                            if p%2==0:
                                p+=1
                                y = savgol_filter(y,p,1)
                            elif p==0:
                                pass
                            else:
                                y = savgol_filter(y,p,1)
                        x_cut,y_cut = cut(x,y,xmin_hist,xmax_hist )
                        a,b = regression(x_cut,y_cut)
                        a = round(a,3); b = round(b,3)
                        hist_metal['a'].append(a)
                        dx,dy = didv(x,y)
                        x_cut_neg,y_cut_neg = cut(dx,dy,xmin_hist,0-resolution )
                        a_neg,b_neg = regression(x_cut_neg,y_cut_neg)
                        a_neg = round(a_neg,3); b_neg = round(b_neg,3)
                        x_cut_pos,y_cut_pos = cut(dx,dy,0+resolution,xmax_hist )
                        a_pos,b_pos = regression(x_cut_pos,y_cut_pos)
                        a_pos = round(a_pos,3); b_pos = round(b_pos,3)    
                        hist_metal['a_neg'].append(a_neg)
                        hist_metal['a_pos'].append(a_pos)
                df = DataFrame(hist_metal)
                df = df.to_csv(paste+'/'+'histogram_alphas_forward.csv')
                hist_path_metal_forwad = paste+'/'+'histogram_alphas_forward.csv'
            if molecula:
                his_mole = {'I_pos':[],'I_neg':[]}
                dfs = file[0]
                for i in range(len(file[0])):   
                    columns = dfs[i].columns
                    x = dfs[i][columns[0]];y = dfs[i][columns[1]]*pow(10,9)
                    if p>1:
                        if p%2==0:
                            p+=1
                            y = savgol_filter(y,p,1)
                        elif p==0:
                            pass
                        else:
                            y = savgol_filter(y,p,1)
                    dx,dy = didv(x,y)
                    x_cut,y_cut = cut(x,y,xmin_hist ,xmax_hist  )
                    #I = round(integral(x_cut,y_cut),4)
                    x_cut_neg,y_cut_neg = cut(dx,dy,xmin_hist ,0-resolution )
                    I_neg = round(integral(x_cut_neg,y_cut_neg),4)
                    x_cut_pos,y_cut_pos = cut(dx,dy,0+resolution,xmax_hist  )           
                    I_pos = round(integral(x_cut_pos,y_cut_pos),4)
                    his_mole['I_pos'].append(I_pos)
                    his_mole['I_neg'].append(I_neg)
                df = DataFrame(his_mole)
                df = df.to_csv(paste+'/'+'histogram_molecule_forward.csv')
                hist_path_molecula_forwad = paste+'/'+'histogram_molecule_forward.csv'
            to_table(paste+'/',files_df,name=name_table,save_df_todos = save_df_todos,save_df_limi = save_df_limi)
            print("arquivos salvos na pasta "+ paste)


def select_sts_volta(path_file, file,n = [],smooth = 5,delta = 10,resolution = 0.01,save_um_file = False,metal = False,molecula = False,xmin_hist=-1,xmax_hist=1,name_table = '',save_df_todos = False,save_df_limi = False):
            global hist_path_backward
            global hist_path_metal_backward
            global hist_path_molecula_backward
            #file = load_file(path_file)
            
            folder_save = 'sts_saves'
            for i in range(1,len(path_file[:-4])):
                if path_file[len(path_file[:-4]) -i] == '/':
                    ct = len(path_file[:-4]) -i
                    break
            try:
                #folder_name = path.join(folder_save,path_file[:-4][ct:])
                folder_name= folder_save+path_file[:-4][ct:]
            except UnboundLocalError:
                ct = 0
                #folder_name = path.join(folder_save,path_file[ct:-4])
                folder_name= folder_save+'/'+ path_file[:-4][ct:]
            try: 
                mkdir(folder_save )
            except FileExistsError:
                pass
                
            paste =folder_name
            try:
                mkdir(paste)
            except FileExistsError:
                pass
                          
            hist ={'Curve':[],'Gap(V)':[] , 'Dop(Type)':[],'Dop(Value)':[]}
            files_df = []
            for i in range(len(file[0])):
                if (i in n) == False:
                        name = path.join(paste,file[1][i])
                        x= file[0][i][file[0][i].columns[0]];y = file[0][i][file[0][i].columns[1]]*pow(10,9)
                        p = int(smooth*len(y)/100)
                        if p%2==0:
                            p+=1
                            y = savgol_filter(y,p,1)
                        elif p==0:
                            pass
                        else:
                            y = savgol_filter(y,p,1)
                        dx,dy = didv(x,y)
                        gap,typ,xmin,xmax = gap_type(dx,dy,delta/100)
                        hist['Curve'].append(i)
                        hist['Gap(V)'].append(round(gap,3))
                        hist['Dop(Value)'].append(round(typ,3))
                        if abs(round(typ,3))<=resolution:
                            tipo = 'neutro'
                        elif typ<-resolution:
                            tipo = 'n'
                        else:
                            tipo = 'p'
                        hist['Dop(Type)'].append(tipo)
                        f = interpolate.interp1d( file[0][i][file[0][i].columns[0]],file[0][i][file[0][i].columns[1]])
                        g = interpolate.interp1d(dx,dy)
                        xnew = arange(dx.min(),dx.max()-0.01,0.01)
                        df_new = DataFrame({'V':xnew,'I(nA)':f(xnew),'didv':g(xnew),'gap': str(gap),'tipo':str(tipo)}   )
                        files_df.append(df_new)
                        df_new = df_new.set_index('V')
                        if save_um_file:
                            if ct ==0:
                                df_new.to_csv(name +'_'+'B_'+path_file[:-4][ct:]+'.txt') 
                            else:
                                df_new.to_csv(name +'_'+'B_'+path_file[:-4][ct+1:]+'.txt')
            df_hist = DataFrame(hist)
            df_hist = df_hist.set_index('Curve')
            df_hist.to_csv(paste+'/'+'histogram_backward.csv')
            hist_path_backward = paste+'/'+'histogram_backward.csv'
            if metal:
                    
                hist_metal = {'a':[],'a_neg':[],'a_pos':[]}
                dfs = file[0]
                for i in range(len(file[0])):                        
                        columns = dfs[i].columns
                        x = dfs[i][columns[0]];y = dfs[i][columns[1]]*pow(10,9)
                        if p>1:
                            if p%2==0:
                                p+=1
                                y = savgol_filter(y,p,1)
                            elif p==0:
                                pass
                            else:
                                y = savgol_filter(y,p,1)
                        x_cut,y_cut = cut(x,y,xmin_hist,xmax_hist )
                        a,b = regression(x_cut,y_cut)
                        a = round(a,3); b = round(b,3)
                        hist_metal['a'].append(a)
                        dx,dy = didv(x,y)
                        x_cut_neg,y_cut_neg = cut(dx,dy,xmin_hist,0-resolution )
                        a_neg,b_neg = regression(x_cut_neg,y_cut_neg)
                        a_neg = round(a_neg,3); b_neg = round(b_neg,3)
                        x_cut_pos,y_cut_pos = cut(dx,dy,0+resolution,xmax_hist )
                        a_pos,b_pos = regression(x_cut_pos,y_cut_pos)
                        a_pos = round(a_pos,3); b_pos = round(b_pos,3)    
                        hist_metal['a_neg'].append(a_neg)
                        hist_metal['a_pos'].append(a_pos)
                df = DataFrame(hist_metal)
                df = df.to_csv(paste+'/'+'histogram_alphas_backward.csv')
                hist_path_metal_backward = paste+'/'+'histogram_alphas_backward.csv'
            if molecula:
                his_mole = {'I_pos':[],'I_neg':[]}
                dfs = file[0]
                for i in range(len(file[0])):   
                    columns = dfs[i].columns
                    x = dfs[i][columns[0]];y = dfs[i][columns[1]]*pow(10,9)
                    if p>1:
                        if p%2==0:
                            p+=1
                            y = savgol_filter(y,p,1)
                        elif p==0:
                            pass
                        else:
                            y = savgol_filter(y,p,1)
                    dx,dy = didv(x,y)
                    x_cut,y_cut = cut(x,y,xmin_hist ,xmax_hist  )
                   # I = round(integral(x_cut,y_cut),4)
                    x_cut_neg,y_cut_neg = cut(dx,dy,xmin,0-resolution )
                    I_neg = round(integral(x_cut_neg,y_cut_neg),4)
                    x_cut_pos,y_cut_pos = cut(dx,dy,0+resolution,xmax_hist  )       
 
                    I_pos = round(integral(x_cut_pos,y_cut_pos),4)
                    his_mole['I_pos'].append(I_pos)
                    his_mole['I_neg'].append(I_neg)
                df = DataFrame(his_mole)
                df = df.to_csv(paste+'/'+'histogram_molecule_backward.csv')
                hist_path_molecula_backward = paste+'/'+'histogram_molecule_backward.csv'
            to_table(paste+'/',files_df,name=name_table,save_df_todos = save_df_todos,save_df_limi = save_df_limi)
            print("arquivos salvos na pasta "+ paste)

def get_mapa_from_ibw(file):
    data_temp = load_ibw(file)
    data = data_temp['wave']
    ndim = data['wave_header']['nDim']
    sfA = data['wave_header']['sfA']
    sfB = data['wave_header']['sfB']
    matrix = data['wData']
    #dimensoes
    xtick = linspace(0,sfA[0]*ndim[0],ndim[0])
    ytick = linspace(0,sfA[1]*ndim[1],ndim[1])
    #bias voltage range
    V_list = []
    for line in data['note'].decode('utf-8').split('\r'):
        if ('Spectroscopy points per curve' in line)==True:
            for j in range(len(line.split())):
                if line.split()[j] =='=':
                    try:
                        V_list.append(float(line.split()[j+1][:-1]))
                    except ValueError:
                        pass
    V = linspace(V_list[1],V_list[2],ndim[2])
    return [xtick,ytick,V,matrix]

#Functions displayed for user

def Open_files():
    global folder
    global filenames
    global files_data
    global conca
    global stm
    global grid_files
    stm = 'Nanosurf'
    gui = Tk()
    gui.geometry("600x500")
    gui.title('STS Data Analise for Omicron and Nanosurf STM by Rafael Reis Barreto')
    #url = "https://i.postimg.cc/WzPSwVNh/logo.png"
    #u = urlopen(url)
    #raw_data = u.read()
    #u.close()
    data = b'\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x01-\x00\x00\x01\x8b\x08\x06\x00\x00\x00\x92\xa6\xc4\x1d\x00\x00\x00\x01sRGB\x00\xae\xce\x1c\xe9\x00\x00\x00\x04gAMA\x00\x00\xb1\x8f\x0b\xfca\x05\x00\x00\x00\tpHYs\x00\x00\x0e\xc2\x00\x00\x0e\xc2\x01\x15(J\x80\x00\x00\xa0oIDATx^\xed\x9d\x07\xa0T\xc5\xd5\x80\xe7\xf5Jy\xf4\xde\x94\xa6 \x08Vl\x88\x1a{\x8b\xc6\x9a\x18\x89-\xd6\x14\xa3\xfej\x125&vM4&Fc\xef\xbd\xc7^\xb1!\xa2"\x88 (HG:\xbc^\xf7?\xdf\xb9w\xf6\xdd]^\xb9\xbb\xef=de>\xb3\xe1\xed\xdd\xdd\x99[f\xce\x9c9s\xe6\x9c\xb4\x88`\x1c\x0e\x87#EH\xf7\xffu8\x1c\x8e\x94\xc0\t-\x87\xc3\x91R8\xa1\xe5p8R\n\'\xb4\x1c\x0eGJ\xe1\x84\x96\xc3\xe1H)\x9c\xd0r8\x1c)\x85\x13Z\x0e\x87#\xa5pB\xcb\xe1p\xa4\x14Nh9\x1c\x8e\x94\xc2\t-\x87\xc3\x91R8\xa1\xe5p8R\n\'\xb4\x1c\x0eGJ\xe1\x84\x96\xc3\xe1H)\x9c\xd0r8\x1c)\x85\x13Z\x0e\x87#\xa5pB\xcb\xe1p\xa4\x14Nh9\x1c\x8e\x94\xc2\t-\x87\xc3\x91R8\xa1\xb5\x99PSSc.\xb9\xe4\x12\xd3\xa9S\'\x93\x96\x96\xa6\xaf\xf1\xe3\xc7\x9bg\x9f}6\xfa\xf9a\x87\x1d\x16\xfd\xac\xb9\xd7\xe5\x97_\xae\xbf\x83\xe6\xcan\x88\x96\xd4\x07\x8b\x16-2\xe7\x9dw^L\x9d999Z\xef\x17_|\xe1\x7f\xabq\x92\xf9}EE\x85\xe9\xdf\xbf\xbf),,4+W\xae\xf4\x8f6L2\xf7\xc4\xb1\x99@\x8cx\xc7\x0fKyyy\xa4_\xbf~\xc4\xea\x8f\x0c\x1b6,r\xfa\xe9\xa7G&N\x9c\xa8\xefy=\xf2\xc8#\x91\xea\xea\xea\xc8\xc5\x17_\x1c\x197n\\\xf45v\xec\xd8\xe8w\x82\xc7y\xdd\x7f\xff\xfd\xa1\xcbn\x88d\xeb\x83\xbb\xee\xba+\xfa\xbd\xe0w\x83\xc7~\xf5\xab_EJKK\xfd_\xc4\x92\xec\xef\xed\xb5\x16\x14\x14DV\xacX\xe1\x1f\xdd\x98d\xef\x89c\xf3\xc0\t\xad\xcd\x00\xdbI\x8f8\xe2\x08\xff\x88\xc7\xc2\x85\x0b#G\x1f}t\xa3\x9dh\xde\xbcy\x91\xa2\xa2\xa2\xc8\x981c\x9a\x15\x00\x89\x96\xdd\x10\x89\xd4\x97\x9d\x9d\x1d#\xc8,\xaf\xbc\xf2\x8a\x96\xc1w.\xbb\xec2\xffh=-\xf9}X\xa1\xd5\x9a\xf7\xc4\xb1\xe9qB\xeb\x07\x06\x8d\xe6\xd0C\x0f\xd5N\x94hgiN\x88\xb4\xa4\xec\x86h\xae\xbe\xa0\x06\xd3T}\xef\xbd\xf7\x9e~\'^\xb8\xb4\xd6\xef\x9b\x12Z\xad}O\x1c\x9b\x1eg\xd3\xfa\x81\xc9\xcc\xcc4\x83\x07\x0f\xd6\xbfg\xcf\x9e\xad\xff\xb6\x16mYvC<\xfc\xf0\xc3F\xb4\x15#BM\xeda\x8d\xb1\xcb.\xbb\x18\x11\x1cF\x04\x9fy\xf3\xcd7\xfd\xa3-\xff}\x186\xf5=q\xb4>Nhm\x06\x1cy\xe4\x91\xfa\xef\xd5W_m\x1ex\xe0\x01\xfd\xbb\xb5h\xcb\xb2\xe3\x999s\xa6\xfe\x8b@\xc9\xcf\xcf\xd7\xbf\x1b\x02\xc1!S3\xfd\xfb\xb1\xc7\x1e\xd3\x7f\xa1\xa5\xbf\x0f\xcb\xa6\xbc\'\x8e\xd6\xc7\t\xad\xcd\x80\xddw\xdf\xdd\\|\xf1\xc5\xa6\xaa\xaa\xca\x9ct\xd2I\xbaJFg*++\xf3\xbf\x91<mYv\x10V\xe3\xe6\xce\x9d\xab\x7f\x0f\x1b6L\xffM\x84\x96\xfe>\x116\xd5=q\xb4\rNhm&\\u\xd5U:\xd5a\xd9\xddv\xa6\xa2\xa2\xa2V\xd1\x04\xda\xb2\xecd\x192d\x88\xffWr\xb4\xf4\xf7\x9b\xe3=q\x84\xc3\t\xad\xcd\x88\t\x13&\x98\xb7\xdf~\xdb\xcc\x9a5+\xa63\xc5\xfb@%C[\x96\x9d\x0cs\xe6\xcc\xf1\xffJ\x8e\x96\xfe\x1e6\xb7{\xe2\x08\x87\x13Z\x9b!L\x8f\xe8Lw\xddu\x97\xbe\xbf\xe1\x86\x1b\x9au\x96\x0cK[\x95\x9d\xa8\x81\xdb\xda\xafF\x8d\x1a\xa5\xff\xb6\xf4\xf7-\xa1-\xef\xb7\xa3\xf5qBk3\xe6\x84\x13N0\xfd\xfa\xf53\xd5\xd5\xd5f\xfe\xfc\xf9\xfe\xd1\xd6\xa1-\xca\xdev\xdbm\xf5\xdf\xe6<\xde\x1b\xb3_\xb5\xf4\xf7-\xa5-\xef\xb7\xa3\xf5pB\xcb\xd1j\xec\xbd\xf7\xdej\x17z\xe9\xa5\x97\xcc\x94)S\xfc\xa3\x1bs\xff\xfd\xf7\x9b\x17^xa#\xd7\x86\x96\xfe\xde\xb1e\xe0\x84\xd6\x0f\x0c#:\xf6\x94\xf8=oh\x13\x97^z\xa9\xfa-\x8d\x181B_\x89\xd2\x96e7\xc4\xc0\x81\x03\xcd\xc4\x89\x13\xd56\xb4\xc7\x1e{4X\xef?\xff\xf9Os\xca)\xa7\xe8\xfb\x0b.\xb8 \xc6\xb5\xa1\xa5\xbf\x0f\xc3\xa6\xbe\'\x8e6\xc0w2u\xfc@X/s\x1e\x05/\x99\xee\xc4\xec\xb3c;\xcb\xc7\x1f\x7f\xec\x7f;\x96\xe6<\xd4[RvC4W\x1f\x04=\xce\xed\x8b:\x83\xfb\x16\xa9\xf7\x86\x1bn\xf0\x7f\x11KK~\x1f\xbf\xa7\x90\xdf\x05_\xecW\x9c1cF\xab\xde\x13\xc7\xa6\xc7\t\xad\xcd\x00\x19\xdd#\xe7\x9e{nLg\xa2\xf34\xb5\xa9\x18\xc2\x08\x91d\xcbn\x880\xf5Y\xde|\xf3\xcd\xc8\xfe\xfb\xef\x1f\xad\x93\x17\x02\xe2\x17\xbf\xf8E\xe4\xcb/\xbf\xf4\xbf\xd58\xc9\xfc>(\xb4\x1az\xd9\xf3n\xcd{\xe2\xd8\xf4\xa4\xf1\x7f\xf2\xd0\x1c\x0e\x87#%p6-\x87\xc3\x91R8\xa1\xe5p8R\n\'\xb4\x1c\x0eGJ\xe1\x84\x96\xc3\xe1H)\x9c\xd0r8\x1c)\x85\x13Z\x0e\x87#\xa5pB\xcb\xe1p\xa4\x14Nh9\x1c\x8e\x94\xc2\t-\x87\xc3\x91R8\xa1\xe5p8R\n\'\xb4\x1c\x0eGJ\xe1\x84\x96\xc3\xe1H)\x9c\xd0JA\x88\t\xd5\xa9S\xa7h*\xac \xcb\x96-\xdb\xec\xb3\xca\xbc\xfa\xea\xabz\xfeiii\xd1L8\x8e\xd4fS>\xd3V\x15Z\x15\x15\x15\xa6\x7f\xff\xfez\xe2\xf1\xaf\xddv\xdb\xcd\\{\xed\xb5)\x9b\xa6\xe9\xee\xbb\xef\x8e^\xcb\xa3\x8f>\xea\x1f\xdd\xbcx\xff\xfd\xf7M\xaf^\xbdL\xb7n\xdd6\xdb\x18\xe7\x08\xdc\xe3\x8f?^\x13\xad\xf2\xef\x89\'\x9eh\xbe\xfd\xf6[\xff\xd3\xb6\x876J\xb4S\x9e\xe3v\xdbm\xd7\xe8}\xb2\xcf\xdb%\xb9h\x9eM\xfeL5@M+a\xe3\x19\x11\x9bHN>r\xfa\xe9\xa7\xeb+\x18\x17\x89\xcf\xee\xbf\xff~\xff\x17\xc9c\x83\xc5Q^[\x07m\x8b\x0fLw\xc4\x11G\xf8\x9f\xfc0\xd8\xb8V\xf1\xe7a\xd3\xc5\x87\x89w\xf5Cq\xd7]w\xe99\xfeP)\xe9\xe3cn5\xf6,\xedy^v\xd9e\xfe\x11Gcl\xeag\xda&\xd3\xc3\xac\xac,s\xf3\xcd7\x9b\xdbo\xbf]_\xaf\xbc\xf2\x8a&\x0b\xb8\xe5\x96[\xa2i\x9a6Wm\xa5!\x16-Z\xa4Z\x8c\x08_M|\xf0\xfa\xeb\xafo\x96\x9a\x0cIH\xe5\x99\x9aO?\xfd4\xe10\xc4\x9b\n\x9bE\xe7\x87f\xd8\xb0a\xa1\xe2\xd1;\x9agS?\xd3Mf\xd3"E\xd4\xb9\xe7\x9e\x1bM\xd3t\xfd\xf5\xd7\xa7\xccT\x91\xf4Rk\xd7\xae5\'\x9f|\xb29\xfa\xe8\xa3U\r&\xd1\xa7#uA\xa8_q\xc5\x15:\x88\x9ey\xe6\x99.\xbbt*\xe1)\\\xad\x83U\xbd\x0b\n\n"+V\xac\xf0\x8f\xc6\x12T\xcf\xe3\xd5\xc9\xa5K\x97F.\xbe\xf8\xe2\x980\xb8{\xed\xb5\xd7F\xd3\xbf\xdf\xff\xfe\xf7\xd1\xcf\xe3_\xc12\xc3\x96\xd7\x14vjh\xaf\xa9\xb9)\x98\x9d\xba1\xad\xb0a}m\xdd#G\x8el\xb4\xeeD\xce\xb5\xb1\xe9ac\xc7\x81\xf0\xc5\xe3\xc7\x8f\x8f\x96\xddXx\xe1\x86\xbew\xcd5\xd74x\xada\xcb\x04;\x85\x88\x7f\x05\xdbJC!\x96\xb9\x07\r\x85W\x0e\xdeg\xfe\xb6\xe7\xc1si\xac\xedA\xb0\x8d.Y\xb2$:\xed\x8fo\x8bMM\x0f\x93yV\x89\xb6\x07H\xe4~@s\xcf\xc3\xb6\xdd\x86\xda\x87=\xcf\xf8v\xdd\xd4}\xbe\xea\xaa\xab\xa2u\x05_M\xf5\xff\xd6`\x93\x0b-\xb0B\'\xd8 &O\x9e\x1cm\x04<\x98\xa0-,\xden\xc5\xc3\xe1s\xfb}k?;\xfb\xec\xb3\xa3\x0f4\x91\xf2\x9a"\xfeA7gK\xb3\x0f\x99s\xe2_\xbe\xd7\\\xdd\x89\x9e\xab\xad#\xac\xd0\xb2\xd7@Y\xf6^Q~|\x03\xb5\x1d5\xf8={^\xf1\xdf\r[\xa6\x85k\xe4;6A\x85\xbd\xce\xdf\xfc\xe67\xfa\xfd\xa0P\xb3\xe5\x05;`\xbcP\x89\xbf\xcf|\x87\xb2\x9bk{\xf1m\xb4\xb1A\xa81\xa1\x95\xec\xb3\xb2\xe7\xc9w\x9a\xfb\r$z?\xc2<\x8f\xf8\xb6\x1c\xc4\x9eg\xfc}h\xea>?\xff\xfc\xf3ZOc\xcf\xb4\xad\xf8A\x84\x96} \xc1\x9b\xc7\rm(iAC\xdf\x85\xe6\x84G\xa2\xe55\x06\x026\xbe\x8e\xc6\x1a4\xd8\x87l\xebh\xa8#\xc4\xd7\x9d\xe8\xb9\xda:\xc2\x1co\xee>Y\x1ak\xb4\xfc\xde\x0e2\xb6\xa3\x84-\xb3!\xe2\xcb\x02\xdb\x99h7\xf1\xf7\xe0\x95W^\x89~\x16lS\xc1\xfb\xdc\x98\xa0l\x88\xf86j\xaf\x85r\x82\xcf\xb3\xb1g\x9c\xec\xb3\xb2\x9f\x85m\x0f\x1c\x0f{?\xc2>\x0f[n|}\xd0\xd8\xf3\x0fs\x9f\x1bz\xa6m\xc9f\xe3\xa7\x85\x11\x99$\x9c6\xcb\xb0\xc5&\xf0L\x94\xd6(\x8f\xe5\xf1\'\x9f|r\xa3<x\xb6\x0c\x12\x866f\x0b\x91\x07l\x1ez\xe8\xa1\x18\x83\xb8\xfd\x9dL\x13b~\xd7\xda\xd7\x9e\x0c\xb7\xdez\xab\xda\xed\xe2s\tb\x8b<\xe7\x9cs\xf4<\x1e{\xec1\xffh\xeb\xf2\xcc3\xcf\xe8\xbfw\xdey\xe7F\xf7@\xb4\x05#\x9d\xa2Q;\xa2t^]\xe8Iv\xe1\x81\xebc\xd1\x88\xeb\x0b\x93\x0e?\xd9g\x95H{h\xc9\xfdh+Zz\x9f[\x93\xcd\xce\xb9\x14\xe7H\x84\xc1\x19g\x9c\xa1\xaf+\xaf\xbcR;S\xb2\xb4\xa4\xbc\xa9S\xa7j\x83\x92Q,\xe6a\xf5\xed\xdbW\x1b\xefg\x9f}fDE\xf6\x8f\xc6"\xa3\xf9F\x0f\xb8g\xcf\x9e\xa6]\xbbv\xfe\xbb\x8di\xedk\x07:\xe5\x85\x17^\x18M\x80J\xa2\xd3\xef\xbe\xfb\xce\xff\xd4\x83D\xa56\xcd<\xd7c\xeb\x8f?\x0f\xdb\xb9\xc2\x94\x19\x16[\xb7h\tf\xd0\xa0A\xfe\xd1Xl\xc7\x9d={\xb6\xfe\x1bd\xbf\xfd\xf63]\xbbv\xf5\xdf%\x87M\x12\x8b \x90\xe9\x8d\x7f\xb4i\x12}Va\xdbC2\xf7\xa35\x9fGc\xb4\xc6}n-~\x10\xa1e\x97HG\x8d\x1a\xa5\xff\x02\x0f\xeb\xbc\xf3\xceS\xe7H\x9c\xff\xee\xb8\xe3\x0e}\xdds\xcf=\xfe7\x12\xa35\xca\xb3#\xde;\xef\xbc\x13\xd3\x89\xcf>\xfblS\\\\\xac\x9f\xb5\x86\xf6\xd1\xda\xd7\x1e\x0f\x02\x96Qy\xdc\xb8q\xea4I\'\xc5\xb1\xb2\xa1\xa5jQ\xf1\xa3\xf57u\x1e\x89\x94\xd9\x14\\\xfb\x17_|\xa1n2\x94\xd1\x14|\xaf\xad\xf8\xdb\xdf\xfe\xa6\x82\xa59\x17\x88\xb6~V\xc9\xde\x8f\xd6z\x1e\xa9\xc0&\x17Zv\xca\xc5Hr\xd0A\x07\xf9G\x8d\xb9\xe8\xa2\x8b\x0c)\xcfQ\xa3e\x1e\xaf\xfeF\xbcdN\x9d\xd4\x14\xa9\xa5\xe5\xe1\xe5k\x1b\xe2\xbb\xef\xbe\x1b\xd3\x89y!\xc8\xa05|\xb6Z\xfb\xda\x1bb\xc2\x84\t\xea\xba\xb1t\xe9Rs\xf1\xc5\x17\x9b\x193fh}\xc1\x0e\xca3\xf9\xf8\xe3\x8f\xa3\xf5\xc7\xbf\xe2\xfd\xbf\xc2\x94\xd9\x1ch\t\x0c^\xd5\xd5\xd5z\xcf\x9b"8\xc8\xb56\xb9\xb9\xb9\xe6\xb2\xcb.Sm\xe5\xea\xab\xaf\xf6\x8fnL[?\xab\x96\xdc\x8f\xd6x\x1e\xa9\xc0&\x17Z\x0f?\xfc\xb0N3\x82v"F\x17\xab\x12\xdfv\xdbm\x1b\xcd\xe3\x13\xa55\xca\xb3\xbeY4\xe4`\xc7\xb5/\x1a\x15\xd3\xc6\x96\xda\x16Z\xfb\xda\x9b\x83)\xc9UW]\xa5\xfertP:\x1b\x1de\xf0\xe0\xc1\xd1\xf7\x89\xd2P\x99ai\xaen\xee\xcf\xb3\xcf>\xab\x7f\xe3\x10\xda\x96\x9cp\xc2\tQmk\xcd\x9a5\xfe\xd1z6\xc5\xb3j\x8d\xfb\xd1\xd8\xf3\xe8\xdd\xbbw\x836\xb4Tc\x93\t-l\x00\x97\\r\x89\xce\xb7\xedCo\xce\xa8\xc7\x03\xb2\x06\xe2x\x92\xe9hM\x95\x17\xc46\x0c\xce3\xa8\r\x06\xa1\xfe#\x8e8B\xffn\x0b\x03u\xd8sm\x0e4[\x84k\xfc4!\xfe\xbd\xdd|\xdd\x98\xd3\xef[o\xbd\x15\xfdM\xd82\xc3b\xeb>\xf5\xd4S7*\x83\x01\x01\xdb\x11\x1a\x03\xd3\xb1\xb6\x04m\x0bc9m\x8a\x05\x89\xb0\xb4\xd6\xb3\xb2$z?\xc2>\x0fkCCC\xe4ea\xc7\xc7\xf8\xf1\xe3[\xed\xfc\xdb\x1c\xd1\x1aZ\r\xbb\x9cL\xb12\nDd~\xad/\x91\xeez\x8c\x97\x08\x82\x06\x97e\xed\xf2/\x9f\xe3\x132q\xe2\xc4\x98\xdf5\xb4L\x1b\xfc\x8d\xf5K\xb1\xcb\xae\xc9\x94g\x11!\xd8\xe0\xf2o<\xf6z\x83\xd7d\x7f\xdbP\xf9\xf6\xfb\xf1\xe5&z\xae\x8d\xd5\xd1\xd0\xf1\xe03\xb1~4A\x07\xc1\xe0y\xd8\xa5\xeb\xe0w9\x17{\xcc\xde\xdbD\xca\x8c\xa7\xb1\xe5\xf1`\xdd\xd6\xcf\xc8\x96\x19\xbc\xbf\x96\xa6\xeesS\xd8s\x0f\xba\x0c\x04\t\xba@\xf0\x8awyh\xadg\x05\x8d\xb5\x07H\xe4~$\xf3\x8c\x83\xe7\xcf{\xfa+\xe7\x19\xff\xfd0\xf7\xb9\xb1g\xdaV\xb4\x99\xd0\x8a\x7fq3\x9fy\xe6\x99&\x1b4\x1b\xa9\x83\r\x80\xdfL\x9d:U\xcbl\xec\xa6\xe1\x99l\xbfOC\x0c>\xccd\xca\x03\xdb0\xe3\x1blC\xd8\x07f\xbf\x9bl#M\xe4\\\x1b\xab\xa3\xb1\xe32\x1d\x88\xf1\xc4\xa6\xc16\xe6\xb9\x8e\x1f\x90u\x16\xb4\xdf\xe5\\\xa6M\x9b\xe6\x7f\xc3#\x912\x834\xd5\xc0\x1b\xaa\xbb!\x9f(\x08\xd3\x99\x1a\xa29\xa1\x05\xb6l\xce\x81\xe7\x12Ok<+h\xaa=@"\xf7#\xec\xf3@(\xcb,\'z\xfe|\x8f\x1d\x0f\xabV\xadj\xf0\\\xc2\xdc\xe7M-\xb4\xd2\xf8?\xa9\xd0\xe1p8R\x82\xcd\xceO\xcb\xe1p8\x9a\xc2\t-\x87\xc3\x91R8\xa1\xe5p8R\n\'\xb4\x1c\x0eGJ\xe1\x84\x96\xc3\xe1H)\x9c\xd0r8\x1c)\x85\x13Z\x0e\x87#\xa5pB\xcb\xe1p\xa4\x14Nh9\x1c\x8e\x94\xc2\t-\x87\xc3\x91R8\xa1\xe5p8R\n\'\xb4\x1c\x0eGJ\xe1\x84\xd6\x8f\x10"^v\xea\xd4\xc9\x8c\x1d;6\xa5\x82\xbd\x11s-\x95\x83\xd396\rNh9\x14\x02\xc1\x11\xfb\x1ca\x97\x96\x96\xa6\xaf\x9c\x9c\x1c\r\x0e\xd7\x96\xb1\xd9-\xef\xbf\xff\xbe\xc6]\xef\xd6\xad[\x8b\xc3W;~\xdc8\xa1\xe5\xd0D\x08\xfd\xfa\xf5\xd3\xd8\xe7D\xaf$9\x02/"x\x12\x1f\x7f\xf4\xe8\xd1\x1aqvShAC\x87\x0e\xd5tU\x0eGc8\xa1\xb5\x85\x83\xc0\xb2!\xb0\xef\xbf\xff~\x8d\x7f\xff\xc1\x07\x1f\xe8\x8b\xbf\xc9uWTT\xa4\xdf\xbb\xee\xba\xeb\xfc_\xb5>d\x93\xa1\xbe\xf8\xe4\x19\x0eG<Nhm\xc1\x10[\xfc\x8a+\xae\xd0\xbf\xef\xbb\xef>\xf3\x8b_\xfcB\xff\x0eBrP\x9b\xdb1L2S\x87\xa3\xadqB\xab\x8d\xb0\x89<\x826"\xecC\r\xa5s\xb2\x86\xf3\xcb/\xbf<j[\xb2\xbf!w]c)\xa0H\xa8\xf0\x9f\xff\xfc\'Z\x076\xa8?\xfe\xf1\x8f\x9a!(\x0c63\xd2\x98f\x92F\xec\xb2\xcb.\rf\x1ej\xee\xbcmb\x05>#\x9b\xb2\xfd\xec\xa4\x93N\xdah\xaai\xcb\xb2I\x1d\xe2y\xf5\xd5W\xcd\x0e;\xec\x10-c\xf8\xf0\xe1\xe6\xdak\xaf\x8d\x96\x13<\x17\xfe\xb6\xf5\xb1\x18\x11\x14\xb4$\xe88\xe0\x80\x03\xa2\xe5\xf0\xe2\xb9\xc4\'\x81\x80d\x9f\x8b\xa3\x8d!\xdc\xb2\xa3u\x99<yr4\x067\xf1\xc3I4@\xd2\r\xde\x13\x93\xbb\xb1$\r$\x1a\xe0_\xbe\xd3\xdco \x98\xa4 \xf8}\xfbj,\xf6\xb8%>\xbe}S\xd8\xb8\xf9\xc1X\xe1\x8d\x9d\xb7M\xaa@\x1c\xf6\xeb\xaf\xbf^\xff&q\x02\x9f\xd9\x98\xe7\x89\xc4"\x0f^\xa7M\xf2\xc0w9f\xe3\x92\xc7\x9f\x0b\x9fQW0\x16\xbc\xbd\x06^\xb6\x1c{\xae\xc1\xb2,\xc9>\x17G\xdb\xe2\x84V\x1b\xf0\xde{\xef5\x98\x80\xa0\xa1\x8e\x0f\xb6s\xd8\xcf\x82\x9d\xb9\xb1\xdfP\x07\xc7\xe3\x134\x90\xe0\x80\x04\x05|\xd6\x94\xd0\nf\x9d\t\x93\x90\xa0)\xa1e\x8f\xdb\xba\x9a\xcahc\x939\xc4w\xf8\xc6\x84\x96\xbd\xce\x91#Gn\x94\x88B\xb4\xbe\xe8=\x0e\x9eKC\xd7\x1d\xbc_\xf1\xcf\x85\x04\x12\xf6\xb3`\x1d\xc9<\x17G\xdb\xe3\xa6\x87m\x00Fe\x8c\xda\xf1\xc9<\x99\xb2H\'\xf0\xdfm\x0c\xd34\xf2\xee\x05\r\xd1\xf67L\xe3\x82S*\x9b\xb2\xff\x0f\x7f\xf8\x83\xe9\xda\xb5\xab\xfe\r}\xfb\xf6\xd5\xec\xd7M\xd5\x93\x0cC\x86\x0c\xf1\xff\xda\x98\xf8\xf3\x0e\xe6\x84\xe4_\xa6W\x96`&g\x11\n\xfe\xd1\xc6\xb1\xd7\xc9T;x\x9d@F\xe5\xf8{,\x82G\x17\x0f\xe2\x8d\xf9\xb6\x9c;\xef\xbcs\xa3\xdf`\xb7\x13mn\xa3\xe9\xaf%\x91\xe7\xe2h{\x9c\xd0jC\xb0k\x91X\xf3\x8c3\xce\xd0\xd7\x95W^\xd9dBL\xdc\x0e\xe2;\x9bM\xb0\x19\x04[\x96\xcdt\xdcX2\xd9\xd6f\xce\x9c9\xfe_\x1b\xd3\xd0y[!\xd7T*\xfb\xd9\xb3g\xfb\x7f5L\xf0:\x07\r\x1a\xe4\x1fm\x9a\xfd\xf6\xdbo#\xe1\x16\xa6\x1c+\xc8\x1a:\xa7\xb0\xcf\xc5\xb1ipB\xab\r\xa0\x93`\xb4\xc5Y\x12\x03\xf7\x1dw\xdc\xa1\xaf{\xee\xb9\xc7\xff\xc6\x0f\x8f\xcd\xd0\r\xcd\t\x0f\xb0\x86\xea\xa6\x84Pk\xc3}\xc4\xb15++\xcb\x0c\x1c8\xd0?\x9a8\x89\x94\xb3)\x1ci\x1d-\xc3\t\xad6\xe0\xa2\x8b.RGM\xa6\x15_~\xf9\xa5\xfa\x1f\xf1b:\xd4\xda\xd3\xb6\x96`\xb5\x8b\xe6:\xaa\xd5T`\xd8\xb0a\xfa\xef\xa6\x00\xc1\x8a\x90\xac\xae\xae\xd6\x95\xbcdI\xa4\x9cM)\x94\x1d\xc9\xe1\x84V+\x13\x9c\x8a\xdcv\xdbm\x1b\xd9OZ\x03\xab%\x85\xb5\x0b5\x86\xb5\xcb\xbc\xf4\xd2KM.\xdfc\x9fc\x9a\x8b\x10n\xca5\xa2\xb5i\xad\xebl\xae\x1c\x9e\xd9\xb3\xcf>\xab\x7foJ\xa1\xecH\x0e\'\xb46\x11t\x8c[o\xbd\xb5I\x9bV"X\x7f\xa6\xeb\xaf\xbf>\xc6\x10\x8c&\x81oR\x98z\x98*M\x9c8Q;\xf3\x1e{\xec\x11\xed\xb8\x16\xce\x19\x8d\x11\x8fy\xb8\xe0\x82\x0b6\xb2\xed\xb45V\xe8\xc7_\'L\x9a4\xa9A\xff\xaa\x86\xb0\xf7\xeb\xd4SO\xdd\xe87\x18\xdf\x7f\x08\xa1\xecH\x0e\'\xb4Z\x19FuV\xcc\xac 8\xe1\x84\x13\xcc\xaf~\xf5+\xdd\x08|\xd3M7\xf9\xdfj9\xd6\xe1\xf3\xb3\xcf>Sm\tC?N\x93\x18\x9a\xfb\xf4\xe9\xa3\x0e\x93a\xc0A\x93r8_:6\x8e\x93\xbb\xed\xb6\x9b:rb\x03\xc26\x87\xd6\x887\xfcq\xc7\x1d\xe7\xffj\xd3\x81#j\xf0:\xb9\x9f\\+N\x9f{\xed\xb5\x97\x991c\x86\xff\xcd\xa6aE\xd7\xae\x10\x8e\x181"Z\x0e\xda&\xf7\xcdj\xc6\x9bZ(;\x12\xc7\t\xad6\x00!\xc5\x94\x8a\xe5\xf7G\x1eyD\r\xf0xPO\x9d:UW\xa2Z\x03\x84\xe3\xd3O?m.\xbe\xf8b\x158\x18\xfa\xdf~\xfbm\x15.t\xf0\xb0+[\x94\xc36\x1d\xb4\r\x96\xfe\xe1\xc3\x0f?\xd4=\x80L\x95\xd8\xdaCy\xe7\x9f\x7f\xbe~\xb6\xa9\xb1\xd7\x89@\xb1\xf7\x93k\xed\xde\xbd\xbb\xb9\xe6\x9ak\x12\xd2\x8cn\xbc\xf1Fu\x87@\x13\xb5\xe5p\xad\xf6\x1aw\xdai\'\xff\x9b\x8e\xcd\x994\x9c\xb5\xfc\xbf\x1d\x0e\x87c\xb3\xc7iZ\x0e\x87#\xa5pB\xcb\xe1p\xa4\x14Nh9\x1c\x8e\x94\xc2\t-\x87\xc3\x91R8\xa1\xe5p8R\n\'\xb4\x1c\x0eGJ\xe1\x84\x96\xc3\xe1H)\x9c\xd0r8\x1c)\x85\x13Z\x0e\x87#\xa5pB\xcb\xe1p\xa4\x14Nh9\x1c\x8e\x94\xc2\t-\x87\xc3\x91R8\xa1\xe5p8R\n\'\xb4\x1c\x0eGJ\xe1\x84\x96\xc3\xe1H)\x9c\xd0je^\x7f\xfdu\x8d\x86i\xd3\xa7\'\xf2"\xba&9\x0b\x1b\x82p\xc0\xe3\xc6\x8dk\xf0w\xcd\xbd\xf6\xd9g\x1f3y\xf2d\xbf\xa4zH\xf4p\xfb\xed\xb7k\xd8\xe5\x86~\xd7\xd4k\x8f=v3\xe7\xfe\xfa\x023z\xab\x83\xcc\xb0\xde\x13\xcc\xf0>\xfb\x98\xa1\xbd&\x98Q\xf2\xfe\x9a\xbf\xddhv\xdb-\xb9s%\x8a(\xc1\x12\xe3!\xec\x1bi\xfcI<\xd1\xd0\xef\x9a{\x1d~\xf8\xe1f\xfa\xf4\xe9~i\xf5\x10\xc2\x99P\xce=z\xf4h\xf0wM\xbd\x88LK\x9a}\xc7\xa6\xc5\x05\x01lE\x88P\xfa\xa7?\xfd\xc9,Y\xb2\xc4?\xe2\x91\x96\xdb\xced\xf7\x1bc2:\xf44\x91\xbaZ9\x90n\xea\xd6/3U\x0b?5\x91\xcaR\xff[\x1e\x03\x06\x0c\xd0Nt\xf4\xd1G\xfbG\x8c\xf9\xd7\xbf\xfee\xae\xb8\xe2\n\xb3r\xe5J\xff\x88Gz~G-7\xbd]7)\xb7N\x8f\xd5\xae[b\xaa\x17~f"\xd5\xe5\xfa\xdeB\x1eB\xc2=\x1f|\xf0\xc1\xfa\x9e\xcez\xd5UW\xe9\xb1\xf2\xf2\xd8\xeffv\x1fb\xb2z\x0c7&+\x17ia"\x15\xebM\xf5\x92/\xb5\xec \xe9iY\xa6o\xb7\xe1&/\xb3\x8btb\xc6\xbf\x88YS\xb2\xd0\xac+_d*++\xbc/\xf9\xa4\x17\x14\xc9\xb9\x8e5\xe9\x85]\xea\xcfu\xedb9W\xb9\x075\x95\xfa\xde\xb2\xcd6\xdb\x98\x7f\xfc\xe3\x1f\x9a\xc3\x10jkk\xcd\xd5W_m\xae\xbb\xee:S\\\\\xac\xc7,\x94\xa7\xe5J\xf9\xd1rW\x7fg\xaa\x17\xc9=\xa8\xad\xd1\xf7\x96\xed\xb7\xdf\xde\xdcr\xcb-:8\x00q\xf4\xff\xf8\xc7?\x9a\xff\xfc\xe7?\xa6\xce\xff\xad%\xab\xd7\x08\x93\xd9m\xb0\xdc\x8cl\xef\x1e\x94\xad1U\x8b\xbf0u\xc5\xb1\xcf\x00\x81ODT\x1b\x83\xde\xd1\xf68\xa1\xd5J\x10\xb2\x98x\xe6\xeb\xd7\xaf\xf7\x8fH\x87j\xd7\xd5\xe4\xefx\x9c\xc9\x192\xded\xf5\xdcF\x85\x8b\xb1B\xabd\xa5\x08\x82\x19\xa6\xe2\xabWM\xd9\'\x8f\xc6\x08/\x12\x81\xdew\xdf}\xdai\x1f}\xf4QM,\x11L\xea\x80\xf0\xcb\xdf\xe9x\x933x/\x93\xd9s\xb8t\xd8\xceR\xaet\xba4\xe9\xb0\x1bVH\xb9\xd3M\xc5\x97/\x99\xf2O\x9f\x10\xe1U/<\xfa\xf7\xef\xaf\xda\n\x1a\x1b\x02\xe0\xff\xfe\xef\xffT\x83\xb1d\xf7\xdf\xc1\xe4\x8d=\xdado\xb5\x9b\xc9\xec2\xc8\xa4e\xe6\xc8Q\x84V\x89\xa9^1\xc7T\xce}\xcf\x94M\xbe\xdf\xd4\xaeY\xe8\xfd@@p\xf5\xec4\xcct\xc8\xedi\xd6\x96-2\xcb\xd7}-e\xd6\x0b\x80\x8c\xa2>r\xae\'\x98\x9c\xadw\xf7\xce5\xbfS\xfd\xb9\xae_\xee\x9d\xeb\x8c\x17\xe5\\\x9f\x14!S\xed\xff\xca\x98\xad\xb6\xdaJ\xaf\x9dX\xf5\xff\xfe\xf7\xbf\xcd\xb9\xe7\x9e\x1b#X2\xbb\x0c4y\x94\xbb\xd58\x93)\x026=\xaf\x83\x9c\xaa|.\x97S\xbb~\xa9\x08\xadi\xa6|\xfa\x0b\xa6|\xda\xd3^}>$\xcax\xec\xb1\xc7\xf4_\xae\x9f\x18\xf9Ar\xb6\xde\xc3\xe4\x8d9\xcad\x0f\xda\xc5dt\xeao\xd22\xb2\xe4h\xc4\xd4\x95\xaf75\xcbg\x9b\xca\xaf\xdf6\xa5\x93\x1f\x10\xe1\xb5\xc2\xfb\x81@V\xef\x07\x1f|\xd0\xec\xb9\xe7\x9e\xfe\x11G[\x92qy0g\xb9#)\xc8\xee\xf2\xdb\xdf\xfe\xd6|\xf7\xddw\xfe\x11O\x00t8\xeazS\xb8\xe7\xe9&{\xc0(\xe9T\xd2Y32MzV\x9eI\xcb\xcaQ\x01\x96\xddo[\xe9$"\xd0zm#\xda\xc1|\xe9l\xcb\xf4\xb7%%%Z\x16\x89%\xfe\xfe\xf7\xbf\x9b\x05\x0b\x16\xe8q\xc8\x96N\xda\xf1\xe8\x1bM\xc1n\xbf\x92\xdf\x8f0\xe9\xb9E~\xb9\xb9Rn\xae\x08\xb4\xeer|\xa4\x084)\xb7\xfbPS\xb3\xf2\x9bh\x07C\xa0\xa2\x05\x92\xdc\xe1\xe6\x9bo\x8e\xc9\xd8\x83p\xedp\xf4\r\xd2a\x7f*\x02\xa1\x9fI\xcf\xf4\xce\x932\xd1\xe82{\x0e\xf6\xca\xec\xb9\xad\xa9\xdb\xf0\xbd\xa9Y\xe5\xa5\xe2\x92\xeelj\xea\xcaM\xbbv\xf9fu\xf1BS\x15\xd0\xf0\xb2\x07\xefi:\xfeL\xceu\xd7\x93\xe5\x9cDh\xe7\x88`\xc9\xcc\n\x9ckO\xb9Or\xae\xdc\x03\xd1j\xaa\xbf\x9f+\xc2|\x95\xfe\x96s[\xbat\xa9\n*\x04\xcb\xea\xd5\xab\xf58\xe4\x0c\xff\x89\x94{\x83\xc9\xdf\xe5\x17&\xbb\xcf0\x93\x9e\xdd>\xb6\xdc\x8e\xbd\xf4\x9e\xe7\x0c\xde[\xaee\x80\x08\x9bY\xa6\xae\xcc\xbbV\xb4U^\xdf\x7f\xff\xbdjsv0HK\xcf4\x05\xbb\x9f*\xcf\xecZ\x93\xb7\xddA*l\xd3EhG\xefAA\'yNC\xbd2{\x0cU\xc1\x8d\xa6\x08\x1b6l\xd0\x04\x1b\xc4\xd8\xef\xd8\xb1\xa3\x1es\xb4\x1dN\xd3j\x05\xc8\xf2B\x07\xb0\xb72k\xc0N\xa6\xe8\x84\x7f\x9b\xec\x81cE\xd3\x11\xed!\xa0A\xc4\x836\x93\x96\x95!#\xf8\xfbf\xddS\x17\x98\xaay\x9e\xed\t\x9bI\xe7\xce\x9d\xb5C\x90\xb8\x02\xb2\x87\xece:\x1dw\xab\xc9\xec;\xc2D8V\x17;\xfd\tBGK\xcbL\x17\x8d\xeb\r)\xf7B\xd1<>\xd7\xe3\xe9\xe9\xe9\x9aq\x86\xce\xaa\x9a\x8bh<\xf9;\xfd\xdct\xf8\xe9\xb5\xa2Y\xf4\x12\x8dO4\xb3\x80\xa6\x14\x83\n\xc7lS\xb5h\xbaY\xff\xc4\xf9\xa6b\xd6\x1b\xdeq)\xa3 \xbf@\xa6\x84\x95\x9av\x0cr\x86\xefk\x8a8\xd7\x9eC\xe5\x1e\x848\xd7\x8ctS>\xe3e\xb3\xfeI9\xd7\xa5_\xeaq\xce\x95{\xb0f\xcd\x1a\x9d"B\xeev\x87\x9a\x8e\xc7\xddl2\xbb\x0e\x94{ \xd3J4\xd7FH\xcb\xceG\xa95e\x9f>c\xd6?\xf3\x7f\xa6\xe6{/\xb5\x7fFF\x86\xc9\xcb\xcb\xd3\xc1\xc1;\x90i\n\xf78\xc3\xb4?\xec/2\x98t\x92{ \x82\xb7\x91n\x81\xe6\x95\x96\x9d%Z\xe7\x87f\xdd\xe3\xbf7U\xf3?\xf6?1\xe6\xca+\xaf4\x17^x\xa1f\xf6q\xb4\x1dN\xd3j!\x18\xce\xff\xfa\xd7\xbf\xaap\x81\x8c\xa2\xde"\xb0\xfeer\x07\xef\xe6\t\x80&:\x95"\x9fc\x8b\xc9\xec6H4\x8f^\xa6r\xce;2\x1d\xf3\xec6\x08\x16\xdbY3\xbbn\xe5\t\xc2\x01c\xa4\xb3\xd2\xa9\x1a\x11,\x16\x11\x12Zn\xaf!&C\xa6\x8fZnU\x99\nV\x84`T\xc0\xf6\xdb\xde\x14\x1d\xff/\x93\xd9\xb9\xbf\x9c/ZG\x13c\x98\xd4\x19\x91\xf3\xc9\xe8\xd4[\xae\xb3\xaf\x08\xd8\x8fL]\xa9\xa7\x01a\xd4\xb7\xd3\xb7L\xd1\xf0\x8aN\xbc\xcdd\xf5\x1d\xe9\x0b\x800\xe7\x1a\x11MF\xb4\xa6\xdc\x0e\xde\xb9\x8a\xc6\xc69r\x0f\xa2\xe7\xdag\x94Wn\xf7!\xe1\xca\xad\xe5:E\xd8\xf7\x19!\xc2&\xc7T\xcd\x9d\xa4\xf63{\x0f,92\x18\x14\x1d\xfb\x0f\x93^\xd8\xd5\xbb\xb7M\xc1=\xe0\xbe\x8a\xd0L/\xe8b\xaa\xbe\xfdP\x9e\x97\xf7\xec\xbf\xf9\xe6\x1b5\xf8#h\x1dm\x87[=l\x014\xfe7\xdex\xc3,^\xecM\x13\x80\x11;{\xd08S\x87v\xd1\\\xa7\xb2 \xb8\xe4\xfb\xb9\xdb\x1eh\n\xf6\xfc\xb5\x1c\x10\xd5%\x8e\xc2\xf1g\x8b\x80\x19c\xea\xd0.\xfcN\xdc,\x94[Um\xf2F\x1fi\n\xc6M\x94\x03\xb1\xe5\xa6\xa1aH}\x19\x9d\x07\xc4\xd8\xbe\x9a\x84N+\x1d\x9e\x8e\x9e\'S\xca\x8d\xce5=\xc3\xb4\x9bp\xae\xc9\xea=\xca\x13\xdaM\t\xc1 \x08.\x11|\xf9;\x1ck\xf2w>\xd1?X\x0f\xdaX\xbb}\x7f\xabS^O\xb0\x84)W\xce\xadV\xca\xad\xa9\x96)\xea/M\xee\xf6G\xf9\xc7\xebI\xcfmg\n\xf7:\xcb\xa4\xb7\xef.\xdf\x0by\x0f\xfc\xe7\x95\xb7\xdd!\xfa\xb2,Z\xb4HS\x929\xda\x16\'\xb4Z\xc0\xb2e\xcb4?\xa0%\xa3\xf3@\x93;\xfa\x08\xed`t\x96\x84\xe0\xfb\x19i&w\xf8>\xbaz\x17$\xb3\xc70\x93;\xea0\x152\xa2\xea\xf8GC\xc2\xd4T\xa6\x9f9\xdb\xfcD\xce\xaf\xbf\x7f\xd0C\xcb\x1dq\x90NEC\x0bX`\xaa\'S\xb7\\)\x13\xfbN\x90\xac^\xdb\xea\x14.\xe12\x81s\xcd\xceT\xe1\x8dM)\x08Z\x16\xe7\xaae\x86\x15\xda>\x08-\x93\x93c\xf2F\x1e\xac\xc2)H\xa6\x94\x9b\xb3\xcd\xbe\xdeJc"\xe5\xf2\xfdL9W)\x13\xad\xd3\x82\xe6\x1d\xbf\x1a\xebh]\x9c\xd0j\x01\x18\xcb\xe7\xcc\xf1\xec$\x903xO\xafS4a\xbfi\x12\xe9\\\x99\xdd\x86\xc8\x14p\xac\x7f\xc0#g\xc8\xde&=\xbfHG\xf8\xa4\x10\r&[\x84Iv\x9f\xed\xfc\x03\x1e\xb9\xdb\xeco\xd2\xf2:\x88\x1cH\xa2\\\xd14\x10Ph\x7fAr\x86\xee\xed\x95\x99\xa8p\xb5p\xae"H(;H\xce\xb0}LZN\x81\x94\x9b\xa0 \xb4Pn\xff\xb12 \x0c\xf6\x0f\x08i\x19* \xd32q\xedH\xa2\\-sG\x93\xd9s\x1b\xff\x80\xd1A,\xb8\xd2\xebh}\x9c\xd0j\x01\xacp\xadZ\xe5\xadvAv\x9f\x912\xddh\x9f\x9c\x10\x10\x18\xed\xd3;v1\x19]\xb6\xf6\x8fxd\xf7\x1d\xe5u\xd8\x96\x94[\xd4C5\xc1 Y}GK\x87\xc5\x0f)\xf1\x0e\xcb\xb9\xa4\xb7\xebh2:\xf6\xf6\x8fxdS&\x9a\xa6o\xdfJ\x14=\xd7\xce\xbd\xd4\xdd JZ\xba\x96k\xd2\xb3\xe4\x0b\x89iY\x16\xca\xcd\xe82 \xe6|\xd32\xb3Lv?)\xd7\xf71K\x94\x88\x0cN\xe9\x1d\xbb\x99\x8c\x80\xf6\xb6b\xc5\x8a\xe8b\x84\xa3mpB\xab\x05\xe0:`\r\xf0\x80k\x80\xfa\xf5$\xd9\xb1\xf8\x9d\x0c\xfe\xd2\xe9\xf1\x8f\xaa\x07-\x8b%\xf9\xa4\xa1\\\xf9y\xc3\xe5J\x85ItX-SZO\xe3\xe7\xda\x82{\xc0\xb9\xaa\x8fX=\xb8\x1c\xa4\xc9\x94\xb4E\xe5\xca\xa3I\xcb\x08\xac\xec\xc9\x05\xe8\xf9\xeaT\xd6?\x96\x08\xfe\xb9\xa6\xe7\x14\xfa\x07<\xb7\x12\xbbx\xe2h\x1b\x9c\xd0j\x01\x99\x99\x991\xcb\xdb\x9e&\x94d\xa7\xb2\xf0s\xe9\x0c1\xe8TK?\xd0\xb7I\xd1d\xb9- N\xa3\xf2\xa6\x85-,3\xfe\\\x11*L\xb99\xd6\x92\xa2\xb5\\\xef\xcf(\xc9Nc-\x9cR\xa0\x0c|\xebT\x08:\xda\x0c\'\xb4Z@\x87\x0e\x1dL\xa7N\x9d\xfcw\xc6\xd4\xae]\xa2+[\xde\x96\x96$\x90\xdfE*\xabM\xc4w\x84\xb4\xd4\xacY\xecouiA\xb9\x15U\xa6\xae|\x9d\x7f\xc0\xa3f\xcd")\x97\xa9L\x12\x9d\x8c2\xabj\xa2\xee\x19\x16\xafL\xdc\t\x92\xeb\xb8i\xa2jF\xca+M]E\xe0\\E0j\xb9\x0c\n\xe9\xc9\x97[WV\x1e{\xbe"\x08k\xd6,\x14\xa1#\x827\x99b\xe5\x1e\xd4q_\x03\xcf\x0b\xe7R\xfc\xc0\x1cm\x87\x13Z-\x00\x7f\x9cn\xdd\xba\xf9\xef\x8c\xa9\xfen\x8a4\xe2\xf5\xea\xac\x98\x0cL-k\xd6,5\xd5\xcbg\xfbG<\xaa\xe6O\x16aV*}$\xb9\xce\x80\xdd\xaaf\xd5BS\xb3\xe2\x1b\xff\x88G\xf5\xbc\x8fD\xca\x88\x90M\xa2\\\xce\xb5v\xf5\x12\xf5\xb8\x0fR=O\xce\xb5\xba"\xe9s\xc5\xb3\xbdz\xc5|)w\xbe\x7f\x00"\x9e\xd3mmu\xf2\x03\x82\xdc\x83\xea\xe5s\xe4\xfe\xd6\xef.`\xdbP\xd5\xb7r\x0f\x10\x86I\x94\xcbT\xb3f\xe5<S+\x02\xd52x\xf0`\xe7\\\xda\xc68\xa1\xd5\x02h\xa0#G\x8e\xf4\xdf\x19S\xf9\xcd\xfb\xa6z\xc9L\x9d2H\xef\xf2\x0e&BV\x86\xa9^<\xcdTI9A*f\xbf\xe9ysSf\x12\xe5\xa6e\xa5\x8b\xe0\x9bb\xaa\xbe\x8b\x8d\x9eP9\xe7]S[\xb2Z\xbe\x90D\x87\xcd\x96s]\xfe\x95\x94\xf9\x89\x7f\xc4\xa3b\xd6\xeb\x9epl\xc9\xb9\xce\xfbP\xee\xc3\x17\xfe\x11\x8f\x8a\x99\xaf\x98\x9a\xd5\xdf\xf9\xe7\x9a\xcc\xbdM3Us\xde\x91\xfb\x18\x18\x10d\xbaY9\xe7mO\xfbJ\xe6\\s\xd2M\xf5\x82\xa9Q\x0f~\xd8i\xa7\x9dt\xc7\x81\xa3\xedpB\xab\x05\x14\x14\x14h\xe4\x00K]e\x89)\xfb\xf0^\x9d\x86\xc5\x18|C\x90\x96\x95\'#\xf6RS\xf6\xf1C\xba97HD\xde\x97J\xb9x\xb4\xa7\xb1\x82\x96\x00le\xa9Y\xf1\x9d)\xfb\xe4a\xd1\xd6\xe2\xa6rk\x17\xcb\xf1G<\x9f\xa3\x044#4\xb7\xba\x92u\xa6\xe2\x8b\x17\xa3{\x05-u"\x04\xcb>\x92se:\x9b\xe0\xe2\x81\x9e\xeb\xf2oM\xb9\x9cSD\xeee\x10"L\x94}t\xbfL\x11e*\x97\xa0\x16\xa7\xe5.\x9ee\xca?}\xdcwL\xad\xa7\xfa\xfboL\x99\x1c\x97\x07&\xaf\xf0\xdd\x81\x85\x82\xbau+L\xc5\xf4\x17c\xa6\x9c{\xed\xb5\x97\xd3\xb4\xda\x18\'\xb4Z\x08\x9bdG\x8f\x1e\xed\xbf3\x1aU@;\x1d\x8e\x92\xb8\x13\x84A\xbe\x17\xa9\xad2eS\x1e\x15A\xf0\x9c\x7f0\x96\xf2\xa9\x8f\x99\xf2\xcf\x9e\x94\xbf\xa4\xd3j\xe4\x81\xe6\x10\xcdA:\x16\xdbaJ\xa5\xb3W~\xf5\x9a\x7f<\x96\x92w\xfem*D\xdbPw\x820\xc2@\xa7\xbei"\xec\x9e0\xa5\x93\xef\xf3\x8e\xc5Q6\xe5a\xb9\x0f\xcf\xca\xd7\xe4\x1cBM\x95\xe5{Yr\xae"\x94K>\xb8\xdbT~\xddpL1\xea\xab\xf8\xf2\x7fR\xa6\x9cg\xc8rq\xbf@\xa8\x94L\xba\xc3T\x06\xf6\tF\x11\xe1Z\xf2\xd6\xcd2\xb5\xffX\x85q(\xc1\xc5\xf3\x8a\xd4\x99\x92\xf7\xee1\xe5\x81\xe7E[\x18;6\xd6\xc7\xce\xd1\xfa\xb8\xbd\x87-\xa4k\xd7\xae\xea\xfa@\xf0?\xa5\xae\xd6T/\x9cj\xd2\x88u\xd5c[\x1d\xe5\xbd\xd9L\xdc\xb2\x95th\xdd|\x8b`\x91\xceZ\xfe\xf1\x83f\xc3s\x7f\xd4\xbf!77\xd7\x0c\x1f>\\\x1d\x15u\xaf\xa0\x085\xe2oe\x14v5Y=\x87kgT\xe2W\x04m\xb9Y\xd2\xb1*6\x982\x11\x02\x1b^\xfc\x8bo\xc87:u\x19:t\xa8\xc6\xa5\xc2\x9f\x08[Y\xf5\xa2/LV\x9f\xedLF\xa7\xbe^\xc7\xf5\x96\xc4\xf4\xfbQDkR7\x04\xd1\xca\x08y\xc3\x06d\xbb`\x80\xe1y\xd8\xb0a\xea\t\xce\x1eD\xea\xd2sm\xdf\xc3d\xf5\x18\xda\xfc\xb9"\x04\xd0&\'\xddn\x8a_\xb9\xda7\xe4{\x9a,\xe5Z7\x02\xee\r\x1b\xbf3;\xf61Y\xdd\x07{\xe7\x03\r\x96\x9b\xad\xe5b$G(\x95\xbc\xf9\x0f\xb5\x89A\xfb\xf6\xed\xcd\xd6[om\xd6\xad[\xa7\xfb%\xebJ\xd7\xcaTw\x96\xd1\x98g\x1d{\x89\xdc\x12\x81\xa8e\x06\xcb\x95\x87h\xefAM\x85)}\xff.\xb3\xe1\x7f\x97\xeb\xfd\x036w\x13\x07\xcd\t\xad\xb6\xc7\t\xad\x16\xc2\xf2\xf6v\xdbm\xa7\xe1c\x08O\x024d\xe2.1M\xcc\xe82P;m\xba\x08\xaf4\x996x\x9d\x94e\xf1\x0c\x9dNV\x7f?G:\xea5\xa6\xe4\xd5k\xf5=\xe4\xe4\xe4\x98_\xff\xfa\xd7\x1aG\x8aP26\xe2&B\x88r#U\xa5\x1aO\xca+\xb7@^"hl\xb9\xa2<k\xb9\xcb\xbe2\xc5\xff\xfb\xab)y\xe3\xa6\xe8\xbeB"\x1b\x10\x91\x82\r\xde\x949\x7f\xbeg\xec&tM\xd5\x9cwMZN\xa1\xc9,\x12\xc1E\x87\xcf\x91\xf3\xa5<^R6\x1d\xb5n\xfd\x12\x11,w\x98\r\xcf^,\x1d}\x8d\xfe\x96%~\xe2\x88\xddz\xeb\xad\x1aJ\xe6\xcb/=\xfb\x0eB\xa8r\xf6[*\xc02;\x0f\xf0\xce\x952E\x98F\xef\x81\x9ek\xb1\xa9^:\xc3lx\xe1\nS\xfa\xd6-Q\xe1\xca\xb9^t\xd1E\x1a\x96f\xd6\xacYf\xee\xdc\xb9z\x9c\r\xdaU_K\xb9"l\xd8\xe4\xad\xe5\xe5\x14\xc8\xbf\xdeyz\xe5\xa6\xe9T\xb8J\x04\xdc\x86\xe7\xfe\xa4\xe7\xcc\xe6i@\x10\x12P\xf1\x82\x0b.0\x1f}\xf4\x91n\xc5\x02\xc2\xccT}\xfb\x81I/\xec\xec\t.\x11xi9y\xb1\xf7@\xb4\xd6\xba5\x0bM\xf1\x1b\x7f\x97{+\x03\x81?\xc0\xc0i\xa7\x9df\xce8\xe3\x0c}v\x8e\xb6\xc5\t\xadV\x00\x1b\x06a\x80\x11Z\xd1\x98Z\xacL\xc9t\xa4r\xc6\x8b\xa6V\x84\x02\xd3\xc5H\xf9\x06S\xb7n\xb9\xd7AD\x13){\xefN\xd5\xaeT\x10\xf9Z\x00Z\xcb\x981cTh\x11\x02x\xd0\xa0A\xbaU\x88\xce\x85V\xa0Z\x8ct.\x82\xfc\xa9=\xa9\x0e\x17\x89\xf5\x1a\t\xb5v\x8d\x94\xbb\xe0\x13\xe9\xa4\xff1\xc5\x94+\xdf\xb3[\x7f(w\x97]v1\xa7\x9f~\xba\x06\x03\xec\xd5\xab\x97\xf9\xea\xab\xaf4\xae\x14\xa0\x91T\xcc\xf8\x9f\xa9\xfc\x86\xdfTJ\x87\xacP\xc1\xc3\xb9\xd6|?K\xa7\xa7\x1b^\xbcR\xa6~\x0fE5!\xb4\x0b4\xa1\xf3\xce;\xcf\xf4\xee\xdd\xdb\xf4\xeb\xd7O\xef\x01\xbb\x04\xbcs\xad\xd0\xc8\n\x18\xd15\x1a\x84hiue\xa2\xdd\xd8s\x95\xfbS\xfa\xee\xbf\xe5\\\xff\xec\x85x\xf1=\xf3\xf1\x7f#\xa0\xde\xa9\xa7\x9e\xaa\x9a,\xd1\\\x11\x86\xc4\xc1b\x93:\xc2\xa2R\x04W\xe5Wo\xc8\xc0\xb0V\xef\x1d\xdaR\xddz\xb9\xb7k\x16h\xf4\x89\xe27o1\xc5/^\xa6Q\\\x83\xe5\x12X\xf1\xe4\x93O\xd6{\xc0\xea/\xe5\x12\xfa\x06\x88JZ>\xedy\xbd\x87\xaa\x95!\xa4J\xd7\xe9\xea`\xf5\xd2\x99\x9e6\xfc\xc2\xe5\xde\xd4\xd7\xbf\xafp\xe8\xa1\x87jd\xd5\xee\xddc\xf75:\xda\x06\x17O\xab\x15A#\xb8\xf8\xe2\x8b\xcds\xcf5l\x97\x82\xf4\xbc\x8e\xa6\x0e\xc3m#N\x8dL\x0b\x89\x84\xc9\xbfh\x05\x84IF\xebx\xf1\xc5\x17U\x18\x10\xb3jcDg\xc9\xef\xe0\x19\xf0\x1by\x9cL\x0b)\x17\xcd\xa8O\x9f>f\xc4\x88\x11\xba\r\x89\xd8\xf3t\xda\x86\xb6\x9e\x10\x11\x15\x83\xb8\xd5~\xe2\xa1,\xcad\xba\xc5\x14\x96\xd5T\x04\x19\x91/\x82aubi\xfe\\\xb9n{\xae\xf8\xc2q\x0f\x80se\xaa\x18\x0c+\x13%-]\xeem{\x15\x8a\x8dQXX\xa8\xe5"\xbc\x10\x84L\xbf\x19\x0c\xb8\xb7\xeclh\xe8|\x89>\x8b@ll?\xe9QG\x1de\xae\xb9\xe6\x1a\x9dn:6\rNh\xb52\x08\x02\xa2\x8d\x12*\xd8NiZ\x03:/SQ\x84\x16v\xa3\xd6\xda\xdfF\'\xe6\x9c\xd1\x8cZs\xa3/\xda\'\xe7\xc99\xdb8[-\xa5\xa8\xa8H\xcb\xe2\x1e \xb8Z\xab\\4D"\xa3\xd2\x15\xc2\xde\x034\xb5\xe3\x8f?^\xa7\x99A\x07cG\xdb\xe3\x84V\x1b\xf1\xc1\x07\x1f\x98G\x1eyDw\xfd\x13\x8e9>!\x03\x9d9\x99[\x8f\xb6\xd0\xae];\x9d\x8ea\x93\n\x86!N\x16\xa6\x8e\x94\x8b\x86\x83\xb3\xec\xb4i\xd3\xfcOZ\x06\xd7\x88\xe6\x85&\x86v\x13\x9f\x98#\x99{\xc0o8W\x848\xd3g\xa6\xce\xc1\xfd\x9f\xc9\x82V\x876\xca\xb9\xe2\xd5n\xed\x93A\xd0~\x89-\xcf\xf4\xfd\x98c\x8e1\xfb\xee\xbb\xaf\xff\x89cS\xe2\x84V\x1b\xf3\xf5\xd7_\x9b/\xbe\xf8\xc2\xcc\x9b7O\xb5#\xb4\x84\x07\x1ex\xc0,\\\xc8\xf6\x91\xd8[\x9f\xd9\xa9\xbf\xc9"\xa2Cn;\x99:\xc9\xffX-[63\x1a&\xd8B\xa7\x9a0a\x82\xbe\x08\x19\xcc\xb4\xe6\xa1\x87\x1eR\x1bU<\x18\xd7\t\xc9\x92Q\xd4\xcf\x9b\xe2\xa4g\x98\xda\xe2\xefM\xf5wSc\xb6\x9f\x00\t5H7\xc6\n\x18+\xa2\x9c\xdf\xbd\xf7\xdek\xbe\xfd\xf6[\xff\x1b\xf5\xa4\xc9T\x8c8\xf8\x1a5A\xfd\xbc\xd25\xc6}\xd5\x82\xa9j\xbb\x0b\x82\xed\x882I\xb9\x85\xd0A\xc8\x90\xb9\x88\xe9\xeeF\xf7\xa0\xdb`\x93\xd5{\x84\xb7\xea\xca=\xc0\xa0\xbed\x86\xa9]\xe5-\x1aX\xb0u\xfd\xe4\'?1\xbb\xed\xb6[t\xcax\xf7\xddw\xc7\xc4\xd3\xb7\xb0\x91=\x8bs\xed\xd0\xb3\xfe\\\xd7-U\xc7\xd8x\x7f04(\xcaE8\xc5\x0f4L)qoaj\xed\xf8\xe1pBk\x13\xf3\xd4SOif\x19\xbbj\x05\x04\xd2\xcb\xdf\xe1x\x933dO\xed\xb4\xdaa\x05|\xac\xf0\x02\xaf\x96\xceU\xf6\xf1\xc3\x9e\x81\xd8\x87Q\x9fte\x97\\r\x89\x994i\x92\xf9\xd5\xaf~\x15#\\H\xa9\x95\xbf\xe3\t\x1a\xab\x9d`\x7f\xb8\x1f\xd8\xed*uekL\xcd\xb2\xafL\xe5\xb7\x1f\xaa\x81\xbd& \x10\x100\xa4,;\xf6\xd8c\xcdK/\xbd\xa4\x0b\x02D\xe4\xb4\x90\x90\x83\xec:\xb9\xc3\xf66\x99\xdd\x87\xe9{\xaf\\\x99\x06\x96\xae2\xd5K\xbfR\x8f\xfe2)\xd7&~\x00\xa6\xa1\xe4X<\xf0\xc0\x03\xcd\x9dw\xde\xa9+\x83\xd6\x00\x0e\x84\x9e\xc9\xdb\xe1X\x93M\xd6\x1e2\x01\xf9n\x12\xac\x94\xb2U\x86\xadLe\x93\x1fP\x83\xb8\x05\xad\x087\x03\x16\x17\xb0#\x9eu\xd6Y\xba\x82i\xf1\xb2\x16\x9d\xa8QV\xb9\xc7\x84S\xb6\xe7Z[\xb2\xd2\xd4HY\x95s&\x99\xf2O\xe5\\\xd7/\xf7\x7fe\xd4\xe6w\xd7]w\xa9\xf0rl~8\xa1\xb5\ty\xf3\xcd7\xcd\t\'\x9c\xa01\x97,\xf9;\x1cc\n\xf7\xfd\x9dh\x02;\x9a\xb4\xcc\x0c#\xea\x98\xf4T\xff\x91H\xe7\x92y\x95\xfeY\xbdp\xba)\x9dt\x9b)}\xef\xbf\xde\xc6a\x81i\xd2\xcf\x7f\xfes\x9d\x82~\xf2I\xbd@#]W\xbb\xfd/\xf0\x82\x07\x16\xb6\x13\xe1\x17\x91\xdfT\xab+\x80"\xda\x16\xdbe\xea*\xabM\xf5\xb7\x1f\x99\r\xaf_\xaf\x9e\xdd\x16l<\xb81 \x08\x82\xd3$\xa2\xaa\x16\xfeD\xca\x95\xf2\xd3\xf3\x0b\xa4\\\xe2\xa5\xd7\xc4\x96\x9bI\xb9\x95\x9an\x0c7\x8eh\xf2\x0b\x01C=B\xeb\xc9\'\x9f\x8c\x11.\x05\xbb\x9db\n\'\x9c\xa3!\x9a\x89\xde\xda\xe0=\xa8c\x0f\xe6\x14S\xf2\xf6?E\x80?\xe8}&`O\xe2\x1e\xe0\'\xc7B\x88%w\xdb\x03L\xe1~\xe7k\x8a\xb1t\x99\xf6m|\xae\x99r\x0fD\xd0\x96WhL\xfab9\xd7\xa0S+B\xf6\x99g\x9eq~W\x9b!Nhm"\x98j\xa0\xb5\x90w\xd0B\xda\xae\xf6G^m2\xbb\x0e\x10\x8d\xa2\xd2\xd3\x02\x1aB\xb4\xa3\xb4\xec\\SW\xbc\xca\x14\xbf~\xa3\xfau\x05\xc1&eW\xbe\x88FJ\x1a\xac\xec~\xa3L]u\xb5\xb7t\xdf\x18t\xdc\xeclS\xb3\xfc\x1b]\xca\xc7\x9d\xc1\x82\r\x8a\xa6a\xcb\xcd\x1bu\xb8i\xff\xd3k4\xf9Ds\x19\x86\xd4g,+\xcbT/\x99\xa5\xae\x17e\x9f?\xed\x7f\xb01\xc4\xc4o\x7f\xe8\xe52\xcd\xec.S\xb5\n\x11V\x8d\x18\xd7\x11\x88\xd99\xa2\xbd-UgY\x1cQ\x83`;\xb3\x86\xf9\xfc\xb1?3\xed\x8f\xf8\x9bhW\x83\xe5\xbeV\xc9}\x15!\xd8\x08\xea\xdb%\xe7Z\xb5h\x86\xd9\xf0\xec\xa5\x9a+\xd1r\xf6\xd9g\xeb\xca \x83\x83c\xf3\xc1\xf9im"p\x03\xc0\x97\xc7\xba,\x90\x05\xa7\xe31\x7f7Y=\xc2d\x96\x91qE\x84\x04K\xfad~\xaeY=_\x13\x87Z\xec\xb8C\xfe\xc4\x8e\xc7\xdebr\x06\x8c\x11mG\x04@cB\xd0B\x9d\xb55&S\x04\x06\xd3\xa7\x9a\xc5_\xa8O\x12 \x00l\xb9D\xf7\xecx\xfc\xadZ\xbe\xee\xdd\x0bUn\xad\xc9(\xea)\x02yk\xf5\x95"\x81j<L\x87\xc9\xe1H\x06\xa3\xe63\x01q\x0fj\xbc\xfc\x83\xdd\x87\xc8\xf4vV\xcc\xb46z\xae\x03v\x94s\xfd\xa7w_9\xd7&\xef\xab \x9f\x93a(\x93\x0cC]\x06\xaaM\x8e\xbc\x8e\x80\x91\x1fc;Z\x97c\xf3\xc1\xed=\xdc\x04 \x00\xb0;EW\xb9d\xca\xc3\x94\x88\xcc\xc8\x91j\x84X\x13\x9d5\x00\x0e\x9f\xa4\xef*\xdc\xfd4\xd1:\xf2\xfc\xa3\x16)s\x8f\xd3U\x18\xd6\xa1]4\xd7Y-\xd2\xd9\xebDhf\xf5\xde\xd6\x14\x8c?G\x86\xb1\xb8=}r\xaed\x02\x8a\x9e\xab/\x1c\x9a\x05a \x02:k\xc0X\xd1\xa6NWm1\x06y_\xb8\xe7\x99r=}\xa4\xdc\x90Yp\xa4n\x04Q\xa6\x08\xa4\xfc]\x7f\xa9\x9ab\x0cr\xee\x85\x13\xce3\x19]\x07\x8b\x96\x99\xd8\xb92\xa5\xcd\xd9z\x17}.\xf6\\1\xf0c\xd7k\xd0/\xcc\xf1\x83\xe1\x84\xd6&\x00/\xf9\xc9\x93\xbd$\xac\x90\xd5{\xa4\x1a\x875\xe6TsZK\x0c\xd2\tE\x00f\xf5\x19mrG\x1c\xec\x1f\xf3@\x0b\xc2\x86\xa5\xfb\xe6\x9a\x98\x0e5\x08\x9d[d\\\xf6\x80\x1dL\xceV\xbb\xfb\x07=\xb2E\x08fo\xbd\xa7\xc8.i*\t\x9d\xab\x80\x03\xad\x14\x9d3h\x9c\x94\xbd\x93\x7f\xd0#g\xab]5[\xb6\x89\xa4\xc9+\xa4\x80\x05=\xd7\x88\xfe6g\xe8x\xff\xa0GN\xff\x1d\xe4\\wS3X2\xe7\xcai\x90\x16?\xbbo}\xe4\x0e\xb2\xeb\x04\xf3\x008~x\x9c\xd0\xda\x04\xd0\xe8\x83\xb9\x11\xe9\x18$fm\xd2.\xd4\x08l\x9c\xceh\xdf\xc5\xe4\x0c\x8c\x13\x02\xd2Y\x99f\xe9\x92~\x12\xe8\x1eA\xf9}\xf6\xa0]\xfd#\x1e9\x83\xf72\xe9\xedY!L\xb2\xdc\xea*Ml\xbaQ\x86\xa1\xa1\x13tS9\xc6\xf1Da\x1bQfQ\x9f\x18\xe1\x029C\xc6\x9b\xf4\xfc\xceI\x95\tz\xae\xdd\xb7\xd6\x84\x1f\x96\xd9\xb3g\xb7\x8a\x1f\x98\xa3\xf5pBk\x13\xc04#\xb8b\xa8\xd1\x14r\nEiH@\xc3\xb0\x88\xa6EZ\xf64\\\x18\x02\xe0\x87\xe5\x95\x99\xa0\x86a\xa1\xdc\xbc<O\xf0\x05 W".\x18I\xa7\xee\x12\x8d\'-?\xdf\xa4w\x88/w\x80I:u\x97\x9ek\x8en\xb1\tB\xb6\x1d\x16,\xf8<)\xe4\\\xd3\x0b\n\xe5\x1e\xd4\xdb\xb0p\xdemx\xeb\x94\xe3\x87\xc2\t\xadM\x006\x91`\x02O\x02\xfe\xa5e\xc8\xd40\xac\xcd%\x1e\x99\xfex!d\xea\xc1\xafI\x03\x04&[&\xf38\xca%\x9aA\x00=W\xa6\xb1-)WZ\x99&\x9a\r\x90n\xcb\ri\xcf\x8b\xc5+\xd3\xc4\x05Z\x8c\x9ekRe\x82\xfcN\xeeA:\x82/@km\x17r\xb4\x0eNhm\x02\xd8\x1e\x13\xdc\x9f\x16)_\xa7S\x11\xcf\xf8\x92(\xf2\x1b\xfaP\\\x04N\xc2\xe0hZ\xf7x\x83w"Pn\x9cQ<RF\xb9\x18\xa2\x939W\x1f\x94\xbf\xb8r\xf1\xc6\xf7"[$Y\xae\x96\x19w\x0fJ\xa5L\xb2I\xb7\xa4Y\xcb=\xa8\rl\xbaf\x0f%\xee\x1f\x8e\xcd\x07\'\xb46\x01\xec\x93\xeb\xd2\xa5\x8b\xffN\xfa\xda\x92/\xd5+=\x99\\\x86h\x12u\xe5e\x1b\'\xa9X\xfa\x95z\xa4\xab\x06\x97\x0c\xa2\xa5\xd5\x15o0\xd5+b7yW/\x99\xa1!j\x92.W4\xb7\xda\xf5kc\xdc\x13\x80\x18\xf0x\xbb{\x9aQb\xa0Qr\xae\xb5\xc4\x8c\x0fP\xb5d\xbaa\xdbO2e*\x9c\xeb\xba\xd5\xa6vM}\xb9\xecod\xf7\x81c\xf3\xc1\t\xadM\x00~>\x84A\xb1T\xce\x9d\xe4mqIF\x10\x10\x8ds\xc3rS\xf9\xcd{\xfe\x01\x0f\xe2V\xd5\xae[\x96\\\x99Bzv\x96\x08\x96y1\x1e\xec\x80\x97xm\xf1J)79m\x83rI\x80Q1\'6\x84r\xc5\xec\xb7\xbcx`I\x08n\xc3\xb9\xae\x9eo*\xe7\xd7\xaf\xc8B\x15e\x12F\xa6%\xe7*B\xbarn}b\x11\xf6\x19\xb2\xd7\xd3\xb1\xf9\xe0\x84\xd6&\x00-\x8b,-\x96\xda\r\xdf\x9b\xb2\xa9\x8f\x8b\xc6\xb4a#\x1bR\x93\xa0A\xd4V\xa9`\xa9\xfan\x8a\x7f\xd0\xa3V\x04@\xf9\'\x8f\x8a\x06G\x99\xb1\xb6\x9e\xe6\xc0\xde\x84\x0fX\xc5\xcc\x97c\x9cV\xa1f\xddb\xdd\x9f\x18\xa9\x10\xad(Aa\xc0\xb5E*\xcaL\xe5\x8c\x976\xda\xf0\\\xb3\xea[\r\xdb\xac>Z\x89hF"\xe4\xf4\\\xa5\xcc\xe0>D\xa8Y\xbd@\xf7<j\xee\xc9d\xce\xb5\xbcD\xca}1f\xcf$q\xdf]\xe8\x99\xcd\x0b\'\xb46\x11D\reO\x9f\xa5\xec\xc3\xbb4\xc4\xb1v\xd80\x9d6-\xdd\x10\x9f\xbcz\xf1\x0cS\x1c\x08\xa1\x1c\xa4\xe4\xfd\xff\x9a\x8a/\xfcm(a;\xad\xd4\xcdt\xabb\xd6[^\x1c\xf5\x06(y\xeb\x9f\xa6\x82\xc4\x18d\xac\t\xab\x19\xe9ue\x9a\xf2\xe9/\x99\x92wo\xf3\x0f\x06\x88D\xe4\xf8\x7fL\xd5\xc2\xa9r\xae"\xb8\xd3C4E\xf9\x0e\x0b\x10U\xdf|\xa8\t96v\xef\x902\xe5\x1a\x08\xf3\xec\x9dk\x88\xfb\n\\\x93\xdc\xaf\xb2\xcf\x9f\xd3\xd8\xef\x16">\x10A\x95mR\x8e\xcd\x07\xb7\x8dg\x13Ax\xe3\xe5\xcb\x97k\\r\xc0\xbb\xbcz\xc9\x17&\xab\xd7\x08\x93\xd1i\x80\xf41\xe9\x18\xbaB\x17\xb7\xf2\x85\xb0\x92\x0e\x85`\xa9\xfe~\xb6Y\xf7\xd8y\xa6z\xc1\xa7\xfe\x87\xde\xa6i\xc2\xbd\xe8\x1e\xc1\xdajS\xbd\xf0S\x93\xd9u\x90\xbc\xb6\xaa_a\xdch1\x8d%2\x11V\xbeFF\xb8\xe7u\x8f\xff\xce\xd4\x8a\xa6\x02\x94G\xb4\x07\xca\xe4\x85\x0fW\r\t%\xba\x0f5\x99\xb8\x15XM\xae\xa9r\xe5\xb3\xca\x99\xaf\x98\xf5O\x9e\xaf!k\x80\xfd\x81h-\x04\x07\xd4mB\x15\xc5\xa2\xd9\xcd2\xd9}\xfd\x84\x12\x08\x1a-\xb4\xa1{@\x9c\xf6L\xddf\xb3\xee\xd1\xf3L\xcd\x8a\xfap=D{\xe0<\xb5\xcc\xear\xb5\x97e\xf6\xdc\xc6d\xea}\xf55\xd9&\xcf5\xa2\xc2~\xfdS\x7f\xd0x\xf9\x16\xa2\xd0\x1eq\xc4\x11z\xde\x8e\xcd\x07\'\xb46\x11\x8c\xd6\x03\x07\x0e4\x9f\x7f\xfe\xb9\xc6\xd2\x02b\x92\x13\xc6%\xa3\xb0\x93\xfa\x06i\x92\x86\xcc\\yy\x89\x14\xbc\x0e%B\xa3R\xa6-\xb3\xdf\x10\x81\xf5\x1b/\xd3\xb2\x0f\x89bo\xbc\xf1F]\xdd"\xd0 \xfb\xef\x08c\xcc\xf4\x11!\x88\x8fU:\xe5e\xe5\xa8\x96\x86\xe1_\x136\xa0\x81\x88\x96\xc2*&S\xb4u\x8f\xff^\xa6o\xf5am\x08\xc9r\xd3M7i\xb6\x1a\xf6\xdfi\xb9\xa5\xabM\xe5\xac\xd7\xd5\xad \xa3s?\xaf\x1c=W\xca\x0b\x96\xeb\xc5k/\x9f\xf2\x90\'\xb0\x02S\xad#\x8f<R\x93Jp\xfd6\xdc\r\x9f\x13\xd3\x9d02\x99"\xb8\xb0\xd9\xa9\xfb\x86^\xbf\xbcp\xe3P\x01\xb7A\xd3u!\\k\x02\xc9Q\xc7\x8d\x1bg\xae\xbb\xee:u\x00%4\x8f\x9ek\xc9J\xd1\xb6\xde\xd4\x84\x176\xc3\x90\x96\x19<W\xf5\xf0\xaf\x89\xe6i\\\xff\xd4\x85\x1ac\xder\xf0\xc1\x07k\xd8\x1fg\xcf\xda\xfcpBk\x13\x82\xf6\xc2\x94\xe3\xe3\x8f?\x8eF\x1c\xd5\x84\x12_\xbe\xac\xf1\xa2\xd4\xd1R^\x91\x8a\x125R\xd7\xacY(\x82\xe2MS\xf2\xda\xb5\xf2\xba\xde\xd4\xca{@\x13"\xe6\x13\x9a\xc0A\x07\x1d\xa4\xe5~\xf6\xd9g\xd1\xed&h\x1bhO\x95_\xbd\xaa\xcb\xf78\x15p,R\xbaF\x93l\x10T\x90\xfc\x8a\xeb_\xb8\xcc\x94\xbdw\x87\x9e\x03 X\x11\x84\x94\x8b\r\x8e\xf0\xc6S\xa7N\xd5p\xcc@\x96!\x04"\xc2K\xe3\xdcs\xac\x8arW{\xe5\x8a\xd6T\xfe\xd9\xd3R\xee\x9fU\x10\xd4\x89\xa0\x01\x84*\x19\x8b\x08ML\xa8\x17\xea\x992eJ4\xb41\xdaM\xc5\xf4\x174{\x8e\x82v\'\x82\x9a\x98Wh\x7f\x953_6\xc5/_%S\xbf\x9b\xa3\x9b\x99\xd1~\xb6\xdaj+s\xd9e\x97\xe9\x14\x0e\xe1B\x998\xf2\x02Z\x1c\xd9\xae\x11^6\xd0\x1fA\x15\xeb\xcfu\xb6&o]\xff\xfc\x9fL\xd9\xe4\x07\xa3\xdf\x01\xae\x9d8]$\xedpl~\xb8\xd04?\x00\xcf?\xff\xbc\n\x86\x86"\x8d\x8aD2\x19\x05\xb8GDL-\x19l\xe2\x1e\x8f\r_L\x84QV\xb6\x88\xa5E@AB\xdf\x10~\x99\xa9\xd7\xc6\x90\x070\xd3\xa4\xe7\x17\x99\xba\xaaR\xe9\xa0\x1bGT@\xb0 \xfc(\x17a\x85\xe6F\xf4R\x04\x16{\'\x1b\x8eI/\xe5\x8aV\x98\x9e\'\xe5V\x16\xab\x00\x8b/\x17\x01Kxh\xa2\xac\xf27e\xe1\xfb\xc4\xb6&\x9bah#\xb8\x07\xed\xbb\xeb\x14\x1a\xff\xb3\xf8{\x80\xd0\xe3\x1c\x0f8\xe0\x00\xcdV\xc4 \x80\xc0\xe6\\\x89\\j\xc3\xe9\xc4\xc2\xb9f\xfb\x89E6H\xd9\xd8\x047n\xfahn\x08,\xfeul\x9e8\xa1\xf5\x03AGCKx\xff\xfd\xf7U8\x84\x81\x9cz\x08-\x9cU[s\x13/\xd9~(\x17ab\xb5\xaa\xd6\xc0\xda\x82Z\xd3\xa3\x9c{\x80\xd0\xc2w*\x18\xf9\xb4\xa5`sdJHDU48\xc7\xe6\x8b\x13Z? LeH~A\n+2\xf7`?j\x08\xa6)\x08\x13\x84[EEE\xabd\xe2A[#\xed\x95\xd5L\xb0_\xb5\x068c\xb2e\xc9n2n\x8d\xe6\x85\x90"\x8d\x18\x891\xb8~\xa6\x95\xad!\x08Y\xc4 \x9a*\xf7\x97\xe8\xa7L\xb5\x1d\x9b?Nhm\x06\xd0\xc9\x99\xe6\xa1}\x05c\xc7\x03\xb6+>{\xf7\xddwcb\xb5\x03\t0\xb2\xfb\x8c\xd2\x8d\xc3\x04\xb2cZE"\xd4\xaa\xc5\xd3\x8c\xf1\x13\xaa\x06\xd9q\xc7\x1d\xa3\xd34\x1c^Y\xc9|\xed\xb5\xd7b6s\x83\xae>v\x1b"\x7fx\xd9\x921\x82\x13S\x1e\xff\xb2 \x94C\x87\'\x842\x7f\xa3\xb1\x91\x85\xc8&V\r\xa2\x890\xfa\x8c\xd6\x0c\xce\xd1s]\xb7D\xce\xf5\x0b5\xde\xc7\xc3\xf4\x8cD\x18\x08h\xee\x01\x1a)e\xb3\x02\x1b\x84)o\x16\xf7\xa0\xa0\xc8h\x18ji\xcd\xb5k\x17\xe9\nbC\x9b\xb1\xc7\x8f\x1fov\xdeyg\xd5\x02\x87\x0e\x1d\xaa66\x97\xa8"\xb5pBk3\xe7\xad\xb7\xde\xd2\xb8\xf26\x134hr\x89\xb1?39\x83\xf7\xd4\xd8\\*\xb44~\x94\x08\x82\r"\xb4\x16~\xae\xc6\xeb\xf2\xcf\x9f\xf1\xf7\xf7y\xd0Y\xd1\xecX\xc5$\x1b\xce9\xe7\x9c\x13\x93\xe7\x8f\xce\x9f\xb7\xfd\x91&{\xf0\x1e&\xab\xdb`OhI\xeb@hU/\x9f\xa5^\xf7eS\x1e\xd6L6\x96m\xb6\xd9F3\xf6 \x10\x89\xd3\x8e\xc6\x12\x13\xd1\x82\xe4\x12r\xaeZf\xef\x11"\\\xba\xd4\x9f\xeb\xfa\xa5r\xae\x9f\x99\x8a/\xffg*\xa6=\xe7\x1f\xf7 \xcb\xcec\x8f=\xa6\xa9\xd2H\x06B\xe2\x8e`\x88\x18V\x05\xf3\xc7\x1e\xa3\xf1\xb3p\x1bAx\xd9\xdf\xd7\xae[\xacn!\xe5\xd3_4\x153^\xd0k\xb0`\xb3#\'ep[\x95#\xb5p\xab\x87\x9b1\xa4\x1e;\xed\xb4\xd3\xd4\xc0n!\x98^\x87\xa3\xaf3\x85{\xfe\xdad\x0f\x14\xcd%\xbf\xb3g`\xce\xce\xd3\x17\xfeN9r<g\xc8\x04\xd1\x96\xb66\xb5+\xe6z\xdbe\x84%K\x96\xe84\x94P+\x7f\xfb\xdb\xdfb\x84K\xde\x98\xa3M\xc7\x9f\xdd\xa8q\xeb3\xbb\r\x94\xb2\nLzV\xaeWnAg\x93\xdd{\x98\xc9\x1e\xb2\x8f\xc9\xea1L\xfd\xae\xec\xbe?4*\x92j`k\xa2\xcc`F \x02\xf5u<\xea\x06\x8d\xa8\x9a=p;\x93\x9e\xd3)\xee\\{\x9b\x9cA\xdb\x8b\xf0\xdd\xdbdv\x19\xa8\xab\x9au\xa5\x9e\x9d\n\xad\x92\xb2\xd0\x88\xc8:\x14L\x84\x913to\xd3\xf1\xe8\x1bL\xfe\xee\xa7\x98\xec~\xdbJ\xb9\x1d\xa5\xdc\x9c\xfar;\xf5\x91r\xc7z\xe5\x8apC\xe0\xb2\x7f\x12\xb8\x97\xa4s#\x8c2\x9a\xa1#\xf5p\x9a\xd6f\n\x8f\xe5\xcc3\xcf\xd4\xb4[\x96\xec\xadv3E\xc4j\xef?\xda4\x9b\xb0A\xfd\x92\xd2E\xdbx\xc5\xac\x7f\xea"S\xbdd\xba\x1e\xc7>\x84!\x9f|\x89\xd6.\x94\xbf\xe3\xb1\xa6\xc3Q\xd7\x8b\xe0\xe8k\xea**\x1a\x9cV)\xac@fe\x9b\xaa\x05\x9f\x99uO\x9c\x1f\x93\xbd\x06\x97\x03lnv\xf5\x92\xa8\xa2\x1d\x8f\x93s\xed\xb3m\x88s%TO\x9a)\x9f\xf6\x82Y\xf7\xd4\xff\x99\x9a\xe5\xde\xaa*\xe7\x8aF\xc4\xa2\x83]\x11\xcc\xd9\xf6@\xd3\xf1\xf8[LV\xf7\xad\xa5\xdcJ)\xb7^;\x8bGS\xb1\xa5\xcb\xf4{\xca\x13f\xfd\xb3\x17\x9b\x9a\x95\x9e@E\x10\xdew\xdf}\xaa\x15:R\x0f\xa7im\xa6\xbc\xfa\xea\xab\xe6\xdak\xafU\xe1\x02\x99\x9d\x07\x98\x8e\'\xfc\xdb\xe4l\xb5\x93i>\x11\x86 B"R\x17\x91)\xd9P\x93\x91W\xa4i\xb2\xd4\xa7J\x84!\x9a\x96\x1d\xab\xb2\xfal\'B\xe0\xdfj\xc7j>\xb9D\x9d\xda\xa32:\xf75\x99\x1d\xfb\xa8S\xa8\xd5\x8c0\x90[!\x88\x86Wt\xe2m&\xbb\xff\xf62\xb5L\xe4\\\xb7\x11\xad\xa9\xd0;\xd7\xea\n=G\x9b4\x16\x98^RnV\xaf\xe1\xe1\xca\xad\xad\x92Q9M\xb4\xb1\x91&--\xd3T~3Im}\x94\x87\xed\xf0\xf0\xc3\x0fW\x01\xeeH-\xdc\xfe\x84\xcd\x94\x97_~9\xc6\xe8\\\xb8\xd7\x99:5\xacC\xbb\xf0;q\xb3 \x0c\xaa\xaae\xeaw\x94)\xd8\xe5\x97\xfe\xc1z\xf0\x0e/\xdc\xf3\x0c\xdd\xf2\x13>\xb9\x84\x08.\xd1\x9c\x98\xa2\xe5\x8d=\xd6?\x18@\xb4\x98v\xe3\xcf1Y}\xc7\x88\x10l\xd8\x17\xaaA8W\xd1\xd2\xf2v<^4\xbf\xe3\xfd\x83\xf50\xfdk7\xe17&\xab\xa7hn\x08\xedP\xe5\xa6\xa9M/RSc\xf2\xc7M4y\xa3\x8f\xf4\x8f{.\'\xef\xbd\x17\x1b)\xc3\x91\x1a8\xa1\xb5\x19\x82\x1b\xc2\xb4i\xd3\xfcw\xa2\xb9t\x1fbr\xb7\xff\xa9:\x88&\x9c\xb0\x01C|v\x96\xc9\x19q\x80\xc9\xe8\xd4\xdf?\xe8\x91\xd1C\xca\x1dy\xa8\xae\xfc5\xab\xb5\x04a\xaa\x87\xaf\xd4\xb6\xfb\xeb\xb9\x05\xc9\xea\xb9\x8d\xc9\x1d}D\xe2e\x82\x9ckZN\xb6\x9c\xd3\xc1^\xba\xfd\x00h\x84\xb9\xdb\x1d\xea\x95\x19Vh\xfb\x10\xc40-?\xcf\xe4\xc9\xb5jFl\x8eI\x19h\xb3h\x88\x8e\xd4\xc2\t\xad\xcd\x10\x8c\xe5\x18\x8b-\x9a)\xba\xa0S\xe2\x02\xcb"\x1a\x0c+lt\xfc $v\xf5\x92K$Q.e\xcat-\xab\x7f\\\xc2\n2\x02Qf\xb2\xb1\xea)\xb7\xcf(9\xdfm\xfd\x03\x1e9C\xf71i\xb9I\xc6\xd5\x87\xaa\x1a\xcd6\x94\xd9}\xb0\x7f\xc0\xe8\x16%\'\xb4R\x0f\'\xb46C\xd8\x97h\xf7&Bv\xdf\xd1\xa2\x81\xe4\'\'\\\x84Hm\x8dhY=u\x85.\x08\xd1\x15X\xcdKX#\x12\xc8x\x93\xde\xaeh#\x8d\x88\x94c,\x02\x98$\x9d?\xf5\\\xbb\xf4\xd1\xc4\x17Q\xd2\xd2\xb5\\\xa2\xab&\xaaeY\x98&ft\x1d\xa8Y|,\xb8\x91\xb4\x86\xa3\xaec\xd3\xe2\x84\xd6f\x08\xfb\x08\x83\x890p\x9c\xd4h\x07\xc9"\x1d=Mf\x96*L\x02x\xe5\xdap0\tB\x99\xf2S"H\x04A#\xf4\xc2H\'\'\\\xa2\xe7\x8a0\r\x90^H\xb94\xd7\x16\x96\x9b\xd3\xce?`t\x17@kn1rl\x1a\x9c\xd0\xda\x0ca\xf3rL2\x05\xd5.\xec\xab\x05h9\x01T\xc3ji\x99\xfe\xbf>\xde\xf4\xad\x15\xca\x0c\x16\x11\xb5\x8f\xc9\xc1\x16\x16\x1d\xbc\x07YY-\x18\x08\x1c?\x18Nhm\x86\x10(\x8f\xbd\x81\x16bNy\x19q\x92|\\2\xbd\x8aTT\x9b\xba\n\xcf\xc1\xd2\xa2\xe5j\xf4O\x82\xd7$\x08eV\xd5J\xb9^\x88\x1aK\xcd\x9aE\xfe\xb9&Q&\x88\xfa\x16\xa9\xa8\x8a=W\xd1\x86j\xd7p\xae2=F\x80%\x83\x94[W^\xa1\xf1\xb3,D\x8a\xc0\x17\xcc\x91Z8\xa1\xb5\x19\x82Cep\x9bI\xe5\xfc\x8f\r\xb1\xac\x92\xcd2\xc3T\xabf\xe5BS\xb3\xa2\xde[\x1d\xaa\xe6\x7fdH\xed\x95L\xb9\x04\xe8\xab]\xb34\xea\xb0i\xa9\xe6\\\xab+[p\xaeYr\x9e\xdf\xc5e\xef\x89\x98J\x82\x1f\xb2\xba\xa8S\xc4\xc4\xd1r\x97\xcf15k\xbd\x98d@\xf8k\xa7m\xa5\x1eNhm\x86l\xbb\xed\xb6\xba\x99\xd7R9\xfb\r\xe9\xc8s\xa5\xe7\x89\x96\x91\x8cR\x94\x95n\xaa\x17|b\xaa\xbf\xfb\xc4?\xe2\xa1\x99v\x88\xd9E\x14\xcf\x04I\xcb\xce\xd0,;\xf1eV\xcczM\x93V$}\xae\xd9\xe9"\xa0>\xf46<\x07\xa8\xf8\xea\x15\xd5\xe2<M+\x89\x82\xe5\x1e\x90\x05)\x98\xb8\x83\r\xd9\xf9\xf9\xf9\xfe;G\xaa\xe0\x84\xd6f\x08y\x12\x89\xf4i\xa9+[gJ?\xba_4\x98r\x91/\x89i\x06l\x91\xa9Y\xb5\xc8\x94}\xf2H4\x92\xa8\xa5F\xa6\\e\x9f>\xe1\xb9R$\xa0\x19\xa1\xb5\x90\xf5\x87\x8c8D\x01\rRW\xbc\xca\x94q\xae\xf8\x87a\xf9N\x00=\xd7\xef\xbf\xf3\xb3\xff\xc4N;kE`\x95}\xfc\x80g\x92JP\xdbb;O\xcd\xd29^\xf6\x9f*o\x838~d\xec?\x8c\xb1\x1d:R\x02\'\xb46S\x0e=\xf4P\x8d\xf5d)\x17\xa1S>\xedY\xef\x8d\xae\xce\x85@\xa6\x85\x91\xdaJ\x11"\x0f\x9a\x8a\x99\xaf\xf8\x07\x83DL\xc9\xdb\xb7z\xdb[\x10\x86a\x04\x17u\xa7e\x88`y\xda\x94}x\xaf\x7f0\x96\xb2)R\xdf\xf4\x17\xbc\xf2B\tC\xd1\x9c2s\x0c\x19\xb2K?\xb8WC$7D\xe9\x87\xf7\x98\xca\x99\xaf\xea\x1e\xc8\xb0\xe5\xb2\xba\xc9\xd4\xbat\xd2\x7fM\xd5\xb7\x1f\xfa\xc7\xbd8\xf8\x84\x96v\xa4\x1en\xef\xe1f\n\x914\x89\xc2`\xb7\x9a\x90\x11\x870.\x19\xed{\x98\xac\x9e\xc3\xa53\xe2\x12 \x9d=~E\x90\xe9\x93tju\x19\x10\xad\xa2\xec\xa3\xfb\xcc\xfa\xe7/S-\r\x88\xf8I\xf0?\xf64\xe2\xa3\xa4\x19q\x16OW?\xa8\x8c\xa2\xde\x9e&\x17]\xad\x0c B"-\x83P5\xb5\x1a\xf2F\x13A\x94z\xd1#\xd8\x80L\x998j\xb2a\x9a-A\xd5\x9ck\xc7\xde&\xbb\xc7P\xefw\r\xad\xfc\xe9\xb9f\xa9\xe6F\xb6\xe9\xb2\xf7\xef4\x1b^\xfa\xab\xfe\x1e\x88\xc2\x80\xe0\xc6\x05D\xb3\x02\x89\xf0a\xda\x98\xd1\xa9\x9f\xc9\xea>D\xedjJ\x03\xe5jR\x0c\x84\xb6h\x97\x08\xe6\xe27n\xf4\x17\x08\x8cFh%!\xc8\xa8Q\xa3\xf4\xbd#\xb5pBk3\x85\xe9\x0b\x9d\x8a8\xf26\xa2)\xe1U*\xbf~K\x8d\xe7\x19]\xb7\x16\xa5\'[\xa6>y*\xc0\xbcN*/\xf9\x8f\x8d\xd1\xa4\xd8\xda\xf0\xd2\xdfL\xf1\xeb7D\xa7D\x84\x8f\xf9\xcdo~c\xae\xbc\xf2J3}\xfat\xdd.\x04\x04\xf7#cuzn\x07\x93\xd9\xa9\xbfW\x8eL\xa9\xb4L}\x89fS[%S\xbf\xefM)\x82\xe5\xe9\x8b4\xe3\r0\xbd"\xde\xd7?\xff\xf9O\r}c\xe3\xde\x93,\x83\xfc\x83\xacN\xb2\x19[\xb3\x015t\xae\xd5ejg\xda\xf0\xbf\xbf\x98\x927\xfe\x1e#\\\xff\xf0\x87?\xe8\xa6q\xe2\xd5\xdb\x907\xd4[5\xfbm\x15L\x99]\x07JY\xdc\x039\xd7`\xb9\xc8G\xb9f\xb2Eox\xfe\xcf\xa6\xf4\xdd\xdb\xa4\xdcJ\xfd=\x02\xf6\xc2\x0b/\xd4\xf8\\nj\x98\x9a8\xa1\xb5\x19\x83\x91\x98\xa8\x9a\xc4\xab\xb2\x11M\xd1BH\xdbNN\xc1\xbar\xe2\xb9\x8b\xb6"\x1aHm\xc9\n\x8dZZ\xbdp\x9a)\x99t\xbb\xd9\xf0\xec\xa5\xa6\x92d\xb0\xea\xd2 \x0f:#C\x13\xc6\x12\xf8\x0f\xad\xa8[\xb7n1\x11FI\x11F0\xbe\xaao\xc9\xcbX\'\xff\xab\xd1d\x15\xa4\xd5\xaa]\xf9\x8d)\xff\xf4IS\xfc\xe2_L\xe9d\xcf\xb6\x066\xfa\xe7\xf9\xe7\x9f\xaf\t&\x88\x86\xca\x9eIb\xb7\xe3\xb4\xc9\xf7*\xe7\xbek*\xbfzM\xedr\xe0e\x1aZ\xe9EX]\xf0\xa9)}\xe76\xb3\xe1\xb9?j*5\xbbM\x89s%\xc3\xce\xd9g\x9f\xadA\x00\xc9`D\xea5v\t\xb0g\x10\xad\x0c\x81X5K\x84\xa2\x9c#\xa0QaO\xd3\xc0\x82\xdf}"\xda\xd5?U`U\xcd\xff8Z.\x03\xc1\xc9\'\x9f\xac\xf1\xb9\x82.%\x8e\xd4\xc2\xc5\xd3J\x01\x10Zh\x07\xef\xbcS\x1f\xbf*\x88j\x18y\x1dD\x13\xdb \x9a\x8d7\x05\x8a\x07\x01H\xe7G\x83A\xb8 \x0c\x89S\xf5\xf4\xd3Ok\xfc\xf9\x862\xd8\xa4\x93\x11\xa7\xb2D\xa7e\r\x81\xbb\x00e\xe2\xefTUU\xa5q\xdc\xedFdB\xca4\xe4m\xae\x9aQ^{\xd5\x1a\x83QU\x83\x10.f\xc0\x80\x01\xaa\x19\xb2(\x81`\xe4\xfc\x9ey\xe6\x19\x8d^J]\xf10\x15L\xcb\x95rE\xc3kh\xbb\x13\xd7}\xd2I\'i\xdeE\xe2\xd8;R\x17\'\xb4R\x04"w\x92\x94\x94\x8ek\x93\xbd\xb6\x06h2v;Kp\xebPK\xc1n\x84}\x0b\xed\xa6\xb5\xb6\xca\xe0tKsEh\x11&:l\xd3\xc5\x85\x04\r\x0b-\x13\xe1\xe5Hm\x9c\xd0J1\x88\xc3\xfe\xf0\xc3\x0fk(\xe6\xd9\xb3g\xb7\x8a\xa0a:FnB^\x08\x06\xcan\r\x10XL!)\x136Jv!\x9f\'\xda\xfc8W\xb4/2\xe90\xc5\xc5\x86\x16\x8cso!\x87#\xc2j\xf4\xe8\xd1j\xbfrF\xf7\x1f\x0fNh\xa5(3f\xcc\xd0\xac\xd2\x84\xb0\xc1\xa0L\xf2\x87\x86\x84\rF\xea\xac\xbe\xa3MfQ_\x8d\xcc \xf33SW\xb2\xc2T/\xfc\\S\xe8\x07!\xe1\x05\xb9\xff\xc8\xfb\xc7\xd4\x91\xe9\x1fI \x10\x8e\xf1\xa4\xe5\x14\x9a\xec~c4q\x85Wn\xba\xa9\xdb\xb0\\W8\xe3\xa7\x93\xac\x84\xee\xba\xeb\xae\xeab\x80\xf6\x85\xa6\xf4\xd0C\x0f\xa9\x9d.\xbe\xf9\x11\x89\x82@\x7f&;\xcf\xe8\x82cU\xb1\xa9^\xfaU4\xbb\xb6\x05\r\x914\xfb\xf8\xb3\x11O>\xa8\xcd\xb1\xea8|\xf8pM\xb6\xc1T\xd8\xf1\xe3\xc2\t\xad\x1f\x01h\x1b\xc7\x1e{\xac\x1a\xd6-\xd8\xb8\xf2\xc7\x1emr\x86\xed\xab\xb1\xa92:\xf4\x16\t\xe0\x0b\x97\x92\xd5"\x08fh\x8a{\x1c9\xad\x91\x1c\xd8\xda\xf2\xc0\x03\x0f\xa8!\x9c\xd4e\xc7\x1f\x7f\xbc\xc6\xf7\xb2\x90\xe4"o\x87cL\xee\xd0\xbd\xb5\xdc\xf4\xf6=\xd4h\xaf\xe5\x16\xaf4UK\xbe0\x953_S\xa7\xd5`\xaayR\x8d\xa1!n\xbf\xfd\xf6\xe6\xd9g\x9f5g\x9duVL\xba4\xca"\xb9\x06\x19\x86\x88y\x85\xa3\xa9H45\xbaW\x7f?G}\xac\xca>~0f\xdb\x10\xb6\xa9\xbb\xee\xba\xcb\xe5+\xdc\xc2pB+\xc5\xc1\x15\xe0\x94SN\xd1\xbc\x88\x96L\xd1T\xda\x1ft\x89\xc9\x1by\xb0Io\xd7\xc1D\xaa\xe5\x11\xd7a\xf4N\xf3\xbe\x80\xcfU\x16\xc2\xab\xc4T|\xfd\x86)y\xf5zS\x19p\xbc$\x17\xe0o\x7f\xfb[s\xf7\xddw\x9b\xb7\xdf~\xdb?*\x82\xa5\xef\xf6\xa6\xfd\xc1\x97j\xf0\xc0\xf4\x82B)\xd7[e\xac/7S\xcaM\x13\xe1\xb5A\x9dY\x8b_\xbb\xdeT-\x98\xea}&\xb0m\x86d\x12\xb8G\x04\x05l\xdev\x87\x98v\x07\xff\xd9d\xf7\xdfA\xe6\x7fR\x161\xael\xb3d\x8bQV\x861\xb5Fc\xc7\x17\xbf~\xa3\xa9\x98\xfe\xa2\xf7\x99\x80&\xf5\xc4\x13Ohz4\xc7\x96\x81\x13Z)\xce_\xff\xfaWM\xafo\xa7G\xe4A$\x0bN\xee\xb0=ENI\xe7od5Q\xc9 \x9dW\xa6\xa9\x9a7\xd5\xac{\xf2\x02\x15\n\x166l\xe3\x80j#{f\x89@):\xfe_\x9aX\xa3N\xa6x\r%X\xb5\xe8J\x9e\x94[9\xfb\x03\xb3\xee\xa9\x0b4\x01\x06`\xdfb\x15\x13;\x9c]\xad\xcc\x1b}\x84\xe9p\xf4\r&\xb3\xc7V\xa2\x995\x91]\x07A\x9b\x93cj\x96~-e^h*\xbex\xde\xff\xc0\x98\x89\x13\'\x9a\x9bn\xbaI3\x029~\xfc\xb8m<)\x0c\xd3\xb7\xfb\xef\xbf?*\xb0\xd2\x0b\xbb\x98\xf6\x87_\xe9\t,\xdc\x02\x9a\x12X\x80\xc3\xa8\x08\xa5\xec\x81;\x98\xf6\x87]\x1e\x13\xd9\x14\x9b\x96\x15X\xe9\x1d{\x9a\x8eG\\\xe5\t,\x92U4!\xb0\x00\xcf\xf3\xba\x8aJ\x93=t7\xd1\xcc\xfe\xac\x9e\xf6\xc0y"\x08\xad\xc0"\xbe|\xbbC.7Y\xddD`\xb1\xa0\xd0\x98\xc0\x02\xf9,"\xe7\x93\xd9c\xa8h\x91\x97jHf\x0bI]\t\x9d\xec\xd82pB+\x85\x994iR\x8c\xbd\xa9`\xd7_\x8a\xc0\xda\xc7\xd3\xb0t\xda\x16\x82H\x9df\xf8\xc1\x96T\xb8\xcfoDM\xf2\xa7z\x01\nw?\xcdd\x0f\xde]\xca\x15!\x18643BF\x04\'\xc9/\n\xf7<S\x0el\\n\x81\x94\x9b\xd5s\x98\x97ah\xa3\xbd8\r u\xe3\xd9NV\xa2\xfc]O\x92\x03^\x99\xac\x1er/l\xceE\xc7\x8f\x1b\'\xb4R\x144\xa1\xc9\x93\'\xfb\xef\xe4A\xb6\xefn\xf2\xc6\xfcT\x93?4\xaba\xc5\x83\x86#\xc2*g\xc8x\x99^\xc6&\xbf`\x9f_\x1e\x99\x800\x8c\xfb\xde\xf5\xa1\xe1\xfb\x19R\xee\xf0}EC\x8a\xcd\xda\x93!Z]\xdev\x87\xaa\xb3)\xfb\x19C\xa3\xe7J\x02\r9\xd7\xbe\xf5\xda\xd6G\x1f}\x14\x931\xdb\xf1\xe3\xc5\t\xad\x14\x05gS\xf6\xe4Yr\x06\x8d\x93iX?\xafS\'CM\xb5\xc9\xe8\xdc_\xa6\x80\xe3\xfc\x03\x1e9\x83\xf70\x19\x1d\xfc\x15\xc2d\x10\xed\x87\xe4\xad9\xa2\x1d\x05\xc9\x15A\x96\xde\xaekr\xe5\xca\xf43\xb3\xdb`\x93\xbd\xd5\xae\xfe\x01\xa3\xee\x1e\xf1~`\x8e\x1f\'Nh\xa5(lg!\x9b\x8c\x85\x14a$\x95\xf0\xc2\'\'\x8ef\xd7)\xech2\xbb\xd7\x07\x1f\x044/\xdd\x1e\x93\xa40\xd4r;t6\x19]\xeb\xc3\xec\x80f\x18\xca.0\xc9\xa4\x04\xe3\\\xd2\x0b\xda\xe9\xe6n\x0b[\x91\\:\xb0-\x03\'\xb4R\x14\xec8\xeb\xd7\xd7;\x87\xa6\xe7w0DR\x88\xba\n$\x8a\xfc\x0e\xef\x82\x8d2\xf6\xe4w\xf4\xa7p-(7\x83r\xe3\xb2\xf6\xe4\x17\xc9\xf1\xcc\xe4\xca\xf5\xcf\x95\x14\xfa\x16\xc2\xec\x90\xee\xdf\xf1\xe3\xc7\t\xad\x14\x05/x\xf6\xf7E\xb1\xd9jZ\x02v\xedx!\xd2\x1a\xe5\xf2\xf3\xb8rUs\xd3c-(;N\xfb\xc3\xa5\xc2\xf1\xe3\xc7=\xe5\x14\x85}\x82]\xbbv\xf5\xdf\x89\xa6\xb1n\xa9\xa9\xab(\x11\r$\xc9G*\xaaK\xa4\xaa\xc6\xd4\x96\xad\xf1\x0fx\xd4\x90\xb1\xa7\xaa\xcc\xa4\xa1\xda$\x83_\xae\x17F\xa7\x1e-\xb7F4\xa3d\xca\xa5\xcc\xeaZS\x1b\xc8\xac\x83\x00\'*\x84\xe3\xc7\x8f\x13Z)\n\x9b\x86\x83!V\xaa\x17~j\xeaJV\x19"\x81&\x03\xe1m\xea\xd6\xaf2\xd5K\xea=\xd5\x81\xc4\x15ue2\re*\x97\x04\x94[\xbbf\x99\xa9^6\xcb?\xe2\xa1Y{*\x8aE\xfe$^.\xd3\xca\xda\xf5+t{\x8f\x85x^.F\xd6\x96\x81\x13Z)\n{\x04\xc7\x8c\x19\xe3\xbf3\xa6\xea\xbb\xa9\xa6z\xd1\xe7\xdel\xab\x01_\xabf\xc9\xca\x10!0\xdbT\xcez\xdd?\xe0Q\xf9\xed\x07\xa6f\xc9\x8c\x96\x95\xbbd\xba\xa9\x9a;\xc9?\xe0Af\x9c\xda\xf5\xcb\xa4L\x9a`b\xe5\xa6e\x89\xd0Z\xf5\xad\xa9\x92s\xb3\xb0\xa7\x91\xa8\x0f\x8e\x1f?Nh\xa5(\xc4\x85b\x8f\xa0\x85(\xa1D\x15\xad\xdd\xb0\xdc3\xc8\'\x00\xdf\xaf\xdb\xb0J7$\xab\xb6\x16@\x93B|t\x9fN\xef\xbcX\xef\xe1\xc1\xa8_\xb7v\xb9\x94\xfbP\xcc\xa6l\xa8+]c\xca>yT\xce\xbbL\xb4\xb80I*<T#\xac(5\xe53^6\xb5k\x17\xf9G\x8dF\x91p\xdbx\xb6\x0c\x9c\xd0Ja\xf6\xdak/3n\\\xbd_\x15\x99j\xca&? \x82\xa0\xc2\x90\xdd&\x14$\xc0\x88\xd4\x99\xf2\xcf\x9f\x13\xe1\xf2\xb0\x7f0\x96\xf2/\x9e3\xe5S\x1e\xf1\xa2\xa2\xf2\xfd0\xf0\xbd\xda\x1aS6\xf5q)\xfbi\xff`,\xa5\xef\xdda*\xc8\xae\x83\xb6\x15f\x9a\xc8w\xd23L\xc5\x17\xff3\xa5\xef\xfc\xcb?h4<\xcd\xf8\xf1\xe3\x9d!~\x0b\xc1\xc5\x88Oal$\xcf\x97_~\xd9\xdb\x7f(\xc2\xa7z\xc1T\xf5\x7fR\xbf\xad\x9cB\x7fF\x17\xbfB\'\x07\x89\xc8\x80`\xab\xa90\xe5\xd3\xbc\xec:\x91rO\x1b"\x8e\x16\xf1\xa8\xd8\x16\xa3\xbeOu\xb5\x1a\xcf\x1d\xf7\x87\xac^\xdb\x98t)\xdf\x9b\xd1\xc5\x95+\x95ao\xd2,8U\xe5"\xb0\x1e1\x1b\x9e\xb9$\x1a\xa2\x06C9\xa1\x93\xd90ML-R\x86UK\xb9Y=\xb71\x99\x9d\x07\xe8\xef\xb4\xcc\xf8\x15L6K\xab;G\xad\xc6\xb1_\xff\xe4\x1f4\x19\x87\xe5\xf7\xbf\xff\xbd9\xe2\x88#\xa4\xfa$\xa6\xaf\x8e\x94\xc3\t\xad\x14\x87\xe8\x9cl_\xb1\x1b\x86\xd1\xb2\xaa\xe6\xbck\xea\x8aW\x98\xcc.\x83t\xfbM:\xd9j\xb2stj\xa5\xd9jD\x08\xb0"X\xbbj\xbe)~\xe3\xef\xa6\xf8\x7f\x7f\xd1\xc4\x16\x16\xc2\xc7\x10\x96\x86\xcd\xcd$\x94@ j2\x89\xaf\xdf6\x91\xd2\xb5^v\x1d\x99\xfay\xe5\x06\xb2\xe0\x10`P\xa6\x935+\xbe1%\xaf^gJ^\xb9F\xa6r^\x82X"\x8e\x9e~\xfa\xe9\xe6\xe6\x9bo\xd6,@\x04\x16D\xe0j\xd6\x9e9\xef\xa8P\xca\xecL& "DH\xb9\x94\xc7K\xca\xc6\x03\x9e\xeb)\x93\xe9\xef\x86\'/0\xb5\xeb\x97j\x99p\xc0\x01\x07\x98\x8b.\xbaH\xe3\xd4;\xb6\x0c\\h\x9a\x1f\x01\x8b\x17/\xd6\xa0z/\xbc\xf0\x82\x7f\xc4\x83\xbc\x83y\xdb\x1fir\x87\xefc\xd2;\xf6\x11\xa1\x92.z\x8c\x08\n\xd1R*f\xbfm*>{\xc2\xd4\xac\xf6\xd2\x88\x01\x9a\x101\xaf\x18\xc7\x88^\xca6\xa1\xdf\xfd\xeew\xfa\xaf\x8d$\x01\x08\x97\xdc\xed\x7fjr\x87N\x90r{\x88\xd2%B\xd0\xd4\x99\xbauK\xbd\xc0\x82\x9f=ej\xd7-\xf1\xbf\xed\x95\xcbT\x96,8, \x10\xfb\xeb\xd2K/\xd5\xf3\x8e6?\xd1\x92\xb2\xfa\x8d5\x05;\x1e/\xff\x8e1\xe9\x05E\xa28\x92\x97\xb1D3\xea\xa0\rV\xcd\x9b"_\xac?\x8f\x1dv\xd8\xc1\xfc\xeb_\xff2;\xed\x14\xbbE\xc8\xf1\xe3\xc6\t\xad\x1f\t\x84]\xbe\xe4\x92K4\xec2\xde\xe1\r\x91\x9e\xd7\xd1\xd4\x89\xc6\xd4Ph\x19\x04K\x9f>}4\xf32S\xc2Y\xb3fiF\x1d\xfe&\x91FS\xde\xe6\xe9yERn\xf1F\x1b\xaa\xedt\r\x7f\xb2}\xf6\xd9G\xb7\xda\xa0eQ\x17\xc94\x08\x93\xdcP\x16 P\xa1U-SH\xce\xb7\x01v\xdbm7s\xcd5\xd7\x98\xddw\xdf\xdd?\xe2\xd8RpB\xebG\x04\xd3\xb9[n\xb9\xc5<\xf8\xe0\x83*t\xc2\x82\x10\xe1\x85-\x8b\xdc\x82\xad\x85Ml\xd1\x98`J\x06\x12V\x1cr\xc8!\xaa\xa9\x91}\xda\xb1\xe5\xe1\x84\xd6\x8f\x10\xec[$\x8e\x982e\x8a\xc6\x8fG\xab\x89\x07#>I[\xb1-!T\xd0\xaa\x12\xa5\xa1l:={\xf6\xdch_dK\xa1\x1eb\xcc\x93Q\x07\x83\xfb1\xc7\x1c\x13\xd5\xe2\x1c[\x1eNh\xfd\x88\xf9\xe6\x9bo4d\x0b\x81\x02\x83\tN\xd1\xa8\x10Z\xac:\x12\x03\x9e\x88\x11A2{\x0c\xd3\x15=\xdd<-\xcd\x83\xac=8\x88\xd6\xae]\xec\x7f\xc3\x03\xc1A\x06\x9f\x9f\xfd\xecg\x9a\xd2\x8b\xa6\xf4\xd2K/\x99\xaf\xbf\xfeZ\xa7\x82AH\x88\x91=`\xacI/$\x1c\r\x9aW\x9a\xfaY\x11C^]4\xe2\xc0\x07\xed\xb0\xc3\x0e\xd3\xbf\x11\x84\xb85\x90]\xc7\xb958\x9c\xd0\xdaB\xb9\xea\xaa\xab\xcc\x9f\xff\xfc\xe7\x98\xa9[\xf6\xc0\x9dL\xfe\xd8cL\xd6V\xbb\x9a\xcc\xce\x03uE\x0f\xa1\x85\xcbB\xf5\n\x11|\xdf~`J?z@\xbd\xd1-$\x96`E\x90t^d\xf19\xf7\xdcsc\xb4\xac\x8cN}M\xc1\xce?7\xd9[\xef\xae\xa1\x92\xd3\xf3;\x89\xd0\xf2\x8c\xe9\xb8-\x90\x15\x88U\xc9\xf2O\x9fP\x87S\x0b\xab\xa2\xf7\xdcs\x8f\n*\x87#\x88\x13Z[ \x08\x83\xb3\xcf>;\x9a\xe8\x95\xfd\x7f\x05{\x9ea\n\xf7:\xd3d\xf6\xdaV\xd4"9H\xc8f\xeb\x87\x85\xf3gV\x86\x89\xd4\xd4\x99\xaa\xb9\xef\x99\x927\xffa\xca\xa7=\xeb}&\xa0\t\x91j\x8c\x14\xfb\xdf}\xf7\x9d\x7f\xd4\x98\xbcQ\x87\x9b\xc2}\x7fg\xb2\x07\xedb\xd2ssL\xa4J\x04\xa4F)\xf5\xa7v\xea*\x81w|\x89:\x99\x16\xbfz\xad\xa9\xfa\xee\x13\xef3a\x9bm\xb6\xd1\x8c\xda\xa4\xdbw8,Nhma\x10\xf1\xf4\xa7?\xfd\xa9\xf9\xf8\xe3\x8f\xbd\x03\xe9\x19\xa6p\xc2o4YDz\xbbN\xa2U\xc9T\xad\xb1\xc0|8\xa4fg\x9b\xda\x15\xf3\xcd\xbag\xffh\xca?\xa9\xf7\xa0\xb76&\xdb\x9c\x88W\xdf\xfe\xb0\xbf\x98\x8c.\xfdDX5\x91eGP\xdf\xacL\xb2\x02M1\xeb\x9e\xfe?\xd5\xbc,\xac\x88\xe2*\xe1\xd2\xd9;,\xce@\xb0\x85A\x8e@2S[r\xb7\xf9\x89i\xb7\xff\x05\x1a\x94/RQ\xd6\xb8\xc0\x02\xfc\xa6*\xcbMf\xb7\x81\xa6\xfd\x01\x17\xaa\x06eAXY\x81\x95;t\xbc\'\xb0:\x89\xc0\xa2\xcc&\x04\x16h\xf6\x9e\xaa\n)o\'\xd3\xfe\xc0K4\x94\xb2\x85d\xac\xd8\xe6\x1c\x0e\x8b\x13Z[\x10\xf8\\ax\xb7Yk0\xb4\x17\xeeu\x96\xc9h\xd7M\xb7\xd4\x84B\x04\x13i\xc4\xb2\xfb\x8f2\x05;\x9e\xa0\x9aZ\x90\xb4\x9c\x02S\xb0\xcfoMFQ\x1f\xc3&\xee\xd0\xd4\xd5I\xb9\x95&w\xdb}L\xfe.?Gu\xd3\xc3\x84\x94~\xe5\x95WZ\xd5m\xc2\x91\xda8\xa1\xb5\x05\xc1\x96\x9c\xa0\xff\x16I+0\xbe\xaba<\x11+\x81hc(d\xd9\xc3\xf6\x16\xe1\x15k(\xcf\x1e\xb8\xb3\xc9\x1e\xb0\xb3~\'\xa12!R+?I\x13Mm\x9f\x98X\xf5o\xbe\xf9\xe6F+\x9c\x8e-\x17\'\xb4\xb6 \xd86\x13\xccX\x93;|?\xd1\x8cpUH\\\x8b\xc1[=\xab\xeb \x93\xd5{\x84\x7f\xc4#g\xd8\xbe&=\xb7\x9d\xc8\xac$5#\xca\x952q\xb9\xb0 h\xf1\xfdr8\xc0\t\xad-\x08\x04VPc!\xf7\xa0F$MT#\x02\x11Ji\xf9\xf9\x9a\xd5:Hf\xd7\x01^X\x9ad\xca\x144\xd3N\xbb\x0e\xd1\xac\xd4\xc0\x14\xd1%buX\x9c\xd0\xda\x82\xc0\xa6\x15\xb4\r\x11\x01\xc2\x8b\xfd\x9e\x8c\x80\x91\xdf\xf0S\xa20\x04H\xcf\xcaoA\x99\xe0\x95\x9bNrX\x1f\xf6=\x067l;\xb6l\x9c\xd0\xda\x82 \xb2g0\x83\x0faa\x92\x9e\xc6\x01?\x8d\xf3f\xaf+\xa5L|\xbc\x92\xdcf\x83\x01^\xe4S\xad\x9c\x9b\x05o{B\xdb8\x1c\xe0\x84\xd6\x16\x04\x9b\x8d\x83!\x89\xab\x17\x7faLM\xa5\xc8\x89$\x04Bz\x96\xa9]\xbff\xa3\xad=Zfu\xb9I:+\x10\xe5\xaeYnj\xd7\xd5\xc7\xcc\xea\xdd\xbb\xb7n\xe8v8\xc0\t\xad-\x08\xa2\x91\xf6\xef_\x9f\x95\xb9\xe2\xab\xd7M]E\xb1\xb4\x82\xc4\x85Vzv\x96\xa9\xf9~\xb6\xa9Z\xf8\xa9\x7f\xc4\x83xZ\xc4\x957\xc9\x08B!=\'S\xbd\xe2\xab\xbe#v\x96\x07\xfb\x0e\xf3\xf3\xf3\xfdw\x8e-\x1d\'\xb4\xb6 \x88\xea@\xb4\x04K\xf5\xb2\xaf\xbc\xf8\xed\xac\x1e&\xa0\x19\xa5\x896\x14\xa9,3\x15\xd3_05+\xeb\xf7!B\xf5\xf2\xd9\xa6\xec\xd3\'\xfd2\x13\x13\\d\xb2\xae+]o\xca\xbfx\xde\xd4\x15\xd7\xafr\x1et\xd0A:Et8\xc0\t\xad-\x08"$L\x980As&*\xb5\xd5\xa6\xe4\xed\x7f\x9a\xea\xa53\xe5\xc3,\xa4\x91w\xbc)\xa4\x8c\xb4\xac,S\xfe\xd5\x1b\xa6\xe4\xbd;u\x151\x86\xba\x1aS\xfc\xda\xf5\xa6\xf2\xdb\xc9^\x99a\x85!\xab\x98\xf2\xdd\xb2\x8f\x1f5\xe5S\x1f\xf3\x0f\x1a\x8d)O\xc0?\x17\xdd\xc1aq-a\x0b\x8302\x84>\xb6\xd4|?\xd7\xac\x7f\xf2\x02\xf9\xf7ko\x033\xab\x81\r\t/9\x86&D\x1a\xb1\x8a9\x93\xcc\xfa\xa7/\x8aI7F\xc6kk,\'\xd4\xf2\xfa\xa7.\xd0$\x1b\xba_Q~\xd7\xb0\xf0J\x93\xe36i\x851eS\x1e5\x1b\x9e\xff\xb37e\xf5\xf9\xedo\x7f\xab\x89X\x1d\x0e\x8b\x13Z[\x18\x05\x05\x05\xe6\x82\x0b.\x88\x11\x04\x15\xb3\xdf4k\xef;E\x13\xb5j\x1eB\x04Tv\x9e\xe7\x12\xe1\xff\x0buekL\xe9\x87\xf7\x985\xf7N452\r\x046J\x13\xa2\xf9\xde{\xef5\xbb\xecR\xbf\x17\x11\x9b\xd4\x9a\xbbN4\xe5\x9a\xf3p\x8d\x08\xa5:\xdd6\xa4I+\xb4\\\x92W\x880\x13M\xadv\xc32S\xf2\xc6Mf\xdd#g\x99\xda\xe2\x15~\t\x9e\x80=\xea\xa8\xa3\x9c\x96\xe5\x88\xc1Ey\xd8B\xb9\xef\xbe\xfb\xcc\xf9\xe7\x9f\x1f\x13^\x19O\xf6\x9cm~b\xf2\xc6\xfeL\xb7\xd1\xa4\xe7\x14\xa8P\xa9\xab,6\xd5\xf3\xbc\xe4\x12\x95s\xdf7\x9a\xffP@`\x11\x96\xe6\xa6\x9bn2{\xef\xbd\xb7y\xe7\x9dw\xcc\xc5\x17_\xac\xe1i\xac_\x15\x82)\xab\xffX\x937\xe6g&g\xd0\xae&-\xbfH\xbd\x1ap\xb5 \xc1\x06\x99\xa6I\x84\x81}-8\xd5D\x1b\xfc\xf7\xbf\xff\xad\xe1i\x1c\x8e Nhm\xc1\xfc\xe7?\xff1W\\q\x85Y\xbe|\xb9\x7f$\x80h[\x19\x1dzj\x00@\x9d\xae5\x10\xfd\x81\xe9 \xd9uz\xf4\xe8\xa1\xc940\xf4\xe3q\xff\xfa\xeb\xaf\xab\x07\xfbFM\x0b\rN\xa6\x82\xe9\xf9\x1d4\xe3t\xa4\xa6R\xca\xdd\xb8\xf9aw\xbb\xf1\xc6\x1b\xcd\xe8\xd1\xa3\xfd#\x0eG=Nhm\xe1<\xff\xfc\xf3\xe6\xca+\xaf\xd4\xcd\xd4\xad\x19I\x81)]\xa2^\xec\x08@B,_x\xe1\x85\x1a\x11\xd5\xe1h\x08\'\xb4\x1c\x9a\xca\x8b\xe9"ak\x88\'\xcf\xfb\xd6\xc0\x06\x06$\x91*\x7f7\x94\xe9\xa7}\xfb\xf6\x9ac\x91i\xe0\xc9\'\x9fl\xf6\xddw_\xff\x13\x87\xa3a\x9c\xd0rDY\xb3f\x8d\xf9\xe4\x93O4\x8b\x0f\x89)\xd8\xf2C\x08e\x04Y<\x18\xe8\xb3z\x8f\x92)dwo+\x90L\xfd\xea6\xac0\xd5K\xbe0\xa4\xc4\x0f\x82G\xfb\xce;\xef\xaca\x93\x83\xf9\x13\x89F\x8a\xc3+I,\x9c\xed\xca\x11\x16\'\xb4\x1c\x8d2m\xda4s\xdcq\xc7iv\x1dKz~G\x93\xb7\xfdQ&g\xd8\xde"\xb4\xb6\xf3\xec^\xec5T\xa1\xf5\xbd\xa9^\xf4\xb9\xa9\xf8\xea5uZ\r\n/\x12U<\xfc\xf0\xc3\xea\xdd\xeep\xb4\x04\'\xb4\x1c\r2g\xce\x1cs\xd2I\'\xd5\xc7\x92\x17\xb2z\x8f4\xed\x0e\xbc\xc4\xe4\x8e<\xc8d\xb4k/B\xa9.f\xc5O}\xb2\xb2\xd2Dx\xad3\xe53^4\xc5\xaf\xdf(Bl\x9a\xff\xa1Qm\x8b|\x8cL\x07\x1d\x8edq\x0e0\x8e\x06\xc1\xef\x8ai\xa2%\xab\xefh\xd3\xf1\xc4\xdbL\xc1\xce\xc7\xa9\x9fU]i\x99\xe6+\x8c\xd4V\xd7\xbf\xaa\xcbM]Y\x99I\xcbmg\nv\xfb\xb9\xe9x\xcc?L\xf6\x80\xfa\xc8\xa6\x08@\xb2_7\x96\xb6\xdf\xe1\x08\x83\x13Z\x8e\x8d\xf8\xe8\xa3\x8f\xcc\xa3\x8f>\x1auYHo\xdf\xcdt8\xe2o&w\xf0n\x1a\x1f\x9e\xed?M\x81+C]E\xa5L!\xf72\xed\x0f\xfe\x93L!{\xf8\x9fx\xc2\x90\xac\xd7\x0eG\xb28\xa1\xe5\xd8\x08\xfc\xac\xe6\xcf\x9f\xef\xbf3\xa25\x9djr\x86\x8c7u\xd5U\r\xfak5\x88L\x1b#\xd5\xd52\x95<\xd8\x14\xec\xf9k\xff\xa0Q\xc7\xd3\xd7^{mc\x1f.\x87#$Nh9b\xc0\xd1\x94\x15D\x0bYu\xf2\xc7\x1e\xad\xdbnLm\x82\xd3:4\xb2\x8ct\x93\xbb\xcd\xfe&\xb3{}\xc2\xd5\xb7\xdez\xcb\xacXQ\xbf]\xc7\xe1H\x04\'\xb4\x1c1,X\xb0\xc0\xcc\x9e\xed\xed+\x84\xec\xc1{\x98\xf4\x0e\xbdDsJ\xd2\x0e%\xdaVf\xb7\xadcl[\xacJ\x06\x13l8\x1c\x89\xe0\x84\x96#\x06\xfc\xb3V\xad\xaa\x8f\xde\x90\xddg\x94I\xcfk\xef\xf9b%\x01\xee\x10\xe9\x1d\xba\x88\xe0\xaaO\t\x86\x93)\xf1\xea\x1d\x8edpB\xcb\x11Cii\xa9Y\xbf~\xbd\xffN\x1a\x08\x1b\x9c\t-\x93\xac\rJ~G\x10\xd3\xf4\xbc\xfa ~UUU\xfar8\x92\xc1\t-G\x0cl\x82\xce\xcc\xcc\xf4\xdf\tjxo\x05\xa3y\x9c\xd0s\xe1f\x1c\xc9\xe2Z\x8e#\x06\x12_t\xe9R\x9f\xcb\xb0v\xed\x12\xcf\xb3=-\xc9\xa6"\xbf\x8bT\xd5\xc4\xc4\xc9\xca\xcb\xcb\x8b\xc9\n\xe4p$\x82\x13Z\x8e\x18\xd8\xdc\xdc\xad[7\xff\x9dL\xe5\x16L5ue\xebE\xf6\x04\xb4\xaf\x04 \x12j\xed\xda\xe5\xa6fy\xfdV\xa0>}\xfah0B\x87#\x19\x9c\xd0r\xc4@L\xac\x11#\xeaS\xddW~\xfb\xbe\xa9Y6\xd3\x7f\x97D.\xc3\xac\x0cS\xbdt\x86\xa9\x9c\xfb\x9e\x7f\xc0\x98\x9dv\xda\xc9t\xef\xde\xdd\x7f\xe7p$\x86\x13Z\x8e\x18\xd0\x80\xb6\xdf~{\xff\x9d1\x91\x8a\x12S:\xf9~SW\xb1\xce\x0b\x8f\x9c\x00\x04\xfc\xab[\xb7\xc2\x94}\xfc\xb0\xa9+\xad\x0fKC\x94\xd3hr\r\x87#A\x9c\xd0rl\x041\xdf\x83\xd1\x18\x88\xd8P>\xf5q\xcfW+.\r~\xa3\xf0\xbdH\x9d\xa6\x13+\xff\xecI\xff\xa0\x97\xc3p\xdc\xb8q\xd1X[\x0eG\xa28\xa1\xe5\xd8\x08\xa6\x87\xbf\xf8\xc5/\xfcw"{\xaa+\xcc\x86\x17\xff"\x1a\xd7\x03\xc6\xd4Vi\x82\n":l4]D\x10\x11\xe9!S>\xaf\xad6e\x9f<j6\xbcp\x99\xfe\xde2q\xe2DM\x0b\xe6p$\x8b\x0bM\xe3h\x90\xe2\xe2bs\xfa\xe9\xa7\xeb\xc6iKZN\xa1)\xd8\xf3\x0cS8\xfe,\x93Q\xd8\xd5\xdb\xdaC\xda0\xdb\x82\xeajM\x1d\x91\x1e\xd6-1%\x93\xee0e\x1f\xdci\xea\xca7\xf8\x1f\x1as\xc2\t\'\x98[n\xb9E\xd3\xf3;\x1c\xc9\xe2\x84\x96\xa3Q\x88\xa9u\xea\xa9\xa7\x9a\xf7\xde\xab7\xa2\xa3]ev\xdb\xca\xe4\x8d!\x10\xe0>\x1a\x04\x90cH\xae\xdauK5-~\xf9\xa7O\x98\xda\xd5\x0b\xf4\x98e\xbf\xfd\xf6S\x81\x15\xccp\xedp$\x83\x13Z\x8e&\xf9\xf2\xcb/5\xd1\xc4\xcb/\xbf\xec\x1f\x89%-C\xa6\x83yE&RY\x1c3\r\x0cr\xc8!\x87\x98k\xaf\xbd\xd6\x85Tv\xb4\nNh9\x9a\x85\xbd\x887\xdcp\x83y\xfc\xf1\xc7cB\xd64\xc7\x80\x01\x03\xccO\x7f\xfaSs\xd1E\x17\xc5\xf8~9\x1c-\xc1\t-Gh\xde}\xf7]\x8d<J\xba1\xe2\xc6\x97\x94\x94\xf8\x9f\xd4SXX\xa8\xc9*\xd0\xaa\x08\xd7L\x0eC\x87\xa35qB\xcb\x9103g\xce4\x9f~\xfa\xa9f\xe9!)\xab\x85\xad98\xa7\xe2<\xealW\x8e\xb6\xc2\t-\x87\xc3\x91R8?-\x87\xc3\x91R8\xa1\xe5p8R\n\'\xb4\x1c\x0eGJ\xe1\x84\x96\xc3\xe1H)\x9c\xd0r8\x1c)\x85\x13Z\x0e\x87#\xa5pB\xcb\xe1p\xa4\x14Nh9\x1c\x8e\x94\xc2\t-\x87\xc3\x91R8\xa1\xe5p8R\n\'\xb4\x1c\x0eGJ\xe1\x84\x96\xc3\xe1H)\x9c\xd0r8\x1c)\x85\x13Z\x0e\x87#\xa5pB\xcb\xe1p\xa4\x14Nh9\x1c\x8e\x94\xc2\t-\x87\xc3\x91R8\xa1\xe5p8R\n\'\xb4\x1c\x0eGJ\xe1\x84\x96\xc3\xe1H)\x9c\xd0r8\x1c)\x85\x13Z\x0e\x87#\xa5pB\xcb\xe1p\xa4\x14Nh9\x1c\x8e\x94\xc2\t-\x87\xc3\x91R8\xa1\xe5p8R\n\'\xb4\x1c\x0eGJ\xe1\x84\x96\xc3\xe1H)\x9c\xd0r8\x1c)\x85\x13Z\x0e\x87#\xa5pB\xcb\xe1p\xa4\x14Nh9\x1c\x8e\x94\xc2\t-\x87\xc3\x91R\xa4E\x04\xff\xef-\x9a\xef\xbf\xff\xdeL\x992\xc5\xcc\x9f?\xdf\x94\x95\x95\x99\x8c\x8c\x0c\xd3\xad[7\xb3\xddv\xdb\x99\xed\xb7\xdf\xde\xffV\xdb\xb1v\xedZ\xf3\xf1\xc7\x1f\x9bo\xbf\xfd\xd6\x14\x17\x17\x9b\xf4\xf4t\xd3\xb9sg\xb3\xed\xb6\xdb\x9a\x1dw\xdcQ\xcf\xa7-)))\xd1\xeb\xff\xfa\xeb\xaf\xcd\xfa\xf5\xeb\xb5\xfe\x8e\x1d;\x9aa\xc3\x86\x99\x9dw\xde\xd9\xe4\xe4\xe4\xf8\xdfl\x1b*++\xcd\'\x9f|bf\xcd\x9ae\xd6\xacY\xa3\xc7\xda\xb7oo\x06\x0f\x1elv\xd9e\x17SXX\xa8\xc7\xda\x8a\xda\xdaZ\xf3\xe9\xa7\x9f\x9a/\xbf\xfc\xd2\xacZ\xb5\xca\xd4\xd5\xd5i\x9d[m\xb5\x95^\x7f\xa7N\x9d\xfco\xb6\x1d\xd3\xa6M3_|\xf1\x85Y\xb1b\x85\x9eO~~\xbe\x190`\x80\xd6\xdf\xbd{w\xff[\x0e\x83\xd0\xda\x92\x91F\x12\x998qbd\xd0\xa0A\x11i\xa4\x08\xf0\xe8++++"\x8d%\xb2\xfb\xee\xbbGn\xbf\xfd\xf6\xc8\x86\r\x1b\xfc_\xb5\x1es\xe7\xce\x8d\x9cw\xdey\x11\xe9\x9c\x11\xe9\xa41\xf5gffF\xbav\xed\x1a\xd9i\xa7\x9d"7\xddtSD\x04\x9b\xff\xab\xd6c\xf1\xe2\xc5\x91\x8b/\xbe82|\xf8\xf0HQQQ$---Z\xbf\x08\xae\x88t\xd6\xc8\xe8\xd1\xa3#W\\qEd\xd9\xb2e\xfe\xafZ\x8f\x95+WF\xae\xbe\xfa\xea\xc8\xa8Q\xa3""\xa4#"\x9c\xa3\xf5s."8#"\xb8#\x7f\xf8\xc3\x1f"\xf3\xe6\xcd\xf3\x7f\xd5zpO\xff\xf9\xcf\x7f\xea=\xe6^s\xcfm\xfd\xbcx&C\x86\x0c\x89\x9cy\xe6\x99\x91\x993g\xfa\xbfj=d\x80\x8a\xdc{\xef\xbd\xda\xc6z\xf4\xe8\xa1m.X?mr\xe0\xc0\x81\x91\x93N:)"\x83\x8a\xff\xab-\x9b-VhUTTD\xae\xbc\xf2\xcaH\x97.]b\x1aIS\xaf\x03\x0e8 \xf2\xf9\xe7\x9f\xfb%\xb4\x0c\x19\xc9#\xb7\xdezk\xa4o\xdf\xbe\r\xd6\xd5\xd0k\xb7\xddv\x8b\xbc\xfb\xee\xbb~\t-\xe7\xc1\x07\x1f\x8c\x0c\x1d:\xb4\xc1\xba\x1az!X\x9e\x7f\xfey\xff\xd7-\xe7\xc5\x17_\x8c\x8c\x193\xa6\xc1\xba\x1azm\xbd\xf5\xd6\x91\xfb\xef\xbf\xdf\xffu\xcby\xff\xfd\xf7#{\xec\xb1G\x83u5\xf4\xea\xdd\xbbw\xe4\x96[n\x89TUU\xf9%\xb4\x8c\x193fD\x0e:\xe8\xa0\x06\xebj\xe8\xc5\x00\xf2\x97\xbf\xfc%"Z\xb1_\xc2\x96\xc9\x16)\xb4\x18]\x7f\xfd\xeb_o\xd4(\x06t\xcd\x8d\xec3\xa2c\xe4\xc0\xed;E\x0e\x18\xdd)\xb2\xe3V\xed"\xf9\xd9\xe91\xdfA#{\xe9\xa5\x97\xfc\x92\x92\xa3\xbc\xbc<r\xc9%\x97\xc4h\x15\xbczw\xca\x89\x8c\xdf\xd6\xab\x9f\xd7\xb8!\xed#\xed\xf3bG~F\xe3\x87\x1f~\xd8/)9\x10\x987\xdcpCD\xa6\x1f1ew\xef\x90\x15\xd9sx\x07\xef\xfa\xe5\xb5\x87\xfc\xdd\xb9]\xec\xc8\xdf\xa1C\x07\xed\xb8-\x05\xed\x02\xcd*Xv\xa7\xc2L\xbdf\xea\xe6\xc5\xbd\xe8\xd11;\xe6;2M\x8d\\~\xf9\xe5\x91\x9a\x9a\x1a\xbf\xa4\xe4x\xf6\xd9g7\x1a0\xda\xe5eDv\xdeZ\xea\x1f]\xa4\xcf\x7f\x9f\x11E\x91\xbe\x9dsb\xbe\x83\xf6\x87f\xdcR\xc1\xf1\xce;\xefl4`\xe4I[\x1b;\xa8]d\x7f\xad\xbf(\xb2\xefvE\x91A\xddrc\xbe\xc3\xeb\xe7?\xff\xb9j\xa8[*[\x9cM\xab\xba\xba\xda\x9c\x7f\xfe\xf9F\xa6\x04\xfe\x11c\x06\xf7\xc83\x87\xef\xd8\xc5\x0c\xed\x95g\xda\xe7g\x9a\x8c\xf44m\x1e\x15\xd5\xb5f\xc5\xfaj\xf3\xe6\x97\xeb\xcck_\xac1\xd5\xb5\xde\xad\x92\x11\xd7<\xfe\xf8\xe3f\xdc\xb8q\xfa>Qd\xb44\x97]v\x99\xff\xce\x98>\x9ds\xcc\x91;v6#\xfa\x15\x9a\x8e\xf9\x19&#\xc3[\x1f\xa9\xaa\xae3+7T\x9b\xf7f\xaf7/}\xbe\xda\x94U\xd6\xe9qlM\x0f<\xf0\x809\xe4\x90C\xf4}\xa2\xdcv\xdbm\xe6\xdcs\xcfU\xbb\ttm\x9fe\x0e\xdf\xa1\x8b\x19;\xa8\xd0\x14\x15f\x9aL\xbf\xfe\xea\x9a:\xb3\xa6\xa4\xc6|<g\x83y\xee\xd3\xd5f}Y\x8d\x1e\x97)\x94\xb9\xf3\xce;\xcd/\x7f\xf9K}\x9f(O>\xf9\xa4\x91\xe9\x8e\x11\xe1\xad\xef\xb9\xe7\x87\x8d\xedlD`\x98\xce\xed2Mv\x96W\x7f\x8d\xdc\xefu\xa5\xd5\xe6\xf3\xf9%\xe6\xe9)\xab\xf4^X\xae\xbb\xee:s\xc1\x05\x17\xf8\xef\x12\xe3\xad\xb7\xde2\xc7\x1dw\x9c\x91\x8e\xaf\xefEX\x98\x83\xb6\xefdv\x1f\xd6A\xeeE\xb6\xc9\xcd\x92\xe7o\xd2L\xadt\x8d\rr\xcd_.,\xd5\xfa\x17\xad\xae\xd4\xef\xc3\x85\x17^h\xae\xbd\xf6Z\xff]b|\xf6\xd9g\xe6\x98c\x8eQ\xfb%df\xa4\x99\x9flWd\xf6\xde\xb6\xa3\x11!\xad\xe7\x03u\xd2\xdc\x8a\xcbk\xcd\xd7K\xcb\xcd\xb3\x9f\xac4s\x96y\xf7\x0b&N\x9ch\xfe\xf3\x9f\xff\x98\xec\xecl\xff\xc8\x96\xc3\x16\'\xb4\xe8\xb0g\x9du\x96\xff\xce\x98\t#:\x9a\x13\xf7\xe8n\xbaI\xc7\xad\x15\x99P+-\xc5\xde\x91ti;4\xa8Z\xe9<\x1f\xcdYo\xeexs\xb9t"\xaf\xe3\xee\xba\xeb\xaeFFk5\xd6\'\xc2SO=eN<\xf1D5<\xc3N[\xb73\x13\xc7\xf7P\xc1U\'\xf5\xd7\x04\xeb\x97\xbe\x93\x99\x99&\xc7#f\xda\x82R\xf3\x9f\xd7\x96\x9a\xe5\xeb\xaa\xf4\xb3m\xb6\xd9\xc6<\xf7\xdcsF\xa6L\xfa>,2\xc2\x9b\xa3\x8f>\xda\xac^\xbdZ\xdfo\xdb\xb7\xc0\x9c:\xa1\x87\xd9\xaa{\x9e\x0e\xe3\x08\n[\x7f\x1a\xf5\xcb\xf5\xf3\xc1\xd7\xcb\xca\xb4\xfey+*\xf4\xb3>}\xfa\x98\xa7\x9f~Z\x17\t\x12a\xfa\xf4\xe9\xe6\xb0\xc3\x0e3\x0b\x16,\xd0\xf7\x03\xbb\xe5\x9a\xd3\xf6\xe9\xa9\xe7\x01\r\xd5\x8f\x08\xf9ne\x85\xdc\xffe*@\x00\xc1\xfd\xe8\xa3\x8f\x9a\xfd\xf7\xdf_\xdf\x87\x85z\x0f=\xf4P#S3}\xdf]\x84\xc4\xe9R\xff\x18\x11\xd8\x19R!\xf7\x9f\xe7\x00Z\xbf<\x844i\x07\xcb\xd7V\x99\xbb\xdfYn&\x8b\x00\x07\x16&\xfe\xfb\xdf\xff\x9a_\xfc\xe2\x17\xfa>,,\xb8\x1cy\xe4\x91F\xa6\xf9\xfa\xbe\x83\x08\xecS\xe4\xfe\xef>\xb4\x83>k\xae?X?\x03(\xed`MI\xb5y\xe8\xfd\x15\xe6\xf5\xe9k\xbd\x0f\x85\x1bo\xbc\xd1\xfc\xfe\xf7\xbf\xf7\xdfm9d\x88\xaa}\xb9\xff\xf7\x8f\x1eV\x08O?\xfd\xf4\xe8\xea\x14#\xeb\x19\xfb\xf52\x1d\xf22Leu$*\xb0\xe83\xbc\xe4\xad6"z\xcd\xd6=\xf3M\x8f\x0e\xd9\xe6\xd3\xf9\xc5\xaaq-^\xbcX\x05\xd6n\xbb\xed\xa6e\x85\x81U\xb9s\xce9\xc7|\xf7\xddw\xfa~T\xffBs\xdeA}Lw)\xb7R\xb4*+\xb0\xe2\xeb\xe7X\xff\xae\xb9F\xa6\n\xe6\xd3y%\xa2\x01\x8a\x06&ZBVV\x96\xd9w\xdf}u\xa5/\x0c\x15\x15\x15\xaa\x9d|\xfe\xf9\xe7\xfa\x1eA\xf5\xdb\x83\xfb\x18\x99\x16\x9bJ\xd1\xaal]\xb6~\xfe\xf6\xeeI\xc4\xf4,\xca1\xc3z\xe7\x9bi\xdf\x95\x98\x92\x8aZ\xb3a\xc3\x06]e=\xf0\xc0\x03\xf5<\xc2\x80fw\xc5\x15W\x987\xdf|S\xdf\xf7,\xca\xd6\xfa\xb7\xe9\x9b\xafZec\xf5\xa3\xf1\xa0\r\x8e\x14M\xf4\xab\xc5e\xaa\xfdq-<O\x04Pnn\xae\x96\x17\x86\x9bo\xbeY\xb5d@\xab<\xef\xc0\xdef\xc7\xad\xda\x89V\x19\xd1\xe7\xca=\xdf\xa8~9\xde\xb1 C\x9f\xd7\xfc\x95\x95:pp-\xf3\xe6\xcd3G\x1cqDB+\x9b\xf7\xdf\x7f\xbf\xf9\xd7\xbf\xfe\xa5\x7f\x17\xe4d\x98_\xff\xa4\x97hXE\xf2\xec\xeb\xf4\x1c\x1a\xaa\x9fvQ\x90\x9ba\xb6\x1fPhV\x14W\x99\x05r\x0e\xc0J+\x03\xc0\xa6X\xd9\xdc\x9c\x08\xd7\xda\x7f$\xd0`\xe6\xce\x9d\xab\x7fw\xef\x90e\x8e\xdd\xb5\x9b)\x94\xc6P%\x8d\xa5)\x18\xf9\xca\xa4\xa3\xee<\xb8\x9d9x\xfb\xce\xfeQcn\xbf\xfdv\x15Day\xe1\x85\x17\xd4\xad\x00\x18a\x8f\xdd\xad\xab\xe9R\x98\xa5B\xa8\xa93\xa0!S?\xda\xc8Q;w\x95\x91\x17\xdd\xc3\x98{\xef\xbd\xd7,Z\xb4H\xff\x0e\xc3\xa4I\x93\xcck\xaf\xbd\xa6\x7f\xe7\xca\x14\xec\x98]\xbb\x9a~\xa2\xe1UTI\xfdM\x9c\x80\xd6_Yk\x06v\xcd3\'\xec\xd6\xcd\xe4\xf8\xd37\xb4\xc6\x993g\xea\xdfa@\xcbB;\x034\x88#w\xea\xa2\x82\xb0B\xa6\xbd\xd4\xd1\x18\x9c[\xb9\x9c#S\xa7\x9f\x8bV\xcct\x12\xd0\x1a?\xf8\xe0\x03\xfd;\x0chY\xb4\x01\xcb\x81\xa3;\x991\x03\x0b\xb5\xec&\xeb\x97W\x85\x0cj<\xb3\x13\xf7\xe8\xa6\x83\x0c\xa0\xad\xf1L\xc3\x82\x96u\xc7\x1dw\xf8\xef\x8c\xd9k\x9b\x8ef\x0f\x198+\xaajE8\xf9\x07\x1b\x816\xca}?n\\7\x1d\xc0\x80g\xff\xe0\x83\x0f\xea\xdf[\x12[\x8c\xd0b:\xf6\xea\xab\xaf\xfa\xef\x8c\x19\xbfmGy\xf89:\xc2\x87\x81\x86K\xe7\xd9wd\x91\xe9\xd2\xce\xd3,\xd0\x98\x10\x04a\xa8\xa9\xa9\xd1\xfa\xf9\x17v\x19\xdc\xde\x0c\xef]\xa0\x02+\x0c\xd4\xcfHLC\xef\xdb\xc5\xeb4h\x8c\xd8g\xc2\x80\xdf\xd1\xeb\xaf\xbf\xae\xda\x11\x8c\xea_\xa06\xac\xe6\x04f\x90\xca\x9aZ\xb3\xcb\x90\xf6j\xfb\x03\xb4\x9d7\xdexC\xff\x0e\xc3\xdbo\xbf\x1d\xb5#aG\xdcM\xa6Dh\x98a\xeb/\x97\xce\x8d\xb6\xb1]?o*\x89}\x12\xad\x8dk\x0b\x03\x02\x0e\xed\x08zu\xca6\x13F\x14\xa9v\xd5\x94\xc0\x0e\x82p\x1b\xd6+\xdf\xec(Sz\xa0^\xae\xa9\xaa\xca\x9b\xb27\x07\xb6,^\x80\x00<`t\x91\xd6\xdd\x94\xc0\x0c\xc2\xb3\xea\xdf%\xd7\xec9\xbc\x83N\x1d\xe1\xbd\xf7\xde3\xeb\xd6\xad\xf3\xdel!l1B\x0bUz\xce\x9c9\xfawGi0\xa3\x07\xb4\xd3\x07\x1f\xb6\xc1\x00\xa3!S\n\xec\x1f\xfa^\xa6\x08v\xaa\xd3\x1cL\'q\x1c\x04\xb4\x9c\xb1\x83\xda\x99l\xd16\xea\xc2\xf6\x18A\xfa\x97L)\xd2u:c\t+4h\xd8V\xcb\xc3N\xb4\xe3\xd6\xedMnv\xbaN?\xc2\xc2\xf5g\xc9o\xb1\xc3Y\xb8\xfe0\x9d\x16\x01g\xb5"\xee\xfb\x0er\r\xed\xf32\xbd\xe9wH\xec\xad\xa2~],\x11\xb0\r\x85\xe9\xb4Lq\x83\x03\xcc\xd8\x81\xedt\xf0I\xa4~\xc0\xbe\x88\xb0\xe79\xc0\xe4\xc9\x93\xcd\x92%K\xf4\xef\xe6\xb0v,`\xaa\xd9K\xa6\xdcvq\',|\x7f;\x19p:\x89\x86\x0eL\xf5\xed\xecaKa\x8b\x11Z\xcb\x96-SOg\xc0\x96\xd2S\xa6\x1ah.\x89@\x83\xcd\xcf\xc90C{\xe6\xfbG\x8cY\xb8p\xa1\xffW\xd3P7\xe7\x00]\xdag\x99~]D\xcbknN\x10\x07\x1d\x0f\x81\x83\x86f\xb1\x06\xed\xe6\xa0c\xdb\xa9d;\x99\x12c\x1fK\xf4\xfa=\xa4\xfe^\x05\xd1)*\xf5[\xed\xb1)JKKu\xb7\x01dg\xa4\x9b\xc1=\xf3D`$v\xfd\x80}k\xa8h;\xf9\xfe\n\x1b\xd7dW!\x9b\x02\xad\xccjY\x80\xb6(:Vh-\xcb\x82\xd0\x18\xdc#?:E]\xbat\xa9\xda\xf7\xc2`W\x0baX\xef<\x11\xbch\xd0\t\n\xad\x9a:\xb5Avm\xe7\xd5\x8f\xb6\xcd\xb4sKb\x8b\x11ZtZ\xdb\xb8\xb1c\x15\xe6e$\xa4\xe5\x00\xdf\xa6\xaf\xf2{KX\xd5\x9c\xad9\xb6q\xb1\xa4\x8dkC\x82\x83\xac\x92l\xfdL\x0b\xed\x8a!\xb6\x91\xa2\x82\xcc\x84\xb4\xcc \x05\xb9\xe9&[\xdd\x02\xbc\xc5\x05\xeb:\xd1\x14L\xcf\xed\xd4\x10\xc1\x8bkCR\xc89\xe7\x8b\x96c\xdd"\xb8\xfe0B\x93\xef`\xb8\x07\x94\xb4\xce\xa2eyW\x90\x18\x0c\x1ch\xa8h\xcb\xc0u\x85\x9d\x1e\xda\xfa\x81\xfa\xd3\xe5D\x12\x15\x9a|\x9f\xba\xf3d\xf0\xb4\xd8)\xff\x96\xc2\x16#\xb4\xd8\xbbgW\xd9x\xf0\x91\xc4\x07y\x85\x86\xee+\x19J\xd8=\x81\xd4m\xbfK\xfd\x08\xacd:\rP\xbf=\x87\xa4\xebO\xf2\xfa\xe5\xd7\xf2\x92\xca\xf9G\xa0\xcc\xb4\xe0\ri\x04\xea\xc7\xbf\xcb\x12B\xce5\x8a\xe7\x04\xe1\x11\xb6~\x88\xa9?\xe9\xeb\xa7\xfeH\xcc\xb3K\xaa\xfedF,\x1f\xaf\xb6\xfa:\xc3\xae\x1e\xffX\xd8b\xae\x96e\xe1\x82\x02oZ\xc5\x92}qE\x8d<\xecp\x8d\xcdB\xdb\xc4\x06\xb4\xd6\xf7\xd5\x026\xf5\x86\xa1C\x87\x0e\xba\x01\x1a0\xe8\xe2\xa8\x99`\xf5\xdaL\xd1\x0eY\xf2G\xf0@\xd8\xfa\xd9|k}\xcapoXG\xfdI>}|\xd5(\x03\xa8?L\xa7\xc1\xaf\xa9G\x8f\x1e\xfa7\xcb\xfbk\xa4\x8c\x90}=\x06~\xc3\xbdc\xc5\x13\xda\xb5k\x17#\x0c\x1a\x03\xb7\x8c\x9e={\xea\xdfh\x98z\x0f\xe5\xefDO\x01\x01\x85\xc3g\xa9_?\xd7\x15\xd6\xc1\xd3\xd6\x0f\xab\xa5~\xdaR\xa2\xf7\x80\xfai\xbf%\xd2~-\x89\xb8|\xfc\x18\xd8b\x84\x16\xbb\xe4\xad?\xcb\xd2\xb5\x95f\xd9\xda*\x93\x9d\x99X\x8b\xc1\x8e\x83\xc0\xf9jI\xbd:N\x14\x820 \xb0\xac\xd0XU\\\xa5\xce\x92\x89\xd6O\x03GC\xf8j\xb1\xe7`\tC\x86\x0c\xf1\xffj\x1a\x84&\x9e\xfc\xb0A:\xdd7\xcb\xcb\xd5\xb6\x94\x08\xd4O\xa7\x99)\xf5[\xa1\xc9\xf5\x87\xf1\xd3\xca\xcb\xcb3}\xfb\xf6\xd5\xbf\xab\xaa#\xe6k\xb9\x87\xd6\xf3>\x110\xc0\xcfZRj\xd8\xad\x008\xd7\xda\xc1\xa8)\x10l\xfd\xfa\xf5\xf3\xdfy\xf70\x1d\x91\x95\xd8#\x90g\x96n\xbe^V\xae\x9e\xf2@\x14\x86\xa2\xa2"\xfd\xbb9\xf8\xaee\x96\xd4\xcf\xb3\x0c\xab\xa5YrdZ\x8e\x83\xef\n\x7fw\x00\x03A\xa2\x0e\xce\xa9\xce\x16#\xb4\x08\xb12|\xf8p\xfd\x9bN;sQ\x99\x8e\xb8\x89\xb4\x19\xfa\x18\x8e\x85\xd3\xe6\x97\xe8{:\x02\xce\x9da\xa0\xc3\x8e\x1d;V\xff\xc6\x91u\xc6\x822S#\xfd.\x11m\x0b\xcdp\xad\x8c\xd0S\xbf-\xf6\x8f\x18\xb3\xdf~\xfb\xf9\x7f5\r\x1d\x0b/~P\x0f\xfb\xef<\'\xd5D\xb4-\xce\xb5\xb4\xb2\xd6|\x12\xa8\x9f\xeb\x0f#\xb4\xd0\x06\xf6\xdak/\xfd\x1by7m\x81\xe7\xa4\x8a\xc7yX\xf8*\xfeJS\xbe)\x89N\xef\xc6\x8f\x1f\xaf\x02\xb99\x10\x0e\xfb\xec\xb3\x8f\xff\xce\x98\x19\x0bKE\xdb\xaaN\xa8~\xda\n\x9a\xee\xa7\xdf\x96\xe8\xe0\x05\xdc\xd3\xa0\x06\xd5\x14\xc1\xfag..3+\xd6W%\\\xbf\xfc\xbf>\xbb\xf5\xbe\xb6O\xd8\xa4DwE\xa4:?\x9am<\x18y\x89\xc7\xc4j\x1e\x86I:\x12#\x10\xf1\xb0\xac\xb0b\xaf\xd6\xd9g\x9f\xad\xfe5xX_\xf2\xd3~f\xeb\xee\xf9\xea\xff\xd3\x1c\x19\xd2`\xd8\x13x\xfb\xebK\xcd\xcb\xd3<\x8fz\x1a\x0c1\xb0\xa8\x0b\x830\xf5\xb3BFl*l-]\xbat\xd1xX\xa3G\x8f\xd6\xef\xb3\xed\xe6\xf8\xe3\x8f\xd7\x05\x01\x96\xfb/<\xac\xaf\x19\x8ds\xa3\x08\x82\xe6\x1e\x02\r6/+\xc3<\xf4\xfe\xf7\xe6\x91\x0fV\xe8\xb1\xfe\xfd\xfbk\x9d]\xbbv\xd5\xd59\xfe\xfe\xe6\x9bo\xd4\xe8O\'EPq\xedl\xb5\xe1\xfdG\x1f}d\x0e>\xf8`]\x10\xc8\xcb\xce0\xe7\x1c\xd0K\xfd\xd5p\x1cm\xae\x15\xd0_\xf0\xca~~\xeajs\xe7\x9b\xcb\xd4K\x9b\xeb{\xff\xfd\xf7\xcd\xd0\xa1C\xd5\x18=u\xeaTu+\xa1|\xeaC\x98\xa0\x89\xed\xb4\xd3N:\x85bi~\xc2\x84\t\xea\xfe\x91%Z\xe6\xaf\xc6\xf74\x87\xed\xd0\xd9\x94\xc9\xfd\x0f\xd3\nY\x80x\xf7\xabu\xe6\xe6\x97\x96\xa8\xc0E\xc3z\xe5\x95W\xcc\xee\xbb\xef\xae\xcf\x14\x1f(\\[\xec\x82\x83\x8d\x87E\xfd|\x97\x15\xdc=\xf7\xdcS\xbf\x83\xd6\xfc\xb3]\xbb\xaa\xb3j\xa5hm\x0c`\xcd\x81\x07\xfb\xe7"0\xaeyv\xa1\'pe\xd0z\xf8\xe1\x87\xcd\xcf~\xf63\xfd\x1c\xe7Y\xe2q\xd1\x169\x1f\xa6\xe4\x03\x07\x0e\xd4\xfa\xd9v\xc4=Bpq\xcf\xe0\x80\xd1\x9d\xcc\xaf\xf7\xeb\xa5\xd3\xc40\xae\',@|\xb3\xbc\xc2\xfc\xed\xe9\x05\xd1}\x98x\xf8\x9fw\xdey\xfa\xf7\xec\xd9\xb3\xd5\xad\x06\x83?\x0b\x0f\xd4\xcf`\xc9\xf3\xff1ic)/\xb4\xf0J\xfe\xc7?\xfe\xa1\ra\xf9\xf2\xe51\xcb\xcf\x8c\xeeth:\xee)\xa7\x9c\xa2Z\t\x9d\x96\xce\x0bxC\xff\xf6\xe0\xbe\xbaE\xc3\xdaH\x1a\x82\xd1\x10\xb5\xfc\xf5\x19\xeb\xccm\xaf.U{\x0ev\x1c<\xd2i\x84l\xde\xc5q\x94\xfaYM\xb3\xb7\x94\x8eJ\xc7\xa6\xe3\xfe\xfc\xe7?\xd7=\x7f\'\x9f|\xb2\n/\x18\xd23\xdf\xfc\xe1\xd0\xbe\xa6gQ\x96\xe7\x95\xaeG7\x86)\x11+\x8e\x1f\xcd\xd9 \x1dv\xb1j\x8ap\xfd\xf5\xd7\x9b_\xfd\xeaW\xe6\xa6\x9bn2\xcf?\xff\xbc.\xbf#<\xedj\x1e\xc2\x94)\xf1\xa0A\x83t\x83.u\xff\xdf\xff\xfd\x9fz\xf2C\xefN\xd9"8Ep\xf7\xc8kRp\xa0\x0c\xe0\xea1ca\x89\xb9\xe9\xc5%\xe6{\xd1\x10\x80\x8d\xe7\x97^z\xa9zy\xb35\x06\xf7\x03\x04\x96]\xcd\xa3S\xd3Y\x11\xae\x87\x1f~\xb8na\xba\xe5\x96[\x8c\xdd9\xc6\n&\xd7o\x05wc\xfd\x16\x81] B\xf6\xdb\x15\xe5Z\xff|\xf9\x17\xd8\xc3\xc9\xc6w\xf6 \xe2\xe9\x8e\xb3/\x02\x0b\xf7\x06\xe0\x19Q?\xfb$\x0f8\xe0\x00s\xd1E\x17\x99\'\x9exB\xf7\x9e"T\x10\xdc\xbf9\xa8\xb7:k\xa295&8\x10\xd8y"0\xd0\xb2\xff\xf1\xbf%\xe6\xcbE\xde\xf4\x9cgOy\xff\xfb\xdf\xfft\x039\x03\x06\x82\xd1\xee+\xb5\x82\x1bMl\xef\xbd\xf7\xd6{\x8f`?\xf6\xd8c\xf5\x1cYEe\xdf\xe3\xc1c:\xab\x10nJp\xf1\xfc\xd7\x97\xd5\x9a\x7f\xbd\xb2\xc4|4\xd7k\xe3\x0c\xc8\x08m\x06\xab\x7f\xff\xfb\xdf\xe6\xab\xaf\xbeR\x81\x89O\x9c\x05\x9b#\xa6\x116\xf7s\xffw\xd8a\x07\xff\x93\xd4%e\x85\x16\x0f\x86NK\xa3\xb5K\xe9MA\x03\xa6\x91#@\xfe\xfe\xf7\xbfG\xdd\x0fv\x1e\xdc\xde\x9c\xb2\xb7\xb7a\x99\xa9G5\xf3\x0e\xff\x8e0\x1dCX1\x8d{c\xc6Zs\xff$\x11\x8a\xd2p\x80N\xc0\xa8}\xf7\xddwkc\r\x03\xfb\xd4\x98N\xd0q\xadC"\xfb\xe9N\xdd\xa7\x87\x19\xdc=W\xea\x96\xe9O\xa0\xfe4\xeaW\xbbW\x9ay\x7f\xf6zs\xf7\xdb\xcb\xa2#,\x8d\x90\x8d\xb7\x0f=\xf4\x90F\xbc\x0c\x03S9\x846B\x8bQ\x19\xb6\xee\x9egN\xdb\xd7\xdb\xb0L\xa7\xc1\x0f\xc8\xb6\x08\x84\x056\x1c\x84\xe6\xd4y\xc5\xe6\xae\xb7\x96\x99\x85\xab\xbc\x0e9r\xe4H\x8d\xf2\xc0\xa6q\xab94\x07\x11H\xe9\xb0\x9c3\x9d\x17z\x17\xe5\x98S\xf7\xedav\x18\xd4N\xaf\x9b\x01!X\x7f\x96\xd4O\xe7\xfeJ\xa6\xf3w\xbd\xb5\xd4\xcc^\xea\t,\xecCg\x9ey\xa6z\xa4\xd3q\xc3\xc09#\xb8_z\xe9\xa5\xa8S0N\x9a<\x7f\xf6\xa12Uf\xea\x1e\xed\x12\xd4/us\x0f\xe6}_\xa1\xd7\x8f\xa6\x05\x0c\x86\xbf\xf9\xcdoT\xb3!jE\x98n\xc4\xe0\xc1\xdeW\x1cR\x19d\x10\x9cho\xbf\xdc\xab\xbb\xd9w\xbb"\xb5qR?\xd3w%P\xff\xd25\x95\xe6\xdew\xbf\xd7v\x00h\x91\xbf\xfd\xedoUk%\xe2G\x18\xb7\x13\x060\xce\x99M\xd6\x89\xec\x97\xdc\xdcHI\xa1\x85C\x1d\xa3\x16\xbb\xec\x83\xb0-g@\xd7<m\xe4\xb0\xaa\xb8\xda\xcc\x92\xc6\x1et\xe2\x1c3f\x8c><\xb6?\xd8\x11\x91\x8d\xc3D{\xc0K\xb9O\xe7l\x1d!\xd1.Xa#,\xc8\x07_\xaf7\xef\xcdZ\x1f\xf5\x9e\xc6\xa0\x8b\xca\x8fv\xc5T\xcc\xd2\xab([\xcb\xc2\x0f\x8ao\xf2\xfb\xafdT\xb6\xf6\x0f\xc0\xb6\xc6\x94\x01\xefh\xeb_\xd3\xa7S\x8en)\xc1\xd3\xbe\x7f\x97\x1c\x15\x12tX\xa6 s\x97\x95\x9b\xc9s\x8b\xcd\xdb3\xd7F\xcbA\xd5G`RFP`\x13\xa9\x02\xa7M4\x08(\x96\xdfcpf\xb5\xcb\x82\xd6C\xe7\xe5\xfa\xed\xbeI~\xc7\xa6]\xbc\xd4\x07\x89\xf0\xa4\xa3P?\xf5a\xb0\xc7\x86\xf5\xd6\x97\xeb\xa2\xa1i\xd0\x1e\x10\x80x\xd8\x07\xf7>\xa29\xe1\xf8\xc94\x12\x98v\xcf^R\xae\xb6#\x0b\xa3>\xe1\x83\xe9\xb8\x84\x15\x06v(0M\xddI\xea\xdfZ\xce\x1f?(n \xce\xaf\xdf\xae\xac0\x9f\x8b\xc0d\xd0\xb0\x02\x9bi\x0fZ3\x9aE\xd0\x1b\xbc]^\x86\xd6\xcf\x16\x19\xa8\x12\x018G\x9e\x9f\xd5\x0c\x01\xcd\x8b{\x87\'\xb9=w\xa6]{\r\xef\xa8\x03\x18N\xa7z\xfeR?B\x9c\xcd\xc9\xd3D\xc3|c\xfaZ\xb3\xd8\x0fM\x83\x06\xcb\xf5\xa3\xd9\xda]\x0e\x806\xc46\x9fN\xbe\x0f\x1a\x83\xdd\xb7\xdf\x97G\x7f\x07\x9c;Sd\xc2Z\xdbs\xcf\x96\xfb=N\x84\xe6nC\xd9\xda\xe59\xaej\xaf\x94\xd7\xa2\xd5\x15f\x86\xb4\xa17\xa7\xaf3\xdfHY\x16\xca\xc0\xcc`g\r@\xbb\xe7\xf7<O\x04\x1e\xcd~\x81\xdc\xbf\xf9~d\x0e\x0b&\nf\'\xa9:eL9\xa1\x85\xa0a\x84\xc1>ea\x9au\xc8\xd8N\xea\xa9\xdeA:\x8e]\x94\xc2V\xb3tM\xb5L\xeb\xd6\x98wf\xaeW#* 8Xuc\xb4\xc5\x16daC.\x1d\xafSa\xa6t\xf8:\xe9\xec5\xd2\xe0\xab\xb5\x1c\x0b*9\x1d\x9f}|V\r\xc7\xbb\xfd\xd0\xb1]D[\x91\x06K\xfd\xbe\xd0\xa4\xd3\x7f/S\x8aw\xbe"\x1e\xd7\xda\xe8\x96\r\xb4\x04\xec\\\x08\x0ek\x7f\x01\xecl\x9de\xe4\xa7\xd1\xf3[\xb4\xba\x15\x1b\xaab\x84\x0eFW\x84\x0e\xf5c;\x83\xae\x1d\xb2\xcdar\xfd\xec\xcb\xc3i\xd1\nm4G\x8c\xbd\x1f\xcc\xde\xe0\xc5\xe3\xf2\x85\x1e\xd3\x15\x84.1\xd1\x19\xa9-\xd4\x8d\xb7~G\xb9\x06\x044+d+E\xf0\xdbp<\xc0\n$\x1a\x13\x02\xd3\xee0@Hp\xffw\xda\xaa\xbd\xfe\xde\xae\x8a"tV\xcb\xef\xa7|Sl\x9e\x0f\xc4\xe3\xc2\xd6\xb6\xc7\x1e{\xa8\xd0\tj\xa9\x94\xd3\xad\x83W?\x1d\x96\xeb_%\x02\x8f2,\xac\xc2b|\x0f\nL\x84\x05\xf1\xb0\xc6I\xa7\xefF<,\x84\x9e\xc05\xb0p\x81\xe1\xfa\xb9\xa9\xab\xa3\xc2\x0b\xc1\xc1\xa2\x00\xd7nC\xd4\x0063\xda\x00\xe7\xc1=\xc4\xd8\x8dk\x04\xcf\xc0\x82m\x0c\x81\x89]\x0c\xc1\x03|\x97xX{n\xd3\xd1\xf4\x92\xdf3\x95\x04\x84\x06\xf1\xc0f.*\x97\xfaWF\xb5T\x84\x1e\xf53h0\xb5\xb3p\x1d\xec\xd6\xa0~\xaea\x9d\xd4\x8d{\x8d\rG\x04\xfc\x96p<\x9c\xbb\xd5\xb0\x19`\xf7\x12\xa1\xbf\x8f\x0c|\xbde\x00d\x8b\x11\x83\x0e\n\x1b\xcf\x10\xc1\xfd\xdc\xd4U1\xf1\xb80W0\xadgU7\xd5H\xb9\xd04\xb7\xdez\xab\xf9\xdb\xdf\xfe\xe6\xbf3f\xbf\x91E\xe6\xcc\xfd{\x99m\xfb\x14\xa8\xaa\xcd\xc3\xe2\xff\xd0\x96\xf2D\xe3\xe9!\x8d\x00\r\x86\xe0n\xac\xd8\xd0\x91\xe8l\xa8\xea\x04\xa2c\x9af;\x1f\x9a\r\xda\x19\xc1\xdeh\xe0tV+hh\xac<h:\x1b\xf6\x1b\xaba\xed:\xa4\xbd9\xf7\x80\xdej\x1fk\x97\x97\xa9\xf5\xda\xfa\xd1\xb8\x88\x080J\x84\t\x82\x8d\xb0*\xd8.\xb0;1\xbd\xc0\xce\x86\xd6h\xb7\xf7\x10\xe4\xcf\xd6OC\xa5\xc1\xda\x08\x14\xd8\x87\x8e:\xea(\xb5\r=\xf3\xcc3\xd1s\x1e\xd9\xaf\xc0\xfc\xe6\xa0>fW\xd1\x12h\xec\xc1\xfa\x11\x1e]E\x88\x8d\xec_ \x1aX\xbe.\xd5#\x00\x11v\\\xcfi\xa7\x9d\xa6\xc6a\x1b*\x07A\x89\x80X"S\x11\\B4\x04\x8c\x9c\xaf\x8504\xc4\x8fb:f\xb7/\xa1Y\x9ewPo3~\x9b"\xdd\x97\xe9\xed\t\xf4\xea\xa733\xfd\xdaF\x9e\r\xe1g\x18\xf1mX\x19\xc6\xcaSO=U\xed\x8evO(\x9b\xa7\xf9|\xe9\x9a*\xb3T\xea_-\x02\xcbj\x97\xc0\xbd\xff\xf5\xaf\x7f\xad\xd3Q\x84\x06\xd0\xc9\xcf=\xb0\xb7\x1a\xb5\xbb\xb4\xcb\xf6\x05\xb6_\xbf\x9c\x0b\x83\xd0\x10\xd1~F\r(\xd0)\x16\x83\x10\xf6$\xb4\x14\xa6\xb7h~\x08\x1f\xa6j\xdck\xea\xe7\xda\xb9\x07<\x0bVK-h\xe9\x0c\x98\x18\xdb\xad\xb0)*\xc82g\xfd\xa4\x97\x06\x91D\xe0\xa1\xa5\xe2zJ\xfd\xdc\x0b\x9e\xc9V\xa2\xbd\xb2\xd7\x94\xb2y\xb6\xd4\x85y\x02\x8d\x87E\x0c\xea\xe7\x9cT\xc8\xfaB\n\xed\x8c\xfai\x93\x16\x06[\xec\x88\xd8N\x99\x16\x03m\xfe\x94\xbd{\x9ac\xc6u\x13\x8d=\xdb\x1b0\xfc\xe7O|\xb0v\xb9\x99f@\xb7\\\xd1\xa2\xdb\xab\xe6\xcb4\x17X4`\x8a\xc8"F\xaa\x91RB\x0b\x01CG\xb3\xd3\x1a"\x1e\x9c\xbe_O\xddK\x87\xefO4\x1e\x95\xffb\xa4\xa1!\xb0R\x84\xdaL\x03\xfa|~\xb1\x8e\x80\x8c\xf0D\x7f\xc4\x90\x8c\x83"\x9d\x88\xc6\x10o\x1b`\xf5\x89\xce\xfa\xe7?\xffY\r\xb8D\x1c\xb5\x9d\x0cAu\x8e\x08,\x04bL<\xaa\xb8\xfa\x01\xa1\xd1\xbb\x13\xf1\xb0\x8a\xb5s\xd0\xe9)\xf7\x86\x1bnPc=0]\x8a\xdf\x12\xc2\xea\xcfO~\xf2\x13s\xf1\xc5\x17\xeb\xb9\xb2Z\xc4\x8a%0\x15$\x1e\x15\xe1e\x1a\xad\xdf\xbf\'\xfd\xba\xe6j\xe7\xf9l\xbe\xb7\\\x8f\xa0D\xdb\xc3\x80\x8b\xa1\x1a\x9b\x1f\x820~\x1f\x1f~@LE\x88\xc3u\xf5\xd5W\xebj\xd9\xcb/\xbf\xac\x9fa\x8f\xfa\xdd!\xbd5\xbc\x0cS1\x04<u\x06\xcf\x81\xfa\xd1p{u\xcc1\xc3\xfb\xe6\x99\xe9\x0bJu!\x01\r\x13\x8d\x0f\x9b \xf7\x18\xa1LG\xb6\xda\xa3\x85\xa9<\xd39\x84\x05\xb6H\xc2\xd1\xd8p,h\x95\x08\xec\xb1\xf2\x1c\xaa\xa4\xee\xc6\xeag\xbf"\x9b\xa3\xb1\x1f"\xb8\x11\x06\x0c:\xd4y\xdf}\xf7\x99\x11#F\xe8\xa2\t\xed*~\x1f!m\x03\xfb\xe1\x19g\x9c\xa1\xb6H\xf6/\xf2\x0c\x00\xcd\xec,\x190\xd1\xb0\xd8G\xc9s\x8d\xaf\x9f)&/\xa6|\x0c^\x8bD\xdbB #\xb8\xa9\xeb\xae\xbb\xee\x8af;B\xeb\xb7\xb1\xde,hBh\xc5\xd8\xe2\xb8~\x04\x1e1\xc9h\xaf9\x99\xe9f\xe2\x84\x9e\xaaeRoc\xf5\xd3.\nDs\x1b-\x837\x82\xd3\x06rD\xf8b\xe3d\x00M%Rjzx\xe5\x95W\xaa\xf0\x00F\xd8?\x1d\xd5_\xd5aF\xe8\xe6\xc0\xc8\x8a\xf0\xfa\xef\x9b\xcb\xcd\xcb2U\x82Q\xa3F\xa9m\x83Q\t\xdb\x10\xc2\xc8\nD@\x15Gh0\x1a\xf2\x1d:\x18B\x93\x86\xc3\x08~\xc9\x91\xfd\xa4\xc3\x16\xe8\x08\xd6\x1c\xf2smd\x8f|\xb8\xc2<\xf2\xbeg\xcbAX\xd0p\xb0\x11\xa1}a\x1c\x0f6Z:U\xaf^\xbdt*K\xa7\xc2\x80\xfc\xd3\x9f\xfeT\xa7\xc8\xac\xe6\x9d\x7fH\x1f\x8d\xf1e\xc307G~v\x86y\xf1\xb3\xd5\xe6\xce\xb7\x96iCfe\t7\x01\x84\x06\x1d\x06\xed\xc5\xda\x99\x00A\x86\xd0\xa2~\xa6T\x18\xcf\x11\xa0\x08\x174\x8a\xb3\xf6\xef-\xd3\xa2\x8e:\xed\x0c\xd3\x8a8\xe7I\xb3\xd6\x9b[_^\xa2\xab\x95hY\x84\xd6aq\x82k\xa2~\x84\xa9m\x92\xdcs\xec.L\x89\xb9Gh\x84\x080;-\xc4\x80ML\xb0\xd0\xf5\xcb\xf5\x7f\xbe\xa0\xd8\xdc\xf4\xc2b\xd5h\xb8\xbfh\xcd,h\xf0L\x99\xae2\xed\xe2o\x0b\xd3Q\xea\xe7_\x9e\x11\xf5\xdb)%\xda\x15QG5\xbcN\x88\xfa\x99\xf2\xa1\xe9\\\xfb\xecB\xb3L\xb4)\xae\x0f\xdb\x92uY@\xe3\x8a\xdf\x80\x8e\r\x8eY\x01\xcf\x81\xf3b\xc5\x12\xc1\r\xe3EX\xa2\xe5F\x10\x8c!\xeaG\xf3\xc7\\q\xcds\x8b\xe4<\xbc\xc1\xa9%a\xa3\x7f(RFh\xa1\x01\xf0\xc0\xac\xe1\xf1\x17{v7?\xdb\xa5k\xccjSs\xf0\xd0\xbe[Yi\xfe\xf4\xd8<\xb5\x97\xd0i\x10\x04,G7\x07\xea;+_L\xcd\xe0\xd0\xb1\x9d\xcd\xa9\xfb\xf4\xd4\xd56F\xb70\xe0\x9b\xb4\xa6\xb8\xc6\\\xfa\xe8\xfc\xa8\x9d\x82Nc\xfd|\x9a\x82\x06K\\w4# x\x1cZ\x160\x9a\x86\x81\xe9R\xa5\x8c\xc6\x7f~|\xbe\x1a\xf8\x81\xe96\xbek\xcdA3aZ\xfe\xa7?\xfdI\xdf\x13\xd3\xea\x92\x9f\xf6W#2\xdaL\x18\x9892p\xfc\xed\x99\x85\xaaq\x02\x83\x10\xca>\x1d\xb89p+`\xd0\x00\x02\xe1]q\xcc\x00\x8d:k\xa7\xf0\xcdA\x15l6\xc6m\xe1\xcd/\xbd\xd5c4("\x89\x86\xd9\xc3I\xc0?"\x85\x02Z\xde\x95\xc7\x0e\xd0\xc5\x17;\x85\x0f\x03\xd3\xb9\xbb\xdf^n\x9e\xfa\xd8[@aE\x99\xd5T\x06\x85\xe6\xc0\x8e\xc7t\x8e\xb6\x88\x00\xbe\xfc\x98\xfej\xc7\xa5\x0f\x84\xa5P\xea\x7fj\xca*s\xcf\xdb\xcb\xb4\xdd\xa2E\xb2\x92i\xb7\x98\xa5\x02\xbe\xc9z\xf3\x87U\x1a\x1bZ\x84\x06\xc3J\x1f\x8d0\x11\x91\x8bv\xd1\xbd\xbd\xf7[@E\x0f\x1bD\x8f\xbam\x94N\x1a\x1e6\nl\x16a\x05\x160-\xed\x90\x9fav\xf0\xe3q\x01\x06\xf50\xa0\x01a8\x07\xdc\x00v \x1e\x96t\xc0\xb0\x02\x0b\x98&\xe5f\xa7m\x14\x8f+\xcc\xb8\xc5\xb4\xcd\x0e\x18\x08\x9e\x1d\xb7j\xaf\x1d \xac\xc0\x02\xbe\x9a.\xb2\x01\xed\xd0\xca(\xee\x7f\x98(\x05h\x1f,\\Xv\x94\xfb\xcf\x82IX\x81\x05\\&\xe7\xb0\xc3V\x85\xd1\xc5\x02\xca\x0cj\x97M\x11\x8c\x87\xc5\xa2\x07\xe1\xb7\x13\xa9\x1f\xb8_\xdb\xcbt\x16\xe7b@\x10Y\x9bbsP?\x02\x0bF\xc8\xa0\x81\x9d4\x91\xfb\x0f\xd5\xf2\xfd\x11}\xf3u\xf1\x06\xd0\x1a\xd10S\x89\x94\x11Z\xd8\xb3\xaco\x15>U\xdd\x92h0\xf8\xbf\x10\x92&\x99xXx\x19\xdb\xd0"\xdd;f\x99\xde\x9de\x84\r1-\rB\xfdL\x11\xb1\x01Y\xc2\xc6\xc3\xc2\x06dW\xfa\x98\x9a\x0e\xec\x86_Yb\xf5\xd3i\x118\xdb\x04\xea\xa7\xc3\x84\xf1\xf1\xc1\x06d;\x17\xab\\[\xf5\xc8U;N\xa2\x10]\x03\xb7\x00|\x8f\x80\xeb\xb7\xae\'M\xc1\x00c\x07-\x06\x8b!\xbd\xf2\x92\x8a\x94\xc0op\x8b(\xcc\xf5\x84\x06\xf74\xb8\x82\xdc\x18\x08\xf6\xf8xX*x\x13<\x05\xfc\x00Y\xbc\xe0\x19\x02\xd3\xe1\xa0I\xa2)\x82\xf5\xe3\x9a\xc1=L4\xbc\x12\xf5\x13\xfd\xb4G\x07o\xeb\x15\xcf5\x8c\x9f\xe3\xe6D\xca\x08-l=\xd6H\xdd>7\xc3\xb4\xcb\x95\x07\x96\xe0(\xc3\xb7Y\\BpY\xc26\x18\x8c\xa6\xf6\xbbhZ\x1dd\xa4L\xb4\xc1\x00\x0e\xa3\xac2Z\xb0\x93\x84\x81\x8ee\xdd#\xd0\xb0:\xe5\'\x17\x0f\x8b~V(\xf5\xb3\xb2\x04\xd4\x1fF\xd3bzn\x1b7Z\n\xdan\xe2"\xcb\x03\x81a5\x1d\xeei\xd0\x86\xd3\x18h\x18v\xd0\xc0\xa5\x85\xfa\x93\x81+\xc5/+G4N\xa0\xd3\xc6/~4\x04\xd3s\x16j,\xacT2\xa5M\xf4\x11p\xab\xf3\xa4n\xeb\x16\xc1\xbd\xb7\xae3\xcd\x11\xac\x9f\xeb\xd7}\x8b\t\x9e\x00\xe6\xba\x1c\x19t\xb0/Z\xc2\x08\xed\xcd\x89\x94\x11Z\x18\x85-<\xf8$\xe4\x85\x87<g\xaf\xb9z\x84\xb1\xa5\x00\xdf\x0b\xc6\xa3JF`\x00\xb5%[\xbf\xbd\x07\x11\xf9/\t%#\x8a\xd6\xe8W\x1b\xbc\xafM\x11\xbc~Ht\xc0\x08\xa2N\x01~\xfd\x94\x1b\xf6\x1e\xd4\xd7\xef\xa5UK\x16\xa91\xda\xf0\x13\xa9?x\xaf\x92P2\xa3P\x1b\xe7`I\xa6~\xae?\xd9>\xa0\xf5\x07\xea\x0c[\xff\xe6B\xb8\x16\xbb\x19\x80\xa1\x10\xc39\xe0\xe9\x8d\xffL2\xf1\xb0\xb0k\x05\x9d%\xc3\xc6\xa3b\x15\x87\x15,`\xb5\x0e\xc7\xd3M\x19\x8f\x8b\xa5w\xbb4\xcdj\x95\xc6\xe3J\xe2\xe9!\xf0\xf0\xd4\xb7\xb6\xb0\xb0\xf1\xb00\x14\xe3\xd3\x04LK\xb9\x86\x04/?\xcaz\xb9wv\xaf\'\xf5\x871\x82\x07\xe3q\xd5\x8a\xba\x80\xd3h\xa0\xdf\x87\x86g\xb0\xa1\xa2&\xba\xe2\x8a\xaf\x12\xab\xc4\xcd\xc1=\xb2\xa1}`mI\xb5\xde\xcbD\xfb;\xe1pJ\xa4\xed\x96Vym\x80r\xb9\xb60\xb0\x92l\xe1\xfakDj%\\\xbf\xfc\x00gi\xda\xaf%\xd5\x1cLSFh\xe1\xd3\x83\xe0\x00\x1c\xefp\xfed\xd9=\x11\x98\x12\xe1\xac\xf7\xf5\xd2z\xc3/\xcb\xc9a@`X\x7f*\xea^\xbc\xa62:\xc5\t\x0b#\x1a+M\xb3\x92\x88\xc7\xc5\xb5\xdbN\xbb\xae\xa4\xd6\xcc\xff\xbeBW\xee\x12\x81\x06\xce\xe8\x1c\x8c\xc7\xc5r~\x18\xa1\x813\xaa\xed\xb4\xb8\x18\xb0\xfah=\xef\xc3\xc2\xb7\x11\xf4_-.W\'_\xc0\xdd\xc2\x0eFM\x81`\xb1\xf1\xb0\xd0rf\xcb3\xf4\x1cY\x13#K~\xf3\xf5\x92\xf2\xa8\xd3(\xbb\x13\x18\x10\x9a\x83g\x17\x8c\xc75k\xa9\x17S,\xd13 L\xf5\xb7\xcb+t\x15\x19p{\t\xbbr\xc7N\x0c\xcbliC\xdc\xc3D\xb5$\xea_\xb0\xcas^\x06v\'\xd8v\x95*\xa4\x8c\xd0b\xeb\x8a\x150xJ\xb3\xa7\r\x15;\x91g\x86-\x04ogb)\x01#\x0c\x8e\x93a\xa0sq\x0e@\x83\x9f\xb9\xb0L\x8d\xca\x89\xd6\xcf\xb9\xe3\xe0i\t\x1b\x8f\x8b\x86e\xb39\xb3\x97r\xba\\C\xc2\xf1\xb8\xe4d\xd9\x9e4\xf5\xdb\xc4\xeb\xa7c\xdb\xc4\xb4t\xd6\xe9\x0bJD[\x8aDmca S3Z\xda\'\xdfl\x10\x1d\xc5\x83\xfb\x1ff\xb9\x1f\xa1\xc5\xf6\x1d\xcb\x17\x0bJMqY\xad\x08\xdc\x04\xea\x97\xaf\xb2\x82J<2\xeb\xa6\x80\x0b\x81\x1d\x8c\x9a#\xd8V\x88\x87\x86\xe0\xc9H@\xdd\xb5\xb7\x8a\xe7o=\xdd\x89\xba`\x83#6\x07\xf5[\xad\xf0\xab%\xa5\xease\xb7\xac\x85\x81\xeai\x03\xb4\x7f\xbb\x8f\x93\xd0Id+O%R\xc6#\x9e\x87\x85!\xd2\xba(\xacX_\xad[3\xd8F\x11f\xd9\xd7\x8e\xca\xc4\xa2\xb2\x9a\x0e\r\xe6/\x7f\xf9\x8b\xfe\x8dA\xf8\xc3\x0f?T\xc7=\xfe\xc5\xe9\x94\x95-\xd4w\x1a5\xffb\x8c~\xf1\xc5\x17=\xa3\xach[lOa\xebF\x98U,\x1a,\xab=OOY\x15\r\xa2\x87\x96u\xcd5\xd7\xe8\xf4\x80e\x7f6\x11\xb3\xac\xcd6\x15\x9c>Y-\xa2.;-C#"\xaa\x02\x86c\xbc\xba\xd9\x1c\x8e\xbfR\x98\xeb\xe7\xeaI\x86\xf0\xf2\xe7kt/$\x82\x87r\xa9\x1f-\x0eC7[S\xb8~\xea\xc7\x91\x94\r\xbd\xac\xec\xa1\xe52\xa2\xa3m\x91l\x95s]+SL\xb6(\xb1E&\xec\xb2;\x0b\x188\x97\xbe\xf4\xd9j\xd5\x96\x10\x84\x7f\xfd\xeb_u\xda\x83A\x9a{N\xfd\xb8!p.8\xdbb$F`s\xedx\xc7\xe3\'\xc7\xb3\xc2D\x80\x97\xf9v}\x0bB\xd7\x8f\x07\xfbg\xf3J\xcc\x13\x1f\xafT-\x05\x87\xdd?\xfe\xf1\x8f\xea<\x0c,\xffs\xffI5F\xfd\xb8\x02\xb0\x00\x83\x96M\xfb\xe3~\xb1\x1b\x80\x05\x01\x9cc\x89\xbc\xca\xae\x08\x16d\xc2\x9c\x01\x0b\x00\xec\x03|\xf0\xbd\x15\xba+\x81{\xfa\xbb\xdf\xfdN=\xe2\x01\xe7R[?\xae\x108\x1e\xb3\x00\xc5u\xa3\x8dr\x9f\xf8\x8cUTV\xce1u\xb0\xc9\x9drx\x9e\xcd\xc1\xaa/\xdb\x93\x88\x16a\xc3\x1b\xb1\x95\xe9\xa0\x83\x0e\xd2\xbfS\x85\x94\xf2\x88\xa7\xb10\xda\xdb\xa5_\x92}\xb2\xef\x8f\x87\xd1\x94\x83\x1d\xab,doye\xda\x1a\r\xe2\xc7\x03G\x08=\xf6\xd8c\xea\\G<,6O\xb3k\x9f\x0ea]\x00\xd0\x00\xf0\xc8&\x1e\x17\x0f\x97p48\x03Z\x8fd\xfc\xbd~\x7fp\x1f\xf5\x17*o\xc2\xfd\x01\x81\x8974\x1b\x97oyyqt\x94\xc5\xb1\x93\xfdg\xc4\xc3"&\x93u\xeb\xb0\xabi4T:\x0c\xc2\x8d\xef\x11\x13\x8b\xd0&\x9c7\xb0t~\xc1\xa1}52\x05\x9d\xa0\xb1\x07\x89\xbcf\xb5\x88\x8d\xc37\xfdo\xb1Y\xe5\x8f\xb2tX\xb6\xe7\xdcv\xdbm\x9a-\x1aO\xf3`<*:5S\x17\xb4L\xf6=\x12\xbb\x8bmLxq\x03\x02\x9b@\x86\xb8\x104\x15\x8f\x0b\x81\x8d\xc0\x9a\xbb\xbc\xdc\xdc\xf8\xc2\xa2\xe8\xc6a\xf6^\xdex\xe3\x8d\xea\\\xc9\xf6 \\*\xd8Jd] \x10\x14tX\xa6E\x87\x1cr\x88\x86Ua\xa3<q\xb1\x00\x9f\xb7\xf3\x0f\xe9\xab\x1d\x17\x1bUc\xab\xb9\xd4O\x1ba\xfb\xcc\xdf_\\\x1c\x1d\xb4\xd8\xc2\xc2\x96 \x06\xa2{\xee\xb9G\x854+\xa4v5\x0fA\xc9\xf4\tM\x88M\xd2x\x8f\xf3]\xee\x03\x83\t\xce\xca\xb4\xbf\t\xdbv\x90\xe7\xdft ?\xea\xc7\x0e\xf8\xcf\x97\x97D\x07-4g\x9c\x9b\x19$\xd8\xbclw$X\xbf5\xea\xc7\x8e\x8a\xb0\xc2\x13\x9f\xebF\x90\xe2\xe0\xca3\xa2]\xffjB\x0fs\xf8\x0e\x9d5\xa4MS\xc2\x9b\x15gvn\xdc\xfe\xc62\x8d\xd8\x01L\xf7\x11\x92<\xdfT"\xe5\xa2<\x10\x0b\xca\x06q\x03B\xba\xb0\x9d\x83\x08\t\x18\xa8\x19}\xec\x05!,\xa2\xf1\xb0\xa6\xaf\x95\x11fyT`\xd0\t\xd8\x80Kx\x9b0\xf1\xb0h@\'\x9cp\x82\xaa\xd2\xec\x17\xb4\xee\x07$\x0e=uBO\xd3\xbbs\x8e\x8e\xde\xf8\xc1\xd8;\xaa\xf1\xb8\xd4\xee\x95f\xde#\x1e\xd6[\xcbTC\x02\x1a!\x9b\x9f\x89\x85\x14&\x1e\x16\xa3)\xdf\xe7w\x08\r\xeb_6B4\x8d\xd3\xf6\xe9\xa9\x81\xfch\xb4L\xbf\xa2\xf5K\xd5hw\x9c\xc7\xa7\xd2Q\xfe+\xf5\xdb0)\xec;D\x10#\xac\xc2\xc6\xc3b*I\x87\xe1\x19XG\xdbA\xdd\xf2\xcc\xe9\xfb\xf6TgGV\xb4\x82;\x14\x10\x16\xf8\xa5a\xfb"\xbc\xf5\x7f\xdf\\\x1a\x8d4@G\xe19\xe2\\\x1b6\x1e\x16\xd1%x\x06\x8f<\xf2H\xd4\xd1\x95\xfc\x95\xd4\x8f\xe0\x02\x8dG\xe5\x9f\x00\xf5g\x896\x84\xed\xf1[?\x1e\x16\x82\x1b\xd0\xde\xd8\xcf\x88\xc3.\xf7\xc0\xb6\xa7\xa6\xc0<\x80\xa0E\xdb\xb2\xd9\xca\t\xabC<\xb4=\x86w\xd4\xfb\xbdq\xfd^<\xac%k\xaa\xcc\xbd\xef,\xd70G\x800B\xcb\xe29\x12\xc00\x8c\xdb\x07!\x8d\x88!\x86\x16h\xcf\x19a\xf8\xcb\xbdz\x98\xfdG\x15\xa9\xd31}\xc0\nO\xa9^\xef=\xc2u\x95Le\x1f\x9c\xb4\xdc\xbc&\xfd\xc0\xc2\x80Al\xadT#\xe5\x84\x16S#\x1a\x1b\xda\x81e\xdb>\xf9f\xef\x11\x1duC,{\x12yXtrV\t\xe7.+\xd3XX\x93Dh \xd0\x00\xe3+SC\x1a_\xd0G\x85-\x19\xec\x88\xa7\x91qWX!bT\x0e:\xb1\x12b\x19\xed\x87\x11\xcaj\x04\x04\xd2\x9b0\xd2\xc6\xe3\xca\xd1\xc6K\xfd\xac\xd0\x10\x1e\x97\x88\xa3\xc1xXt\x18\x84\x0f\xda\x9d\x15~\x80\xe0eSs\xae\x1f\x0f\x8b\xb0"\xd4\x1f\x8ct\xc0T\x06\xe39\xda\x9e=w\xe2q\xed3\xb2H=\xad\xfbw\xcd\xd1\x11\x98\xfa\xd1>\x88\xe7\x84\r\xe9\xcd\x19\xebt\xd5\x0e\x98\x0e\xa29\xd0\xf1\xad\xc3*\xe0\xf0\x88\xf0#\x9e\x14W\\&\x02\x1e\x83w04\x0eZ\x07\xf7\x80i\x8a\xf51#\x1c\x0c\xf1\xc8\xc6\x8a\xe0\xe0\xfc\x11\x14<\x04\x9co\x89\xec\x80\r\xe7\xf5/\xd6\x9a\x95\xc5\x9e\xf1\x17\r\x96\xf0*L\x7f\x82\xf1\xb0\x98\xbe\r\xe9\x99g\xda\x89 \x80J\xb9n\x84\\0\x1e\x17\x9a/{\x15\x99J[\xbf-6\xc2O \x1e\x97\x0c [k<.\xb9\x7f\xf2\x00Q\xbe\x89\'\x85\xfd\x8d\xd0@,\x9e\x00\x1a\x1c\xf5#0\x88v`A\x1bAk$\x92-\x17\xc0s\'\x9e\x18\xe1},\xdc;\xc2\xca\xb0C\xc3:\xdb\x928\x96\xcd\xfb\xbb\x0c\xf1\xe2q\xe1\x87F\xb7Bv\x10\xd5\xe1\xcb\x85\xa5\xe6\xf5\x19k\xcd\xb7R\x16\xf0l\x18\x00\xf0\x11\xe3:,\x08\x18\xea\'\'$m\x98)4\xf7\x8f)\x9d\x05;,\xdb\xd9\xb8o64\x0e\x82\x91 \x86\xbb\xc9k\xb8\xd4\xdf\xa1 K\xeb\x07\x84%\x89X\xde\x94\xfag\xfa\x11W\x81\x88%l\xd6F\x9bN5RNh\x01v\x86?\xfc\xe1\x0f1A\x00y\xc8\x08\x0c\xc2\xa3\xd0\xf9\xe8h\xcc\xdb1\xbc\x07\xc3\x8b\x10\x0f\x8b\x8e\x87\xc0\xb0\xd3\x00\xb6C\x1c2\xa6\xb3F\xefd\xaag\xed_\xfc\x8e0)tx\x84\x8e\xbdQl Fx 8hx\x16\x84\x1eN\x7f\x94Q\xaan\x11^\xfd\x1b\x02\xcb\xcbL\xf50~\xb2}&>\x1e\x16B\x8fh\x04vU\x8e\xb00\xfc\x1e;\xd0k\xd3\xd7DW\xdcX\xc5BS\xc2\xf6fC\xd4\x006&\x04\x1f\xf5W\xc8w\x8bE\xe8\xd9\x107\x16V\xab\x98\x96p\xeev\x87\x01\x9d\x9e\xebg{Q\xd7\x0e\xc4\xc3\xf2\xac\xbbhm\x84r\xf9\xe8\xeb\r\xe6\xa5i\xab\xa3n\x02\x08\x0e\xb4\x9e` =\xe0\xdc\xbb\xcb\xef\x8b\n\xb3t\xb4\'<0\x1d\xdej\x97\xc0t\x93NO\xa4\n\x1b\xbd\x15m\xe1\xa0\xed;\x9b]\x06\xb7\xd7\xdd\x06\x08\x0f@h`0FK\x0c\xc6\xe3BK\xc1\x80\xce\x06\xf7\xa0\xd0#\x0e\x17\x9a\x17\xff\xf2\x0c\x19\xb4\xf8}0\x08 .\x0e\x08\x0c\x04\xa6\xd5\xb0\xb9\xdf\xc4\xc3\xdacx\x07\x19\xf4r\xa2\xd9\xab\xb9\x06\x16N\xbe\xf8\xaeTc\xe3\xdbr\x98\xb6\xb3(\xc0\xf9\x07\xe3q\x11m\xa4\x97\x0c \xd4\xcf\xca.\xae%\xabE\xc3Y\xba\xb6^\xe8 0\xd9t\xce}\xb3\x02\x13\x8d\x8c\xcd\xcf{\x8b\xe0\xed+m8_\xca\xa1\x05\xa0\xb9\x92jm\xd6\xe22\x8d\x87\x15\x8c\xc7\xc5\xa0G\xdb\xc3\xf6e\xe1\xbc\xd1\xf8y\x9e\xc4\xd4\xe2\xb9\xe3\x1a\x81\xb0\x0e\xf6r\x04\x16\x11\x7f\xedj|\xaa\x91\x92B\x0b\xb0;aDf\xaa\x12\xec8\x8d\x81\x11\x19\x9b\x10\xf6\x11B|X\xefv\xecb?\xdf\x93XD9:2Zm\x0c\x90]lr\xc6\xa7\xe8\xddY\xeb\xcc=o\x7f\x1f\x9d^\xd2\xf0\xe8|\xd8Dll\xa7\xa6\xa0\xa11\xbd##\x0f\r\x06\xfb\x19 \xa8&\xee\xddC\xd3\xd4CpzKcfj\xc3J\x17\x81\xf4\xfe\xfb\xe6\xb2h@<lqL\xd5\x08\xf5kC\x177\x0769Fi\xec\'\xb6\xb3\xa3\x99\x9c*\xf5\x93j\x9f\xd5=\xad\xdf?\x01:\x0e\xd7\xcfB\xc3t\x19\xa5\xefx\xa3~zI\x84\x0c\xeclL\xed\xac\x8d\xaf9\x98\x8e\xdb\r\xc2,4\x00Q:\x88\x94\xc0^>\x84\x07\x82*\xd8"\xa9\x9fU\xda9\xa21\x13\xa1\x83\x7f\x81\xe9%\xb6%\xb4E\xec\x81a\x9a1\xf1\xb08g\xecRh\xca@\xbc/\xecB\xc4#c*O\xfd\xb4\x03\x8bu\xabAc\xbb[\xa6w\x9f\xfb+\xbfh\xcbl\xb6F\xdbaq"\x8cW=\xf1\xb0\x98\x923\xd8\xb0\xf9\x1a\xb0\xf5\xfdr|w\xb3\xb7\x08-\x84w|\xfd\xdc\x13\xda!\x83\xd7\x03\xef}\xaf\xb3\x06@p\x13[\x0cM\x9d\x18\xf9\xf1!}\x1a\x82\x01\x8bs\xc66F{LUR.\x08\xa0\x05C:\xa3\r\x9d\x10\x95\x19!\xc6t!\xbe\xf1b\x07@\xc0p\x99\x18\xb11>\x931\x07\x98N\x9c\xbd\x7f/\xd3\xa5\x89xX4"lB\x84\xa0A\x93\xf8T\x1a-#0\x8b\x01\xd8WX}d\xba\x83}\x81\xfa\xe3\xf7\xf1\xd1P8G\xe2a]r\xc9%j\x0f\xb3\x1d\x96=\x80\xbf!\x1e\x96t\\[?u\xc6\xd7\x8fk\x07\xd36\xe2f\x11\x1d\x81H\r\x08j\xa2S`\xdf\xc2X\xcducD\x8e\xef<\xacx\xa1\x15\xd8xX\xc4\x8f\xb2\xf1\xd1\xfbu\xce5\xbf\x93\xfa\x874\x12\x0f\x8b\xbf\xad\x10\xed\xd7%W\xe3w\xd1i\xd1\xb8\xb8V\x16(\x184\xac\xff\x16\x1d(~K\x8a\x8dR\x8a\x11\x9d\xc1\x02[\xd0\xe3\x8f?\xae\x9f\xa1\x15r\xfd\xac\xc0Q7\x9ad\xb0~^\xde=\x89\xe8\xb4\x7f\x1b\xd1\x84I*\x81\xc6\x85\x96\x88\xd6Fr\x11\x04\x18\xed\x81\xe9j\xfc\x96\x14V(\xd1\nm4\x074,\x1b\xf5\xb6}>\x19\x89z\xcb\xd4\xaa\xbdN\xc5\x1a\x8aG\x85\x9dP\xe3q\xc9\xb9n\xd7\xbf\xc0\xcc\x95\xe9>\xda\x1bB\x82g\xce\xfd\xc4\xd6\x85\xcd\x13\xcd\'>\x1e\x17Z\x19\xa6\x08\x84\x15\x83\x15\xe7w\xd5UW\xe9g\x08)"\x85\xec?\xaa\xb3\xd6\xc5s\x8d\xaf\x9f\xb6\xc6\x0b\xedi\xfb\x01\xed\xcc\x12\xd1\xda\x1880M\xb0\xb2\xc8\x14\x8f\x01\x8c\xeb\xa7l\xab=[\x08\xbf\x83VN\x84\x12B\xd00ps\xae\xa9L\xcajZ\xf1\xa0\xaa\xb3Dn5(\xa0\xc1\xa0Ya<\xc7\x8e\xc0j\x1d\xb1\x8b\xb8dB\x0b\xff\xf1\xa8\xfe\xba\xf1\xd7zg7\x05\xa3\x1d\xa3\x1eaE\x98*\x00#\'\xb6\r\xec\x02\xac\xfa\xb0\xb2\x13\x8c\x87\xc5h\xc6T\x8e\xce\xcdw0\x9e"\xe8\x10,\xd8o.<\xbc\xaft\xd8v\xa1S\x881mz\xe2\xa3\x95\xe6\x81I"\x9c\xe5\x18\x02\x89)\x06\xd35:,\x1d2\x18\xb1\x80\xc6\x89\xd0\xa4~\x04+\xae\x04\xac\x98\xd1\xb9\x98\x02\x9ew`o\x9d\x92\x84M\xe1E8\x94W\xbfX\xa3+P\x089\xa6Z\xd8d\x98\xee\xd2\x89\xa9\xdfj\x90@G\xc2]\x82\xfb\x84f\xc0\xf3\xc1\xd7\x88M\xc2\xdc\xcfS&\xf44G\xecH\n\xb1p\xe1\x85\xd0J0d\xdf\xf2\xf2\x12\xd5xq\x15A\xcbbP\xa0\x13S?\xc2<hT\xe7\x1e1\x95\xc7m\x05\xa1\x8e\x00\xb5\xb6\xa0\xa3w\xe9\xa2Fl\x8c\xd7\x08\x8b\xe6`\xfa5cQ\x99\xb9\xe1\x85E\xaa\xf1r\x7fYu$\x9a+uR?v\xae\xa0Q\x9dz1\tp\x1f\x10\xe8\\\xbf]D\xd8O\xa6\xa4\x0c\x9av\xb0j\x0e\x9e\xff\x82U\x15\xe6\x9ag\x17\xa9\x9d\x8b6\x8d\x00$_\x02\xd0\xfep\x87\x08\x0e\\L\x01\xa9?\xac/X*\xf0\xa3\x11Z\xcd\xc1\x121+\x86\xaf\xbd\xf6\x9a\xbe?j\xe7.\xe6$i\xb0\x89\xc4\xc3b\xaa\x86\x8d\xeb\xd2\xc7\xe6\xab\xad\x80F\xcbT\x83iWs\xa0\x81\xb1\xf2\xc4\xc8\x0c\x18\xcei\xb0\xdc}F\xd20`\xe0F\xcb\xf8\xa3\xd4o\xa7i\xac<\xd1i\x9a\x83\xc7\x8c\xa6\xc7\x94\x1a\x08\xads\xd1\xe1}D\x10\xa7k\xa7\t\x03\xf6uVb\xafxrA\xd4\xab\x1e\xcd\x91\x10\xc0a \xf2\'\x1a\x17\xa09^vt\x7f5\xfa\x87\xad\x1fA\x87\xad\xea\xba\xe7\x17\xe9\xe2\x06\xa0ArM\x08\xc8\xe6@\xc3C\xe3\x80\xee\x1d\xb3\xcd_\x8e\x19\xa01\xe9\xad\xad\xb09\xec\xc0\xf1\xefW\xebs_r\xef\xd1v\xc2L\xb7\x98\x92Z\x07Y\xc2 _q\xac\x0c\x9a\xdd\xf2T\xcb\x0e\x0b\x82\xfbA\x99&>\xfa\xe1\nm;\xcc"Hc\x16v;\xd8\x8f\x81\xe6\x9f\xf4\x8f\x04Fy;\xc2\x12\xcb\x08\r\x87N\x18V`\x01S\x08\xa6\tLg\xf4\xbd\x08\xa2\xb0\xf1\xb0\xd0\x04\xadk\x03n\x00,\xd1\xf3oX\x81\x05|\xb7}^\x86\xd9q\xab\xfax\\V\x087\x07\x9a\x98\r\xd3L\xc7gjL\x07\x08+0\x80\xaf\xe2B\xb2\xf3\xd6\xb1\xf1\xc0\xac_WS\xa0eX\xd7\n:?\xf1\xb8:\xe2\x18\x9c@\xfd\xdc*{\xeev\xb1\x04{ZP\xbbn\x0c\x84\xb6\xb5c\xc1Xy\xfe,\\$R?B\x82\xd7X\xb9\xff\xd6X\x8f}\xca.(4G\xd0\xf6\xc7T\x13\xa3{X\xc7X\x0bm`\xf4\x80\x025\xf6\x03\x8b!\xc1\xc5\x88-\x81-Fh1m\xb1\xa1Uz\x15e\xc9\xcb\xf3\xabJ\x04VsH\xcf5\xacW\x81\x7f$|<,\xea\xb6S\'\x04\x1f\xa9\xc2\x98b%\x02\xb6\x1d\xa6\xa8x\xe2[\xec\xb2{s \xb4\xaco\x17\xa9\xb6pMH\xf4\xfa\xbd9\xacW?\xdbA\x80\xfa\xc3\x08-\xec-6\x1e\x16\x1a\xe3\x90\x9e\xc9\xc5\xe3\xa2\x93\x13\x8f\x0c{\x10p\xff\xc3\x04\x11\xe4\x1c\x83\xfex\xc3z\xe5\xc9\xe5\xc4\x1a\xfd\xc3\x80\xedmH\x8f\xfa4e\x08\xacx;Vc\xc4\xd4\xdf\'_]S\x1as\x88m\x0c\xb6p\r\x14\xed\x0c{ \xd0\xae\x82n3[\x02[\x8c\xd0\xc2@i\x1b7\xf1\xac\xda\xe5g$\xa4\xe5\x00\xdff\x16\x82\xb6c\x897|6\x06\r\xdb~\x97\xed\x1c\xb8e$0\xc8GAV\xd8\xa8\x97\x10\xb6~\x84\x86u\x8f`\x8a\xc3\xaaY2\xf5\x03B\xcfn\x16G\x18\xc6/>4\x04v\x16kocE\x0e\xc1\x9d\x14r\xce\xd8\x03=\xa7]\xaf\xfe0\x8e\x99|\xc7\xfau\xa1\xa4Q\xbfWBb\xa0\xb1\xe1\x92@L*@\x83\x0c\xb3r\x08\xc1xXdIb\x81\'Q\xa1\xc9J*\x02;\x18\x0f+>\x19\xc9\x8f\x9d-Fha\xb4\xe4\x054\x94D\x1b\x8b\x85\x12\xfcb\x14[fs\xb4V\xfd@1\xb6\xdad\xea\x87\xe4\xeb\xf7V3\x13\xad\x1f\xa2\xdf\x95\x7f\x12\x1c/b\xf0\xea\xf7\x9an\xfcu5E\xf0{-\xab?"\x1d\'\xfcu[\x82\xf5\xb7\xe8\xf9\xcb\x7f\xc9\xd4\xffca\x8b\x11Z\xb8\x05\xe0\xab\x058\x8d\x96V$\x1e\x8f\x8bv\x82v\x86\xd3\xa4%\xac\x01\x94\xd53\x1b\x82\x84\xd5J\x1c_}\x17\xa0\xd0\xf0u\x1a;N\x8b\xb6\xd1\x87\xad\x9fkg\x95\x11\xd8j\xb2N\xae!\x84\xed\xba\x01\xd2\xbcxX\xd5\xde\xd4.l<.Vr\xf1m\x02\xa6\x858~\x86\x945\xb1\xc8o\xd8iPQ\xed=\x03\\\x1a\xc2,\xe1c(g\x05\x0f\x10X\xd4\xcf-L\xf4\x14\x10<%\x15u\xba\xe2\n\xac\n\x87\xf5y\n\xc6\xc3\xc2\xcb\x1fsC\xa2\xf7\x80\xfai\xbf%\x15\xf5\xdae\xaa\xc5\xc3j)[\x8c\xd0\xa2\xc3\xe23\x048\xea-[[\x99p<*\xc2\xb0\xb0\xa5\x86\xad-\x96\xb0\xf1\xb8\x10\x9a6\x88\x1fY\x93qV\xc4q2\x11h\xe0\xd8t\xf0\x90\xb6\x84\xdd\xecJ\xe7\xb6\x9d\x96 x\xf3\xbe/K*\x1e\x17/\x92\xceZ\xa1\xc9\xf5\x87\xd9\n\x82\xd0\xc2\xfd\x02\xf0\x87\x9a\x93d<,\xec@\xdc\x7f\x9b\xb6\x8d\xfa\xed`\xd4\x14\xf8+\x05\x97\xfdg-)\xf5\xb4\x95\x04O\x81gF,1\xbb\xcb\x01\x97\x96\xb0\x9e\xe5\xc1x\\\\\x03&\xcd\xa0\xf6\x15\x06\xe2a}\'m\x87\xcc\xdf@\xbb\x0e\x1bZ\xe7\xc7\xc2\x16#\xb4\xf0\x15\xb2!H\xd0Tf-)Ox\xa4\xa5\x8f\xe3XH\xc2W}/#<>Ba\xa0\xc1\xb2g\x0f\xd0\xb4\xf0\xf7\xc1\x9d(\x916\x8bf\x88\xcb\xc3T?\xfd\x16\x84\x8d\x87\x85\x96gC\xa0\xe0\xe1N<\xaaj\xe9w\x89\xc8\r\xce\x15\xa1m\xa3\x14\x00\xd7\x1fF\xd3@\x1b\xc0\x19\x18\x10x\xd3\xa4~\xcaJDp\xf1U\x84\xf6\'\xdf\xe2\xe0\xeb\x1d\xa3L\xb4\xd8\xe6@8\x04S\xc5\x914\x96{\x99P<0\xf9*\xdff/\xa5\xdd\xd2\x84\xe3\xaa\x1d\x0c\x9a#X\xff\x97\x0b\xcb\xd4\xd7+3\x91\xfa\xe5\xc5\x02\x08\xcfN#\xb7\n\xecL`/\xea\x96D\xcaz\xc4\xc7\x83\xa1\x9b%\xfd\x0f>\xf8@\xf7c\xb1\'\x8c\xd5::\x14#!#-\x8e\x9f\xd6E`\x85\x08\x1f\x96\x9dq2\r\xb3\xecL\x87\xc9\xc8H7ON^\x15\x8d\x14\x80\xd3*\xce}\xd4\x81A\x96\xdd\xf7\xd4\xcfy\xe0\xf4\xc9j\x1d\x9d\x05\x81\xc1\xbf\xac`\xb1}\x03\xc35\xc2\x8f\xac4\xecW\x0c\xb3\xecN\xdb\xce\xcd\xca\xd0XTD\x8c\x00:\x0b^\xcehQ\x18\x9a\x89X`\xeb\xc7\xbd\x82\x95=\x9c\x1e\xed\xb4\x90\xf3$\x1e\x95zSK\xa3\xef\xdb%W\xa34\x84]v\xc7E\xe2\xed\x99\xeb\xcc\xab\xd3\xd6\xe8\x14\x8b\xfb\xca\xf5\xdb\xf2q\xb4\xa5~\x1cNY\x8ag\xb5\x90\xbal\xa7\xe6<q\xb0eQ\x80\xe91+`\xdc\x83\xd0\xf5\xe7f\xe8v\xa6g>Y\xa5\xabx\x08BB\xe5Xm\x17\xe7J\xea\xb7\xf1\xd0p\x05\xa0.\x1cL\x99\xc2\xf2\x1c\x88G\xc6\xe2\x05{C)\x8fmTL\xf9\xc3\x9c\x01\xfb\xf9f\x8a\x96\xf9\xf0\xfb+\xd4!\x95A\x8b=\xb0v0\xa2>\xea\xc6y\x94]\x0f\xb8\xd8\xe0\x8ea\xe3q1=\xa6\xfd\xd1.\x99^3\x08\xe1>\x83\x10\x0fS?n\x16D\x1d\xbd?\x10\xad\x04O\x7f\x1cV\x81\x95T\xea\xe7E[\xb0\xc9\x7f\x99a\xa0\xe9\xfeXHy\xe7R\x96\x91\xf1t\'\xea\x00\xde\xd0v5\t!\x81\xc76\x1d\x86m\x16\xecSc\xbb\x03\x9a\x89\xcd\x1f\xc8\x06\xdd\xf3\x0e\xec#\x8d\xd7\x0b\xe9\xd1\x18h\x03\xe4\x0b|\xf7\xab\r\xe6\x9f//\x8eF]\xc0\xa9\x90\xec\xc4\x84\xf8`{\n\xf5\xd3H\xac\x0b\x00\xd3\x16\x1a*\x1e\xe9\'\x9ex\xa2z\xa3\xe3\xdch\xd3\xca\xb3A\x9bxP]\xdbgF\xcbl\x08FWV\x1c?\x9dWbnzqQt\x034\xc9S\xf1\xf0g{\xcas\xcf=\xa7\x8d\x96\x15B\xbb\x9aE\xa7F\xa0\xa0a\x92\x10\xf6\xb8\xe3\x8e\xd3\x84\xafl}\x81\x01]s5\x1e\x16)\xf3\x99n5\xd6\x12\x10\x98x\xc3\xb3\xef\xef\x86\xe7\x17\xebV\x128\xe7\x9cstk\x10\x0e\xae8n"\xa4X\x82\xb7[y\xe8(L]\x98\xc2\xb2\xef\x92mT\x9c3\xbf\x01\x84\x16\xf5\xe3B\xd1\\<.\xea\'b\xc2M/.\x8e\xee?\xe4\x9ax\x06\x08"B\xfc 4\x82\xf1\xa8\x98\xb6"\xa8\xd8\xca\x85\x030aX\xf8\xbeupe\x15\xd2\xcb\xd2\xdd\xbe\xc9x\\\xc0\x8a\x1dv\xa8\x7f\xbc\xb4$\xba\xff\x10\xefz\x12\x9d\xe2\x7fE\xb9\xecAe\x85\x10A\t\x08*\x04\x06Z6\x82\x05GX\x82X\xb2\xff\x91\xc1\x04?\xbd\xb3~\xd2\xcb\xec\xbb]\x91\n\xb1\xa6V\xb3Y\xf1e\xe7\xc0m\xaf.1\xef\xfa\xfb\x0fiWl\xc9BX\xb35\xc9\x0e\xd4\xecN\xa0[3P3\xb00-g\x839amR-JiC\xa4\xf4\x86i\xf6r\xb1\x9f\xcd\xfa\x1f5\x05\x1d\x08\xc1\x85\x10\xc1\x8b\xdb\xfa\xd6\x10Rd\xe2\xf8\x1e\xea\x19\x1d\x1f\x8f\x8b\x91\xd0.\xadO\xfaj\xbd\xb9\xeb\xede\xaa\xa1\x00\xd3"<\xec\x11\x00h\x18\xcdA\x03Bh\xa0\xceS\xbf]~\xc7\xc9\xf4\xd4\t=t\x1f`\x95\xd4\x1d\x13\x8fK\xaa&\x16\x12\x02\x98)\xd9\x7f\xdfX\xaa\x81\xec\x80H\rxc\x13\x10\x10\xed\xa29\xd04\xd8`\xcdy\xb3_\xd1\x06Rd\xff\xe3\xe9\xfb\xf52\x83\x1b\x88\xc7\x85\xb0\xa0c\xe1\x1bF\x88^6l\x13\xaa\x05\x98n\xb3a\x97\r\xd3\x08\xec0\xcd\x88\xbaI\xebOt\x0e\xebh\x8b\xe0<c?\x19X\xfa\x15\xaaa:>\x1e\x17\xdb\x8dp\x91\xa0\xde;\xa5~\xc2L\x03\xfb\x1d\x89G\x85V\xc9\x86\xe50n\x17L\xe5\xec=c\x90\x03\x1cL\x89\xc7\xb5\x13\xf1\xb8\xa4\xbe\xe0\x96\x1e\xea\xb7\xf1\xb0\x88\x94p\xf7[\xcb\xcd\xe4\xb9^\xbb\xc1F\xc9N\x00\xee#\x9b\xe6\xc3\xb8=\x8c\x181B\x057\xf7\x8b\xe0\x7f\xdc3\xa2\xaf\xf2\xfc\xf7\x1a\xdeA\x07\xc7\x8a`<.yq\xefi\x03h\xe6l\x98&.\x1c0 q\xfdl\xc9"\xf3v\x18\xb7\x07\x16\x02\xd0\x0c\x89c\x166\x99\xc6\xe6HJ\n-\x1e\x14\xb3Z"~\x06!\x92f\xdf.9\xda\xd0\x90<\xabE\xc0`4\r\x8e\xa0\xc4b\xe2\x81\xd3h\xad\x7f\x0f\x1a\xcf\xbe#;\x9ame\xc4\xd7x\\\xf2s\x04\x05\xa1]\x08\x1e\xf7\xd1\x9c\xf5\xe6\x8d\x19\xeb\xa2+f6\x92$\xaa~p\xaf!\x1b\xaa\xe9\x84\x18K\x81UF\x0c\xceLe,\x08-~\xff\xf6\xdboG5\x12"\x90\xb2\x0f\x8d\xe9*\xd1&X\x8c\xa3~\xe2Y\xcd[)\xd3\xce\xb9\xc5\x1a\xbc\xcd\x1a\x7f\x19\xbd\xd9\xbe\x81\x87y\xd0\x1b\x1b/i\xa2E\x10%\x15J+\xea\xcc\xd7\xa2\x95\x04\xf7V\xda\xb0:\xd4o#\x03P\'\xf5\x13\x8f\x8b0=t\x14\xfe\xa3\x03\xcf\x97\xfa\xd1,\x98\x12Z\xe3/\x1a,\x9a\x0b\x82\'\xe80\x89\xe6\xc2\xb5\xa0\xb9\x02\xda\xe37r\xff\t\x8dl\xc1\x18N\xa4\x0b\xee\xbf\xbdwh\\\x84\x86a\x97\xc2\xc0\xee^<3`\x95q\xc1\xaa*3}A\xb1ye\xda\xdah\\)4(\xeaG\xb3c\xbf\x9f\x05m\x84\xedA\xeaG\'\x8f\x00\x83?\xf1\xc4\xac\xfd\x07\xd0<\x89~\x8b\xb0\xb3\xce\xbe8\x8a\xee;\xa2\xc8\xec8\xd8\x8b\x07\x86V\xc7\xd0\x85\xcd\x91\xedRL\t\x89zKY\xc0\x00\xc0\xfdg\x9aI9\x16\xee\x1b\xc2\xdf&b%\x9b3\x0b.\x84\x06\xb7`\x7f\xc3\xb6\xc5@g7\xee\xa3\xc5\xed\xbdm\x91\x197\xa4\xbd\x19\xdc3W\xf3Rj\xb7\x8c\xa4\xa9VK\x12\x8b\xd7\xe5\xf9\xb3Y\xdcB\x84\x11\xce\x83\xe7h\xa1\xddr\xfd\xb4CZ \xcdn\xd1\xaa\x8a\xe8@gAp\xb2\xf5\xc9.L\xa5\x1a)\'\xb4\x104l\x10eJf!c\xeeAc:\xa9\xd6\xd0I\x1e\x985\xee\xb2,\xbcpe\x95y}\xc6\x9a\xe8^5`\xc4\xa3\xf3\xa0\xaa\xdb@~@9\x04`\xa3\x8c\x12\x8d\xc7E,\xa2*\r\xc6g\xa1\xc3\xf3B-\xb7\xd3\x00F\xeb\x83\xc7tV\xa1\x83\xd3 \x8d\x97\x9b\xca\x94g\x894z\xec@\xbc\xec\x9d\xc6p\x8a\xa6B\xc7\rzS#<\x88g\x85\xe3g\x85\xfc\x16\xa1G,&\xab\xdd\x81\xed\xf44V\xbb}\x05au\xd0\xf6\x9dtkJ\xb7\x8eY&\x9b\xfdI\x02B\x96\x06\xfb\xfe\xec\xf5\xe6\xb5/d\xda\xea\x0bO\xa6\x0b\xec\xfc\xc7\xf6\x17\xdc`\x8d\xd0\xe7E\xa7C\xebZ/\xd3\xd0e\xeb\xaat\x94\xb7`\x9fa\xaa\x81\xdd\xc4j\x8b\xc4\x9e?pt\x91\xd9y\xeb\xf6\x1a\xcf\x8a\xd0\xd6\xa0\xf1\xb8\xe4\xf7\x1f\x8b\xd0}I:=\xa9\xab\x80)#Z\x8f\xb5\xfbY\xe8l\xbd:I\xfdr\xfdd\x82\xc5PN,~\x9b9\x06\xb0\x8b1\xd5\xe2\xb7\xb6\xd33H!t\t\x82\x87\x8d\x90]\x0b\x80\xd6\xbcrC\x95\xc6\x85\x7f\xf1\xb3\xd5\xd1i5ep\rhI\xc4\xe4\xb2p\xdd\xc4\xa3\xe2_V)Y\xb0Y)\x02\xc7\x06\x0f\x04\x04&\x02\x8b\xbam\xf4V\x84\x05\xf1\xb0\xf6\xda\xb6\xa3F\xec\xc8\xf7\x856\x8b\x05\x18\xdb1\xfa\xbf\xf8\xe9j\xbd\x16@\xebg\xd0c*icj\x01N\xbbl\xed\xe1yr\r\x08[b\x91-Z]\x11\xd0>\xe5Z\xf7\xdbO\xbd\xe0\xad\x99\x03v\x15\x81G\x14_\x06\xcdvy^\xfd\xfc\x86\xb6\xc3j\xf3\x0b\x9f\xad\x12\x01Z\x7f\x1d\xd8\xc2\x98\xa90\x85M5RNh\x11\x0b\x8ai\x89=\xed=\xa4\xa1\x9e\xb8G7\r\x00\xc8\xc8\x18\xd4j\xd0Xh\xd0\xf8\xd5\xbc>}\x8d&\x14@{`\x84bjG\xc7ez\x17fz\xc9\xc3=\xf4\xd0C5&\x13\x1b\x7fmgG;9y\xaf\x1e\xaa!@\x8d\x8c\xee\xf6\x0c\x90\x9d,\x91\xa3q\x10\x07\x89\x08\x11\xd6\x80\xcaT\x89\xcd\xb3\xc4\x96\xc2`\x1a\x06\xa2m2Js\x0f\xec\x96\x18"}\xfejBO3\xbcW\xbe^/\xd7_\xdf\xc0ez\'\xd7_)\xc7>!\x1e\x17\xe1\x9e}\x01\xc4J"v&\x0c\xe3\xc1\xc6\xdf\x14h(\xfc\x86s\xb6Sb\xee\xfb){{\xf1\xb0\xc8\x8c\x13_?\xf7\xdf\xc6\xe3bz\xb9\xc8\x0fdGd\x08"^0U\xb2S\xb5\xe6\xe0ya\x0fb1\xc3\xeecD\xd0\xfdJ\xea\xc7.\x85\x97>\x82*:\xbd\x93\x17\xf7\x9f\xf7D\xb0%\x1e\x97M\x1fG\xf4\x0f6\xb0\xb3h\x80\x8d1L7@K%\xc4\x0cu[\xbb$\xda%\x91"\xc6o\xdbA5&\x1b^\xc7\xa2Z\xbf\xb0P4\x9e{\xde\xf9^C\x0b\x01\xc2\x1f\xc1\x81\x1d\x8e\xc5\x910\xd3K\x06\xac\x89\x13\'\xaa\x81\x9fM\xd2j\x17\x93\x01\xe2\xf8q\xdd\xcc\xfe2h\x91u\x9d\r\xedA\xdb\x18\xf5#\xe8\x96\xad\xab4\x0f\xc9\xf4\xf2\xdd\xaf\xea\xf7i\xde|\xf3\xcdj\x13M5Rj\xf5\x90\x91\x9d\x86f\xa7\x15\xbb\x0e\xe9`\xce\xfcI/\x8d\x16\x1a\xb5G\xc9\xf3\xb2/+\xc4h\xb8#d\xea\xc7j\x11+\x7f<T\x1e\xfc\xd9g\x9f\xad\xc6Q\xecM\x18\xcf)?\xbe\xf1b;A\xb8\x10!\x81\xc4\x06\x18\x91\xed\x08K|\xf6\xdf\x1c\xd8G\x03\xd95\x15\x0f\x0b\xcd\x8fU24\xb2\xcf\xe6\x17\xeb\xf7\x18\xa9I\x16\xc1\xea\x1bac\xd0 \xa9?\xde6\xc3t\x06\xad\x80\xf3\xc4\x88\x8d=\x88\x103@h\xe8\xdf\x1d\xd2\xc7\x0c\x96)\x19{\xd2\xa8\xab\xa1\xfai\xb4\x83d\xda\xc0(\x8c1\x9f{\xc5\xb4\x92\xa92\x8b\x18L\x13tEs\xe5\xca\x8d\xf6\x11\xf2\x19\x0b\x18\x18\xf0\xb1\x85ax\xc6\xf0\r\xdd\xdbgk\xfd\xa3D`1\xd3\xc6&\x17_\xbf>\x13\xf9.\xf1\xb8\x86\xf4\xca\x93\xfb_\xaa\x8e\xbd\xd4\xc5\xaa\x1f\xf6\x18\x16K\xb8\xef<W;e\xb60\x15\xddi\xa7\x9d\xb4\x83\xff\xfb\xdf\xffV\x01{\xf7\xddw\xebgh$$\x96`Z\x85V\x13\x1f\x0f\xcb\xd6\x8fy\x80i\xff\x88\xbe\xf9\xa2u\xc8tQ4.\xb4T\xee;\x8b\x08\xd6\xd7\x8dE\x1c\xab=[\xb0\xfd\xa0\xd9\x9et\xd2I\x1a\xe2\x9b\x85\x8e\xeb\xaf\xbf^?c\x1a\x89=l\xbfQE\xba\xbd\xa6\xa1xXh\xac\xc4\xe3\xa2\x8d\xb2RI\xf8d"\xa0\xb2X\xc0\xb5\x12\xf5\x83h\xba\\?\xd3\xf5\xf8}\x8c\xb4M>g\x01\x87\xc1\x92\xfb\xc1\x8a)\xed\x05\x81\xf4\x8b={\x98#w\xea\xa2\x03$N\xc3\xba\x12\x1a_\xbf\xbc:\xc8\x94s\xb4h\xe2\xd4m#\xa0b\xb8g\x10\xc2>\x97J\xa4\x94\xa6\xc5\xf2\xbe\x8d\x1d\xd4U:\xcc\x9f\x8f\xea\xa7)\xb4\xac\xad\xa9)\x10\x1c\\\xe8m\xaf-\xd5x\xd9\x801\xdb\x86\xab%V:\xf6\x91\xe0^>\xa6\x02\xac<\xb1\xfa\x88\xa6\x85\x86q\xf2\xc9\'k\x83a\xff\xdf\xff\x1d\xd9\xd7l\xd7\xb70\xea\x1d\xdd\x14h\x1d\xd8j\xee\x9f\xb4\xdc<5\xd9\xdb\x03H\xd9L\x0fh\x88\x08,\x1a\x11\x9d\xd9B\x83E#@+a%\x92\x10\xcd\x18\xd31\xbab\xbf\xf9\xdd\xc1\xbduJT^Y\x17\xd5\xee\x1a\x83\xfa\xf3\xe47OOYm\xee{w\xb96d\x1a+K\xf3\xd4\xc1us.\xd6\xce\x03h\xa4L%\x99Nc\x8bA\xbbb\xf5\x95\x8e\xcb\xf4\x89\x0e{\xb0L\xcb\xc3\xc4\xc3B\xdf`\x1a\xc9\xbd\xe7\x19\xf0\xcc\xb8&V\xde\x08\x92G\x87\xa5|V`m\x93D\xd8"\xd0X\xf1B3A\xd02\xad\xb2Z\xe6\t\xbbw\xd3\x176;\xb9\x9c&\xb1\xf5O\xf9v\x83\xf9\xc7\x8bKt\xea\xcf\xf3E\xd3D\xeb\xc6L`\xedL\xc1x\\\x0c\x1a\xac\xd2a\x87\xc4\x96\x8a\xa6k5SBD\x9f\xb1\x1f\xe1\x8d\x10\x90\xcd=\x01\xcfv\x85S\xe9u\xcf-\xd6i+\xf7\x97\x95_f\x0e\xd4I\xfdLY\x83\x03\x07\xab\x9f\x98#xF\x80\xb6m\xddv\x88\xba\xfb\xbbCz\xcb\xb5\x896\xdb\xdc\r\x10\xd0\xca\xb0\x0b\x12\x8f\x0b\xcd\x0f.\xbd\xf4RM\xe3\x96J\xa4\x8c\xd0B}fJe\xa7\x05\xc7\xef\xd6M_\xc1\xd5\xa6\xe6\xe0\xa1\x91\xdd\xf7\xcf\x8f\xcf\xd3)#\x06y\x1a\x00\x9aLs\xa0\x8905A-\x87\x03Gw\xd2U/\xa6>\xf2\xbfP\xa0\xf1\xad\\_c.}t^\xd4N\xc4\xd4\x80\x10\xc4\xcd\xc1c"\xa1\x07\xa3-\x10\x1e\xf8\xf7\x87\xf6\x91\x86\xefM\xbf\xc2\x80\xad\x8d\xa9\xea\x1f\x1f\x9d\xaf#>0\xd5<\xed\xb4\xd3\xf4\xef\xe6\xc0xK\x04V\xc0~x\xe9Q\xfd\xb5#\xa2\xcd\x84\x01m\x00\xf1q\xe5S\x0b\xcc\x17\x0b\xbcE\x80+\xaf\xbcR\xa3\xc9\x86\x01\xad\x84A\x03\xb0\xff]q\xec\x00\xd3\xb90S5\xac0P?\x19kp\x9bx\xf7+/)\x07\xda6\xf7\x14\x01\xd2\x1c\xac\x94\x1ex\xe0\x81\xfa7v/\xea\'\x9al\xd8\xfau\xe0\x10\xed\x8ci\xf2s\x9fx\x03\xd7\xd1G\x1f\xad\xee\x1aa\xfc\xa8\xf0=C;F\xc02h\xfd\xf9h\x19\xd0D\xdbGs\x0e\x0b\xbevOL^i\xee{g\xb9\x0et\x0c\x02\xb8\xcb\x84\xf5\xea\xdf\x1ch\xfeIm&\xd8Q\x08h0\xd8\x92h\x04\x89\x88\\:w\xcf"\xc2\xe6z\xf1\xa0\xd0Xl\xe8\xe1\xe6`\x04\xb6I\x0c\x98\x16\xec\xb8U;\x11\x02\xe9\tEJ`\nST\x98\xa1\x01\xf8,v\xd4l\x0elh6\x16<\xc2gG\x11Z\x9cGX\x81\x05\x8c\xc6\xf8{\x11\x8f\xca\x12\xd6]\x01M\x08\xe3;\xe07\xb6\xd3\xd6\xedu\xd5-\xac\xc0\x02\x94\x81\xacLcv\x1eL\x82Q\xef\x18\xdac\x98\xd02\x0c\x1aA\xdb\x17\xae",z\x84\x15\x18@\xfdTK<2\x06\x10\xa0\xcc\xa0v\xdb\x14\xc1\x95\xba\xd12%\xeeMx\xa3\x04\xae\x9f\xdb\x8c[\x07\x0e\xa5$\xc1\x00V\x1f\xc3\x86\x17B+\xb5\x0bG\x08+V\x8a\x13\xb9\xff@\x1b\x18\xd9\xaf\xc0\x10b\x1c\xd0\xae\xad\xb9#UH\x19\xa1\xc5\xb4\xc1\xc6\r\xea\xd3%G#O&\xd2`\x80\x07\x86\xe1\x14\xfb\x92\xc5\xae@5\x07!\x82mh\x112\xc6p\x0eD=M\x04\x1a,~O\xdb\xf4\xa9\xaf\xdfNu\x9a\x83k\xb7\x0b\x06\x08m\x96\xe6\x13\x8d\xc7E\xa7A\xe0\xe0\xdaa\xa1\xfe0>N\xd8Z\xec\xbdB\xbb"^|M\x82\xf5\x033/\xea\xd74c\x02e\xc6\xdb\xb1\x1a\x82\xef\xd8`wh\x97\xc4\xd4\xc2V\x94(tr~\xdbN4\x0e\xe0\x9eZ\xd7\x8f\xa6@\xb0\xdb\xfaa\xb8\x94\xa1\x9ac\x82\xa7\x80\x1f\x1en\tdL\x02\xa6\xbca\xc3\x0b\x05W:\xb9\x06\xcc\ra\xa6\xa5A\xb0}\xb2J\xdeC\xda0`\xc7\x0b\xae \xa7\x02)#\xb40\xd2\xda\x15\x96\x8ey\x99\xa6\xbd\x08\x1f\x84@"\xf0ml18\xf4Yxha\xc0pk\xbf\x8b\xe0#Ig\x18;B<t8\x1b@\x0e\xc2\xd6\x8f\x81\xd8\nm\xa6\x18\x9dDp%Q\xbdj\x1a\\\xbfv8\x81\xfa\xc3hZ\x08\r\xdb\xb8Y\xa5#\x1eU\xe2"\xcb\x83\xa5\xfdD\xe3a\xf1\xec\xad\x8b\x05n\\\x1a\x04/\x89\xeb\xe7\'<?\x1b\x0f\x0ba\x1cf\xe5\x0e\x9bSL<\xac\x0e\xf8\xf3yv\xd2D\xe0\x991EC\xf0\xeb{)7\xe8v\xd3\x141\xf5\xcb\xf5\xa3q\'z\x02\x0c\x1ay\xa2m\xb3(e\x89_|\xd8\xdcI\x19\xa1\x15\x84>\x96\xc4 \xeb!\xcf\xd9NM\x80\x86\x17\x16k\xf7hI\xfd\xd4\x96@\x95Q\xe2\x05K\xd2\xd7/P\xbd\x8d<\x9a,-\xad?\xcd\x97\x9a\xdc\xff\xb0\xcf\xa0\xfe{\x89\x07\xcf\x0b\x82\xe1:\xd1\xebo\xfd\xfb\xdf\xb2\xae\xf7C?\xff\x1f\x92\x94\x11Z\xac\xa2\xd8\xad\x07%\x95\xb5\xea\xa8\x98\x88\xc0\xb1\xa0\x1dm\x08\xc4\xc3\xc2\xd10\x0c\x18*m4\x01\x8c\xd9xy\'\xf3\xe0Q\xe7\x83\xf1\xb8\xc2\xd6\xcf\xf7lh\x1b\x0c\xaf\xeb\xcb\x93\x8b\x87E[g\xe5\xccnR&\x1eV\x98\xfb\xc8\xa2\x05\x1b\x8f\x01\xd7\x06\xe2QYm-Q\xb8w\x95\xfe\x8a+\xd7\x15&\x1e\x16+}6\x1eW\xad\xa8\x0b\xd4\xaf\xbd/\th?v\xaf\'+\xb7a\x1c,9\xc7`<\xacu\xa5\xd5r/\x93\x88\x87%\xff\xb1\xda\\\xea_?\xf7\x9ek\x0bCl\xfd\xfe3L\xb4~\xa9\x8fk\xb7\xfe\x82\xc0\xb3M%RFh\xd1`\xad\xd0`\xd9\x96(\r\xd6q/,L\ryXl\xad\xb1\x90"?\x0cxq#8\x01_\x17\xce\xc1\x86\x1c\x0e\x0bSC|if/\xa9W\xc7\xc3\xc6\xe3\xe2\xda\xad\xd0\xa0\xc1~\xb7\xa2"\xe1\xeb\xa7\x83\xa11\x90j\xdfB\xfda\x84\x06\xee\t\xb6\xd3\x90\xf2\x8c\xbd\x80:=I\x00\xbe\x8d\xa0\xa5~k@\xc7\xed#\xcc>8:\xb6\x8d\xc7\xc5\x82\x06N\xa2\x89\x84\x95\xb1p\xcfx\xfe\x08.`33\x82\xab9\xe8\xec\xc1x\\\xb8.\xa0\xed$z\x06l\xf1\xf2\xb6\x16y\xab\xc7\xf8\x01\x86\xf5\x93\n\xd6\xcf\xf5c\xd3Mt\xe0dZ\x8e\xbb\x03;\x15\x80ve\xa3t\xa4\n)#\xb4\xf0\x95\xa2\x81\x03\xee\x02s\x96\x96\xeb\x03K\xe4\x91a\xfb\xe5a\xd9M\xb7,3\x07c\x1c5\x05\x0e\x88\xf8+\x01\x82\x8f@x4\xd9D\xda\x0c\xf5\xb35\x04\x07OK\xd8xX\xf8+\xe1\xe4\x08\xb8y\xb0\x81\x19\xfbD"\xf5s\xbf\x88f05.\x1eV\x18M\x0b\x8d\x0c\'S`\x80\x9f\xbe\xa0\xc4T\x89\x00N\xa4\xd3\xf0U:\x1a\x9b\xbf=\x91\xe5\xc5\x98\n\x13\xc4\x0fm\x88\xe5y\x0b.\x13\\\x8b\xdd\xb2\x15\x06\xeaG\xd0p\xff\xab|7\x01\xbc\xfc\xed`\xd4\x1c\xc1\xb6\xa2\xf1\xb8d\xf0H\xb4~\xee5\x0e\xb6\x84\xe6\x01vX\x04\x85QSP?\xbe{0sQ\xa9n1\xf2\xd73B\xc3\xc0\xc9^J\x9b\xe2\x1f\x1f8\xfc\xd0R\x89\x94\x11Z\x8c\x86\xec\xf9\xb2\xbc\xfa\xc5Z\xdd\x9a`\xf7\xb95\x07\x0f\x0b^\x9b\xbeN\xf7\xb4\x01\xfb\xff\xd8\x03\x17\x06:\r{\xbe\xacV\xf2\xf6\x97k\xcd72b\xe2/\x13\x06\x1a,\x9a\xc9[\xf2;\xbb\x97\x8eQ\x9e\xf0&a\xa0\xb1s\xfdV\x95\x9f\xf2\xcd\x06\x15\\j\xd0\r\xd1o\xf8\n\x1b\xa9\x89\xc55\xef{o\xb5\x0eow\xf6\xf1\x85\x85\xefZm\xf7\xcb\xc5\xa5\xe6\xe3o\x8a\xb5~\xae-\x0c\xb8hL\xfd\xb6\xc4|\xe9\x0f\x1a\\\x0bB3,\x08-;E\x9c\xbf\xb2\xd2\xbc3k\x9d\xde\xffD\xea\xa7\xb3s\xef\x00\x01\xc0\xa0\x11fz\x08l}\xc2\xd1\x13\xd8\x04\xfd\xea\xf4\xb5\xfaL\xc3\xd6\xcf\xbd\x9a\'\x1a\xea$\xdfG\x0c\xb8\xa7a\x846\xe0\x19o\x0392\xc5~\xe9soa\xc6\xb6\xed\xe6\xe0^-\x97>c\x9d\xab\x81{\x9aj\x91OSFh\x01\xbb\xd3\xadg\xf0\xfc\x95\xe5\xe6\x91\x0fV\xea\x88i\xa3\x024\x06\xa3!\x0fl\xd2\xec\r\xe6\x8d\xc0\x03#DG"\xf3\xf9\x9f\xff\xfc\xe7\xdap\x80\xe9\xe9C\xef\xadP\xfbXs\x82\x0bm\x84\xec)\x8c\xf0\xff\xfb\xac>*\x04\xd7c\xa7|a \xb2\x01\xbb\xfb\x01\x8d\x8d\xa4\x9d\xcb\xd7U\xab\xa7{S\xcd\x96N\xc5j\x11\xd3\xb2g\xa6\xac\x8a\xda\xb3\x88\xf1E\xf6\xe1\xb0\xb0\x9d\xc6:\xc2\xa2\xe5<\xfc\xfe\xf7f\xfe\x8ar]\xcdl\xaa\xe3j\xfdr\xfd\xdf\xc9\xb4\xe4\x89\x8fVDw0\x10_\x8c2\xc3\xc2\xb9Z\xe7R\xdcM\xc8\xb6\x8d\xe0\xe6\xde6\'8\x10\x18+6T\x99G\xe57V\xcba\xc0\xc2\xc3<,L\xa3\x88I\x05\xd8&\xc94>y\xce\x06S e7\'8h#\xb4\x95\xc7\xa5~\xda\x0e0h\x12\x13,,\xb4U\xb6SYh\xcbo}\xb9N\x9f\x7fs\x1a\x1f\xae6\xb8\xc8<\xf5\xf1\xaa\xa8c1m\x8f\xbd\x94\xa9FJ\xed=\xb4Fc<\x93\x81\x9bO\x04J\xfc\xae\xd4\x8dA\xfa\xa2\xdf\x1f\x15\x1a\x12\x0f\x14\xa1\xf1\xce\xcc\xf5\xe6\xae\xb7\x96iR\x00`\x84c\x0fW"B\x0b\xdb\x0b\x86c\xf6\xdf\xb1TM\x04\x06\xc2\xb5P\xbfF&\x10\xd1\x11t\xc3\xa0\x1d\xa1\xdd\xe0\x85M\xc4\xcd\xdb__\xaa\xbb\xfe\x81h\x97\xeccL\xc4\x13\x19\x8d\x80\x86\xc6\xde?\x96\xe9\x89\x00\xb0xu\x95\x86C\xc1Y\x90{\x13\xac\x9f\x8eLga\'\xc0\x0c\x99\xce\xb0}\xc6f\xa6f\xaaM\xa4\x0c\xab\xb9\x84\x01-\x13\xbb\x12\xa9\xe8\xd9\xd2B\xe7Gkc\x0fd\x8f\x8e\x84\xd4\x89\xcd\xe3G\xfd\xd4\xcd9`\x03\xfb\xcf\xeb\xcb\xcc\xd72\xad\x07\xa6d\xc4B\x0b\x1b\xe3\x1eX\xbde\xd0\xc2!\x95\xadD\x18\x941\x13\x10\x19\x01\x0fy6l\x07\xddP\xe8\xc6\x0ch\x08\xac%k\xaa\xcc\x1do,\xd3P\xc9\x80i\x80\xd0F\x84\n\n\x0b\xf7\x17\x1b(\x91I\xf1\x1bd\xaa\xcb@\xd0\xadc\xb6\xee\xeb\xc4^\xc6\xfd\x0f4A=\x86P]UR\xa3\x1b\xa6\'\x89vh\xe1\xf9\xdbA(,\\?\xdb\xcd\xf0\xd9\xc2\xb6\xc7T\xafc~\x86\xd9J\xda\x00\x89t\xe5\x94bV\x16\xd1\x04\x19T\x8a+\xea\xccC2\xc8\x04\x07Mv7\x10\xdf,\xd5H\xb9p\xcbh:8\xe4\xe1!\x0fs\xa53,\x90\x11\x9c\x0e\x83\x971\xc2\x83\xd0,\x08\x0b\x1a5\x06\xcbg?Ym\x1e\xfbpE\xd4\xf8\x8a\xf1\x93\xad\x13a\x8d\xf0A\xd8\x07\x18\xf4\x0eg\xf3\xe97\xcbe\xe4\x92\x1eR\x98C>\xc1L\xed(tTV\xd9\xe8\xac4\x94\x07\'}ol\x88\x19\xa6el\xfaM\xa4\xc3X\xe8\xe4LklfkB\xc7\xcc^R\xae\x8e\x96\x84\x03&\xac\x0e\xa3*\xc2\x82\xfe;O\x04\xfb\x1b2\x95\xbe\xff\xdd\xef\xa3q\x95\xe8\xb0l>\x0ek\xcf\x0b\x821\x9e\xe9\xc4\x8b/\xbe\xa8\x82\x1b\xc1\xf9\xe5\xa22Ct\x0b\xee9\xa1}\xe8$\xdc\x03,\x8e\x0bWW\x98w\xbeZo\xee\x93\x0ek\xe3Q\xc1u\xd7]\x97\x90\x96aA\xd8!p\x198\x10\xdcd\x06"f:\xcf\x9a{N\xf8l\x84\x04\xf5\xa3},\x15a\xf5\xa1hC\xd4\x1f\x8cGE\x87\xb5ZS"`\xa6\xc0\xb6I\xa4\t\xfc\x9b\xd8w\xf9\xc5w%\xa6\xb8\xdc\xd3\xf8y\xfeh\xb58\xcf2Xa;b\xc0\xba_\x9e\xbf\x9d\x96\x02\x1b\xc0\xff\xf4\xa7?\xa9 L\x04\x06N\xda\r\xcf_}\x17\xe5\xbec#[[Z\xad\xed\xbe\xa8 \xc3\x90\xd7\x93\xfai\x03<\x9f\xcf\xe5\xfc\xd0\xca\xdf\x99Y/0\x89\xb8K0\xca\xb0S\xe3\xcd\x8aH\n"\xa3l\xe4\xb8\xe3\x8ec<\x89\xbe2\xd3\xd3"\xa2qDv\x1d\xd2>r\xd0\xf6\x9d"{\x0c\xef\x10\xd9\xae_a\xa4C~f\xcc\xf7d\x8a\x11y\xeb\xad\xb7\xfc\x92\x92C\xb4\x8c\x884\xf8\x98r\xa5\xedE\x06u\xcb\x8d\xec2\xb8}\xe4@\xa9\x7f\xafm:FF\x0f(\x8ctn\x97\x15\xf3\xbd\x9e={F\x9e|\xf2I\xbf\xa4\xe4\x90\xce\x1a\xf9\xe3\x1f\xff\x18\x11\xe1\x15Sv\xbf.9\x91\x9d\xb6n\x179`tQd\xef\x11\x1d#c\x07\xb5\x8bt\xef\x90\x1d\xf3\x1d\xd1V#\xb7\xdf~\xbb_R\xf2\x88\x96\x12\x91\x0e\x1cSv\xaf\xa2\x9c\xc8\x8e[\xb5\x8b\xfcdT\xa7\xc8\xbe#\x8b\xf4\xef^\x9drb\xbe#\x9d$\xf2\xd7\xbf\xfe5R[+b\xb6\x05\xdc\x7f\xff\xfd\x11\x99\xae\xc5\x94\xdd\xad}\x96\\s\xa1\xd6\xfd\x93QEr/\xda\xcb=\xc9\x8d\xf9\x0e\xaf\xdf\xfd\xeew\x91\xf2\xf2r\xbf\xa4\xe4\x10\xa1\x1d\x11\xe1\x19S\xae\x08\xac\xc8\xf6\xf2\xcc\'\xc8\xbd\xdf_\xea\xa7-\x0c\xec\x96\xa7m#\xf8=\x99\x92E\xd6\xad[\xe7\x97\x94\x1c\x1f|\xf0AD\x06\xf0\x98r\xdb\xe7eFF\xf5/\xd0\xb6G\x1b\xa4/\xd0\'D\xdb\x8a\xf9\xde\xe1\x87\x1f\x1eY\xbe|\xb9_R\xea\x91\x92B\x0bht\x17]tQDF\xfd\x98\x07\xd2\xd8\x8b\xcer\xd0A\x07E\xa6O\x9f\xee\x97\xd02jD\xb5\x10\xf5^\x85PC\xf5\xc5\xbfdD\x8d\xec\xbe\xfb\xee\x91\xf7\xdf\x7f\xdf/\xa1\xe5\xdcv\xdbm\x11\x99.4X_C/\x99\x92jgk-\x1ey\xe4\x91\xc8\xb0a\xc3\x1a\xac\xab\xa1\xd7\xd0\xa1C#\x0f>\xf8\xa0\xff\xeb\x96\xf3\xf2\xcb/G\xc6\x8e\x1d\xdb`]\r\xbd\xfa\xf5\xeb\x17\xb9\xf5\xd6[[,0-2M\x8c\xc8\xf4N\x9fmC\xf5\xc5\xbfd*\xae\x02\x9bA\xa75\x989sf\xe4\x90C\x0e\x89dg\xc7\x0eL\x8d\xbdDK\x8d\\x\xe1\x85\x11\xd1\x10\xfd\x12R\x93\x94\x15Z\x16\x99\xa6E&N\x9c\x18\x91i[\x83\x0f\n\xa1r\xc0\x01\x07D\xee\xbd\xf7\xdeHuu\xb5\xff\xab\xd6\x03!x\xf6\xd9g\xab@h\xa8\xf1"T\xf7\xd9g\x9f\xc8\xbf\xfe\xf5/\xd5\xd0Z\x9bo\xbe\xf9&r\xc1\x05\x17Dv\xdey\xe7\x06\x1bo\x87\x0e\x1d"{\xee\xb9g\xe4\xfa\xeb\xafW\r\xb5\xb5\x91\xa9z\xe4\xf2\xcb/W\x81\x9c\x9f\x9f\xbfQ\xfd\x05\x05\x05\x91]v\xd9%r\xd9e\x97E\x16-Z\xe4\xff\xaa\xf5X\xbdz\xb5^\xdb\x84\t\x13\xf4Z\xe3\xeb\x97\xe9Td\xcc\x981z\x8f\xe6\xcc\x99\xe3\xff\xaa\xf5@\x00\xc8T;\xb2\xff\xfe\xfbG\xbav\xed\xbaQ\xfd\x19\x19\x19\x91\x91#GF\xce:\xeb\xac\xc8\xe7\x9f\x7f\xee\xff\xaa\xf5\xa0M\xa3u"\xbcd\xea\xbeQ\xfd\xbc\x18XN>\xf9\xe4V\x1d0\x7fHR.ric\x10\x01\x82(\x0c\xc1\xcd\xa7\xd8n\x08m\x8c\r \xac\xd7q\xb2`\x98\xc5\xce\x16\x8c\x18@\x9d8ob\x87\x0b\xbb\xac\x9d,\xec\xcb#t\t\x1b\xbb-\x18\xce\xb1\xdbQ\x7f[\x87\x1e\xc1\xbeB\xfd\x8b\x17/\x92w\x9e\x9d\x06{\r\xf6C\xea\xb7\xde\xfcm\x05vFb\x83\xc5\xc7\xc3\xc2\x06\x87\r\x8a\xf3hK\xd8?H\xfd\xc4\xcc\x0f\xee\xa5d\xc5\x11_(\xebc\xd8Vp\xcd6m\x19\xb6>\x0b\x8e\xab\xf8a\x11u\xf5\xc7\xc2\x8fFh9\x1c\x8e-\x03\'\xb4\x1c\xadF\xf1\x862\xf3\xc2\x93\xef\x99\x8a\xd2JC,\xd5\xbe\xfd\xbb\x99\xfd\x0f\xdb\xd5\xff\xd4\xe1h\x1d\x9c\xd0r\xb4\x1aK\x16\xac0\'\x1e\xf2\'\xb3z\xe5z\x9d\xae\xec>a{s\xfb\xa3^\xa4S\x87\xa3\xb5pB\xcb\xe1p\xa4\x14)\xb5\x8d\xc7\xe1p8\x9c\xd0r8\x1c)\x85\x13Z\x0e\x87#\xa5pB\xcb\xe1p\xa4\x14Nh9\x1c\x8e\x94\xc2\t-\x87\xc3\x91R8\xa1\xe5p8R\n\'\xb4\x1c\x0eGJ\xe1\x84\x96\xc3\xe1H)\x9c\xd0r8\x1c)\x85\x13ZIB\xf8\x91\xc3\x0e;\xcc<\xfa\xe8\xa3\xfe\x91\xcd\x83\xf3\xcf?_C\xc2\x10\x96w\xca\x94)\xfe\xd1\xe4\xa1<B\xf3:\x1c\x9b\x0bNhm&\x103\x1ea\x13|%\x1a\xbe\x9fXR\x0f?\xfc\xb0\xf9\xf8\xe3\x8f5\xbeS"\x99n\x92\xa1\xa5\xe7l\x05\x7f2B\xb1\xa1\xba\x9dp\xdd2pBk3\x82\xc4\x9d$K`\x0f\xfb\xbcy\xf3\xcc-\xb7\xdc\x92\x90\x10 \xe1\x07Yr\xda:\xe0\\\x90\x96\x9esK\x08\xd6]^^\xaeA\xf06U\xddA\x9c6\xbaiqBk3\x05\xc13q\xe2\xc4h\xd6\xa1\xb0\x90L\xb4\xad\xa3\xa46F\xa2\xe7LV!\xb2\xea<\xf3\xcc3\xfe\x91\xe4!J\xed\xd1G\x1f\x9d\xf0\xfdr\xa4\x1eNh\xb5\x10Fxr\xd11=\t\xda\x91\x18}Ic_VF\xfa|\x0f\xa64\xf1\xc7\x12\xc1N\xa7\xect\x88tV6\xbc3\xf5\x91\xad\x1am\x03\xa1eG\xfe\xa6~\x03\xcd}\xdeR\x9a+?^Ky\xff\xfd\xf7\xa3\xdf\xe5\x15\xf6~15\xbe\xe7\x9e{\xcc\xb1\xc7\x1e\xeb\x1fi\xba\xee\x8a\x8a\n\rA\xfc\xc8#\x8fhHb\x9e\xdd\xa4I\x936:\xc6\xf3l\xac\x1c{\x9c\xfc\x89\xe4\xa2\xe4\xb3\xb0\xf7\xdd\x91<Nh\xb5\x90_\xff\xfa\xd7\xe6\x89\'\x9e\xd0)\xcam\xb7\xdd\xa6I`i\x9c4^\x92j\xf2\x02\x1a1\r\xfb\xd0C\x0f5\xf9\xf9\xf9z\xac)\xe2;!\xbf\'\xb1\xe6\t\'\x9c\xa0u\xf1"w\x1eY\xaa\x81\xc4\xab\xef\xbd\xf7^t\xca\xf4\x8ch/\xcd\xfd\xc6~N,y\xfb9\xd3;2Y\'#X\x1b;\xe7\xb0\xe5\xf3{r!b\x93\xb3\xdf\xff\xf4\xd3O\x1b\xbd_V@#\x14\x88\xc5\x8f\xa6\x87\xa0\x80\xe6\xae\x1d\xb0\xfb\x9dv\xdai\x1aW\xdd\xda\x00\xe3\x8fq?\x1b\xbb\x06b\xb1\xa3)\xfe\xfe\xf7\xbf\xd7\xcc\xdb|\x16\xbc\xef\xc1\xdfP7\xe7\xe7\x04W\xcbqB\xab\x85\xdcw\xdf}Q\x837\x1d\x84d\xa2o\xbe\xf9f4\xe5\xfaK/\xbd\xa4\x9f\x91\xf8\xe2\x93O>1\x07\x1dt\x90\xbeo\x88`\'\x1c9r\xa4v\x9c\xe3\x8e;N?\xb3S)\xfb\x1eH\x1c\xbbp\xe1\xc2F\x05Ls\xbf\xb1\xe7D\xe2R\x0b\xd7\x80]\xcc\n\xdb\xe6h\xea\x9c\x13-\xbfg\xcf\x9e\x9a\x0c\xc4\xde\xb3\xe6\x08\xda\xb4x\x8d\x1f?^\x13I \x18\xc2\xde\xaf;\xef\xbcs\xa3\xa4\x1b\xc1c\xc9\xdc\xa3\xc9\x93\'\x9b\xb7\xdez\xcb\xdcq\xc7\x1d\xfe\x11c\xfe\xf6\xb7\xbfE\xdb\x86\xa3e8\xa1\xd5F\xd0i\x18}\xc9DL\'y\xfb\xed\xb7\xa3\x99a\x1a\xc3v\xc2\xea\xeaj\xd5\xd8\xe25\x124\x11\xa6-v\xcaq\xca)\xa7\xf8\x9f4Ns\xbfA\x9b\xd8y\xe7\x9d\xa3\x9f\xe7\xe5\xe5\x99\xb9s\xe7\xaaQ=\x0c\xcd\x9ds"\xe5c\x97B\xe8\xa1\xad\xf1\xddD\xdd6\xce9\xe7\x1c\x15zV0$s\xbf\x1a\xa2\xa5\xf7\xc8\xd1\xba8\xa1\xd5\x8a\x90\xbe\x8b\x11\xd8\xc2\x88\xbcj\xd5*\xf3\xd4SO\xe9\xd4\xf0\x82\x0b.\x0855D\xe0\xdd|\xf3\xcd\xda\xe9\xd0\x16\x80\xbf\xb1\xef\x90\xce\xdej\x16w\xddu\x97~\xd6\x18a~\x83`\x08N\xc7\xec+\xa8\xa1\x84\xa1\xa1s\x86D\xcbGp-X\xb0@\xbf\x83\xf0\xc1N\x97\x8c\xbfY2\xf7\xab1Z\xeb\x1e9Z\x07\'\xb4Z\xc8/\x7f\xf9\xcbh\xa7B\x9b\xc2\xce\xb1\xcf>\xfb\xe8{\xbb\xa2u\xd2I\'\xe9t\xc1\x1e\x0f\x83]\x89{\xec\xb1\xc7\xfc#\xb1`H\xbe\xe2\x8a+\xfcw\xe1\x88\xffM\xdf\xbe}\xcd\x8e;\xeeh\xae\xbe\xfaj\xffH\xcb\x88?\xe7\x96\x96O\xaeB4\xa5\xb0\xdcz\xeb\xad1v\xad \xc9\xdc/\x08{\r\xc1i\xe7\x0e;\xec\xa0S\xc1\xa0\xfd\xec\xd2K/5]\xbati\xf0\xdc\x1c\x89\xe1\x84V\x0b`\x04\xbe\xf7\xde{uJ\xc4\xb4\xe1\xcc3\xcfT\xe1\x14\xb4\x91\xd8\xd5\xa4\xfd\xf6\xdb/\xe1\x84\xa5\xfc\x16\xfb\x0eB\x91\xcex\xc3\r7\x98\xe3\x8f?^\xeb\xea\xd0\xa1\x839\xf7\xdcs\xfdo6Ls\xbfA;z\xfa\xe9\xa7Mmmmt\xea\xc3\xab%+]\xc1sN\xb4\xfc\xf8\x95C\x8c\xeb\x7f\xff\xfb\xdf\x1bu\x92\r\xda\xd3x\xbd\xf3\xce;\xba\x18\x816\x9b\xcc\xfdj\x880\xd7\xc0\xb4\x14\xcd\xce\xae\xda\xdai.\xe7g\xbf\x1f<7G\xcbp\xd9x\xda\x18\x1a\xf3\xb8q\xe3\xccs\xcf=\xd7\xe6\x1e\xea\x0e\xc7\x96\x80\xd3\xb4\xda\x980\x06x\x87\xc3\x11\x1e\'\xb4\xda\x10\xfcu\x12\xf1\xcdr8\x1c\xcd\xe3\xa6\x87\x0e\x87#\xa5p\x9a\x96\xc3\xe1H)\x9c\xd0r8\x1c)\x85\x13Z\x0e\x87#\xa5pB\xcb\xe1p\xa4\x14Nh9\x1c\x8e\x94\xc2\t-\x87\xc3\x91R8\xa1\xe5p8R\n\'\xb4\x1c\x0eGJ\xe1\x84\x96\xc3\xe1H)\x9c\xd0r8\x1c)\x85\x13Z\x0e\x87#\xa5pB\xcb\xe1p\xa4\x14Nh9\x1c\x8e\x94\xc2\t-\x87\xc3\x91R8\xa1\xe5p8R\n\'\xb4\x1c\x0eGJ\xe1\x84\x96\xc3\xe1H)\x9c\xd0r8\x1c)\x85\x13Z\x0e\x87#\xa5pB\xcb\xe1p\xa4\x10\xc6\xfc?6\x85\xae],b\xe5\xfb\x00\x00\x00\x00IEND\xaeB`\x82'
    # In order to display the image in a GUI, you will use the 'PhotoImage' method of Tkinter. It will an image from the directory (specified path) and store the image in a variable.
    #icon = PhotoImage(file = "teste.png")
    #icon = PhotoImage(data=raw_data)
    icon = PhotoImage(data=data)

    # Finally, to display the image you will make use of the 'Label' method and pass the 'image' variriable as a parameter and use the pack() method to display inside the GUI.
    label = Label(gui, image = icon)
    label.grid(row=0,column=1)


    label2 = Label(text='Choose your STM microscope')
    label2.grid(row=1,column=1)

    def which():
        global stm
        stm = 'Nanosurf'
        print('Nanosurf mode selected')
        showinfo(
            title='Selected Mode',
            message='Nanosurf Mode Selected'
        )

    btnselec = ttk.Button(gui, text="Nanosurf Files", command=which)
    btnselec.grid(row=2,column=0)

    def which2():
        global stm
        stm = 'Omicron'
        print('Omicron mode selected')
        showinfo(
            title='Selected Mode',
            message='Omicron Mode Selected'
        )
    btnselec2 = ttk.Button(gui, text="Omicron Files", command=which2)
    btnselec2.grid(row=2,column=2)



    def getFolderPath():
                global grid_files
                grid_files = False
                filetypes = (
            ('*.txt', '*.csv'),
            ('All files', '*.*')
        )

                global folder
                folder = filedialog.askopenfilename(filetypes=filetypes)
                print("File: ",folder)
                print("Uploaded")
                showinfo(
                title='Selected File',
                message=folder
            )
                
                gui.destroy()


    btnFind = ttk.Button(gui, text="Open File (Single File)", command=getFolderPath)
    btnFind.grid(row=3,column=0)



    def select_files():
        global filenames
        global conca
        global grid_files
        grid_files = False
        filetypes = (
            ('*.txt', '*.csv'),
            ('All files', '*.*')
        )
        conca = False
        filenames = filedialog.askopenfilenames(
            title='Open files (Average)',
            #initialdir='/.',
            filetypes=filetypes)
        print("Files: ")
        for names in filenames:
            print(names)
        print("Uploaded")
        showinfo(
            title='Selected Files',
            message=filenames
        )
        gui.destroy()

    # open button
    open_button = ttk.Button(
        gui,
        text='Open files (Average)',
        command=select_files
    )

    #open_button.pack(expand=True)
    open_button.grid(row=3,column=1)

    def select_files2():
        global filenames
        global conca
        global grid_files
        grid_files = False
        filetypes = (
            ('*.txt', '*.csv'),
            ('All files', '*.*')
        )
        conca = True
        filenames = filedialog.askopenfilenames(
            title='Open files (Concatenate)',
            #initialdir='/.',
            filetypes=filetypes)
        print("Files: ")
        for names in filenames:
            print(names)
        print("Uploaded")
        showinfo(
            title='Selected Files',
            message=filenames
        )
        gui.destroy()

    # open button
    open_button2 = ttk.Button(
        gui,
        text='Open files (Concatenate)',
        command=select_files2
    )

    #open_button.pack(expand=True)
    open_button2.grid(row=3,column=2)

    def getFolderPath():
                filetypes=(
            ("Igor Binary Wave", "*.ibw"),
            ("ASCII Files", "*.asc"),
            ("Text Files", "*.txt"),
            ("CSV Files", "*.csv"),
            ("All Files", "*.*")
        )
        

                global folder
                global grid_files
                grid_files = True
                folder = filedialog.askopenfilename(filetypes=filetypes)
                print("File: ",folder)
                print("Uploaded")
                showinfo(
                title='Selected File',
                message=folder
            )
                
                gui.destroy()


    btnFind = ttk.Button(gui, text="Open File GRID (Single File: .ibw, .asc,.csv)", command=getFolderPath)
    btnFind.grid(row=4,column=1)




    gui.mainloop()




    if filenames!=None:
        files_mult = []
        for item in filenames:
            files_mult.append(load_file(item,which=stm))
        
        for indice in range(len(filenames[0])):
            ct = len(filenames[0])-1-indice
            if filenames[0][ct]=='/':
                break
        folder = filenames[0][:ct+1] +'AAA'
        Vmin_glob =-9999;Vmax_glob =9999
        df_news = []
        if conca == False:
            for i in range(len(files_mult[0]['ixv'][0])):
                list_interps = []
                for j in range(len(files_mult)):
                    df = files_mult[j]['ixv'][0][i]
                    colum = df.columns
                    x_data = array(df[colum[0]]); y_data = array(df[colum[1]])
                    if x_data[0]>0:
                        xnew = [];ynew = []
                        for i in range(len(x_data)):
                            xnew.append(x_data[len(x_data)-i-1])
                            ynew.append(y_data[len(y_data)-1-i])
                        x_data = array(xnew)
                        y_data = array(ynew)

                    f = interpolate.interp1d(x_data,y_data)
                    list_interps.append(f)
                    if j ==0:
                        vmin = x_data.min();vmax = x_data.max()
                        if x_data.min()>Vmin_glob:
                            Vmin_glob = x_data.min()
                        if x_data.max()<Vmax_glob:
                            Vmax_glob = x_data.max()
                    else:
                        if x_data.min()>vmin:
                            vmin = x_data.min()
                        if x_data.max()<vmax:
                            vmax = x_data.max()
                        if x_data.min()>Vmin_glob:
                            Vmin_glob = x_data.min()
                        if x_data.max()<Vmax_glob:
                            Vmax_glob = x_data.max()
                V_new = arange(vmin,vmax,0.005)
                
                for k in range(len(list_interps)):
                    if k ==0:
                        ymedia = array(list_interps[k](V_new))
                    else:
                        ymedia=(ymedia+array(list_interps[k](V_new)))/2

                V_new = V_new
                df_media = DataFrame(V_new,columns = ['V'])
                df_media['I'+str(i)]=ymedia
                df_news.append(df_media)
                #printProgressBar(i,len(files_mult[0]['ixv'][0])-1)
######################
            if stm == 'Omicron':
                files_data = {'ixv':[df_news,['Average'],[Vmin_glob,Vmax_glob]],'ixv_idaevolta':[[],[],[]]}
            else:
                files_data = {'ixv':[df_news,files_mult[0]['ixv'][1],[Vmin_glob,Vmax_glob]],'ixv_idaevolta':[[],[],[]]}
            df_news = []
            if len(files_mult[0]['ixv_idaevolta'][0])!=0:
                for i in range(len(files_mult[0]['ixv_idaevolta'][0])):
                    list_interps = []
                    for j in range(len(files_mult)):
                        df = files_mult[j]['ixv_idaevolta'][0][i]
                        colum = df.columns
                        x_data = array(df[colum[0]]); y_data = array(df[colum[1]])
                        if x_data[0]>0:
                            xnew = [];ynew = []
                            for i in range(len(x_data)):
                                xnew.append(x_data[len(x_data)-i-1])
                                ynew.append(y_data[len(y_data)-1-i])
                            x_data = array(xnew)
                            y_data = array(ynew)

                        f = interpolate.interp1d(x_data,y_data)
                        list_interps.append(f)
                        if j ==0:
                            vmin = x_data.min();vmax = x_data.max()
                            if x_data.min()>Vmin_glob:
                                Vmin_glob = x_data.min()
                            if x_data.max()<Vmax_glob:
                                Vmax_glob = x_data.max()
                        else:
                            if x_data.min()>vmin:
                                vmin = x_data.min()
                            if x_data.max()<vmax:
                                vmax = x_data.max()
                            if x_data.min()>Vmin_glob:
                                Vmin_glob = x_data.min()
                            if x_data.max()<Vmax_glob:
                                Vmax_glob = x_data.max()
                    V_new = arange(vmin,vmax,0.005)
                    
                    for k in range(len(list_interps)):
                        if k ==0:
                            ymedia = array(list_interps[k](V_new))
                        else:
                            ymedia=(ymedia+array(list_interps[k](V_new)))/2

                    V_new = V_new
                    df_media = DataFrame(V_new,columns = ['V'])
                    df_media['I'+str(i)]=ymedia
                    df_news.append(df_media)
                    #printProgressBar(i,len(files_mult[0]['ixv'][0])-1)
                if stm == 'Omicron':
                    files_data['ixv_idaevolta'][0]=df_news
                    files_data['ixv_idaevolta'][1]=['Average_backward']
                    files_data['ixv_idaevolta'][2]=[Vmin_glob,Vmax_glob]
                else:
                    files_data['ixv_idaevolta'][0]=df_news
                    files_data['ixv_idaevolta'][1]=files_mult[0]['ixv'][1]
                    files_data['ixv_idaevolta'][2]=[Vmin_glob,Vmax_glob]

        elif conca == True:
            df_conca = []
            names_conca = []
            for j in range(len(files_mult)):
                if j ==0:
                    df = files_mult[j]['ixv'][0]
                    df_conca = df
                    if stm == 'Omicron':
                        names_conca =  files_mult[j]['ixv'][1]
                else:
                    df = files_mult[j]['ixv'][0]
                    df_conca=df_conca+df
                    if stm == 'Omicron':
                        names =  files_mult[j]['ixv'][1]
                        names_conca =names_conca +names
            for i in range(len(files_mult[0]['ixv'][0])):
                for j in range(len(files_mult)):
                    try:
                        df = files_mult[j]['ixv'][0][i]
                        colum = df.columns
                        x_data = array(df[colum[0]])
                        if x_data[0]>0:
                            x_data = sort(x_data)
                        if j ==0:
                            vmin = x_data.min();vmax = x_data.max()
                            if x_data.min()>Vmin_glob:
                                Vmin_glob = x_data.min()
                            if x_data.max()<Vmax_glob:
                                Vmax_glob = x_data.max()
                        else:
                            if x_data.min()>vmin:
                                vmin = x_data.min()
                            if x_data.max()<vmax:
                                vmax = x_data.max()
                            if x_data.min()>Vmin_glob:
                                Vmin_glob = x_data.min()
                            if x_data.max()<Vmax_glob:
                                Vmax_glob = x_data.max()
                    except IndexError:
                        pass
                #printProgressBar(i,len(files_mult[0]['ixv'][0])-1)
            print(len(df_conca))
            if stm == 'Omicron':
                files_data = {'ixv':[df_conca,names_conca,[Vmin_glob,Vmax_glob]],'ixv_idaevolta':[[],[],[]]}
            else:
                files_data = {'ixv':[df_conca,list(map(lambda x:str(x),range(len(df_conca)))),[Vmin_glob,Vmax_glob]],'ixv_idaevolta':[[],[],[]]}
    
    #############
            if len(files_mult[0]['ixv_idaevolta'][0])!=0:
                df_conca = []
                names_conca = []
                for j in range(len(files_mult)):
                    if j ==0:
                        df = files_mult[j]['ixv_idaevolta'][0]
                        df_conca = df
                        if stm == 'Omicron':
                            names_conca =  files_mult[j]['ixv_idaevolta'][1]
                    else:
                        df = files_mult[j]['ixv_idaevolta'][0]
                        df_conca=df_conca+df
                        if stm == 'Omicron':
                            names =  files_mult[j]['ixv_idaevolta'][1]
                            names_conca =names_conca +names
                for i in range(len(files_mult[0]['ixv_idaevolta'][0])):
                    for j in range(len(files_mult)):
                        try:
                            df = files_mult[j]['ixv_idaevolta'][0][i]
                            colum = df.columns
                            x_data = array(df[colum[0]])
                            if x_data[0]>0:
                                x_data = sort(x_data)
                            if j ==0:
                                vmin = x_data.min();vmax = x_data.max()
                                if x_data.min()>Vmin_glob:
                                    Vmin_glob = x_data.min()
                                if x_data.max()<Vmax_glob:
                                    Vmax_glob = x_data.max()
                            else:
                                if x_data.min()>vmin:
                                    vmin = x_data.min()
                                if x_data.max()<vmax:
                                    vmax = x_data.max()
                                if x_data.min()>Vmin_glob:
                                    Vmin_glob = x_data.min()
                                if x_data.max()<Vmax_glob:
                                    Vmax_glob = x_data.max()
                        except IndexError:
                            pass
                    #printProgressBar(i,len(files_mult[0]['ixv'][0])-1)
                print(len(df_conca))
                if stm == 'Omicron':
                    files_data['ixv_idaevolta'][0]=df_conca
                    files_data['ixv_idaevolta'][1]=names_conca
                    files_data['ixv_idaevolta'][2]=[Vmin_glob,Vmax_glob]
                else:
                    files_data['ixv_idaevolta'][0]=df_conca
                    files_data['ixv_idaevolta'][1]=list(map(lambda x:str(x),range(len(df_conca))))
                    files_data['ixv_idaevolta'][2]=[Vmin_glob,Vmax_glob]
    else:
        if grid_files:
            x,y,V,M =load_file(folder,which=stm,grid=True)

            files_data = [x,y,V,M]
        else:
            files_data = load_file(folder,which=stm)

def Display():
        #file = load_file(folder)

        if len(files_data['ixv_idaevolta'][0])!=0:
            file = files_data['ixv'];file_volta = files_data['ixv_idaevolta']
            #xlim= xlimSlider.value
            def plot_curve(file,curve = 0,smooth = 5,delta = 10,resolution=0.010,volta= True,mm= False,xlim = (-1,1)):
                    global save_var
                    global curve_glob
                    global smooth_glob
                    global delta_glob
                    global selec 
                    curve_glob = curve; smooth_glob = smooth; delta_glob = delta
                    xmin,xmax = xlim
                    curve = int(curve)
                    fig,ax= plt.subplots(1,2,figsize=(20,8))
                    dfs = file[0]
                    columns = dfs[curve].columns
                    x = dfs[curve][columns[0]];y = dfs[curve][columns[1]]*pow(10,9)

                    if mm:
                        x_cut,y_cut = cut(x,y,xmin,xmax )
                        a,b = regression(x_cut,y_cut)
                        a = round(a,3); b = round(b,3)
                        I = round(integral(x_cut,y_cut),3)
                        ax[0].plot(x_cut,x_cut*a+b,c='orange',label = 'a: ' + str(a) + ' b: '+str(b)+'\n'+'Integral: '+str(I))

                    p = int(smooth*len(y)/100)
                    if p%2==0:
                        p+=1
                        y = savgol_filter(y,p,1)
                    elif p==0:
                        pass
                    else:
                        y = savgol_filter(y,p,1)
                    if volta:
                        ax[0].plot(x,y,color = 'black',label = 'Forward curve')
                    else:   
                        ax[0].plot(x,y,color = 'black')
                        ax[0].legend()
                    if stm == 'Omicron':
                        ax[0].set_title('Curve from file: '+files_data['ixv'][1][curve])
                    ax[0].set_xlabel('Sample bias (V)')
                    ax[0].set_ylabel('Current (nA)')

                    dx,dy = didv(x,y)
                    if mm:
                        x_cut_neg,y_cut_neg = cut(dx,dy,xmin,0-resolution )
                        a_neg,b_neg = regression(x_cut_neg,y_cut_neg)
                        a_neg = round(a_neg,3); b_neg = round(b_neg,3)
                        I_neg = round(integral(x_cut_neg,y_cut_neg),3)
                        x_cut_pos,y_cut_pos = cut(dx,dy,0+resolution,xmax )
                        a_pos,b_pos = regression(x_cut_pos,y_cut_pos)
                        a_pos = round(a_pos,3); b_pos = round(b_pos,3)                
                        I_pos = round(integral(x_cut_pos,y_cut_pos),3)
                        if volta:
                            ax[1].plot(dx,dy,color = 'black',label = 'F Int neg: '+str(I_neg)+' Int pos: '+str(I_pos))
                        else:
                            ax[1].plot(dx,dy,color = 'black',label = 'Int neg: '+str(I_neg)+' Int pos: '+str(I_pos))
                        ax[1].plot(x_cut_neg,a_neg*x_cut_neg+b_neg,c = 'orange',label = 'a_neg: ' + str(a_neg) + ' b_neg: '+str(b_neg))
                        ax[1].plot(x_cut_pos,a_pos*x_cut_pos+b_pos,c = 'gray',label = 'a_pos: ' + str(a_pos) + ' b_pos: '+str(b_pos))

                    gap,typ,xmin,xmax = gap_type(dx,dy,delta/100)
                    if abs(round(typ,3))<=resolution:
                        tipo = 'neutro'
                    elif typ<-resolution:
                        tipo = 'n'
                    else:
                        tipo = 'p'
                    dyinterp = interpolate.interp1d(dx,dy)
                    ymin = dyinterp(xmin)
                    ymax = dyinterp(xmax)
                    ax[1].scatter([xmin,xmax],[ymin,ymax],s = 50, color = 'red')
                    if volta:
                        if mm == False:
                            ax[1].plot(dx,dy, label = 'F Gap '+ str(gap)+ ': Type ' + tipo,color = 'black')
                    else:
                        if mm == False:
                            ax[1].plot(dx,dy,color = 'black',label = 'Forward')
                    ax[1].set_title('Gap '+ str(gap)+ ': Type ' + tipo)
                    ax[1].set_xlabel('Sample bias (V)')
                    ax[1].set_ylabel('dI/dV (arb. units)')
                    ax[1].legend()    

                    if volta:
                        dfs = file_volta[0]
                        columns = dfs[curve].columns
                        x = dfs[curve][columns[0]];y = dfs[curve][columns[1]]*pow(10,9)
                        p = int(smooth*len(y)/100)
                        if p%2==0:
                            p+=1
                            y = savgol_filter(y,p,1)
                        elif p==0:
                            pass
                        else:
                            y = savgol_filter(y,p,1)

                        ax[0].plot(x,y,color ='red',label = 'Backward curve')
                        ax[0].set_xlabel('Sample bias (V)')
                        ax[0].set_ylabel('Current (nA)')
                        ax[0].legend()

                        dx,dy = didv(x,y)
                        gap,typ,xmin,xmax = gap_type(dx,dy,delta/100)
                        if abs(round(typ,3))<=resolution:
                            tipo = 'neutro'
                        elif typ<-resolution:
                            tipo = 'n'
                        else:
                            tipo = 'p'
                        dyinterp = interpolate.interp1d(dx,dy)
                        ymin = dyinterp(xmin)
                        ymax = dyinterp(xmax)
                        ax[1].scatter([xmin,xmax],[ymin,ymax],s = 50, color = 'blue')
                        ax[1].plot(dx,dy, label = 'B Gap '+ str(gap)+ ': Type ' + tipo,color = 'red')
                        ax[1].set_xlabel('Sample bias (V)')
                        ax[1].set_ylabel('dI/dV (arb. units)')
                        ax[1].legend()    
            
            curve_slider=widgets.widgets.IntSlider(
            value=0,min=0,max=len(file[0])-1,	step=1,description='Select Curve: ',continuous_update=False,layout=widgets.Layout(width='400px')	)  
            smoothingSlider=widgets.widgets.FloatSlider(
            value=5,min=.5,max=20,	step=.5,description='Smoothing: ',continuous_update=False,layout=widgets.Layout(width='400px')	)  
            deltaSlider=widgets.widgets.FloatSlider(
            value=5,min=.5,max=20,	step=.5,description='Threshold: ',continuous_update=False,layout=widgets.Layout(width='400px')	)  
            resolutionSlider = widgets.FloatText(
            value=0.010,
            description='Resolution of Doping Neutral (V):',
            disabled=False,layout=widgets.Layout(width='400px')	
    )
            voltaslider = widgets.Checkbox(value = True,description= 'Show the backward curve ',disable = False)

            molecu_metal_slider = widgets.Checkbox(value = False,description= 'Molecule or Metal ',disable = False)
            xlimSlider=widgets.FloatRangeSlider(value=[file[2][0], file[2][1]], min=file[2][0], max=file[2][1],  step=0.1, description='Range (V):',  disabled=False, continuous_update=False, orientation='horizontal',
            readout=True,  readout_format='.1f',layout=widgets.Layout(width='400px'))
            


            widgets.interact(plot_curve, file = widgets.fixed(file),  curve=curve_slider, smooth = smoothingSlider,delta = deltaSlider,resolution = resolutionSlider,
                             volta = voltaslider,mm = molecu_metal_slider,xlim = xlimSlider)
            #print(curve_glob,smooth_glob,delta_glob)


        else:
            file = files_data['ixv']
            def plot_curve(file,curve = 0,smooth = 5,delta = 10,resolution=0.010,mm=False,xlim = (-1,1)):
                    global save_var
                    global curve_glob
                    global smooth_glob
                    global delta_glob
                    global selec 
                    global stm
                    curve_glob = curve; smooth_glob = smooth; delta_glob = delta
                    xmin,xmax = xlimSlider.value
                    curve = int(curve)
                    fig,ax= plt.subplots(1,2,figsize=(20,8))
                    dfs = file[0]
                    columns = dfs[curve].columns
                    x = dfs[curve][columns[0]];y = dfs[curve][columns[1]]*pow(10,9)
                    if mm:
                        x_cut,y_cut = cut(x,y,xmin,xmax )
                        a,b = regression(x_cut,y_cut)
                        a = round(a,3); b = round(b,3)
                        I = round(integral(x_cut,y_cut),3)
                        ax[0].plot(x_cut,x_cut*a+b,c='orange',label = 'a: ' + str(a) + ' b: '+str(b)+'\n'+'Integral: '+str(I))

                    p = int(smooth*len(y)/100)
                    if p%2==0:
                        p+=1
                        y = savgol_filter(y,p,1)
                    elif p==0:
                        pass
                    else:
                        y = savgol_filter(y,p,1)

                    ax[0].plot(x,y,color = 'black')
                    ax[0].set_xlabel('Sample bias (V)')
                    ax[0].set_ylabel('Current (nA)')
                    if stm == 'Omicron':
                        ax[0].set_title('Curve from file: '+files_data['ixv'][1][curve])

                    dx,dy = didv(x,y)
                    if mm:
                        x_cut_neg,y_cut_neg = cut(dx,dy,xmin,0-resolution )
                        a_neg,b_neg = regression(x_cut_neg,y_cut_neg)
                        a_neg = round(a_neg,3); b_neg = round(b_neg,3)
                        I_neg = round(integral(x_cut_neg,y_cut_neg),3)
                        x_cut_pos,y_cut_pos = cut(dx,dy,0+resolution,xmax )
                        a_pos,b_pos = regression(x_cut_pos,y_cut_pos)
                        a_pos = round(a_pos,3); b_pos = round(b_pos,3)                
                        I_pos = round(integral(x_cut_pos,y_cut_pos),3)
                        ax[1].plot(dx,dy,color = 'black',label = 'Int neg: '+str(I_neg)+' Int pos: '+str(I_pos))
                        ax[1].plot(x_cut_neg,a_neg*x_cut_neg+b_neg,c = 'orange',label = 'a_neg: ' + str(a_neg) + ' b_neg: '+str(b_neg))
                        ax[1].plot(x_cut_pos,a_pos*x_cut_pos+b_pos,c = 'gray',label = 'a_pos: ' + str(a_pos) + ' b_pos: '+str(b_pos))
                        ax[1].legend()   


                    gap,typ,xmin,xmax = gap_type(dx,dy,delta/100)
                    if abs(round(typ,3))<=resolution:
                        tipo = 'neutro'
                    elif typ<-resolution:
                        tipo = 'n'
                    else:
                        tipo = 'p'
                    dyinterp = interpolate.interp1d(dx,dy)
                    ymin = dyinterp(xmin)
                    ymax = dyinterp(xmax)
                    ax[1].scatter([xmin,xmax],[ymin,ymax],s = 50, color = 'red')
                    if mm == False:
                        ax[1].plot(dx,dy,color = 'black')
                    
                    ax[1].set_title('Gap '+ str(gap)+ ': Type ' + tipo)
                    ax[1].set_xlabel('Sample bias (V)')
                    ax[1].set_ylabel('dI/dV (arb. units)')
                     
        
            curve_slider=widgets.widgets.IntSlider(
            value=0,min=0,max=len(file[0])-1,	step=1,description='Select Curve: ',continuous_update=False,layout=widgets.Layout(width='400px')	)  
            smoothingSlider=widgets.widgets.FloatSlider(
            value=5,min=.5,max=20,	step=.5,description='Smoothing: ',continuous_update=False,layout=widgets.Layout(width='400px')	)  
            deltaSlider=widgets.widgets.FloatSlider(
            value=5,min=.5,max=20,	step=.5,description='Threshold: ',continuous_update=False,layout=widgets.Layout(width='400px')	)  
            resolutionSlider = widgets.FloatText(
            value=0.010,
            description='Resolution of Doping Neutral (V):',
            disabled=False,layout=widgets.Layout(width='400px')	
    )   
            molecu_metal_slider = widgets.Checkbox(value = False,description= 'Molecule or Metal ',disable = False)
            xlimSlider=widgets.FloatRangeSlider(value=[file[2][0], file[2][1]], min=file[2][0], max=file[2][1],  step=0.1, description='Range (V):',  disabled=False, continuous_update=False, orientation='horizontal',
            readout=True,  readout_format='.1f',layout=widgets.Layout(width='400px'))
            

            widgets.interact(plot_curve, file = widgets.fixed(file),  curve=curve_slider, smooth = smoothingSlider,delta = deltaSlider,resolution = resolutionSlider,mm = molecu_metal_slider,xlim = xlimSlider)
            #print(curve_glob,smooth_glob,delta_glob)

def Save_data():
    file = files_data['ixv']
    file_volta = files_data['ixv_idaevolta']
    for i in range(len(file[0])):
            selec[i] = True
    
    def str_to_int(A):
        A_new = []
        for item in A:
            try:
                A_new.append(int(item))
            except ValueError:
                pass
        return A_new

    def save_files(list_n,salvar = False,smooth = 5,delta = 5,resolution=0.01,save_df_todos = False,save_df_limi = False,save_um_file = False,metal= False, molecula = False,rang=(-1,1),volta = False):
        xmin,xmax = xlim.value
        global hist_path
        list_n = list_n.split(',')
        n_new = str_to_int(list_n)
        if salvar:
            print('Wainting ....')
            if volta:
                select_sts_ida(folder,file=file,n = n_new,smooth = smooth,delta = delta,resolution=resolution,
                       save_um_file = save_um_file,metal= metal, molecula = molecula,xmin_hist=  xmin,xmax_hist=  xmax,name_table ='forward',save_df_todos = save_df_todos,save_df_limi = save_df_limi )
                select_sts_volta(folder,file=file_volta,n = n_new,smooth = smooth,delta = delta,resolution=resolution,
                       save_um_file = save_um_file,metal= metal, molecula = molecula,xmin_hist=  xmin,xmax_hist=  xmax,name_table ='backward',save_df_todos = save_df_todos,save_df_limi = save_df_limi )
                df_hist_ida = read_csv(hist_path_forwad)
                df_hist_volta = read_csv(hist_path_backward)
                df_hist = concat([df_hist_ida,df_hist_volta])
                df_hist = df_hist.reset_index(drop=True)
                hist_path= save_path+'/histogram.csv'
                df_hist.to_csv(hist_path)
                if metal:
                    df_hist_ida_metal = read_csv(hist_path_metal_forwad)
                    df_hist_volta_metal = read_csv(hist_path_metal_backward)
                    df_hist_metal = concat([df_hist_ida_metal,df_hist_volta_metal])
                    df_hist_metal = df_hist_metal.reset_index(drop=True)
                    hist_path_metal= save_path+'/histogram_alphas.csv'
                    df_hist_metal.to_csv(hist_path_metal)
                if molecula:
                    df_hist_ida_molecula = read_csv(hist_path_molecula_forwad)
                    df_hist_volta_molecula = read_csv(hist_path_molecula_backward)
                    df_hist_molecula = concat([df_hist_ida_molecula,df_hist_volta_molecula])
                    df_hist_molecula = df_hist_molecula.reset_index(drop=True)
                    hist_path_molecula= save_path+'/histogram_molecule.csv'
                    df_hist_molecula.to_csv(hist_path_molecula)      

            else:
                select_sts(folder,file=file,n = n_new,smooth = smooth,delta = delta,resolution=resolution,
                       save_um_file = save_um_file,metal= metal, molecula = molecula,xmin_hist=  xmin,xmax_hist=  xmax ,save_df_todos = save_df_todos,save_df_limi = save_df_limi )
            print('Files saved')

    if len(files_data['ixv_idaevolta'][0])==0:   
        list_n = widgets.Textarea(
        value='',    placeholder="Write down the number of the files that you DON'T want to save. Separated by comma.",    
        description="List of curve numbers: ",    disabled=False, layout=widgets.Layout(width='400px'))
        print("Write down the number of the files that you DON'T want to save. Separated by comma.")
        save_buttom= widgets.ToggleButton(
        value=False,
        continuous_update=tuple,
        description='Save file and make a report',
        disabled=False,
        button_style='', # 'success', 'info', 'warning', 'danger' or ''
        tooltip='Description',
        icon='check',
        layout=widgets.Layout(width='400px')
    )
        smoothingSlider=widgets.widgets.FloatSlider(
            value=5,min=.5,max=20,	step=.5,description='Smoothing (%): ',continuous_update=False,layout=widgets.Layout(width='400px')	)  
        deltaSlider=widgets.widgets.FloatSlider(
            value=5,min=.5,max=20,	step=.5,description='Threshold (%): ',continuous_update=False,layout=widgets.Layout(width='400px')	)  
        resolutionSlider = widgets.FloatText(
        value=0.010,
        description='Resolution of Doping Neutral (V):',
        disabled=False,layout=widgets.Layout(width='400px')	
    )
        slidersave = widgets.Checkbox(value = False,description= 'Save files individually ',disable = False)

        slider_df_complete = widgets.Checkbox(value = True,description= 'Save dataframe complete ',disable = False)
        slider_df_limited = widgets.Checkbox(value = True,description= 'Save dataframe Limited ',disable = False)
        metal = widgets.Checkbox(value = False,description= 'Save Histrogram metal ',disable = False)

        molecula = widgets.Checkbox(value = False,description= 'Save Histrogram molecule  ',disable = False)
        xlim=widgets.FloatRangeSlider(
        value=[file[2][0], file[2][1]],
        min=file[2][0],
        max=file[2][1],
        step=0.1,
        description='Range (V):',
        disabled=False,
        continuous_update=False,
        orientation='horizontal',
        readout=True,
        readout_format='.1f',layout=widgets.Layout(width='400px')
    )

        widgets.interact(save_files, list_n = list_n,salvar = save_buttom,smooth = smoothingSlider,delta = deltaSlider,
                        resolution = resolutionSlider,save_df_todos = slider_df_complete,save_df_limi = slider_df_limited ,save_um_file = slidersave,metal = metal,molecula = molecula,rang = xlim,volta = widgets.fixed(False))
    else:
        list_n = widgets.Textarea(
        value='',    placeholder="Write down the number of the files that you DON'T want to save. Separated by comma.",    
        description="List of curve numbers: ",    disabled=False, layout=widgets.Layout(width='400px'))
        print("Write down the number of the files that you DON'T want to save. Separated by comma.")
        save_buttom= widgets.ToggleButton(
        value=False,
        continuous_update=tuple,
        description='Save file and make a report',
        disabled=False,
        button_style='', # 'success', 'info', 'warning', 'danger' or ''
        tooltip='Description',
        icon='check',
        layout=widgets.Layout(width='400px')
    )
        smoothingSlider=widgets.widgets.FloatSlider(
            value=5,min=.5,max=20,	step=.5,description='Smoothing (%): ',continuous_update=False,layout=widgets.Layout(width='400px')	)  
        deltaSlider=widgets.widgets.FloatSlider(
            value=5,min=.5,max=20,	step=.5,description='Threshold (%): ',continuous_update=False,layout=widgets.Layout(width='400px')	)  
        resolutionSlider = widgets.FloatText(
        value=0.010,
        description='Resolution of Doping Neutral (V):',
        disabled=False,layout=widgets.Layout(width='400px')	
    )
        slidersave = widgets.Checkbox(value = False,description= 'Save files individually ',disable = False)
        slider_df_complete = widgets.Checkbox(value = True,description= 'Save dataframe complete ',disable = False)
        slider_df_limited = widgets.Checkbox(value = True,description= 'Save dataframe Limited ',disable = False)
        metal = widgets.Checkbox(value = False,description= 'Save Histrogram metal ',disable = False)

        molecula = widgets.Checkbox(value = False,description= 'Save Histrogram molecule  ',disable = False)
        xlim=widgets.FloatRangeSlider(
        value=[file[2][0], file[2][1]],
        min=file[2][0],
        max=file[2][1],
        step=0.1,
        description='Range (V):',
        disabled=False,
        continuous_update=False,
        orientation='horizontal',
        readout=True,
        readout_format='.1f',layout=widgets.Layout(width='400px')
    )
        volta = widgets.Checkbox(value = False,description= 'Save Backward files ',disable = False)


        widgets.interact(save_files, list_n = list_n,salvar = save_buttom,smooth = smoothingSlider,delta = deltaSlider,
                        resolution = resolutionSlider,save_df_todos = slider_df_complete,save_df_limi = slider_df_limited,save_um_file = slidersave,metal = metal,molecula = molecula,rang = xlim,volta = volta)
    
def Hist_plot():
    font = {'size'   : 14}
    matplotlib.rc('font', **font)
    if hist_path == 'not_path':
        gui = Tk()
        gui.geometry("400x400")
        gui.title('Nanosurf STS Data Analise by Rafael Reis Barreto')
        def getFolderPath():
            global hist_path
            hist_path = filedialog.askopenfilename()
            print("File: ",hist_path)
            print("Uploaded")
            gui.destroy()

        btnFind = ttk.Button(gui, text="Open a histogram file", command=getFolderPath)
        btnFind.grid(row=1,column=1)
        gui.mainloop()
    hist_file = read_csv(hist_path)


    def plot_hist(hist_file_col,bins,label,monocolor,rwidth):
            fig, ax = plt.subplots(figsize = (10,8))
            if monocolor:
                N,n_bins,patches =ax.hist(hist_file_col,bins = bins,rwidth= rwidth)
                # We'll color code by height, but you could use any scalar
                hist_file_col=array(hist_file_col)
                fracs = array(sorted(hist_file_col))/hist_file_col.max()

                # we need to normalize the data to 0..1 for the full range of the colormap
                norm = matplotlib.colors.Normalize(fracs.min(), fracs.max())

                # Now, we'll loop through our objects and set the color of each accordingly
                for thisfrac, thispatch in zip(fracs, patches):
                    color = plt.cm.viridis(norm(thisfrac))
                    thispatch.set_facecolor(color)
            else:
                ax.hist(hist_file_col,bins = bins,edgecolor='black',rwidth= rwidth)


            ax.set_xlabel(label)
            ax.set_ylabel('Counting')
            de = rwidth*(hist_file_col.max()-hist_file_col.min())/bins     
            print('Voltage width of each bar: %s (V)'%(round(de,3)))



    box_layout = widgets.Layout(
			border='dashed 1px gray',
			margin='0px 10px 10px 0px',
			padding='5px 5px 5px 5px',
			width='600px')


    style = {'description_width': 'initial'}

    panel=[{},{}]
    fig= []
    axes=[]

    
    for axis in [0,1]:
        panel[axis]['bins']=widgets.IntSlider(value=10,min=1,max=100,	
                                            step=1,description='Bins: ',continuous_update=False,layout=widgets.Layout(width='400px')	)
        panel[axis]['histcolor']=widgets.Checkbox(value = False,description= 'Hist color by x axis',disable = False)
        panel[axis]['rwidth']=widgets.FloatSlider(value=0.9,min=0.1,max=1,	
                                            step=.1,description='rwidth: ',continuous_update=False,layout=widgets.Layout(width='400px')	)

    colums = [hist_file['Gap(V)'],hist_file['Dop(Value)']]
    label = ['Gap (V)','Doping, Shifting from 0 (V) ']
    for axis in [0,1]:
        panel[axis]['output']=widgets.interactive_output(plot_hist,{'hist_file_col':widgets.fixed(colums[axis]),
                                                                    'bins':panel[axis]['bins'],
                                                                    'label': widgets.fixed(label[axis]),
                                                                    'monocolor': panel[axis]['histcolor'],
                                                                    'rwidth': panel[axis]['rwidth']})
        panel[axis]['widget'] = widgets.VBox([panel[axis]['output'],panel[axis]['bins'], panel[axis]['histcolor'],panel[axis]['rwidth']],layout=box_layout)
        panel[axis]['widget'].children[0].layout.height = '600px'


    outputPanel = widgets.HBox([panel[0]['widget'],panel[1]['widget']],layout=widgets.Layout(width='1200px'))
    return outputPanel
    
def Hist_metal():
    font = {'size'   : 14}
    matplotlib.rc('font', **font)
    if hist_path == 'not_path':
        gui = Tk()
        gui.geometry("400x400")
        gui.title('Nanosurf STS Data Analise by Rafael Reis Barreto')
        def getFolderPath():
            global hist_path_metal
            hist_path_metal = filedialog.askopenfilename()
            print("File: ",hist_path)
            print("Uploaded")
            gui.destroy()

        btnFind = ttk.Button(gui, text="Open a histogram file", command=getFolderPath)
        btnFind.grid(row=1,column=1)
        gui.mainloop()
    hist_file_metal = read_csv(hist_path_metal)
    def plot_hist(hist_file_col,bins,label,monocolor,rwidth):
            hist_file_col = array(hist_file_col)
            fig, ax = plt.subplots(figsize = (10,8))
            if monocolor:
                N,n_bins,patches =ax.hist(hist_file_col,bins = bins,rwidth= rwidth)
                # We'll color code by height, but you could use any scalar
                hist_file_col=array(hist_file_col)
                fracs = array(sorted(hist_file_col))/hist_file_col.max()

                # we need to normalize the data to 0..1 for the full range of the colormap
                norm = matplotlib.colors.Normalize(fracs.min(), fracs.max())

                # Now, we'll loop through our objects and set the color of each accordingly
                for thisfrac, thispatch in zip(fracs, patches):
                    color = plt.cm.viridis(norm(thisfrac))
                    thispatch.set_facecolor(color)
            else:
                ax.hist(hist_file_col,bins = bins,edgecolor='black',rwidth= rwidth)


            ax.set_xlabel(label)
            ax.set_ylabel('Counting')
            de = rwidth*(hist_file_col.max()-hist_file_col.min())/bins     
            print('Voltage width of each bar: %s (V)'%(round(de,3)))



    box_layout = widgets.Layout(
			border='dashed 1px gray',
			margin='0px 10px 10px 0px',
			padding='5px 5px 5px 5px',
			width='600px')


    style = {'description_width': 'initial'}

    panel=[{},{}]
    fig= []
    axes=[]

    
    for axis in [0,1]:
        panel[axis]['bins']=widgets.IntSlider(value=10,min=1,max=100,	
                                            step=1,description='Bins: ',continuous_update=False,layout=widgets.Layout(width='400px')	)
        panel[axis]['histcolor']=widgets.Checkbox(value = False,description= 'Hist color by x axis',disable = False)
        panel[axis]['rwidth']=widgets.FloatSlider(value=0.9,min=0.1,max=1,	
                                            step=.1,description='rwidth: ',continuous_update=False,layout=widgets.Layout(width='400px')	)

    colums = [hist_file_metal['a'],hist_file_metal['a_neg']+hist_file_metal['a_pos']]
    label = ['alpha IxV','alpha (dIxdV) ']
    for axis in [0,1]:
        panel[axis]['output']=widgets.interactive_output(plot_hist,{'hist_file_col':widgets.fixed(colums[axis]),
                                                                    'bins':panel[axis]['bins'],
                                                                    'label': widgets.fixed(label[axis]),
                                                                    'monocolor': panel[axis]['histcolor'],
                                                                    'rwidth': panel[axis]['rwidth']})
        panel[axis]['widget'] = widgets.VBox([panel[axis]['output'],panel[axis]['bins'], panel[axis]['histcolor'],panel[axis]['rwidth']],layout=box_layout)
        panel[axis]['widget'].children[0].layout.height = '600px'


    outputPanel = widgets.HBox([panel[0]['widget'],panel[1]['widget']],layout=widgets.Layout(width='1200px'))
    return outputPanel 

def Hist_molecule():
    font = {'size'   : 14}
    matplotlib.rc('font', **font)
    if hist_path_molecula == 'not_path':
        gui = Tk()
        gui.geometry("400x400")
        gui.title('Nanosurf STS Data Analise by Rafael Reis Barreto')
        def getFolderPath():
            global hist_path_molecula
            hist_path_molecula = filedialog.askopenfilename()
            print("File: ",hist_path)
            print("Uploaded")
            gui.destroy()

        btnFind = ttk.Button(gui, text="Open a histogram file", command=getFolderPath)
        btnFind.grid(row=1,column=1)
        gui.mainloop()
    hist_file_molecule = read_csv(hist_path_molecula)
    def plot_hist(hist_file_col,bins,label,rwidth,pizza,thre):
            if pizza == True:
                fig, ax = plt.subplots(figsize = (10,8))
                coluna = hist_file_col.columns
                hist_file_cola = array(hist_file_col['I_pos'])
                hist_file_colb = array(hist_file_col['I_neg'])
                n_neg = 0;n_pos = 0;n_neuto=0
                for i in range(len(hist_file_cola)):
                    if abs(abs(hist_file_cola[i])-abs(hist_file_colb[i]))<=float(thre):
                        n_neuto +=1
                    else:
                        if abs(hist_file_cola[i])>abs(hist_file_colb[i]):
                            n_pos+=1
                        elif abs(hist_file_cola[i])<abs(hist_file_colb[i]):
                            n_neg+=1
                n = n_neg+n_neuto+n_pos
                labels = ['Int. Diff Neg.','Int. Diff. Zero','Int. Diff. Pos.']
                c = ['red','gray','blue']
                values = [n_neg*100/n,n_neuto*100,n_pos*100/n]
                wedges, texts, autote= ax.pie(values, autopct= '%1.1f%%',shadow=True,startangle=90,colors = c)
                ax.legend(wedges,labels, title='Int Values (%)',loc = 'center left')
            else:     
                coluna = hist_file_col.columns
                hist_file_cola = array(hist_file_col['I_pos'])
                hist_file_colb = -array(hist_file_col['I_neg'])
                fig, ax = plt.subplots(figsize = (10,8))
                ax.hist(hist_file_cola,bins = bins,edgecolor='black',rwidth= rwidth,color = 'blue')
                ax.hist(hist_file_colb,bins = bins,edgecolor='black',rwidth= rwidth,color = 'red')
                
                ax.set_xlabel(label)
                ax.set_ylabel('Counting')
                de = rwidth*(hist_file_cola.max()-hist_file_cola.min())/bins     
                print('Voltage width of each bar: %s (V)'%(round(de,3)))



    box_layout = widgets.Layout(
			border='dashed 1px gray',
			margin='0px 10px 10px 0px',
			padding='5px 5px 5px 5px',
			width='600px')


    style = {'description_width': 'initial'}

    panel=[{},{}]
    fig= []
    axes=[]

    
    for axis in [0,1]:
        panel[axis]['bins']=widgets.IntSlider(value=10,min=1,max=100,	
                                                step=1,description='Bins: ',continuous_update=False,layout=widgets.Layout(width='400px')	)

        panel[axis]['rwidth']=widgets.FloatSlider(value=0.9,min=0.1,max=1,	
                                                step=.1,description='rwidth: ',continuous_update=False,layout=widgets.Layout(width='400px')	)
        panel[axis]['threshold'] = widgets.FloatText(
        value=0.0,
        description='Threshold of difference between integral pos and neg:',
        disabled=False,layout=widgets.Layout(width='400px')	
    )

    colums = [hist_file_molecule,hist_file_molecule]
    label = ['alpha IxV','Int. Values ']
    for axis in [0,1]:
        if axis ==0:
            panel[axis]['output']=widgets.interactive_output(plot_hist,{'hist_file_col':widgets.fixed(colums[axis]),
                                                                        'bins':widgets.fixed(panel[axis]['bins']),
                                                                        'label': widgets.fixed(label[axis]),
                                                                        'rwidth': widgets.fixed(panel[axis]['rwidth']),
                                                                        'pizza':widgets.fixed(True),
                                                                        'thre':panel[axis]['threshold']
                                                                        })
            panel[axis]['widget'] = widgets.VBox([panel[axis]['output'],panel[axis]['threshold']],layout=box_layout)
            panel[axis]['widget'].children[0].layout.height = '600px'      
        else:
            panel[axis]['output']=widgets.interactive_output(plot_hist,{'hist_file_col':widgets.fixed(colums[axis]),
                                                                        'bins':panel[axis]['bins'],
                                                                        'label': widgets.fixed(label[axis]),
                                                                        'rwidth': panel[axis]['rwidth'],
                                                                        'pizza':widgets.fixed(False),
                                                                        'thre':widgets.fixed(0)
                                                                        })
            panel[axis]['widget'] = widgets.VBox([panel[axis]['output'],panel[axis]['bins'],panel[axis]['rwidth']],layout=box_layout)
            panel[axis]['widget'].children[0].layout.height = '600px'


    outputPanel = widgets.HBox([panel[0]['widget'],panel[1]['widget']],layout=widgets.Layout(width='1200px'))
    return outputPanel 


def Grid_plot(interactive = False):
    #font = {'size'   : 14}
    #matplotlib.rc('font', **font)
    
    if interactive:
        import matplotlib
        import os
        import numpy as np
        import matplotlib.pyplot as plt
        from ipywidgets import Output, VBox, HBox, FloatSlider, Dropdown, Checkbox, Button, interact
        from scipy.ndimage import gaussian_filter1d
        from IPython.display import display
        # Ensure correct backend for interactive plots
        matplotlib.use('TkAgg')
        # Load your data (replace with actual data)
        x_array, y_array, V_array, current_matrix = files_data[0], files_data[1], files_data[2], files_data[3]

        # Convert current_matrix to nA and ensure it's writable
        current_matrix = np.array(current_matrix, copy=True) * 1e9  # Assuming current is originally in A

        # Output widgets for displaying the heatmap and I-V + dI/dV curve
        output_heatmap = Output()
        output_function = Output()

        # Create folder 'grid_sts' if it doesn't exist
        save_folder = 'grid_sts'
        if not path.exists(save_folder):
            makedirs(save_folder)

        # Custom gap_type function following your detailed logic
        def gap_type(V, I, delta):
            dIdV = np.gradient(I, V)  # Calculate dI/dV
            dIdV_norm = (dIdV - np.min(dIdV)) / (np.max(dIdV) - np.min(dIdV))  # Normalize
            threshold = delta  # Threshold based on delta

            xmin, xmax = None, None

            # Search for xmin from 0V to negative values
            for i in range(np.argmax(V >= 0), -1, -1):
                if dIdV_norm[i] > threshold:
                    xmin = V[i]
                    break

            # Search for xmax from 0V to positive values
            for i in range(np.argmax(V >= 0), len(V)):
                if dIdV_norm[i] > threshold:
                    xmax = V[i]
                    break

            if xmin is None or xmax is None:
                return [0, 0, 0, 0]  # Return zeros if no valid gap is found

            # Calculate the gap and doping type
            gap = abs(xmin) + abs(xmax)
            doping_type = abs(xmax) - abs(xmin)

            return [round(gap, 2), round(doping_type, 2), xmin, xmax]

        # Calculate the current map, derivative map, gap map, and doping map
        def calculate_maps(V_value, delta):
            V_index = np.argmin(np.abs(V_array - V_value))
            derivative_map = np.gradient(current_matrix, axis=2)[:, :, V_index]

            gap_map = np.zeros((current_matrix.shape[0], current_matrix.shape[1]))
            doping_map = np.zeros((current_matrix.shape[0], current_matrix.shape[1]))
            current_map = current_matrix[:, :, V_index]

            for i in range(current_matrix.shape[0]):
                for j in range(current_matrix.shape[1]):
                    V = V_array
                    I = current_matrix[i, j, :]
                    gap, doping, _, _ = gap_type(V, I, delta)
                    gap_map[i, j] = gap
                    doping_map[i, j] = doping

            return current_map, derivative_map, gap_map, doping_map

        # Save all heatmaps as .asc files with headers
        def save_heatmaps_as_asc(current_map, derivative_map, gap_map, doping_map):
            def write_asc(data, filename, header):
                filepath = os.path.join(save_folder, filename)
                np.savetxt(filepath, data, fmt='%.6f', header=header)
                print(f'{filename} saved in {save_folder}.')

            write_asc(current_map, 'current_map.asc', 'Current Map (nA)')
            write_asc(derivative_map, 'derivative_map.asc', 'Derivative Map (dI/dV)')
            write_asc(gap_map, 'gap_map.asc', 'Gap Map (eV)')
            write_asc(doping_map, 'doping_map.asc', 'Doping Map')

        # Export all I-V and dI/dV curves into a single .csv file
        def export_all_curves_to_csv():
            all_data = []
            
            # Loop through each pixel and collect I-V and dI/dV curves
            for i in range(current_matrix.shape[0]):
                for j in range(current_matrix.shape[1]):
                    I = current_matrix[i, j, :]
                    dIdV = np.gradient(I, V_array)
                    data = np.column_stack([V_array, I, dIdV])
                    all_data.append(data)
            
            # Concatenate all data side by side
            concatenated_data = np.hstack(all_data)

            # Create column names for each pair (V, I, dI/dV)
            columns = []
            for i in range(current_matrix.shape[0]):
                for j in range(current_matrix.shape[1]):
                    columns += [f'V_{i}_{j}', f'I_{i}_{j}', f'dI/dV_{i}_{j}']
            
            # Create DataFrame and save as CSV
            df = pd.DataFrame(concatenated_data, columns=columns)
            csv_filename = os.path.join(save_folder, 'ixV_dIxdV_curves.csv')
            df.to_csv(csv_filename, index=False)
            print(f'All I-V and dI/dV curves saved as {csv_filename}')

        # Plot I-V and dI/dV curves for the selected pixel (x, y)
        def plot_function(x, y, smooth):
            I = current_matrix[x, y, :]
            dIdV = np.gradient(I, V_array)

            sigma = max(smooth, 1e-6)  # Ensure sigma is not zero
            I_smooth = gaussian_filter1d(I, sigma=sigma)
            dIdV_smooth = gaussian_filter1d(dIdV, sigma=sigma)

            with output_function:
                output_function.clear_output(wait=True)
                fig, ax = plt.subplots(2, 1, figsize=(6, 8))

                ax[0].plot(V_array, I, label='I(V) (nA)', alpha=0.5)
                ax[0].plot(V_array, I_smooth, label=f'Smoothed I(V), σ={smooth}', color='b')
                ax[0].set_xlabel('V (Potential)')
                ax[0].set_ylabel('I (Current) [nA]')
                ax[0].legend()

                ax[1].plot(V_array, dIdV, label='dI/dV', alpha=0.5, color='r')
                ax[1].plot(V_array, dIdV_smooth, label=f'Smoothed dI/dV, σ={smooth}', color='g')
                ax[1].set_xlabel('V (Potential)')
                ax[1].set_ylabel('dI/dV')
                ax[1].legend()

                plt.show()

        # Plot the heatmap based on user-selected parameters
        def plot_heatmap(V_value, map_type, cmap, interpolate_data, smooth, delta):
            current_map, derivative_map, gap_map, doping_map = calculate_maps(V_value, delta)

            with output_heatmap:
                output_heatmap.clear_output(wait=True)
                fig, ax = plt.subplots(figsize=(5, 5))

                data = (current_map if map_type == 'Current' else
                        derivative_map if map_type == 'Derivative' else
                        gap_map if map_type == 'Gap' else doping_map)

                interp_method = 'nearest' if not interpolate_data else 'bilinear'
                cax = ax.imshow(data, cmap=cmap, origin='upper', interpolation=interp_method)
                fig.colorbar(cax, ax=ax, label=f'{map_type} Map')
                plt.title(f'{map_type}  (V = {V_value:.3f} V)')

                def onclick(event):
                    ix, iy = int(event.xdata), int(event.ydata)
                    if 0 <= ix < current_matrix.shape[0] and 0 <= iy < current_matrix.shape[1]:
                        plot_function(ix, iy, smooth)

                fig.canvas.mpl_connect('button_press_event', onclick)
                plt.show()

        # Create interactive widgets
        V_slider = FloatSlider(value=V_array[0], min=V_array.min(), max=V_array.max(), 
                            step=np.round(V_array[1] - V_array[0], 3), description='V (Potential)')
        smooth_slider = FloatSlider(value=0.1, min=0.01, max=5, step=0.1, description='Smoothing (σ)')
        delta_slider = FloatSlider(value=0.1, min=0.01, max=1.0, step=0.01, description='Delta')
        map_selector = Dropdown(options=['Current', 'Derivative', 'Gap', 'Doping'], 
                                value='Current', description='Map Type')
        cmap_selector = Dropdown(options=plt.colormaps(), value='viridis', description='Colormap')
        interpolate_checkbox = Checkbox(value=False, description='Interpolate Data')
        save_button = Button(description='Save Maps to ASC')
        export_curves_button = Button(description='Export All I-V and dI/dV Curves')

        # Save heatmaps on button click
        save_button.on_click(lambda _: save_heatmaps_as_asc(*calculate_maps(V_slider.value, delta_slider.value)))

        # Export I-V and dI/dV curves on button click
        export_curves_button.on_click(lambda _: export_all_curves_to_csv())

        # Use interact to update the heatmap dynamically
        interact(plot_heatmap, V_value=V_slider, map_type=map_selector, cmap=cmap_selector,
                interpolate_data=interpolate_checkbox, smooth=smooth_slider, delta=delta_slider)

        # Display the layout
        display(VBox([HBox([output_heatmap, output_function]), 
                    V_slider, smooth_slider, delta_slider, map_selector, cmap_selector, 
                    interpolate_checkbox, save_button, export_curves_button]))

    else:
        import matplotlib
        import matplotlib.pyplot as plt
        import numpy as np
        from ipywidgets import Output, VBox, HBox, FloatSlider, Dropdown, Checkbox, Button, Layout
        from scipy.ndimage import gaussian_filter1d
        from IPython.display import display

        #matplotlib.use('Agg')
        # Load your data (replace with actual data)
        x_array, y_array, V_array, current_matrix = files_data[0], files_data[1], files_data[2], files_data[3]

        # Convert current_matrix to nA and ensure it's writable
        current_matrix = np.array(current_matrix, copy=True) * 1e9  # Convert current to nA

        # Output widget for displaying the heatmap
        output_heatmap = Output()

        # Custom gap_type function following your detailed logic
        def gap_type(V, I, delta):
            dIdV = np.gradient(I, V)  # Calculate dI/dV
            dIdV_norm = (dIdV - np.min(dIdV)) / (np.max(dIdV) - np.min(dIdV))  # Normalize
            threshold = delta  # Set the threshold

            xmin, xmax = None, None

            # Search for xmin from 0V to negative values
            for i in range(np.argmax(V >= 0), -1, -1):
                if dIdV_norm[i] > threshold:
                    xmin = V[i]
                    break

            # Search for xmax from 0V to positive values
            for i in range(np.argmax(V >= 0), len(V)):
                if dIdV_norm[i] > threshold:
                    xmax = V[i]
                    break

            if xmin is None or xmax is None:
                return [0, 0, 0, 0]  # Return zeros if no valid gap is found

            gap = abs(xmin) + abs(xmax)
            doping_type = abs(xmax) - abs(xmin)

            return [round(gap, 2), round(doping_type, 2), xmin, xmax]

        # Calculate the current map, derivative map, gap map, and doping map
        def calculate_maps(V_value, delta):
            V_index = np.argmin(np.abs(V_array - V_value))
            derivative_map = np.gradient(current_matrix, axis=2)[:, :, V_index]

            gap_map = np.zeros((current_matrix.shape[0], current_matrix.shape[1]))
            doping_map = np.zeros((current_matrix.shape[0], current_matrix.shape[1]))
            current_map = current_matrix[:, :, V_index]

            for i in range(current_matrix.shape[0]):
                for j in range(current_matrix.shape[1]):
                    V = V_array
                    I = current_matrix[i, j, :]
                    gap, doping, _, _ = gap_type(V, I, delta)
                    gap_map[i, j] = gap
                    doping_map[i, j] = doping

            return current_map, derivative_map, gap_map, doping_map

        # Function to update the heatmap display
        def update_heatmap(*args):
            V_value = V_slider.value
            map_type = map_selector.value
            cmap = cmap_selector.value
            interpolate_data = interpolate_checkbox.value
            delta = delta_slider.value

            current_map, derivative_map, gap_map, doping_map = calculate_maps(V_value, delta)

            data = (current_map if map_type == 'Current' else
                    derivative_map if map_type == 'Derivative' else
                    gap_map if map_type == 'Gap' else doping_map)

            with output_heatmap:
                output_heatmap.clear_output(wait=True)
                fig, ax = plt.subplots(figsize=(5, 5))
                interp_method = 'nearest' if not interpolate_data else 'bilinear'
                cax = ax.imshow(data, cmap=cmap, origin='upper', interpolation=interp_method)
                fig.colorbar(cax, ax=ax, label=f'{map_type} Map')
                plt.title(f'{map_type} (V = {V_value:.3f} V)')
                plt.show()

        # Save all heatmaps as .asc files with headers
        def save_heatmaps_as_asc(*args):
            current_map, derivative_map, gap_map, doping_map = calculate_maps(V_slider.value, delta_slider.value)

            def write_asc(data, filename, header):
                np.savetxt(filename, data, fmt='%.6f', header=header)
                print(f'{filename} saved.')

            write_asc(current_map, 'current_map.asc', 'Current Map (nA)')
            write_asc(derivative_map, 'derivative_map.asc', 'Derivative Map (dI/dV)')
            write_asc(gap_map, 'gap_map.asc', 'Gap Map (eV)')
            write_asc(doping_map, 'doping_map.asc', 'Doping Map')

        # Create interactive widgets
        V_slider = FloatSlider(value=V_array[0], min=V_array.min(), max=V_array.max(),
                            step=np.round(V_array[1] - V_array[0], 3), description='V (Potential)')
        smooth_slider = FloatSlider(value=0.1, min=0.01, max=5, step=0.1, description='Smoothing (σ)')
        delta_slider = FloatSlider(value=0.1, min=0.01, max=1.0, step=0.01, description='Delta')
        map_selector = Dropdown(options=['Current', 'Derivative', 'Gap', 'Doping'],
                                value='Current', description='Map Type')
        cmap_selector = Dropdown(options=plt.colormaps(), value='viridis', description='Colormap')
        interpolate_checkbox = Checkbox(value=False, description='Interpolate Data')
        save_button = Button(description='Save Maps to ASC')

        # Attach update functions to widgets
        V_slider.observe(update_heatmap, names='value')
        delta_slider.observe(update_heatmap, names='value')
        map_selector.observe(update_heatmap, names='value')
        cmap_selector.observe(update_heatmap, names='value')
        interpolate_checkbox.observe(update_heatmap, names='value')
        save_button.on_click(save_heatmaps_as_asc)

        # Display the layout
        display(VBox([output_heatmap, 
                    V_slider, delta_slider, map_selector, cmap_selector, 
                    interpolate_checkbox, save_button]))

        # Initial heatmap display
        update_heatmap()






def Grid_plot2_old():
    font = {'size'   : 14}
    matplotlib.rc('font', **font)
    #file = load_file(folder)
    def save_matrix(x,y,M,name,tipo):
            folder_save = 'sts_saves'
            for i in range(1,len(name[:-4])):
                if name[len(name[:-4]) -i] == '/':
                    ct = len(name[:-4]) -i
                    break
            try:
                #folder_name = path.join(folder_save,path_file[:-4][ct:])
                folder_name= folder_save+name[:-4][ct:]
            except UnboundLocalError:
                ct = 0
                #folder_name = path.join(folder_save,path_file[ct:-4])
                folder_name= folder_save+'/'+ name[:-4][ct:]
            try: 
                mkdir(folder_save )
            except FileExistsError:
                pass
                
            paste =folder_name
            try:
                mkdir(paste)
            except FileExistsError:
                pass
            arq = open(paste+'/grid'+tipo+'_.txt','w')
            arq.writelines('Grid of '+tipo)
            line ='x: '
            for item in x:
                line+=str(item)+','
            line +='\n'
            arq.writelines(line)
            line ='y: '
            for item in y:
                line+=str(item)+','
            line +='\n'            
            arq.writelines(line)
            line = 'z :'
            for i in range(len(M)):
                if i ==0:
                    for j in range(len(M[0])):
                        line+=str(M[i][j])+','
                    line += '\n'
                    arq.writelines(line)
                else:
                    line =''
                    for j in range(len(M[0])):
                        line+=str(M[i][j])+','
                    line += '\n'
                    arq.writelines(line)
            arq.close()
            print('File saved at '+paste)

    if stm =='Nanosurf':
        file = files_data['ixv']
        def get_matrix(dfs,delta,nx=20,V=0):
            files = []
            for i in range(len(dfs)):
                columns = dfs[i].columns
                x = dfs[i][columns[0]];y = dfs[i][columns[1]]*pow(10,9)
                files.append([x,y])
            ny = int(len(dfs)/nx)
            M_didv = [];M_dop = [];M_gap = []
            for i in range(nx):
                col_didv = [];col_dop = [];col_gap = []
                for j in range(ny):
                    x,y = files[j+i*ny]
                    dx,dy = didv(x,y)
                    gap,typ,xmin,xmax = gap_type(dx,dy,delta/100)
                    dyinterp = interpolate.interp1d(dx,dy)

                    col_didv.append(dyinterp(V))
                    col_dop.append(round(typ,3))
                    col_gap.append(round(gap,3))
                M_didv.append(array(col_didv));M_dop.append(array(col_dop));M_gap.append(array(col_gap))

            M_didv = array(M_didv);M_dop = array(M_dop);M_gap = array(M_gap)
            x = arange(nx);y=arange(ny)
            return [x,y,[M_didv,M_gap,M_dop]]

        def plot_mapa2(file,whichmap,delta = 5,interpolation= False,mult=2,cmap = 'viridis',nx = 20,save_mat=False):
            x,y,mapas = get_matrix(file,delta,nx=nx)
            M=mapas[whichmap]

            fig,ax= plt.subplots(figsize=(10,8))

            if interpolation == True:
                nx = len(x);ny=len(y)

                x,y,M = inter_x(x,y,M,dx=mult*nx,dy = mult*ny)

            Y,X = meshgrid(y,x)
            im = ax.pcolormesh(X,Y,M,cmap = cmap)
            if save_mat:
                if axis==1:
                    save_matrix(x,y,M,folder,' Gap')
                elif axis==2:
                    save_matrix(x,y,M,folder,' Doping')
            if whichmap==1:
                cbar = fig.colorbar(im)
                cbar.set_ticks([M.min(),M.max()],labels= ['Gap ','No Gap'])
            elif whichmap==2:
                cbar = fig.colorbar(im)
                cbar.set_ticks([M.min(),0,M.max()],labels= ['N ','Neutro','P'])

            #im2 = ax[2].pcolormesh(X,Y,M_dop,cmap = cmap)
            #cbar = fig.colorbar(im2)
            #cbar.set_ticks([M_dop.min(),0,M_dop.max()],labels= ['N ','Neutro','P'])

        def plot_mapa(file,whichmap,V = 0,delta = 5,interpolation= False,mult=2,cmap = 'viridis',nx =20,save_mat=False):
            x,y,mapas = get_matrix(file,delta,V=V,nx = nx)
            M=mapas[whichmap]

            fig,ax= plt.subplots(figsize=(10,8))

            if interpolation == True:
                nx = len(x);ny=len(y)

                x,y,M = inter_x(x,y,M,dx=mult*nx,dy = mult*ny)
            if save_mat:
                save_matrix(x,y,M,folder,' dIdV at '+str(V)+' V')
            Y,X = meshgrid(y,x)
            im = ax.pcolormesh(X,Y,M,cmap = cmap)
            cbar = fig.colorbar(im)


        box_layout = widgets.Layout(
                border='dashed 1px gray',
                margin='0px 10px 10px 0px',
                padding='5px 5px 5px 5px',
                width='600px')

        panel=[{},{},{}]
        fig= []
        axes=[]
        for axis in [0,1,2]:
            if axis ==0:
                panel[axis]['vslider']=widgets.widgets.FloatSlider(
                value=0,min=file[2][0],max=file[2][1],	step=.2,description='Sample Bias (V): ',continuous_update=False,layout=widgets.Layout(width='300px')	)
            panel[axis]['deltaslider']=widgets.widgets.FloatSlider(
            value=5,min=.5,max=20,	step=.5,description='Threshold: ',continuous_update=False,layout=widgets.Layout(width='300px')	)  
            panel[axis]['interpolation']=widgets.Checkbox(value = False,description= 'Interpolation',disable = False)
            panel[axis]['mult']=widgets.widgets.IntSlider(
            value=2,min=1,max=20,	step=1,description='Multiplicity of interpolation ',continuous_update=False,layout=widgets.Layout(width='300px'))	
            panel[axis]['nx']=widgets.IntText(  value=20, description='Number of points per line. Nanosurf software',  disabled=False
    )
            panel[axis]['colormap'] = widgets.Dropdown(
            options=['bone_r', 'inferno', 'viridis','plasma', 'cividis','gray','OrRd','PuBuGn','coolwarm','bwr','terrain'],
            value='viridis',
            description='Colormap:',
            )
            panel[axis]['save']  = widgets.Checkbox(value = False,description= 'Save matrix file ',disable = False)

        for axis in [0,1,2]:

            if axis ==0:
                panel[axis]['output']=widgets.interactive_output(plot_mapa,{'file':widgets.fixed(file[0]),
                                                                        'whichmap':widgets.fixed(axis),
                                                                        'V':panel[axis]['vslider'],
                                                                        'delta': panel[axis]['deltaslider'],
                                                                        'interpolation': panel[axis]['interpolation'],
                                                                        'mult': panel[axis]['mult'],
                                                                        'cmap':panel[axis]['colormap'],
                                                                        'nx':panel[axis]['nx'],'save_mat':panel[axis]['save']
                                                                        })
                panel[axis]['widget'] = widgets.VBox([panel[axis]['output'],panel[axis]['vslider'], panel[axis]['deltaslider'],
                                                panel[axis]['interpolation'],panel[axis]['mult'],panel[axis]['colormap'],panel[axis]['nx'],panel[axis]['save'] ],layout=box_layout)
                panel[axis]['widget'].children[0].layout.height = '400px'
            else:
                panel[axis]['output']=widgets.interactive_output(plot_mapa2,{'file':widgets.fixed(file[0]),
                                                                        'whichmap':widgets.fixed(axis),
                                                                        'delta': panel[axis]['deltaslider'],
                                                                        'interpolation': panel[axis]['interpolation'],
                                                                        'mult': panel[axis]['mult'],
                                                                        'cmap':panel[axis]['colormap'],
                                                                        'nx':panel[axis]['nx'],
                                                                        'save_mat':panel[axis]['save']
                                                                        })
                panel[axis]['widget'] = widgets.VBox([panel[axis]['output'],panel[axis]['deltaslider'],
                                                panel[axis]['interpolation'],panel[axis]['mult'],panel[axis]['colormap'],panel[axis]['nx'],panel[axis]['save'] ],layout=box_layout)
            panel[axis]['widget'].children[0].layout.height = '600px'


        outputPanel = widgets.HBox([panel[0]['widget'],panel[1]['widget'],panel[2]['widget']],layout=widgets.Layout(width='1800px'))
        return outputPanel
    elif stm == 'Omicron':
        



        #def map_spip_temp(map_file):
        #    arquivo = open_file(map_file)
        #    for line in arquivo:
        #        if ('z-range' in line) == True:
        #            z_range = float(line[3])*pow(10,-9)
        #        elif ('z-points' in line) == True:
        #            z_points = int(line[3])                 
        #        
        #
        #    V_start = -z_range/2
        #    V_end = z_range/2
        #    dv = (V_end -V_start)/(z_points)
        #    V = []
        #    number = V_start
        #    for i in range(z_points):
        #        V.append(number)
        #        number+=dv
        #        number  = round(number,3)
        #    V = array(V)
        #
        #    return [arquivo,V]


        def map_spip(arquivo,delta = 5,V_thre=0):
            matriz = []
            i = 0
            for line in arquivo:
                if ('x-pixels' in line) == True:
                    n = int(line[3])
                elif ('y-pixels' in line) == True:
                    m = int(line[3])
                elif ('x-length' in line) == True:
                    x_leng = float(line[3]) 
                elif ('y-length' in line) == True:
                    y_leng = float(line[3])
                elif ('x-offset' in line) == True:
                    x_ofsset = float(line[3]) 
                elif ('y-offset' in line) == True:
                    y_ofsset = float(line[3]) 
                elif ('z-range' in line) == True:
                    z_range = float(line[3])*pow(10,-9)
                elif ('z-points' in line) == True:
                    z_points = int(line[3])                 
                
                elif  ('Start' in line) == True and ('of' in line) == True and ('Data:' in line) == True:
                    break 
                i+=1
            
            
            dx = (x_leng)/n
            x = arange(-x_leng/2,x_leng/2,dx)-x_ofsset
            dy = (y_leng)/m
            y = arange(-y_leng/2,y_leng/2,dy)-y_ofsset


        
            sts_all =array(list(map(lambda x:array(list(map( lambda y:float(y),x))), arquivo[i+1:])))
            V_points = len(sts_all[0])
            V_start = -z_range/2
            V_end = z_range/2
            dv = (V_end -V_start)/(V_points)
            V = []
            number = V_start
            for i in range(V_points):
                V.append(number)
                number+=dv
                number  = round(number,3)
            V = array(V)
            matriz = []
            for j in range(m):
                col = []
                for i in range(n):
                    col.append(sts_all[j+(n-i-1)*n])
                matriz.append(array(col))

            nx = len(x);ny =len(y)
            M_didv = [];M_dop=[];M_gap = []
            for i in range(nx):
                col_didv = [];col_dop = [];col_gap = []
                for j in range(ny):
                    dx,dy = didv(V,matriz[i][j])
                    gap,typ,xmin,xmax = gap_type(dx,dy,delta/100)
                    
                    dyinterp = interpolate.interp1d(dx,dy)

                    col_didv.append(dyinterp(V_thre))
                    col_dop.append(round(typ,3))
                    col_gap.append(round(gap,3))
                M_didv.append(array(col_didv));M_dop.append(array(col_dop));M_gap.append(array(col_gap))

            M_didv = array(M_didv);M_dop = array(M_dop);M_gap = array(M_gap)
            return [x,y,[M_didv,M_gap,M_dop]]

        
        def plot_mapa2(arquivo,whichmap,delta = 5,interpolation= False,mult=2,cmap = 'viridis',save_mat=False):
            global folder
            x,y,V,M = files_data
            x,y,mapas =map_spip(arquivo,delta = delta)
            M=mapas[whichmap]

                
            fig,ax= plt.subplots(figsize=(10,8))

            if interpolation == True:
                nx = len(x);ny=len(y)

                x,y,M = inter_x(x,y,M,dx=mult*nx,dy = mult*ny)

            Y,X = meshgrid(y,x)
            im = ax.pcolormesh(X,Y,M,cmap = cmap)
            ax.set_xlabel('Distance (nm)')
            ax.set_ylabel('Distance (nm)')
            if whichmap==1:
                cbar = fig.colorbar(im)
                cbar.set_ticks([M.min(),M.max()],labels= ['Gap ','No Gap'])
            elif whichmap==2:
                cbar = fig.colorbar(im)
                cbar.set_ticks([M.min(),0,M.max()],labels= ['N ','Neutro','P'])

            if save_mat:
                if axis==1:
                    save_matrix(x,y,M,folder,' Gap')
                elif axis==2:
                    save_matrix(x,y,M,folder,' Doping')
            #im2 = ax[2].pcolormesh(X,Y,M_dop,cmap = cmap)
            #cbar = fig.colorbar(im2)
            #cbar.set_ticks([M_dop.min(),0,M_dop.max()],labels= ['N ','Neutro','P'])

        def plot_mapa(arquivo,whichmap,V = 0,delta = 5,interpolation= False,mult=2,cmap = 'viridis',save_mat=False):
            x,y,mapas =map_spip(arquivo,delta = delta,V_thre=V)
            M=mapas[whichmap]
            fig,ax= plt.subplots(figsize=(10,8))

            if interpolation == True:
                nx = len(x);ny=len(y)

                x,y,M = inter_x(x,y,M,dx=mult*nx,dy = mult*ny)

            Y,X = meshgrid(y,x)
            im = ax.pcolormesh(X,Y,M,cmap = cmap)
            cbar = fig.colorbar(im)
            ax.set_xlabel('Distance (nm)')
            ax.set_ylabel('Distance (nm)')
            if save_mat:
                save_matrix(x,y,M,folder,' dIdV at '+str(V)+' V')



        box_layout = widgets.Layout(
                border='dashed 1px gray',
                margin='0px 10px 10px 0px',
                padding='5px 5px 5px 5px',
                width='600px')

        arquivo,V = map_spip_temp(folder)
        
        
        panel=[{},{},{}]
        fig= []
        axes=[]
        for axis in [0,1,2]:
            if axis ==0:
                panel[axis]['vslider']=widgets.widgets.FloatSlider(
                value=0,min=V.min(),max=V.max(),	step=.2,description='Sample Bias (V): ',continuous_update=False,layout=widgets.Layout(width='300px')	)
            panel[axis]['deltaslider']=widgets.widgets.FloatSlider(
            value=5,min=.5,max=20,	step=.5,description='Threshold: ',continuous_update=False,layout=widgets.Layout(width='300px')	)  
            panel[axis]['interpolation']=widgets.Checkbox(value = False,description= 'Interpolation',disable = False)
            panel[axis]['mult']=widgets.widgets.IntSlider(
            value=2,min=1,max=20,	step=1,description='Multiplicity of interpolation ',continuous_update=False,layout=widgets.Layout(width='300px'))	
            panel[axis]['colormap'] = widgets.Dropdown(
            options=['bone_r', 'inferno', 'viridis','plasma', 'cividis','gray','OrRd','PuBuGn','coolwarm','bwr','terrain'],
            value='viridis',
            description='Colormap:',
            )       
            panel[axis]['save']  = widgets.Checkbox(value = False,description= 'Save matrix file ',disable = False)


        for axis in [0,1,2]:

            if axis ==0:
                panel[axis]['output']=widgets.interactive_output(plot_mapa,{'arquivo':widgets.fixed(arquivo),
                                                                        'whichmap':widgets.fixed(axis),
                                                                        'V':panel[axis]['vslider'],
                                                                        'delta': panel[axis]['deltaslider'],
                                                                        'interpolation': panel[axis]['interpolation'],
                                                                        'mult': panel[axis]['mult'],
                                                                        'cmap':panel[axis]['colormap'],
                                                                        'save_mat':panel[axis]['save']
                                                                        })
                panel[axis]['widget'] = widgets.VBox([panel[axis]['output'],panel[axis]['vslider'], panel[axis]['deltaslider'],
                                                panel[axis]['interpolation'],panel[axis]['mult'],panel[axis]['colormap'],panel[axis]['save']],layout=box_layout)
                panel[axis]['widget'].children[0].layout.height = '400px'
            else:
                panel[axis]['output']=widgets.interactive_output(plot_mapa2,{'arquivo':widgets.fixed(arquivo),
                                                                        'whichmap':widgets.fixed(axis),
                                                                        'delta': panel[axis]['deltaslider'],
                                                                        'interpolation': panel[axis]['interpolation'],
                                                                        'mult': panel[axis]['mult'],
                                                                        'cmap':panel[axis]['colormap'],
                                                                        'save_mat':panel[axis]['save']
                                                                        })
                panel[axis]['widget'] = widgets.VBox([panel[axis]['output'],panel[axis]['deltaslider'],
                                                panel[axis]['interpolation'],panel[axis]['mult'],panel[axis]['colormap'],panel[axis]['save']],layout=box_layout)
            panel[axis]['widget'].children[0].layout.height = '600px'


        outputPanel = widgets.HBox([panel[0]['widget'],panel[1]['widget'],panel[2]['widget']],layout=widgets.Layout(width='1800px'))
        return outputPanel




