"""

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 0.0.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from satnogsnetworkapiclient.api_client import ApiClient, Endpoint as _Endpoint
from satnogsnetworkapiclient.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from satnogsnetworkapiclient.model.job import Job
from satnogsnetworkapiclient.model.new_observation import NewObservation
from satnogsnetworkapiclient.model.observation import Observation
from satnogsnetworkapiclient.model.paginated_observation_list import PaginatedObservationList
from satnogsnetworkapiclient.model.paginated_station_list import PaginatedStationList
from satnogsnetworkapiclient.model.paginated_transmitter_list import PaginatedTransmitterList
from satnogsnetworkapiclient.model.patched_observation import PatchedObservation
from satnogsnetworkapiclient.model.station import Station
from satnogsnetworkapiclient.model.transmitter import Transmitter


class ApiApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __api_jobs_list(
            self,
            **kwargs
        ):
            """api_jobs_list  # noqa: E501

            SatNOGS Network Job API view class  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.api_jobs_list(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                end (datetime): [optional]
                ground_station (int, none_type): [optional]
                id (int): [optional]
                satellite__norad_cat_id (int): [optional]
                start (datetime): [optional]
                status (str): [optional]
                transmitter_mode (str, none_type): [optional]
                transmitter_type (str): [optional]
                transmitter_uuid (str): [optional]
                vetted_status (str): Vetted status (deprecated: please use Status). [optional]
                vetted_user (int, none_type): Vetted user (deprecated: will be removed in next version). [optional]
                waterfall_status (bool, none_type): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                [Job]
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.api_jobs_list = _Endpoint(
            settings={
                'response_type': ([Job],),
                'auth': [
                    'tokenAuth'
                ],
                'endpoint_path': '/api/jobs/',
                'operation_id': 'api_jobs_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'end',
                    'ground_station',
                    'id',
                    'satellite__norad_cat_id',
                    'start',
                    'status',
                    'transmitter_mode',
                    'transmitter_type',
                    'transmitter_uuid',
                    'vetted_status',
                    'vetted_user',
                    'waterfall_status',
                ],
                'required': [],
                'nullable': [
                    'ground_station',
                    'transmitter_mode',
                    'vetted_user',
                    'waterfall_status',
                ],
                'enum': [
                    'status',
                    'transmitter_type',
                    'vetted_status',
                    'waterfall_status',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('status',): {

                        "BAD": "bad",
                        "FAILED": "failed",
                        "FUTURE": "future",
                        "GOOD": "good",
                        "UNKNOWN": "unknown"
                    },
                    ('transmitter_type',): {

                        "TRANSCEIVER": "Transceiver",
                        "TRANSMITTER": "Transmitter",
                        "TRANSPONDER": "Transponder"
                    },
                    ('vetted_status',): {

                        "BAD": "bad",
                        "FAILED": "failed",
                        "GOOD": "good",
                        "UNKNOWN": "unknown"
                    },
                    ('waterfall_status',): {
                        'None': None,
                        "FALSE": "false",
                        "FALSE": "false"
                    },
                },
                'openapi_types': {
                    'end':
                        (datetime,),
                    'ground_station':
                        (int, none_type,),
                    'id':
                        (int,),
                    'satellite__norad_cat_id':
                        (int,),
                    'start':
                        (datetime,),
                    'status':
                        (str,),
                    'transmitter_mode':
                        (str, none_type,),
                    'transmitter_type':
                        (str,),
                    'transmitter_uuid':
                        (str,),
                    'vetted_status':
                        (str,),
                    'vetted_user':
                        (int, none_type,),
                    'waterfall_status':
                        (bool, none_type,),
                },
                'attribute_map': {
                    'end': 'end',
                    'ground_station': 'ground_station',
                    'id': 'id',
                    'satellite__norad_cat_id': 'satellite__norad_cat_id',
                    'start': 'start',
                    'status': 'status',
                    'transmitter_mode': 'transmitter_mode',
                    'transmitter_type': 'transmitter_type',
                    'transmitter_uuid': 'transmitter_uuid',
                    'vetted_status': 'vetted_status',
                    'vetted_user': 'vetted_user',
                    'waterfall_status': 'waterfall_status',
                },
                'location_map': {
                    'end': 'query',
                    'ground_station': 'query',
                    'id': 'query',
                    'satellite__norad_cat_id': 'query',
                    'start': 'query',
                    'status': 'query',
                    'transmitter_mode': 'query',
                    'transmitter_type': 'query',
                    'transmitter_uuid': 'query',
                    'vetted_status': 'query',
                    'vetted_user': 'query',
                    'waterfall_status': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__api_jobs_list
        )

        def __api_jobs_retrieve(
            self,
            id,
            **kwargs
        ):
            """api_jobs_retrieve  # noqa: E501

            SatNOGS Network Job API view class  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.api_jobs_retrieve(id, async_req=True)
            >>> result = thread.get()

            Args:
                id (int): A unique integer value identifying this observation.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Job
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['id'] = \
                id
            return self.call_with_http_info(**kwargs)

        self.api_jobs_retrieve = _Endpoint(
            settings={
                'response_type': (Job,),
                'auth': [
                    'tokenAuth'
                ],
                'endpoint_path': '/api/jobs/{id}/',
                'operation_id': 'api_jobs_retrieve',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__api_jobs_retrieve
        )

        def __api_observations_create(
            self,
            new_observation,
            **kwargs
        ):
            """api_observations_create  # noqa: E501

            Creates observations from a list of observation data  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.api_observations_create(new_observation, async_req=True)
            >>> result = thread.get()

            Args:
                new_observation (NewObservation):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                NewObservation
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['new_observation'] = \
                new_observation
            return self.call_with_http_info(**kwargs)

        self.api_observations_create = _Endpoint(
            settings={
                'response_type': (NewObservation,),
                'auth': [
                    'tokenAuth'
                ],
                'endpoint_path': '/api/observations/',
                'operation_id': 'api_observations_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'new_observation',
                ],
                'required': [
                    'new_observation',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'new_observation':
                        (NewObservation,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'new_observation': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client,
            callable=__api_observations_create
        )

        def __api_observations_list(
            self,
            **kwargs
        ):
            """api_observations_list  # noqa: E501

            SatNOGS Network Observation API view class  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.api_observations_list(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                end (datetime): [optional]
                ground_station (int, none_type): [optional]
                id (int): [optional]
                page (int): A page number within the paginated result set.. [optional]
                satellite__norad_cat_id (int): [optional]
                start (datetime): [optional]
                status (str): [optional]
                transmitter_mode (str, none_type): [optional]
                transmitter_type (str): [optional]
                transmitter_uuid (str): [optional]
                vetted_status (str): Vetted status (deprecated: please use Status). [optional]
                vetted_user (int, none_type): Vetted user (deprecated: will be removed in next version). [optional]
                waterfall_status (bool, none_type): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                PaginatedObservationList
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.api_observations_list = _Endpoint(
            settings={
                'response_type': (PaginatedObservationList,),
                'auth': [
                    'tokenAuth'
                ],
                'endpoint_path': '/api/observations/',
                'operation_id': 'api_observations_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'end',
                    'ground_station',
                    'id',
                    'page',
                    'satellite__norad_cat_id',
                    'start',
                    'status',
                    'transmitter_mode',
                    'transmitter_type',
                    'transmitter_uuid',
                    'vetted_status',
                    'vetted_user',
                    'waterfall_status',
                ],
                'required': [],
                'nullable': [
                    'ground_station',
                    'transmitter_mode',
                    'vetted_user',
                    'waterfall_status',
                ],
                'enum': [
                    'status',
                    'transmitter_type',
                    'vetted_status',
                    'waterfall_status',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('status',): {

                        "BAD": "bad",
                        "FAILED": "failed",
                        "FUTURE": "future",
                        "GOOD": "good",
                        "UNKNOWN": "unknown"
                    },
                    ('transmitter_type',): {

                        "TRANSCEIVER": "Transceiver",
                        "TRANSMITTER": "Transmitter",
                        "TRANSPONDER": "Transponder"
                    },
                    ('vetted_status',): {

                        "BAD": "bad",
                        "FAILED": "failed",
                        "GOOD": "good",
                        "UNKNOWN": "unknown"
                    },
                    ('waterfall_status',): {
                        'None': None,
                        "FALSE": "false",
                        "FALSE": "false"
                    },
                },
                'openapi_types': {
                    'end':
                        (datetime,),
                    'ground_station':
                        (int, none_type,),
                    'id':
                        (int,),
                    'page':
                        (int,),
                    'satellite__norad_cat_id':
                        (int,),
                    'start':
                        (datetime,),
                    'status':
                        (str,),
                    'transmitter_mode':
                        (str, none_type,),
                    'transmitter_type':
                        (str,),
                    'transmitter_uuid':
                        (str,),
                    'vetted_status':
                        (str,),
                    'vetted_user':
                        (int, none_type,),
                    'waterfall_status':
                        (bool, none_type,),
                },
                'attribute_map': {
                    'end': 'end',
                    'ground_station': 'ground_station',
                    'id': 'id',
                    'page': 'page',
                    'satellite__norad_cat_id': 'satellite__norad_cat_id',
                    'start': 'start',
                    'status': 'status',
                    'transmitter_mode': 'transmitter_mode',
                    'transmitter_type': 'transmitter_type',
                    'transmitter_uuid': 'transmitter_uuid',
                    'vetted_status': 'vetted_status',
                    'vetted_user': 'vetted_user',
                    'waterfall_status': 'waterfall_status',
                },
                'location_map': {
                    'end': 'query',
                    'ground_station': 'query',
                    'id': 'query',
                    'page': 'query',
                    'satellite__norad_cat_id': 'query',
                    'start': 'query',
                    'status': 'query',
                    'transmitter_mode': 'query',
                    'transmitter_type': 'query',
                    'transmitter_uuid': 'query',
                    'vetted_status': 'query',
                    'vetted_user': 'query',
                    'waterfall_status': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__api_observations_list
        )

        def __api_observations_partial_update(
            self,
            id,
            **kwargs
        ):
            """api_observations_partial_update  # noqa: E501

            SatNOGS Network Observation API view class  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.api_observations_partial_update(id, async_req=True)
            >>> result = thread.get()

            Args:
                id (int): A unique integer value identifying this observation.

            Keyword Args:
                patched_observation (PatchedObservation): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Observation
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['id'] = \
                id
            return self.call_with_http_info(**kwargs)

        self.api_observations_partial_update = _Endpoint(
            settings={
                'response_type': (Observation,),
                'auth': [
                    'tokenAuth'
                ],
                'endpoint_path': '/api/observations/{id}/',
                'operation_id': 'api_observations_partial_update',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'patched_observation',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'patched_observation':
                        (PatchedObservation,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                    'patched_observation': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client,
            callable=__api_observations_partial_update
        )

        def __api_observations_retrieve(
            self,
            id,
            **kwargs
        ):
            """api_observations_retrieve  # noqa: E501

            SatNOGS Network Observation API view class  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.api_observations_retrieve(id, async_req=True)
            >>> result = thread.get()

            Args:
                id (int): A unique integer value identifying this observation.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Observation
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['id'] = \
                id
            return self.call_with_http_info(**kwargs)

        self.api_observations_retrieve = _Endpoint(
            settings={
                'response_type': (Observation,),
                'auth': [
                    'tokenAuth'
                ],
                'endpoint_path': '/api/observations/{id}/',
                'operation_id': 'api_observations_retrieve',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__api_observations_retrieve
        )

        def __api_observations_update(
            self,
            id,
            **kwargs
        ):
            """api_observations_update  # noqa: E501

            Updates observation with audio, waterfall or demoded data  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.api_observations_update(id, async_req=True)
            >>> result = thread.get()

            Args:
                id (int): A unique integer value identifying this observation.

            Keyword Args:
                observation (Observation): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Observation
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['id'] = \
                id
            return self.call_with_http_info(**kwargs)

        self.api_observations_update = _Endpoint(
            settings={
                'response_type': (Observation,),
                'auth': [
                    'tokenAuth'
                ],
                'endpoint_path': '/api/observations/{id}/',
                'operation_id': 'api_observations_update',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'observation',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'observation':
                        (Observation,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                    'observation': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client,
            callable=__api_observations_update
        )

        def __api_stations_list(
            self,
            **kwargs
        ):
            """api_stations_list  # noqa: E501

            SatNOGS Network Station API view class  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.api_stations_list(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                client_version (str): [optional]
                id (int): [optional]
                name (str): [optional]
                page (int): A page number within the paginated result set.. [optional]
                status (int): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                PaginatedStationList
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.api_stations_list = _Endpoint(
            settings={
                'response_type': (PaginatedStationList,),
                'auth': [
                    'tokenAuth'
                ],
                'endpoint_path': '/api/stations/',
                'operation_id': 'api_stations_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'client_version',
                    'id',
                    'name',
                    'page',
                    'status',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'status',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('status',): {

                        "0": 0,
                        "1": 1,
                        "2": 2
                    },
                },
                'openapi_types': {
                    'client_version':
                        (str,),
                    'id':
                        (int,),
                    'name':
                        (str,),
                    'page':
                        (int,),
                    'status':
                        (int,),
                },
                'attribute_map': {
                    'client_version': 'client_version',
                    'id': 'id',
                    'name': 'name',
                    'page': 'page',
                    'status': 'status',
                },
                'location_map': {
                    'client_version': 'query',
                    'id': 'query',
                    'name': 'query',
                    'page': 'query',
                    'status': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__api_stations_list
        )

        def __api_stations_retrieve(
            self,
            id,
            **kwargs
        ):
            """api_stations_retrieve  # noqa: E501

            SatNOGS Network Station API view class  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.api_stations_retrieve(id, async_req=True)
            >>> result = thread.get()

            Args:
                id (int): A unique integer value identifying this station.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Station
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['id'] = \
                id
            return self.call_with_http_info(**kwargs)

        self.api_stations_retrieve = _Endpoint(
            settings={
                'response_type': (Station,),
                'auth': [
                    'tokenAuth'
                ],
                'endpoint_path': '/api/stations/{id}/',
                'operation_id': 'api_stations_retrieve',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__api_stations_retrieve
        )

        def __api_transmitters_list(
            self,
            **kwargs
        ):
            """api_transmitters_list  # noqa: E501

            SatNOGS Network Transmitter API view class  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.api_transmitters_list(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                page (int): A page number within the paginated result set.. [optional]
                uuid (str): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                PaginatedTransmitterList
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.api_transmitters_list = _Endpoint(
            settings={
                'response_type': (PaginatedTransmitterList,),
                'auth': [
                    'tokenAuth'
                ],
                'endpoint_path': '/api/transmitters/',
                'operation_id': 'api_transmitters_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'page',
                    'uuid',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'page':
                        (int,),
                    'uuid':
                        (str,),
                },
                'attribute_map': {
                    'page': 'page',
                    'uuid': 'uuid',
                },
                'location_map': {
                    'page': 'query',
                    'uuid': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__api_transmitters_list
        )

        def __api_transmitters_retrieve(
            self,
            transmitter_uuid,
            **kwargs
        ):
            """api_transmitters_retrieve  # noqa: E501

            SatNOGS Network Transmitter API view class  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.api_transmitters_retrieve(transmitter_uuid, async_req=True)
            >>> result = thread.get()

            Args:
                transmitter_uuid (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Transmitter
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['transmitter_uuid'] = \
                transmitter_uuid
            return self.call_with_http_info(**kwargs)

        self.api_transmitters_retrieve = _Endpoint(
            settings={
                'response_type': (Transmitter,),
                'auth': [
                    'tokenAuth'
                ],
                'endpoint_path': '/api/transmitters/{transmitter_uuid}/',
                'operation_id': 'api_transmitters_retrieve',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'transmitter_uuid',
                ],
                'required': [
                    'transmitter_uuid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transmitter_uuid':
                        (str,),
                },
                'attribute_map': {
                    'transmitter_uuid': 'transmitter_uuid',
                },
                'location_map': {
                    'transmitter_uuid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__api_transmitters_retrieve
        )
