/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.nwdiag.legacy;

import java.util.LinkedHashMap;
import java.util.Map;
import net.sourceforge.plantuml.nwdiag.core.NServer;
import net.sourceforge.plantuml.nwdiag.core.Network;
import net.sourceforge.plantuml.nwdiag.legacy.NServerLegacy;
import net.sourceforge.plantuml.nwdiag.next.NStage;

public class NetworkLegacy
extends Network {
    private final Map<NServerLegacy, String> localServers = new LinkedHashMap<NServerLegacy, String>();
    private final int stage;

    @Override
    public String toString() {
        return super.toString() + "(" + this.stage + ")";
    }

    public NetworkLegacy(NStage nstage, String name, int stage) {
        super(null, nstage, name, new Object[0]);
        this.stage = stage;
    }

    public String getAdress(NServer server) {
        return this.localServers.get(server);
    }

    public void addServer(NServerLegacy server, Map<String, String> props) {
        String address = props.get("address");
        if (address == null) {
            address = "";
        }
        if (address.length() == 0 && this.localServers.containsKey(server)) {
            return;
        }
        this.localServers.put(server, address);
    }

    public boolean constainsLocally(String name) {
        for (NServerLegacy server : this.localServers.keySet()) {
            if (!server.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public final int getStage() {
        return this.stage;
    }
}

