/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.nwdiag.core;

import java.awt.geom.Dimension2D;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.nwdiag.core.NServer;
import net.sourceforge.plantuml.nwdiag.next.LinkedElementNext;
import net.sourceforge.plantuml.nwdiag.next.NBox;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorSet;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class NwGroup {
    public static final HColorSet colors = HColorSet.instance();
    private final Set<String> names = new HashSet<String>();
    private final String name;
    private HColor color;
    private String description;
    private NBox nbox;

    public NBox getNboxInternal() {
        if (this.nbox == null) {
            this.nbox = new NBox();
        }
        return this.nbox;
    }

    public final NBox getNbox(Map<String, ? extends NServer> servers) {
        if (this.nbox == null) {
            this.nbox = new NBox();
            for (Map.Entry<String, ? extends NServer> ent : servers.entrySet()) {
                if (!this.names.contains(ent.getKey())) continue;
                this.nbox.add(ent.getValue().getBar());
            }
        }
        return this.nbox;
    }

    public void addName(String name) {
        this.names.add(name);
    }

    public String toString() {
        return "NwGroup:" + this.name + " " + this.names + " " + this.nbox;
    }

    public NwGroup(String name, Object ... unused) {
        this.name = name;
    }

    public final String getName() {
        return this.name;
    }

    public final HColor getColor() {
        return this.color;
    }

    public final void setColor(HColor color) {
        this.color = color;
    }

    public final void setDescription(String value) {
        this.description = value;
    }

    public final FontConfiguration getGroupDescriptionFontConfiguration() {
        UFont font = UFont.serif(11);
        return new FontConfiguration(font, HColorUtils.BLACK, HColorUtils.BLACK, false);
    }

    protected final String getDescription() {
        return this.description;
    }

    public final Set<String> names() {
        return Collections.unmodifiableSet(this.names);
    }

    public boolean matches(LinkedElementNext tested) {
        return this.names().contains(tested.getElement().getName());
    }

    public boolean containsNext(NServer server) {
        return this.names.contains(server.getName());
    }

    public double getTopHeaderHeight(StringBounder stringBounder, ISkinParam skinParam) {
        TextBlock block = this.buildHeaderName(skinParam);
        if (block == null) {
            return 0.0;
        }
        Dimension2D blockDim = block.calculateDimension(stringBounder);
        return blockDim.getHeight();
    }

    public void drawGroup(UGraphic ug, MinMax size, ISkinParam skinParam) {
        HColor color;
        TextBlock block = this.buildHeaderName(skinParam);
        if (block != null) {
            Dimension2D blockDim = block.calculateDimension(ug.getStringBounder());
            double dy = size.getMinY() - blockDim.getHeight();
            size = size.addPoint(size.getMinX(), dy);
        }
        if ((color = this.getColor()) == null) {
            color = colors.getColorOrWhite(skinParam.getThemeStyle(), "#AAA");
        }
        size.draw(ug, color);
        if (block != null) {
            block.drawU(ug.apply(new UTranslate(size.getMinX() + 5.0, size.getMinY())));
        }
    }

    private TextBlock buildHeaderName(ISkinParam skinParam) {
        if (this.getDescription() == null) {
            return null;
        }
        return Display.getWithNewlines(this.getDescription()).create(this.getGroupDescriptionFontConfiguration(), HorizontalAlignment.LEFT, skinParam);
    }
}

